/* MAX44000 Ambient Light Sensor / Proximity Sensor Demo
 * This demonstrates some of the capabilities of the MAX44000.
 *
 * This is written to work with the ARD2PMD adapter board and
 * the MAX44000PMB1.  It uses the standard Arduino pin names
 * and it will compile for most arduino form-factor mbed boards.
 *
 * LED1 toggles when something is first detected by the proximity sensor.
 * LED2 indicates when the Ambient Light Sensor reads grater than alsLim.
 * LED3 will stay on whenever something is detected by the proximity sensor
 *   and stay on for an additional 5s after it is no longer detected.
 *
 * The following boards have been tested to work:
 *   MAX32600MBED
 *
 * Some boards use D13 for an LED signal, so this example uses the second
 *   row (row B, pins 7 through 12) of the Pmod connector.
 */

#include "mbed.h"
#include "ard2pmod.h"
#include "MAX44000.h"

MAX44000 max44000(D14, D15);
DigitalOut tog(LED1);
DigitalOut als(LED2);
DigitalOut dly(LED3);
DigitalIn pb3(D6);  // Set as input to remove load from PB3
DigitalIn pb4(D7);  // Set as input to remove load from PB4

const int alsLim = 0x0008;

int main()
{
    Ard2Pmod ard2pmod(Ard2Pmod::PMOD_TYPE_I2C_B);  // Configure ard2pmod multiplexer for I2C row B (bottom row)

    max44000.init(MAX44000::MODE_ALS_PROX, MAX44000::ALSTIM_64X, MAX44000::ALSPGA_1X, MAX44000::DRV_10);

    bool lastProx = false;
    int offDelay = 0;
    tog = false;
    als = false;
    dly = false;

    while (true) {
        wait (0.02);
        int alsData = max44000.readALS();
        int proxData = max44000.readReg(MAX44000::REG_PRX_DATA);

        als = (alsData < alsLim);

        if (proxData) {
            if (!lastProx) {
                tog = !tog;
            }
            lastProx = true;
            offDelay = 250;
            dly = false;
        } else {
            lastProx = false;
        }
        if (offDelay > 0) {
            offDelay -= 1;
        } else {
            dly = true;
        }
    }
}