/*******************************************************************************
 * Copyright(C) Maxim Integrated Products, Inc., All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files(the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of Maxim Integrated
 * Products, Inc.shall not be used except as stated in the Maxim Integrated
 * Products, Inc.Branding Policy.
 *
 * The mere transfer of this software does not imply any licenses
 * of trade secrets, proprietary technology, copyrights, patents,
 * trademarks, maskwork rights, or any other form of intellectual
 * property whatsoever. Maxim Integrated Products, Inc.retains all
 * ownership rights.
 *******************************************************************************
 */

#ifndef MAX41473_4_REGS_H_
#define MAX41473_4_REGS_H_

/**
 * @brief DEMOD Register
 *
 * Address : 0x00
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char demod_tctrl : 3;  /**< Demodulator Parameter#1
                                             Conditions / Recommended Value
                                             ASK_FSK_SEL=1 / 4 - CHF_SEL
                                             ASK_FSK_SEL=0, ATH_TYPE=0 / min(2+SRC_LG, 7)
                                             ASK_FSK_SEL=0, ATH_TYPE=1 / min(3+SRC_LG,7) */
        unsigned char demod_fsk   : 3;  /**< Demodulator Parameter#2 to be used only in FSK mode. Must be programmed
                                             according to the table of FSK Demodulator Configuration. */
        unsigned char rssi_dt     : 2;  /**< RSSI Peak Peak Detector Discharge Time
                                             0x0: 1/2 default value             0x2: 2x default value
                                             0x1: default value                 0x3: 4x default value */
    } bits;
} max41473_4_reg_demod_t;

/**
 * @brief AGC Register
 *
 * Address : 0x01
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char agc_en_bo : 2;    /**< AGC Operation Mode
                                             0x0: AGC disabled, max gain                0x2: AGC enabled
                                             0x1: AGC disabled, back off ADC buffer     0x3: AGC enabled, back off ADC buffer  */
        unsigned char agc_threl : 4;    /**< AGC-Release Threshold Fine Tune. Recommended value is 0x9 when data
                                             rate is lower than 52kbps, or 0xF when data rate is higher than 52kbps. */
        unsigned char           : 2;
    } bits;
} max41473_4_reg_agc_t;

/**
 * @brief IF_CGF_SEL Register
 *
 * Address : 0x02
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char chf_sel     : 3;  /**< Channel Filter Selection
                                             0x0: RXBW = 340kHz or 170kHz           0x4: RXBW = 12kHz or 6kHz
                                             0x1: RXBW = 120kHz or 60kHz            0x5: Invalid value
                                             0x2: RXBW = 52kHz or 26kHz             0x6: Invalid value
                                             0x3: RXBW = 24kHz or 12kHz             0x7: Invalid value */
        unsigned char if_sel      : 1;  /**< Intermediate Frequency Selection
                                             0x0: 400KHz            0x1: 200KHz  */
        unsigned char ask_fsk_sel : 1;  /**< ASK/FSK Selection
                                             0x0: ASK Demodulation          0x1: FSK Demodulation  */
        unsigned char             : 3;
    } bits;
} max41473_4_reg_if_chf_sel_t;

/**
 * @brief PDF_CFG Post Demodulation Filter Register
 *
 * Address : 0x03
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char src_sm : 3;   /**< "Small" adjustment to the Sample Rate Converter used to calculate the
                                         recommended data rate.
                                         See Configuration Guidance Tables and Recommended Data Rate Equation.
                                         0x0: Default rate              0x4: 8/12 Default
                                         0x1: 8/9 Default               0x5: 8/13 Default
                                         0x2: 8/10 Default              0x6: 8/14 Default
                                         0x3: 8/11 Default              0x7: 8/15 Default */
        unsigned char src_lg : 3;   /**< "Large" adjustment to the Sample Rate Converter used to calculate the
                                         recommended data rate.
                                         See Configuration Guidance Tables and Recommended Data Rate Equation.
                                         0x0: 4x Default                0x4: 1/4 Default
                                         0x1: 2x Default                0x5: 1/8 Default
                                         0x2: Default rate              0x6: 1/16 Default
                                         0x3: 1/2 Default               0x7: 1/32 Default*/
        unsigned char ld_bw  : 1;   /**< Post Demodulation Filter Bandwidth Control
                                         0x0: Default BW
                                         0x1: 1.67x Default BW */
        unsigned char ld_buf : 1;   /**< Output Buffer Selection. Low delay buffer can only be selected when
                                         (SRC_LG >= 3) or (SRC_LG = 2 and SRC_SM is even).
                                         0x0: Default Selection
                                         0x1: Low Delay Buffer */
    } bits;
} max41473_4_reg_pdf_cfg_t;

/**
 * @brief ATH_CFG1 ASK Threshold Configuration 1 Register
 *
 * Address : 0x04
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char ath_lb : 8;   /**< Parameter#1 for ASK Threshold Generation: lower bound of threshold
                                         in 8bit signed, two's complement format. Valid value from -128 to 0 */
    } bits;
} max41473_4_reg_ath_cfg1_t;

/**
 * @brief ATH_CFG2 ASK Threshold Configuration 2 Register
 *
 * Address : 0x05
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char ath_tc : 5;   /**< Parameter#2 for ASK Threshold Generation: to be programmed
                                         according to SRC_LG */
        unsigned char ath_dt : 2;   /**< Parameter#4 for ASK Threshold Generation: peak-hold time control in the
                                         "adaptive Peak Detector" (aPD) method
                                         0x0: Default discharge time, suggested for Manchester data, close to Rb
                                         0x1: 2x Discharge time, suggested for Manchester data, lower than Rb
                                         0x2: 4x Discharge time
                                         0x3: 8x Discharge time, suggested for NRZ data   */
        unsigned char        : 1;
    } bits;
} max41473_4_reg_ath_cfg2_t;

/**
 * @brief ATH_CFG3 ASK Threshold Configuration 3 Register
 *
 * Address : 0x06
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char ath_gc   : 5; /**< Parameter#3 for ASK Threshold Generation: to be programmed
                                         according to IF_SEL and CHF_SEL */
        unsigned char ath_bw   : 1; /**< Parameter#5 for ASK Threshold Generation: bandwidth control
                                         for precharged LPF(preLPF)
                                         0x0: Default bandwidth         0x1: 2x default */
        unsigned char ath_type : 1; /**< ASK Threshold Adjustment Method
                                         0x0: Precharged Low Pass Filter (preLPF)(Manchester)
                                         0x1: Adaptive Peak Detector (aPD)(NRZ) */
        unsigned char          : 1;
    } bits;
} max41473_4_reg_ath_cfg3_t;

/**
 * @brief AFC_CFG1 Register
 *
 * Address : 0x07
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char afc_lg : 2;   /**< AFC Loop Gain Control
                                         0x0: 1/4 Default           0x2: Default gain, FSK typical setting
                                         0x1: 1/2 Default           0x3: 2x Default, ASK typical setting */
        unsigned char afc_mo : 3;   /**< AFC Frequency Offset Limit
                                         0x0: AFC disabled          0x4: 4/7 Max offset
                                         0x1: 1/7 Max offset        0x5: 5/7 Max offset
                                         0x2: 2/7 Max offset        0x6: 6/7 Max offset
                                         0x3: 3/7 Max offset        x7: Max offset */
        unsigned char        : 3;
    } bits;
} max41473_4_reg_afc_cfg1_t;

/**
 * @brief AFC_CFG2 Register
 *
 * Address : 0x08
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char reserved       : 6;   /**< Reserved. Set to 0 */
        unsigned char pad_freeze_afc : 1;   /**< Control bit to Freeze AFC after Preamble Detected.
                                                 Not used in ASK mode.
                                                 0x0: Not to freeze AFC
                                                 0x1: Freeze AFC (stop PLL frequency update) once preamble is detected*/
        unsigned char                : 1;
    } bits;
} max41473_4_reg_afc_cfg2_t;

/**
 * @brief LO_CTR_FREQ3 Register
 *
 * Address : 0x09
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char lo_ctr_freq_23_to_16 : 8; /**< LO Center Frequency, Upper Byte of 24-bit Word */
    } bits;
} max41473_4_reg_lo_ctr_freq3_t;

/**
 * @brief LO_CTR_FREQ2 Register
 *
 * Address : 0x0A
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char lo_ctr_freq_15_to_8 : 8;  /**< LO Center Frequency, Middle Byte of 24-bit Word */
    } bits;
} max41473_4_reg_lo_ctr_freq2_t;

/**
 * @brief LO_CTR_FREQ1 Register
 *
 * Address : 0x0B
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char lo_ctr_freq_7_to_0 : 8;   /**< LO Center Frequency, Lower Byte of 24-bit Word */
    } bits;
} max41473_4_reg_lo_ctr_freq1_t;

/**
 * @brief PREAMBLE_CFG1 Register
 *
 * Address : 0x0C
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char preamb_len : 4;   /**< Preamble Bit Pattern Length before Manchester Coding
                                             Bit Pattern Length = Register Field Value +1 */
        unsigned char            : 4;
    } bits;
} max41473_4_reg_preamble_cfg1_t;

/**
 * @brief PREAMBLE_WORD1 Register
 *
 * Address : 0x0D
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char preamb_word_7_to_0 : 8;   /**< Lower Byte of the Preamble Bit Pattern before Manchester Coding */
    } bits;
} max41473_4_reg_preamble_word1_t;

/**
 * @brief PREAMBLE_WORD2 Register
 *
 * Address : 0x0E
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char preamb_word_15_to_8 : 8;  /**< Upper Byte of the Preamble Bit Pattern before Manchester Coding */
    } bits;
} max41473_4_reg_preamble_word2_t;

/**
 * @brief RSSI Register
 *
 * Address : 0x10
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char rssi : 8; /**< Received Signal Strength Indicator (RSSI)
                                     8-bit unsigned integer */
    } bits;
} max41473_4_reg_rssi_t;

/**
 * @brief FEI Register
 *
 * Address : 0x11
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char fei : 8;  /**< AFC Frequency Error Indicator (FEI)
                                     8-bit signed integer in two's complement format */
    } bits;
} max41473_4_reg_fei_t;

/**
 * @brief PDF_OUT Register
 *
 * Address : 0x12
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char pdf_out : 8;  /**< Post Demodulation Filter (PDF) Read Out
                                         8-bit signed integer in two's complement format */
    } bits;
} max41473_4_reg_pdf_out_t;

/**
 * @brief ISR Register
 *
 * Address : 0x13
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char preamb_det : 1;   /**< Interreupt Status Register Bit0: preamble detector in self-polling mode
                                             0x0: No interrupt event        0x1: Preamble detected in self-polling*/
        unsigned char            : 7;
    } bits;
} max41473_4_reg_isr_t;

/**
 * @brief CDR_CFG1 Register
 *
 * Address : 0x35
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char cdr_mode : 2; /**< Clock Data Recovery configuration register
                                         0x0: CDR disabled                          0x2: Clock out disabled, DATAOUT retimed
                                         0x1: Clock out enabled, DATAOUT untimed    0x3: Clock out enabled,  DATAOUT retimed */
        unsigned char          : 6;
    } bits;
} max41473_4_reg_cdr_cfg1_t;

/**
 * @brief STATE_CTRL1 Register
 *
 * Address : 0x14
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char slave_rx_en : 1;  /**< Slave Receiver Enable bit
                                             0x0 Disable Receiver       0x1 Enable Receiver */
        unsigned char wut_en      : 1;  /**< Wake Up Timer (WUT) Enable bit
                                             0x0: Disable WUT           0x1: Enable WUT */
        unsigned char en_xo       : 1;  /**< XO Enable Bit
                                             0x0: Disable XO            0x1: Enebale XO */
        unsigned char             : 5;
    } bits;
} max41473_4_reg_state_ctrl1_t;

/**
 * @brief STATE_CTRL2 Register
 *
 * Address : 0x15
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char rx_state : 2; /**< Receiver State Machine Register
                                         0x0: Standby                   0x2: Wait in Self-Polling
                                         0x1: Slave Receiver            0x3: Polling Receiver */
        unsigned char          : 6;
    } bits;
} max41473_4_reg_state_ctrl2_t;

/**
 * @brief STATE_CTRL3 Register
 *
 * Address : 0x16
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char rx_reset_time : 2;    /**< Receiver Front-End Turn-On Time
                                                 0x0: 0.08 ms           0x2: 0.24 ms
                                                 0x1: 0.16 ms           0x3: 0.32 ms */
        unsigned char               : 6;
    } bits;
} max41473_4_reg_state_ctrl3_t;

/**
 * @brief WUT1 Register
 *
 * Address : 0x17
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char tdet : 8; /**< Duration in POLLINGRX State: from 0.48ms to 20.88ms, in step size of 0.08ms
                                     Duration (ms) = 0.48 + 0.08 x (Register Field Value) */
    } bits;
} max41473_4_reg_wut1_t;

/**
 * @brief WUT2 Register
 *
 * Address : 0x18
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char tsby_tdet_ratio : 7;  /**< WUT Duty Cycle Control
                                                 Duty Cycle = 1 / (2 + Register Field Value) */
        unsigned char                 : 1;
    } bits;
} max41473_4_reg_wut2_t;

/**
 * @brief AFE_CTL1 Register
 *
 * Address : 0x19
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char fracmode     : 1; /**< PLL Mode Control: always program to 1
                                             0x0: Integer-N PLL         0x1: Fractional-N PLL  */
        unsigned char lodiv        : 2; /**< LO Divider Control
                                             0x0: Disabled              0x2: 425MHz to 480MHz
                                             0x1: 860MHz to 960MHz      0x3: 286MHz to 320MHz */
        unsigned char mix_hs_lsbar : 1; /**< LO Injection Control.
                                             0x0: Targeted RF frequency higher than LO frequency
                                             0x1: Targeted RF frequency lower than LO frequency */
        unsigned char xoclkdiv     : 2; /**< XO Clock Divider Ratio
                                             0x0: divide by 4           0x2: divide by 6
                                             0x1: divide by 5           0x3: invalid value */
        unsigned char xoclkdelay   : 2; /**< Start Delay before Applying XO Clock to Digital
                                             0x0: No delay.             0x2: 32 cycle delay
                                             0x1: 16 cycle delay        0x3: 64 cycle delay */
    } bits;
} max41473_4_reg_afe_ctl1_t;

/**
 * @brief IR_ADJUST Register
 *
 * Address : 0x1A
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char ir_adjust : 5 /**< Image Rejection Adjustment. See the Image Rejection Calibration section
                                         for more information*/;
        unsigned char           : 3;
    } bits;
} max41473_4_reg_ir_adjust_t;

/**
 * @brief PART_NUM Register
 *
 * Address : 0x1E
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char part_num : 8; /**< Part Number Designator. Read of part number requires EN_XO = 1
                                         0x70 = MAX41470
                                         0x73 = MAX41473
                                         0x74 = MAX41474 */
    } bits;
} max41473_4_reg_part_num_t;

/**
 * @brief REV_NUM Register
 *
 * Address : 0x1F
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char rev_num : 3;  /**< Revision Number of chip */
        unsigned char         : 5;
    } bits;
} max41473_4_reg_rev_num_t;

/**
 * @brief STATUS Register
 *
 * Address : 0x27
 */
typedef union {
    unsigned char raw;
    struct {
        unsigned char pll_lock : 1; /**< PLL Lock Status
                                         0x0: PLL is not locked     0x1: PLL is locked */
        unsigned char reserved : 1; /**< Reserved */
        unsigned char          : 6;
    } bits;
} max41473_4_reg_status_t;

/**
 * @brief Register Set
 *
 *
 */
typedef struct {
    max41473_4_reg_demod_t          reg_demod;
    max41473_4_reg_agc_t            reg_agc;
    max41473_4_reg_if_chf_sel_t     reg_if_chf_sel;
    max41473_4_reg_pdf_cfg_t        reg_pdf_cfg;
    max41473_4_reg_ath_cfg1_t       reg_ath_cfg1;
    max41473_4_reg_ath_cfg2_t       reg_ath_cfg2;
    max41473_4_reg_ath_cfg3_t       reg_ath_cfg3;
    max41473_4_reg_afc_cfg1_t       reg_afc_cfg1;
    max41473_4_reg_afc_cfg2_t       reg_afc_cfg2;
    max41473_4_reg_lo_ctr_freq3_t   reg_lo_ctr_freq3;
    max41473_4_reg_lo_ctr_freq2_t   reg_lo_ctr_freq2;
    max41473_4_reg_lo_ctr_freq1_t   reg_lo_ctr_freq1;
    max41473_4_reg_preamble_cfg1_t  reg_preamble_cfg1;
    max41473_4_reg_preamble_word1_t reg_preamble_word1;
    max41473_4_reg_preamble_word2_t reg_preamble_word2;
    max41473_4_reg_rssi_t           reg_rssi;
    max41473_4_reg_fei_t            reg_fei;
    max41473_4_reg_pdf_out_t        reg_pdf_out;
    max41473_4_reg_isr_t            reg_isr;
    max41473_4_reg_cdr_cfg1_t       reg_cdr_cfg1;
    max41473_4_reg_state_ctrl1_t    reg_state_ctrl1;
    max41473_4_reg_state_ctrl2_t    reg_state_ctrl2;
    max41473_4_reg_state_ctrl3_t    reg_state_ctrl3;
    max41473_4_reg_wut1_t           reg_wut1;
    max41473_4_reg_wut2_t           reg_wut2;
    max41473_4_reg_afe_ctl1_t       reg_afe_ctl1;
    max41473_4_reg_ir_adjust_t      reg_ir_adjust;
    max41473_4_reg_part_num_t       reg_part_num;
    max41473_4_reg_rev_num_t        reg_rev_num;
    max41473_4_reg_status_t         reg_status;
} max41473_4_reg_map_t;

#endif /* MAX41473_4_REGS_H_ */
