#include "mbed.h"
#include "MAX30205.h"
#include "max32630hsp.h"

//PC serial connection:
Serial pc(USBTX,USBRX);

//Enable pin to convert 3V3 to 3V for MAX30205:
DigitalOut max30205_LDO_EN(P7_1,1);

//Board Initializations: (This also initializes PMIC)
MAX32630HSP icarus(MAX32630HSP::VIO_3V3);

//Get I2C instance
I2C i2cBus(I2C1_SDA, I2C1_SCL);

//Get temp sensor instance
MAX30205 bodyTempSensor(i2cBus, (0x90 >> 1));

int main(void)
{
    //use sensor
    uint16_t TemperatureValue;
    uint32_t ExpandTemperatureValue=0;
    float Celsius;

    while(1)
    {
        if(!bodyTempSensor.readTemperature(TemperatureValue))
        {
            ExpandTemperatureValue = (uint32_t)TemperatureValue;
            Celsius = bodyTempSensor.toCelsius(ExpandTemperatureValue);
            pc.printf("The temperature is %f Celsius\r\n",Celsius);
        }
        wait(0.5);
    }
}
