/*******************************************************************************
* Copyright (C) 2019 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/
#include "mbed.h"
#include "max32630fthr.h"
#include "max31875.h"
#include "max31875_cpp.h"
#include "USBSerial.h"
 
MAX32630FTHR pegasus(MAX32630FTHR::VIO_1V8); 
 
DigitalOut rLED(LED1);
DigitalOut gLED(LED2);
DigitalOut bLED(LED3);
 
I2C i2cBus(P3_4, P3_5);

// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)
/**
* @brief Sample main program for MAX31875
* @version 1.0000.0003
*
* @details Sample main program for MAX31875
* The prints are sent to the terminal window (9600, 8n1).
* The program sets the GPIOs to 1.8V and the program
* configures the chip and reads temperatures.
* To run the program, drag and drop the .bin file into the 
* DAPLINK folder. After it finishes flashing, cycle the power or 
* reset the Pegasus (MAX32630FTHR) after flashing by pressing the button on
* the Pegasus next to the battery connector or the button
* on the MAXREFDES100HDK.
*/
int main()
{
    uint32_t i;
    float temperature;
    uint16_t cfg;
    DigitalOut rLED(LED1, LED_OFF);
    DigitalOut gLED(LED2, LED_OFF);
    DigitalOut bLED(LED3, LED_OFF);
    gLED = LED_ON;
    printf("MAX31875 Small Package Temperature Sensor example source code.\r\n");
    printf("\r\n");

    MAX31875 temp_sensor(i2cBus, MAX31875_I2C_SLAVE_ADR_R0);
    i2cBus.frequency(1000000);
   
    /* Configure for fault filter 1, comparator, continuous,
     * normal format, 8 sps, 12 bit resolution
     */
    temp_sensor.write_cfg(uint16_t(MAX31875_CFG_FAULT_FILTER_1 | 
        MAX31875_CFG_COMPARATOR_MODE | MAX31875_CFG_CONTINUOUS | 
        MAX31875_CFG_NORMAL_FORMAT | MAX31875_CFG_CONV_RATE_8 | 
        MAX31875_CFG_RESOLUTION_12BIT));

    for (i = 0; i < 10; i++) {
        wait(MAX31875_WAIT_CONV_RATE_8);
        temperature = temp_sensor.read_reg_as_temperature(MAX31875_REG_TEMPERATURE);
        printf("Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, temp_sensor.celsius_to_fahrenheit(temperature));
    }
    temp_sensor.read_reg(&cfg, MAX31875_REG_CONFIGURATION);
    printf("Configuration Register = 0x%04Xh \r\n", cfg);
#if 0
    temp_sensor.write_trip_low(-63.9375);
    wait(0.03);
    temperature = temp_sensor.read_reg_as_temperature(MAX31875_REG_THYST_LOW_TRIP);
    printf("Thyst Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, temp_sensor.celsius_to_fahrenheit(temperature));

    temp_sensor.write_trip_high(64.0625f);
    wait(0.03);
    temperature = temp_sensor.read_reg_as_temperature(MAX31875_REG_TOS_HIGH_TRIP);
    printf("TOS Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, temp_sensor.celsius_to_fahrenheit(temperature));
    printf("\r\n\r\n");
#endif

    printf("\r\n");

    /* Configure for fault filter 4, interrupt, shutdown,
     * extended format, 0.25 sps, 10 bit resolution, start one-shot
     */
    for (i = 0; i < 2; i++) {
        temp_sensor.write_cfg(uint16_t(MAX31875_CFG_FAULT_FILTER_4 | 
            MAX31875_CFG_INTERRUPT_MODE | MAX31875_CFG_SHUTDOWN |
            MAX31875_CFG_EXTENDED_FORMAT| MAX31875_CFG_CONV_RATE_0_25 | 
            MAX31875_CFG_RESOLUTION_10BIT | MAX31875_CFG_ONE_SHOT_START));
        wait(MAX31875_WAIT_CONV_RATE_0_25);
        temperature = temp_sensor.read_reg_as_temperature(MAX31875_REG_TEMPERATURE);
        printf("Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, temp_sensor.celsius_to_fahrenheit(temperature));
    }
    temp_sensor.read_reg(&cfg, MAX31875_REG_CONFIGURATION);
    printf("Configuration Register = 0x%04Xh \r\n", cfg);

    printf("\r\n\r\n");

#if 0
    temp_sensor.write_trip_low(-127.9375);
    wait(0.03);
    temp_sensor.read_reg(&cfg, MAX31875_REG_CONFIGURATION);
    temperature = temp_sensor.read_reg_as_temperature(MAX31875_REG_THYST_LOW_TRIP);
    printf("Thyst Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, temp_sensor.celsius_to_fahrenheit(temperature));

    temp_sensor.write_trip_high(129.0625f);
    wait(0.03);
    temperature = temp_sensor.read_reg_as_temperature(MAX31875_REG_TOS_HIGH_TRIP);
    printf("TOS Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, temp_sensor.celsius_to_fahrenheit(temperature));
    printf("\r\n\r\n");
#endif

    /***************************************************************************
     * Call the C code version of the driver
     ***************************************************************************
     */
#include "max31875_c.h"
    printf("C implementation of the code\r\n");
    max31875_init(MAX31875_I2C_SLAVE_ADR_R0);
    /* Configure for fault filter 1, comparator, continuous,
     * normal format, 8 sps, 12 bit resolution
     */
    max31875_write_cfg(uint16_t(MAX31875_CFG_FAULT_FILTER_1 | 
        MAX31875_CFG_COMPARATOR_MODE | MAX31875_CFG_CONTINUOUS | 
        MAX31875_CFG_NORMAL_FORMAT | MAX31875_CFG_CONV_RATE_8 | 
        MAX31875_CFG_RESOLUTION_12BIT), i2cBus);
    for (i = 0; i < 10; i++) {
        wait(MAX31875_WAIT_CONV_RATE_8);
        temperature = max31875_read_reg_as_temperature(MAX31875_REG_TEMPERATURE,
            i2cBus);
        printf("Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, temp_sensor.celsius_to_fahrenheit(temperature));
    }
    max31875_read_reg(&cfg, MAX31875_REG_CONFIGURATION, i2cBus);
    printf("Configuration Register = 0x%04Xh \r\n", cfg);

#if 0
    max31875_write_trip_low(-63.9375, i2cBus);
    wait(0.03);
    temperature = max31875_read_reg_as_temperature(MAX31875_REG_THYST_LOW_TRIP, i2cBus);
    printf("Thyst Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, max31875_celsius_to_fahrenheit(temperature));

    max31875_write_trip_high(64.0625f, i2cBus);
    wait(0.03);
    temperature = max31875_read_reg_as_temperature(MAX31875_REG_TOS_HIGH_TRIP, i2cBus);
    printf("TOS Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, max31875_celsius_to_fahrenheit(temperature));
#endif

    printf("\r\n");
    for (i = 0; i < 2; i++) {
        max31875_write_cfg(uint16_t(MAX31875_CFG_FAULT_FILTER_4 | 
            MAX31875_CFG_INTERRUPT_MODE | MAX31875_CFG_SHUTDOWN |
            MAX31875_CFG_EXTENDED_FORMAT| MAX31875_CFG_CONV_RATE_0_25 | 
            MAX31875_CFG_RESOLUTION_10BIT | MAX31875_CFG_ONE_SHOT_START),
            i2cBus);
        wait(MAX31875_WAIT_CONV_RATE_0_25);
        temperature = max31875_read_reg_as_temperature(MAX31875_REG_TEMPERATURE,
            i2cBus);
        printf("Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, temp_sensor.celsius_to_fahrenheit(temperature));
    }
    max31875_read_reg(&cfg, MAX31875_REG_CONFIGURATION, i2cBus);
    printf("Configuration Register = 0x%04Xh \r\n", cfg);

#if 0
    temp_sensor.write_trip_low(-127.9375);
    max31875_write_trip_low(-127.9375, i2cBus);
    wait(0.03);
    temperature = max31875_read_reg_as_temperature(MAX31875_REG_THYST_LOW_TRIP, i2cBus);
    printf("Thyst Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, max31875_celsius_to_fahrenheit(temperature));

    max31875_write_trip_high(129.0625f, i2cBus);
    wait(0.03);
    temperature = max31875_read_reg_as_temperature(MAX31875_REG_TOS_HIGH_TRIP, i2cBus);
    printf("TOS Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, max31875_celsius_to_fahrenheit(temperature));
#endif
    printf("\r\n\r\n\r\n");


    while (true) {  // Blink the green LED 
        gLED = !gLED;
        wait(0.5);
    }
}
 
 