/*******************************************************************************
 * Copyright (C) 2019 Maxim Integrated Products, Inc., All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of Maxim Integrated
 * Products, Inc. shall not be used except as stated in the Maxim Integrated
 * Products, Inc. Branding Policy.
 *
 * The mere transfer of this software does not imply any licenses
 * of trade secrets, proprietary technology, copyrights, patents,
 * trademarks, maskwork rights, or any other form of intellectual
 * property whatsoever. Maxim Integrated Products, Inc. retains all
 * ownership rights.
 *******************************************************************************
 */
#include "mbed.h"
#include "max32630fthr.h"
#include "max31723.h"
#include "USBSerial.h"

MAX32630FTHR pegasus(MAX32630FTHR::VIO_1V8);  /* Pegasus, MAX31723: use 1.8V */

DigitalOut rLED(LED1);
DigitalOut gLED(LED2);
DigitalOut bLED(LED3);

DigitalOut selectPin(P3_0);  /* Pin 3_0 is used to drive chip enable low */
SPI spi(P5_1, P5_2, P5_0);  /* mosi, miso, sclk */

   
/** main() runs in its own thread in the OS */
/** (note the calls to Thread::wait below for delays) */
/**
 * @brief Sample main program for Maxim Integrated MAX31723
 * @version 1.0000.0002
 *
 * @details Sample main program for MAX31723/MAX31722
 * The prints are sent to the terminal window (9600, 8n1).
 * The program configures the SPI buss and then it performs
 * 5 one shot readings.
 * The program then blinks the green LED.
 * To run the program, drag and drop the .bin file into the 
 * DAPLINK folder. After it finishes flashing, cycle the power or 
 * reset the Pegasus (MAX32630FTHR) after flashing by pressing the button on
 * the Pegasus next to the battery connector or the button
 * on the MAXREFDES100HDK.
 */
 

int main()
{
    int ret, i;
    float temperature;
    uint8_t value;
    DigitalOut rLED(LED1, LED_OFF);
    DigitalOut gLED(LED2, LED_OFF);
    DigitalOut bLED(LED3, LED_OFF);
    
    gLED = LED_ON;

    MAX31723 max31723_temp(spi, selectPin);
    spi.format(8,3);  /* 8-bit, SPI mode 3 */
    spi.frequency(5000000);  /* Use 5 MHz SPI bus */
    /* Jumpers (JP1) on MAX31723PMB should be set to SPI mode configuration
     * or SERMODE pin should be set to VDD for SPI mode
     */
    ret = max31723_temp.perform_one_shot_int(MAX31723_CFG_RESOLUTION_12BIT);
    
    for (i = 0; i < 5; i++) {
        ret = max31723_temp.perform_one_shot_int(MAX31723_CFG_RESOLUTION_12BIT);
        wait(MAX31723_CONV_TIME_MSEC_12BIT);
        temperature = max31723_temp.read_reg_as_temperature(MAX31723_REG_TEMP_LSB);
        printf("Temperature = %4.4f Celsius, %4.4f Fahrenheit\r\n", 
            temperature, max31723_temp.celsius_to_fahrenheit(temperature));
        wait(2);
    } 
    printf("Configuration Register = 0x%02Xh \r\n", max31723_temp.read_cfg());

    printf("\r\n");

    while (true) {  // Blink the green LED 
        gLED = !gLED;
        wait(1.0);
    }
}
