/*******************************************************************************
* Copyright (C) 2018 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/
#include "mbed.h"
#include "max32630fthr.h"
#include "max30205.h"
#include "max30205_cpp.h"
#include "max30205_c.h"
#include "USBSerial.h"

Serial pc(USBTX, USBRX);          // Use USB debug probe for serial link
Serial uart(P2_1, P2_0);
void wait_sec_prompt(uint8_t time)
{
   // Ports and serial connections
    uint32_t i;
    for (i = 0; i < time; i++) {
        pc.printf(".");
        wait(1);
    }
    pc.printf("\r\n");
}


MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3); 
 
DigitalOut rLED(LED1);
DigitalOut gLED(LED2);
DigitalOut bLED(LED3);
 
I2C i2cBus(P3_4, P3_5);

// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)

/**
* @brief Sample main program for MAX30205
* @version 1.0001.0
*
* @details Sample main program for MAX30205.
* The prints are sent to the terminal window (9600, 8n1).
* The temperature is read in continous mode, then in shutdown mode for
* C++ and C calls.
* To run the program, drag and drop the .bin file into the 
* DAPLINK folder. After it finishes flashing, cycle the power or 
* reset the Pegasus after flashing by pressing the button on
* the Pegasus next to the battery connector or the button
* on the MAXREFDES100HDK.
*/

int main()
{
    uint32_t i;
    float temperature;
    uint8_t cfg;
    DigitalOut rLED(LED1, LED_OFF);
    DigitalOut gLED(LED2, LED_OFF);
    DigitalOut bLED(LED3, LED_OFF);
    gLED = LED_ON;
    pc.baud(9600);                    // Baud rate = 115200
    pc.printf("MAX30205 Clinical Temperature Sensor"
              " example source code.\r\n");
    pc.printf("\r\n");
    uint8_t i2c_addr = MAX30205_I2C_SLAVE_ADR_00;
    uint8_t wait_shut = 60;
    MAX30205 temp_sensor(i2cBus, i2c_addr);
    i2cBus.frequency(400000);
    /* Configure for time out enabled, normal format, fault filter 6,
       active low polarity, comparator mode, continuous
     */
    temp_sensor.write_cfg_reg(uint8_t(MAX30205_CFG_TIMEOUT_ENABLE |
        MAX30205_CFG_NORMAL_FORMAT| MAX30205_CFG_FAULT_FILTER_6 |
        MAX30205_CFG_OS_POLARITY_ACT_LOW | MAX30205_CFG_COMPARATOR_MODE |
        MAX30205_CFG_CONTINUOUS));
    for (i = 0; i < 5; i++) {
        wait(MAX30205_WAIT_CONV_TIME);
        temperature =
            temp_sensor.read_reg_as_temperature(MAX30205_REG_TEMPERATURE);
        pc.printf("Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, temp_sensor.celsius_to_fahrenheit(temperature));
    }
    temp_sensor.read_cfg_reg(&cfg);
    pc.printf("Configuration Register = 0x%02Xh \r\n", cfg);
#if 0
    temp_sensor.write_trip_low_thyst(-63.9375);
    temperature =
        temp_sensor.read_reg_as_temperature(MAX30205_REG_THYST_LOW_TRIP);
    pc.printf("Thyst Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, temp_sensor.celsius_to_fahrenheit(temperature));

    temp_sensor.write_trip_high_tos(64.0625f);
    temperature = temp_sensor.read_reg_as_temperature(MAX30205_REG_TOS_HIGH_TRIP);
    pc.printf("TOS Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, temp_sensor.celsius_to_fahrenheit(temperature));
    pc.printf("\r\n\r\n");
#endif

    pc.printf("\r\n");
    temp_sensor.write_cfg_reg(uint8_t(MAX30205_CFG_ONE_SHOT_START |
        MAX30205_CFG_TIMEOUT_DISABLE | MAX30205_CFG_EXTENDED_FORMAT |
        MAX30205_CFG_FAULT_FILTER_4 | MAX30205_CFG_OS_POLARITY_ACT_LOW |
        MAX30205_CFG_COMPARATOR_MODE | MAX30205_CFG_SHUTDOWN));
    for (i = 0; i < 8; i++) {
        wait_sec_prompt(wait_shut); /*  leave it in shutdown mode for a while */
        /* Configure for one shot, time out disabled, extended format, fault filter 4,
           active low polarity, comparator mode, shutdown
         */
        temp_sensor.write_cfg_reg(uint8_t(MAX30205_CFG_ONE_SHOT_START |
            MAX30205_CFG_TIMEOUT_DISABLE | MAX30205_CFG_EXTENDED_FORMAT |
            MAX30205_CFG_FAULT_FILTER_4 | MAX30205_CFG_OS_POLARITY_ACT_LOW |
            MAX30205_CFG_COMPARATOR_MODE | MAX30205_CFG_SHUTDOWN));
        wait(MAX30205_WAIT_CONV_TIME);
        temperature =
            temp_sensor.read_reg_as_temperature(MAX30205_REG_TEMPERATURE);
        pc.printf("Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, temp_sensor.celsius_to_fahrenheit(temperature));
    }
    temp_sensor.read_cfg_reg(&cfg);
    pc.printf("Configuration Register = 0x%02Xh \r\n", cfg);

    pc.printf("\r\n\r\n");

#if 0
    temp_sensor.write_trip_low_thyst(-55.0f);
    temperature = 
        temp_sensor.read_reg_as_temperature(MAX30205_REG_THYST_LOW_TRIP);
    pc.printf("Thyst Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, temp_sensor.celsius_to_fahrenheit(temperature));

    temp_sensor.write_trip_high_tos(125.0f);
    temperature = temp_sensor.read_reg_as_temperature(MAX30205_REG_TOS_HIGH_TRIP);
    pc.printf("TOS Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, temp_sensor.celsius_to_fahrenheit(temperature));
    pc.printf("\r\n\r\n");
#endif

    /***************************************************************************
     * Call the C code version of the driver
     ***************************************************************************
     */
#include "max30205_c.h"
    pc.printf("C implementation of the code\r\n");
    max30205_init(i2c_addr);
    /* Configure for time out enabled, normal format, fault filter 6,
       active low polarity, comparator mode, continuous
     */
    max30205_write_cfg_reg(uint8_t(MAX30205_CFG_TIMEOUT_ENABLE |
        MAX30205_CFG_NORMAL_FORMAT | MAX30205_CFG_FAULT_FILTER_6 |
        MAX30205_CFG_OS_POLARITY_ACT_LOW | MAX30205_CFG_COMPARATOR_MODE |
        MAX30205_CFG_CONTINUOUS), i2cBus);
    for (i = 0; i < 5; i++) {
        wait(MAX30205_WAIT_CONV_TIME);
        temperature = max30205_read_reg_as_temperature(MAX30205_REG_TEMPERATURE,
            i2cBus);
        pc.printf("Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, temp_sensor.celsius_to_fahrenheit(temperature));
    }

    max30205_read_cfg_reg(&cfg, i2cBus);
    pc.printf("Configuration Register = 0x%02Xh \r\n", cfg);

#if 0
    max30205_write_trip_low_thyst(-63.9375, i2cBus);
    temperature = max30205_read_reg_as_temperature(MAX30205_REG_THYST_LOW_TRIP,
        i2cBus);
    pc.printf("Thyst Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, max30205_celsius_to_fahrenheit(temperature));

    max30205_write_trip_high_tos(64.0625f, i2cBus);
    temperature = max30205_read_reg_as_temperature(MAX30205_REG_TOS_HIGH_TRIP,
        i2cBus);
    pc.printf("TOS Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, max30205_celsius_to_fahrenheit(temperature));
#endif

    pc.printf("\r\n");
    max30205_write_cfg_reg(uint8_t(MAX30205_CFG_ONE_SHOT_START |
        MAX30205_CFG_TIMEOUT_DISABLE | MAX30205_CFG_EXTENDED_FORMAT |
        MAX30205_CFG_FAULT_FILTER_4 | MAX30205_CFG_OS_POLARITY_ACT_LOW |
        MAX30205_CFG_COMPARATOR_MODE | MAX30205_CFG_SHUTDOWN), i2cBus);
    for (i = 0; i < 8; i++) {
        wait_sec_prompt(wait_shut); /*  leave it in shutdown mode for a while */
        /* Configure for one shot, time out disabled, extended format, fault filter 4,
           active low polarity, comparator mode, shutdown
         */
        max30205_write_cfg_reg(uint8_t(MAX30205_CFG_ONE_SHOT_START |
            MAX30205_CFG_TIMEOUT_DISABLE | MAX30205_CFG_EXTENDED_FORMAT |
            MAX30205_CFG_FAULT_FILTER_4 | MAX30205_CFG_OS_POLARITY_ACT_LOW |
            MAX30205_CFG_COMPARATOR_MODE | MAX30205_CFG_SHUTDOWN), i2cBus);
        wait(MAX30205_WAIT_CONV_TIME);
        temperature = max30205_read_reg_as_temperature(MAX30205_REG_TEMPERATURE,
            i2cBus);
        pc.printf("Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, temp_sensor.celsius_to_fahrenheit(temperature));
    }
    max30205_read_cfg_reg(&cfg, i2cBus);
    pc.printf("Configuration Register = 0x%02Xh \r\n", cfg);

#if 0
    max30205_write_trip_low_thyst(-55, i2cBus);
    temperature = max30205_read_reg_as_temperature(MAX30205_REG_THYST_LOW_TRIP,
        i2cBus);
    pc.printf("Thyst Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, max30205_celsius_to_fahrenheit(temperature));

    max30205_write_trip_high_tos(125.0f, i2cBus);
    temperature = max30205_read_reg_as_temperature(MAX30205_REG_TOS_HIGH_TRIP,
        i2cBus);
    pc.printf("TOS Temperature = %3.4f Celsius, %3.4f Fahrenheit\r\n", 
            temperature, max30205_celsius_to_fahrenheit(temperature));
#endif
    pc.printf("\r\n\r\n\r\n");


    while (true) {  // Blink the green LED 
        gLED = !gLED;
        wait(0.5);
    }
}
 
 