/*******************************************************************************
 * Copyright (C) 2017 Maxim Integrated Products, Inc., All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of Maxim Integrated
 * Products, Inc. shall not be used except as stated in the Maxim Integrated
 * Products, Inc. Branding Policy.
 *
 * The mere transfer of this software does not imply any licenses
 * of trade secrets, proprietary technology, copyrights, patents,
 * trademarks, maskwork rights, or any other form of intellectual
 * property whatsoever. Maxim Integrated Products, Inc. retains all
 * ownership rights.
 *******************************************************************************
 */
 
 
#include "MAX30101.h"


//*****************************************************************************
MAX30101::MAX30101(PinName sda, PinName scl):
m_i2cBus(sda, scl)
{
    //empty block
}


//*****************************************************************************
MAX30101::MAX30101(I2C &i2c):
m_i2cBus(i2c)
{
    //empty block
}


//*****************************************************************************
MAX30101::~MAX30101()
{
    //empty block
}


//*****************************************************************************
int32_t MAX30101::enableInterrupts(const InterruptBitField_u data)
{
    char cmdData[3] = {InterruptEnable1, (data.all & 0xF0), (data.all & 0x02)};
    
    return m_i2cBus.write(I2C_W_ADRS, cmdData, 3);
}


//*****************************************************************************
int32_t MAX30101::getInterruptStatus(InterruptBitField_u &data)
{
    char local_data[3];
    local_data[0] = InterruptStatus1;
    
    int32_t result = m_i2cBus.write(I2C_W_ADRS, local_data, 1);
    if(result == 0)
    {
        result = m_i2cBus.read(I2C_R_ADRS, (local_data + 1), 2);
        if(result == 0)
        {
            data.all = local_data[1] + local_data[2];
        }
    }
    
    return result;
}


//*****************************************************************************
int32_t MAX30101::setFIFOConfiguration(const FIFO_Configuration_u config)
{
    return -1;
}
    

//*****************************************************************************
int32_t MAX30101::getFIFOConfiguration(FIFO_Configuration_u &config)
{
    return -1;
}
    
    
//*****************************************************************************
int32_t MAX30101::setModeConfiguration(const ModeConfiguration_u config)
{
    return -1;
}
    

//*****************************************************************************    
int32_t MAX30101::getModeConfiguration(ModeConfiguration_u &config)
{
    return -1;
}   
    

//*****************************************************************************    
int32_t MAX30101::setSpO2Configuration(const SpO2Configuration_u config)
{
    return -1;
}   


//*****************************************************************************    
int32_t MAX30101::getSpO2Configuration(SpO2Configuration_u &config)
{
    return -1;
}


//*****************************************************************************  
int32_t MAX30101::setLEDPulseAmplitude(Registers_e reg, const uint8_t amp)
{
    return -1;
}


//*****************************************************************************  
int32_t MAX30101::getLEDPulseAmplitude(Registers_e reg, uint8_t &amp)
{
    return -1;
}


//*****************************************************************************  
int32_t MAX30101::setMultiLEDModeControl(Registers_e reg, const ModeControlReg_u data)
{
    return -1;
}
 
    
//*****************************************************************************  
int32_t MAX30101::getMultiLEDModeControl(Registers_e reg, ModeControlReg_u &data)
{
    return -1;
}

    
//*****************************************************************************  
int32_t MAX30101::getDieTemperature(uint16_t &data)
{
    return -1;
}

    
//*****************************************************************************  
int32_t MAX30101::getDieTemperatureC(float &data)
{
    return -1;
}


//*****************************************************************************  
float MAX30101::celsius2fahrenheit(float c) 
{
    return 0.0F;
}
    

//*****************************************************************************     
int32_t MAX30101::setProxIntThreshold(const uint8_t data)
{
    return -1;
}
    

//*****************************************************************************     
int32_t MAX30101::getProxIntThreshold(uint8_t &data)
{
    return -1;
}


//*****************************************************************************
int32_t MAX30101::writeRegister(Registers_e reg, uint8_t value)
{
    char local_data[2] = {reg, value};

    return m_i2cBus.write(I2C_W_ADRS, local_data, 2);
}


//*****************************************************************************
int32_t MAX30101::readRegister(Registers_e reg, uint8_t &value)
{
    int32_t result;
    
    char local_data[2];
    local_data[0] = reg;

    result = m_i2cBus.write(I2C_W_ADRS, local_data, 1);
    if(result == 0) 
    {
        result = m_i2cBus.read(I2C_R_ADRS, (local_data + 1), 1);
        if (result == 0) 
        {
            value = local_data[1];
        }
    }

    return result;
}

