/*******************************************************************************
 * Copyright (C) 2016 Maxim Integrated Products, Inc., All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of Maxim Integrated
 * Products, Inc. shall not be used except as stated in the Maxim Integrated
 * Products, Inc. Branding Policy.
 *
 * The mere transfer of this software does not imply any licenses
 * of trade secrets, proprietary technology, copyrights, patents,
 * trademarks, maskwork rights, or any other form of intellectual
 * property whatsoever. Maxim Integrated Products, Inc. retains all
 * ownership rights.
 *******************************************************************************
 */
#ifndef _PUSHBUTTON_H
#define _PUSHBUTTON_H

#include "mbed.h"

class PushButton {
public:
  /**
  * @brief Constructor with a PinName
  */
  PushButton(PinName pin);
  /**
  * @brief Get the pushed state of the button
  */
  bool GetButtonFallState(void);
  /**
  * @brief Clear the pushed state of the button
  */
  void clearButtonFallState(void);
  /**
  * @brief Read the button input
  * @return Represented as 0 or 1 (int)
  */
  int Read(void);
  /**
  * @brief Set the state
  * @param state Set the button state to this value
  */
  void SetButtonFallState(bool state);

private:
  InterruptIn interruptButton;
  bool buttonFallState;
  PinName pin;
  Timeout timeout;
  bool debouncingState;
  const static float debounceTime = 0.02;
  
  void pb_hit_interrupt_fall(void);
  void pb_debounce_timeout(void);
};

#endif /* _PUSHBUTTON_H */

