/*******************************************************************************
 * Copyright (C) 2016 Maxim Integrated Products, Inc., All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of Maxim Integrated
 * Products, Inc. shall not be used except as stated in the Maxim Integrated
 * Products, Inc. Branding Policy.
 *
 * The mere transfer of this software does not imply any licenses
 * of trade secrets, proprietary technology, copyrights, patents,
 * trademarks, maskwork rights, or any other form of intellectual
 * property whatsoever. Maxim Integrated Products, Inc. retains all
 * ownership rights.
 *******************************************************************************
 */

#include "MAX14720.h"

//******************************************************************************
MAX14720::MAX14720(PinName sda, PinName scl, int slaveAddress) :
	slaveAddress(slaveAddress)
{
	i2c = new I2C(sda,scl);
	isOwner = true;
}
//******************************************************************************
MAX14720::MAX14720(I2C *i2c, int slaveAddress) :
		slaveAddress(slaveAddress)
{
	this->i2c = i2c;
	isOwner = false;
}
//******************************************************************************
MAX14720::~MAX14720()
{
	if (isOwner == true) {
		delete i2c;
	}
}

//******************************************************************************
int MAX14720::boostEn(BoostEn_Values value) {
    int result;
 	max14720_BoostCfg val;

 	// read modify write BoostEn to desired state
 	result = readReg(BOOST_CFG, &val.all);
 	val.bit.BoostEn = (char)value;
    result = writeReg(BOOST_CFG, val.all);
    if (result == MAX14720_ERROR) return result;
	return 0;
}

//******************************************************************************
int MAX14720::boostVSet(BoostVSet_Values value) {
    int result;
    max14720_BoostVSet val;

 	// read modify write boostVSet to desired state
 	result = readReg(BOOST_V_SET, &val.all);
 	val.bit.BoostVSet = (char)value;
    result = writeReg(BOOST_V_SET, val.all);
    if (result == MAX14720_ERROR) return result;
	return 0;
}

//******************************************************************************
int MAX14720::readBoostVSet(BoostVSet_Values *value) {
    int result;
    char val;
    
    result = readReg(BOOST_V_SET,&val);
    *value = (BoostVSet_Values)val;
    return result;
}

//******************************************************************************
int MAX14720::readBoostISet(BoostISet_Values *value) {
    int result;
    char val;
    
    result = readReg(BOOST_V_SET,&val);
    *value = (BoostISet_Values)val;
    return result;
}

//******************************************************************************
int MAX14720::boostISet(BoostISet_Values value) {
    int result;
    max14720_BoostISet val;

 	// read modify write boostVSet to desired state
 	result = readReg(BOOST_I_SET, &val.all);
 	val.bit.BoostISet = (char)value;
    result = writeReg(BOOST_I_SET, val.all);
    if (result == MAX14720_ERROR) return result;
	return 0;
}

//******************************************************************************
int MAX14720::writeReg(MAX14720_REG_map_t reg,  char value)
{
    int result;
    char cmdData[2] = { (char)reg, value };
    result = i2c->write(slaveAddress, cmdData, 2);
    if (result != 0) return MAX14720_ERROR;
    return MAX14720_NO_ERROR;
}

//******************************************************************************
int MAX14720::readReg(MAX14720_REG_map_t reg, char *value)
{
    int result;
    char cmdData[1] = { (char)reg };
    
    result = i2c->write(slaveAddress, cmdData, 1);
    if (result != 0) return MAX14720_ERROR;
    result = i2c->read(slaveAddress, value, 1);
    if (result != 0) return MAX14720_ERROR;
    return MAX14720_NO_ERROR;
}







