﻿// /*******************************************************************************
// * Copyright (C) 2019 Maxim Integrated Products, Inc., All Rights Reserved.
// *
// * Permission is hereby granted, free of charge, to any person obtaining a
// * copy of this software and associated documentation files (the "Software"),
// * to deal in the Software without restriction, including without limitation
// * the rights to use, copy, modify, merge, publish, distribute, sublicense,
// * and/or sell copies of the Software, and to permit persons to whom the
// * Software is furnished to do so, subject to the following conditions:
// *
// * The above copyright notice and this permission notice shall be included
// * in all copies or substantial portions of the Software.
// *
// * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
// * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// * OTHER DEALINGS IN THE SOFTWARE.
// *
// * Except as contained in this notice, the name of Maxim Integrated
// * Products, Inc. shall not be used except as stated in the Maxim Integrated
// * Products, Inc. Branding Policy.
// *
// * The mere transfer of this software does not imply any licenses
// * of trade secrets, proprietary technology, copyrights, patents,
// * trademarks, maskwork rights, or any other form of intellectual
// * property whatsoever. Maxim Integrated Products, Inc. retains all
// * ownership rights.
// *******************************************************************************
// */
// *********************************************************************
// @file MAX11410.h
// *********************************************************************
// Header file
// DO NOT EDIT; except areas designated "CUSTOMIZE". Automatically generated file.
// generated by XMLSystemOfDevicesToMBED.py
// System Name = ExampleSystem
// System Description = Device driver example
// Device Name = MAX11410
// Device Description = 1.9ksps, Low-Power, Serial SPI 24-Bit, 10-Channel, Differential/Single-Ended Input, SAR ADC
// Device Manufacturer = Maxim Integrated
// Device PartNumber = MAX11410ATI+
// Device RegValue_Width = DataWidth16bit_HL
//
// SPI CS = ActiveLow
// SPI FrameStart = CS
// SPI CPOL = 0
// SPI CPHA = 0
// SPI MOSI and MISO Data are both stable on Rising edge of SCLK
// SPI SCLK Idle Low
// SPI SCLKMaxMHz = 8
// SPI SCLKMinMHz = 0
//


// Prevent multiple declaration
#ifndef __MAX11410_H__
#define __MAX11410_H__

// standard include for target platform
#include "mbed.h"

// CODE GENERATOR: conditional defines
// CODE GENERATOR: class declaration and docstrings
/**
 * @brief MAX11410 1.9ksps, Low-Power, Serial SPI 24-Bit, 10-Channel, Differential/Single-Ended Input, SAR ADC
 *
 *
 *
 * Datasheet: https://www.maximintegrated.com/MAX11410
 *
 *
 *
 * //---------- CODE GENERATOR: helloCppCodeList
 * @code
 * // CODE GENERATOR: example code includes
 * // example code includes
 * // standard include for target platform
 * #include "mbed.h"
 * //#include "max32625.h"
 * #include "MAX11410.h"
 *
 * // example code board support
 * //MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);
 * //DigitalOut rLED(LED1);
 * //DigitalOut gLED(LED2);
 * //DigitalOut bLED(LED3);
 * //
 * // Arduino "shield" connector port definitions (MAX32625MBED shown)
 * #if defined(TARGET_MAX32625MBED)
 * #define A0 AIN_0
 * #define A1 AIN_1
 * #define A2 AIN_2
 * #define A3 AIN_3
 * #define D0 P0_0
 * #define D1 P0_1
 * #define D2 P0_2
 * #define D3 P0_3
 * #define D4 P0_4
 * #define D5 P0_5
 * #define D6 P0_6
 * #define D7 P0_7
 * #define D8 P1_4
 * #define D9 P1_5
 * #define D10 P1_3
 * #define D11 P1_1
 * #define D12 P1_2
 * #define D13 P1_0
 * #endif
 *
 * // example code declare SPI interface
 * #if defined(TARGET_MAX32625MBED)
 * SPI spi(SPI1_MOSI, SPI1_MISO, SPI1_SCK); // mosi, miso, sclk spi1 TARGET_MAX32625MBED: P1_1 P1_2 P1_0 Arduino 10-pin header D11 D12 D13
 * DigitalOut spi_cs(SPI1_SS); // TARGET_MAX32625MBED: P1_3 Arduino 10-pin header D10
 * #elif defined(TARGET_MAX32600MBED)
 * SPI spi(SPI2_MOSI, SPI2_MISO, SPI2_SCK); // mosi, miso, sclk spi1 TARGET_MAX32600MBED: Arduino 10-pin header D11 D12 D13
 * DigitalOut spi_cs(SPI2_SS); // Generic: Arduino 10-pin header D10
 * #else
 * SPI spi(D11, D12, D13); // mosi, miso, sclk spi1 TARGET_MAX32600MBED: Arduino 10-pin header D11 D12 D13
 * DigitalOut spi_cs(D10); // Generic: Arduino 10-pin header D10
 * #endif
 *
 * // example code declare GPIO interface pins
 * // example code declare device instance
 * MAX11410 g_MAX11410_device(spi, spi_cs, MAX11410::MAX11410_IC);
 *
 * // example code main function
 * int main()
 * {
 *     while (1)
 *     {
 *         // CODE GENERATOR: example code: member function Init
 *         g_MAX11410_device.Init();
 *
 *         // CODE GENERATOR: example code: has no member function REF
 *         // CODE GENERATOR: example code: has no member function CODE_LOAD
 *         // CODE GENERATOR: example code: has no member function CODEallLOADall
 *         // CODE GENERATOR: example code: has no member function CODEnLOADn
 *         // CODE GENERATOR: example code: has no member function ScanManual
 *         // CODE GENERATOR: example code: has no member function ReadAINcode
 *         wait(3.0);
 *     }
 * }
 * @endcode
 * //---------- CODE GENERATOR: end helloCppCodeList
 */
class MAX11410 {
public:
// CODE GENERATOR: TypedefEnum EnumItem declarations
// CODE GENERATOR: TypedefEnum MAX11410_CMD_enum_t
    //----------------------------------------
    /// Register Addresses
    ///
    /// Naming convention is CMD_bitstream_FUNCTION_NAME
    /// - r = read/write bit (1=read, 0=write)
    /// - xaaa_aaaa = 7-bit register address field
    /// - dddd_dddd = 8-bit register data field
    /// - dddd_dddd_dddd_dddd = 16-bit register data field
    /// - dddd_dddd_dddd_dddd_dddd_dddd = 24-bit register data field
    /// - xxxx = don't care
    typedef enum MAX11410_CMD_enum_t {
        CMD_r000_0000_xxxx_xxdd_PD = 0x00, //!< 8'b00000000
        CMD_r000_0001_xddd_xxdd_CONV_START = 0x01, //!< 8'b00000001
        CMD_r000_0010_xddd_dddd_SEQ_START = 0x02, //!< 8'b00000010
        CMD_r000_0011_xxxx_xddd_CAL_START = 0x03, //!< 8'b00000011
        CMD_r000_0100_dddd_xddd_GP0_CTRL = 0x04, //!< 8'b00000100
        CMD_r000_0101_dddd_xddd_GP1_CTRL = 0x05, //!< 8'b00000101
        CMD_r000_0110_xddd_xxdd_GP_CONV = 0x06, //!< 8'b00000110
        CMD_r000_0111_xddd_dddd_GP_SEQ_ADDR = 0x07, //!< 8'b00000111
        CMD_r000_1000_x0dd_dddd_FILTER = 0x08, //!< 8'b00001000
        CMD_r000_1001_dddd_dddd_CTRL = 0x09, //!< 8'b00001001
        CMD_r000_1010_dddd_dddd_SOURCE = 0x0a, //!< 8'b00001010
        CMD_r000_1011_dddd_dddd_MUX_CTRL0 = 0x0b, //!< 8'b00001011
        CMD_r000_1100_dddd_dddd_MUX_CTRL1 = 0x0c, //!< 8'b00001100
        CMD_r000_1101_dddd_dddd_MUX_CTRL2 = 0x0d, //!< 8'b00001101
        CMD_r000_1110_xxdd_xddd_PGA = 0x0e, //!< 8'b00001110
        CMD_r000_1111_dddd_dddd_WAIT_EXT = 0x0f, //!< 8'b00001111
        CMD_r001_0000_xxxx_xxxx_WAIT_START = 0x10, //!< 8'b00010000
        CMD_r001_0001_xxxx_xxxx_xxxx_xxxx_xxxx_xddd_PART_ID = 0x11, //!< 8'b00010001
        CMD_r001_0010_xxxx_xxxx_dddd_xxdd_dddd_dddd_SYSC_SEL = 0x12, //!< 8'b00010010
        CMD_r001_0011_dddd_dddd_dddd_dddd_dddd_dddd_SYS_OFF_A = 0x13, //!< 8'b00010011
        CMD_r001_0100_dddd_dddd_dddd_dddd_dddd_dddd_SYS_OFF_B = 0x14, //!< 8'b00010100
        CMD_r001_0101_dddd_dddd_dddd_dddd_dddd_dddd_SYS_GAIN_A = 0x15, //!< 8'b00010101
        CMD_r001_0110_dddd_dddd_dddd_dddd_dddd_dddd_SYS_GAIN_B = 0x16, //!< 8'b00010110
        CMD_r001_0111_dddd_dddd_dddd_dddd_dddd_dddd_SELF_OFF = 0x17, //!< 8'b00010111
        CMD_r001_1000_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_1 = 0x18, //!< 8'b00011000
        CMD_r001_1001_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_2 = 0x19, //!< 8'b00011001
        CMD_r001_1010_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_4 = 0x1a, //!< 8'b00011010
        CMD_r001_1011_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_8 = 0x1b, //!< 8'b00011011
        CMD_r001_1100_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_16 = 0x1c, //!< 8'b00011100
        CMD_r001_1101_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_32 = 0x1d, //!< 8'b00011101
        CMD_r001_1110_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_64 = 0x1e, //!< 8'b00011110
        CMD_r001_1111_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_128 = 0x1f, //!< 8'b00011111
        CMD_r010_0000_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH0 = 0x20, //!< 8'b00100000
        CMD_r010_0001_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH1 = 0x21, //!< 8'b00100001
        CMD_r010_0010_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH2 = 0x22, //!< 8'b00100010
        CMD_r010_0011_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH3 = 0x23, //!< 8'b00100011
        CMD_r010_0100_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH4 = 0x24, //!< 8'b00100100
        CMD_r010_0101_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH5 = 0x25, //!< 8'b00100101
        CMD_r010_0110_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH6 = 0x26, //!< 8'b00100110
        CMD_r010_0111_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH7 = 0x27, //!< 8'b00100111
        CMD_r010_1000_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH0 = 0x28, //!< 8'b00101000
        CMD_r010_1001_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH1 = 0x29, //!< 8'b00101001
        CMD_r010_1010_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH2 = 0x2a, //!< 8'b00101010
        CMD_r010_1011_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH3 = 0x2b, //!< 8'b00101011
        CMD_r010_1100_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH4 = 0x2c, //!< 8'b00101100
        CMD_r010_1101_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH5 = 0x2d, //!< 8'b00101101
        CMD_r010_1110_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH6 = 0x2e, //!< 8'b00101110
        CMD_r010_1111_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH7 = 0x2f, //!< 8'b00101111
        CMD_r011_0000_dddd_dddd_dddd_dddd_dddd_dddd_DATA0 = 0x30, //!< 8'b00110000
        CMD_r011_0001_dddd_dddd_dddd_dddd_dddd_dddd_DATA1 = 0x31, //!< 8'b00110001
        CMD_r011_0010_dddd_dddd_dddd_dddd_dddd_dddd_DATA2 = 0x32, //!< 8'b00110010
        CMD_r011_0011_dddd_dddd_dddd_dddd_dddd_dddd_DATA3 = 0x33, //!< 8'b00110011
        CMD_r011_0100_dddd_dddd_dddd_dddd_dddd_dddd_DATA4 = 0x34, //!< 8'b00110100
        CMD_r011_0101_dddd_dddd_dddd_dddd_dddd_dddd_DATA5 = 0x35, //!< 8'b00110101
        CMD_r011_0110_dddd_dddd_dddd_dddd_dddd_dddd_DATA6 = 0x36, //!< 8'b00110110
        CMD_r011_0111_dddd_dddd_dddd_dddd_dddd_dddd_DATA7 = 0x37, //!< 8'b00110111
        CMD_r011_1000_dddd_dddd_dddd_dddd_dxxx_dddd_STATUS = 0x38, //!< 8'b00111000
        CMD_r011_1001_dddd_dddd_dddd_dddd_dxxd_dddd_STATUS_IE = 0x39, //!< 8'b00111001
        CMD_r011_1010_xaaa_aaaa_dddd_dddd_UC_0 = 0x3a, //!< 8'b00111010
        CMD_r011_1011_xaaa_aaaa_dddd_dddd_UC_1 = 0x3b, //!< 8'b00111011
        CMD_r011_1100_xaaa_aaaa_dddd_dddd_UC_2 = 0x3c, //!< 8'b00111100
        CMD_r011_1101_xaaa_aaaa_dddd_dddd_UC_3 = 0x3d, //!< 8'b00111101
        CMD_r011_1110_xaaa_aaaa_dddd_dddd_UC_4 = 0x3e, //!< 8'b00111110
        CMD_r011_1111_xaaa_aaaa_dddd_dddd_UC_5 = 0x3f, //!< 8'b00111111
        CMD_r100_0000_xaaa_aaaa_dddd_dddd_UC_6 = 0x40, //!< 8'b01000000
        CMD_r100_0001_xaaa_aaaa_dddd_dddd_UC_7 = 0x41, //!< 8'b01000001
        CMD_r100_0010_xaaa_aaaa_dddd_dddd_UC_8 = 0x42, //!< 8'b01000010
        CMD_r100_0011_xaaa_aaaa_dddd_dddd_UC_9 = 0x43, //!< 8'b01000011
        CMD_r100_0100_xaaa_aaaa_dddd_dddd_UC_10 = 0x44, //!< 8'b01000100
        CMD_r100_0101_xaaa_aaaa_dddd_dddd_UC_11 = 0x45, //!< 8'b01000101
        CMD_r100_0110_xaaa_aaaa_dddd_dddd_UC_12 = 0x46, //!< 8'b01000110
        CMD_r100_0111_xaaa_aaaa_dddd_dddd_UC_13 = 0x47, //!< 8'b01000111
        CMD_r100_1000_xaaa_aaaa_dddd_dddd_UC_14 = 0x48, //!< 8'b01001000
        CMD_r100_1001_xaaa_aaaa_dddd_dddd_UC_15 = 0x49, //!< 8'b01001001
        CMD_r100_1010_xaaa_aaaa_dddd_dddd_UC_16 = 0x4a, //!< 8'b01001010
        CMD_r100_1011_xaaa_aaaa_dddd_dddd_UC_17 = 0x4b, //!< 8'b01001011
        CMD_r100_1100_xaaa_aaaa_dddd_dddd_UC_18 = 0x4c, //!< 8'b01001100
        CMD_r100_1101_xaaa_aaaa_dddd_dddd_UC_19 = 0x4d, //!< 8'b01001101
        CMD_r100_1110_xaaa_aaaa_dddd_dddd_UC_20 = 0x4e, //!< 8'b01001110
        CMD_r100_1111_xaaa_aaaa_dddd_dddd_UC_21 = 0x4f, //!< 8'b01001111
        CMD_r101_0000_xaaa_aaaa_dddd_dddd_UC_22 = 0x50, //!< 8'b01010000
        CMD_r101_0001_xaaa_aaaa_dddd_dddd_UC_23 = 0x51, //!< 8'b01010001
        CMD_r101_0010_xaaa_aaaa_dddd_dddd_UC_24 = 0x52, //!< 8'b01010010
        CMD_r101_0011_xaaa_aaaa_dddd_dddd_UC_25 = 0x53, //!< 8'b01010011
        CMD_r101_0100_xaaa_aaaa_dddd_dddd_UC_26 = 0x54, //!< 8'b01010100
        CMD_r101_0101_xaaa_aaaa_dddd_dddd_UC_27 = 0x55, //!< 8'b01010101
        CMD_r101_0110_xaaa_aaaa_dddd_dddd_UC_28 = 0x56, //!< 8'b01010110
        CMD_r101_0111_xaaa_aaaa_dddd_dddd_UC_29 = 0x57, //!< 8'b01010111
        CMD_r101_1000_xaaa_aaaa_dddd_dddd_UC_30 = 0x58, //!< 8'b01011000
        CMD_r101_1001_xaaa_aaaa_dddd_dddd_UC_31 = 0x59, //!< 8'b01011001
        CMD_r101_1010_xaaa_aaaa_dddd_dddd_UC_32 = 0x5a, //!< 8'b01011010
        CMD_r101_1011_xaaa_aaaa_dddd_dddd_UC_33 = 0x5b, //!< 8'b01011011
        CMD_r101_1100_xaaa_aaaa_dddd_dddd_UC_34 = 0x5c, //!< 8'b01011100
        CMD_r101_1101_xaaa_aaaa_dddd_dddd_UC_35 = 0x5d, //!< 8'b01011101
        CMD_r101_1110_xaaa_aaaa_dddd_dddd_UC_36 = 0x5e, //!< 8'b01011110
        CMD_r101_1111_xaaa_aaaa_dddd_dddd_UC_37 = 0x5f, //!< 8'b01011111
        CMD_r110_0000_xaaa_aaaa_dddd_dddd_UC_38 = 0x60, //!< 8'b01100000
        CMD_r110_0001_xaaa_aaaa_dddd_dddd_UC_39 = 0x61, //!< 8'b01100001
        CMD_r110_0010_xaaa_aaaa_dddd_dddd_UC_40 = 0x62, //!< 8'b01100010
        CMD_r110_0011_xaaa_aaaa_dddd_dddd_UC_41 = 0x63, //!< 8'b01100011
        CMD_r110_0100_xaaa_aaaa_dddd_dddd_UC_42 = 0x64, //!< 8'b01100100
        CMD_r110_0101_xaaa_aaaa_dddd_dddd_UC_43 = 0x65, //!< 8'b01100101
        CMD_r110_0110_xaaa_aaaa_dddd_dddd_UC_44 = 0x66, //!< 8'b01100110
        CMD_r110_0111_xaaa_aaaa_dddd_dddd_UC_45 = 0x67, //!< 8'b01100111
        CMD_r110_1000_xaaa_aaaa_dddd_dddd_UC_46 = 0x68, //!< 8'b01101000
        CMD_r110_1001_xaaa_aaaa_dddd_dddd_UC_47 = 0x69, //!< 8'b01101001
        CMD_r110_1010_xaaa_aaaa_dddd_dddd_UC_48 = 0x6a, //!< 8'b01101010
        CMD_r110_1011_xaaa_aaaa_dddd_dddd_UC_49 = 0x6b, //!< 8'b01101011
        CMD_r110_1100_xaaa_aaaa_dddd_dddd_UC_50 = 0x6c, //!< 8'b01101100
        CMD_r110_1101_xaaa_aaaa_dddd_dddd_UC_51 = 0x6d, //!< 8'b01101101
        CMD_r110_1110_xaaa_aaaa_dddd_dddd_UC_52 = 0x6e, //!< 8'b01101110
        CMD_r110_1111_xxxx_xxxx_xaaa_aaaa_UCADDR = 0x6f, //!< 8'b01101111
        CMD_1aaa_aaaa_REGISTER_READ = 0x80, //!< 8'b10000000
    } MAX11410_CMD_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_SEQ_ADDR_enum_t
    //----------------------------------------
    /// Microcode Sequencer Addresses.
    /// CMD_r000_0010_xddd_dddd_SEQ_START
    /// CMD_r000_0111_xddd_dddd_GP_SEQ_ADDR
    ///
    /// Naming convention is CMD_bitstream_FUNCTION_NAME
    /// - xaaa_aaaa = 7-bit register address field
    /// - dddd_dddd = 8-bit register data field
    /// - xxxx = don't care
    typedef enum MAX11410_SEQ_ADDR_enum_t {
        SEQ_ADDR_r011_1010_xaaa_aaaa_dddd_dddd_UC_0 = 0x3a, //!< 8'b00111010
        SEQ_ADDR_r011_1011_xaaa_aaaa_dddd_dddd_UC_1 = 0x3b, //!< 8'b00111011
        SEQ_ADDR_r011_1100_xaaa_aaaa_dddd_dddd_UC_2 = 0x3c, //!< 8'b00111100
        SEQ_ADDR_r011_1101_xaaa_aaaa_dddd_dddd_UC_3 = 0x3d, //!< 8'b00111101
        SEQ_ADDR_r011_1110_xaaa_aaaa_dddd_dddd_UC_4 = 0x3e, //!< 8'b00111110
        SEQ_ADDR_r011_1111_xaaa_aaaa_dddd_dddd_UC_5 = 0x3f, //!< 8'b00111111
        SEQ_ADDR_r100_0000_xaaa_aaaa_dddd_dddd_UC_6 = 0x40, //!< 8'b01000000
        SEQ_ADDR_r100_0001_xaaa_aaaa_dddd_dddd_UC_7 = 0x41, //!< 8'b01000001
        SEQ_ADDR_r100_0010_xaaa_aaaa_dddd_dddd_UC_8 = 0x42, //!< 8'b01000010
        SEQ_ADDR_r100_0011_xaaa_aaaa_dddd_dddd_UC_9 = 0x43, //!< 8'b01000011
        SEQ_ADDR_r100_0100_xaaa_aaaa_dddd_dddd_UC_10 = 0x44, //!< 8'b01000100
        SEQ_ADDR_r100_0101_xaaa_aaaa_dddd_dddd_UC_11 = 0x45, //!< 8'b01000101
        SEQ_ADDR_r100_0110_xaaa_aaaa_dddd_dddd_UC_12 = 0x46, //!< 8'b01000110
        SEQ_ADDR_r100_0111_xaaa_aaaa_dddd_dddd_UC_13 = 0x47, //!< 8'b01000111
        SEQ_ADDR_r100_1000_xaaa_aaaa_dddd_dddd_UC_14 = 0x48, //!< 8'b01001000
        SEQ_ADDR_r100_1001_xaaa_aaaa_dddd_dddd_UC_15 = 0x49, //!< 8'b01001001
        SEQ_ADDR_r100_1010_xaaa_aaaa_dddd_dddd_UC_16 = 0x4a, //!< 8'b01001010
        SEQ_ADDR_r100_1011_xaaa_aaaa_dddd_dddd_UC_17 = 0x4b, //!< 8'b01001011
        SEQ_ADDR_r100_1100_xaaa_aaaa_dddd_dddd_UC_18 = 0x4c, //!< 8'b01001100
        SEQ_ADDR_r100_1101_xaaa_aaaa_dddd_dddd_UC_19 = 0x4d, //!< 8'b01001101
        SEQ_ADDR_r100_1110_xaaa_aaaa_dddd_dddd_UC_20 = 0x4e, //!< 8'b01001110
        SEQ_ADDR_r100_1111_xaaa_aaaa_dddd_dddd_UC_21 = 0x4f, //!< 8'b01001111
        SEQ_ADDR_r101_0000_xaaa_aaaa_dddd_dddd_UC_22 = 0x50, //!< 8'b01010000
        SEQ_ADDR_r101_0001_xaaa_aaaa_dddd_dddd_UC_23 = 0x51, //!< 8'b01010001
        SEQ_ADDR_r101_0010_xaaa_aaaa_dddd_dddd_UC_24 = 0x52, //!< 8'b01010010
        SEQ_ADDR_r101_0011_xaaa_aaaa_dddd_dddd_UC_25 = 0x53, //!< 8'b01010011
        SEQ_ADDR_r101_0100_xaaa_aaaa_dddd_dddd_UC_26 = 0x54, //!< 8'b01010100
        SEQ_ADDR_r101_0101_xaaa_aaaa_dddd_dddd_UC_27 = 0x55, //!< 8'b01010101
        SEQ_ADDR_r101_0110_xaaa_aaaa_dddd_dddd_UC_28 = 0x56, //!< 8'b01010110
        SEQ_ADDR_r101_0111_xaaa_aaaa_dddd_dddd_UC_29 = 0x57, //!< 8'b01010111
        SEQ_ADDR_r101_1000_xaaa_aaaa_dddd_dddd_UC_30 = 0x58, //!< 8'b01011000
        SEQ_ADDR_r101_1001_xaaa_aaaa_dddd_dddd_UC_31 = 0x59, //!< 8'b01011001
        SEQ_ADDR_r101_1010_xaaa_aaaa_dddd_dddd_UC_32 = 0x5a, //!< 8'b01011010
        SEQ_ADDR_r101_1011_xaaa_aaaa_dddd_dddd_UC_33 = 0x5b, //!< 8'b01011011
        SEQ_ADDR_r101_1100_xaaa_aaaa_dddd_dddd_UC_34 = 0x5c, //!< 8'b01011100
        SEQ_ADDR_r101_1101_xaaa_aaaa_dddd_dddd_UC_35 = 0x5d, //!< 8'b01011101
        SEQ_ADDR_r101_1110_xaaa_aaaa_dddd_dddd_UC_36 = 0x5e, //!< 8'b01011110
        SEQ_ADDR_r101_1111_xaaa_aaaa_dddd_dddd_UC_37 = 0x5f, //!< 8'b01011111
        SEQ_ADDR_r110_0000_xaaa_aaaa_dddd_dddd_UC_38 = 0x60, //!< 8'b01100000
        SEQ_ADDR_r110_0001_xaaa_aaaa_dddd_dddd_UC_39 = 0x61, //!< 8'b01100001
        SEQ_ADDR_r110_0010_xaaa_aaaa_dddd_dddd_UC_40 = 0x62, //!< 8'b01100010
        SEQ_ADDR_r110_0011_xaaa_aaaa_dddd_dddd_UC_41 = 0x63, //!< 8'b01100011
        SEQ_ADDR_r110_0100_xaaa_aaaa_dddd_dddd_UC_42 = 0x64, //!< 8'b01100100
        SEQ_ADDR_r110_0101_xaaa_aaaa_dddd_dddd_UC_43 = 0x65, //!< 8'b01100101
        SEQ_ADDR_r110_0110_xaaa_aaaa_dddd_dddd_UC_44 = 0x66, //!< 8'b01100110
        SEQ_ADDR_r110_0111_xaaa_aaaa_dddd_dddd_UC_45 = 0x67, //!< 8'b01100111
        SEQ_ADDR_r110_1000_xaaa_aaaa_dddd_dddd_UC_46 = 0x68, //!< 8'b01101000
        SEQ_ADDR_r110_1001_xaaa_aaaa_dddd_dddd_UC_47 = 0x69, //!< 8'b01101001
        SEQ_ADDR_r110_1010_xaaa_aaaa_dddd_dddd_UC_48 = 0x6a, //!< 8'b01101010
        SEQ_ADDR_r110_1011_xaaa_aaaa_dddd_dddd_UC_49 = 0x6b, //!< 8'b01101011
        SEQ_ADDR_r110_1100_xaaa_aaaa_dddd_dddd_UC_50 = 0x6c, //!< 8'b01101100
        SEQ_ADDR_r110_1101_xaaa_aaaa_dddd_dddd_UC_51 = 0x6d, //!< 8'b01101101
        SEQ_ADDR_r110_1110_xaaa_aaaa_dddd_dddd_UC_52 = 0x6e, //!< 8'b01101110
    } MAX11410_SEQ_ADDR_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_PD_enum_t
    //----------------------------------------
    /// Power-down state command
    /// CMD_r000_0000_xxxx_xxdd_PD PD[1:0] field
    ///
    /// - 00: Normal mode
    /// - 01: Standby mode -- Powers down all analog circuity, but not the internal voltage regulator
    /// - 10: Sleep mode -- Powers down all analog circuitry including the internal voltage regulator
    /// - 11: Reset -- all registers reset to POR state (Self Clearing to 01 Standby mode)
    typedef enum MAX11410_PD_enum_t {
        PD_00_Normal = 0x00, //!< 8'b00000000
        PD_01_Standby = 0x01, //!< 8'b00000001
        PD_10_Sleep = 0x02, //!< 8'b00000010
        PD_11_Reset = 0x03, //!< 8'b00000011
    } MAX11410_PD_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_DEST_enum_t
    //----------------------------------------
    /// Conversion / seqeuncer start command
    /// CMD_r000_0001_xddd_xxdd_CONV_START DEST[2:0] field.
    /// CMD_r000_0110_xddd_xxdd_GP_CONV GP_DEST[2:0] field.
    ///
    /// - 000: Store result in DATA0
    /// - 001: Store result in DATA1
    /// - 010: Store result in DATA2
    /// - 011: Store result in DATA3
    /// - 100: Store result in DATA4
    /// - 101: Store result in DATA5
    /// - 110: Store result in DATA6
    /// - 111: Store result in DATA7
    typedef enum MAX11410_DEST_enum_t {
        DEST_000_DATA0 = 0x00, //!< 8'b00000000
        DEST_001_DATA1 = 0x01, //!< 8'b00000001
        DEST_010_DATA2 = 0x02, //!< 8'b00000010
        DEST_011_DATA3 = 0x03, //!< 8'b00000011
        DEST_100_DATA4 = 0x04, //!< 8'b00000100
        DEST_101_DATA5 = 0x05, //!< 8'b00000101
        DEST_110_DATA6 = 0x06, //!< 8'b00000110
        DEST_111_DATA7 = 0x07, //!< 8'b00000111
    } MAX11410_DEST_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_CONV_TYPE_enum_t
    //----------------------------------------
    /// Conversion / seqeuncer start command
    /// CMD_r000_0001_xddd_xxdd_CONV_START CONV_TYPE[1:0] field.
    /// CMD_r000_0110_xddd_xxdd_GP_CONV GP_CONV_TYPE[2:0] field.
    ///
    /// - 00: Single conversion
    /// - 01: Continuous conversions
    /// - 10, 11: 1:4 Duty cycled conversions (modulator low-power mode)
    typedef enum MAX11410_CONV_TYPE_enum_t {
        CONV_TYPE_00_Single = 0x00, //!< 8'b00000000
        CONV_TYPE_01_Continuous = 0x01, //!< 8'b00000001
        CONV_TYPE_10_DutyCycle_1_4 = 0x02, //!< 8'b00000010
        CONV_TYPE_11_DutyCycle_1_4 = 0x03, //!< 8'b00000011
    } MAX11410_CONV_TYPE_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_CAL_TYPE_enum_t
    //----------------------------------------
    /// Calbration command
    /// CMD_r000_0011_xxxx_xddd_CAL_START CAL_TYPE[2:0] field
    ///
    /// - 000: Performs a self-calibration. Resulting offset calibration value is stored in the SELF_OFF register, and the 1x gain calibration value is stored in the SELF_GAIN_1 register.
    /// - 001: Performs a PGA gain calibration at the currently programmed PGA gain. A 'No Op' will result if PGA Gain calibration is executed with the PGA disabled via the SIG_PATH register, or with the GAIN register set to 1x.The resulting gain calibration value is stored in the SELF_GAIN_[2-128] register corresponding to the currently programmed PGA GAIN setting.
    /// - 010: Reserved
    /// - 011: Reserved
    /// - 100: Performs a system offset calibration. The resulting calibration value is stored in the SYS_OFF_A register.
    /// - 101: Performs a system gain calibration. The resulting calibration value is stored in the SYS_GAIN_A register.
    /// - 110: Performs a system offset calibration. The resulting calibration value is stored in the SYS_OFF_B register.
    /// - 111: Performs a system gain calibration. The resulting calibration value is stored in the SYS_GAIN_B register.
    typedef enum MAX11410_CAL_TYPE_enum_t {
        CAL_TYPE_000_SELF_CAL = 0x00, //!< 8'b00000000
        CAL_TYPE_001_PGA_GAIN = 0x01, //!< 8'b00000001
        CAL_TYPE_010_reserved = 0x02, //!< 8'b00000010
        CAL_TYPE_011_reserved = 0x03, //!< 8'b00000011
        CAL_TYPE_100_SYS_OFF_A = 0x04, //!< 8'b00000100
        CAL_TYPE_101_SYS_GAIN_A = 0x05, //!< 8'b00000101
        CAL_TYPE_110_SYS_OFF_B = 0x06, //!< 8'b00000110
        CAL_TYPE_111_SYS_GAIN_B = 0x07, //!< 8'b00000111
    } MAX11410_CAL_TYPE_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_GP0_DIR_enum_t
    //----------------------------------------
    /// GPIO0 pin command
    /// CMD_r000_0100_dddd_xddd_GP0_CTRL GP0_DIR[1:0] field
    ///
    /// - 00: Input mode, reference to VDDIO (default)
    /// - 01: Reserved
    /// - 10: Output mode, open-drain output
    /// - 11: Output mode, CMOS output
    typedef enum MAX11410_GP0_DIR_enum_t {
        GP0_DIR_000_Input = 0x00, //!< 8'b00000000
        GP0_DIR_001_reserved = 0x01, //!< 8'b00000001
        GP0_DIR_010_OutputOpenDrain = 0x02, //!< 8'b00000010
        GP0_DIR_011_Output = 0x03, //!< 8'b00000011
    } MAX11410_GP0_DIR_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_GP0_ISEL_enum_t
    //----------------------------------------
    /// GPIO0 pin command
    /// CMD_r000_0100_dddd_xddd_GP0_CTRL GP0_ISEL[1:0] field
    ///
    /// - 00: GPIO_0 input disabled (default)
    /// - 01: GPIO_0 input configured as rising-edge-triggered conversion start
    /// - 10: GPIO_0 input configured as rising-edge-triggered sequence start from GP_SEQ_ADDR
    /// - 11: Reserved
    typedef enum MAX11410_GP0_ISEL_enum_t {
        GP0_ISEL_000_disabled = 0x00, //!< 8'b00000000
        GP0_ISEL_001_TRIGGER_CONV_START = 0x01, //!< 8'b00000001
        GP0_ISEL_010_TRIGGER_SEQ_START = 0x02, //!< 8'b00000010
        GP0_ISEL_011_reserved = 0x03, //!< 8'b00000011
    } MAX11410_GP0_ISEL_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_GP0_OSEL_enum_t
    //----------------------------------------
    /// GPIO0 pin command
    /// CMD_r000_0100_dddd_xddd_GP0_CTRL GP0_OSEL[2:0] field
    ///
    /// - 000: GPIO_0 output disabled, high Z (default)
    /// - 001: GPIO_0 output is configured as INTRB (active low)
    /// - 010: GPIO_0 output is configured as INTR (active high)
    /// - 011: GPIO_0 output is configured as state Logic 0
    /// - 100: GPIO_0 output is configured as state Logic 1
    /// - 101: GPIO_0 output is configured as automatic low-side switch operation (CMOS output mode overridden)
    /// - 110: GPIO_0 output is configured as modulator active status
    /// - 111: GPIO_0 output is configured as system clock (2.456Mhz Nominal)
    typedef enum MAX11410_GP0_OSEL_enum_t {
        GP0_OSEL_000_disabled = 0x00, //!< 8'b00000000
        GP0_OSEL_001_INTRB = 0x01, //!< 8'b00000001
        GP0_OSEL_010_INTR = 0x02, //!< 8'b00000010
        GP0_OSEL_011_LOGIC_0 = 0x03, //!< 8'b00000011
        GP0_OSEL_100_LOGIC_1 = 0x04, //!< 8'b00000100
        GP0_OSEL_101_AUTO_LOWSIDE_SWITCH = 0x05, //!< 8'b00000101
        GP0_OSEL_110_MODULATOR_ACTIVE_STATUS = 0x06, //!< 8'b00000110
        GP0_OSEL_111_CLOCK_2M456 = 0x07, //!< 8'b00000111
    } MAX11410_GP0_OSEL_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_GP1_DIR_enum_t
    //----------------------------------------
    /// GPIO1 pin command
    /// CMD_r000_0101_dddd_xddd_GP1_CTRL GP1_DIR[1:0] field
    ///
    /// - 00: Input mode, reference to VDDIO (default)
    /// - 01: Reserved
    /// - 10: Output mode, open-drain output
    /// - 11: Output mode, CMOS output
    typedef enum MAX11410_GP1_DIR_enum_t {
        GP1_DIR_000_Input = 0x00, //!< 8'b00000000
        GP1_DIR_001_reserved = 0x01, //!< 8'b00000001
        GP1_DIR_010_OutputOpenDrain = 0x02, //!< 8'b00000010
        GP1_DIR_011_Output = 0x03, //!< 8'b00000011
    } MAX11410_GP1_DIR_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_GP1_ISEL_enum_t
    //----------------------------------------
    /// GPIO1 pin command
    /// CMD_r000_0101_dddd_xddd_GP1_CTRL GP1_ISEL[1:0] field
    ///
    /// - 00: GPIO_1 input disabled (default)
    /// - 01: GPIO_1 input configured as rising-edge-triggered conversion start
    /// - 10: GPIO_1 input configured as rising-edge-triggered sequence start from GP_SEQ_ADDR
    /// - 11: Reserved
    typedef enum MAX11410_GP1_ISEL_enum_t {
        GP1_ISEL_000_disabled = 0x00, //!< 8'b00000000
        GP1_ISEL_001_TRIGGER_CONV_START = 0x01, //!< 8'b00000001
        GP1_ISEL_010_TRIGGER_SEQ_START = 0x02, //!< 8'b00000010
        GP1_ISEL_011_reserved = 0x03, //!< 8'b00000011
    } MAX11410_GP1_ISEL_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_GP1_OSEL_enum_t
    //----------------------------------------
    /// GPIO1 pin command
    /// CMD_r000_0101_dddd_xddd_GP1_CTRL GP1_OSEL[2:0] field
    ///
    /// - 000: GPIO_1 output disabled, high Z (default)
    /// - 001: GPIO_1 output is configured as INTRB (active low)
    /// - 010: GPIO_1 output is configured as INTR (active high)
    /// - 011: GPIO_1 output is configured as state Logic 0
    /// - 100: GPIO_1 output is configured as state Logic 1
    /// - 101: GPIO_1 output is configured as system clock (2.456Mhz Nominal)
    /// - 110: GPIO_1 output is configured as modulator active status
    /// - 111: GPIO_1 output is configured as automatic low-side switch operation (CMOS output mode overridden)
    typedef enum MAX11410_GP1_OSEL_enum_t {
        GP1_OSEL_000_disabled = 0x00, //!< 8'b00000000
        GP1_OSEL_001_INTRB = 0x01, //!< 8'b00000001
        GP1_OSEL_010_INTR = 0x02, //!< 8'b00000010
        GP1_OSEL_011_LOGIC_0 = 0x03, //!< 8'b00000011
        GP1_OSEL_100_LOGIC_1 = 0x04, //!< 8'b00000100
        GP1_OSEL_101_AUTO_LOWSIDE_SWITCH = 0x05, //!< 8'b00000101
        GP1_OSEL_110_MODULATOR_ACTIVE_STATUS = 0x06, //!< 8'b00000110
        GP1_OSEL_111_CLOCK_2M456 = 0x07, //!< 8'b00000111
    } MAX11410_GP1_OSEL_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_LINEF_enum_t
    //----------------------------------------
    /// Filter command
    /// CMD_r000_1000_x0dd_dddd_FILTER LINEF[1:0] field
    ///
    /// - 00: Simultaneous 50/60Hz FIR rejection (default)
    /// - 01: 50Hz FIR rejection
    /// - 10: 60Hz FIR rejection
    /// - 11: SINC4
    typedef enum MAX11410_LINEF_enum_t {
        LINEF_00_50Hz_60Hz_FIR = 0x00, //!< 8'b00000000
        LINEF_01_50Hz_FIR = 0x01, //!< 8'b00000001
        LINEF_10_60Hz_FIR = 0x02, //!< 8'b00000010
        LINEF_11_SINC4 = 0x03, //!< 8'b00000011
    } MAX11410_LINEF_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_RATE_enum_t
    //----------------------------------------
    /// Filter command
    /// CMD_r000_1000_x0dd_dddd_FILTER RATE[3:0] field
    ///
    /// Sets conversion rate based on LINEF value. See Table 9a through Table 9d for details.
    ///
    /// Table 9a. LINEF = 00 Data Rate and Filter Rejection Settings
    ///
    ///  Rate      | LINEF                  | CONV_TYPE                  | Rate
    /// -----------|------------------------|----------------------------|----------
    ///  RATE_0000 | LINEF_00_50Hz_60Hz_FIR | CONV_TYPE_00_Single        |  1.0SPS
    ///  RATE_0001 | LINEF_00_50Hz_60Hz_FIR | CONV_TYPE_00_Single        |  2.0SPS
    ///  RATE_0010 | LINEF_00_50Hz_60Hz_FIR | CONV_TYPE_00_Single        |  4.0SPS
    ///  RATE_0011 | LINEF_00_50Hz_60Hz_FIR | CONV_TYPE_00_Single        |  8.0SPS
    ///  RATE_0100 | LINEF_00_50Hz_60Hz_FIR | CONV_TYPE_00_Single        | 16.0SPS
    ///  RATE_0000 | LINEF_00_50Hz_60Hz_FIR | CONV_TYPE_01_Continuous    |  1.1SPS
    ///  RATE_0001 | LINEF_00_50Hz_60Hz_FIR | CONV_TYPE_01_Continuous    |  2.1SPS
    ///  RATE_0010 | LINEF_00_50Hz_60Hz_FIR | CONV_TYPE_01_Continuous    |  4.2SPS
    ///  RATE_0011 | LINEF_00_50Hz_60Hz_FIR | CONV_TYPE_01_Continuous    |  8.4SPS
    ///  RATE_0100 | LINEF_00_50Hz_60Hz_FIR | CONV_TYPE_01_Continuous    | 16.8SPS
    ///  RATE_0000 | LINEF_00_50Hz_60Hz_FIR | CONV_TYPE_10_DutyCycle_1_4 |  0.3SPS
    ///  RATE_0001 | LINEF_00_50Hz_60Hz_FIR | CONV_TYPE_10_DutyCycle_1_4 |  0.5SPS
    ///  RATE_0010 | LINEF_00_50Hz_60Hz_FIR | CONV_TYPE_10_DutyCycle_1_4 |  1.1SPS
    ///  RATE_0011 | LINEF_00_50Hz_60Hz_FIR | CONV_TYPE_10_DutyCycle_1_4 |  2.1SPS
    ///  RATE_0100 | LINEF_00_50Hz_60Hz_FIR | CONV_TYPE_10_DutyCycle_1_4 |  4.2SPS
    ///
    /// Table 9b. LINEF = 01 Data Rate and Filter Rejection Settings
    ///
    ///  Rate     | LINEF                  | CONV_TYPE                  | Rate
    /// ----------|------------------------|----------------------------|----------
    /// RATE_0000 | LINEF_01_50Hz_FIR      | CONV_TYPE_00_Single        |  1.3SPS
    /// RATE_0001 | LINEF_01_50Hz_FIR      | CONV_TYPE_00_Single        |  2.5SPS
    /// RATE_0010 | LINEF_01_50Hz_FIR      | CONV_TYPE_00_Single        |  5.0SPS
    /// RATE_0011 | LINEF_01_50Hz_FIR      | CONV_TYPE_00_Single        | 10.0SPS
    /// RATE_0100 | LINEF_01_50Hz_FIR      | CONV_TYPE_00_Single        | 20.0SPS
    /// RATE_0101 | LINEF_01_50Hz_FIR      | CONV_TYPE_00_Single        | 35.6SPS
    /// RATE_0000 | LINEF_01_50Hz_FIR      | CONV_TYPE_01_Continuous    |  1.3SPS
    /// RATE_0001 | LINEF_01_50Hz_FIR      | CONV_TYPE_01_Continuous    |  2.7SPS
    /// RATE_0010 | LINEF_01_50Hz_FIR      | CONV_TYPE_01_Continuous    |  5.3SPS
    /// RATE_0011 | LINEF_01_50Hz_FIR      | CONV_TYPE_01_Continuous    | 10.7SPS
    /// RATE_0100 | LINEF_01_50Hz_FIR      | CONV_TYPE_01_Continuous    | 21.3SPS
    /// RATE_0101 | LINEF_01_50Hz_FIR      | CONV_TYPE_01_Continuous    | 40.0SPS
    /// RATE_0000 | LINEF_01_50Hz_FIR      | CONV_TYPE_10_DutyCycle_1_4 |  0.3SPS
    /// RATE_0001 | LINEF_01_50Hz_FIR      | CONV_TYPE_10_DutyCycle_1_4 |  0.7SPS
    /// RATE_0010 | LINEF_01_50Hz_FIR      | CONV_TYPE_10_DutyCycle_1_4 |  1.3SPS
    /// RATE_0011 | LINEF_01_50Hz_FIR      | CONV_TYPE_10_DutyCycle_1_4 |  2.7SPS
    /// RATE_0100 | LINEF_01_50Hz_FIR      | CONV_TYPE_10_DutyCycle_1_4 |  5.3SPS
    /// RATE_0101 | LINEF_01_50Hz_FIR      | CONV_TYPE_10_DutyCycle_1_4 | 10.0SPS
    ///
    /// Table 9c. LINEF = 10 Data Rate and Filter Rejection Settings
    ///
    ///  Rate     | LINEF                  | CONV_TYPE                  | Rate
    /// ----------|------------------------|----------------------------|----------
    /// RATE_0000 | LINEF_10_60Hz_FIR      | CONV_TYPE_00_Single        |  1.3SPS
    /// RATE_0001 | LINEF_10_60Hz_FIR      | CONV_TYPE_00_Single        |  2.5SPS
    /// RATE_0010 | LINEF_10_60Hz_FIR      | CONV_TYPE_00_Single        |  5.0SPS
    /// RATE_0011 | LINEF_10_60Hz_FIR      | CONV_TYPE_00_Single        | 10.0SPS
    /// RATE_0100 | LINEF_10_60Hz_FIR      | CONV_TYPE_00_Single        | 20.0SPS
    /// RATE_0101 | LINEF_10_60Hz_FIR      | CONV_TYPE_00_Single        | 35.6SPS
    /// RATE_0000 | LINEF_10_60Hz_FIR      | CONV_TYPE_01_Continuous    |  1.3SPS
    /// RATE_0001 | LINEF_10_60Hz_FIR      | CONV_TYPE_01_Continuous    |  2.7SPS
    /// RATE_0010 | LINEF_10_60Hz_FIR      | CONV_TYPE_01_Continuous    |  5.3SPS
    /// RATE_0011 | LINEF_10_60Hz_FIR      | CONV_TYPE_01_Continuous    | 10.7SPS
    /// RATE_0100 | LINEF_10_60Hz_FIR      | CONV_TYPE_01_Continuous    | 21.3SPS
    /// RATE_0101 | LINEF_10_60Hz_FIR      | CONV_TYPE_01_Continuous    | 40.0SPS
    /// RATE_0000 | LINEF_10_60Hz_FIR      | CONV_TYPE_10_DutyCycle_1_4 |  0.3SPS
    /// RATE_0001 | LINEF_10_60Hz_FIR      | CONV_TYPE_10_DutyCycle_1_4 |  0.7SPS
    /// RATE_0010 | LINEF_10_60Hz_FIR      | CONV_TYPE_10_DutyCycle_1_4 |  1.3SPS
    /// RATE_0011 | LINEF_10_60Hz_FIR      | CONV_TYPE_10_DutyCycle_1_4 |  2.7SPS
    /// RATE_0100 | LINEF_10_60Hz_FIR      | CONV_TYPE_10_DutyCycle_1_4 |  5.3SPS
    /// RATE_0101 | LINEF_10_60Hz_FIR      | CONV_TYPE_10_DutyCycle_1_4 | 10.0SPS
    ///
    /// Table 9d. LINEF = 11 Data Rate and Filter Rejection Settings
    ///
    ///  Rate     | LINEF                  | CONV_TYPE                  | Rate
    /// ----------|------------------------|----------------------------|----------
    /// RATE_0000 | LINEF_11_SINC4         | CONV_TYPE_00_Single        |     1SPS
    /// RATE_0001 | LINEF_11_SINC4         | CONV_TYPE_00_Single        |     2.5SPS
    /// RATE_0010 | LINEF_11_SINC4         | CONV_TYPE_00_Single        |     5SPS
    /// RATE_0011 | LINEF_11_SINC4         | CONV_TYPE_00_Single        |    10SPS
    /// RATE_0100 | LINEF_11_SINC4         | CONV_TYPE_00_Single        |    15SPS
    /// RATE_0101 | LINEF_11_SINC4         | CONV_TYPE_00_Single        |    30SPS
    /// RATE_0110 | LINEF_11_SINC4         | CONV_TYPE_00_Single        |    60SPS
    /// RATE_0111 | LINEF_11_SINC4         | CONV_TYPE_00_Single        |   120SPS
    /// RATE_1000 | LINEF_11_SINC4         | CONV_TYPE_00_Single        |   240SPS
    /// RATE_1001 | LINEF_11_SINC4         | CONV_TYPE_00_Single        |   480SPS
    /// RATE_0000 | LINEF_11_SINC4         | CONV_TYPE_01_Continuous    |    4SPS
    /// RATE_0001 | LINEF_11_SINC4         | CONV_TYPE_01_Continuous    |   10SPS
    /// RATE_0010 | LINEF_11_SINC4         | CONV_TYPE_01_Continuous    |   20SPS
    /// RATE_0011 | LINEF_11_SINC4         | CONV_TYPE_01_Continuous    |   40SPS
    /// RATE_0100 | LINEF_11_SINC4         | CONV_TYPE_01_Continuous    |   60SPS
    /// RATE_0101 | LINEF_11_SINC4         | CONV_TYPE_01_Continuous    |  120SPS
    /// RATE_0110 | LINEF_11_SINC4         | CONV_TYPE_01_Continuous    |  240SPS
    /// RATE_0111 | LINEF_11_SINC4         | CONV_TYPE_01_Continuous    |  480SPS
    /// RATE_1000 | LINEF_11_SINC4         | CONV_TYPE_01_Continuous    |  960SPS
    /// RATE_1001 | LINEF_11_SINC4         | CONV_TYPE_01_Continuous    | 1920SPS
    /// RATE_0000 | LINEF_11_SINC4         | CONV_TYPE_10_DutyCycle_1_4 |    1SPS
    /// RATE_0001 | LINEF_11_SINC4         | CONV_TYPE_10_DutyCycle_1_4 |    2.5SPS
    /// RATE_0010 | LINEF_11_SINC4         | CONV_TYPE_10_DutyCycle_1_4 |    5SPS
    /// RATE_0011 | LINEF_11_SINC4         | CONV_TYPE_10_DutyCycle_1_4 |   10SPS
    /// RATE_0100 | LINEF_11_SINC4         | CONV_TYPE_10_DutyCycle_1_4 |   15SPS
    /// RATE_0101 | LINEF_11_SINC4         | CONV_TYPE_10_DutyCycle_1_4 |   30SPS
    /// RATE_0110 | LINEF_11_SINC4         | CONV_TYPE_10_DutyCycle_1_4 |   60SPS
    /// RATE_0111 | LINEF_11_SINC4         | CONV_TYPE_10_DutyCycle_1_4 |  120SPS
    /// RATE_1000 | LINEF_11_SINC4         | CONV_TYPE_10_DutyCycle_1_4 |  240SPS
    /// RATE_1001 | LINEF_11_SINC4         | CONV_TYPE_10_DutyCycle_1_4 |  480SPS
    ///
    typedef enum MAX11410_RATE_enum_t {
        RATE_0000 = 0x00, //!< 8'b00000000
        RATE_0001 = 0x01, //!< 8'b00000001
        RATE_0010 = 0x02, //!< 8'b00000010
        RATE_0011 = 0x03, //!< 8'b00000011
        RATE_0100 = 0x04, //!< 8'b00000100
        RATE_0101 = 0x05, //!< 8'b00000101
        RATE_0110 = 0x06, //!< 8'b00000110
        RATE_0111 = 0x07, //!< 8'b00000111
        RATE_1000 = 0x08, //!< 8'b00001000
        RATE_1001 = 0x09, //!< 8'b00001001
        RATE_1010 = 0x0a, //!< 8'b00001010
        RATE_1011 = 0x0b, //!< 8'b00001011
        RATE_1100 = 0x0c, //!< 8'b00001100
        RATE_1101 = 0x0d, //!< 8'b00001101
        RATE_1110 = 0x0e, //!< 8'b00001110
        RATE_1111 = 0x0f, //!< 8'b00001111
    } MAX11410_RATE_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_REF_SEL_enum_t
    //----------------------------------------
    /// Filter command
    /// CMD_r000_1001_dddd_dddd_CTRL REF_SEL[2:0] field
    ///
    /// - 000: AIN0(REF0P)/AIN1(REF0N)
    /// - 001: REF1P/REF1N (default)
    /// - 010: REF2P/REF2N
    /// - 011: AVDD/AGND
    /// - 100: AIN0(REF0P)/AGND (single-ended mode)
    /// - 101: REF1P/AGND (single-ended mode)
    /// - 110: REF2P/AGND (single-ended mode)
    /// - 111: AVDD/AGND
    typedef enum MAX11410_REF_SEL_enum_t {
        REF_SEL_000_AIN0_AIN1 = 0x00, //!< 8'b00000000
        REF_SEL_001_REF1P_REF1N = 0x01, //!< 8'b00000001
        REF_SEL_010_REF2P_REF2N = 0x02, //!< 8'b00000010
        REF_SEL_011_AVDD_AGND = 0x03, //!< 8'b00000011
        REF_SEL_100_AIN0_AGND = 0x04, //!< 8'b00000100
        REF_SEL_101_REF1P_AGND = 0x05, //!< 8'b00000101
        REF_SEL_110_REF2P_AGND = 0x06, //!< 8'b00000110
        REF_SEL_111_AVDD_AGND = 0x07, //!< 8'b00000111
    } MAX11410_REF_SEL_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_VBIAS_MODE_enum_t
    //----------------------------------------
    /// Source command
    /// CMD_r000_1010_dddd_dddd_SOURCE VBIAS_MODE[1:0] field
    ///
    /// - 00: Active mode (default)
    /// - 01: High impedance; 125kOhm output impedance
    /// - 10: Low impedance; 20kOhm output impedance
    /// - 11: Low impedance; 20kOhm output impedance
    typedef enum MAX11410_VBIAS_MODE_enum_t {
        VBIAS_MODE_00_Active = 0x00, //!< 8'b00000000
        VBIAS_MODE_01_125kOhm = 0x01, //!< 8'b00000001
        VBIAS_MODE_10_20kOhm = 0x02, //!< 8'b00000010
        VBIAS_MODE_11_20kOhm = 0x03, //!< 8'b00000011
    } MAX11410_VBIAS_MODE_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_BRN_MODE_enum_t
    //----------------------------------------
    /// Source command
    /// CMD_r000_1010_dddd_dddd_SOURCE BRN_MODE[1:0] field
    ///
    /// - 00: Powered down, burnout sources disabled (default)
    /// - 01: 0.5uA burnout current sources enabled
    /// - 10: 1uA burnout current sources enabled
    /// - 11: 10uA burnout current sources enabled
    typedef enum MAX11410_BRN_MODE_enum_t {
        BRN_MODE_00_disabled = 0x00, //!< 8'b00000000
        BRN_MODE_01_0u5A = 0x01, //!< 8'b00000001
        BRN_MODE_10_1uA = 0x02, //!< 8'b00000010
        BRN_MODE_11_10uA = 0x03, //!< 8'b00000011
    } MAX11410_BRN_MODE_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_IDAC_MODE_enum_t
    //----------------------------------------
    /// Source command
    /// CMD_r000_1010_dddd_dddd_SOURCE IDAC_MODE[3:0] field
    ///
    /// - 0000: 10uA (default)
    /// - 0001: 50uA
    /// - 0010: 75uA
    /// - 0011: 100uA
    /// - 0100: 125uA
    /// - 0101: 150uA
    /// - 0110: 175uA
    /// - 0111: 200uA
    /// - 1000: 225uA
    /// - 1001: 250uA
    /// - 1010: 300uA
    /// - 1011: 400uA
    /// - 1100: 600uA
    /// - 1101: 800uA
    /// - 1110: 1200uA
    /// - 1111: 1600uA
    typedef enum MAX11410_IDAC_MODE_enum_t {
        IDAC_MODE_0000_10uA = 0x00, //!< 8'b00000000
        IDAC_MODE_0001_50uA = 0x01, //!< 8'b00000001
        IDAC_MODE_0010_75uA = 0x02, //!< 8'b00000010
        IDAC_MODE_0011_100uA = 0x03, //!< 8'b00000011
        IDAC_MODE_0100_125uA = 0x04, //!< 8'b00000100
        IDAC_MODE_0101_150uA = 0x05, //!< 8'b00000101
        IDAC_MODE_0110_175uA = 0x06, //!< 8'b00000110
        IDAC_MODE_0111_200uA = 0x07, //!< 8'b00000111
        IDAC_MODE_1000_225uA = 0x08, //!< 8'b00001000
        IDAC_MODE_1001_250uA = 0x09, //!< 8'b00001001
        IDAC_MODE_1010_300uA = 0x0a, //!< 8'b00001010
        IDAC_MODE_1011_400uA = 0x0b, //!< 8'b00001011
        IDAC_MODE_1100_600uA = 0x0c, //!< 8'b00001100
        IDAC_MODE_1101_800uA = 0x0d, //!< 8'b00001101
        IDAC_MODE_1110_1200uA = 0x0e, //!< 8'b00001110
        IDAC_MODE_1111_1600uA = 0x0f, //!< 8'b00001111
    } MAX11410_IDAC_MODE_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_AINP_SEL_enum_t
    //----------------------------------------
    /// Input multiplexer channel selection
    /// CMD_r000_1011_dddd_dddd_MUX_CTRL0 field AINP_SEL[3:0]
    ///
    /// - 0000: AINP = AIN0
    /// - 0001: AINP = AIN1
    /// - 0010: AINP = AIN2
    /// - 0011: AINP = AIN3
    /// - 0100: AINP = AIN4
    /// - 0101: AINP = AIN5
    /// - 0110: AINP = AIN6
    /// - 0111: AINP = AIN7
    /// - 1000: AINP = AIN8
    /// - 1001: AINP = AIN9
    /// - 1010: AINP = AVDD
    /// - 1011: AINN = Unconnected
    /// - 1100: AINN = Unconnected
    /// - 1101: AINN = Unconnected
    /// - 1110: AINN = Unconnected
    /// - 1111: AINN = Unconnected (default)
    typedef enum MAX11410_AINP_SEL_enum_t {
        AINP_SEL_0000_AIN0 = 0x00, //!< 8'b00000000
        AINP_SEL_0001_AIN1 = 0x01, //!< 8'b00000001
        AINP_SEL_0010_AIN2 = 0x02, //!< 8'b00000010
        AINP_SEL_0011_AIN3 = 0x03, //!< 8'b00000011
        AINP_SEL_0100_AIN4 = 0x04, //!< 8'b00000100
        AINP_SEL_0101_AIN5 = 0x05, //!< 8'b00000101
        AINP_SEL_0110_AIN6 = 0x06, //!< 8'b00000110
        AINP_SEL_0111_AIN7 = 0x07, //!< 8'b00000111
        AINP_SEL_1000_AIN8 = 0x08, //!< 8'b00001000
        AINP_SEL_1001_AIN9 = 0x09, //!< 8'b00001001
        AINP_SEL_1010_AVDD = 0x0a, //!< 8'b00001010
        AINP_SEL_1011_unconnected = 0x0b, //!< 8'b00001011
        AINP_SEL_1100_unconnected = 0x0c, //!< 8'b00001100
        AINP_SEL_1101_unconnected = 0x0d, //!< 8'b00001101
        AINP_SEL_1110_unconnected = 0x0e, //!< 8'b00001110
        AINP_SEL_1111_unconnected = 0x0f, //!< 8'b00001111
    } MAX11410_AINP_SEL_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_AINN_SEL_enum_t
    //----------------------------------------
    /// Input multiplexer channel selection
    /// CMD_r000_1011_dddd_dddd_MUX_CTRL0 field AINP_SEL[3:0]
    ///
    /// - 0000: AINN = AIN0
    /// - 0001: AINN = AIN1
    /// - 0010: AINN = AIN2
    /// - 0011: AINN = AIN3
    /// - 0100: AINN = AIN4
    /// - 0101: AINN = AIN5
    /// - 0110: AINN = AIN6
    /// - 0111: AINN = AIN7
    /// - 1000: AINN = AIN8
    /// - 1001: AINN = AIN9
    /// - 1010: AINN = GND
    /// - 1011: AINN = Unconnected
    /// - 1100: AINN = Unconnected
    /// - 1101: AINN = Unconnected
    /// - 1110: AINN = Unconnected
    /// - 1111: AINN = Unconnected (default)
    typedef enum MAX11410_AINN_SEL_enum_t {
        AINN_SEL_0000_AIN0 = 0x00, //!< 8'b00000000
        AINN_SEL_0001_AIN1 = 0x01, //!< 8'b00000001
        AINN_SEL_0010_AIN2 = 0x02, //!< 8'b00000010
        AINN_SEL_0011_AIN3 = 0x03, //!< 8'b00000011
        AINN_SEL_0100_AIN4 = 0x04, //!< 8'b00000100
        AINN_SEL_0101_AIN5 = 0x05, //!< 8'b00000101
        AINN_SEL_0110_AIN6 = 0x06, //!< 8'b00000110
        AINN_SEL_0111_AIN7 = 0x07, //!< 8'b00000111
        AINN_SEL_1000_AIN8 = 0x08, //!< 8'b00001000
        AINN_SEL_1001_AIN9 = 0x09, //!< 8'b00001001
        AINN_SEL_1010_GND = 0x0a, //!< 8'b00001010
        AINN_SEL_1011_unconnected = 0x0b, //!< 8'b00001011
        AINN_SEL_1100_unconnected = 0x0c, //!< 8'b00001100
        AINN_SEL_1101_unconnected = 0x0d, //!< 8'b00001101
        AINN_SEL_1110_unconnected = 0x0e, //!< 8'b00001110
        AINN_SEL_1111_unconnected = 0x0f, //!< 8'b00001111
    } MAX11410_AINN_SEL_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_IDAC1_SEL_enum_t
    //----------------------------------------
    /// Input multiplexer channel selection
    /// CMD_r000_1100_dddd_dddd_MUX_CTRL1 field IDAC1_SEL[3:0]
    ///
    /// - 0000: AIN0
    /// - 0001: AIN1
    /// - 0010: AIN2
    /// - 0011: AIN3
    /// - 0100: AIN4
    /// - 0101: AIN5
    /// - 0110: AIN6
    /// - 0111: AIN7
    /// - 1000: AIN8
    /// - 1001: AIN9
    /// - 1010: Unconnected; IDAC1 powered down.
    /// - 1011: Unconnected; IDAC1 powered down.
    /// - 1100: Unconnected; IDAC1 powered down.
    /// - 1101: Unconnected; IDAC1 powered down.
    /// - 1110: Unconnected; IDAC1 powered down.
    /// - 1111: Unconnected; IDAC1 powered down.(Default)
    typedef enum MAX11410_IDAC1_SEL_enum_t {
        IDAC1_SEL_0000_AIN0 = 0x00, //!< 8'b00000000
        IDAC1_SEL_0001_AIN1 = 0x01, //!< 8'b00000001
        IDAC1_SEL_0010_AIN2 = 0x02, //!< 8'b00000010
        IDAC1_SEL_0011_AIN3 = 0x03, //!< 8'b00000011
        IDAC1_SEL_0100_AIN4 = 0x04, //!< 8'b00000100
        IDAC1_SEL_0101_AIN5 = 0x05, //!< 8'b00000101
        IDAC1_SEL_0110_AIN6 = 0x06, //!< 8'b00000110
        IDAC1_SEL_0111_AIN7 = 0x07, //!< 8'b00000111
        IDAC1_SEL_1000_AIN8 = 0x08, //!< 8'b00001000
        IDAC1_SEL_1001_AIN9 = 0x09, //!< 8'b00001001
        IDAC1_SEL_1010_unconnected = 0x0a, //!< 8'b00001010
        IDAC1_SEL_1011_unconnected = 0x0b, //!< 8'b00001011
        IDAC1_SEL_1100_unconnected = 0x0c, //!< 8'b00001100
        IDAC1_SEL_1101_unconnected = 0x0d, //!< 8'b00001101
        IDAC1_SEL_1110_unconnected = 0x0e, //!< 8'b00001110
        IDAC1_SEL_1111_unconnected = 0x0f, //!< 8'b00001111
    } MAX11410_IDAC1_SEL_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_IDAC0_SEL_enum_t
    //----------------------------------------
    /// Input multiplexer channel selection
    /// CMD_r000_1100_dddd_dddd_MUX_CTRL1 field IDAC0_SEL[3:0]
    ///
    /// - 0000: AIN0
    /// - 0001: AIN1
    /// - 0010: AIN2
    /// - 0011: AIN3
    /// - 0100: AIN4
    /// - 0101: AIN5
    /// - 0110: AIN6
    /// - 0111: AIN7
    /// - 1000: AIN8
    /// - 1001: AIN9
    /// - 1010: Unconnected; IDAC0 powered down.
    /// - 1011: Unconnected; IDAC0 powered down.
    /// - 1100: Unconnected; IDAC0 powered down.
    /// - 1101: Unconnected; IDAC0 powered down.
    /// - 1110: Unconnected; IDAC0 powered down.
    /// - 1111: Unconnected; IDAC0 powered down.(Default)
    typedef enum MAX11410_IDAC0_SEL_enum_t {
        IDAC0_SEL_0000_AIN0 = 0x00, //!< 8'b00000000
        IDAC0_SEL_0001_AIN1 = 0x01, //!< 8'b00000001
        IDAC0_SEL_0010_AIN2 = 0x02, //!< 8'b00000010
        IDAC0_SEL_0011_AIN3 = 0x03, //!< 8'b00000011
        IDAC0_SEL_0100_AIN4 = 0x04, //!< 8'b00000100
        IDAC0_SEL_0101_AIN5 = 0x05, //!< 8'b00000101
        IDAC0_SEL_0110_AIN6 = 0x06, //!< 8'b00000110
        IDAC0_SEL_0111_AIN7 = 0x07, //!< 8'b00000111
        IDAC0_SEL_1000_AIN8 = 0x08, //!< 8'b00001000
        IDAC0_SEL_1001_AIN9 = 0x09, //!< 8'b00001001
        IDAC0_SEL_1010_unconnected = 0x0a, //!< 8'b00001010
        IDAC0_SEL_1011_unconnected = 0x0b, //!< 8'b00001011
        IDAC0_SEL_1100_unconnected = 0x0c, //!< 8'b00001100
        IDAC0_SEL_1101_unconnected = 0x0d, //!< 8'b00001101
        IDAC0_SEL_1110_unconnected = 0x0e, //!< 8'b00001110
        IDAC0_SEL_1111_unconnected = 0x0f, //!< 8'b00001111
    } MAX11410_IDAC0_SEL_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_SIG_PATH_enum_t
    //----------------------------------------
    /// Input multiplexer channel selection
    /// CMD_r000_1110_xxdd_xddd_PGA field SIG_PATH[1:0]
    ///
    /// - 00: Buffered, low-power, unity-gain path (PGA disabled, digital gain) [default]
    /// - 01: Bypass path (signal buffer disabled,PGA disabled, digital gain)
    /// - 10: PGA path (signal buffer disabled, analog gain)
    /// - 11: Reserved
    typedef enum MAX11410_SIG_PATH_enum_t {
        SIG_PATH_00_BUFFERED = 0x00, //!< 8'b00000000
        SIG_PATH_01_BYPASS = 0x01, //!< 8'b00000001
        SIG_PATH_10_PGA = 0x02, //!< 8'b00000010
        SIG_PATH_11_reserved = 0x03, //!< 8'b00000011
    } MAX11410_SIG_PATH_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_GAIN_enum_t
    //----------------------------------------
    /// Input multiplexer channel selection
    /// CMD_r000_1110_xxdd_xddd_PGA field GAIN[2:0]
    ///
    /// - 000: 1 (default)
    /// - 001: 2
    /// - 010: 4
    /// - 011: 8
    /// - 100: 16
    /// - 101: 32
    /// - 110: 64
    /// - 111: 128
    typedef enum MAX11410_GAIN_enum_t {
        GAIN_000_1 = 0x00, //!< 8'b00000000
        GAIN_001_2 = 0x01, //!< 8'b00000001
        GAIN_010_4 = 0x02, //!< 8'b00000010
        GAIN_011_8 = 0x03, //!< 8'b00000011
        GAIN_100_16 = 0x04, //!< 8'b00000100
        GAIN_101_32 = 0x05, //!< 8'b00000101
        GAIN_110_64 = 0x06, //!< 8'b00000110
        GAIN_111_128 = 0x07, //!< 8'b00000111
    } MAX11410_GAIN_enum_t;

// TODO1: CODE GENERATOR: ic_variant -- IC's supported with this driver
    /**
     * @brief IC's supported with this driver
     * @details MAX11410
     */
    typedef enum
    {
        MAX11410_IC = 0,
        //MAX11410_IC = 1
    } MAX11410_ic_t;

// TODO1: CODE GENERATOR: class constructor declaration
    /**********************************************************//**
    * @brief Constructor for MAX11410 Class.
    *
    * @details Requires an existing SPI object as well as a DigitalOut object.
    * The DigitalOut object is used for a chip enable signal
    *
    * On Entry:
    *     @param[in] spi - pointer to existing SPI object
    *     @param[in] cs_pin - pointer to a DigitalOut pin object
    *     CODE GENERATOR: class constructor docstrings gpio InputPin pins
    *     CODE GENERATOR: class constructor docstrings gpio OutputPin pins
    *     @param[in] ic_variant - which type of MAX11410 is used
    *
    * On Exit:
    *
    * @return None
    **************************************************************/
    MAX11410(SPI &spi, DigitalOut &cs_pin, // SPI interface
            // CODE GENERATOR: class constructor declaration gpio InputPin pins
            // CODE GENERATOR: class constructor declaration gpio OutputPin pins
            MAX11410_ic_t ic_variant);

// CODE GENERATOR: class destructor declaration
    /************************************************************
     * @brief Default destructor for MAX11410 Class.
     *
     * @details Destroys SPI object if owner
     *
     * On Entry:
     *
     * On Exit:
     *
     * @return None
     **************************************************************/
    ~MAX11410();

    // CODE GENERATOR: spi_frequency setter declaration
    /// set SPI SCLK frequency
    void spi_frequency(int spi_sclk_Hz);

//----------------------------------------
// CODE GENERATOR: omit typedef enum MAX11410_device_t, class members instead of global device object
public:

    /// reference voltage, in Volts
    double VRef;

    /// shadow of register CMD_r011_1000_dddd_dddd_dddd_dddd_dxxx_dddd_STATUS
    uint32_t status;

    /// shadow of register CMD_r011_0000_dddd_dddd_dddd_dddd_dddd_dddd_DATA0
    uint32_t data0;

// CODE GENERATOR: omit global g_MAX11410_device

// CODE GENERATOR: extern function declarations
// CODE GENERATOR: extern function declaration SPIoutputCS
//----------------------------------------
// Assert SPI Chip Select
// SPI chip-select for MAX11410
//
    void SPIoutputCS(int isLogicHigh);

// CODE GENERATOR: extern function declaration SPIwrite16bits
//----------------------------------------
// SPI write 16 bits
// SPI interface to MAX11410 shift 16 bits mosiData into MAX11410 DIN
//
    void SPIwrite16bits(int16_t mosiData16);

// CODE GENERATOR: extern function declaration SPIreadWrite16bits
//----------------------------------------
// SPI read and write 16 bits
// SPI interface to MAX11410 shift 16 bits mosiData16 into MAX11410 DIN
// while simultaneously capturing 16 bits miso data from MAX11410 DOUT
//
    int16_t SPIreadWrite16bits(int16_t mosiData16);

// CODE GENERATOR: extern function declaration SPIreadWrite32bits
//----------------------------------------
// SPI read and write 32 bits
// SPI interface to MAX11410 shift 32 bits mosiData into MAX11410 DIN
// while simultaneously capturing 32 bits miso data from MAX11410 DOUT
//
    int32_t SPIreadWrite32bits(int32_t mosiData32);

// CODE GENERATOR: class member data
private:
// CODE GENERATOR: class member data for SPI interface
    // SPI object
    SPI &m_spi;
    int m_SPI_SCLK_Hz;
    int m_SPI_dataMode;
    int m_SPI_cs_state;

    // Selector pin object
    DigitalOut &m_cs_pin;

// CODE GENERATOR: class member data for gpio InputPin pins
// CODE GENERATOR: class member data for gpio OutputPin pins

    // Identifies which IC variant is being used
    MAX11410_ic_t m_ic_variant;

public:

// CODE GENERATOR: class member function declarations
    //----------------------------------------
    /// Initialize device
    /// @return 1 on success; 0 on failure
    uint8_t Init(void);

    //----------------------------------------
    /// Return the physical voltage corresponding to DAC register.
    /// Does not perform any offset or gain correction.
    ///
    /// @pre g_MAX11410_device.VRef = Voltage of REF input, in Volts
    /// @param[in] value_u24: raw 24-bit MAX11410 code (right justified).
    /// @return physical voltage corresponding to MAX11410 code.
    double VoltageOfCode(uint16_t value_u24);

    //----------------------------------------
    /// Write an 8-bit MAX11410 register
    ///
    /// CMD_1aaa_aaaa_REGISTER_READ bit is cleared 0.
    ///
    /// SPI 16-bit transfer
    ///
    /// SPI MOSI = 0aaa_aaaa_dddd_dddd
    ///
    /// SPI MISO = xxxx_xxxx_xxxx_xxxx
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Write_8bit(MAX11410_CMD_enum_t regAddress, uint8_t regData);

    //----------------------------------------
    /// Read an 8-bit MAX11410 register
    ///
    /// CMD_1aaa_aaaa_REGISTER_READ bit is set 1.
    ///
    /// SPI 16-bit transfer
    ///
    /// SPI MOSI = 1aaa_aaaa_0000_0000
    ///
    /// SPI MISO = xxxx_xxxx_dddd_dddd
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Read_8bit(MAX11410_CMD_enum_t regAddress, uint8_t* ptrRegData);

    //----------------------------------------
    /// Write a 16-bit MAX11410 register
    ///
    /// CMD_1aaa_aaaa_REGISTER_READ bit is cleared 0.
    ///
    /// SPI 24-bit transfer
    ///
    /// SPI MOSI = 0aaa_aaaa_dddd_dddd_dddd_dddd
    ///
    /// SPI MISO = xxxx_xxxx_xxxx_xxxx_xxxx_xxxx
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Write_16bit(MAX11410_CMD_enum_t regAddress, uint16_t regData);

    //----------------------------------------
    /// Read a 16-bit MAX11410 register
    ///
    /// CMD_1aaa_aaaa_REGISTER_READ bit is set 1.
    ///
    /// SPI 24-bit transfer
    ///
    /// SPI MOSI = 1aaa_aaaa_0000_0000_0000_0000
    ///
    /// SPI MISO = xxxx_xxxx_dddd_dddd_dddd_dddd
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Read_16bit(MAX11410_CMD_enum_t regAddress, uint16_t* ptrRegData);

    //----------------------------------------
    /// Write a 24-bit MAX11410 register
    ///
    /// CMD_1aaa_aaaa_REGISTER_READ bit is cleared 0.
    ///
    /// SPI 32-bit transfer
    ///
    /// SPI MOSI = 0aaa_aaaa_dddd_dddd_dddd_dddd_dddd_dddd
    ///
    /// SPI MISO = xxxx_xxxx_xxxx_xxxx_xxxx_xxxx_xxxx_xxxx
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Write_24bit(MAX11410_CMD_enum_t regAddress, uint32_t regData);

    //----------------------------------------
    /// Read a 24-bit MAX11410 register
    ///
    /// CMD_1aaa_aaaa_REGISTER_READ bit is set 1.
    ///
    /// SPI 32-bit transfer
    ///
    /// SPI MOSI = 1aaa_aaaa_0000_0000_0000_0000_0000_0000
    ///
    /// SPI MISO = xxxx_xxxx_dddd_dddd_dddd_dddd_dddd_dddd
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Read_24bit(MAX11410_CMD_enum_t regAddress, uint32_t* ptrRegData);

    //----------------------------------------
    /// Configure Measurement for voltage input.
    ///
    /// Example code for typical voltage measurement.
    ///
    /// SPI register write sequence test AIN0-AGND voltage input using REF2=2.5V
    /// write8 0x00 PD = 0x03 (Reset Registers; enter Standby mode)
    /// write8 0x00 PD = 0x00 (NOP)
    /// write8 0x08 FILTER = 0x34 to select RATE_0100, LINEF_11_SINC4 60SPS (given CONV_TYPE_01_Continuous )
    /// write8 0x0B MUX_CTRL0 = 0x0A to select AINP=AIN0 and AINN=GND
    /// write8 0x09 CTRL = 0x02 to select reference REF2P/REF2N; or CTRL = 0x1A to select reference REF2P/REF2N with reference input buffers enabled; Data Format = Bipolar 2's Complement
    /// write8 0x0E PGA = 0x00 to select input path = Buffers, digital gain = 1V/V
    /// write8 0x01 CONV_START = 0x01 to set Conversion Mode = Continuous
    /// read24 0x80|0x38 STATUS (%SW 0xB8 0 0 0)
    /// read24 0x80|0x30 DATA0 (%SW 0xB0 0 0 0)
    ///
    /// @param[in] channel_hi = channel high side
    /// @param[in] channel_lo = channel low side
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Configure_Voltage(MAX11410_AINP_SEL_enum_t channel_hi, MAX11410_AINN_SEL_enum_t channel_lo);

    //----------------------------------------
    /// Trigger Measurement for voltage input.
    ///
    /// Example code for typical voltage measurement.
    ///
    /// @param[in] channel_hi = channel high side
    /// @param[in] channel_lo = channel low side
    /// @post TODO: where does the measurement go? struct member?
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Measure_Voltage(MAX11410_AINP_SEL_enum_t channel_hi, MAX11410_AINN_SEL_enum_t channel_lo);

    //----------------------------------------
    /// Configure Measurement for Resistive Temperature Device (RTD).
    ///
    /// Example code for typical RTD measurement.
    ///
    /// @param[in] channel_RTD_Force = channel RTD high side force
    /// @param[in] channel_RTD_Hi = channel RTD high side sense
    /// @param[in] channel_RTD_Lo = channel RTD low side
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Configure_RTD(MAX11410_AINP_SEL_enum_t channel_RTD_Force, MAX11410_AINP_SEL_enum_t channel_RTD_Hi, MAX11410_AINN_SEL_enum_t channel_RTD_Lo);

    //----------------------------------------
    /// Trigger Measurement for Resistive Temperature Device (RTD).
    ///
    /// Example code for typical RTD measurement.
    ///
    /// @param[in] channel_RTD_Force = channel RTD high side force
    /// @param[in] channel_RTD_Hi = channel RTD high side sense
    /// @param[in] channel_RTD_Lo = channel RTD low side
    /// @post TODO: where does the measurement go? struct member?
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Measure_RTD(MAX11410_AINP_SEL_enum_t channel_RTD_Force, MAX11410_AINP_SEL_enum_t channel_RTD_Hi, MAX11410_AINN_SEL_enum_t channel_RTD_Lo);

    //----------------------------------------
    /// Configure Measurement for Thermocouple
    ///
    /// Example code for typical Thermocouple measurement.
    ///
    /// @param[in] channel_TC_Hi = channel of Thermocouple high side
    /// @param[in] channel_TC_Lo = channel of Thermocouple low side
    /// @param[in] channel_RTD_Hi = channel of cold junction RTD high side
    /// @param[in] channel_RTD_Lo = channel of cold junction RTD low side
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Configure_Thermocouple(MAX11410_AINP_SEL_enum_t channel_TC_Hi, MAX11410_AINN_SEL_enum_t channel_TC_Lo, MAX11410_AINP_SEL_enum_t channel_RTD_Hi, MAX11410_AINP_SEL_enum_t channel_RTD_Lo);

    //----------------------------------------
    /// Trigger Measurement for Thermocouple
    ///
    /// Example code for typical Thermocouple measurement.
    ///
    /// @param[in] channel_TC_Hi = channel of Thermocouple high side
    /// @param[in] channel_TC_Lo = channel of Thermocouple low side
    /// @param[in] channel_RTD_Hi = channel of cold junction RTD high side
    /// @param[in] channel_RTD_Lo = channel of cold junction RTD low side
    /// @post TODO: where does the measurement go? struct member?
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Measure_Thermocouple(MAX11410_AINP_SEL_enum_t channel_TC_Hi, MAX11410_AINN_SEL_enum_t channel_TC_Lo, MAX11410_AINP_SEL_enum_t channel_RTD_Hi, MAX11410_AINP_SEL_enum_t channel_RTD_Lo);

}; // end of class MAX11410

#endif // __MAX11410_H__

// End of file
