﻿// /*******************************************************************************
// * Copyright (C) 2019 Maxim Integrated Products, Inc., All Rights Reserved.
// *
// * Permission is hereby granted, free of charge, to any person obtaining a
// * copy of this software and associated documentation files (the "Software"),
// * to deal in the Software without restriction, including without limitation
// * the rights to use, copy, modify, merge, publish, distribute, sublicense,
// * and/or sell copies of the Software, and to permit persons to whom the
// * Software is furnished to do so, subject to the following conditions:
// *
// * The above copyright notice and this permission notice shall be included
// * in all copies or substantial portions of the Software.
// *
// * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
// * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// * OTHER DEALINGS IN THE SOFTWARE.
// *
// * Except as contained in this notice, the name of Maxim Integrated
// * Products, Inc. shall not be used except as stated in the Maxim Integrated
// * Products, Inc. Branding Policy.
// *
// * The mere transfer of this software does not imply any licenses
// * of trade secrets, proprietary technology, copyrights, patents,
// * trademarks, maskwork rights, or any other form of intellectual
// * property whatsoever. Maxim Integrated Products, Inc. retains all
// * ownership rights.
// *******************************************************************************
// */
// *********************************************************************
// @file MAX11410.cpp
// *********************************************************************
// Device Driver file
// DO NOT EDIT; except areas designated "CUSTOMIZE". Automatically generated file.
// generated by XMLSystemOfDevicesToMBED.py
// System Name = ExampleSystem
// System Description = Device driver example

#include "MAX11410.h"

// Device Name = MAX11410
// Device Description = 1.9ksps, Low-Power, Serial SPI 24-Bit, 10-Channel, Differential/Single-Ended Input, SAR ADC
// Device Manufacturer = Maxim Integrated
// Device PartNumber = MAX11410ATI+
// Device RegValue_Width = DataWidth16bit_HL
//
// SPI CS = ActiveLow
// SPI FrameStart = CS
// SPI CPOL = 0
// SPI CPHA = 0
// SPI MOSI and MISO Data are both stable on Rising edge of SCLK
// SPI SCLK Idle Low
// SPI SCLKMaxMHz = 8
// SPI SCLKMinMHz = 0
//

// CODE GENERATOR: class constructor definition
MAX11410::MAX11410(SPI &spi, DigitalOut &cs_pin, // SPI interface
                 // CODE GENERATOR: class constructor definition gpio InputPin pins
                 // CODE GENERATOR: class constructor definition gpio OutputPin pins
                 // CODE GENERATOR: class constructor definition ic_variant
                 MAX11410_ic_t ic_variant)
    // CODE GENERATOR: class constructor initializer list
    : m_spi(spi), m_cs_pin(cs_pin), // SPI interface
    // CODE GENERATOR: class constructor initializer list gpio InputPin pins
    // CODE GENERATOR: class constructor initializer list gpio OutputPin pins
    // CODE GENERATOR: class constructor initializer list ic_variant
    m_ic_variant(ic_variant)
{
    // CODE GENERATOR: class constructor definition SPI interface initialization
    //
    // SPI CS = ActiveLow
    // SPI FrameStart = CS
    m_SPI_cs_state = 1;
    m_cs_pin = m_SPI_cs_state;

    // SPI CPOL = 0
    // SPI CPHA = 0
    // SPI MOSI and MISO Data are both stable on Rising edge of SCLK
    // SPI SCLK Idle Low
    m_SPI_dataMode = 0; //SPI_MODE0 // CPOL=0,CPHA=0: Rising Edge stable; SCLK idle Low
    m_spi.format(8,m_SPI_dataMode);         // int bits_must_be_8, int mode=0_3 CPOL=0,CPHA=0

    // SPI SCLKMaxMHz = 8
    // SPI SCLKMinMHz = 0
    //#define SPI_SCLK_Hz 48000000 // 48MHz
    //#define SPI_SCLK_Hz 24000000 // 24MHz
    //#define SPI_SCLK_Hz 12000000 // 12MHz
    //#define SPI_SCLK_Hz 4000000 // 4MHz
    //#define SPI_SCLK_Hz 2000000 // 2MHz
    //#define SPI_SCLK_Hz 1000000 // 1MHz
    m_SPI_SCLK_Hz = 8000000; // 8MHz; MAX11410 limit is 8MHz
    m_spi.frequency(m_SPI_SCLK_Hz);

}

// CODE GENERATOR: class destructor definition
MAX11410::~MAX11410()
{
    // do nothing
}

// CODE GENERATOR: spi_frequency setter definition
/// set SPI SCLK frequency
void MAX11410::spi_frequency(int spi_sclk_Hz)
{
    m_SPI_SCLK_Hz = spi_sclk_Hz;
    m_spi.frequency(m_SPI_SCLK_Hz);
}

// CODE GENERATOR: omit global g_MAX11410_device
// CODE GENERATOR: extern function declarations
// CODE GENERATOR: extern function requirement MAX11410::SPIoutputCS
// Assert SPI Chip Select
// SPI chip-select for MAX11410
//
void MAX11410::SPIoutputCS(int isLogicHigh)
{
    // CODE GENERATOR: extern function definition for function SPIoutputCS
    // CODE GENERATOR: extern function definition for standard SPI interface function SPIoutputCS(int isLogicHigh)
    m_SPI_cs_state = isLogicHigh;
    m_cs_pin = m_SPI_cs_state;
}

// CODE GENERATOR: extern function requirement MAX11410::SPIwrite16bits
// SPI write 16 bits
// SPI interface to MAX11410 shift 16 bits mosiData into MAX11410 DIN
//
void MAX11410::SPIwrite16bits(int16_t mosiData16)
{
    // CODE GENERATOR: extern function definition for function SPIwrite16bits
    // TODO1: CODE GENERATOR: extern function definition for standard SPI interface function SPIwrite16bits(int16_t mosiData16)
    size_t byteCount = 2;
    static char mosiData[2];
    static char misoData[2];
    mosiData[0] = (char)((mosiData16 >> 8) & 0xFF); // MSByte
    mosiData[1] = (char)((mosiData16 >> 0) & 0xFF); // LSByte
    //
    // Arduino: begin critical section: noInterrupts() masks all interrupt sources; end critical section with interrupts()
    //~ noInterrupts();
    //
    //~ digitalWrite(Scope_Trigger_Pin, LOW); // diagnostic Scope_Trigger_Pin
    //
    unsigned int numBytesTransferred = m_spi.write(mosiData, byteCount, misoData, byteCount);
    //~ m_spi.transfer(mosiData8_FF0000);
    //~ m_spi.transfer(mosiData16_00FF00);
    //~ m_spi.transfer(mosiData16_0000FF);
    //
    //~ digitalWrite(Scope_Trigger_Pin, HIGH); // diagnostic Scope_Trigger_Pin
    //
    // Arduino: begin critical section: noInterrupts() masks all interrupt sources; end critical section with interrupts()
    //~ interrupts();
    //
    // VERIFY: SPIwrite24bits print diagnostic information
    //cmdLine.serial().printf(" MOSI->"));
    //cmdLine.serial().printf(" 0x"));
    //Serial.print( (mosiData8_FF0000 & 0xFF), HEX);
    //cmdLine.serial().printf(" 0x"));
    //Serial.print( (mosiData16_00FF00 & 0xFF), HEX);
    //cmdLine.serial().printf(" 0x"));
    //Serial.print( (mosiData16_0000FF & 0xFF), HEX);
    // hex dump mosiData[0..byteCount-1]
#if 0 // HAS_MICROUSBSERIAL
    cmdLine_microUSBserial.serial().printf("\r\nSPI");
    if (byteCount > 7) {
        cmdLine_microUSBserial.serial().printf(" byteCount:%d", byteCount);
    }
    cmdLine_microUSBserial.serial().printf(" MOSI->");
    for (unsigned int byteIndex = 0; byteIndex < byteCount; byteIndex++)
    {
        cmdLine_microUSBserial.serial().printf(" 0x%2.2X", mosiData[byteIndex]);
    }
    // hex dump misoData[0..byteCount-1]
    cmdLine_microUSBserial.serial().printf("  MISO<-");
    for (unsigned int byteIndex = 0; byteIndex < numBytesTransferred; byteIndex++)
    {
        cmdLine_microUSBserial.serial().printf(" 0x%2.2X", misoData[byteIndex]);
    }
    cmdLine_microUSBserial.serial().printf(" ");
#endif
#if 0 // HAS_DAPLINK_SERIAL
    cmdLine_DAPLINKserial.serial().printf("\r\nSPI");
    if (byteCount > 7) {
        cmdLine_DAPLINKserial.serial().printf(" byteCount:%d", byteCount);
    }
    cmdLine_DAPLINKserial.serial().printf(" MOSI->");
    for (unsigned int byteIndex = 0; byteIndex < byteCount; byteIndex++)
    {
        cmdLine_DAPLINKserial.serial().printf(" 0x%2.2X", mosiData[byteIndex]);
    }
    // hex dump misoData[0..byteCount-1]
    cmdLine_DAPLINKserial.serial().printf("  MISO<-");
    for (unsigned int byteIndex = 0; byteIndex < numBytesTransferred; byteIndex++)
    {
        cmdLine_DAPLINKserial.serial().printf(" 0x%2.2X", misoData[byteIndex]);
    }
    cmdLine_DAPLINKserial.serial().printf(" ");
#endif
    // VERIFY: DIAGNOSTIC: print MAX5715 device register write
    // TODO: MAX5715_print_register_verbose(mosiData8_FF0000, mosiData16_00FFFF);
    // TODO: print_verbose_SPI_diagnostic(mosiData16_FF00, mosiData16_00FF, misoData16_FF00, misoData16_00FF);
    //
    // int misoData16 = (misoData16_FF00 << 8) | misoData16_00FF;
    // return misoData16;
}

// CODE GENERATOR: extern function requirement MAX11410::SPIreadWrite16bits
// SPI read and write 16 bits
// SPI interface to MAX11410 shift 16 bits mosiData16 into MAX11410 DIN
// while simultaneously capturing 16 bits miso data from MAX11410 DOUT
//
int16_t MAX11410::SPIreadWrite16bits(int16_t mosiData16)
{
    // CODE GENERATOR: extern function definition for function SPIreadWrite16bits
    // TODO1: CODE GENERATOR: extern function definition for standard SPI interface function SPIreadWrite16bits(int16_t mosiData16)
    size_t byteCount = 2;
    static char mosiData[2];
    static char misoData[2];
    mosiData[0] = (char)((mosiData16 >> 8) & 0xFF); // MSByte
    mosiData[1] = (char)((mosiData16 >> 0) & 0xFF); // LSByte
    //
    // Arduino: begin critical section: noInterrupts() masks all interrupt sources; end critical section with interrupts()
    //~ noInterrupts();
    //
    //~ digitalWrite(Scope_Trigger_Pin, LOW); // diagnostic Scope_Trigger_Pin
    //
    unsigned int numBytesTransferred = m_spi.write(mosiData, byteCount, misoData, byteCount);
    //~ m_spi.transfer(mosiData8_FF0000);
    //~ m_spi.transfer(mosiData16_00FF00);
    //~ m_spi.transfer(mosiData16_0000FF);
    //
    //~ digitalWrite(Scope_Trigger_Pin, HIGH); // diagnostic Scope_Trigger_Pin
    //
    // Arduino: begin critical section: noInterrupts() masks all interrupt sources; end critical section with interrupts()
    //~ interrupts();
    //
    // VERIFY: SPIwrite24bits print diagnostic information
    //cmdLine.serial().printf(" MOSI->"));
    //cmdLine.serial().printf(" 0x"));
    //Serial.print( (mosiData8_FF0000 & 0xFF), HEX);
    //cmdLine.serial().printf(" 0x"));
    //Serial.print( (mosiData16_00FF00 & 0xFF), HEX);
    //cmdLine.serial().printf(" 0x"));
    //Serial.print( (mosiData16_0000FF & 0xFF), HEX);
    // hex dump mosiData[0..byteCount-1]
#if 0 // HAS_MICROUSBSERIAL
    cmdLine_microUSBserial.serial().printf("\r\nSPI");
    if (byteCount > 7) {
        cmdLine_microUSBserial.serial().printf(" byteCount:%d", byteCount);
    }
    cmdLine_microUSBserial.serial().printf(" MOSI->");
    for (unsigned int byteIndex = 0; byteIndex < byteCount; byteIndex++)
    {
        cmdLine_microUSBserial.serial().printf(" 0x%2.2X", mosiData[byteIndex]);
    }
    // hex dump misoData[0..byteCount-1]
    cmdLine_microUSBserial.serial().printf("  MISO<-");
    for (unsigned int byteIndex = 0; byteIndex < numBytesTransferred; byteIndex++)
    {
        cmdLine_microUSBserial.serial().printf(" 0x%2.2X", misoData[byteIndex]);
    }
    cmdLine_microUSBserial.serial().printf(" ");
#endif
#if 0 // HAS_DAPLINK_SERIAL
    cmdLine_DAPLINKserial.serial().printf("\r\nSPI");
    if (byteCount > 7) {
        cmdLine_DAPLINKserial.serial().printf(" byteCount:%d", byteCount);
    }
    cmdLine_DAPLINKserial.serial().printf(" MOSI->");
    for (unsigned int byteIndex = 0; byteIndex < byteCount; byteIndex++)
    {
        cmdLine_DAPLINKserial.serial().printf(" 0x%2.2X", mosiData[byteIndex]);
    }
    // hex dump misoData[0..byteCount-1]
    cmdLine_DAPLINKserial.serial().printf("  MISO<-");
    for (unsigned int byteIndex = 0; byteIndex < numBytesTransferred; byteIndex++)
    {
        cmdLine_DAPLINKserial.serial().printf(" 0x%2.2X", misoData[byteIndex]);
    }
    cmdLine_DAPLINKserial.serial().printf(" ");
#endif
    // VERIFY: DIAGNOSTIC: print MAX5715 device register write
    // TODO: MAX5715_print_register_verbose(mosiData8_FF0000, mosiData16_00FFFF);
    // TODO: print_verbose_SPI_diagnostic(mosiData16_FF00, mosiData16_00FF, misoData16_FF00, misoData16_00FF);
    //
    //int misoData16 = (misoData16_FF00 << 8) | misoData16_00FF;
    int misoData16 = (misoData[0] << 8) | misoData[1];
    return misoData16;
}

// CODE GENERATOR: extern function requirement MAX11410::SPIreadWrite32bits
// SPI read and write 32 bits
// SPI interface to MAX11410 shift 32 bits mosiData into MAX11410 DIN
// while simultaneously capturing 32 bits miso data from MAX11410 DOUT
//
int32_t MAX11410::SPIreadWrite32bits(int32_t mosiData32)
{
    // CODE GENERATOR: extern function definition for function SPIreadWrite32bits
    // TODO1: CODE GENERATOR: extern function definition for standard SPI interface function SPIreadWrite32bits(int32_t mosiData32)
    size_t byteCount = 4;
    static char mosiData[4];
    static char misoData[4];
    mosiData[0] = (char)((mosiData32 >> 24) & 0xFF); // MSByte
    mosiData[1] = (char)((mosiData32 >> 16) & 0xFF);
    mosiData[2] = (char)((mosiData32 >>  8) & 0xFF);
    mosiData[3] = (char)((mosiData32 >>  0) & 0xFF); // LSByte
    //
    // Arduino: begin critical section: noInterrupts() masks all interrupt sources; end critical section with interrupts()
    //~ noInterrupts();
    //
    //~ digitalWrite(Scope_Trigger_Pin, LOW); // diagnostic Scope_Trigger_Pin
    //
    unsigned int numBytesTransferred = m_spi.write(mosiData, byteCount, misoData, byteCount);
    //~ m_spi.transfer(mosiData8_FF0000);
    //~ m_spi.transfer(mosiData16_00FF00);
    //~ m_spi.transfer(mosiData16_0000FF);
    //
    //~ digitalWrite(Scope_Trigger_Pin, HIGH); // diagnostic Scope_Trigger_Pin
    //
    // Arduino: begin critical section: noInterrupts() masks all interrupt sources; end critical section with interrupts()
    //~ interrupts();
    //
    // VERIFY: SPIwrite24bits print diagnostic information
    //cmdLine.serial().printf(" MOSI->"));
    //cmdLine.serial().printf(" 0x"));
    //Serial.print( (mosiData8_FF0000 & 0xFF), HEX);
    //cmdLine.serial().printf(" 0x"));
    //Serial.print( (mosiData16_00FF00 & 0xFF), HEX);
    //cmdLine.serial().printf(" 0x"));
    //Serial.print( (mosiData16_0000FF & 0xFF), HEX);
    // hex dump mosiData[0..byteCount-1]
#if 0 // HAS_MICROUSBSERIAL
    cmdLine_microUSBserial.serial().printf("\r\nSPI");
    if (byteCount > 7) {
        cmdLine_microUSBserial.serial().printf(" byteCount:%d", byteCount);
    }
    cmdLine_microUSBserial.serial().printf(" MOSI->");
    for (unsigned int byteIndex = 0; byteIndex < byteCount; byteIndex++)
    {
        cmdLine_microUSBserial.serial().printf(" 0x%2.2X", mosiData[byteIndex]);
    }
    // hex dump misoData[0..byteCount-1]
    cmdLine_microUSBserial.serial().printf("  MISO<-");
    for (unsigned int byteIndex = 0; byteIndex < numBytesTransferred; byteIndex++)
    {
        cmdLine_microUSBserial.serial().printf(" 0x%2.2X", misoData[byteIndex]);
    }
    cmdLine_microUSBserial.serial().printf(" ");
#endif
#if 0 // HAS_DAPLINK_SERIAL
    cmdLine_DAPLINKserial.serial().printf("\r\nSPI");
    if (byteCount > 7) {
        cmdLine_DAPLINKserial.serial().printf(" byteCount:%d", byteCount);
    }
    cmdLine_DAPLINKserial.serial().printf(" MOSI->");
    for (unsigned int byteIndex = 0; byteIndex < byteCount; byteIndex++)
    {
        cmdLine_DAPLINKserial.serial().printf(" 0x%2.2X", mosiData[byteIndex]);
    }
    // hex dump misoData[0..byteCount-1]
    cmdLine_DAPLINKserial.serial().printf("  MISO<-");
    for (unsigned int byteIndex = 0; byteIndex < numBytesTransferred; byteIndex++)
    {
        cmdLine_DAPLINKserial.serial().printf(" 0x%2.2X", misoData[byteIndex]);
    }
    cmdLine_DAPLINKserial.serial().printf(" ");
#endif
    // VERIFY: DIAGNOSTIC: print MAX5715 device register write
    // TODO: MAX5715_print_register_verbose(mosiData8_FF0000, mosiData16_00FFFF);
    // TODO: print_verbose_SPI_diagnostic(mosiData16_FF00, mosiData16_00FF, misoData16_FF00, misoData16_00FF);
    //
    //int misoData32 = (misoData32_FF000000 << 24) | (misoData32_FF0000 << 16) | (misoData32_0000FF00 << 8) | misoData32_000000FF;
    int misoData32 = (misoData[0] << 24) | (misoData[1] << 16) | (misoData[2] << 8) | misoData[3];
    return misoData32;
}

// CODE GENERATOR: class member function definitions
//----------------------------------------
// Initialize device
// @return 1 on success; 0 on failure
uint8_t MAX11410::Init(void)
{
    
    //----------------------------------------
    // Nominal Full-Scale Voltage Reference
    VRef = 2.500;
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Return the physical voltage corresponding to DAC register.
// Does not perform any offset or gain correction.
//
// @pre VRef = Voltage of REF input, in Volts
// @param[in] value_u24: raw 24-bit MAX11410 code (right justified).
// @return physical voltage corresponding to MAX11410 code.
double MAX11410::VoltageOfCode(uint16_t value_u24)
{
    
    //----------------------------------------
    // Linear map min and max endpoints
    double MaxScaleVoltage = VRef; // voltage of maximum code 0xffffff
    double MinScaleVoltage = 0.0; // voltage of minimum code 0x000
    const uint16_t FULL_SCALE_CODE_24BIT = 0xffffff;
    const uint16_t MaxCode = FULL_SCALE_CODE_24BIT;
    const uint16_t MinCode = 0x000;
    double codeFraction = ((double)value_u24 - MinCode) / (MaxCode - MinCode + 1);
    return MinScaleVoltage + ((MaxScaleVoltage - MinScaleVoltage) * codeFraction);
}

//----------------------------------------
// Write an 8-bit MAX11410 register
//
// CMD_1aaa_aaaa_REGISTER_READ bit is cleared 0.
//
// SPI 16-bit transfer
//
// SPI MOSI = 0aaa_aaaa_dddd_dddd
//
// SPI MISO = xxxx_xxxx_xxxx_xxxx
//
// @return 1 on success; 0 on failure
uint8_t MAX11410::Write_8bit(MAX11410_CMD_enum_t regAddress, uint8_t regData)
{
    
    //----------------------------------------
    // warning -- WIP work in progress
    #warning "Not Implemented Yet: MAX11410::Write_8bit..."
    
    //----------------------------------------
    // SPI write 16-bit mosiData16 and read misoData16
    int16_t mosiData16 = ((int16_t)regAddress << 8) | ((int16_t)regData);
    SPIoutputCS(0);
    SPIwrite16bits(mosiData16);
    SPIoutputCS(1);
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Read an 8-bit MAX11410 register
//
// CMD_1aaa_aaaa_REGISTER_READ bit is set 1.
//
// SPI 16-bit transfer
//
// SPI MOSI = 1aaa_aaaa_0000_0000
//
// SPI MISO = xxxx_xxxx_dddd_dddd
//
// @return 1 on success; 0 on failure
uint8_t MAX11410::Read_8bit(MAX11410_CMD_enum_t regAddress, uint8_t* ptrRegData)
{
    
    //----------------------------------------
    // warning -- WIP work in progress
    #warning "Not Implemented Yet: MAX11410::Read_8bit..."
    
    //----------------------------------------
    // SPI write 16-bit mosiData16 and read misoData16
    int16_t mosiData16 = ((CMD_1aaa_aaaa_REGISTER_READ | (int16_t)regAddress) << 8) | ((int16_t)0);
    SPIoutputCS(0);
    int16_t misoData16 = SPIreadWrite16bits(mosiData16);
    SPIoutputCS(1);
    (*ptrRegData) = (misoData16 & 0x00FF);
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Write a 16-bit MAX11410 register
//
// CMD_1aaa_aaaa_REGISTER_READ bit is cleared 0.
//
// SPI 24-bit transfer
//
// SPI MOSI = 0aaa_aaaa_dddd_dddd_dddd_dddd
//
// SPI MISO = xxxx_xxxx_xxxx_xxxx_xxxx_xxxx
//
// @return 1 on success; 0 on failure
uint8_t MAX11410::Write_16bit(MAX11410_CMD_enum_t regAddress, uint16_t regData)
{
    
    //----------------------------------------
    // warning -- WIP work in progress
    #warning "Not Implemented Yet: MAX11410::Write_16bit..."
    
    //----------------------------------------
    // SPI write 32-bit (24-bit) mosiData32 and read misoData32
    int32_t mosiData32 = ((int32_t)regAddress << 8) | ((int32_t)regData);
    SPIoutputCS(0);
    int32_t misoData32 = SPIreadWrite32bits(mosiData32);
    SPIoutputCS(1);
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Read a 16-bit MAX11410 register
//
// CMD_1aaa_aaaa_REGISTER_READ bit is set 1.
//
// SPI 24-bit transfer
//
// SPI MOSI = 1aaa_aaaa_0000_0000_0000_0000
//
// SPI MISO = xxxx_xxxx_dddd_dddd_dddd_dddd
//
// @return 1 on success; 0 on failure
uint8_t MAX11410::Read_16bit(MAX11410_CMD_enum_t regAddress, uint16_t* ptrRegData)
{
    
    //----------------------------------------
    // warning -- WIP work in progress
    #warning "Not Implemented Yet: MAX11410::Read_16bit..."
    
    //----------------------------------------
    // SPI write 32-bit (24-bit) mosiData32 and read misoData32
    int32_t mosiData32 = ((CMD_1aaa_aaaa_REGISTER_READ | (int32_t)regAddress) << 16);
    SPIoutputCS(0);
    int32_t misoData32 = SPIreadWrite32bits(mosiData32);
    SPIoutputCS(1);
    (*ptrRegData) = (misoData32 & 0x00FFFF);
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Write a 24-bit MAX11410 register
//
// CMD_1aaa_aaaa_REGISTER_READ bit is cleared 0.
//
// SPI 32-bit transfer
//
// SPI MOSI = 0aaa_aaaa_dddd_dddd_dddd_dddd_dddd_dddd
//
// SPI MISO = xxxx_xxxx_xxxx_xxxx_xxxx_xxxx_xxxx_xxxx
//
// @return 1 on success; 0 on failure
uint8_t MAX11410::Write_24bit(MAX11410_CMD_enum_t regAddress, uint32_t regData)
{
    
    //----------------------------------------
    // warning -- WIP work in progress
    #warning "Not Implemented Yet: MAX11410::Write_24bit..."
    
    //----------------------------------------
    // SPI write 32-bit mosiData32 and read misoData32
    int32_t mosiData32 = ((int32_t)regAddress << 24) | ((int32_t)regData & 0x00FFFFFF);
    SPIoutputCS(0);
    SPIreadWrite32bits(mosiData32);
    SPIoutputCS(1);
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Read a 24-bit MAX11410 register
//
// CMD_1aaa_aaaa_REGISTER_READ bit is set 1.
//
// SPI 32-bit transfer
//
// SPI MOSI = 1aaa_aaaa_0000_0000_0000_0000_0000_0000
//
// SPI MISO = xxxx_xxxx_dddd_dddd_dddd_dddd_dddd_dddd
//
// @return 1 on success; 0 on failure
uint8_t MAX11410::Read_24bit(MAX11410_CMD_enum_t regAddress, uint32_t* ptrRegData)
{
    
    //----------------------------------------
    // warning -- WIP work in progress
    #warning "Not Implemented Yet: MAX11410::Read_24bit..."
    
    //----------------------------------------
    // SPI write 32-bit mosiData32 and read misoData32
    int32_t mosiData32 = ((CMD_1aaa_aaaa_REGISTER_READ | (int32_t)regAddress) << 24);
    SPIoutputCS(0);
    int32_t misoData32 = SPIreadWrite32bits(mosiData32);
    SPIoutputCS(1);
    (*ptrRegData) = (misoData32 & 0x00FFFFFF);
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Configure Measurement for voltage input.
//
// Example code for typical voltage measurement.
//
// SPI register write sequence test AIN0-AGND voltage input using REF2=2.5V
// write8 0x00 PD = 0x03 (Reset Registers; enter Standby mode)
// write8 0x00 PD = 0x00 (NOP)
// write8 0x08 FILTER = 0x34 to select RATE_0100, LINEF_11_SINC4 60SPS (given CONV_TYPE_01_Continuous )
// write8 0x0B MUX_CTRL0 = 0x0A to select AINP=AIN0 and AINN=GND
// write8 0x09 CTRL = 0x02 to select reference REF2P/REF2N; or CTRL = 0x1A to select reference REF2P/REF2N with reference input buffers enabled; Data Format = Bipolar 2's Complement
// write8 0x0E PGA = 0x00 to select input path = Buffers, digital gain = 1V/V
// write8 0x01 CONV_START = 0x01 to set Conversion Mode = Continuous
// read24 0x80|0x38 STATUS (%SW 0xB8 0 0 0)
// read24 0x80|0x30 DATA0 (%SW 0xB0 0 0 0)
//
// @param[in] channel_hi = channel high side
// @param[in] channel_lo = channel low side
//
// @return 1 on success; 0 on failure
uint8_t MAX11410::Configure_Voltage(MAX11410_AINP_SEL_enum_t channel_hi, MAX11410_AINN_SEL_enum_t channel_lo)
{
    
    //----------------------------------------
    // warning -- WIP work in progress
    #warning "Not Tested Yet: MAX11410::Configure_Voltage..."
    
    //----------------------------------------
    // write8 0x00 PD = 0x03 (Reset Registers; enter Standby mode)
    Write_8bit(CMD_r000_0000_xxxx_xxdd_PD, PD_11_Reset);
    
    //----------------------------------------
    // write8 0x00 PD = 0x00 (NOP)
    Write_8bit(CMD_r000_0000_xxxx_xxdd_PD, PD_00_Normal);
    
    //----------------------------------------
    // write8 0x08 FILTER = 0x34 to select RATE_0100, LINEF_11_SINC4 60SPS (given CONV_TYPE_01_Continuous)
    Write_8bit(CMD_r000_1000_x0dd_dddd_FILTER, 0x34);
    
    //----------------------------------------
    // write8 0x0B MUX_CTRL0 = 0x0A to select AINP=AIN0 and AINN=GND
    Write_8bit(CMD_r000_1011_dddd_dddd_MUX_CTRL0, 0x0A);
    
    //----------------------------------------
    // write8 0x09 CTRL = 0x02 to select reference REF2P/REF2N; or CTRL = 0x1A to select reference REF2P/REF2N with reference input buffers enabled; Data Format = Bipolar 2's Complement
    Write_8bit(CMD_r000_1001_dddd_dddd_CTRL, 0x02);
    
    //----------------------------------------
    // write8 0x0E PGA = 0x00 to select input path = Buffers, digital gain = 1V/V
    Write_8bit(CMD_r000_1110_xxdd_xddd_PGA, 0x00);
    
    //----------------------------------------
    // write8 0x01 CONV_START = 0x01 to set Conversion Mode = Continuous
    Write_8bit(CMD_r000_0001_xddd_xxdd_CONV_START, 0x01);
    
    //----------------------------------------
    // read24 0x80|0x38 STATUS (%SW 0xB8 0 0 0)
    Read_24bit(CMD_r011_1000_dddd_dddd_dddd_dddd_dxxx_dddd_STATUS, &status);
    
    //----------------------------------------
    // read24 0x80|0x30 DATA0 (%SW 0xB0 0 0 0)
    Read_24bit(CMD_r011_0000_dddd_dddd_dddd_dddd_dddd_dddd_DATA0, &data0);
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Trigger Measurement for voltage input.
//
// Example code for typical voltage measurement.
//
// @param[in] channel_hi = channel high side
// @param[in] channel_lo = channel low side
// @post TODO: where does the measurement go? struct member?
//
// @return 1 on success; 0 on failure
uint8_t MAX11410::Measure_Voltage(MAX11410_AINP_SEL_enum_t channel_hi, MAX11410_AINN_SEL_enum_t channel_lo)
{
    
    //----------------------------------------
    // warning -- WIP work in progress
    #warning "Not Tested Yet: MAX11410::Measure_Voltage..."
    
    //----------------------------------------
    // read24 0x80|0x38 STATUS (%SW 0xB8 0 0 0)
    Read_24bit(CMD_r011_1000_dddd_dddd_dddd_dddd_dxxx_dddd_STATUS, &status);
    
    //----------------------------------------
    // read24 0x80|0x30 DATA0 (%SW 0xB0 0 0 0)
    Read_24bit(CMD_r011_0000_dddd_dddd_dddd_dddd_dddd_dddd_DATA0, &data0);
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Configure Measurement for Resistive Temperature Device (RTD).
//
// Example code for typical RTD measurement.
//
// @param[in] channel_RTD_Force = channel RTD high side force
// @param[in] channel_RTD_Hi = channel RTD high side sense
// @param[in] channel_RTD_Lo = channel RTD low side
//
// @return 1 on success; 0 on failure
uint8_t MAX11410::Configure_RTD(MAX11410_AINP_SEL_enum_t channel_RTD_Force, MAX11410_AINP_SEL_enum_t channel_RTD_Hi, MAX11410_AINN_SEL_enum_t channel_RTD_Lo)
{
    
    //----------------------------------------
    // warning -- WIP work in progress
    #warning "Not Implemented Yet: MAX11410::Configure_RTD..."
    
    //----------------------------------------
    // read24 0x80|0x38 STATUS (%SW 0xB8 0 0 0)
    Read_24bit(CMD_r011_1000_dddd_dddd_dddd_dddd_dxxx_dddd_STATUS, &status);
    
    //----------------------------------------
    // read24 0x80|0x30 DATA0 (%SW 0xB0 0 0 0)
    Read_24bit(CMD_r011_0000_dddd_dddd_dddd_dddd_dddd_dddd_DATA0, &data0);
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Trigger Measurement for Resistive Temperature Device (RTD).
//
// Example code for typical RTD measurement.
//
// @param[in] channel_RTD_Force = channel RTD high side force
// @param[in] channel_RTD_Hi = channel RTD high side sense
// @param[in] channel_RTD_Lo = channel RTD low side
// @post TODO: where does the measurement go? struct member?
//
// @return 1 on success; 0 on failure
uint8_t MAX11410::Measure_RTD(MAX11410_AINP_SEL_enum_t channel_RTD_Force, MAX11410_AINP_SEL_enum_t channel_RTD_Hi, MAX11410_AINN_SEL_enum_t channel_RTD_Lo)
{
    
    //----------------------------------------
    // warning -- WIP work in progress
    #warning "Not Implemented Yet: MAX11410::Measure_RTD..."
    
    //----------------------------------------
    // read24 0x80|0x38 STATUS (%SW 0xB8 0 0 0)
    Read_24bit(CMD_r011_1000_dddd_dddd_dddd_dddd_dxxx_dddd_STATUS, &status);
    
    //----------------------------------------
    // read24 0x80|0x30 DATA0 (%SW 0xB0 0 0 0)
    Read_24bit(CMD_r011_0000_dddd_dddd_dddd_dddd_dddd_dddd_DATA0, &data0);
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Configure Measurement for Thermocouple
//
// Example code for typical Thermocouple measurement.
//
// @param[in] channel_TC_Hi = channel of Thermocouple high side
// @param[in] channel_TC_Lo = channel of Thermocouple low side
// @param[in] channel_RTD_Hi = channel of cold junction RTD high side
// @param[in] channel_RTD_Lo = channel of cold junction RTD low side
//
// @return 1 on success; 0 on failure
uint8_t MAX11410::Configure_Thermocouple(MAX11410_AINP_SEL_enum_t channel_TC_Hi, MAX11410_AINN_SEL_enum_t channel_TC_Lo, MAX11410_AINP_SEL_enum_t channel_RTD_Hi, MAX11410_AINP_SEL_enum_t channel_RTD_Lo)
{
    
    //----------------------------------------
    // warning -- WIP work in progress
    #warning "Not Implemented Yet: MAX11410::Configure_Thermocouple..."
    
    //----------------------------------------
    // read24 0x80|0x38 STATUS (%SW 0xB8 0 0 0)
    Read_24bit(CMD_r011_1000_dddd_dddd_dddd_dddd_dxxx_dddd_STATUS, &status);
    
    //----------------------------------------
    // read24 0x80|0x30 DATA0 (%SW 0xB0 0 0 0)
    Read_24bit(CMD_r011_0000_dddd_dddd_dddd_dddd_dddd_dddd_DATA0, &data0);
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Trigger Measurement for Thermocouple
//
// Example code for typical Thermocouple measurement.
//
// @param[in] channel_TC_Hi = channel of Thermocouple high side
// @param[in] channel_TC_Lo = channel of Thermocouple low side
// @param[in] channel_RTD_Hi = channel of cold junction RTD high side
// @param[in] channel_RTD_Lo = channel of cold junction RTD low side
// @post TODO: where does the measurement go? struct member?
//
// @return 1 on success; 0 on failure
uint8_t MAX11410::Measure_Thermocouple(MAX11410_AINP_SEL_enum_t channel_TC_Hi, MAX11410_AINN_SEL_enum_t channel_TC_Lo, MAX11410_AINP_SEL_enum_t channel_RTD_Hi, MAX11410_AINP_SEL_enum_t channel_RTD_Lo)
{
    
    //----------------------------------------
    // warning -- WIP work in progress
    #warning "Not Implemented Yet: MAX11410::Measure_Thermocouple..."
    
    //----------------------------------------
    // read24 0x80|0x38 STATUS (%SW 0xB8 0 0 0)
    Read_24bit(CMD_r011_1000_dddd_dddd_dddd_dddd_dxxx_dddd_STATUS, &status);
    
    //----------------------------------------
    // read24 0x80|0x30 DATA0 (%SW 0xB0 0 0 0)
    Read_24bit(CMD_r011_0000_dddd_dddd_dddd_dddd_dddd_dddd_DATA0, &data0);
    
    //----------------------------------------
    // success
    return 1;
}


// End of file
