﻿// /*******************************************************************************
// * Copyright (C) 2019 Maxim Integrated Products, Inc., All Rights Reserved.
// *
// * Permission is hereby granted, free of charge, to any person obtaining a
// * copy of this software and associated documentation files (the "Software"),
// * to deal in the Software without restriction, including without limitation
// * the rights to use, copy, modify, merge, publish, distribute, sublicense,
// * and/or sell copies of the Software, and to permit persons to whom the
// * Software is furnished to do so, subject to the following conditions:
// *
// * The above copyright notice and this permission notice shall be included
// * in all copies or substantial portions of the Software.
// *
// * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
// * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// * OTHER DEALINGS IN THE SOFTWARE.
// *
// * Except as contained in this notice, the name of Maxim Integrated
// * Products, Inc. shall not be used except as stated in the Maxim Integrated
// * Products, Inc. Branding Policy.
// *
// * The mere transfer of this software does not imply any licenses
// * of trade secrets, proprietary technology, copyrights, patents,
// * trademarks, maskwork rights, or any other form of intellectual
// * property whatsoever. Maxim Integrated Products, Inc. retains all
// * ownership rights.
// *******************************************************************************
// */

#include "mbed.h"
#include "MAX11410.h"
#include "CmdLine.h"

//--------------------------------------------------
// tolerate AT commands, which may be sent during probe, such as:
//  AT
//  AT+CGMI      -- request manufacturer identification AT+CMGI=?
//  AT+CGMM      -- request manufacturer model
//  AT%IPSYS?
//  ATE0         -- echo disable
//  ATV1         -- verbose result codes OK | ERROR | NO CARRIER
//  AT+CMEE=1
//  ATX4
//  AT&C1
//  ATE0
//  AT+CMEE=1
//  AT+GCAP
//  ATI
//  AT+CPIN?
//  AT+CGMM
#ifndef IGNORE_AT_COMMANDS
#define IGNORE_AT_COMMANDS 1
#endif

extern MAX11410 g_MAX11410_device; // defined in main.cpp

bool MAX11410_menu_onEOLcommandParser(CmdLine & cmdLine)
{
    switch (cmdLine[0])
    {
        // TODO1: MAX11410 main_menu_onEOLcommandParser
        case '0':
        {
           // // recommended for hex command codes 00..0F
           // // placeholder: cmdLine.serial().printf("\r\n 3 ch=? code=? -- CODEnLOADn");
           // uint16_t ch = g_MAX5715_device.channelNumber_0_3;
           // uint16_t code;
           // if (cmdLine.parse_uint16_dec("ch", ch))
           // {
           // }
           // if (cmdLine.parse_uint16_dec("code", code))
           // {
           // }
           // if (cmdLine.parse_flag("xyzzy", g_xyzzy_flag, XYZZY_FLAG))
           // {
           //     isUpdatedSPIConfig = true;
           // }
           // cmdLine.serial().printf("CODEnLOADn ch=%d code=%d", ch, code);
           // //~ MAX5715_CODEnLOADn(ch, code);
           // cmdLine.serial().printf("\r\n placeholder");
            return true; // command was handled by MAX11410
        }
        break;
        case '1':
        {
            // recommended for hex command codes 10..1F
        }
        break;
        case '2':
        {
            // recommended for hex command codes 20..2F
        }
        break;
        case '3':
        {
            // recommended for hex command codes 30..3F
        }
        break;
        case '4':
        {
            // recommended for hex command codes 40..4F
        }
        break;
        case '5':
        {
            // recommended for hex command codes 50..5F
        }
        break;
        case '6':
        {
            // recommended for hex command codes 60..6F
        }
        break;
        case '7':
        {
            // recommended for hex command codes 70..7F
        }
        break;
        case '8':
        {
            // recommended for hex command codes 80..8F
        }
        break;
        case '9':
        {
            // recommended for hex command codes 90..9F
        }
        break;
        case 'a': case 'A':
        {
            // recommended for hex command codes A0..AF
            switch (cmdLine[1])
            {
                case 't': case 'T':
#if IGNORE_AT_COMMANDS
# if HAS_DAPLINK_SERIAL
                    cmdLine_DAPLINKserial.serial().printf("\r\n ignore AT command \"%s\"\r\n", cmdLine.str());
# endif // HAS_DAPLINK_SERIAL
                    // AT command: skip the prompt to avoid confusing modem detector
                    return false; // command not handled
#endif // IGNORE_AT_COMMANDS
            }
        }
        break;
        case 'b': case 'B':
        {
            // recommended for hex command codes B0..BF
        }
        break;
        case 'c': case 'C':
        {
            // recommended for hex command codes C0..CF
            // cmdLine.serial().printf("\r\n CV ch=? ainp=? ainn=? pga=? -- (future) Voltage configuration");
            // cmdLine.serial().printf("\r\n CT -- (future) Thermocouple configuration");
            // cmdLine.serial().printf("\r\n CR -- (future) Resistive Temperature Device (RTD) configuration");
            #warning "Not Implemented Yet: MAX11410 menu C Voltage / Thermocouple / RTD configuration"
        }
        break;
        case 'd': case 'D':
        {
            // recommended for hex command codes D0..DF
        }
        break;
        case 'e': case 'E':
        {
            // recommended for hex command codes E0..EF
        }
        break;
        case 'f': case 'F':
        {
            // recommended for hex command codes F0..FF
        }
        break;
        // case 'g': case 'G':
        // case 'h': case 'H':
        // case 'i': case 'I':
        // case 'j': case 'J':
        // case 'k': case 'K':
        // case 'l': case 'L':
        case 'm': case 'M':
        {
            // cmdLine.serial().printf("\r\n MV -- (future) Voltage measurement");
            // cmdLine.serial().printf("\r\n MT -- (future) Thermocouple measurement");
            // cmdLine.serial().printf("\r\n MR -- (future) RTD measurement");
            #warning "Not Implemented Yet: MAX11410 menu M measure Voltage / Thermocouple / RTD"
        }
        break;
        // case 'n': case 'N':
        // case 'o': case 'O':
        // case 'p': case 'P':
        // case 'q': case 'Q':
        case 'r': case 'R':
        {
            // cmdLine.serial().printf("\r\n R reg=? -- (future) read register");
            #warning "Not Tested Yet: MAX11410 menu R read register"
            uint8_t regAddress; // = g_MAX11410_device.reg; ??
            if (cmdLine.parse_byte_dec("reg", regAddress))
            {
            }
            if (regAddress <= MAX11410::CMD_r001_0000_xxxx_xxxx_WAIT_START)
            {
                // regAddress range 0x00 .. 0x10 are 8-bit registers
                uint8_t regData;
                g_MAX11410_device.Read_8bit((MAX11410::MAX11410_CMD_enum_t)regAddress, &regData);
                cmdLine.serial().printf("r reg=0x%2.2x --> data=0x%2.2x\r\n",
                    regAddress, regData);
            }
            else if (regAddress <= MAX11410::CMD_r011_1001_dddd_dddd_dddd_dddd_dxxd_dddd_STATUS_IE)
            {
                // regAddress range 0x11 .. 0x39 are 24-bit registers
                uint32_t regData;
                g_MAX11410_device.Read_24bit((MAX11410::MAX11410_CMD_enum_t)regAddress, &regData);
                cmdLine.serial().printf("r reg=0x%2.2x --> data=0x%6.6lx\r\n",
                    regAddress, regData);
            }
            else
            {
                // regAddress range 0x3a .. 0x6f are 16-bit registers
                uint16_t regData;
                g_MAX11410_device.Read_16bit((MAX11410::MAX11410_CMD_enum_t)regAddress, &regData);
                cmdLine.serial().printf("r reg=0x%2.2x --> data=0x%4.4x\r\n",
                    regAddress, regData);
            }
            return true; // command was handled by MAX11410
        }
        break;
        case 's': case 'S':
        {
            // cmdLine.serial().printf("\r\n S -- (future) read status register");
            #warning "Not Tested Yet: MAX11410 menu S read status register"
            g_MAX11410_device.Read_24bit(MAX11410::CMD_r011_1000_dddd_dddd_dddd_dddd_dxxx_dddd_STATUS, &g_MAX11410_device.status);
            cmdLine.serial().printf("status=0x%6.6lx\r\n",
                g_MAX11410_device.status);
            return true; // command was handled by MAX11410
        }
        break;
        // case 't': case 'T':
        // case 'u': case 'U':
        // case 'v': case 'V':
        case 'w': case 'W':
        {
            // cmdLine.serial().printf("\r\n W reg=? data=? -- (future) write register");
            #warning "Not Tested Yet: MAX11410 menu W write register"
            uint8_t regAddress; // = g_MAX11410_device.reg; ??
            if (cmdLine.parse_byte_dec("reg", regAddress))
            {
            }
            if (regAddress <= MAX11410::CMD_r001_0000_xxxx_xxxx_WAIT_START)
            {
                // regAddress range 0x00 .. 0x10 are 8-bit registers
                uint8_t regData;
                if (cmdLine.parse_byte_dec("data", regData))
                {
                }
                g_MAX11410_device.Write_8bit((MAX11410::MAX11410_CMD_enum_t)regAddress, regData);
                cmdLine.serial().printf("w reg=0x%2.2x data=0x%2.2x\r\n",
                    regAddress, regData);
            }
            else if (regAddress <= MAX11410::CMD_r011_1001_dddd_dddd_dddd_dddd_dxxd_dddd_STATUS_IE)
            {
                // regAddress range 0x11 .. 0x39 are 24-bit registers
#warning "CmdLine needs to define parse_uint32_dec()"
                //uint32_t regData;
                //if (cmdLine.parse_uint32_dec("data", regData))
                uint16_t regData;
                if (cmdLine.parse_uint16_dec("data", regData))
                {
                }
                g_MAX11410_device.Write_24bit((MAX11410::MAX11410_CMD_enum_t)regAddress, regData);
                cmdLine.serial().printf("w reg=0x%2.2x data=0x%6.6lx\r\n",
                    regAddress, regData);
            }
            else
            {
                // regAddress range 0x3a .. 0x6f are 16-bit registers
                uint16_t regData;
                if (cmdLine.parse_uint16_dec("data", regData))
                {
                }
                g_MAX11410_device.Write_16bit((MAX11410::MAX11410_CMD_enum_t)regAddress, regData);
                cmdLine.serial().printf("w reg=0x%2.2x regData=0x%4.4x\r\n",
                    regAddress, regData);
            }
            // g_MAX11410_device.Write_8bit(MAX11410_CMD_enum_t regAddress, uint8_t regData)
            // g_MAX11410_device.Write_16bit(MAX11410_CMD_enum_t regAddress, uint16_t regData);
            // g_MAX11410_device.Write_24bit(MAX11410_CMD_enum_t regAddress, uint32_t regData);
            return true; // command was handled by MAX11410
        }
        break;
        case 'x': case 'X':
        {
        }
        break;
        case 'y': case 'Y':
        {
        }
        break;
        case 'z': case 'Z':
        {
        }
        break;
        case '~':     // TODO: IGNORE_AT_COMMANDS -- ignore ~~~ modem command
        {
            // TODO: '~' is not recommended for menu commands, interferes with ssh
#if IGNORE_AT_COMMANDS
# if HAS_DAPLINK_SERIAL
            cmdLine_DAPLINKserial.serial().printf("\r\n ignore AT command \"%s\"\r\n", cmdLine.str());
# endif // HAS_DAPLINK_SERIAL
#endif // IGNORE_AT_COMMANDS
        }
        break;
        case '+':     // TODO: IGNORE_AT_COMMANDS -- ignore +++ modem command
        {
#if IGNORE_AT_COMMANDS
# if HAS_DAPLINK_SERIAL
            cmdLine_DAPLINKserial.serial().printf("\r\n ignore AT command \"%s\"\r\n", cmdLine.str());
# endif // HAS_DAPLINK_SERIAL
#endif // IGNORE_AT_COMMANDS
        }
        break;
        case '@':
        {
            // // Menu @ -- print device configuration
            // cmdLine.serial().printf("\r\n @ -- (future) print device configuration");
            #warning "Not Tested Yet: MAX11410 menu @ print device configuration"
            // //
            // print shadow register configuration
            //
            // shadow of write-only register CODE dddd_dddd_dddd_0000
            //~ int16_t CMD_1000_CODE;
            // int index = 0;
            // for (index = 0; index < 4; index++)
            // {
            //     cmdLine.serial().printf("CODE %c=0x%4.4x MAX5715_VoltageOfCode(%d)=%5.3fV\r\n",
            //                             (char)('A' + index),
            //                             (g_MAX5715_device.Shadow_0010_nnnn_CODE[index] & 0xFFFF),
            //                             g_MAX5715_device.CODE[index],
            //                             g_MAX5715_device.VoltageOfCode(g_MAX5715_device.CODE[index])
            //                             );
            // }
            //
            // cmdLine.serial().printf("\r\n");
            //
            //cmdLine.serial().printf("channelNumber_0_3=%d channels_bitmask_DCBA=%d\r\n",
            //                        (g_MAX5715_device.channelNumber_0_3 & 0xFFFF),
            //                        (g_MAX5715_device.channels_bitmask_DCBA & 0xFFFF));
            //
            cmdLine.serial().printf("VRef=%5.6fV\r\n", g_MAX11410_device.VRef);
            // dtostrf width and precision: 2.5V / 2^24 LSB = ______ volts per LSB
            //
            // shadow of register CMD_r011_1000_dddd_dddd_dddd_dddd_dxxx_dddd_STATUS
            cmdLine.serial().printf("status=0x%6.6lx\r\n",
                g_MAX11410_device.status);
            //
            // shadow of register CMD_r011_0000_dddd_dddd_dddd_dddd_dddd_dddd_DATA0
            double voltage_of_data0;
            voltage_of_data0 = g_MAX11410_device.VoltageOfCode(g_MAX11410_device.data0);
            cmdLine.serial().printf("data0=0x%6.6lx=%lu=%ld=%5.6fV\r\n",
                g_MAX11410_device.data0,
                g_MAX11410_device.data0,
                g_MAX11410_device.data0,
                voltage_of_data0);
            //
            return true; // command was handled by MAX11410
        }
        break;
    } // end switch (cmdLine[0])
    return false; // command not handled
} // end bool MAX11410_menu_onEOLcommandParser(CmdLine & cmdLine)
