// /*******************************************************************************
// * Copyright (C) 2020 Maxim Integrated Products, Inc., All Rights Reserved.
// *
// * Permission is hereby granted, free of charge, to any person obtaining a
// * copy of this software and associated documentation files (the "Software"),
// * to deal in the Software without restriction, including without limitation
// * the rights to use, copy, modify, merge, publish, distribute, sublicense,
// * and/or sell copies of the Software, and to permit persons to whom the
// * Software is furnished to do so, subject to the following conditions:
// *
// * The above copyright notice and this permission notice shall be included
// * in all copies or substantial portions of the Software.
// *
// * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
// * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// * OTHER DEALINGS IN THE SOFTWARE.
// *
// * Except as contained in this notice, the name of Maxim Integrated
// * Products, Inc. shall not be used except as stated in the Maxim Integrated
// * Products, Inc. Branding Policy.
// *
// * The mere transfer of this software does not imply any licenses
// * of trade secrets, proprietary technology, copyrights, patents,
// * trademarks, maskwork rights, or any other form of intellectual
// * property whatsoever. Maxim Integrated Products, Inc. retains all
// * ownership rights.
// *******************************************************************************
// */
// CODE GENERATOR: class declaration and docstrings
// CODE GENERATOR: example code includes
// example code includes
// standard include for target platform -- Platform_Include_Boilerplate
#include "mbed.h"
// Platforms:
//   - MAX32625MBED
//      - supports mbed-os-5.11, requires USBDevice library
//      - add https://developer.mbed.org/teams/MaximIntegrated/code/USBDevice/
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - MAX32600MBED
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//      - Windows 10 note:  Don't connect HDK until you are ready to load new firmware into the board.
//   - NUCLEO_F446RE
//      - remove USBDevice library
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - NUCLEO_F401RE
//      - remove USBDevice library
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - MAX32630FTHR
//      - #include "max32630fthr.h"
//      - add http://os.mbed.org/teams/MaximIntegrated/code/max32630fthr/
//      - remove MAX32620FTHR library (if present)
//   - MAX32620FTHR
//      - #include "MAX32620FTHR.h"
//      - remove max32630fthr library (if present)
//      - add https://os.mbed.com/teams/MaximIntegrated/code/MAX32620FTHR/
//      - not tested yet
//   - MAX32625PICO
//      - #include "max32625pico.h"
//      - add https://os.mbed.com/users/switches/code/max32625pico/
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//      - not tested yet
//      - see https://os.mbed.com/users/switches/code/max32625pico/
//      - see https://os.mbed.com/users/switches/code/PICO_board_demo/
//      - see https://os.mbed.com/users/switches/code/PICO_USB_I2C_SPI/
//      - see https://os.mbed.com/users/switches/code/SerialInterface/
//      - Note: To load the MAX32625PICO firmware, hold the button while
//        connecting the USB cable, then copy firmware bin file 
//        to the MAINTENANCE drive.
//      - see https://os.mbed.com/platforms/MAX32625PICO/
//      - see https://os.mbed.com/teams/MaximIntegrated/wiki/MAX32625PICO-Firmware-Updates
//
// end Platform_Include_Boilerplate
#include "MAX11410.h"
#include "CmdLine.h"
#include "MaximTinyTester.h"
// CODE GENERATOR: class declaration statement open

// CODE GENERATOR: Test_Menu externs
#include "MAX11410.h"
extern MAX11410 g_MAX11410_device; // defined in main.cpp

// CODE GENERATOR: build testMenuCommand list
// CODE GENERATOR: build testMenuGlobalArgsDict common/global argument list
// CODE GENERATOR: class member function declarations
// CODE GENERATOR: MAX11410 Command Name = Init (void) --> uint8_t
// CODE GENERATOR: Menu item hint description Menu item '!'
// CODE GENERATOR: Menu item '!' -- Menu item !
// CODE GENERATOR: test menu case '!':
// CODE GENERATOR:           helpString '! -- Init'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Init'
// CODE GENERATOR:           CommandParamIn 'void'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn ''
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
// CODE GENERATOR:           CommandDocTest '@test Init() expect 1'
// CODE GENERATOR:           CommandDocTest '@test group POR // verify initial register values'
// CODE GENERATOR:           CommandDocTest '@test group PORverbose // verify initial register values'
// CODE GENERATOR:           CommandDocTest '@test group PORverbose tinyTester.print("PART_ID value")'
// CODE GENERATOR:           CommandDocTest '@test group POR RegRead(MAX11410::CMD_r001_0001_xxxx_xxxx_xxxx_xxxx_xxxx_xddd_PART_ID, buffer) expect 1 expect-buffer 0x000F02'
// CODE GENERATOR:           CommandDocTest '@test group PORverbose tinyTester.print("POR value 0x04 CMD_r000_0100_dddd_xddd_GP0_CTRL")'
// CODE GENERATOR:           CommandDocTest '@test group POR RegRead(MAX11410::CMD_r000_0100_dddd_xddd_GP0_CTRL, buffer) expect 1 expect-buffer 0x00'
// CODE GENERATOR:           CommandDocTest '@test group PORverbose tinyTester.print("POR value 0x05 CMD_r000_0101_dddd_xddd_GP1_CTRL")'
// CODE GENERATOR:           CommandDocTest '@test group POR RegRead(MAX11410::CMD_r000_0101_dddd_xddd_GP1_CTRL, buffer) expect 1 expect-buffer 0x00'
// CODE GENERATOR:           CommandDocTest '@test group PORverbose tinyTester.print("POR value 0x07 CMD_r000_0111_xddd_dddd_GP_SEQ_ADDR")'
// CODE GENERATOR:           CommandDocTest '@test group POR RegRead(MAX11410::CMD_r000_0111_xddd_dddd_GP_SEQ_ADDR, buffer) expect 1 expect-buffer 0x00003a'
// CODE GENERATOR:           CommandDocTest '@test group PORverbose tinyTester.print("POR value 0x08 CMD_r000_1000_x0dd_dddd_FILTER")'
// CODE GENERATOR:           CommandDocTest '@test group POR RegRead(MAX11410::CMD_r000_1000_x0dd_dddd_FILTER, buffer) expect 1 expect-buffer 0x00'
// CODE GENERATOR:           CommandDocTest '@test group PORverbose tinyTester.print("POR value 0x09 CMD_r000_1001_dddd_dddd_CTRL")'
// CODE GENERATOR:           CommandDocTest '@test group POR RegRead(MAX11410::CMD_r000_1001_dddd_dddd_CTRL, buffer) expect 1 expect-buffer 0x000001'
// CODE GENERATOR:           CommandDocTest '@test group PORverbose tinyTester.print("POR value 0x0a CMD_r000_1010_dddd_dddd_SOURCE")'
// CODE GENERATOR:           CommandDocTest '@test group POR RegRead(MAX11410::CMD_r000_1010_dddd_dddd_SOURCE, buffer) expect 1 expect-buffer 0x00'
// CODE GENERATOR:           CommandDocTest '@test group PORverbose tinyTester.print("POR value 0x0b CMD_r000_1011_dddd_dddd_MUX_CTRL0")'
// CODE GENERATOR:           CommandDocTest '@test group POR RegRead(MAX11410::CMD_r000_1011_dddd_dddd_MUX_CTRL0, buffer) expect 1 expect-buffer 0x0000ff'
// CODE GENERATOR:           CommandDocTest '@test group PORverbose tinyTester.print("POR value 0x0c CMD_r000_1100_dddd_dddd_MUX_CTRL1")'
// CODE GENERATOR:           CommandDocTest '@test group POR RegRead(MAX11410::CMD_r000_1100_dddd_dddd_MUX_CTRL1, buffer) expect 1 expect-buffer 0x0000ff'
// CODE GENERATOR:           CommandDocTest '@test group PORverbose tinyTester.print("POR value 0x0d CMD_r000_1101_dddd_dddd_MUX_CTRL2")'
// CODE GENERATOR:           CommandDocTest '@test group POR RegRead(MAX11410::CMD_r000_1101_dddd_dddd_MUX_CTRL2, buffer) expect 1 expect-buffer 0x00'
// CODE GENERATOR:           CommandDocTest '@test group PORverbose tinyTester.print("POR value 0x0e CMD_r000_1110_00ss_0ggg_PGA")'
// CODE GENERATOR:           CommandDocTest '@test group POR RegRead(MAX11410::CMD_r000_1110_00ss_0ggg_PGA, buffer) expect 1 expect-buffer 0x00'
// CODE GENERATOR:           CommandDocTest '@test group RES1KA2A3TOGND // measure a 1kohm resistor between (AIN2,AIN3) and AGND to verify ref2_v (disabled by default)'
// CODE GENERATOR:           CommandDocTest '@test group RES1KA2A3TOGNDMORE // measure a 1kohm resistor between (AIN2,AIN3) and AGND to verify ref2_v in more detail'
// CODE GENERATOR:           CommandDocTest '@test group RES1KA2A3TOGNDMORE tinyTester.print("measure a 1kohm resistor between (AIN2,AIN3) and AGND to verify ref2_v")'
// CODE GENERATOR:           CommandDocTest '@test group RES1KA2A3TOGND tinyTester.settle_time_msec = 1000 // default 250'
// CODE GENERATOR:           CommandDocTest '@test group RES1KA2A3TOGND RegWrite(0x0C, 0xF3) expect 1 // *mux_ctrl1=0xf3 drives current source from AIN3'
// CODE GENERATOR:           CommandDocTest '@test group RES1KA2A3TOGNDMORE RegWrite(0x0A, 0x03) expect 1 // *source=0x03 idac_mode=100uA, 1k resistor 0.1V'
// CODE GENERATOR:           CommandDocTest '@test group RES1KA2A3TOGNDMORE tinyTester.print("idac_mode=100uA, 1k resistor 0.1V")'
// CODE GENERATOR:           CommandDocTest '@test group RES1KA2A3TOGNDMORE tinyTester.Wait_Output_Settling()'
// CODE GENERATOR:           CommandDocTest '@test group RES1KA2A3TOGNDMORE Measure_Voltage(2,10) expect 0.1'
// CODE GENERATOR:           CommandDocTest '@test group RES1KA2A3TOGNDMORE AINcode[2] expect (uint32_t)337731 within 33773 // idac_mode=100uA, 1k resistor 0.1V'
// CODE GENERATOR:           CommandDocTest '@test group RES1KA2A3TOGNDMORE RegWrite(0x0A, 0x0D) expect 1 // *source=0x0d idac_mode=800uA, 1k resistor 0.8V'
// CODE GENERATOR:           CommandDocTest '@test group RES1KA2A3TOGNDMORE tinyTester.print("idac_mode=800uA, 1k resistor 0.8V")'
// CODE GENERATOR:           CommandDocTest '@test group RES1KA2A3TOGNDMORE tinyTester.Wait_Output_Settling()'
// CODE GENERATOR:           CommandDocTest '@test group RES1KA2A3TOGNDMORE Measure_Voltage(2,10) expect 0.8'
// CODE GENERATOR:           CommandDocTest '@test group RES1KA2A3TOGNDMORE AINcode[2] expect (uint32_t)2724467 within 33773 // idac_mode=800uA, 1k resistor 0.8V'
// CODE GENERATOR:           CommandDocTest '@test group RES1KA2A3TOGND RegWrite(0x0A, 0x0B) expect 1 // *source=0x0b idac_mode=400uA, 1k resistor 0.4V'
// CODE GENERATOR:           CommandDocTest '@test group RES1KA2A3TOGNDMORE tinyTester.print("idac_mode=400uA, 1k resistor 0.4V")'
// CODE GENERATOR:           CommandDocTest '@test group RES1KA2A3TOGND tinyTester.Wait_Output_Settling()'
// CODE GENERATOR:           CommandDocTest '@test group RES1KA2A3TOGND Measure_Voltage(2,10) expect 0.4'
// CODE GENERATOR:           CommandDocTest '@test group RES1KA2A3TOGNDMORE AINcode[2] expect (uint32_t)1343163 within 33773 // idac_mode=400uA, 1k resistor 0.4V'
// CODE GENERATOR:           CommandDocTest '@test tinyTester.print("check filter register is writeable")'
// CODE GENERATOR:           CommandDocTest '@test RegWrite(0x08, 0x34) expect 1'
// CODE GENERATOR:           CommandDocTest '@test tinyTester.print("check filter register is readable")'
// CODE GENERATOR:           CommandDocTest '@test RegRead(0x08, buffer) expect 1 expect-buffer 0x34'
// CODE GENERATOR:           CommandDocTest '@test tinyTester.settle_time_msec = 250 // default 250'
// CODE GENERATOR:           CommandDocTest '@test tinyTester.blink_time_msec = 75 // default 75 resume hardware self test'
// CODE GENERATOR:           CommandDocTest '@test tinyTester.input_timeout_time_msec = 250 // default 250'
// CODE GENERATOR:           CommandDocTest '@test tinyTester.settle_time_msec = 20 // default 250'
// CODE GENERATOR:           CommandDocTest '@test tinyTester.blink_time_msec = 20 // quickly speed through the software verification'
// CODE GENERATOR:           CommandDocTest '@test tinyTester.input_timeout_time_msec = 100 // default 250'
// CODE GENERATOR:           CommandDocTest '@test tinyTester.Wait_Output_Settling()'
// CODE GENERATOR: MAX11410 Command Name = VoltageOfCode_Unipolar (uint32_t value_u24) --> double
// CODE GENERATOR: no Menu item hint in description
// CODE GENERATOR: MAX11410 Command Name = VoltageOfCode_Bipolar_OffsetBinary (uint32_t value_u24) --> double
// CODE GENERATOR: no Menu item hint in description
// CODE GENERATOR: MAX11410 Command Name = VoltageOfCode_Bipolar_2sComplement (uint32_t value_u24) --> double
// CODE GENERATOR: no Menu item hint in description
// CODE GENERATOR: MAX11410 Command Name = VoltageOfCode (uint32_t value_u24) --> double
// CODE GENERATOR: no Menu item hint in description
// CODE GENERATOR: MAX11410 Command Name = RegWrite (MAX11410_CMD_enum_t commandByte, uint32_t regData) --> uint8_t
// CODE GENERATOR: no Menu item hint in description
// CODE GENERATOR: MAX11410 Command Name = RegRead (MAX11410_CMD_enum_t commandByte, uint32_t* ptrRegData) --> uint8_t
// CODE GENERATOR: no Menu item hint in description
// CODE GENERATOR: MAX11410 Command Name = RegSize (MAX11410_CMD_enum_t commandByte) --> uint8_t
// CODE GENERATOR: no Menu item hint in description
// CODE GENERATOR: MAX11410 Command Name = DecodeCommand (MAX11410_CMD_enum_t commandByte) --> MAX11410::MAX11410_CMDOP_enum_t
// CODE GENERATOR: no Menu item hint in description
// CODE GENERATOR: MAX11410 Command Name = RegAddrOfCommand (MAX11410_CMD_enum_t commandByte) --> uint8_t
// CODE GENERATOR: no Menu item hint in description
// CODE GENERATOR: MAX11410 Command Name = IsRegReadCommand (MAX11410_CMD_enum_t commandByte) --> uint8_t
// CODE GENERATOR: no Menu item hint in description
// CODE GENERATOR: MAX11410 Command Name = IsRegWriteCommand (MAX11410_CMD_enum_t commandByte) --> uint8_t
// CODE GENERATOR: no Menu item hint in description
// CODE GENERATOR: MAX11410 Command Name = RegName (MAX11410_CMD_enum_t commandByte) --> const char*
// CODE GENERATOR: no Menu item hint in description
// CODE GENERATOR: MAX11410 Command Name = Configure_FILTER (uint8_t linef, uint8_t rate) --> uint8_t
// CODE GENERATOR: Menu item hint description Menu item 'XF'
// CODE GENERATOR: Menu item 'XF' -- Menu item XF
// CODE GENERATOR: MAX11410 help: XF uint8_t linef, uint8_t rate -- Configure_FILTER
// CODE GENERATOR: MAX11410 helpString: 'XF linef=? rate=? -- Configure_FILTER'
// CODE GENERATOR: test menu case 'XF':
// CODE GENERATOR:           helpString 'XF linef=? rate=? -- Configure_FILTER'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Configure_FILTER'
// CODE GENERATOR:           CommandParamIn 'uint8_t linef, uint8_t rate'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn '@param[in] linef = filter type, default=MAX11410::MAX11410_LINEF_enum_t::LINEF_11_SINC4'
// CODE GENERATOR:           CommandDocParamIn '@param[in] rate = output data rate selection, default=MAX11410::MAX11410_RATE_enum_t::RATE_0100'
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
// CODE GENERATOR: MAX11410 Command Name = Configure_PGA (uint8_t sigpath, uint8_t gain) --> uint8_t
// CODE GENERATOR: Menu item hint description Menu item 'XP'
// CODE GENERATOR: Menu item 'XP' -- Menu item XP
// CODE GENERATOR: MAX11410 help: XP uint8_t sigpath, uint8_t gain -- Configure_PGA
// CODE GENERATOR: MAX11410 helpString: 'XP sigpath=? gain=? -- Configure_PGA'
// CODE GENERATOR: test menu case 'XP':
// CODE GENERATOR:           helpString 'XP sigpath=? gain=? -- Configure_PGA'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Configure_PGA'
// CODE GENERATOR:           CommandParamIn 'uint8_t sigpath, uint8_t gain'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn '@param[in] sigpath = signal path, default=MAX11410::MAX11410_SIG_PATH_enum_t::SIG_PATH_00_BUFFERED'
// CODE GENERATOR:           CommandDocParamIn '@param[in] gain = gain selection, default=MAX11410::MAX11410_GAIN_enum_t::GAIN_000_1'
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
// CODE GENERATOR: MAX11410 Command Name = Configure_CTRL (uint8_t extclk, uint8_t u_bn, uint8_t format, uint8_t refbufp_en, uint8_t refbufn_en, uint8_t ref_sel) --> uint8_t
// CODE GENERATOR: Menu item hint description Menu item 'XC'
// CODE GENERATOR: Menu item 'XC' -- Menu item XC
// CODE GENERATOR: MAX11410 help: XC uint8_t extclk, uint8_t u_bn, uint8_t format, uint8_t refbufp_en, uint8_t refbufn_en, uint8_t ref_sel -- Configure_CTRL
// CODE GENERATOR: MAX11410 helpString: 'XC extclk=? u_bn=? format=? refbufp_en=? refbufn_en=? ref_sel=? -- Configure_CTRL'
// CODE GENERATOR: test menu case 'XC':
// CODE GENERATOR:           helpString 'XC extclk=? u_bn=? format=? refbufp_en=? refbufn_en=? ref_sel=? -- Configure_CTRL'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Configure_CTRL'
// CODE GENERATOR:           CommandParamIn 'uint8_t extclk, uint8_t u_bn, uint8_t format, uint8_t refbufp_en, uint8_t refbufn_en, uint8_t ref_sel'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn '@param[in] extclk = external clock enable, default=0'
// CODE GENERATOR:           CommandDocParamIn '@param[in] u_bn = unipolar input range enable, default=0'
// CODE GENERATOR:           CommandDocParamIn '@param[in] format = offset binary format enable, default=0'
// CODE GENERATOR:           CommandDocParamIn '@param[in] refbufp_en = REFP reference buffer enable, default=0'
// CODE GENERATOR:           CommandDocParamIn '@param[in] refbufn_en = REFN reference buffer enable, default=0'
// CODE GENERATOR:           CommandDocParamIn '@param[in] ref_sel = reference selection, default=MAX11410::MAX11410_REF_SEL_enum_t::REF_SEL_001_REF1P_REF1N'
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
// CODE GENERATOR: MAX11410 Command Name = Configure_CTRL_REF (uint8_t ref_sel) --> uint8_t
// CODE GENERATOR: Menu item hint description Menu item 'XR'
// CODE GENERATOR: Menu item 'XR' -- Menu item XR
// CODE GENERATOR: MAX11410 help: XR uint8_t ref_sel -- Configure_CTRL_REF
// CODE GENERATOR: MAX11410 helpString: 'XR ref_sel=? -- Configure_CTRL_REF'
// CODE GENERATOR: test menu case 'XR':
// CODE GENERATOR:           helpString 'XR ref_sel=? -- Configure_CTRL_REF'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Configure_CTRL_REF'
// CODE GENERATOR:           CommandParamIn 'uint8_t ref_sel'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre '@pre ctrl = shadow of CTRL register'
// CODE GENERATOR:           CommandDocParamIn '@param[in] ref_sel = reference selection, default=MAX11410::MAX11410_REF_SEL_enum_t::REF_SEL_001_REF1P_REF1N'
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
// CODE GENERATOR: MAX11410 Command Name = Configure_SOURCE (uint8_t vbias_mode, uint8_t brn_mode, uint8_t idac_mode) --> uint8_t
// CODE GENERATOR: Menu item hint description Menu item 'XS'
// CODE GENERATOR: Menu item 'XS' -- Menu item XS
// CODE GENERATOR: MAX11410 help: XS uint8_t vbias_mode, uint8_t brn_mode, uint8_t idac_mode -- Configure_SOURCE
// CODE GENERATOR: MAX11410 helpString: 'XS vbias_mode=? brn_mode=? idac_mode=? -- Configure_SOURCE'
// CODE GENERATOR: test menu case 'XS':
// CODE GENERATOR:           helpString 'XS vbias_mode=? brn_mode=? idac_mode=? -- Configure_SOURCE'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Configure_SOURCE'
// CODE GENERATOR:           CommandParamIn 'uint8_t vbias_mode, uint8_t brn_mode, uint8_t idac_mode'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn '@param[in] vbias_mode = bias voltage mode, default=MAX11410::MAX11410_VBIAS_MODE_enum_t::VBIAS_MODE_00_Active'
// CODE GENERATOR:           CommandDocParamIn '@param[in] brn_mode = burnout source mode, default=MAX11410::MAX11410_BRN_MODE_enum_t::BRN_MODE_00_disabled'
// CODE GENERATOR:           CommandDocParamIn '@param[in] idac_mode = current source value, default=MAX11410::MAX11410_IDAC_MODE_enum_t::IDAC_MODE_0000_10uA'
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
// CODE GENERATOR: MAX11410 Command Name = Configure_MUX_CTRL0 (uint8_t ainp, uint8_t ainn) --> uint8_t
// CODE GENERATOR: Menu item hint description Menu item 'XM'
// CODE GENERATOR: Menu item 'XM' -- Menu item XM
// CODE GENERATOR: MAX11410 help: XM uint8_t ainp, uint8_t ainn -- Configure_MUX_CTRL0
// CODE GENERATOR: MAX11410 helpString: 'XM ainp=? ainn=? -- Configure_MUX_CTRL0'
// CODE GENERATOR: test menu case 'XM':
// CODE GENERATOR:           helpString 'XM ainp=? ainn=? -- Configure_MUX_CTRL0'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Configure_MUX_CTRL0'
// CODE GENERATOR:           CommandParamIn 'uint8_t ainp, uint8_t ainn'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn '@param[in] ainp = channel high side, default=MAX11410::MAX11410_AINP_SEL_enum_t::AINP_SEL_0000_AIN0'
// CODE GENERATOR:           CommandDocParamIn '@param[in] ainn = channel low side, default=MAX11410::MAX11410_AINN_SEL_enum_t::AINN_SEL_1010_GND'
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
// CODE GENERATOR: MAX11410 Command Name = Configure_MUX_CTRL1 (uint8_t idac1_sel, uint8_t idac0_sel) --> uint8_t
// CODE GENERATOR: Menu item hint description Menu item 'XI'
// CODE GENERATOR: Menu item 'XI' -- Menu item XI
// CODE GENERATOR: MAX11410 help: XI uint8_t idac1_sel, uint8_t idac0_sel -- Configure_MUX_CTRL1
// CODE GENERATOR: MAX11410 helpString: 'XI idac1_sel=? idac0_sel=? -- Configure_MUX_CTRL1'
// CODE GENERATOR: test menu case 'XI':
// CODE GENERATOR:           helpString 'XI idac1_sel=? idac0_sel=? -- Configure_MUX_CTRL1'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Configure_MUX_CTRL1'
// CODE GENERATOR:           CommandParamIn 'uint8_t idac1_sel, uint8_t idac0_sel'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn '@param[in] idac1_sel = channel high side, default=MAX11410::MAX11410_IDAC1_SEL_enum_t::IDAC1_SEL_1111_unconnected'
// CODE GENERATOR:           CommandDocParamIn '@param[in] idac0_sel = channel low side, default=MAX11410::MAX11410_IDAC0_SEL_enum_t::IDAC0_SEL_1111_unconnected'
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
// CODE GENERATOR: MAX11410 Command Name = Configure_MUX_CTRL2 (uint8_t vbias_ain7_ain0_bitmap) --> uint8_t
// CODE GENERATOR: Menu item hint description Menu item 'XV'
// CODE GENERATOR: Menu item 'XV' -- Menu item XV
// CODE GENERATOR: MAX11410 help: XV uint8_t vbias_ain7_ain0_bitmap -- Configure_MUX_CTRL2
// CODE GENERATOR: MAX11410 helpString: 'XV vbias_ain7_ain0_bitmap=? -- Configure_MUX_CTRL2'
// CODE GENERATOR: test menu case 'XV':
// CODE GENERATOR:           helpString 'XV vbias_ain7_ain0_bitmap=? -- Configure_MUX_CTRL2'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Configure_MUX_CTRL2'
// CODE GENERATOR:           CommandParamIn 'uint8_t vbias_ain7_ain0_bitmap'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn '@param[in] vbias_ain7_ain0_bitmap = bit map of AIN7..AIN0 enables for voltage bias, default=0'
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
// CODE GENERATOR: MAX11410 Command Name = Calibrate_Self_Offset_Gain (void) --> uint8_t
// CODE GENERATOR: Menu item hint description Menu item 'X0'
// CODE GENERATOR: Menu item 'X0' -- Menu item X0
// CODE GENERATOR: test menu case 'X0':
// CODE GENERATOR:           helpString 'X0 -- Calibrate_Self_Offset_Gain'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Calibrate_Self_Offset_Gain'
// CODE GENERATOR:           CommandParamIn 'void'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn ''
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
// CODE GENERATOR: MAX11410 Command Name = Calibrate_PGA_Gain (void) --> uint8_t
// CODE GENERATOR: Menu item hint description Menu item 'X1'
// CODE GENERATOR: Menu item 'X1' -- Menu item X1
// CODE GENERATOR: test menu case 'X1':
// CODE GENERATOR:           helpString 'X1 -- Calibrate_PGA_Gain'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Calibrate_PGA_Gain'
// CODE GENERATOR:           CommandParamIn 'void'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn ''
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
// CODE GENERATOR: MAX11410 Command Name = Calibrate_System_Offset_A (void) --> uint8_t
// CODE GENERATOR: no Menu item hint in description
// CODE GENERATOR: MAX11410 Command Name = Calibrate_System_Gain_A (void) --> uint8_t
// CODE GENERATOR: no Menu item hint in description
// CODE GENERATOR: MAX11410 Command Name = Calibrate_System_Offset_B (void) --> uint8_t
// CODE GENERATOR: no Menu item hint in description
// CODE GENERATOR: MAX11410 Command Name = Calibrate_System_Gain_B (void) --> uint8_t
// CODE GENERATOR: no Menu item hint in description
// CODE GENERATOR: MAX11410 Command Name = Read_All_Voltages (void) --> uint8_t
// CODE GENERATOR: Menu item hint description Menu item '$' -> AINcode[0], AINcode[1], AINcode[2], AINcode[3], AINcode[4], AINcode[5], AINcode[6], AINcode[7], AINcode[8], AINcode[9], AINcode[10]
// CODE GENERATOR: Menu item '$' -> AINcode[0], AINcode[1], AINcode[2], AINcode[3], AINcode[4], AINcode[5], AINcode[6], AINcode[7], AINcode[8], AINcode[9], AINcode[10] -- Menu item $
// CODE GENERATOR: test menu case '$':
// CODE GENERATOR:           helpString '$ -- Read_All_Voltages'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Read_All_Voltages'
// CODE GENERATOR:           CommandParamIn 'void'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn ''
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost '@post AINcode[0..10]: measurement result LSB code'
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
// CODE GENERATOR: MAX11410 Command Name = Measure_Voltage (MAX11410_AINP_SEL_enum_t ainp, MAX11410_AINN_SEL_enum_t ainn) --> double
// CODE GENERATOR: Menu item hint description Menu item 'V'
// CODE GENERATOR: Menu item 'V' -- Menu item V
// CODE GENERATOR: MAX11410 help: V MAX11410_AINP_SEL_enum_t ainp, MAX11410_AINN_SEL_enum_t ainn -- Measure_Voltage
// CODE GENERATOR: MAX11410 helpString: 'V  -- Measure_Voltage'
// CODE GENERATOR: test menu case 'V':
// CODE GENERATOR:           helpString 'V  -- Measure_Voltage'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Measure_Voltage'
// CODE GENERATOR:           CommandParamIn 'MAX11410_AINP_SEL_enum_t ainp, MAX11410_AINN_SEL_enum_t ainn'
// CODE GENERATOR:           CommandReturnType 'double'
// CODE GENERATOR:           CommandPre '@pre external connection REF2P-REF2N is a reference voltage'
// CODE GENERATOR:           CommandPre '@pre VRef = Voltage of REF input, in Volts'
// CODE GENERATOR:           CommandPre '@pre v_filter = filter register configuration, 0x34 for LINEF_11_SINC4 RATE_0100 output data rate 60SPS'
// CODE GENERATOR:           CommandPre '@pre v_ctrl = ctrl register configuration, 0x02 for bipolar REF_SEL_010_REF2P_REF2N'
// CODE GENERATOR:           CommandPre '@pre v_pga = pga register configuration, 0x00 for SIG_PATH_00_BUFFERED GAIN_000_1'
// CODE GENERATOR:           CommandDocParamIn '@param[in] ainp = channel high side, default=AINP_SEL_0000_AIN0'
// CODE GENERATOR:           CommandDocParamIn '@param[in] ainn = channel low side, default=AINN_SEL_1010_GND'
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost '@post AINcode[ainp]: measurement result LSB code'
// CODE GENERATOR:           CommandReturn '@return ideal voltage calculated from raw LSB code and reference voltage'
// CODE GENERATOR: MAX11410 Command Name = Measure_RTD (MAX11410_AINP_SEL_enum_t rtd_iout, MAX11410_AINP_SEL_enum_t rtd_ainp, MAX11410_AINN_SEL_enum_t rtd_ainn) --> double
// CODE GENERATOR: Menu item hint description Menu item 'R' -> rtd_ohm, rtd_degc
// CODE GENERATOR: Menu item 'R' -> rtd_ohm, rtd_degc -- Menu item R
// CODE GENERATOR: MAX11410 help: R MAX11410_AINP_SEL_enum_t rtd_iout, MAX11410_AINP_SEL_enum_t rtd_ainp, MAX11410_AINN_SEL_enum_t rtd_ainn -- Measure_RTD
// CODE GENERATOR: MAX11410 helpString: 'R  -- Measure_RTD'
// CODE GENERATOR: test menu case 'R':
// CODE GENERATOR:           helpString 'R  -- Measure_RTD'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Measure_RTD'
// CODE GENERATOR:           CommandParamIn 'MAX11410_AINP_SEL_enum_t rtd_iout, MAX11410_AINP_SEL_enum_t rtd_ainp, MAX11410_AINN_SEL_enum_t rtd_ainn'
// CODE GENERATOR:           CommandReturnType 'double'
// CODE GENERATOR:           CommandPre '@pre external connection REF1P-REF1N is a reference resistor'
// CODE GENERATOR:           CommandPre '@pre ref1_v = reference resistance in ohms, default=4999'
// CODE GENERATOR:           CommandPre '@pre rtd_filter = filter register configuration, 0x34 for LINEF_11_SINC4 RATE_0100 output data rate 60SPS'
// CODE GENERATOR:           CommandPre '@pre rtd_ctrl = ctrl register configuration, 0x40 for ref0_v, 0x41 for ref1_v, 0x42 for ref2_v'
// CODE GENERATOR:           CommandPre '@pre rtd_souce = souce register configuration, 0x0B for IDAC_MODE_1011_400uA'
// CODE GENERATOR:           CommandPre '@pre rtd_pga = pga register configuration, 0x21 for SIG_PATH_10_PGA GAIN_001_2'
// CODE GENERATOR:           CommandDocParamIn '@param[in] rtd_iout = channel RTD high side force, default=AINP_SEL_0111_AIN7'
// CODE GENERATOR:           CommandDocParamIn '@param[in] rtd_ainp = channel RTD high side sense, default=AINP_SEL_1000_AIN8'
// CODE GENERATOR:           CommandDocParamIn '@param[in] rtd_ainn = channel RTD low side, default=AINN_SEL_1001_AIN9'
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost '@post AINcode[rtd_ainp]: measurement result LSB code'
// CODE GENERATOR:           CommandPost '@post rtd_ohm: measurement result resistance in Ohms'
// CODE GENERATOR:           CommandPost '@post rtd_degc: Temperature calculated from RTD Resistance; Thermocouple Cold Junction, in degrees C'
// CODE GENERATOR:           CommandReturn '@return resistance calculated from raw LSB code and reference resistance'
// CODE GENERATOR: MAX11410 Command Name = TemperatureOfRTD_PT1000 (double rtd_ohm) --> double
// CODE GENERATOR: no Menu item hint in description
// CODE GENERATOR: MAX11410 Command Name = TemperatureOfRTD_PT100 (double rtd_ohm) --> double
// CODE GENERATOR: no Menu item hint in description
// CODE GENERATOR: MAX11410 Command Name = TemperatureOfRTD (double rtd_ohm) --> double
// CODE GENERATOR: no Menu item hint in description
// CODE GENERATOR: MAX11410 Command Name = Measure_Thermocouple (MAX11410_AINP_SEL_enum_t tc_ainp, MAX11410_AINN_SEL_enum_t tc_ainn, MAX11410_AINP_SEL_enum_t rtd_iout, MAX11410_AINP_SEL_enum_t rtd_ainp, MAX11410_AINN_SEL_enum_t rtd_ainn) --> double
// CODE GENERATOR: Menu item hint description Menu item 'TM' -> tc_v, tc_delta_degc, tc_degc
// CODE GENERATOR: Menu item 'TM' -> tc_v, tc_delta_degc, tc_degc -- Menu item TM
// CODE GENERATOR: MAX11410 help: TM MAX11410_AINP_SEL_enum_t tc_ainp, MAX11410_AINN_SEL_enum_t tc_ainn, MAX11410_AINP_SEL_enum_t rtd_iout, MAX11410_AINP_SEL_enum_t rtd_ainp, MAX11410_AINN_SEL_enum_t rtd_ainn -- Measure_Thermocouple
// CODE GENERATOR: MAX11410 helpString: 'TM  -- Measure_Thermocouple'
// CODE GENERATOR: test menu case 'TM':
// CODE GENERATOR:           helpString 'TM  -- Measure_Thermocouple'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Measure_Thermocouple'
// CODE GENERATOR:           CommandParamIn 'MAX11410_AINP_SEL_enum_t tc_ainp, MAX11410_AINN_SEL_enum_t tc_ainn, MAX11410_AINP_SEL_enum_t rtd_iout, MAX11410_AINP_SEL_enum_t rtd_ainp, MAX11410_AINN_SEL_enum_t rtd_ainn'
// CODE GENERATOR:           CommandReturnType 'double'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn '@param[in] tc_ainp = channel of Thermocouple high side, default=AINP_SEL_0101_AIN5'
// CODE GENERATOR:           CommandDocParamIn '@param[in] tc_ainn = channel of Thermocouple low side, default=AINN_SEL_0110_AIN6'
// CODE GENERATOR:           CommandDocParamIn '@param[in] rtd_iout = channel RTD high side force, default=AINP_SEL_0111_AIN7'
// CODE GENERATOR:           CommandDocParamIn '@param[in] rtd_ainp = channel RTD high side sense, default=AINP_SEL_1000_AIN8'
// CODE GENERATOR:           CommandDocParamIn '@param[in] rtd_ainn = channel RTD low side, default=AINN_SEL_1001_AIN9'
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost '@post AINcode[tc_ainp]: measurement result LSB code'
// CODE GENERATOR:           CommandPost '@post tc_v: raw thermocouple voltage in Volts'
// CODE GENERATOR:           CommandPost '@post tc_delta_degc: temperature in degC above cold junction'
// CODE GENERATOR:           CommandPost '@post tc_degc: temperature in degC'
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
// CODE GENERATOR: MAX11410 Command Name = TemperatureOfTC_TypeK (double tc_v) --> double
// CODE GENERATOR: no Menu item hint in description
// CODE GENERATOR: MAX11410 Command Name = temperatureDegC_polynomial (double thermocouple_voltage_uV, int num_coefficients, double coefficients[]) --> double
// CODE GENERATOR: no Menu item hint in description
// CODE GENERATOR: testMenuGlobalArgsDict scan global property list g_MAX11410_device

// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.ref0_v
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.ref0_v argname = ref0_v
// CODE GENERATOR: testMenuGlobalArgsDict['ref0_v']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ref0_v']['argtype'] = 'double'
// CODE GENERATOR: testMenuGlobalArgsDict['ref0_v']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ref0_v']['usedBytestMenuItemName'] = 'None'

// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.ref1_v
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.ref1_v argname = ref1_v
// CODE GENERATOR: testMenuGlobalArgsDict['ref1_v']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ref1_v']['argtype'] = 'double'
// CODE GENERATOR: testMenuGlobalArgsDict['ref1_v']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ref1_v']['usedBytestMenuItemName'] = 'None'

// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.ref2_v
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.ref2_v argname = ref2_v
// CODE GENERATOR: testMenuGlobalArgsDict['ref2_v']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ref2_v']['argtype'] = 'double'
// CODE GENERATOR: testMenuGlobalArgsDict['ref2_v']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ref2_v']['usedBytestMenuItemName'] = 'None'

// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.avdd_v
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.avdd_v argname = avdd_v
// CODE GENERATOR: testMenuGlobalArgsDict['avdd_v']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['avdd_v']['argtype'] = 'double'
// CODE GENERATOR: testMenuGlobalArgsDict['avdd_v']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['avdd_v']['usedBytestMenuItemName'] = 'None'

// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.ctrl
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.ctrl shadow of argname = ctrl
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.ctrl argname = ctrl
// CODE GENERATOR: testMenuGlobalArgsDict['ctrl']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ctrl']['argtype'] = 'uint32_t'
// CODE GENERATOR: testMenuGlobalArgsDict['ctrl']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ctrl']['usedBytestMenuItemName'] = 'None'

// CODE GENERATOR: testMenuGlobalArgsDict omit read-only property uint8_t g_MAX11410_device.pgaGain
// CODE GENERATOR: testMenuGlobalArgsDict omit read-only property uint32_t g_MAX11410_device.status
// CODE GENERATOR: testMenuGlobalArgsDict omit read-only property uint32_t g_MAX11410_device.data0
// CODE GENERATOR: testMenuGlobalArgsDict skip array property g_MAX11410_device.AINcode[11]
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.loop_limit
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.loop_limit argname = loop_limit
// CODE GENERATOR: testMenuGlobalArgsDict['loop_limit']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['loop_limit']['argtype'] = 'int'
// CODE GENERATOR: testMenuGlobalArgsDict['loop_limit']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['loop_limit']['usedBytestMenuItemName'] = 'None'

// CODE GENERATOR: testMenuGlobalArgsDict omit read-only property MAX11410::MAX11410_CMD_enum_t* g_MAX11410_device.readAllStatusList
// CODE GENERATOR: testMenuGlobalArgsDict omit read-only property uint8_t g_MAX11410_device.readAllStatusListLen
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.rtd_ms
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.rtd_ms argname = rtd_ms
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_ms']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_ms']['argtype'] = 'int'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_ms']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_ms']['usedBytestMenuItemName'] = 'None'

// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.rtd_ohm
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.rtd_ohm argname = rtd_ohm
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_ohm']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_ohm']['argtype'] = 'double'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_ohm']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_ohm']['usedBytestMenuItemName'] = 'None'

// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.rtd_degc
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.rtd_degc argname = rtd_degc
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_degc']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_degc']['argtype'] = 'double'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_degc']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_degc']['usedBytestMenuItemName'] = 'None'

// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.rtd_filter
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.rtd_filter argname = rtd_filter
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_filter']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_filter']['argtype'] = 'uint8_t'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_filter']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_filter']['usedBytestMenuItemName'] = 'None'

// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.rtd_ctrl
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.rtd_ctrl argname = rtd_ctrl
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_ctrl']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_ctrl']['argtype'] = 'uint8_t'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_ctrl']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_ctrl']['usedBytestMenuItemName'] = 'None'

// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.rtd_source
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.rtd_source argname = rtd_source
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_source']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_source']['argtype'] = 'uint8_t'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_source']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_source']['usedBytestMenuItemName'] = 'None'

// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.rtd_pga
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.rtd_pga argname = rtd_pga
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_pga']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_pga']['argtype'] = 'uint8_t'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_pga']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_pga']['usedBytestMenuItemName'] = 'None'

// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.v_filter
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.v_filter argname = v_filter
// CODE GENERATOR: testMenuGlobalArgsDict['v_filter']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['v_filter']['argtype'] = 'uint8_t'
// CODE GENERATOR: testMenuGlobalArgsDict['v_filter']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['v_filter']['usedBytestMenuItemName'] = 'None'

// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.v_ctrl
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.v_ctrl argname = v_ctrl
// CODE GENERATOR: testMenuGlobalArgsDict['v_ctrl']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['v_ctrl']['argtype'] = 'uint8_t'
// CODE GENERATOR: testMenuGlobalArgsDict['v_ctrl']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['v_ctrl']['usedBytestMenuItemName'] = 'None'

// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.v_pga
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.v_pga argname = v_pga
// CODE GENERATOR: testMenuGlobalArgsDict['v_pga']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['v_pga']['argtype'] = 'uint8_t'
// CODE GENERATOR: testMenuGlobalArgsDict['v_pga']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['v_pga']['usedBytestMenuItemName'] = 'None'

// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.tc_v
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.tc_v argname = tc_v
// CODE GENERATOR: testMenuGlobalArgsDict['tc_v']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['tc_v']['argtype'] = 'double'
// CODE GENERATOR: testMenuGlobalArgsDict['tc_v']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['tc_v']['usedBytestMenuItemName'] = 'None'

// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.tc_delta_degc
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.tc_delta_degc argname = tc_delta_degc
// CODE GENERATOR: testMenuGlobalArgsDict['tc_delta_degc']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['tc_delta_degc']['argtype'] = 'double'
// CODE GENERATOR: testMenuGlobalArgsDict['tc_delta_degc']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['tc_delta_degc']['usedBytestMenuItemName'] = 'None'

// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.tc_degc
// CODE GENERATOR: testMenuGlobalArgsDict add global property g_MAX11410_device.tc_degc argname = tc_degc
// CODE GENERATOR: testMenuGlobalArgsDict['tc_degc']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['tc_degc']['argtype'] = 'double'
// CODE GENERATOR: testMenuGlobalArgsDict['tc_degc']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['tc_degc']['usedBytestMenuItemName'] = 'None'


// CODE GENERATOR: scan testMenuCommand list for items that can be shortened to single character
// CODE GENERATOR: multiple commands begin with character 'X'
// CODE GENERATOR: multiple commands begin with character 'X'
// CODE GENERATOR: multiple commands begin with character 'X'
// CODE GENERATOR: multiple commands begin with character 'X'
// CODE GENERATOR: multiple commands begin with character 'X'
// CODE GENERATOR: multiple commands begin with character 'X'
// CODE GENERATOR: multiple commands begin with character 'X'
// CODE GENERATOR: multiple commands begin with character 'X'
// CODE GENERATOR: multiple commands begin with character 'X'
// CODE GENERATOR: shorten testMenuCommand to single character if unambiguous
// CODE GENERATOR: testMenuCommand '!' already single character
// CODE GENERATOR: testMenuCommand '$' already single character
// CODE GENERATOR: testMenuCommand 'R' already single character
// CODE GENERATOR: shorten testMenuCommand 'TM' to single character 'T'
// CODE GENERATOR: re.sub pattern:'TM' with repl:'T' in helpString 'TM  -- Measure_Thermocouple'
// CODE GENERATOR: updated 'T' help string to 'T  -- Measure_Thermocouple'
// CODE GENERATOR: testMenuCommand 'V' already single character
// CODE GENERATOR: cannot shorten testMenuCommand 'X0' to single character due to duplicates
// CODE GENERATOR: cannot shorten testMenuCommand 'X1' to single character due to duplicates
// CODE GENERATOR: cannot shorten testMenuCommand 'XC' to single character due to duplicates
// CODE GENERATOR: cannot shorten testMenuCommand 'XF' to single character due to duplicates
// CODE GENERATOR: cannot shorten testMenuCommand 'XI' to single character due to duplicates
// CODE GENERATOR: cannot shorten testMenuCommand 'XM' to single character due to duplicates
// CODE GENERATOR: cannot shorten testMenuCommand 'XP' to single character due to duplicates
// CODE GENERATOR: cannot shorten testMenuCommand 'XR' to single character due to duplicates
// CODE GENERATOR: cannot shorten testMenuCommand 'XS' to single character due to duplicates
// CODE GENERATOR: cannot shorten testMenuCommand 'XV' to single character due to duplicates

// CODE GENERATOR: help menu
void MAX11410_menu_help(CmdLine & cmdLine)
{
    // CODE GENERATOR: command: !
    // CODE GENERATOR: help: ! -- Init
    cmdLine.serial().printf("\r\n ! -- Init");
    // CODE GENERATOR: command: $
    // CODE GENERATOR: help: $ -- Read_All_Voltages
    cmdLine.serial().printf("\r\n $ -- Read_All_Voltages");
    // CODE GENERATOR: command: R
    // CODE GENERATOR: help: R  -- Measure_RTD
    cmdLine.serial().printf("\r\n R  -- Measure_RTD");
    // CODE GENERATOR: command: T
    // CODE GENERATOR: help: T  -- Measure_Thermocouple
    cmdLine.serial().printf("\r\n T  -- Measure_Thermocouple");
    // CODE GENERATOR: command: V
    // CODE GENERATOR: help: V  -- Measure_Voltage
    cmdLine.serial().printf("\r\n V  -- Measure_Voltage");
    // CODE GENERATOR: command: X0
    // CODE GENERATOR: help: X0 -- Calibrate_Self_Offset_Gain
    cmdLine.serial().printf("\r\n X0 -- Calibrate_Self_Offset_Gain");
    // CODE GENERATOR: command: X1
    // CODE GENERATOR: help: X1 -- Calibrate_PGA_Gain
    cmdLine.serial().printf("\r\n X1 -- Calibrate_PGA_Gain");
    // CODE GENERATOR: command: XC
    // CODE GENERATOR: help: XC extclk=? u_bn=? format=? refbufp_en=? refbufn_en=? ref_sel=? -- Configure_CTRL
    cmdLine.serial().printf("\r\n XC extclk=? u_bn=? format=? refbufp_en=? refbufn_en=? ref_sel=? -- Configure_CTRL");
    // CODE GENERATOR: command: XF
    // CODE GENERATOR: help: XF linef=? rate=? -- Configure_FILTER
    cmdLine.serial().printf("\r\n XF linef=? rate=? -- Configure_FILTER");
    // CODE GENERATOR: command: XI
    // CODE GENERATOR: help: XI idac1_sel=? idac0_sel=? -- Configure_MUX_CTRL1
    cmdLine.serial().printf("\r\n XI idac1_sel=? idac0_sel=? -- Configure_MUX_CTRL1");
    // CODE GENERATOR: command: XM
    // CODE GENERATOR: help: XM ainp=? ainn=? -- Configure_MUX_CTRL0
    cmdLine.serial().printf("\r\n XM ainp=? ainn=? -- Configure_MUX_CTRL0");
    // CODE GENERATOR: command: XP
    // CODE GENERATOR: help: XP sigpath=? gain=? -- Configure_PGA
    cmdLine.serial().printf("\r\n XP sigpath=? gain=? -- Configure_PGA");
    // CODE GENERATOR: command: XR
    // CODE GENERATOR: help: XR ref_sel=? -- Configure_CTRL_REF
    cmdLine.serial().printf("\r\n XR ref_sel=? -- Configure_CTRL_REF");
    // CODE GENERATOR: command: XS
    // CODE GENERATOR: help: XS vbias_mode=? brn_mode=? idac_mode=? -- Configure_SOURCE
    cmdLine.serial().printf("\r\n XS vbias_mode=? brn_mode=? idac_mode=? -- Configure_SOURCE");
    // CODE GENERATOR: command: XV
    // CODE GENERATOR: help: XV vbias_ain7_ain0_bitmap=? -- Configure_MUX_CTRL2
    cmdLine.serial().printf("\r\n XV vbias_ain7_ain0_bitmap=? -- Configure_MUX_CTRL2");
    //
    cmdLine.serial().printf("\r\n @ -- print MAX11410 configuration");

// CODE GENERATOR: help menu if has_register_write_command: *regname? -- read register; *regname=regvalue -- write register
    cmdLine.serial().printf("\r\n * -- read core registers");
    cmdLine.serial().printf("\r\n *regname? -- read register");
    cmdLine.serial().printf("\r\n *regname=regvalue -- write register");
    cmdLine.serial().printf("\r\n 01 23 45 67 89 ab cd ef -- write and read raw hex codes");

    //
// CODE GENERATOR: TODO1: generate GPIO commands for LDAC, CLR, etc. based on device driver function names (menu_help)
        // case 'G'..'Z','g'..'z' are reserved for GPIO commands
        // case 'A'..'F','a'..'f' may be available if not claimed by bitstream commands
// CODE GENERATOR: TODO1: prevent conflict ExternFunctionGPIOPinCommand with reserved case 'A'..'F','a'..'f'

    //
}

bool MAX11410_menu_onEOLcommandParser(CmdLine & cmdLine)
{

// CODE GENERATOR: testMenuGlobalArgsDict Consolidate common/global argument parsing

// CODE GENERATOR: testMenuGlobalArgsDict['avdd_v']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['avdd_v']['argtype'] = 'double'
// CODE GENERATOR: testMenuGlobalArgsDict['avdd_v']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['avdd_v']['usedBytestMenuItemName'] = 'None'
                    // parse argument double avdd_v
        double avdd_v = g_MAX11410_device.avdd_v; // default to global property value
        if (cmdLine.parse_double("avdd_v", avdd_v))
        {
            g_MAX11410_device.avdd_v = avdd_v; // update global property value
        }

// CODE GENERATOR: testMenuGlobalArgsDict['ctrl']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ctrl']['argtype'] = 'uint32_t'
// CODE GENERATOR: testMenuGlobalArgsDict['ctrl']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ctrl']['usedBytestMenuItemName'] = 'None'
                    // parse argument uint32_t ctrl
        uint32_t ctrl = g_MAX11410_device.v_ctrl; // default to global property value
        if (cmdLine.parse_uint32_dec("ctrl", ctrl))
        {
            g_MAX11410_device.v_ctrl = ctrl; // update global property value
        }

// CODE GENERATOR: testMenuGlobalArgsDict['loop_limit']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['loop_limit']['argtype'] = 'int'
// CODE GENERATOR: testMenuGlobalArgsDict['loop_limit']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['loop_limit']['usedBytestMenuItemName'] = 'None'
                    // parse argument int loop_limit
        int loop_limit = g_MAX11410_device.loop_limit; // default to global property value
        if (cmdLine.parse_int_dec("loop_limit", loop_limit))
        {
            g_MAX11410_device.loop_limit = loop_limit; // update global property value
        }

// CODE GENERATOR: testMenuGlobalArgsDict['ref0_v']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ref0_v']['argtype'] = 'double'
// CODE GENERATOR: testMenuGlobalArgsDict['ref0_v']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ref0_v']['usedBytestMenuItemName'] = 'None'
                    // parse argument double ref0_v
        double ref0_v = g_MAX11410_device.ref0_v; // default to global property value
        if (cmdLine.parse_double("ref0_v", ref0_v))
        {
            g_MAX11410_device.ref0_v = ref0_v; // update global property value
        }

// CODE GENERATOR: testMenuGlobalArgsDict['ref1_v']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ref1_v']['argtype'] = 'double'
// CODE GENERATOR: testMenuGlobalArgsDict['ref1_v']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ref1_v']['usedBytestMenuItemName'] = 'None'
                    // parse argument double ref1_v
        double ref1_v = g_MAX11410_device.ref1_v; // default to global property value
        if (cmdLine.parse_double("ref1_v", ref1_v))
        {
            g_MAX11410_device.ref1_v = ref1_v; // update global property value
        }

// CODE GENERATOR: testMenuGlobalArgsDict['ref2_v']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ref2_v']['argtype'] = 'double'
// CODE GENERATOR: testMenuGlobalArgsDict['ref2_v']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['ref2_v']['usedBytestMenuItemName'] = 'None'
                    // parse argument double ref2_v
        double ref2_v = g_MAX11410_device.ref2_v; // default to global property value
        if (cmdLine.parse_double("ref2_v", ref2_v))
        {
            g_MAX11410_device.ref2_v = ref2_v; // update global property value
        }

// CODE GENERATOR: testMenuGlobalArgsDict['rtd_ctrl']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_ctrl']['argtype'] = 'uint8_t'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_ctrl']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_ctrl']['usedBytestMenuItemName'] = 'None'
                    // parse argument uint8_t rtd_ctrl
        uint8_t rtd_ctrl = g_MAX11410_device.rtd_ctrl; // default to global property value
        if (cmdLine.parse_uint8_dec("rtd_ctrl", rtd_ctrl))
        {
            g_MAX11410_device.rtd_ctrl = rtd_ctrl; // update global property value
        }

// CODE GENERATOR: testMenuGlobalArgsDict['rtd_degc']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_degc']['argtype'] = 'double'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_degc']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_degc']['usedBytestMenuItemName'] = 'None'
                    // parse argument double rtd_degc
        double rtd_degc = g_MAX11410_device.rtd_degc; // default to global property value
        if (cmdLine.parse_double("rtd_degc", rtd_degc))
        {
            g_MAX11410_device.rtd_degc = rtd_degc; // update global property value
        }

// CODE GENERATOR: testMenuGlobalArgsDict['rtd_filter']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_filter']['argtype'] = 'uint8_t'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_filter']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_filter']['usedBytestMenuItemName'] = 'None'
                    // parse argument uint8_t rtd_filter
        uint8_t rtd_filter = g_MAX11410_device.rtd_filter; // default to global property value
        if (cmdLine.parse_uint8_dec("rtd_filter", rtd_filter))
        {
            g_MAX11410_device.rtd_filter = rtd_filter; // update global property value
        }

// CODE GENERATOR: testMenuGlobalArgsDict['rtd_ms']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_ms']['argtype'] = 'int'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_ms']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_ms']['usedBytestMenuItemName'] = 'None'
                    // parse argument int rtd_ms
        int rtd_ms = g_MAX11410_device.rtd_ms; // default to global property value
        if (cmdLine.parse_int_dec("rtd_ms", rtd_ms))
        {
            g_MAX11410_device.rtd_ms = rtd_ms; // update global property value
        }

// CODE GENERATOR: testMenuGlobalArgsDict['rtd_ohm']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_ohm']['argtype'] = 'double'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_ohm']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_ohm']['usedBytestMenuItemName'] = 'None'
                    // parse argument double rtd_ohm
        double rtd_ohm = g_MAX11410_device.rtd_ohm; // default to global property value
        if (cmdLine.parse_double("rtd_ohm", rtd_ohm))
        {
            g_MAX11410_device.rtd_ohm = rtd_ohm; // update global property value
        }

// CODE GENERATOR: testMenuGlobalArgsDict['rtd_pga']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_pga']['argtype'] = 'uint8_t'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_pga']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_pga']['usedBytestMenuItemName'] = 'None'
                    // parse argument uint8_t rtd_pga
        uint8_t rtd_pga = g_MAX11410_device.rtd_pga; // default to global property value
        if (cmdLine.parse_uint8_dec("rtd_pga", rtd_pga))
        {
            g_MAX11410_device.rtd_pga = rtd_pga; // update global property value
        }

// CODE GENERATOR: testMenuGlobalArgsDict['rtd_source']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_source']['argtype'] = 'uint8_t'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_source']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['rtd_source']['usedBytestMenuItemName'] = 'None'
                    // parse argument uint8_t rtd_source
        uint8_t rtd_source = g_MAX11410_device.rtd_source; // default to global property value
        if (cmdLine.parse_uint8_dec("rtd_source", rtd_source))
        {
            g_MAX11410_device.rtd_source = rtd_source; // update global property value
        }

// CODE GENERATOR: testMenuGlobalArgsDict['tc_degc']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['tc_degc']['argtype'] = 'double'
// CODE GENERATOR: testMenuGlobalArgsDict['tc_degc']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['tc_degc']['usedBytestMenuItemName'] = 'None'
                    // parse argument double tc_degc
        double tc_degc = g_MAX11410_device.tc_degc; // default to global property value
        if (cmdLine.parse_double("tc_degc", tc_degc))
        {
            g_MAX11410_device.tc_degc = tc_degc; // update global property value
        }

// CODE GENERATOR: testMenuGlobalArgsDict['tc_delta_degc']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['tc_delta_degc']['argtype'] = 'double'
// CODE GENERATOR: testMenuGlobalArgsDict['tc_delta_degc']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['tc_delta_degc']['usedBytestMenuItemName'] = 'None'
                    // parse argument double tc_delta_degc
        double tc_delta_degc = g_MAX11410_device.tc_delta_degc; // default to global property value
        if (cmdLine.parse_double("tc_delta_degc", tc_delta_degc))
        {
            g_MAX11410_device.tc_delta_degc = tc_delta_degc; // update global property value
        }

// CODE GENERATOR: testMenuGlobalArgsDict['tc_v']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['tc_v']['argtype'] = 'double'
// CODE GENERATOR: testMenuGlobalArgsDict['tc_v']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['tc_v']['usedBytestMenuItemName'] = 'None'
                    // parse argument double tc_v
        double tc_v = g_MAX11410_device.tc_v; // default to global property value
        if (cmdLine.parse_double("tc_v", tc_v))
        {
            g_MAX11410_device.tc_v = tc_v; // update global property value
        }

// CODE GENERATOR: testMenuGlobalArgsDict['v_ctrl']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['v_ctrl']['argtype'] = 'uint8_t'
// CODE GENERATOR: testMenuGlobalArgsDict['v_ctrl']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['v_ctrl']['usedBytestMenuItemName'] = 'None'
                    // parse argument uint8_t v_ctrl
        uint8_t v_ctrl = g_MAX11410_device.v_ctrl; // default to global property value
        if (cmdLine.parse_uint8_dec("v_ctrl", v_ctrl))
        {
            g_MAX11410_device.v_ctrl = v_ctrl; // update global property value
        }

// CODE GENERATOR: testMenuGlobalArgsDict['v_filter']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['v_filter']['argtype'] = 'uint8_t'
// CODE GENERATOR: testMenuGlobalArgsDict['v_filter']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['v_filter']['usedBytestMenuItemName'] = 'None'
                    // parse argument uint8_t v_filter
        uint8_t v_filter = g_MAX11410_device.v_filter; // default to global property value
        if (cmdLine.parse_uint8_dec("v_filter", v_filter))
        {
            g_MAX11410_device.v_filter = v_filter; // update global property value
        }

// CODE GENERATOR: testMenuGlobalArgsDict['v_pga']['alias'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['v_pga']['argtype'] = 'uint8_t'
// CODE GENERATOR: testMenuGlobalArgsDict['v_pga']['usedByCommandName'] = 'None'
// CODE GENERATOR: testMenuGlobalArgsDict['v_pga']['usedBytestMenuItemName'] = 'None'
                    // parse argument uint8_t v_pga
        uint8_t v_pga = g_MAX11410_device.v_pga; // default to global property value
        if (cmdLine.parse_uint8_dec("v_pga", v_pga))
        {
            g_MAX11410_device.v_pga = v_pga; // update global property value
        }

    switch (cmdLine[0])
    {
// CODE GENERATOR: generate * command read/write reg *reg? *reg=value
        case '*':
        {
            // respond to SCPI query "*idn?" with device id string
            if ((strcmp(cmdLine.str(), "*idn?") == 0) || (strcmp(cmdLine.str(), "*IDN?") == 0)) {
                cmdLine.serial().printf("MAXIM,MAX11410\r\n");
                return true; // command handled by MAX11410
            }
            // if buffer starts with a regName:
            // for each reg value (0..n) if(cmdLine.has_keyword(device.regName(r))):
            cmdLine.serial().printf(" scan RegName...\r\n");
            for (uint8_t regAddress = 0; regAddress < 0x80; regAddress++)
            {
                uint32_t regData = 0;
                bool is_regname_query = false;
                bool is_regname_assignment = false;
                if (cmdLine.parse_uint32_dec(g_MAX11410_device.RegName((MAX11410::MAX11410_CMD_enum_t)regAddress), regData))
                {
                    cmdLine.serial().printf(" regAddress=0x%2.2X\r\n", (regAddress & 0xFF));
                    cmdLine.serial().printf(" RegName=%s\r\n", g_MAX11410_device.RegName((MAX11410::MAX11410_CMD_enum_t)regAddress));
                    // accept regName "?" as "RegRead" by name
                    is_regname_query = (cmdLine.chSeparator == '?');
                    is_regname_assignment = (cmdLine.chSeparator == '=');
                    if (is_regname_query)
                    {
                        cmdLine.serial().printf(" RegRead");
                        g_MAX11410_device.RegRead((MAX11410::MAX11410_CMD_enum_t)regAddress, &regData);
                        cmdLine.serial().printf("regData=0x%6.6lx\r\n", (regData & 0x00FFFFFF));
                        return true; // command handled by MAX11410
                    }
                    // accept regName "=0x123456" as "RegWrite" by name
                    if (is_regname_assignment)
                    {
                        cmdLine.serial().printf(" RegWrite");
                        cmdLine.serial().printf("regData=0x%6.6lx\r\n", (regData & 0x00FFFFFF));
                        g_MAX11410_device.RegWrite((MAX11410::MAX11410_CMD_enum_t)regAddress, regData);
                        return true; // command handled by MAX11410
                    }
                }
            } // end for regAddr
            // not a valid register name
            Callback<void(size_t, uint8_t*, uint8_t*)> saved_onSPIprint_handler = g_MAX11410_device.onSPIprint;
            g_MAX11410_device.onSPIprint = NULL; // temporarily suppress SPI diagnostic messages
            // read "all" registers by name
            for (uint8_t readAllStatusIndex = 0; readAllStatusIndex < g_MAX11410_device.readAllStatusListLen; readAllStatusIndex++)
            {
                MAX11410::MAX11410_CMD_enum_t regAddress = g_MAX11410_device.readAllStatusList[readAllStatusIndex];
                uint32_t regData = 0;
                if (g_MAX11410_device.RegSize(regAddress) == 0) continue; // skip undefined regs
                if (g_MAX11410_device.RegRead(regAddress, &regData) == 0) continue; // skip unreadable regs
                cmdLine.serial().printf("%s=0x%6.6lx\r\n", g_MAX11410_device.RegName(regAddress), regData);
            } // end for regAddr
            g_MAX11410_device.onSPIprint = saved_onSPIprint_handler;
            return true; // command handled by MAX11410
        }
        break;

// CODE GENERATOR: generate @ command print global property values of g_MAX11410_device
        case '@':
        {
// CODE GENERATOR: @ command print double g_MAX11410_device.ref0_v
                    cmdLine.serial().printf("ref0_v = ");
// CODE GENERATOR: @ command print double g_MAX11410_device.ref0_v property name ending in physical units v
                    cmdLine.serial().printf("%1.6f\r\n", g_MAX11410_device.ref0_v);
// CODE GENERATOR: @ command print double g_MAX11410_device.ref1_v
                    cmdLine.serial().printf("ref1_v = ");
// CODE GENERATOR: @ command print double g_MAX11410_device.ref1_v property name ending in physical units v
                    cmdLine.serial().printf("%1.6f\r\n", g_MAX11410_device.ref1_v);
// CODE GENERATOR: @ command print double g_MAX11410_device.ref2_v
                    cmdLine.serial().printf("ref2_v = ");
// CODE GENERATOR: @ command print double g_MAX11410_device.ref2_v property name ending in physical units v
                    cmdLine.serial().printf("%1.6f\r\n", g_MAX11410_device.ref2_v);
// CODE GENERATOR: @ command print double g_MAX11410_device.avdd_v
                    cmdLine.serial().printf("avdd_v = ");
// CODE GENERATOR: @ command print double g_MAX11410_device.avdd_v property name ending in physical units v
                    cmdLine.serial().printf("%1.6f\r\n", g_MAX11410_device.avdd_v);
// CODE GENERATOR: @ command print uint32_t g_MAX11410_device.ctrl
                    cmdLine.serial().printf("ctrl = ");
// CODE GENERATOR: @ command print uint32_t g_MAX11410_device.ctrl no recognized physical unit, show both decimal and hexadecimal
                    cmdLine.serial().printf("%ld = 0x%8.8lx\r\n", g_MAX11410_device.ctrl, g_MAX11410_device.ctrl);
// CODE GENERATOR: @ command print uint8_t g_MAX11410_device.pgaGain
                    cmdLine.serial().printf("pgaGain = ");
// CODE GENERATOR: @ command print uint8_t g_MAX11410_device.pgaGain no recognized physical unit, show both decimal and hexadecimal
                    cmdLine.serial().printf("%d = 0x%2.2x\r\n", g_MAX11410_device.pgaGain, g_MAX11410_device.pgaGain);
// CODE GENERATOR: @ command print uint32_t g_MAX11410_device.status
                    cmdLine.serial().printf("status = ");
// CODE GENERATOR: @ command print uint32_t g_MAX11410_device.status no recognized physical unit, show both decimal and hexadecimal
                    cmdLine.serial().printf("%ld = 0x%8.8lx\r\n", g_MAX11410_device.status, g_MAX11410_device.status);
// CODE GENERATOR: @ command print uint32_t g_MAX11410_device.data0
                    cmdLine.serial().printf("data0 = ");
// CODE GENERATOR: @ command print uint32_t g_MAX11410_device.data0 no recognized physical unit, show both decimal and hexadecimal
                    cmdLine.serial().printf("%ld = 0x%8.8lx\r\n", g_MAX11410_device.data0, g_MAX11410_device.data0);
// CODE GENERATOR: @ command print uint32_t array g_MAX11410_device.AINcode[0..10]
                for(int index = 0; (index < 11) && (index < 16); index++) {
                    cmdLine.serial().printf("AINcode[%d] = ", index);
                    cmdLine.serial().printf("%ld = 0x%8.8lx\r\n", g_MAX11410_device.AINcode[index], g_MAX11410_device.AINcode[index]);
                }
// CODE GENERATOR: @ command print int g_MAX11410_device.loop_limit
                    cmdLine.serial().printf("loop_limit = ");
// CODE GENERATOR: @ command print int g_MAX11410_device.loop_limit no recognized physical unit, show both decimal and hexadecimal
                    cmdLine.serial().printf("%d = 0x%4.4x\r\n", g_MAX11410_device.loop_limit, g_MAX11410_device.loop_limit);
// CODE GENERATOR: @ command omit constant property MAX11410::MAX11410_CMD_enum_t* g_MAX11410_device.readAllStatusList
// CODE GENERATOR: @ command omit constant property uint8_t g_MAX11410_device.readAllStatusListLen
// CODE GENERATOR: @ command print int g_MAX11410_device.rtd_ms
                    cmdLine.serial().printf("rtd_ms = ");
// CODE GENERATOR: @ command print int g_MAX11410_device.rtd_ms property name ending in physical units ms
                    cmdLine.serial().printf("%d\r\n", g_MAX11410_device.rtd_ms);
// CODE GENERATOR: @ command print double g_MAX11410_device.rtd_ohm
                    cmdLine.serial().printf("rtd_ohm = ");
// CODE GENERATOR: @ command print double g_MAX11410_device.rtd_ohm property name ending in physical units ohm
                    cmdLine.serial().printf("%1.6f\r\n", g_MAX11410_device.rtd_ohm);
// CODE GENERATOR: @ command print double g_MAX11410_device.rtd_degc
                    cmdLine.serial().printf("rtd_degc = ");
// CODE GENERATOR: @ command print double g_MAX11410_device.rtd_degc property name ending in physical units degc
                    cmdLine.serial().printf("%1.6f\r\n", g_MAX11410_device.rtd_degc);
// CODE GENERATOR: @ command print uint8_t g_MAX11410_device.rtd_filter
                    cmdLine.serial().printf("rtd_filter = ");
// CODE GENERATOR: @ command print uint8_t g_MAX11410_device.rtd_filter no recognized physical unit, show both decimal and hexadecimal
                    cmdLine.serial().printf("%d = 0x%2.2x\r\n", g_MAX11410_device.rtd_filter, g_MAX11410_device.rtd_filter);
// CODE GENERATOR: @ command print uint8_t g_MAX11410_device.rtd_ctrl
                    cmdLine.serial().printf("rtd_ctrl = ");
// CODE GENERATOR: @ command print uint8_t g_MAX11410_device.rtd_ctrl no recognized physical unit, show both decimal and hexadecimal
                    cmdLine.serial().printf("%d = 0x%2.2x\r\n", g_MAX11410_device.rtd_ctrl, g_MAX11410_device.rtd_ctrl);
// CODE GENERATOR: @ command print uint8_t g_MAX11410_device.rtd_source
                    cmdLine.serial().printf("rtd_source = ");
// CODE GENERATOR: @ command print uint8_t g_MAX11410_device.rtd_source property name ending in physical units s
                    cmdLine.serial().printf("%d\r\n", g_MAX11410_device.rtd_source);
// CODE GENERATOR: @ command print uint8_t g_MAX11410_device.rtd_pga
                    cmdLine.serial().printf("rtd_pga = ");
// CODE GENERATOR: @ command print uint8_t g_MAX11410_device.rtd_pga no recognized physical unit, show both decimal and hexadecimal
                    cmdLine.serial().printf("%d = 0x%2.2x\r\n", g_MAX11410_device.rtd_pga, g_MAX11410_device.rtd_pga);
// CODE GENERATOR: @ command print uint8_t g_MAX11410_device.v_filter
                    cmdLine.serial().printf("v_filter = ");
// CODE GENERATOR: @ command print uint8_t g_MAX11410_device.v_filter no recognized physical unit, show both decimal and hexadecimal
                    cmdLine.serial().printf("%d = 0x%2.2x\r\n", g_MAX11410_device.v_filter, g_MAX11410_device.v_filter);
// CODE GENERATOR: @ command print uint8_t g_MAX11410_device.v_ctrl
                    cmdLine.serial().printf("v_ctrl = ");
// CODE GENERATOR: @ command print uint8_t g_MAX11410_device.v_ctrl no recognized physical unit, show both decimal and hexadecimal
                    cmdLine.serial().printf("%d = 0x%2.2x\r\n", g_MAX11410_device.v_ctrl, g_MAX11410_device.v_ctrl);
// CODE GENERATOR: @ command print uint8_t g_MAX11410_device.v_pga
                    cmdLine.serial().printf("v_pga = ");
// CODE GENERATOR: @ command print uint8_t g_MAX11410_device.v_pga no recognized physical unit, show both decimal and hexadecimal
                    cmdLine.serial().printf("%d = 0x%2.2x\r\n", g_MAX11410_device.v_pga, g_MAX11410_device.v_pga);
// CODE GENERATOR: @ command print double g_MAX11410_device.tc_v
                    cmdLine.serial().printf("tc_v = ");
// CODE GENERATOR: @ command print double g_MAX11410_device.tc_v property name ending in physical units v
                    cmdLine.serial().printf("%1.6f\r\n", g_MAX11410_device.tc_v);
// CODE GENERATOR: @ command print double g_MAX11410_device.tc_delta_degc
                    cmdLine.serial().printf("tc_delta_degc = ");
// CODE GENERATOR: @ command print double g_MAX11410_device.tc_delta_degc property name ending in physical units degc
                    cmdLine.serial().printf("%1.6f\r\n", g_MAX11410_device.tc_delta_degc);
// CODE GENERATOR: @ command print double g_MAX11410_device.tc_degc
                    cmdLine.serial().printf("tc_degc = ");
// CODE GENERATOR: @ command print double g_MAX11410_device.tc_degc property name ending in physical units degc
                    cmdLine.serial().printf("%1.6f\r\n", g_MAX11410_device.tc_degc);
                    return true; // command handled by MAX11410
            break;
        }
// CODE GENERATOR: TODO1: generate GPIO commands for LDAC, CLR, etc. based on device driver function names
        // case 'G'..'Z','g'..'z' are reserved for GPIO commands
        // case 'A'..'F','a'..'f' may be available if not claimed by bitstream commands

// CODE GENERATOR: test menu
        // case '0'..'9','A'..'F','a'..'f' letters are reserved for bitstream commands
        // has_register_write_command: case '0'..'9','A'..'F','a'..'f' letters are reserved for bitstream commands
// CODE GENERATOR: top of loop: testMenuCommand="!", testMenuFirstCharHandler="None"
// CODE GENERATOR: test menu case '!':
// CODE GENERATOR:           helpString '! -- Init'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Init'
// CODE GENERATOR:           CommandParamIn 'void'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn ''
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
// CODE GENERATOR:           CommandTest '@test Init() expect 1'
// CODE GENERATOR:           CommandTest '@test group POR // verify initial register values'
// CODE GENERATOR:           CommandTest '@test group PORverbose // verify initial register values'
// CODE GENERATOR:           CommandTest '@test group PORverbose tinyTester.print("PART_ID value")'
// CODE GENERATOR:           CommandTest '@test group POR RegRead(MAX11410::CMD_r001_0001_xxxx_xxxx_xxxx_xxxx_xxxx_xddd_PART_ID, buffer) expect 1 expect-buffer 0x000F02'
// CODE GENERATOR:           CommandTest '@test group PORverbose tinyTester.print("POR value 0x04 CMD_r000_0100_dddd_xddd_GP0_CTRL")'
// CODE GENERATOR:           CommandTest '@test group POR RegRead(MAX11410::CMD_r000_0100_dddd_xddd_GP0_CTRL, buffer) expect 1 expect-buffer 0x00'
// CODE GENERATOR:           CommandTest '@test group PORverbose tinyTester.print("POR value 0x05 CMD_r000_0101_dddd_xddd_GP1_CTRL")'
// CODE GENERATOR:           CommandTest '@test group POR RegRead(MAX11410::CMD_r000_0101_dddd_xddd_GP1_CTRL, buffer) expect 1 expect-buffer 0x00'
// CODE GENERATOR:           CommandTest '@test group PORverbose tinyTester.print("POR value 0x07 CMD_r000_0111_xddd_dddd_GP_SEQ_ADDR")'
// CODE GENERATOR:           CommandTest '@test group POR RegRead(MAX11410::CMD_r000_0111_xddd_dddd_GP_SEQ_ADDR, buffer) expect 1 expect-buffer 0x00003a'
// CODE GENERATOR:           CommandTest '@test group PORverbose tinyTester.print("POR value 0x08 CMD_r000_1000_x0dd_dddd_FILTER")'
// CODE GENERATOR:           CommandTest '@test group POR RegRead(MAX11410::CMD_r000_1000_x0dd_dddd_FILTER, buffer) expect 1 expect-buffer 0x00'
// CODE GENERATOR:           CommandTest '@test group PORverbose tinyTester.print("POR value 0x09 CMD_r000_1001_dddd_dddd_CTRL")'
// CODE GENERATOR:           CommandTest '@test group POR RegRead(MAX11410::CMD_r000_1001_dddd_dddd_CTRL, buffer) expect 1 expect-buffer 0x000001'
// CODE GENERATOR:           CommandTest '@test group PORverbose tinyTester.print("POR value 0x0a CMD_r000_1010_dddd_dddd_SOURCE")'
// CODE GENERATOR:           CommandTest '@test group POR RegRead(MAX11410::CMD_r000_1010_dddd_dddd_SOURCE, buffer) expect 1 expect-buffer 0x00'
// CODE GENERATOR:           CommandTest '@test group PORverbose tinyTester.print("POR value 0x0b CMD_r000_1011_dddd_dddd_MUX_CTRL0")'
// CODE GENERATOR:           CommandTest '@test group POR RegRead(MAX11410::CMD_r000_1011_dddd_dddd_MUX_CTRL0, buffer) expect 1 expect-buffer 0x0000ff'
// CODE GENERATOR:           CommandTest '@test group PORverbose tinyTester.print("POR value 0x0c CMD_r000_1100_dddd_dddd_MUX_CTRL1")'
// CODE GENERATOR:           CommandTest '@test group POR RegRead(MAX11410::CMD_r000_1100_dddd_dddd_MUX_CTRL1, buffer) expect 1 expect-buffer 0x0000ff'
// CODE GENERATOR:           CommandTest '@test group PORverbose tinyTester.print("POR value 0x0d CMD_r000_1101_dddd_dddd_MUX_CTRL2")'
// CODE GENERATOR:           CommandTest '@test group POR RegRead(MAX11410::CMD_r000_1101_dddd_dddd_MUX_CTRL2, buffer) expect 1 expect-buffer 0x00'
// CODE GENERATOR:           CommandTest '@test group PORverbose tinyTester.print("POR value 0x0e CMD_r000_1110_00ss_0ggg_PGA")'
// CODE GENERATOR:           CommandTest '@test group POR RegRead(MAX11410::CMD_r000_1110_00ss_0ggg_PGA, buffer) expect 1 expect-buffer 0x00'
// CODE GENERATOR:           CommandTest '@test group RES1KA2A3TOGND // measure a 1kohm resistor between (AIN2,AIN3) and AGND to verify ref2_v (disabled by default)'
// CODE GENERATOR:           CommandTest '@test group RES1KA2A3TOGNDMORE // measure a 1kohm resistor between (AIN2,AIN3) and AGND to verify ref2_v in more detail'
// CODE GENERATOR:           CommandTest '@test group RES1KA2A3TOGNDMORE tinyTester.print("measure a 1kohm resistor between (AIN2,AIN3) and AGND to verify ref2_v")'
// CODE GENERATOR:           CommandTest '@test group RES1KA2A3TOGND tinyTester.settle_time_msec = 1000 // default 250'
// CODE GENERATOR:           CommandTest '@test group RES1KA2A3TOGND RegWrite(0x0C, 0xF3) expect 1 // *mux_ctrl1=0xf3 drives current source from AIN3'
// CODE GENERATOR:           CommandTest '@test group RES1KA2A3TOGNDMORE RegWrite(0x0A, 0x03) expect 1 // *source=0x03 idac_mode=100uA, 1k resistor 0.1V'
// CODE GENERATOR:           CommandTest '@test group RES1KA2A3TOGNDMORE tinyTester.print("idac_mode=100uA, 1k resistor 0.1V")'
// CODE GENERATOR:           CommandTest '@test group RES1KA2A3TOGNDMORE tinyTester.Wait_Output_Settling()'
// CODE GENERATOR:           CommandTest '@test group RES1KA2A3TOGNDMORE Measure_Voltage(2,10) expect 0.1'
// CODE GENERATOR:           CommandTest '@test group RES1KA2A3TOGNDMORE AINcode[2] expect (uint32_t)337731 within 33773 // idac_mode=100uA, 1k resistor 0.1V'
// CODE GENERATOR:           CommandTest '@test group RES1KA2A3TOGNDMORE RegWrite(0x0A, 0x0D) expect 1 // *source=0x0d idac_mode=800uA, 1k resistor 0.8V'
// CODE GENERATOR:           CommandTest '@test group RES1KA2A3TOGNDMORE tinyTester.print("idac_mode=800uA, 1k resistor 0.8V")'
// CODE GENERATOR:           CommandTest '@test group RES1KA2A3TOGNDMORE tinyTester.Wait_Output_Settling()'
// CODE GENERATOR:           CommandTest '@test group RES1KA2A3TOGNDMORE Measure_Voltage(2,10) expect 0.8'
// CODE GENERATOR:           CommandTest '@test group RES1KA2A3TOGNDMORE AINcode[2] expect (uint32_t)2724467 within 33773 // idac_mode=800uA, 1k resistor 0.8V'
// CODE GENERATOR:           CommandTest '@test group RES1KA2A3TOGND RegWrite(0x0A, 0x0B) expect 1 // *source=0x0b idac_mode=400uA, 1k resistor 0.4V'
// CODE GENERATOR:           CommandTest '@test group RES1KA2A3TOGNDMORE tinyTester.print("idac_mode=400uA, 1k resistor 0.4V")'
// CODE GENERATOR:           CommandTest '@test group RES1KA2A3TOGND tinyTester.Wait_Output_Settling()'
// CODE GENERATOR:           CommandTest '@test group RES1KA2A3TOGND Measure_Voltage(2,10) expect 0.4'
// CODE GENERATOR:           CommandTest '@test group RES1KA2A3TOGNDMORE AINcode[2] expect (uint32_t)1343163 within 33773 // idac_mode=400uA, 1k resistor 0.4V'
// CODE GENERATOR:           CommandTest '@test tinyTester.print("check filter register is writeable")'
// CODE GENERATOR:           CommandTest '@test RegWrite(0x08, 0x34) expect 1'
// CODE GENERATOR:           CommandTest '@test tinyTester.print("check filter register is readable")'
// CODE GENERATOR:           CommandTest '@test RegRead(0x08, buffer) expect 1 expect-buffer 0x34'
// CODE GENERATOR:           CommandTest '@test tinyTester.settle_time_msec = 250 // default 250'
// CODE GENERATOR:           CommandTest '@test tinyTester.blink_time_msec = 75 // default 75 resume hardware self test'
// CODE GENERATOR:           CommandTest '@test tinyTester.input_timeout_time_msec = 250 // default 250'
// CODE GENERATOR:           CommandTest '@test tinyTester.settle_time_msec = 20 // default 250'
// CODE GENERATOR:           CommandTest '@test tinyTester.blink_time_msec = 20 // quickly speed through the software verification'
// CODE GENERATOR:           CommandTest '@test tinyTester.input_timeout_time_msec = 100 // default 250'
// CODE GENERATOR:           CommandTest '@test tinyTester.Wait_Output_Settling()'
        // case '!': // (single character) (testMenuFirstCharHandler="None")
        case '!':
        {
                    // test menu command '!' handler:
                    // helpString='! -- Init'
                    // CMD_='None'
                    // CommandName='Init'
                    // CommandParamIn='void'
                    // CommandReturnType='uint8_t'
                    // @Pre=''
                    // @Param[in]=''
                    // @Param[out]=''
                    // @Post=''
                    // displayPost=''
                    // @Return='@return 1 on success; 0 on failure'
                    // @Test='@test Init() expect 1'
                    // @Test='@test group POR // verify initial register values'
                    // @Test='@test group PORverbose // verify initial register values'
                    // @Test='@test group PORverbose tinyTester.print("PART_ID value")'
                    // @Test='@test group POR RegRead(MAX11410::CMD_r001_0001_xxxx_xxxx_xxxx_xxxx_xxxx_xddd_PART_ID, buffer) expect 1 expect-buffer 0x000F02'
                    // @Test='@test group PORverbose tinyTester.print("POR value 0x04 CMD_r000_0100_dddd_xddd_GP0_CTRL")'
                    // @Test='@test group POR RegRead(MAX11410::CMD_r000_0100_dddd_xddd_GP0_CTRL, buffer) expect 1 expect-buffer 0x00'
                    // @Test='@test group PORverbose tinyTester.print("POR value 0x05 CMD_r000_0101_dddd_xddd_GP1_CTRL")'
                    // @Test='@test group POR RegRead(MAX11410::CMD_r000_0101_dddd_xddd_GP1_CTRL, buffer) expect 1 expect-buffer 0x00'
                    // @Test='@test group PORverbose tinyTester.print("POR value 0x07 CMD_r000_0111_xddd_dddd_GP_SEQ_ADDR")'
                    // @Test='@test group POR RegRead(MAX11410::CMD_r000_0111_xddd_dddd_GP_SEQ_ADDR, buffer) expect 1 expect-buffer 0x00003a'
                    // @Test='@test group PORverbose tinyTester.print("POR value 0x08 CMD_r000_1000_x0dd_dddd_FILTER")'
                    // @Test='@test group POR RegRead(MAX11410::CMD_r000_1000_x0dd_dddd_FILTER, buffer) expect 1 expect-buffer 0x00'
                    // @Test='@test group PORverbose tinyTester.print("POR value 0x09 CMD_r000_1001_dddd_dddd_CTRL")'
                    // @Test='@test group POR RegRead(MAX11410::CMD_r000_1001_dddd_dddd_CTRL, buffer) expect 1 expect-buffer 0x000001'
                    // @Test='@test group PORverbose tinyTester.print("POR value 0x0a CMD_r000_1010_dddd_dddd_SOURCE")'
                    // @Test='@test group POR RegRead(MAX11410::CMD_r000_1010_dddd_dddd_SOURCE, buffer) expect 1 expect-buffer 0x00'
                    // @Test='@test group PORverbose tinyTester.print("POR value 0x0b CMD_r000_1011_dddd_dddd_MUX_CTRL0")'
                    // @Test='@test group POR RegRead(MAX11410::CMD_r000_1011_dddd_dddd_MUX_CTRL0, buffer) expect 1 expect-buffer 0x0000ff'
                    // @Test='@test group PORverbose tinyTester.print("POR value 0x0c CMD_r000_1100_dddd_dddd_MUX_CTRL1")'
                    // @Test='@test group POR RegRead(MAX11410::CMD_r000_1100_dddd_dddd_MUX_CTRL1, buffer) expect 1 expect-buffer 0x0000ff'
                    // @Test='@test group PORverbose tinyTester.print("POR value 0x0d CMD_r000_1101_dddd_dddd_MUX_CTRL2")'
                    // @Test='@test group POR RegRead(MAX11410::CMD_r000_1101_dddd_dddd_MUX_CTRL2, buffer) expect 1 expect-buffer 0x00'
                    // @Test='@test group PORverbose tinyTester.print("POR value 0x0e CMD_r000_1110_00ss_0ggg_PGA")'
                    // @Test='@test group POR RegRead(MAX11410::CMD_r000_1110_00ss_0ggg_PGA, buffer) expect 1 expect-buffer 0x00'
                    // @Test='@test group RES1KA2A3TOGND // measure a 1kohm resistor between (AIN2,AIN3) and AGND to verify ref2_v (disabled by default)'
                    // @Test='@test group RES1KA2A3TOGNDMORE // measure a 1kohm resistor between (AIN2,AIN3) and AGND to verify ref2_v in more detail'
                    // @Test='@test group RES1KA2A3TOGNDMORE tinyTester.print("measure a 1kohm resistor between (AIN2,AIN3) and AGND to verify ref2_v")'
                    // @Test='@test group RES1KA2A3TOGND tinyTester.settle_time_msec = 1000 // default 250'
                    // @Test='@test group RES1KA2A3TOGND RegWrite(0x0C, 0xF3) expect 1 // *mux_ctrl1=0xf3 drives current source from AIN3'
                    // @Test='@test group RES1KA2A3TOGNDMORE RegWrite(0x0A, 0x03) expect 1 // *source=0x03 idac_mode=100uA, 1k resistor 0.1V'
                    // @Test='@test group RES1KA2A3TOGNDMORE tinyTester.print("idac_mode=100uA, 1k resistor 0.1V")'
                    // @Test='@test group RES1KA2A3TOGNDMORE tinyTester.Wait_Output_Settling()'
                    // @Test='@test group RES1KA2A3TOGNDMORE Measure_Voltage(2,10) expect 0.1'
                    // @Test='@test group RES1KA2A3TOGNDMORE AINcode[2] expect (uint32_t)337731 within 33773 // idac_mode=100uA, 1k resistor 0.1V'
                    // @Test='@test group RES1KA2A3TOGNDMORE RegWrite(0x0A, 0x0D) expect 1 // *source=0x0d idac_mode=800uA, 1k resistor 0.8V'
                    // @Test='@test group RES1KA2A3TOGNDMORE tinyTester.print("idac_mode=800uA, 1k resistor 0.8V")'
                    // @Test='@test group RES1KA2A3TOGNDMORE tinyTester.Wait_Output_Settling()'
                    // @Test='@test group RES1KA2A3TOGNDMORE Measure_Voltage(2,10) expect 0.8'
                    // @Test='@test group RES1KA2A3TOGNDMORE AINcode[2] expect (uint32_t)2724467 within 33773 // idac_mode=800uA, 1k resistor 0.8V'
                    // @Test='@test group RES1KA2A3TOGND RegWrite(0x0A, 0x0B) expect 1 // *source=0x0b idac_mode=400uA, 1k resistor 0.4V'
                    // @Test='@test group RES1KA2A3TOGNDMORE tinyTester.print("idac_mode=400uA, 1k resistor 0.4V")'
                    // @Test='@test group RES1KA2A3TOGND tinyTester.Wait_Output_Settling()'
                    // @Test='@test group RES1KA2A3TOGND Measure_Voltage(2,10) expect 0.4'
                    // @Test='@test group RES1KA2A3TOGNDMORE AINcode[2] expect (uint32_t)1343163 within 33773 // idac_mode=400uA, 1k resistor 0.4V'
                    // @Test='@test tinyTester.print("check filter register is writeable")'
                    // @Test='@test RegWrite(0x08, 0x34) expect 1'
                    // @Test='@test tinyTester.print("check filter register is readable")'
                    // @Test='@test RegRead(0x08, buffer) expect 1 expect-buffer 0x34'
                    // @Test='@test tinyTester.settle_time_msec = 250 // default 250'
                    // @Test='@test tinyTester.blink_time_msec = 75 // default 75 resume hardware self test'
                    // @Test='@test tinyTester.input_timeout_time_msec = 250 // default 250'
                    // @Test='@test tinyTester.settle_time_msec = 20 // default 250'
                    // @Test='@test tinyTester.blink_time_msec = 20 // quickly speed through the software verification'
                    // @Test='@test tinyTester.input_timeout_time_msec = 100 // default 250'
                    // @Test='@test tinyTester.Wait_Output_Settling()'
                    cmdLine.serial().printf("Init");
                    // call function Init
                    uint8_t result = g_MAX11410_device.Init();
                    cmdLine.serial().printf(" =%d\r\n", result);
                    return true; // command handled by MAX11410
// CODE GENERATOR: bottom of loop: testMenuCommand="!", testMenuFirstCharHandler="None"
        } // end case '!'
        break;

// CODE GENERATOR: top of loop: testMenuCommand="$", testMenuFirstCharHandler="None"
// CODE GENERATOR: test menu case '$':
// CODE GENERATOR:           helpString '$ -- Read_All_Voltages'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Read_All_Voltages'
// CODE GENERATOR:           CommandParamIn 'void'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn ''
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost '@post AINcode[0..10]: measurement result LSB code'
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
        // case '$': // (single character) (testMenuFirstCharHandler="None")
        case '$':
        {
                    // test menu command '$' handler:
                    // helpString='$ -- Read_All_Voltages'
                    // CMD_='None'
                    // CommandName='Read_All_Voltages'
                    // CommandParamIn='void'
                    // CommandReturnType='uint8_t'
                    // @Pre=''
                    // @Param[in]=''
                    // @Param[out]=''
                    // @Post='@post AINcode[0..10]: measurement result LSB code'
                    // displayPost='AINcode[0], AINcode[1], AINcode[2], AINcode[3], AINcode[4], AINcode[5], AINcode[6], AINcode[7], AINcode[8], AINcode[9], AINcode[10]'
                    // @Return='@return 1 on success; 0 on failure'
                    cmdLine.serial().printf("Read_All_Voltages");
                    // call function Read_All_Voltages
                    uint8_t result = g_MAX11410_device.Read_All_Voltages();
                    cmdLine.serial().printf(" =%d\r\n", result);
                    // Menu item '$' -> AINcode[0], AINcode[1], AINcode[2], AINcode[3], AINcode[4], AINcode[5], AINcode[6], AINcode[7], AINcode[8], AINcode[9], AINcode[10]
                    cmdLine.serial().printf("%s=%ld = 0x%8.8lx\r\n", "AINcode[0]", g_MAX11410_device.AINcode[0], g_MAX11410_device.AINcode[0]);
                    cmdLine.serial().printf("%s=%ld = 0x%8.8lx\r\n", "AINcode[1]", g_MAX11410_device.AINcode[1], g_MAX11410_device.AINcode[1]);
                    cmdLine.serial().printf("%s=%ld = 0x%8.8lx\r\n", "AINcode[2]", g_MAX11410_device.AINcode[2], g_MAX11410_device.AINcode[2]);
                    cmdLine.serial().printf("%s=%ld = 0x%8.8lx\r\n", "AINcode[3]", g_MAX11410_device.AINcode[3], g_MAX11410_device.AINcode[3]);
                    cmdLine.serial().printf("%s=%ld = 0x%8.8lx\r\n", "AINcode[4]", g_MAX11410_device.AINcode[4], g_MAX11410_device.AINcode[4]);
                    cmdLine.serial().printf("%s=%ld = 0x%8.8lx\r\n", "AINcode[5]", g_MAX11410_device.AINcode[5], g_MAX11410_device.AINcode[5]);
                    cmdLine.serial().printf("%s=%ld = 0x%8.8lx\r\n", "AINcode[6]", g_MAX11410_device.AINcode[6], g_MAX11410_device.AINcode[6]);
                    cmdLine.serial().printf("%s=%ld = 0x%8.8lx\r\n", "AINcode[7]", g_MAX11410_device.AINcode[7], g_MAX11410_device.AINcode[7]);
                    cmdLine.serial().printf("%s=%ld = 0x%8.8lx\r\n", "AINcode[8]", g_MAX11410_device.AINcode[8], g_MAX11410_device.AINcode[8]);
                    cmdLine.serial().printf("%s=%ld = 0x%8.8lx\r\n", "AINcode[9]", g_MAX11410_device.AINcode[9], g_MAX11410_device.AINcode[9]);
                    cmdLine.serial().printf("%s=%ld = 0x%8.8lx\r\n", "AINcode[10]", g_MAX11410_device.AINcode[10], g_MAX11410_device.AINcode[10]);
                    return true; // command handled by MAX11410
// CODE GENERATOR: bottom of loop: testMenuCommand="$", testMenuFirstCharHandler="None"
        } // end case '$'
        break;

// CODE GENERATOR: top of loop: testMenuCommand="R", testMenuFirstCharHandler="None"
// CODE GENERATOR: test menu case 'R':
// CODE GENERATOR:           helpString 'R  -- Measure_RTD'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Measure_RTD'
// CODE GENERATOR:           CommandParamIn 'MAX11410_AINP_SEL_enum_t rtd_iout, MAX11410_AINP_SEL_enum_t rtd_ainp, MAX11410_AINN_SEL_enum_t rtd_ainn'
// CODE GENERATOR:           CommandReturnType 'double'
// CODE GENERATOR:           CommandPre '@pre external connection REF1P-REF1N is a reference resistor'
// CODE GENERATOR:           CommandPre '@pre ref1_v = reference resistance in ohms, default=4999'
// CODE GENERATOR:           CommandPre '@pre rtd_filter = filter register configuration, 0x34 for LINEF_11_SINC4 RATE_0100 output data rate 60SPS'
// CODE GENERATOR:           CommandPre '@pre rtd_ctrl = ctrl register configuration, 0x40 for ref0_v, 0x41 for ref1_v, 0x42 for ref2_v'
// CODE GENERATOR:           CommandPre '@pre rtd_souce = souce register configuration, 0x0B for IDAC_MODE_1011_400uA'
// CODE GENERATOR:           CommandPre '@pre rtd_pga = pga register configuration, 0x21 for SIG_PATH_10_PGA GAIN_001_2'
// CODE GENERATOR:           CommandDocParamIn '@param[in] rtd_iout = channel RTD high side force, default=AINP_SEL_0111_AIN7'
// CODE GENERATOR:           CommandDocParamIn '@param[in] rtd_ainp = channel RTD high side sense, default=AINP_SEL_1000_AIN8'
// CODE GENERATOR:           CommandDocParamIn '@param[in] rtd_ainn = channel RTD low side, default=AINN_SEL_1001_AIN9'
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost '@post AINcode[rtd_ainp]: measurement result LSB code'
// CODE GENERATOR:           CommandPost '@post rtd_ohm: measurement result resistance in Ohms'
// CODE GENERATOR:           CommandPost '@post rtd_degc: Temperature calculated from RTD Resistance; Thermocouple Cold Junction, in degrees C'
// CODE GENERATOR:           CommandReturn '@return resistance calculated from raw LSB code and reference resistance'
        // case 'R': // (single character) (testMenuFirstCharHandler="None")
        case 'R':
        {
                    // test menu command 'R' handler:
                    // helpString='R  -- Measure_RTD'
                    // CMD_='None'
                    // CommandName='Measure_RTD'
                    // CommandParamIn='MAX11410_AINP_SEL_enum_t rtd_iout, MAX11410_AINP_SEL_enum_t rtd_ainp, MAX11410_AINN_SEL_enum_t rtd_ainn'
                    // CommandReturnType='double'
                    // @Pre='@pre external connection REF1P-REF1N is a reference resistor'
                    // @Pre='@pre ref1_v = reference resistance in ohms, default=4999'
                    // @Pre='@pre rtd_filter = filter register configuration, 0x34 for LINEF_11_SINC4 RATE_0100 output data rate 60SPS'
                    // @Pre='@pre rtd_ctrl = ctrl register configuration, 0x40 for ref0_v, 0x41 for ref1_v, 0x42 for ref2_v'
                    // @Pre='@pre rtd_souce = souce register configuration, 0x0B for IDAC_MODE_1011_400uA'
                    // @Pre='@pre rtd_pga = pga register configuration, 0x21 for SIG_PATH_10_PGA GAIN_001_2'
                    // @Param[in]='@param[in] rtd_iout = channel RTD high side force, default=AINP_SEL_0111_AIN7'
                    // @Param[in]='@param[in] rtd_ainp = channel RTD high side sense, default=AINP_SEL_1000_AIN8'
                    // @Param[in]='@param[in] rtd_ainn = channel RTD low side, default=AINN_SEL_1001_AIN9'
                    // @Param[out]=''
                    // @Post='@post AINcode[rtd_ainp]: measurement result LSB code'
                    // @Post='@post rtd_ohm: measurement result resistance in Ohms'
                    // @Post='@post rtd_degc: Temperature calculated from RTD Resistance; Thermocouple Cold Junction, in degrees C'
                    // displayPost='rtd_ohm, rtd_degc'
                    // @Return='@return resistance calculated from raw LSB code and reference resistance'
                    // parse argument list
                    // argname default_argvalue symbolic enum name specified in CommandDocParamIn @Param[in]='@param[in] rtd_iout = channel RTD high side force, default=AINP_SEL_0111_AIN7'
                    // parse argument MAX11410::MAX11410_AINP_SEL_enum_t rtd_iout
                    MAX11410::MAX11410_AINP_SEL_enum_t rtd_iout = MAX11410::AINP_SEL_0111_AIN7; // --- g_MAX11410_device.__WARNING_no_match_for_argname_rtd_iout_in_MAX11410_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("rtd_iout", (uint8_t&)rtd_iout))
                    {
                        // g_MAX11410_device.__WARNING_no_match_for_argname_rtd_iout_in_MAX11410_device_t__ = rtd_iout; // update global property value
                    }
                    // argname default_argvalue symbolic enum name specified in CommandDocParamIn @Param[in]='@param[in] rtd_ainp = channel RTD high side sense, default=AINP_SEL_1000_AIN8'
                    // parse argument MAX11410::MAX11410_AINP_SEL_enum_t rtd_ainp
                    MAX11410::MAX11410_AINP_SEL_enum_t rtd_ainp = MAX11410::AINP_SEL_1000_AIN8; // --- g_MAX11410_device.__WARNING_no_match_for_argname_rtd_ainp_in_MAX11410_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("rtd_ainp", (uint8_t&)rtd_ainp))
                    {
                        // g_MAX11410_device.__WARNING_no_match_for_argname_rtd_ainp_in_MAX11410_device_t__ = rtd_ainp; // update global property value
                    }
                    // argname default_argvalue symbolic enum name specified in CommandDocParamIn @Param[in]='@param[in] rtd_ainn = channel RTD low side, default=AINN_SEL_1001_AIN9'
                    // parse argument MAX11410::MAX11410_AINN_SEL_enum_t rtd_ainn
                    MAX11410::MAX11410_AINN_SEL_enum_t rtd_ainn = MAX11410::AINN_SEL_1001_AIN9; // --- g_MAX11410_device.__WARNING_no_match_for_argname_rtd_ainn_in_MAX11410_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("rtd_ainn", (uint8_t&)rtd_ainn))
                    {
                        // g_MAX11410_device.__WARNING_no_match_for_argname_rtd_ainn_in_MAX11410_device_t__ = rtd_ainn; // update global property value
                    }
                    // print arguments
                    cmdLine.serial().printf("Measure_RTD");
                    cmdLine.serial().printf(" rtd_iout=%d", rtd_iout);
                    cmdLine.serial().printf(" rtd_ainp=%d", rtd_ainp);
                    cmdLine.serial().printf(" rtd_ainn=%d", rtd_ainn);
                    cmdLine.serial().printf(" Measure_RTD"); // unique suffix
                    cmdLine.serial().printf("\r\n");
                    // call function Measure_RTD(rtd_iout, rtd_ainp, rtd_ainn)
                    double result = g_MAX11410_device.Measure_RTD(rtd_iout, rtd_ainp, rtd_ainn);
                    cmdLine.serial().printf(" =%f\r\n", result);
                    // Menu item 'R' -> rtd_ohm, rtd_degc
                    cmdLine.serial().printf("%s=%1.6f\r\n", "rtd_ohm", g_MAX11410_device.rtd_ohm);
                    cmdLine.serial().printf("%s=%1.6f\r\n", "rtd_degc", g_MAX11410_device.rtd_degc);
                    return true; // command handled by MAX11410
// CODE GENERATOR: bottom of loop: testMenuCommand="R", testMenuFirstCharHandler="None"
        } // end case 'R'
        break;

// CODE GENERATOR: top of loop: testMenuCommand="T", testMenuFirstCharHandler="None"
// CODE GENERATOR: test menu case 'T':
// CODE GENERATOR:           helpString 'T  -- Measure_Thermocouple'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Measure_Thermocouple'
// CODE GENERATOR:           CommandParamIn 'MAX11410_AINP_SEL_enum_t tc_ainp, MAX11410_AINN_SEL_enum_t tc_ainn, MAX11410_AINP_SEL_enum_t rtd_iout, MAX11410_AINP_SEL_enum_t rtd_ainp, MAX11410_AINN_SEL_enum_t rtd_ainn'
// CODE GENERATOR:           CommandReturnType 'double'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn '@param[in] tc_ainp = channel of Thermocouple high side, default=AINP_SEL_0101_AIN5'
// CODE GENERATOR:           CommandDocParamIn '@param[in] tc_ainn = channel of Thermocouple low side, default=AINN_SEL_0110_AIN6'
// CODE GENERATOR:           CommandDocParamIn '@param[in] rtd_iout = channel RTD high side force, default=AINP_SEL_0111_AIN7'
// CODE GENERATOR:           CommandDocParamIn '@param[in] rtd_ainp = channel RTD high side sense, default=AINP_SEL_1000_AIN8'
// CODE GENERATOR:           CommandDocParamIn '@param[in] rtd_ainn = channel RTD low side, default=AINN_SEL_1001_AIN9'
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost '@post AINcode[tc_ainp]: measurement result LSB code'
// CODE GENERATOR:           CommandPost '@post tc_v: raw thermocouple voltage in Volts'
// CODE GENERATOR:           CommandPost '@post tc_delta_degc: temperature in degC above cold junction'
// CODE GENERATOR:           CommandPost '@post tc_degc: temperature in degC'
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
        // case 'T': // (single character) (testMenuFirstCharHandler="None")
        case 'T':
        {
                    // test menu command 'T' handler:
                    // helpString='T  -- Measure_Thermocouple'
                    // CMD_='None'
                    // CommandName='Measure_Thermocouple'
                    // CommandParamIn='MAX11410_AINP_SEL_enum_t tc_ainp, MAX11410_AINN_SEL_enum_t tc_ainn, MAX11410_AINP_SEL_enum_t rtd_iout, MAX11410_AINP_SEL_enum_t rtd_ainp, MAX11410_AINN_SEL_enum_t rtd_ainn'
                    // CommandReturnType='double'
                    // @Pre=''
                    // @Param[in]='@param[in] tc_ainp = channel of Thermocouple high side, default=AINP_SEL_0101_AIN5'
                    // @Param[in]='@param[in] tc_ainn = channel of Thermocouple low side, default=AINN_SEL_0110_AIN6'
                    // @Param[in]='@param[in] rtd_iout = channel RTD high side force, default=AINP_SEL_0111_AIN7'
                    // @Param[in]='@param[in] rtd_ainp = channel RTD high side sense, default=AINP_SEL_1000_AIN8'
                    // @Param[in]='@param[in] rtd_ainn = channel RTD low side, default=AINN_SEL_1001_AIN9'
                    // @Param[out]=''
                    // @Post='@post AINcode[tc_ainp]: measurement result LSB code'
                    // @Post='@post tc_v: raw thermocouple voltage in Volts'
                    // @Post='@post tc_delta_degc: temperature in degC above cold junction'
                    // @Post='@post tc_degc: temperature in degC'
                    // displayPost='tc_v, tc_delta_degc, tc_degc'
                    // @Return='@return 1 on success; 0 on failure'
                    // parse argument list
                    // argname default_argvalue symbolic enum name specified in CommandDocParamIn @Param[in]='@param[in] tc_ainp = channel of Thermocouple high side, default=AINP_SEL_0101_AIN5'
                    // parse argument MAX11410::MAX11410_AINP_SEL_enum_t tc_ainp
                    MAX11410::MAX11410_AINP_SEL_enum_t tc_ainp = MAX11410::AINP_SEL_0101_AIN5; // --- g_MAX11410_device.__WARNING_no_match_for_argname_tc_ainp_in_MAX11410_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("tc_ainp", (uint8_t&)tc_ainp))
                    {
                        // g_MAX11410_device.__WARNING_no_match_for_argname_tc_ainp_in_MAX11410_device_t__ = tc_ainp; // update global property value
                    }
                    // argname default_argvalue symbolic enum name specified in CommandDocParamIn @Param[in]='@param[in] tc_ainn = channel of Thermocouple low side, default=AINN_SEL_0110_AIN6'
                    // parse argument MAX11410::MAX11410_AINN_SEL_enum_t tc_ainn
                    MAX11410::MAX11410_AINN_SEL_enum_t tc_ainn = MAX11410::AINN_SEL_0110_AIN6; // --- g_MAX11410_device.__WARNING_no_match_for_argname_tc_ainn_in_MAX11410_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("tc_ainn", (uint8_t&)tc_ainn))
                    {
                        // g_MAX11410_device.__WARNING_no_match_for_argname_tc_ainn_in_MAX11410_device_t__ = tc_ainn; // update global property value
                    }
                    // argname default_argvalue symbolic enum name specified in CommandDocParamIn @Param[in]='@param[in] rtd_iout = channel RTD high side force, default=AINP_SEL_0111_AIN7'
                    // parse argument MAX11410::MAX11410_AINP_SEL_enum_t rtd_iout
                    MAX11410::MAX11410_AINP_SEL_enum_t rtd_iout = MAX11410::AINP_SEL_0111_AIN7; // --- g_MAX11410_device.__WARNING_no_match_for_argname_rtd_iout_in_MAX11410_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("rtd_iout", (uint8_t&)rtd_iout))
                    {
                        // g_MAX11410_device.__WARNING_no_match_for_argname_rtd_iout_in_MAX11410_device_t__ = rtd_iout; // update global property value
                    }
                    // argname default_argvalue symbolic enum name specified in CommandDocParamIn @Param[in]='@param[in] rtd_ainp = channel RTD high side sense, default=AINP_SEL_1000_AIN8'
                    // parse argument MAX11410::MAX11410_AINP_SEL_enum_t rtd_ainp
                    MAX11410::MAX11410_AINP_SEL_enum_t rtd_ainp = MAX11410::AINP_SEL_1000_AIN8; // --- g_MAX11410_device.__WARNING_no_match_for_argname_rtd_ainp_in_MAX11410_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("rtd_ainp", (uint8_t&)rtd_ainp))
                    {
                        // g_MAX11410_device.__WARNING_no_match_for_argname_rtd_ainp_in_MAX11410_device_t__ = rtd_ainp; // update global property value
                    }
                    // argname default_argvalue symbolic enum name specified in CommandDocParamIn @Param[in]='@param[in] rtd_ainn = channel RTD low side, default=AINN_SEL_1001_AIN9'
                    // parse argument MAX11410::MAX11410_AINN_SEL_enum_t rtd_ainn
                    MAX11410::MAX11410_AINN_SEL_enum_t rtd_ainn = MAX11410::AINN_SEL_1001_AIN9; // --- g_MAX11410_device.__WARNING_no_match_for_argname_rtd_ainn_in_MAX11410_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("rtd_ainn", (uint8_t&)rtd_ainn))
                    {
                        // g_MAX11410_device.__WARNING_no_match_for_argname_rtd_ainn_in_MAX11410_device_t__ = rtd_ainn; // update global property value
                    }
                    // print arguments
                    cmdLine.serial().printf("Measure_Thermocouple");
                    cmdLine.serial().printf(" tc_ainp=%d", tc_ainp);
                    cmdLine.serial().printf(" tc_ainn=%d", tc_ainn);
                    cmdLine.serial().printf(" rtd_iout=%d", rtd_iout);
                    cmdLine.serial().printf(" rtd_ainp=%d", rtd_ainp);
                    cmdLine.serial().printf(" rtd_ainn=%d", rtd_ainn);
                    cmdLine.serial().printf(" Measure_Thermocouple"); // unique suffix
                    cmdLine.serial().printf("\r\n");
                    // call function Measure_Thermocouple(tc_ainp, tc_ainn, rtd_iout, rtd_ainp, rtd_ainn)
                    double result = g_MAX11410_device.Measure_Thermocouple(tc_ainp, tc_ainn, rtd_iout, rtd_ainp, rtd_ainn);
                    cmdLine.serial().printf(" =%f\r\n", result);
                    // Menu item 'T' -> tc_v, tc_delta_degc, tc_degc
                    cmdLine.serial().printf("%s=%1.6f\r\n", "tc_v", g_MAX11410_device.tc_v);
                    cmdLine.serial().printf("%s=%1.6f\r\n", "tc_delta_degc", g_MAX11410_device.tc_delta_degc);
                    cmdLine.serial().printf("%s=%1.6f\r\n", "tc_degc", g_MAX11410_device.tc_degc);
                    return true; // command handled by MAX11410
// CODE GENERATOR: bottom of loop: testMenuCommand="T", testMenuFirstCharHandler="None"
        } // end case 'T'
        break;

// CODE GENERATOR: top of loop: testMenuCommand="V", testMenuFirstCharHandler="None"
// CODE GENERATOR: test menu case 'V':
// CODE GENERATOR:           helpString 'V  -- Measure_Voltage'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Measure_Voltage'
// CODE GENERATOR:           CommandParamIn 'MAX11410_AINP_SEL_enum_t ainp, MAX11410_AINN_SEL_enum_t ainn'
// CODE GENERATOR:           CommandReturnType 'double'
// CODE GENERATOR:           CommandPre '@pre external connection REF2P-REF2N is a reference voltage'
// CODE GENERATOR:           CommandPre '@pre VRef = Voltage of REF input, in Volts'
// CODE GENERATOR:           CommandPre '@pre v_filter = filter register configuration, 0x34 for LINEF_11_SINC4 RATE_0100 output data rate 60SPS'
// CODE GENERATOR:           CommandPre '@pre v_ctrl = ctrl register configuration, 0x02 for bipolar REF_SEL_010_REF2P_REF2N'
// CODE GENERATOR:           CommandPre '@pre v_pga = pga register configuration, 0x00 for SIG_PATH_00_BUFFERED GAIN_000_1'
// CODE GENERATOR:           CommandDocParamIn '@param[in] ainp = channel high side, default=AINP_SEL_0000_AIN0'
// CODE GENERATOR:           CommandDocParamIn '@param[in] ainn = channel low side, default=AINN_SEL_1010_GND'
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost '@post AINcode[ainp]: measurement result LSB code'
// CODE GENERATOR:           CommandReturn '@return ideal voltage calculated from raw LSB code and reference voltage'
        // case 'V': // (single character) (testMenuFirstCharHandler="None")
        case 'V':
        {
                    // test menu command 'V' handler:
                    // helpString='V  -- Measure_Voltage'
                    // CMD_='None'
                    // CommandName='Measure_Voltage'
                    // CommandParamIn='MAX11410_AINP_SEL_enum_t ainp, MAX11410_AINN_SEL_enum_t ainn'
                    // CommandReturnType='double'
                    // @Pre='@pre external connection REF2P-REF2N is a reference voltage'
                    // @Pre='@pre VRef = Voltage of REF input, in Volts'
                    // @Pre='@pre v_filter = filter register configuration, 0x34 for LINEF_11_SINC4 RATE_0100 output data rate 60SPS'
                    // @Pre='@pre v_ctrl = ctrl register configuration, 0x02 for bipolar REF_SEL_010_REF2P_REF2N'
                    // @Pre='@pre v_pga = pga register configuration, 0x00 for SIG_PATH_00_BUFFERED GAIN_000_1'
                    // @Param[in]='@param[in] ainp = channel high side, default=AINP_SEL_0000_AIN0'
                    // @Param[in]='@param[in] ainn = channel low side, default=AINN_SEL_1010_GND'
                    // @Param[out]=''
                    // @Post='@post AINcode[ainp]: measurement result LSB code'
                    // displayPost=''
                    // @Return='@return ideal voltage calculated from raw LSB code and reference voltage'
                    // parse argument list
                    // argname default_argvalue symbolic enum name specified in CommandDocParamIn @Param[in]='@param[in] ainp = channel high side, default=AINP_SEL_0000_AIN0'
                    // parse argument MAX11410::MAX11410_AINP_SEL_enum_t ainp
                    MAX11410::MAX11410_AINP_SEL_enum_t ainp = MAX11410::AINP_SEL_0000_AIN0; // --- g_MAX11410_device.__WARNING_no_match_for_argname_ainp_in_MAX11410_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("ainp", (uint8_t&)ainp))
                    {
                        // g_MAX11410_device.__WARNING_no_match_for_argname_ainp_in_MAX11410_device_t__ = ainp; // update global property value
                    }
                    // argname default_argvalue symbolic enum name specified in CommandDocParamIn @Param[in]='@param[in] ainn = channel low side, default=AINN_SEL_1010_GND'
                    // parse argument MAX11410::MAX11410_AINN_SEL_enum_t ainn
                    MAX11410::MAX11410_AINN_SEL_enum_t ainn = MAX11410::AINN_SEL_1010_GND; // --- g_MAX11410_device.__WARNING_no_match_for_argname_ainn_in_MAX11410_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("ainn", (uint8_t&)ainn))
                    {
                        // g_MAX11410_device.__WARNING_no_match_for_argname_ainn_in_MAX11410_device_t__ = ainn; // update global property value
                    }
                    // print arguments
                    cmdLine.serial().printf("Measure_Voltage");
                    cmdLine.serial().printf(" ainp=%d", ainp);
                    cmdLine.serial().printf(" ainn=%d", ainn);
                    cmdLine.serial().printf(" Measure_Voltage"); // unique suffix
                    cmdLine.serial().printf("\r\n");
                    // call function Measure_Voltage(ainp, ainn)
                    double result = g_MAX11410_device.Measure_Voltage(ainp, ainn);
                    cmdLine.serial().printf(" =%f\r\n", result);
                    return true; // command handled by MAX11410
// CODE GENERATOR: bottom of loop: testMenuCommand="V", testMenuFirstCharHandler="None"
        } // end case 'V'
        break;

// CODE GENERATOR: top of loop: testMenuCommand="X0", testMenuFirstCharHandler="None"
// CODE GENERATOR: test menu case 'X0':
// CODE GENERATOR:           helpString 'X0 -- Calibrate_Self_Offset_Gain'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Calibrate_Self_Offset_Gain'
// CODE GENERATOR:           CommandParamIn 'void'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn ''
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
        case 'X': // (multiple characters) (testMenuFirstCharHandler="X"):
        {
            switch (cmdLine[1])
            {
                case '0': // (nested inside case 'X')
                {
                    // test menu command 'X0' handler:
                    // helpString='X0 -- Calibrate_Self_Offset_Gain'
                    // CMD_='None'
                    // CommandName='Calibrate_Self_Offset_Gain'
                    // CommandParamIn='void'
                    // CommandReturnType='uint8_t'
                    // @Pre=''
                    // @Param[in]=''
                    // @Param[out]=''
                    // @Post=''
                    // displayPost=''
                    // @Return='@return 1 on success; 0 on failure'
                    cmdLine.serial().printf("Calibrate_Self_Offset_Gain");
                    // call function Calibrate_Self_Offset_Gain
                    uint8_t result = g_MAX11410_device.Calibrate_Self_Offset_Gain();
                    cmdLine.serial().printf(" =%d\r\n", result);
                    return true; // command handled by MAX11410
// CODE GENERATOR: bottom of loop: testMenuCommand="X0", testMenuFirstCharHandler="X"
                } // end nested case 'X0'
                break;

// CODE GENERATOR: top of loop: testMenuCommand="X1", testMenuFirstCharHandler="X"
// CODE GENERATOR: top of loop: nested switch "X" is currently open
// CODE GENERATOR: test menu case 'X1':
// CODE GENERATOR:           helpString 'X1 -- Calibrate_PGA_Gain'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Calibrate_PGA_Gain'
// CODE GENERATOR:           CommandParamIn 'void'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn ''
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
                case '1': // (nested inside case 'X')
                {
                    // test menu command 'X1' handler:
                    // helpString='X1 -- Calibrate_PGA_Gain'
                    // CMD_='None'
                    // CommandName='Calibrate_PGA_Gain'
                    // CommandParamIn='void'
                    // CommandReturnType='uint8_t'
                    // @Pre=''
                    // @Param[in]=''
                    // @Param[out]=''
                    // @Post=''
                    // displayPost=''
                    // @Return='@return 1 on success; 0 on failure'
                    cmdLine.serial().printf("Calibrate_PGA_Gain");
                    // call function Calibrate_PGA_Gain
                    uint8_t result = g_MAX11410_device.Calibrate_PGA_Gain();
                    cmdLine.serial().printf(" =%d\r\n", result);
                    return true; // command handled by MAX11410
// CODE GENERATOR: bottom of loop: testMenuCommand="X1", testMenuFirstCharHandler="X"
                } // end nested case 'X1'
                break;

// CODE GENERATOR: top of loop: testMenuCommand="XC", testMenuFirstCharHandler="X"
// CODE GENERATOR: top of loop: nested switch "X" is currently open
// CODE GENERATOR: test menu case 'XC':
// CODE GENERATOR:           helpString 'XC extclk=? u_bn=? format=? refbufp_en=? refbufn_en=? ref_sel=? -- Configure_CTRL'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Configure_CTRL'
// CODE GENERATOR:           CommandParamIn 'uint8_t extclk, uint8_t u_bn, uint8_t format, uint8_t refbufp_en, uint8_t refbufn_en, uint8_t ref_sel'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn '@param[in] extclk = external clock enable, default=0'
// CODE GENERATOR:           CommandDocParamIn '@param[in] u_bn = unipolar input range enable, default=0'
// CODE GENERATOR:           CommandDocParamIn '@param[in] format = offset binary format enable, default=0'
// CODE GENERATOR:           CommandDocParamIn '@param[in] refbufp_en = REFP reference buffer enable, default=0'
// CODE GENERATOR:           CommandDocParamIn '@param[in] refbufn_en = REFN reference buffer enable, default=0'
// CODE GENERATOR:           CommandDocParamIn '@param[in] ref_sel = reference selection, default=MAX11410::MAX11410_REF_SEL_enum_t::REF_SEL_001_REF1P_REF1N'
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
                case 'C': // (nested inside case 'X')
                {
                    // test menu command 'XC' handler:
                    // helpString='XC extclk=? u_bn=? format=? refbufp_en=? refbufn_en=? ref_sel=? -- Configure_CTRL'
                    // CMD_='None'
                    // CommandName='Configure_CTRL'
                    // CommandParamIn='uint8_t extclk, uint8_t u_bn, uint8_t format, uint8_t refbufp_en, uint8_t refbufn_en, uint8_t ref_sel'
                    // CommandReturnType='uint8_t'
                    // @Pre=''
                    // @Param[in]='@param[in] extclk = external clock enable, default=0'
                    // @Param[in]='@param[in] u_bn = unipolar input range enable, default=0'
                    // @Param[in]='@param[in] format = offset binary format enable, default=0'
                    // @Param[in]='@param[in] refbufp_en = REFP reference buffer enable, default=0'
                    // @Param[in]='@param[in] refbufn_en = REFN reference buffer enable, default=0'
                    // @Param[in]='@param[in] ref_sel = reference selection, default=MAX11410::MAX11410_REF_SEL_enum_t::REF_SEL_001_REF1P_REF1N'
                    // @Param[out]=''
                    // @Post=''
                    // displayPost=''
                    // @Return='@return 1 on success; 0 on failure'
                    // parse argument list
                    // argname default_argvalue numeric literal specified in CommandDocParamIn @Param[in]='@param[in] extclk = external clock enable, default=0'
                    // parse argument uint8_t extclk
                    uint8_t extclk = (uint8_t)0; // --- g_MAX11410_device.__WARNING_no_match_for_argname_extclk_in_MAX11410_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("extclk", extclk))
                    {
                        // g_MAX11410_device.__WARNING_no_match_for_argname_extclk_in_MAX11410_device_t__ = extclk; // update global property value
                    }
                    // argname default_argvalue numeric literal specified in CommandDocParamIn @Param[in]='@param[in] u_bn = unipolar input range enable, default=0'
                    // parse argument uint8_t u_bn
                    uint8_t u_bn = (uint8_t)0; // --- g_MAX11410_device.__WARNING_no_match_for_argname_u_bn_in_MAX11410_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("u_bn", u_bn))
                    {
                        // g_MAX11410_device.__WARNING_no_match_for_argname_u_bn_in_MAX11410_device_t__ = u_bn; // update global property value
                    }
                    // argname default_argvalue numeric literal specified in CommandDocParamIn @Param[in]='@param[in] format = offset binary format enable, default=0'
                    // parse argument uint8_t format
                    uint8_t format = (uint8_t)0; // --- g_MAX11410_device.__WARNING_no_match_for_argname_format_in_MAX11410_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("format", format))
                    {
                        // g_MAX11410_device.__WARNING_no_match_for_argname_format_in_MAX11410_device_t__ = format; // update global property value
                    }
                    // argname default_argvalue numeric literal specified in CommandDocParamIn @Param[in]='@param[in] refbufp_en = REFP reference buffer enable, default=0'
                    // parse argument uint8_t refbufp_en
                    uint8_t refbufp_en = (uint8_t)0; // --- g_MAX11410_device.__WARNING_no_match_for_argname_refbufp_en_in_MAX11410_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("refbufp_en", refbufp_en))
                    {
                        // g_MAX11410_device.__WARNING_no_match_for_argname_refbufp_en_in_MAX11410_device_t__ = refbufp_en; // update global property value
                    }
                    // argname default_argvalue numeric literal specified in CommandDocParamIn @Param[in]='@param[in] refbufn_en = REFN reference buffer enable, default=0'
                    // parse argument uint8_t refbufn_en
                    uint8_t refbufn_en = (uint8_t)0; // --- g_MAX11410_device.__WARNING_no_match_for_argname_refbufn_en_in_MAX11410_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("refbufn_en", refbufn_en))
                    {
                        // g_MAX11410_device.__WARNING_no_match_for_argname_refbufn_en_in_MAX11410_device_t__ = refbufn_en; // update global property value
                    }
                    // argname default_argvalue symbolic name specified in CommandDocParamIn @Param[in]='@param[in] ref_sel = reference selection, default=MAX11410::MAX11410_REF_SEL_enum_t::REF_SEL_001_REF1P_REF1N'
                    // parse argument uint8_t ref_sel
                    uint8_t ref_sel = (uint8_t)MAX11410::REF_SEL_001_REF1P_REF1N; // --- g_MAX11410_device.__WARNING_no_match_for_argname_ref_sel_in_MAX11410_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("ref_sel", ref_sel))
                    {
                        // g_MAX11410_device.__WARNING_no_match_for_argname_ref_sel_in_MAX11410_device_t__ = ref_sel; // update global property value
                    }
                    // print arguments
                    cmdLine.serial().printf("Configure_CTRL");
                    cmdLine.serial().printf(" extclk=%d", extclk);
                    cmdLine.serial().printf(" u_bn=%d", u_bn);
                    cmdLine.serial().printf(" format=%d", format);
                    cmdLine.serial().printf(" refbufp_en=%d", refbufp_en);
                    cmdLine.serial().printf(" refbufn_en=%d", refbufn_en);
                    cmdLine.serial().printf(" ref_sel=%d", ref_sel);
                    cmdLine.serial().printf("\r\n");
                    // call function Configure_CTRL(extclk, u_bn, format, refbufp_en, refbufn_en, ref_sel)
                    uint8_t result = g_MAX11410_device.Configure_CTRL(extclk, u_bn, format, refbufp_en, refbufn_en, ref_sel);
                    cmdLine.serial().printf(" =%d\r\n", result);
                    return true; // command handled by MAX11410
// CODE GENERATOR: bottom of loop: testMenuCommand="XC", testMenuFirstCharHandler="X"
                } // end nested case 'XC'
                break;

// CODE GENERATOR: top of loop: testMenuCommand="XF", testMenuFirstCharHandler="X"
// CODE GENERATOR: top of loop: nested switch "X" is currently open
// CODE GENERATOR: test menu case 'XF':
// CODE GENERATOR:           helpString 'XF linef=? rate=? -- Configure_FILTER'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Configure_FILTER'
// CODE GENERATOR:           CommandParamIn 'uint8_t linef, uint8_t rate'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn '@param[in] linef = filter type, default=MAX11410::MAX11410_LINEF_enum_t::LINEF_11_SINC4'
// CODE GENERATOR:           CommandDocParamIn '@param[in] rate = output data rate selection, default=MAX11410::MAX11410_RATE_enum_t::RATE_0100'
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
                case 'F': // (nested inside case 'X')
                {
                    // test menu command 'XF' handler:
                    // helpString='XF linef=? rate=? -- Configure_FILTER'
                    // CMD_='None'
                    // CommandName='Configure_FILTER'
                    // CommandParamIn='uint8_t linef, uint8_t rate'
                    // CommandReturnType='uint8_t'
                    // @Pre=''
                    // @Param[in]='@param[in] linef = filter type, default=MAX11410::MAX11410_LINEF_enum_t::LINEF_11_SINC4'
                    // @Param[in]='@param[in] rate = output data rate selection, default=MAX11410::MAX11410_RATE_enum_t::RATE_0100'
                    // @Param[out]=''
                    // @Post=''
                    // displayPost=''
                    // @Return='@return 1 on success; 0 on failure'
                    // parse argument list
                    // argname default_argvalue symbolic name specified in CommandDocParamIn @Param[in]='@param[in] linef = filter type, default=MAX11410::MAX11410_LINEF_enum_t::LINEF_11_SINC4'
                    // parse argument uint8_t linef
                    uint8_t linef = (uint8_t)MAX11410::LINEF_11_SINC4; // --- g_MAX11410_device.__WARNING_no_match_for_argname_linef_in_MAX11410_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("linef", linef))
                    {
                        // g_MAX11410_device.__WARNING_no_match_for_argname_linef_in_MAX11410_device_t__ = linef; // update global property value
                    }
                    // argname default_argvalue symbolic name specified in CommandDocParamIn @Param[in]='@param[in] rate = output data rate selection, default=MAX11410::MAX11410_RATE_enum_t::RATE_0100'
                    // parse argument uint8_t rate
                    uint8_t rate = (uint8_t)MAX11410::RATE_0100; // --- g_MAX11410_device.__WARNING_no_match_for_argname_rate_in_MAX11410_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("rate", rate))
                    {
                        // g_MAX11410_device.__WARNING_no_match_for_argname_rate_in_MAX11410_device_t__ = rate; // update global property value
                    }
                    // print arguments
                    cmdLine.serial().printf("Configure_FILTER");
                    cmdLine.serial().printf(" linef=%d", linef);
                    cmdLine.serial().printf(" rate=%d", rate);
                    cmdLine.serial().printf("\r\n");
                    // call function Configure_FILTER(linef, rate)
                    uint8_t result = g_MAX11410_device.Configure_FILTER(linef, rate);
                    cmdLine.serial().printf(" =%d\r\n", result);
                    return true; // command handled by MAX11410
// CODE GENERATOR: bottom of loop: testMenuCommand="XF", testMenuFirstCharHandler="X"
                } // end nested case 'XF'
                break;

// CODE GENERATOR: top of loop: testMenuCommand="XI", testMenuFirstCharHandler="X"
// CODE GENERATOR: top of loop: nested switch "X" is currently open
// CODE GENERATOR: test menu case 'XI':
// CODE GENERATOR:           helpString 'XI idac1_sel=? idac0_sel=? -- Configure_MUX_CTRL1'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Configure_MUX_CTRL1'
// CODE GENERATOR:           CommandParamIn 'uint8_t idac1_sel, uint8_t idac0_sel'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn '@param[in] idac1_sel = channel high side, default=MAX11410::MAX11410_IDAC1_SEL_enum_t::IDAC1_SEL_1111_unconnected'
// CODE GENERATOR:           CommandDocParamIn '@param[in] idac0_sel = channel low side, default=MAX11410::MAX11410_IDAC0_SEL_enum_t::IDAC0_SEL_1111_unconnected'
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
                case 'I': // (nested inside case 'X')
                {
                    // test menu command 'XI' handler:
                    // helpString='XI idac1_sel=? idac0_sel=? -- Configure_MUX_CTRL1'
                    // CMD_='None'
                    // CommandName='Configure_MUX_CTRL1'
                    // CommandParamIn='uint8_t idac1_sel, uint8_t idac0_sel'
                    // CommandReturnType='uint8_t'
                    // @Pre=''
                    // @Param[in]='@param[in] idac1_sel = channel high side, default=MAX11410::MAX11410_IDAC1_SEL_enum_t::IDAC1_SEL_1111_unconnected'
                    // @Param[in]='@param[in] idac0_sel = channel low side, default=MAX11410::MAX11410_IDAC0_SEL_enum_t::IDAC0_SEL_1111_unconnected'
                    // @Param[out]=''
                    // @Post=''
                    // displayPost=''
                    // @Return='@return 1 on success; 0 on failure'
                    // parse argument list
                    // argname default_argvalue symbolic name specified in CommandDocParamIn @Param[in]='@param[in] idac1_sel = channel high side, default=MAX11410::MAX11410_IDAC1_SEL_enum_t::IDAC1_SEL_1111_unconnected'
                    // parse argument uint8_t idac1_sel
                    uint8_t idac1_sel = (uint8_t)MAX11410::IDAC1_SEL_1111_unconnected; // --- g_MAX11410_device.__WARNING_no_match_for_argname_idac1_sel_in_MAX11410_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("idac1_sel", idac1_sel))
                    {
                        // g_MAX11410_device.__WARNING_no_match_for_argname_idac1_sel_in_MAX11410_device_t__ = idac1_sel; // update global property value
                    }
                    // argname default_argvalue symbolic name specified in CommandDocParamIn @Param[in]='@param[in] idac0_sel = channel low side, default=MAX11410::MAX11410_IDAC0_SEL_enum_t::IDAC0_SEL_1111_unconnected'
                    // parse argument uint8_t idac0_sel
                    uint8_t idac0_sel = (uint8_t)MAX11410::IDAC0_SEL_1111_unconnected; // --- g_MAX11410_device.__WARNING_no_match_for_argname_idac0_sel_in_MAX11410_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("idac0_sel", idac0_sel))
                    {
                        // g_MAX11410_device.__WARNING_no_match_for_argname_idac0_sel_in_MAX11410_device_t__ = idac0_sel; // update global property value
                    }
                    // print arguments
                    cmdLine.serial().printf("Configure_MUX_CTRL1");
                    cmdLine.serial().printf(" idac1_sel=%d", idac1_sel);
                    cmdLine.serial().printf(" idac0_sel=%d", idac0_sel);
                    cmdLine.serial().printf("\r\n");
                    // call function Configure_MUX_CTRL1(idac1_sel, idac0_sel)
                    uint8_t result = g_MAX11410_device.Configure_MUX_CTRL1(idac1_sel, idac0_sel);
                    cmdLine.serial().printf(" =%d\r\n", result);
                    return true; // command handled by MAX11410
// CODE GENERATOR: bottom of loop: testMenuCommand="XI", testMenuFirstCharHandler="X"
                } // end nested case 'XI'
                break;

// CODE GENERATOR: top of loop: testMenuCommand="XM", testMenuFirstCharHandler="X"
// CODE GENERATOR: top of loop: nested switch "X" is currently open
// CODE GENERATOR: test menu case 'XM':
// CODE GENERATOR:           helpString 'XM ainp=? ainn=? -- Configure_MUX_CTRL0'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Configure_MUX_CTRL0'
// CODE GENERATOR:           CommandParamIn 'uint8_t ainp, uint8_t ainn'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn '@param[in] ainp = channel high side, default=MAX11410::MAX11410_AINP_SEL_enum_t::AINP_SEL_0000_AIN0'
// CODE GENERATOR:           CommandDocParamIn '@param[in] ainn = channel low side, default=MAX11410::MAX11410_AINN_SEL_enum_t::AINN_SEL_1010_GND'
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
                case 'M': // (nested inside case 'X')
                {
                    // test menu command 'XM' handler:
                    // helpString='XM ainp=? ainn=? -- Configure_MUX_CTRL0'
                    // CMD_='None'
                    // CommandName='Configure_MUX_CTRL0'
                    // CommandParamIn='uint8_t ainp, uint8_t ainn'
                    // CommandReturnType='uint8_t'
                    // @Pre=''
                    // @Param[in]='@param[in] ainp = channel high side, default=MAX11410::MAX11410_AINP_SEL_enum_t::AINP_SEL_0000_AIN0'
                    // @Param[in]='@param[in] ainn = channel low side, default=MAX11410::MAX11410_AINN_SEL_enum_t::AINN_SEL_1010_GND'
                    // @Param[out]=''
                    // @Post=''
                    // displayPost=''
                    // @Return='@return 1 on success; 0 on failure'
                    // parse argument list
                    // argname default_argvalue symbolic name specified in CommandDocParamIn @Param[in]='@param[in] ainp = channel high side, default=MAX11410::MAX11410_AINP_SEL_enum_t::AINP_SEL_0000_AIN0'
                    // parse argument uint8_t ainp
                    uint8_t ainp = (uint8_t)MAX11410::AINP_SEL_0000_AIN0; // --- g_MAX11410_device.__WARNING_no_match_for_argname_ainp_in_MAX11410_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("ainp", ainp))
                    {
                        // g_MAX11410_device.__WARNING_no_match_for_argname_ainp_in_MAX11410_device_t__ = ainp; // update global property value
                    }
                    // argname default_argvalue symbolic name specified in CommandDocParamIn @Param[in]='@param[in] ainn = channel low side, default=MAX11410::MAX11410_AINN_SEL_enum_t::AINN_SEL_1010_GND'
                    // parse argument uint8_t ainn
                    uint8_t ainn = (uint8_t)MAX11410::AINN_SEL_1010_GND; // --- g_MAX11410_device.__WARNING_no_match_for_argname_ainn_in_MAX11410_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("ainn", ainn))
                    {
                        // g_MAX11410_device.__WARNING_no_match_for_argname_ainn_in_MAX11410_device_t__ = ainn; // update global property value
                    }
                    // print arguments
                    cmdLine.serial().printf("Configure_MUX_CTRL0");
                    cmdLine.serial().printf(" ainp=%d", ainp);
                    cmdLine.serial().printf(" ainn=%d", ainn);
                    cmdLine.serial().printf("\r\n");
                    // call function Configure_MUX_CTRL0(ainp, ainn)
                    uint8_t result = g_MAX11410_device.Configure_MUX_CTRL0(ainp, ainn);
                    cmdLine.serial().printf(" =%d\r\n", result);
                    return true; // command handled by MAX11410
// CODE GENERATOR: bottom of loop: testMenuCommand="XM", testMenuFirstCharHandler="X"
                } // end nested case 'XM'
                break;

// CODE GENERATOR: top of loop: testMenuCommand="XP", testMenuFirstCharHandler="X"
// CODE GENERATOR: top of loop: nested switch "X" is currently open
// CODE GENERATOR: test menu case 'XP':
// CODE GENERATOR:           helpString 'XP sigpath=? gain=? -- Configure_PGA'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Configure_PGA'
// CODE GENERATOR:           CommandParamIn 'uint8_t sigpath, uint8_t gain'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn '@param[in] sigpath = signal path, default=MAX11410::MAX11410_SIG_PATH_enum_t::SIG_PATH_00_BUFFERED'
// CODE GENERATOR:           CommandDocParamIn '@param[in] gain = gain selection, default=MAX11410::MAX11410_GAIN_enum_t::GAIN_000_1'
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
                case 'P': // (nested inside case 'X')
                {
                    // test menu command 'XP' handler:
                    // helpString='XP sigpath=? gain=? -- Configure_PGA'
                    // CMD_='None'
                    // CommandName='Configure_PGA'
                    // CommandParamIn='uint8_t sigpath, uint8_t gain'
                    // CommandReturnType='uint8_t'
                    // @Pre=''
                    // @Param[in]='@param[in] sigpath = signal path, default=MAX11410::MAX11410_SIG_PATH_enum_t::SIG_PATH_00_BUFFERED'
                    // @Param[in]='@param[in] gain = gain selection, default=MAX11410::MAX11410_GAIN_enum_t::GAIN_000_1'
                    // @Param[out]=''
                    // @Post=''
                    // displayPost=''
                    // @Return='@return 1 on success; 0 on failure'
                    // parse argument list
                    // argname default_argvalue symbolic name specified in CommandDocParamIn @Param[in]='@param[in] sigpath = signal path, default=MAX11410::MAX11410_SIG_PATH_enum_t::SIG_PATH_00_BUFFERED'
                    // parse argument uint8_t sigpath
                    uint8_t sigpath = (uint8_t)MAX11410::SIG_PATH_00_BUFFERED; // --- g_MAX11410_device.__WARNING_no_match_for_argname_sigpath_in_MAX11410_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("sigpath", sigpath))
                    {
                        // g_MAX11410_device.__WARNING_no_match_for_argname_sigpath_in_MAX11410_device_t__ = sigpath; // update global property value
                    }
                    // argname default_argvalue symbolic name specified in CommandDocParamIn @Param[in]='@param[in] gain = gain selection, default=MAX11410::MAX11410_GAIN_enum_t::GAIN_000_1'
                    // parse argument uint8_t gain
                    uint8_t gain = (uint8_t)MAX11410::GAIN_000_1; // --- g_MAX11410_device.__WARNING_no_match_for_argname_gain_in_MAX11410_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("gain", gain))
                    {
                        // g_MAX11410_device.__WARNING_no_match_for_argname_gain_in_MAX11410_device_t__ = gain; // update global property value
                    }
                    // print arguments
                    cmdLine.serial().printf("Configure_PGA");
                    cmdLine.serial().printf(" sigpath=%d", sigpath);
                    cmdLine.serial().printf(" gain=%d", gain);
                    cmdLine.serial().printf("\r\n");
                    // call function Configure_PGA(sigpath, gain)
                    uint8_t result = g_MAX11410_device.Configure_PGA(sigpath, gain);
                    cmdLine.serial().printf(" =%d\r\n", result);
                    return true; // command handled by MAX11410
// CODE GENERATOR: bottom of loop: testMenuCommand="XP", testMenuFirstCharHandler="X"
                } // end nested case 'XP'
                break;

// CODE GENERATOR: top of loop: testMenuCommand="XR", testMenuFirstCharHandler="X"
// CODE GENERATOR: top of loop: nested switch "X" is currently open
// CODE GENERATOR: test menu case 'XR':
// CODE GENERATOR:           helpString 'XR ref_sel=? -- Configure_CTRL_REF'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Configure_CTRL_REF'
// CODE GENERATOR:           CommandParamIn 'uint8_t ref_sel'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre '@pre ctrl = shadow of CTRL register'
// CODE GENERATOR:           CommandDocParamIn '@param[in] ref_sel = reference selection, default=MAX11410::MAX11410_REF_SEL_enum_t::REF_SEL_001_REF1P_REF1N'
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
                case 'R': // (nested inside case 'X')
                {
                    // test menu command 'XR' handler:
                    // helpString='XR ref_sel=? -- Configure_CTRL_REF'
                    // CMD_='None'
                    // CommandName='Configure_CTRL_REF'
                    // CommandParamIn='uint8_t ref_sel'
                    // CommandReturnType='uint8_t'
                    // @Pre='@pre ctrl = shadow of CTRL register'
                    // @Param[in]='@param[in] ref_sel = reference selection, default=MAX11410::MAX11410_REF_SEL_enum_t::REF_SEL_001_REF1P_REF1N'
                    // @Param[out]=''
                    // @Post=''
                    // displayPost=''
                    // @Return='@return 1 on success; 0 on failure'
                    // parse argument list
                    // argname default_argvalue symbolic name specified in CommandDocParamIn @Param[in]='@param[in] ref_sel = reference selection, default=MAX11410::MAX11410_REF_SEL_enum_t::REF_SEL_001_REF1P_REF1N'
                    // parse argument uint8_t ref_sel
                    uint8_t ref_sel = (uint8_t)MAX11410::REF_SEL_001_REF1P_REF1N; // --- g_MAX11410_device.__WARNING_no_match_for_argname_ref_sel_in_MAX11410_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("ref_sel", ref_sel))
                    {
                        // g_MAX11410_device.__WARNING_no_match_for_argname_ref_sel_in_MAX11410_device_t__ = ref_sel; // update global property value
                    }
                    // print arguments
                    cmdLine.serial().printf("Configure_CTRL_REF");
                    cmdLine.serial().printf(" ref_sel=%d", ref_sel);
                    cmdLine.serial().printf("\r\n");
                    // call function Configure_CTRL_REF(ref_sel)
                    uint8_t result = g_MAX11410_device.Configure_CTRL_REF(ref_sel);
                    cmdLine.serial().printf(" =%d\r\n", result);
                    return true; // command handled by MAX11410
// CODE GENERATOR: bottom of loop: testMenuCommand="XR", testMenuFirstCharHandler="X"
                } // end nested case 'XR'
                break;

// CODE GENERATOR: top of loop: testMenuCommand="XS", testMenuFirstCharHandler="X"
// CODE GENERATOR: top of loop: nested switch "X" is currently open
// CODE GENERATOR: test menu case 'XS':
// CODE GENERATOR:           helpString 'XS vbias_mode=? brn_mode=? idac_mode=? -- Configure_SOURCE'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Configure_SOURCE'
// CODE GENERATOR:           CommandParamIn 'uint8_t vbias_mode, uint8_t brn_mode, uint8_t idac_mode'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn '@param[in] vbias_mode = bias voltage mode, default=MAX11410::MAX11410_VBIAS_MODE_enum_t::VBIAS_MODE_00_Active'
// CODE GENERATOR:           CommandDocParamIn '@param[in] brn_mode = burnout source mode, default=MAX11410::MAX11410_BRN_MODE_enum_t::BRN_MODE_00_disabled'
// CODE GENERATOR:           CommandDocParamIn '@param[in] idac_mode = current source value, default=MAX11410::MAX11410_IDAC_MODE_enum_t::IDAC_MODE_0000_10uA'
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
                case 'S': // (nested inside case 'X')
                {
                    // test menu command 'XS' handler:
                    // helpString='XS vbias_mode=? brn_mode=? idac_mode=? -- Configure_SOURCE'
                    // CMD_='None'
                    // CommandName='Configure_SOURCE'
                    // CommandParamIn='uint8_t vbias_mode, uint8_t brn_mode, uint8_t idac_mode'
                    // CommandReturnType='uint8_t'
                    // @Pre=''
                    // @Param[in]='@param[in] vbias_mode = bias voltage mode, default=MAX11410::MAX11410_VBIAS_MODE_enum_t::VBIAS_MODE_00_Active'
                    // @Param[in]='@param[in] brn_mode = burnout source mode, default=MAX11410::MAX11410_BRN_MODE_enum_t::BRN_MODE_00_disabled'
                    // @Param[in]='@param[in] idac_mode = current source value, default=MAX11410::MAX11410_IDAC_MODE_enum_t::IDAC_MODE_0000_10uA'
                    // @Param[out]=''
                    // @Post=''
                    // displayPost=''
                    // @Return='@return 1 on success; 0 on failure'
                    // parse argument list
                    // argname default_argvalue symbolic name specified in CommandDocParamIn @Param[in]='@param[in] vbias_mode = bias voltage mode, default=MAX11410::MAX11410_VBIAS_MODE_enum_t::VBIAS_MODE_00_Active'
                    // parse argument uint8_t vbias_mode
                    uint8_t vbias_mode = (uint8_t)MAX11410::VBIAS_MODE_00_Active; // --- g_MAX11410_device.__WARNING_no_match_for_argname_vbias_mode_in_MAX11410_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("vbias_mode", vbias_mode))
                    {
                        // g_MAX11410_device.__WARNING_no_match_for_argname_vbias_mode_in_MAX11410_device_t__ = vbias_mode; // update global property value
                    }
                    // argname default_argvalue symbolic name specified in CommandDocParamIn @Param[in]='@param[in] brn_mode = burnout source mode, default=MAX11410::MAX11410_BRN_MODE_enum_t::BRN_MODE_00_disabled'
                    // parse argument uint8_t brn_mode
                    uint8_t brn_mode = (uint8_t)MAX11410::BRN_MODE_00_disabled; // --- g_MAX11410_device.__WARNING_no_match_for_argname_brn_mode_in_MAX11410_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("brn_mode", brn_mode))
                    {
                        // g_MAX11410_device.__WARNING_no_match_for_argname_brn_mode_in_MAX11410_device_t__ = brn_mode; // update global property value
                    }
                    // argname default_argvalue symbolic name specified in CommandDocParamIn @Param[in]='@param[in] idac_mode = current source value, default=MAX11410::MAX11410_IDAC_MODE_enum_t::IDAC_MODE_0000_10uA'
                    // parse argument uint8_t idac_mode
                    uint8_t idac_mode = (uint8_t)MAX11410::IDAC_MODE_0000_10uA; // --- g_MAX11410_device.__WARNING_no_match_for_argname_idac_mode_in_MAX11410_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("idac_mode", idac_mode))
                    {
                        // g_MAX11410_device.__WARNING_no_match_for_argname_idac_mode_in_MAX11410_device_t__ = idac_mode; // update global property value
                    }
                    // print arguments
                    cmdLine.serial().printf("Configure_SOURCE");
                    cmdLine.serial().printf(" vbias_mode=%d", vbias_mode);
                    cmdLine.serial().printf(" brn_mode=%d", brn_mode);
                    cmdLine.serial().printf(" idac_mode=%d", idac_mode);
                    cmdLine.serial().printf("\r\n");
                    // call function Configure_SOURCE(vbias_mode, brn_mode, idac_mode)
                    uint8_t result = g_MAX11410_device.Configure_SOURCE(vbias_mode, brn_mode, idac_mode);
                    cmdLine.serial().printf(" =%d\r\n", result);
                    return true; // command handled by MAX11410
// CODE GENERATOR: bottom of loop: testMenuCommand="XS", testMenuFirstCharHandler="X"
                } // end nested case 'XS'
                break;

// CODE GENERATOR: top of loop: testMenuCommand="XV", testMenuFirstCharHandler="X"
// CODE GENERATOR: top of loop: nested switch "X" is currently open
// CODE GENERATOR: test menu case 'XV':
// CODE GENERATOR:           helpString 'XV vbias_ain7_ain0_bitmap=? -- Configure_MUX_CTRL2'
// CODE GENERATOR:           CMD_ 'None'
// CODE GENERATOR:           CommandName 'Configure_MUX_CTRL2'
// CODE GENERATOR:           CommandParamIn 'uint8_t vbias_ain7_ain0_bitmap'
// CODE GENERATOR:           CommandReturnType 'uint8_t'
// CODE GENERATOR:           CommandPre ''
// CODE GENERATOR:           CommandDocParamIn '@param[in] vbias_ain7_ain0_bitmap = bit map of AIN7..AIN0 enables for voltage bias, default=0'
// CODE GENERATOR:           CommandDocParamOut ''
// CODE GENERATOR:           CommandPost ''
// CODE GENERATOR:           CommandReturn '@return 1 on success; 0 on failure'
                case 'V': // (nested inside case 'X')
                {
                    // test menu command 'XV' handler:
                    // helpString='XV vbias_ain7_ain0_bitmap=? -- Configure_MUX_CTRL2'
                    // CMD_='None'
                    // CommandName='Configure_MUX_CTRL2'
                    // CommandParamIn='uint8_t vbias_ain7_ain0_bitmap'
                    // CommandReturnType='uint8_t'
                    // @Pre=''
                    // @Param[in]='@param[in] vbias_ain7_ain0_bitmap = bit map of AIN7..AIN0 enables for voltage bias, default=0'
                    // @Param[out]=''
                    // @Post=''
                    // displayPost=''
                    // @Return='@return 1 on success; 0 on failure'
                    // parse argument list
                    // argname default_argvalue numeric literal specified in CommandDocParamIn @Param[in]='@param[in] vbias_ain7_ain0_bitmap = bit map of AIN7..AIN0 enables for voltage bias, default=0'
                    // parse argument uint8_t vbias_ain7_ain0_bitmap
                    uint8_t vbias_ain7_ain0_bitmap = (uint8_t)0; // --- g_MAX11410_device.__WARNING_no_match_for_argname_vbias_ain7_ain0_bitmap_in_MAX11410_device_t__; // default to global property value
                    if (cmdLine.parse_uint8_dec("vbias_ain7_ain0_bitmap", vbias_ain7_ain0_bitmap))
                    {
                        // g_MAX11410_device.__WARNING_no_match_for_argname_vbias_ain7_ain0_bitmap_in_MAX11410_device_t__ = vbias_ain7_ain0_bitmap; // update global property value
                    }
                    // print arguments
                    cmdLine.serial().printf("Configure_MUX_CTRL2");
                    cmdLine.serial().printf(" vbias_ain7_ain0_bitmap=%d", vbias_ain7_ain0_bitmap);
                    cmdLine.serial().printf("\r\n");
                    // call function Configure_MUX_CTRL2(vbias_ain7_ain0_bitmap)
                    uint8_t result = g_MAX11410_device.Configure_MUX_CTRL2(vbias_ain7_ain0_bitmap);
                    cmdLine.serial().printf(" =%d\r\n", result);
                    return true; // command handled by MAX11410
// CODE GENERATOR: bottom of loop: testMenuCommand="XV", testMenuFirstCharHandler="X"
                } // end nested case 'XV'
                break;

            } // end nested switch (cmdLine[1]) inside case 'X'
            break;
        } // end case 'X'
        // has_register_write_command: case '0'..'9','A'..'F','a'..'f' letters are reserved for bitstream commands
        case '0': case '1': case '2': case '3': case '4':
        case '5': case '6': case '7': case '8': case '9':
        case 'a': case 'b': case 'c': case 'd': case 'e': case 'f':
        case 'A': case 'B': case 'C': case 'D': case 'E': case 'F':
        {
            // hexadecimal codes get parsed as bytecodes
            //
            // parse_byteCount_byteList_dec() assumes all keyword args have already been removed from the buffer
                    // parse cmdLine byte list --> int byteCount; int mosiData[MAX_SPI_BYTE_COUNT];
                    #define MAX_SPI_BYTE_COUNT 32
                    size_t byteCount = byteCount;
                    static char mosiData[MAX_SPI_BYTE_COUNT];
                    if (cmdLine.parse_byteCount_byteList_hex(byteCount, mosiData,
                                                             MAX_SPI_BYTE_COUNT))
                    {
                        // TODO: decode operation from commandByte
                        // TODO: OVERSIMPLIFICATION: if length is 1 byte then operation is RegRead, otherwise RegWrite
                        // register_read_function 'IsRegReadCommand'
                        // register_write_function 'IsRegWriteCommand'
                        // register_name_function 'RegName'
                        // register_size_function 'RegSize'
// CODE GENERATOR: does the chip have a defined CMDOP_1aaa_aaaa_ReadRegister bit?
                        MAX11410::MAX11410_CMD_enum_t commandByte = (MAX11410::MAX11410_CMD_enum_t)(mosiData[0]);
                        int regAddress = g_MAX11410_device.RegAddrOfCommand(commandByte);
                        cmdLine.serial().printf(" regAddress=0x%2.2x\r\n", (regAddress & 0xFF));
                        cmdLine.serial().printf(" RegName=%s\r\n", g_MAX11410_device.RegName(commandByte));
                        uint32_t regData = 0;
                        int regSize = g_MAX11410_device.RegSize(commandByte);
                        cmdLine.serial().printf(" RegSize=%d\r\n", regSize);
                        switch(regSize)
                        {
                        case 8:
                            regData = ((uint32_t)mosiData[1] & 0xFF);
                            break;
                        case 16:
                            regData = (((uint32_t)mosiData[1] & 0xFF) << 8) + ((uint32_t)mosiData[2] & 0xFF);
                            break;
                        case 24:
                            regData = (((uint32_t)mosiData[1] & 0xFF) << 16) + (((uint32_t)mosiData[2] & 0xFF) << 8) + ((uint32_t)mosiData[3] & 0xFF);
                            break;
                        }
// CODE GENERATOR: does the chip have a defined CMDOP_1aaa_aaaa_ReadRegister bit?
                        if ((byteCount == 1) || g_MAX11410_device.IsRegReadCommand(commandByte))
                        {
                            cmdLine.serial().printf(" RegRead");
                            g_MAX11410_device.RegRead(commandByte, &regData);
                            cmdLine.serial().printf("regData=0x%6.6lx\r\n", (regData & 0x00FFFFFF));
                        }
                        else if (g_MAX11410_device.IsRegWriteCommand(commandByte))
                        {
                            cmdLine.serial().printf(" RegWrite regData=0x%6.6lX\r\n", (regData & 0x00FFFFFF));
                            g_MAX11410_device.RegWrite(commandByte, regData);
                        }
                        // is there support function shadow regValue of regAddr?
                    }
                    return true; // command handled by MAX11410
            //
        } // end case '0'..'9','A'..'F','a'..'f'
        break;
    } // end switch (cmdLine[0])
    return false; // command not handled by MAX11410
} // end bool MAX11410_menu_onEOLcommandParser(CmdLine & cmdLine)

// CODE GENERATOR: class declaration statement close
