// /*******************************************************************************
// * Copyright (C) 2020 Maxim Integrated Products, Inc., All Rights Reserved.
// *
// * Permission is hereby granted, free of charge, to any person obtaining a
// * copy of this software and associated documentation files (the "Software"),
// * to deal in the Software without restriction, including without limitation
// * the rights to use, copy, modify, merge, publish, distribute, sublicense,
// * and/or sell copies of the Software, and to permit persons to whom the
// * Software is furnished to do so, subject to the following conditions:
// *
// * The above copyright notice and this permission notice shall be included
// * in all copies or substantial portions of the Software.
// *
// * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
// * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// * OTHER DEALINGS IN THE SOFTWARE.
// *
// * Except as contained in this notice, the name of Maxim Integrated
// * Products, Inc. shall not be used except as stated in the Maxim Integrated
// * Products, Inc. Branding Policy.
// *
// * The mere transfer of this software does not imply any licenses
// * of trade secrets, proprietary technology, copyrights, patents,
// * trademarks, maskwork rights, or any other form of intellectual
// * property whatsoever. Maxim Integrated Products, Inc. retains all
// * ownership rights.
// *******************************************************************************
// */
//---------- CODE GENERATOR: testMainCppCodeList
// CODE GENERATOR: example code includes

// example code includes
// standard include for target platform -- Platform_Include_Boilerplate
#include "mbed.h"
// Platforms:
//   - MAX32625MBED
//      - supports mbed-os-5.11, requires USBDevice library
//      - add https://developer.mbed.org/teams/MaximIntegrated/code/USBDevice/
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - MAX32600MBED
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//      - Windows 10 note:  Don't connect HDK until you are ready to load new firmware into the board.
//   - NUCLEO_F446RE
//      - remove USBDevice library
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - NUCLEO_F401RE
//      - remove USBDevice library
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - MAX32630FTHR
//      - #include "max32630fthr.h"
//      - add http://os.mbed.org/teams/MaximIntegrated/code/max32630fthr/
//      - remove MAX32620FTHR library (if present)
//   - MAX32620FTHR
//      - #include "MAX32620FTHR.h"
//      - remove max32630fthr library (if present)
//      - add https://os.mbed.com/teams/MaximIntegrated/code/MAX32620FTHR/
//      - not tested yet
//   - MAX32625PICO
//      - #include "max32625pico.h"
//      - add https://os.mbed.com/users/switches/code/max32625pico/
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//      - not tested yet
//      - see https://os.mbed.com/users/switches/code/max32625pico/
//      - see https://os.mbed.com/users/switches/code/PICO_board_demo/
//      - see https://os.mbed.com/users/switches/code/PICO_USB_I2C_SPI/
//      - see https://os.mbed.com/users/switches/code/SerialInterface/
//      - Note: To load the MAX32625PICO firmware, hold the button while
//        connecting the USB cable, then copy firmware bin file 
//        to the MAINTENANCE drive.
//      - see https://os.mbed.com/platforms/MAX32625PICO/
//      - see https://os.mbed.com/teams/MaximIntegrated/wiki/MAX32625PICO-Firmware-Updates
//
// end Platform_Include_Boilerplate
#include "MAX11410.h"
#include "CmdLine.h"
#include "MaximTinyTester.h"

// optional: serial port
// note: some platforms such as Nucleo-F446RE do not support the USBSerial library.
// In those cases, remove the USBDevice lib from the project and rebuild.
#if defined(TARGET_MAX32625MBED)
#include "USBSerial.h"
USBSerial serial; // virtual serial port over USB (DEV connector)
#elif defined(TARGET_MAX32625PICO)
#include "USBSerial.h"
USBSerial serial; // virtual serial port over USB (DEV connector)
#elif defined(TARGET_MAX32600MBED)
#include "USBSerial.h"
USBSerial serial; // virtual serial port over USB (DEV connector)
#elif defined(TARGET_MAX32630MBED)
#include "USBSerial.h"
USBSerial serial; // virtual serial port over USB (DEV connector)
#else
//#include "USBSerial.h"
Serial serial(USBTX, USBRX); // tx, rx
#endif

void on_immediate_0x21(); // Unicode (U+0021) ! EXCLAMATION MARK
void on_immediate_0x7b(); // Unicode (U+007B) { LEFT CURLY BRACKET
void on_immediate_0x7d(); // Unicode (U+007D) } RIGHT CURLY BRACKET

#include "CmdLine.h"

# if HAS_DAPLINK_SERIAL
CmdLine cmdLine_DAPLINKserial(DAPLINKserial, "DAPLINK");
# endif // HAS_DAPLINK_SERIAL
CmdLine cmdLine_serial(serial, "serial");


//--------------------------------------------------


#if defined(TARGET)
// TARGET_NAME macros from targets/TARGET_Maxim/TARGET_MAX32625/device/mxc_device.h
// Create a string definition for the TARGET
#define STRING_ARG(arg) #arg
#define STRING_NAME(name) STRING_ARG(name)
#define TARGET_NAME STRING_NAME(TARGET)
#elif defined(TARGET_MAX32600)
#define TARGET_NAME "MAX32600"
#elif defined(TARGET_LPC1768)
#define TARGET_NAME "LPC1768"
#elif defined(TARGET_NUCLEO_F446RE)
#define TARGET_NAME "NUCLEO_F446RE"
#elif defined(TARGET_NUCLEO_F401RE)
#define TARGET_NAME "NUCLEO_F401RE"
#else
#error TARGET NOT DEFINED
#endif
#if defined(TARGET_MAX32630)
//--------------------------------------------------
// TARGET=MAX32630FTHR ARM Cortex-M4F 96MHz 2048kB Flash 512kB SRAM
//             +-------------[microUSB]-------------+
//             | J1         MAX32630FTHR        J2  |
//      ______ | [ ] RST                    GND [ ] |
//      ______ | [ ] 3V3                    BAT+[ ] |
//      ______ | [ ] 1V8                  reset SW1 |
//      ______ | [ ] GND       J4               J3  |
// analogIn0/4 | [a] AIN_0 1.2Vfs     (bat) SYS [ ] | switched BAT+
// analogIn1/5 | [a] AIN_1 1.2Vfs           PWR [ ] | external pwr btn
// analogIn2   | [a] AIN_2 1.2Vfs      +5V VBUS [ ] | USB +5V power
// analogIn3   | [a] AIN_3 1.2Vfs   1-WIRE P4_0 [d] | D0 dig9
//  (I2C2.SDA) | [d] P5_7  SDA2        SRN P5_6 [d] | D1 dig8
//  (I2C2.SCL) | [d] P6_0  SCL2      SDIO3 P5_5 [d] | D2 dig7
//    D13/SCLK | [s] P5_0  SCLK      SDIO2 P5_4 [d] | D3 dig6
//    D11/MOSI | [s] P5_1  MOSI       SSEL P5_3 [d] | D4 dig5
//    D12/MISO | [s] P5_2  MISO        RTS P3_3 [d] | D5 dig4
//    D10/CS   | [s] P3_0  RX          CTS P3_2 [d] | D6 dig3
//    D9  dig0 | [d] P3_1  TX          SCL P3_5 [d] | D7 dig2
//      ______ | [ ] GND               SDA P3_4 [d] | D8 dig1
//             |                                    |
//             | XIP Flash      MAX14690N           |
//             | XIP_SCLK P1_0  SDA2 P5_7           |
//             | XIP_MOSI P1_1  SCL2 P6_0           |
//             | XIP_MISO P1_2  PMIC_INIT P3_7      |
//             | XIP_SSEL P1_3  MPC P2_7            |
//             | XIP_DIO2 P1_4  MON AIN_0           |
//             | XIP_DIO3 P1_5                      |
//             |                                    |
//             | PAN1326B     MicroSD        LED    |
//             | BT_RX  P0_0  SD_SCLK P0_4   r P2_4 |
//             | BT_TX  P0_1  SD_MOSI P0_5   g P2_5 |
//             | BT_CTS P0_2  SD_MISO P0_6   b P2_6 |
//             | BT_RTS P0_3  SD_SSEL P0_7          |
//             | BT_RST P1_6  DETECT  P2_2          |
//             | BT_CLK P1_7               SW2 P2_3 |
//             +------------------------------------+
// MAX32630FTHR board has MAX14690 PMIC on I2C bus (P5_7 SDA, P6_0 SCL) at slave address 0101_000r 0x50 (or 0x28 for 7 MSbit address).
// MAX32630FTHR board has BMI160 accelerometer on I2C bus (P5_7 SDA, P6_0 SCL) at slave address 1101_000r 0xD0 (or 0x68 for 7 MSbit address).
// AIN_0 = AIN0 pin       fullscale is 1.2V
// AIN_1 = AIN1 pin       fullscale is 1.2V
// AIN_2 = AIN2 pin       fullscale is 1.2V
// AIN_3 = AIN3 pin       fullscale is 1.2V
// AIN_4 = AIN0 / 5.0     fullscale is 6.0V
// AIN_5 = AIN1 / 5.0     fullscale is 6.0V
// AIN_6 = VDDB / 4.0     fullscale is 4.8V
// AIN_7 = VDD18          fullscale is 1.2V
// AIN_8 = VDD12          fullscale is 1.2V
// AIN_9 = VRTC / 2.0     fullscale is 2.4V
// AIN_10 = x undefined?
// AIN_11 = VDDIO / 4.0   fullscale is 4.8V
// AIN_12 = VDDIOH / 4.0  fullscale is 4.8V
//
    #include "max32630fthr.h"
MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);
#define analogIn4_IS_HIGH_RANGE_OF_analogIn0 1
// MAX32630FTHR board supports only internal VREF = 1.200V at bypass capacitor C15
const float ADC_FULL_SCALE_VOLTAGE = 1.200;
// Arduino connector
#ifndef A0
#define A0 AIN_0
#endif
#ifndef A1
#define A1 AIN_1
#endif
#ifndef A2
#define A2 AIN_2
#endif
#ifndef A3
#define A3 AIN_3
#endif
#ifndef D0
#define D0 P4_0
#endif
#ifndef D1
#define D1 P5_6
#endif
#ifndef D2
#define D2 P5_5
#endif
#ifndef D3
#define D3 P5_4
#endif
#ifndef D4
#define D4 P5_3
#endif
#ifndef D5
#define D5 P3_3
#endif
#ifndef D6
#define D6 P3_2
#endif
#ifndef D7
#define D7 P3_5
#endif
#ifndef D8
#define D8 P3_4
#endif
#ifndef D9
#define D9 P3_1
#endif
#ifndef D10
#define D10 P3_0
#endif
#ifndef D11
#define D11 P5_1
#endif
#ifndef D12
#define D12 P5_2
#endif
#ifndef D13
#define D13 P5_0
#endif
//--------------------------------------------------
#elif defined(TARGET_MAX32625MBED)
//--------------------------------------------------
// TARGET=MAX32625MBED ARM Cortex-M4F 96MHz 512kB Flash 160kB SRAM
//             +-------------------------------------+
//             |   MAX32625MBED Arduino UNO header   |
//             |                                     |
//             |                           A5/SCL[ ] |   P1_7 dig15
//             |                           A4/SDA[ ] |   P1_6 dig14
//             |                         AREF=N/C[ ] |
//             |                              GND[ ] |
//             | [ ]N/C                    SCK/13[ ] |   P1_0 dig13
//             | [ ]IOREF=3V3             MISO/12[ ] |   P1_2 dig12
//             | [ ]RST                   MOSI/11[ ]~|   P1_1 dig11
//             | [ ]3V3                     CS/10[ ]~|   P1_3 dig10
//             | [ ]5V0                         9[ ]~|   P1_5 dig9
//             | [ ]GND                         8[ ] |   P1_4 dig8
//             | [ ]GND                              |
//             | [ ]Vin                         7[ ] |   P0_7 dig7
//             |                                6[ ]~|   P0_6 dig6
//       AIN_0 | [ ]A0                          5[ ]~|   P0_5 dig5
//       AIN_1 | [ ]A1                          4[ ] |   P0_4 dig4
//       AIN_2 | [ ]A2                     INT1/3[ ]~|   P0_3 dig3
//       AIN_3 | [ ]A3                     INT0/2[ ] |   P0_2 dig2
// dig16  P3_4 | [ ]A4/SDA  RST SCK MISO     TX>1[ ] |   P0_1 dig1
// dig17  P3_5 | [ ]A5/SCL  [ ] [ ] [ ]      RX<0[ ] |   P0_0 dig0
//             |            [ ] [ ] [ ]              |
//             |  UNO_R3    GND MOSI 5V  ____________/
//              \_______________________/
//
//             +------------------------+
//             |                        |
//             |  MicroSD        LED    |
//             |  SD_SCLK P2_4   r P3_0 |
//             |  SD_MOSI P2_5   g P3_1 |
//             |  SD_MISO P2_6   b P3_2 |
//             |  SD_SSEL P2_7   y P3_3 |
//             |                        |
//             |  DAPLINK      BUTTONS  |
//             |  TX P2_1      SW3 P2_3 |
//             |  RX P2_0      SW2 P2_2 |
//             +------------------------+
//
// AIN_0 = AIN0 pin       fullscale is 1.2V
// AIN_1 = AIN1 pin       fullscale is 1.2V
// AIN_2 = AIN2 pin       fullscale is 1.2V
// AIN_3 = AIN3 pin       fullscale is 1.2V
// AIN_4 = AIN0 / 5.0     fullscale is 6.0V
// AIN_5 = AIN1 / 5.0     fullscale is 6.0V
// AIN_6 = VDDB / 4.0     fullscale is 4.8V
// AIN_7 = VDD18          fullscale is 1.2V
// AIN_8 = VDD12          fullscale is 1.2V
// AIN_9 = VRTC / 2.0     fullscale is 2.4V
// AIN_10 = x undefined?
// AIN_11 = VDDIO / 4.0   fullscale is 4.8V
// AIN_12 = VDDIOH / 4.0  fullscale is 4.8V
//
//#include "max32625mbed.h" // ?
//MAX32625MBED mbed(MAX32625MBED::VIO_3V3); // ?
#define analogIn4_IS_HIGH_RANGE_OF_analogIn0 1
// MAX32630FTHR board supports only internal VREF = 1.200V at bypass capacitor C15
const float ADC_FULL_SCALE_VOLTAGE = 1.200;     // TODO: ADC_FULL_SCALE_VOLTAGE Pico?
// Arduino connector
#ifndef A0
#define A0 AIN_0
#endif
#ifndef A1
#define A1 AIN_1
#endif
#ifndef A2
#define A2 AIN_2
#endif
#ifndef A3
#define A3 AIN_3
#endif
#ifndef D0
#define D0 P0_0
#endif
#ifndef D1
#define D1 P0_1
#endif
#ifndef D2
#define D2 P0_2
#endif
#ifndef D3
#define D3 P0_3
#endif
#ifndef D4
#define D4 P0_4
#endif
#ifndef D5
#define D5 P0_5
#endif
#ifndef D6
#define D6 P0_6
#endif
#ifndef D7
#define D7 P0_7
#endif
#ifndef D8
#define D8 P1_4
#endif
#ifndef D9
#define D9 P1_5
#endif
#ifndef D10
#define D10 P1_3
#endif
#ifndef D11
#define D11 P1_1
#endif
#ifndef D12
#define D12 P1_2
#endif
#ifndef D13
#define D13 P1_0
#endif
//--------------------------------------------------
#elif defined(TARGET_MAX32600)
// target MAX32600
//
#define analogIn4_IS_HIGH_RANGE_OF_analogIn0 0
const float ADC_FULL_SCALE_VOLTAGE = 1.500;
//
//--------------------------------------------------
#elif defined(TARGET_MAX32620FTHR)
#warning "TARGET_MAX32620FTHR not previously tested; need to define pins..."
#include "MAX32620FTHR.h"
// Initialize I/O voltages on MAX32620FTHR board
MAX32620FTHR fthr(MAX32620FTHR::VIO_3V3);
//#define USE_LEDS 0 ?
#define analogIn4_IS_HIGH_RANGE_OF_analogIn0 1
#warning "TARGET_MAX32620FTHR not previously tested; need to verify ADC_FULL_SCALE_VOLTAGE..."
const float ADC_FULL_SCALE_VOLTAGE = 1.200;
//
//--------------------------------------------------
#elif defined(TARGET_MAX32625PICO)
#warning "TARGET_MAX32625PICO not previously tested; need to define pins..."
#include "max32625pico.h"
// configure MAX32625PICO VDDIOH mode, and I/O voltages for DIP pins and SWD pins
MAX32625PICO pico(
    // vddioh_mode_t iohMode
    //~ MAX32625PICO::IOH_OFF, // No connections to VDDIOH
    //~ MAX32625PICO::IOH_DIP_IN, // VDDIOH input from DIP pin 1 (AIN0)
    //~ MAX32625PICO::IOH_SWD_IN, // VDDIOH input from SWD pin 1
    MAX32625PICO::IOH_3V3, // VDDIOH = 3.3V from local supply
    //~ MAX32625PICO::IOH_DIP_OUT, // VDDIOH = 3.3V output to DIP pin 1
    //~ MAX32625PICO::IOH_SWD_OUT, // VDDIOH = 3.3V output to SWD pin 1
    //
    // vio_t dipVio = MAX32625PICO::VIO_1V8 or MAX32625PICO::VIO_IOH
    //~ MAX32625PICO::VIO_1V8, // 1.8V IO (local)
    MAX32625PICO::VIO_IOH, // Use VDDIOH (from DIP pin 1, or SWD pin1, or local 3.3V)
    //
    // vio_t swdVio
    //~ MAX32625PICO::VIO_1V8  // 1.8V IO (local)
    MAX32625PICO::VIO_IOH  // Use VDDIOH (from DIP pin 1, or SWD pin1, or local 3.3V)
    );
//#define USE_LEDS 0 ?
#define analogIn4_IS_HIGH_RANGE_OF_analogIn0 1
#warning "TARGET_MAX32625PICO not previously tested; need to verify ADC_FULL_SCALE_VOLTAGE..."
const float ADC_FULL_SCALE_VOLTAGE = 1.200;
//
//--------------------------------------------------
#elif defined(TARGET_NUCLEO_F446RE) || defined(TARGET_NUCLEO_F401RE)
// TODO1: target NUCLEO_F446RE
//
// USER_BUTTON PC13
// LED1 is shared with SPI_SCK on NUCLEO_F446RE PA_5, so don't use LED1.
#define USE_LEDS 0
// SPI spi(SPI_MOSI, SPI_MISO, SPI_SCK);
// Serial serial(SERIAL_TX, SERIAL_RX);
#define analogIn4_IS_HIGH_RANGE_OF_analogIn0 0
const float ADC_FULL_SCALE_VOLTAGE = 3.300;     // TODO: ADC_FULL_SCALE_VOLTAGE Pico?
//
//--------------------------------------------------
#elif defined(TARGET_LPC1768)
//--------------------------------------------------
// TARGET=LPC1768 ARM Cortex-M3 100 MHz 512kB flash 64kB SRAM
//               +-------------[microUSB]-------------+
//        ______ | [ ] GND             +3.3V VOUT [ ] | ______
//        ______ | [ ] 4.5V<VIN<9.0V   +5.0V VU   [ ] | ______
//        ______ | [ ] VB                 USB.IF- [ ] | ______
//        ______ | [ ] nR                 USB.IF+ [ ] | ______
// digitalInOut0 | [ ] p5 MOSI       ETHERNET.RD- [ ] | ______
// digitalInOut1 | [ ] p6 MISO       ETHERNET.RD+ [ ] | ______
// digitalInOut2 | [ ] p7 SCLK       ETHERNET.TD- [ ] | ______
// digitalInOut3 | [ ] p8            ETHERNET.TD+ [ ] | ______
// digitalInOut4 | [ ] p9  TX SDA          USB.D- [ ] | ______
// digitalInOut5 | [ ] p10 RX SCL          USB.D+ [ ] | ______
// digitalInOut6 | [ ] p11    MOSI     CAN-RD p30 [ ] | digitalInOut13
// digitalInOut7 | [ ] p12    MISO     CAN-TD p29 [ ] | digitalInOut12
// digitalInOut8 | [ ] p13 TX SCLK     SDA TX p28 [ ] | digitalInOut11
// digitalInOut9 | [ ] p14 RX          SCL RX p27 [ ] | digitalInOut10
//     analogIn0 | [ ] p15 AIN0 3.3Vfs   PWM1 p26 [ ] | pwmDriver1
//     analogIn1 | [ ] p16 AIN1 3.3Vfs   PWM2 p25 [ ] | pwmDriver2
//     analogIn2 | [ ] p17 AIN2 3.3Vfs   PWM3 p24 [ ] | pwmDriver3
//     analogIn3 | [ ] p18 AIN3 AOUT     PWM4 p23 [ ] | pwmDriver4
//     analogIn4 | [ ] p19 AIN4 3.3Vfs   PWM5 p22 [ ] | pwmDriver5
//     analogIn5 | [ ] p20 AIN5 3.3Vfs   PWM6 p21 [ ] | pwmDriver6
//               +------------------------------------+
// AIN6 = P0.3 = TGT_SBL_RXD?
// AIN7 = P0.2 = TGT_SBL_TXD?
//
//--------------------------------------------------
// LPC1768 board uses VREF = 3.300V +A3,3V thru L1 to bypass capacitor C14
#define analogIn4_IS_HIGH_RANGE_OF_analogIn0 0
const float ADC_FULL_SCALE_VOLTAGE = 3.300;
#else // not defined(TARGET_LPC1768 etc.)
//--------------------------------------------------
// unknown target
//--------------------------------------------------
#endif // target definition


//--------------------------------------------------
// Option to dedicate SPI port pins
//
//    SPI2_MOSI  = P5_1
//    SPI2_MISO  = P5_2
//    SPI2_SCK   = P5_0
//    On this board I'm using P3_0 as spi_cs
//    SPI2_SS    = P5_3
//    SPI2_SDIO2 = P5_4
//    SPI2_SDIO3 = P5_5
//    SPI2_SRN   = P5_6
//
#ifndef HAS_SPI
#define HAS_SPI 1
#endif
#if HAS_SPI
#define SPI_MODE0 0
#define SPI_MODE1 1
#define SPI_MODE2 2
#define SPI_MODE3 3
//
#if defined(TARGET_MAX32630)
  // Before setting global variables g_SPI_SCLK_Hz and g_SPI_dataMode,
  // workaround for TARGET_MAX32630 SPI_MODE2 SPI_MODE3 problem (issue #30)
#warning "MAX32630 SPI workaround..."
  // replace SPI_MODE2 (CPOL=1,CPHA=0) with SPI_MODE1 (CPOL=0,CPHA=1) Falling Edge stable
  // replace SPI_MODE3 (CPOL=1,CPHA=1) with SPI_MODE0 (CPOL=0,CPHA=0) Rising Edge stable
# if ((SPI_dataMode) == (SPI_MODE2))
#warning "MAX32630 SPI_MODE2 workaround, changing SPI_dataMode to SPI_MODE1..."
  // SPI_dataMode SPI_MODE2 // CPOL=1,CPHA=0: Falling Edge stable; SCLK idle High
#  undef SPI_dataMode
#  define SPI_dataMode SPI_MODE1 // CPOL=0,CPHA=1: Falling Edge stable; SCLK idle Low
# elif ((SPI_dataMode) == (SPI_MODE3))
#warning "MAX32630 SPI_MODE3 workaround, changing SPI_dataMode to SPI_MODE0..."
  // SPI_dataMode SPI_MODE3 // CPOL=1,CPHA=1: Rising Edge stable; SCLK idle High
#  undef SPI_dataMode
#  define SPI_dataMode SPI_MODE0 // CPOL=0,CPHA=0: Rising Edge stable; SCLK idle Low
# endif // workaround for TARGET_MAX32630 SPI_MODE2 SPI_MODE3 problem
  // workaround for TARGET_MAX32630 SPI_MODE2 SPI_MODE3 problem (issue #30)
  // limit SPI SCLK speed to 6MHz or less
# if ((SPI_SCLK_Hz) > (6000000))
#warning "MAX32630 SPI speed workaround, changing SPI_SCLK_Hz to 6000000 or 6MHz..."
#  undef SPI_SCLK_Hz
#  define SPI_SCLK_Hz 6000000 // 6MHz
# endif
#endif
//
uint32_t g_SPI_SCLK_Hz = 24000000; // platform limit 24MHz intSPI_SCLK_Platform_Max_MHz * 1000000
// TODO1: validate g_SPI_SCLK_Hz against system clock frequency SystemCoreClock F_CPU
#if defined(TARGET_NUCLEO_F446RE) || defined(TARGET_NUCLEO_F401RE)
// Nucleo SPI frequency isn't working quite as expected...
// Looks like STMF4 has an spi clock prescaler (2,4,8,16,32,64,128,256)
// so 180MHz->[90.0, 45.0, 22.5, 11.25, 5.625, 2.8125, 1.40625, 0.703125]
// %SC SCLK=1MHz sets spi frequency 703.125kHz
// %SC SCLK=2MHz sets spi frequency 1.40625MHz
// %SC SCLK=3MHz sets spi frequency 2.8125MHz
// %SC SCLK=6MHz sets spi frequency 5.625MHz
// %SC SCLK=12MHz sets spi frequency 11.25MHz
// %SC SCLK=23MHz sets spi frequency 22.5MHz
// %SC SCLK=45MHz sets spi frequency 45.0MHz
// Don't know why I can't reach spi frequency 90.0MHz, but ok whatever.
const uint32_t limit_min_SPI_SCLK_divisor = 2;
const uint32_t limit_max_SPI_SCLK_divisor = 256;
// not really a divisor, just a powers-of-two prescaler with no intermediate divisors.
#else
const uint32_t limit_min_SPI_SCLK_divisor = 2;
const uint32_t limit_max_SPI_SCLK_divisor = 8191;
#endif
const uint32_t limit_max_SPI_SCLK_Hz = (SystemCoreClock / limit_min_SPI_SCLK_divisor); // F_CPU / 2; // 8MHz / 2 = 4MHz
const uint32_t limit_min_SPI_SCLK_Hz = (SystemCoreClock / limit_max_SPI_SCLK_divisor); // F_CPU / 128; // 8MHz / 128 = 62.5kHz
//
uint8_t g_SPI_dataMode = SPI_MODE0; // TODO: missing definition SPI_dataMode;
uint8_t g_SPI_cs_state = 1;
//
#endif


// uncrustify-0.66.1 *INDENT-OFF*
//--------------------------------------------------
// Declare the DigitalInOut GPIO pins
// Optional digitalInOut support. If there is only one it should be digitalInOut1.
// D) Digital High/Low/Input Pin
#if defined(TARGET_MAX32630)
//       +-------------[microUSB]-------------+
//       | J1         MAX32630FTHR        J2  |
//       | [ ] RST                    GND [ ] |
//       | [ ] 3V3                    BAT+[ ] |
//       | [ ] 1V8                  reset SW1 |
//       | [ ] GND       J4               J3  |
//       | [ ] AIN_0 1.2Vfs     (bat) SYS [ ] |
//       | [ ] AIN_1 1.2Vfs           PWR [ ] |
//       | [ ] AIN_2 1.2Vfs      +5V VBUS [ ] |
//       | [ ] AIN_3 1.2Vfs   1-WIRE P4_0 [ ] | dig9
// dig10 | [x] P5_7  SDA2        SRN P5_6 [ ] | dig8
// dig11 | [x] P6_0  SCL2      SDIO3 P5_5 [ ] | dig7
// dig12 | [x] P5_0  SCLK      SDIO2 P5_4 [ ] | dig6
// dig13 | [x] P5_1  MOSI       SSEL P5_3 [x] | dig5
// dig14 | [ ] P5_2  MISO        RTS P3_3 [ ] | dig4
// dig15 | [ ] P3_0  RX          CTS P3_2 [ ] | dig3
// dig0  | [ ] P3_1  TX          SCL P3_5 [x] | dig2
//       | [ ] GND               SDA P3_4 [x] | dig1
//       +------------------------------------+
    #define HAS_digitalInOut0 1 // P3_1 TARGET_MAX32630 J1.15
    #define HAS_digitalInOut1 1 // P3_4 TARGET_MAX32630 J3.12
    #define HAS_digitalInOut2 1 // P3_5 TARGET_MAX32630 J3.11
    #define HAS_digitalInOut3 1 // P3_2 TARGET_MAX32630 J3.10
    #define HAS_digitalInOut4 1 // P3_3 TARGET_MAX32630 J3.9
    #define HAS_digitalInOut5 1 // P5_3 TARGET_MAX32630 J3.8
    #define HAS_digitalInOut6 1 // P5_4 TARGET_MAX32630 J3.7
    #define HAS_digitalInOut7 1 // P5_5 TARGET_MAX32630 J3.6
    #define HAS_digitalInOut8 1 // P5_6 TARGET_MAX32630 J3.5
    #define HAS_digitalInOut9 1 // P4_0 TARGET_MAX32630 J3.4
#if HAS_I2C
// avoid resource conflict between P5_7, P6_0 I2C and DigitalInOut
    #define HAS_digitalInOut10 0 // P5_7 TARGET_MAX32630 J1.9
    #define HAS_digitalInOut11 0 // P6_0 TARGET_MAX32630 J1.10
#else // HAS_I2C
    #define HAS_digitalInOut10 1 // P5_7 TARGET_MAX32630 J1.9
    #define HAS_digitalInOut11 1 // P6_0 TARGET_MAX32630 J1.10
#endif // HAS_I2C
#if HAS_SPI
// avoid resource conflict between P5_0, P5_1, P5_2 SPI and DigitalInOut
    #define HAS_digitalInOut12 0 // P5_0 TARGET_MAX32630 J1.11
    #define HAS_digitalInOut13 0 // P5_1 TARGET_MAX32630 J1.12
    #define HAS_digitalInOut14 0 // P5_2 TARGET_MAX32630 J1.13
    #define HAS_digitalInOut15 0 // P3_0 TARGET_MAX32630 J1.14
#else // HAS_SPI
    #define HAS_digitalInOut12 1 // P5_0 TARGET_MAX32630 J1.11
    #define HAS_digitalInOut13 1 // P5_1 TARGET_MAX32630 J1.12
    #define HAS_digitalInOut14 1 // P5_2 TARGET_MAX32630 J1.13
    #define HAS_digitalInOut15 1 // P3_0 TARGET_MAX32630 J1.14
#endif // HAS_SPI
#if HAS_digitalInOut0
    DigitalInOut digitalInOut0(P3_1, PIN_INPUT, PullUp, 1); // P3_1 TARGET_MAX32630 J1.15
#endif
#if HAS_digitalInOut1
    DigitalInOut digitalInOut1(P3_4, PIN_INPUT, PullUp, 1); // P3_4 TARGET_MAX32630 J3.12
#endif
#if HAS_digitalInOut2
    DigitalInOut digitalInOut2(P3_5, PIN_INPUT, PullUp, 1); // P3_5 TARGET_MAX32630 J3.11
#endif
#if HAS_digitalInOut3
    DigitalInOut digitalInOut3(P3_2, PIN_INPUT, PullUp, 1); // P3_2 TARGET_MAX32630 J3.10
#endif
#if HAS_digitalInOut4
    DigitalInOut digitalInOut4(P3_3, PIN_INPUT, PullUp, 1); // P3_3 TARGET_MAX32630 J3.9
#endif
#if HAS_digitalInOut5
    DigitalInOut digitalInOut5(P5_3, PIN_INPUT, PullUp, 1); // P5_3 TARGET_MAX32630 J3.8
#endif
#if HAS_digitalInOut6
    DigitalInOut digitalInOut6(P5_4, PIN_INPUT, PullUp, 1); // P5_4 TARGET_MAX32630 J3.7
#endif
#if HAS_digitalInOut7
    DigitalInOut digitalInOut7(P5_5, PIN_INPUT, PullUp, 1); // P5_5 TARGET_MAX32630 J3.6
#endif
#if HAS_digitalInOut8
    DigitalInOut digitalInOut8(P5_6, PIN_INPUT, PullUp, 1); // P5_6 TARGET_MAX32630 J3.5
#endif
#if HAS_digitalInOut9
    DigitalInOut digitalInOut9(P4_0, PIN_INPUT, PullUp, 1); // P4_0 TARGET_MAX32630 J3.4
#endif
#if HAS_digitalInOut10
    DigitalInOut digitalInOut10(P5_7, PIN_INPUT, PullUp, 1); // P5_7 TARGET_MAX32630 J1.9
#endif
#if HAS_digitalInOut11
    DigitalInOut digitalInOut11(P6_0, PIN_INPUT, PullUp, 1); // P6_0 TARGET_MAX32630 J1.10
#endif
#if HAS_digitalInOut12
    DigitalInOut digitalInOut12(P5_0, PIN_INPUT, PullUp, 1); // P5_0 TARGET_MAX32630 J1.11
#endif
#if HAS_digitalInOut13
    DigitalInOut digitalInOut13(P5_1, PIN_INPUT, PullUp, 1); // P5_1 TARGET_MAX32630 J1.12
#endif
#if HAS_digitalInOut14
    DigitalInOut digitalInOut14(P5_2, PIN_INPUT, PullUp, 1); // P5_2 TARGET_MAX32630 J1.13
#endif
#if HAS_digitalInOut15
    DigitalInOut digitalInOut15(P3_0, PIN_INPUT, PullUp, 1); // P3_0 TARGET_MAX32630 J1.14
#endif
//--------------------------------------------------
#elif defined(TARGET_MAX32625MBED)
// TARGET=MAX32625MBED ARM Cortex-M4F 96MHz 512kB Flash 160kB SRAM
//             +-------------------------------------+
//             |   MAX32625MBED Arduino UNO header   |
//             |                                     |
//             |                           A5/SCL[ ] |   P1_7 dig15
//             |                           A4/SDA[ ] |   P1_6 dig14
//             |                         AREF=N/C[ ] |
//             |                              GND[ ] |
//             | [ ]N/C                    SCK/13[ ] |   P1_0 dig13
//             | [ ]IOREF=3V3             MISO/12[ ] |   P1_2 dig12
//             | [ ]RST                   MOSI/11[ ]~|   P1_1 dig11
//             | [ ]3V3                     CS/10[ ]~|   P1_3 dig10
//             | [ ]5V0                         9[ ]~|   P1_5 dig9
//             | [ ]GND                         8[ ] |   P1_4 dig8
//             | [ ]GND                              |
//             | [ ]Vin                         7[ ] |   P0_7 dig7
//             |                                6[ ]~|   P0_6 dig6
//       AIN_0 | [ ]A0                          5[ ]~|   P0_5 dig5
//       AIN_1 | [ ]A1                          4[ ] |   P0_4 dig4
//       AIN_2 | [ ]A2                     INT1/3[ ]~|   P0_3 dig3
//       AIN_3 | [ ]A3                     INT0/2[ ] |   P0_2 dig2
// dig16  P3_4 | [ ]A4/SDA  RST SCK MISO     TX>1[ ] |   P0_1 dig1
// dig17  P3_5 | [ ]A5/SCL  [ ] [ ] [ ]      RX<0[ ] |   P0_0 dig0
//             |            [ ] [ ] [ ]              |
//             |  UNO_R3    GND MOSI 5V  ____________/
//              \_______________________/
//
    #define HAS_digitalInOut0 1 // P0_0 TARGET_MAX32625MBED D0
    #define HAS_digitalInOut1 1 // P0_1 TARGET_MAX32625MBED D1
#if APPLICATION_MAX11131
    #define HAS_digitalInOut2 0 // P0_2 TARGET_MAX32625MBED D2 -- MAX11131 EOC DigitalIn
#else
    #define HAS_digitalInOut2 1 // P0_2 TARGET_MAX32625MBED D2
#endif
    #define HAS_digitalInOut3 1 // P0_3 TARGET_MAX32625MBED D3
    #define HAS_digitalInOut4 1 // P0_4 TARGET_MAX32625MBED D4
    #define HAS_digitalInOut5 1 // P0_5 TARGET_MAX32625MBED D5
    #define HAS_digitalInOut6 1 // P0_6 TARGET_MAX32625MBED D6
    #define HAS_digitalInOut7 1 // P0_7 TARGET_MAX32625MBED D7
    #define HAS_digitalInOut8 1 // P1_4 TARGET_MAX32625MBED D8
#if APPLICATION_MAX11131
    #define HAS_digitalInOut9 0 // P1_5 TARGET_MAX32625MBED D9 -- MAX11131 CNVST DigitalOut
#else
    #define HAS_digitalInOut9 1 // P1_5 TARGET_MAX32625MBED D9
#endif
#if HAS_SPI
// avoid resource conflict between P5_0, P5_1, P5_2 SPI and DigitalInOut
    #define HAS_digitalInOut10 0 // P1_3 TARGET_MAX32635MBED CS/10
    #define HAS_digitalInOut11 0 // P1_1 TARGET_MAX32635MBED MOSI/11
    #define HAS_digitalInOut12 0 // P1_2 TARGET_MAX32635MBED MISO/12
    #define HAS_digitalInOut13 0 // P1_0 TARGET_MAX32635MBED SCK/13
#else // HAS_SPI
    #define HAS_digitalInOut10 1 // P1_3 TARGET_MAX32635MBED CS/10
    #define HAS_digitalInOut11 1 // P1_1 TARGET_MAX32635MBED MOSI/11
    #define HAS_digitalInOut12 1 // P1_2 TARGET_MAX32635MBED MISO/12
    #define HAS_digitalInOut13 1 // P1_0 TARGET_MAX32635MBED SCK/13
#endif // HAS_SPI
#if HAS_I2C
// avoid resource conflict between P5_7, P6_0 I2C and DigitalInOut
    #define HAS_digitalInOut14 0 // P1_6 TARGET_MAX32635MBED A4/SDA (10pin digital connector)
    #define HAS_digitalInOut15 0 // P1_7 TARGET_MAX32635MBED A5/SCL (10pin digital connector)
    #define HAS_digitalInOut16 0 // P3_4 TARGET_MAX32635MBED A4/SDA (6pin analog connector)
    #define HAS_digitalInOut17 0 // P3_5 TARGET_MAX32635MBED A5/SCL (6pin analog connector)
#else // HAS_I2C
    #define HAS_digitalInOut14 1 // P1_6 TARGET_MAX32635MBED A4/SDA (10pin digital connector)
    #define HAS_digitalInOut15 1 // P1_7 TARGET_MAX32635MBED A5/SCL (10pin digital connector)
    #define HAS_digitalInOut16 1 // P3_4 TARGET_MAX32635MBED A4/SDA (6pin analog connector)
    #define HAS_digitalInOut17 1 // P3_5 TARGET_MAX32635MBED A5/SCL (6pin analog connector)
#endif // HAS_I2C
#if HAS_digitalInOut0
    DigitalInOut digitalInOut0(P0_0, PIN_INPUT, PullUp, 1); // P0_0 TARGET_MAX32625MBED D0
#endif
#if HAS_digitalInOut1
    DigitalInOut digitalInOut1(P0_1, PIN_INPUT, PullUp, 1); // P0_1 TARGET_MAX32625MBED D1
#endif
#if HAS_digitalInOut2
    DigitalInOut digitalInOut2(P0_2, PIN_INPUT, PullUp, 1); // P0_2 TARGET_MAX32625MBED D2
#endif
#if HAS_digitalInOut3
    DigitalInOut digitalInOut3(P0_3, PIN_INPUT, PullUp, 1); // P0_3 TARGET_MAX32625MBED D3
#endif
#if HAS_digitalInOut4
    DigitalInOut digitalInOut4(P0_4, PIN_INPUT, PullUp, 1); // P0_4 TARGET_MAX32625MBED D4
#endif
#if HAS_digitalInOut5
    DigitalInOut digitalInOut5(P0_5, PIN_INPUT, PullUp, 1); // P0_5 TARGET_MAX32625MBED D5
#endif
#if HAS_digitalInOut6
    DigitalInOut digitalInOut6(P0_6, PIN_INPUT, PullUp, 1); // P0_6 TARGET_MAX32625MBED D6
#endif
#if HAS_digitalInOut7
    DigitalInOut digitalInOut7(P0_7, PIN_INPUT, PullUp, 1); // P0_7 TARGET_MAX32625MBED D7
#endif
#if HAS_digitalInOut8
    DigitalInOut digitalInOut8(P1_4, PIN_INPUT, PullUp, 1); // P1_4 TARGET_MAX32625MBED D8
#endif
#if HAS_digitalInOut9
    DigitalInOut digitalInOut9(P1_5, PIN_INPUT, PullUp, 1); // P1_5 TARGET_MAX32625MBED D9
#endif
#if HAS_digitalInOut10
    DigitalInOut digitalInOut10(P1_3, PIN_INPUT, PullUp, 1); // P1_3 TARGET_MAX32635MBED CS/10
#endif
#if HAS_digitalInOut11
    DigitalInOut digitalInOut11(P1_1, PIN_INPUT, PullUp, 1); // P1_1 TARGET_MAX32635MBED MOSI/11
#endif
#if HAS_digitalInOut12
    DigitalInOut digitalInOut12(P1_2, PIN_INPUT, PullUp, 1); // P1_2 TARGET_MAX32635MBED MISO/12
#endif
#if HAS_digitalInOut13
    DigitalInOut digitalInOut13(P1_0, PIN_INPUT, PullUp, 1); // P1_0 TARGET_MAX32635MBED SCK/13
#endif
#if HAS_digitalInOut14
    // Ensure that the unused I2C pins do not interfere with analog inputs A4 and A5
    // DigitalInOut mode can be one of PullUp, PullDown, PullNone, OpenDrain
    DigitalInOut digitalInOut14(P1_6, PIN_INPUT, OpenDrain, 1); // P1_6 TARGET_MAX32635MBED A4/SDA (10pin digital connector)
#endif
#if HAS_digitalInOut15
    // Ensure that the unused I2C pins do not interfere with analog inputs A4 and A5
    DigitalInOut digitalInOut15(P1_7, PIN_INPUT, OpenDrain, 1); // P1_7 TARGET_MAX32635MBED A5/SCL (10pin digital connector)
#endif
#if HAS_digitalInOut16
    // Ensure that the unused I2C pins do not interfere with analog inputs A4 and A5
    // DigitalInOut mode can be one of PullUp, PullDown, PullNone, OpenDrain
    // PullUp-->3.4V, PullDown-->1.7V, PullNone-->3.5V, OpenDrain-->0.00V
    DigitalInOut digitalInOut16(P3_4, PIN_INPUT, OpenDrain, 0); // P3_4 TARGET_MAX32635MBED A4/SDA (6pin analog connector)
#endif
#if HAS_digitalInOut17
    // Ensure that the unused I2C pins do not interfere with analog inputs A4 and A5
    DigitalInOut digitalInOut17(P3_5, PIN_INPUT, OpenDrain, 0); // P3_5 TARGET_MAX32635MBED A5/SCL (6pin analog connector)
#endif
//--------------------------------------------------
#elif defined(TARGET_NUCLEO_F446RE) || defined(TARGET_NUCLEO_F401RE)
    #define HAS_digitalInOut0 0
    #define HAS_digitalInOut1 0
#if APPLICATION_MAX11131
    // D2 -- MAX11131 EOC DigitalIn
    #define HAS_digitalInOut2 0
#else
    #define HAS_digitalInOut2 1
#endif
    #define HAS_digitalInOut3 1
    #define HAS_digitalInOut4 1
    #define HAS_digitalInOut5 1
    #define HAS_digitalInOut6 1
    #define HAS_digitalInOut7 1
#if APPLICATION_MAX5715
    // D8 -- MAX5715 CLRb DigitalOut
    #define HAS_digitalInOut8 0
#else
    #define HAS_digitalInOut8 1
#endif
#if APPLICATION_MAX5715
    // D9 -- MAX5715 LDACb DigitalOut
    #define HAS_digitalInOut9 0
#elif APPLICATION_MAX11131
    // D9 -- MAX11131 CNVST DigitalOut
    #define HAS_digitalInOut9 0
#else
    #define HAS_digitalInOut9 1
#endif
#if HAS_SPI
// avoid resource conflict between P5_0, P5_1, P5_2 SPI and DigitalInOut
    // Arduino digital pin D10 SPI function is CS/10
    // Arduino digital pin D11 SPI function is MOSI/11
    // Arduino digital pin D12 SPI function is MISO/12
    // Arduino digital pin D13 SPI function is SCK/13
    #define HAS_digitalInOut10 0
    #define HAS_digitalInOut11 0
    #define HAS_digitalInOut12 0
    #define HAS_digitalInOut13 0
#else // HAS_SPI
    #define HAS_digitalInOut10 1
    #define HAS_digitalInOut11 1
    #define HAS_digitalInOut12 1
    #define HAS_digitalInOut13 1
#endif // HAS_SPI
#if HAS_I2C
// avoid resource conflict between P5_7, P6_0 I2C and DigitalInOut
    // Arduino digital pin D14 I2C function is A4/SDA (10pin digital connector)
    // Arduino digital pin D15 I2C function is A5/SCL (10pin digital connector)
    // Arduino digital pin D16 I2C function is A4/SDA (6pin analog connector)
    // Arduino digital pin D17 I2C function is A5/SCL (6pin analog connector)
    #define HAS_digitalInOut14 0
    #define HAS_digitalInOut15 0
    #define HAS_digitalInOut16 0
    #define HAS_digitalInOut17 0
#else // HAS_I2C
    #define HAS_digitalInOut14 1
    #define HAS_digitalInOut15 1
    #define HAS_digitalInOut16 0
    #define HAS_digitalInOut17 0
#endif // HAS_I2C
#if HAS_digitalInOut0
    DigitalInOut digitalInOut0(D0, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut1
    DigitalInOut digitalInOut1(D1, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut2
    DigitalInOut digitalInOut2(D2, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut3
    DigitalInOut digitalInOut3(D3, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut4
    DigitalInOut digitalInOut4(D4, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut5
    DigitalInOut digitalInOut5(D5, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut6
    DigitalInOut digitalInOut6(D6, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut7
    DigitalInOut digitalInOut7(D7, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut8
    DigitalInOut digitalInOut8(D8, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut9
    DigitalInOut digitalInOut9(D9, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut10
    // Arduino digital pin D10 SPI function is CS/10
    DigitalInOut digitalInOut10(D10, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut11
    // Arduino digital pin D11 SPI function is MOSI/11
    DigitalInOut digitalInOut11(D11, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut12
    // Arduino digital pin D12 SPI function is MISO/12
    DigitalInOut digitalInOut12(D12, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut13
    // Arduino digital pin D13 SPI function is SCK/13
    DigitalInOut digitalInOut13(D13, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut14
    // Arduino digital pin D14 I2C function is A4/SDA (10pin digital connector)
    DigitalInOut digitalInOut14(D14, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut15
    // Arduino digital pin D15 I2C function is A5/SCL (10pin digital connector)
    DigitalInOut digitalInOut15(D15, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut16
    // Arduino digital pin D16 I2C function is A4/SDA (6pin analog connector)
    DigitalInOut digitalInOut16(D16, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut17
    // Arduino digital pin D17 I2C function is A5/SCL (6pin analog connector)
    DigitalInOut digitalInOut17(D17, PIN_INPUT, PullUp, 1);
#endif
//--------------------------------------------------
#elif defined(TARGET_LPC1768)
    #define HAS_digitalInOut0 1
    #define HAS_digitalInOut1 1
    #define HAS_digitalInOut2 1
    #define HAS_digitalInOut3 1
    #define HAS_digitalInOut4 1
    #define HAS_digitalInOut5 1
    #define HAS_digitalInOut6 1
    #define HAS_digitalInOut7 1
    #define HAS_digitalInOut8 1
    #define HAS_digitalInOut9 1
//    #define HAS_digitalInOut10 1
//    #define HAS_digitalInOut11 1
//    #define HAS_digitalInOut12 1
//    #define HAS_digitalInOut13 1
//    #define HAS_digitalInOut14 1
//    #define HAS_digitalInOut15 1
#if HAS_digitalInOut0
    DigitalInOut digitalInOut0(p5, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.9/I2STX_SDA/MOSI1/MAT2.3
#endif
#if HAS_digitalInOut1
    DigitalInOut digitalInOut1(p6, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.8/I2STX_WS/MISO1/MAT2.2
#endif
#if HAS_digitalInOut2
    DigitalInOut digitalInOut2(p7, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.7/I2STX_CLK/SCK1/MAT2.1
#endif
#if HAS_digitalInOut3
    DigitalInOut digitalInOut3(p8, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.6/I2SRX_SDA/SSEL1/MAT2.0
#endif
#if HAS_digitalInOut4
    DigitalInOut digitalInOut4(p9, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.0/CAN_RX1/TXD3/SDA1
#endif
#if HAS_digitalInOut5
    DigitalInOut digitalInOut5(p10, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.1/CAN_TX1/RXD3/SCL1
#endif
#if HAS_digitalInOut6
    DigitalInOut digitalInOut6(p11, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.18/DCD1/MOSI0/MOSI1
#endif
#if HAS_digitalInOut7
    DigitalInOut digitalInOut7(p12, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.17/CTS1/MISO0/MISO
#endif
#if HAS_digitalInOut8
    DigitalInOut digitalInOut8(p13, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.15/TXD1/SCK0/SCK
#endif
#if HAS_digitalInOut9
    DigitalInOut digitalInOut9(p14, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.16/RXD1/SSEL0/SSEL
#endif
    //
    // these pins support analog input analogIn0 .. analogIn5
    //DigitalInOut digitalInOut_(p15, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.23/AD0.0/I2SRX_CLK/CAP3.0
    //DigitalInOut digitalInOut_(p16, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.24/AD0.1/I2SRX_WS/CAP3.1
    //DigitalInOut digitalInOut_(p17, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.25/AD0.2/I2SRX_SDA/TXD3
    //DigitalInOut digitalInOut_(p18, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.26/AD0.3/AOUT/RXD3
    //DigitalInOut digitalInOut_(p19, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P1.30/VBUS/AD0.4
    //DigitalInOut digitalInOut_(p20, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P1.31/SCK1/AD0.5
    //
    // these pins support PWM pwmDriver1 .. pwmDriver6
    //DigitalInOut digitalInOut_(p21, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P2.5/PWM1.6/DTR1/TRACEDATA0
    //DigitalInOut digitalInOut_(p22, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P2.4/PWM1.5/DSR1/TRACEDATA1
    //DigitalInOut digitalInOut_(p23, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P2.3/PWM1.4/DCD1/TRACEDATA2
    //DigitalInOut digitalInOut_(p24, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P2.2/PWM1.3/CTS1/TRACEDATA3
    //DigitalInOut digitalInOut_(p25, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P2.1/PWM1.2/RXD1
    //DigitalInOut digitalInOut_(p26, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P2.0/PWM1.1/TXD1/TRACECLK
    //
    // these could be additional digitalInOut pins
#if HAS_digitalInOut10
    DigitalInOut digitalInOut10(p27, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.11/RXD2/SCL2/MAT3.1
#endif
#if HAS_digitalInOut11
    DigitalInOut digitalInOut11(p28, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.10/TXD2/SDA2/MAT3.0
#endif
#if HAS_digitalInOut12
    DigitalInOut digitalInOut12(p29, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.5/I2SRX_WS/CAN_TX2/CAP2.1
#endif
#if HAS_digitalInOut13
    DigitalInOut digitalInOut13(p30, PIN_INPUT, PullUp, 1); // TARGET_LPC1768 P0.4/I2SRX_CLK/CAN_RX2/CAP2.0
#endif
#if HAS_digitalInOut14
    DigitalInOut digitalInOut14(___, PIN_INPUT, PullUp, 1);
#endif
#if HAS_digitalInOut15
    DigitalInOut digitalInOut15(___, PIN_INPUT, PullUp, 1);
#endif
#else
    // unknown target
#endif
// uncrustify-0.66.1 *INDENT-ON*
#if HAS_digitalInOut0 || HAS_digitalInOut1 \
    || HAS_digitalInOut2 || HAS_digitalInOut3 \
    || HAS_digitalInOut4 || HAS_digitalInOut5 \
    || HAS_digitalInOut6 || HAS_digitalInOut7 \
    || HAS_digitalInOut8 || HAS_digitalInOut9 \
    || HAS_digitalInOut10 || HAS_digitalInOut11 \
    || HAS_digitalInOut12 || HAS_digitalInOut13 \
    || HAS_digitalInOut14 || HAS_digitalInOut15 \
    || HAS_digitalInOut16 || HAS_digitalInOut17
#define HAS_digitalInOuts 1
#else
#warning "Note: There are no digitalInOut resources defined"
#endif

// uncrustify-0.66.1 *INDENT-OFF*
//--------------------------------------------------
// Declare the AnalogIn driver
// Optional analogIn support. If there is only one it should be analogIn1.
// A) analog input
#if defined(TARGET_MAX32630)
    #define HAS_analogIn0 1
    #define HAS_analogIn1 1
    #define HAS_analogIn2 1
    #define HAS_analogIn3 1
    #define HAS_analogIn4 1
    #define HAS_analogIn5 1
    #define HAS_analogIn6 1
    #define HAS_analogIn7 1
    #define HAS_analogIn8 1
    #define HAS_analogIn9 1
//    #define HAS_analogIn10 0
//    #define HAS_analogIn11 0
//    #define HAS_analogIn12 0
//    #define HAS_analogIn13 0
//    #define HAS_analogIn14 0
//    #define HAS_analogIn15 0
#if HAS_analogIn0
    AnalogIn analogIn0(AIN_0); // TARGET_MAX32630 J1.5 AIN_0 = AIN0 pin       fullscale is 1.2V
#endif
#if HAS_analogIn1
    AnalogIn analogIn1(AIN_1); // TARGET_MAX32630 J1.6 AIN_1 = AIN1 pin       fullscale is 1.2V
#endif
#if HAS_analogIn2
    AnalogIn analogIn2(AIN_2); // TARGET_MAX32630 J1.7 AIN_2 = AIN2 pin       fullscale is 1.2V
#endif
#if HAS_analogIn3
    AnalogIn analogIn3(AIN_3); // TARGET_MAX32630 J1.8 AIN_3 = AIN3 pin       fullscale is 1.2V
#endif
#if HAS_analogIn4
    AnalogIn analogIn4(AIN_4); // TARGET_MAX32630 J1.5 AIN_4 = AIN0 / 5.0     fullscale is 6.0V
#endif
#if HAS_analogIn5
    AnalogIn analogIn5(AIN_5); // TARGET_MAX32630 J1.6 AIN_5 = AIN1 / 5.0     fullscale is 6.0V
#endif
#if HAS_analogIn6
    AnalogIn analogIn6(AIN_6); // TARGET_MAX32630 AIN_6 = VDDB / 4.0     fullscale is 4.8V
#endif
#if HAS_analogIn7
    AnalogIn analogIn7(AIN_7); // TARGET_MAX32630 AIN_7 = VDD18          fullscale is 1.2V
#endif
#if HAS_analogIn8
    AnalogIn analogIn8(AIN_8); // TARGET_MAX32630 AIN_8 = VDD12          fullscale is 1.2V
#endif
#if HAS_analogIn9
    AnalogIn analogIn9(AIN_9); // TARGET_MAX32630 AIN_9 = VRTC / 2.0     fullscale is 2.4V
#endif
#if HAS_analogIn10
    AnalogIn analogIn10(____); // TARGET_MAX32630 AIN_10 = x undefined?
#endif
#if HAS_analogIn11
    AnalogIn analogIn11(____); // TARGET_MAX32630 AIN_11 = VDDIO / 4.0   fullscale is 4.8V
#endif
#if HAS_analogIn12
    AnalogIn analogIn12(____); // TARGET_MAX32630 AIN_12 = VDDIOH / 4.0  fullscale is 4.8V
#endif
#if HAS_analogIn13
    AnalogIn analogIn13(____);
#endif
#if HAS_analogIn14
    AnalogIn analogIn14(____);
#endif
#if HAS_analogIn15
    AnalogIn analogIn15(____);
#endif
//--------------------------------------------------
#elif defined(TARGET_MAX32625MBED)
    #define HAS_analogIn0 1
    #define HAS_analogIn1 1
    #define HAS_analogIn2 1
    #define HAS_analogIn3 1
    #define HAS_analogIn4 1
    #define HAS_analogIn5 1
#if HAS_analogIn0
    AnalogIn analogIn0(AIN_0); // TARGET_MAX32630 J1.5 AIN_0 = AIN0 pin       fullscale is 1.2V
#endif
#if HAS_analogIn1
    AnalogIn analogIn1(AIN_1); // TARGET_MAX32630 J1.6 AIN_1 = AIN1 pin       fullscale is 1.2V
#endif
#if HAS_analogIn2
    AnalogIn analogIn2(AIN_2); // TARGET_MAX32630 J1.7 AIN_2 = AIN2 pin       fullscale is 1.2V
#endif
#if HAS_analogIn3
    AnalogIn analogIn3(AIN_3); // TARGET_MAX32630 J1.8 AIN_3 = AIN3 pin       fullscale is 1.2V
#endif
#if HAS_analogIn4
    AnalogIn analogIn4(AIN_4); // TARGET_MAX32630 J1.5 AIN_4 = AIN0 / 5.0     fullscale is 6.0V
#endif
#if HAS_analogIn5
    AnalogIn analogIn5(AIN_5); // TARGET_MAX32630 J1.6 AIN_5 = AIN1 / 5.0     fullscale is 6.0V
#endif
//--------------------------------------------------
#elif defined(TARGET_MAX32620FTHR)
#warning "TARGET_MAX32620FTHR not previously tested; need to verify analogIn0..."
    #define HAS_analogIn0 1
    #define HAS_analogIn1 1
    #define HAS_analogIn2 1
    #define HAS_analogIn3 1
    #define HAS_analogIn4 1
    #define HAS_analogIn5 1
    #define HAS_analogIn6 1
    #define HAS_analogIn7 1
    #define HAS_analogIn8 1
    #define HAS_analogIn9 1
//    #define HAS_analogIn10 0
//    #define HAS_analogIn11 0
//    #define HAS_analogIn12 0
//    #define HAS_analogIn13 0
//    #define HAS_analogIn14 0
//    #define HAS_analogIn15 0
#if HAS_analogIn0
    AnalogIn analogIn0(AIN_0); // TARGET_MAX32620FTHR J1.5 AIN_0 = AIN0 pin       fullscale is 1.2V
#endif
#if HAS_analogIn1
    AnalogIn analogIn1(AIN_1); // TARGET_MAX32620FTHR J1.6 AIN_1 = AIN1 pin       fullscale is 1.2V
#endif
#if HAS_analogIn2
    AnalogIn analogIn2(AIN_2); // TARGET_MAX32620FTHR J1.7 AIN_2 = AIN2 pin       fullscale is 1.2V
#endif
#if HAS_analogIn3
    AnalogIn analogIn3(AIN_3); // TARGET_MAX32620FTHR J1.8 AIN_3 = AIN3 pin       fullscale is 1.2V
#endif
#if HAS_analogIn4
    AnalogIn analogIn4(AIN_4); // TARGET_MAX32620FTHR J1.5 AIN_4 = AIN0 / 5.0     fullscale is 6.0V
#endif
#if HAS_analogIn5
    AnalogIn analogIn5(AIN_5); // TARGET_MAX32620FTHR J1.6 AIN_5 = AIN1 / 5.0     fullscale is 6.0V
#endif
#if HAS_analogIn6
    AnalogIn analogIn6(AIN_6); // TARGET_MAX32620FTHR AIN_6 = VDDB / 4.0     fullscale is 4.8V
#endif
#if HAS_analogIn7
    AnalogIn analogIn7(AIN_7); // TARGET_MAX32620FTHR AIN_7 = VDD18          fullscale is 1.2V
#endif
#if HAS_analogIn8
    AnalogIn analogIn8(AIN_8); // TARGET_MAX32620FTHR AIN_8 = VDD12          fullscale is 1.2V
#endif
#if HAS_analogIn9
    AnalogIn analogIn9(AIN_9); // TARGET_MAX32620FTHR AIN_9 = VRTC / 2.0     fullscale is 2.4V
#endif
#if HAS_analogIn10
    AnalogIn analogIn10(____); // TARGET_MAX32620FTHR AIN_10 = x undefined?
#endif
#if HAS_analogIn11
    AnalogIn analogIn11(____); // TARGET_MAX32620FTHR AIN_11 = VDDIO / 4.0   fullscale is 4.8V
#endif
#if HAS_analogIn12
    AnalogIn analogIn12(____); // TARGET_MAX32620FTHR AIN_12 = VDDIOH / 4.0  fullscale is 4.8V
#endif
#if HAS_analogIn13
    AnalogIn analogIn13(____);
#endif
#if HAS_analogIn14
    AnalogIn analogIn14(____);
#endif
#if HAS_analogIn15
    AnalogIn analogIn15(____);
#endif
//--------------------------------------------------
#elif defined(TARGET_MAX32625PICO)
#warning "TARGET_MAX32625PICO not previously tested; need to verify analogIn0..."
    #define HAS_analogIn0 1
    #define HAS_analogIn1 1
    #define HAS_analogIn2 1
    #define HAS_analogIn3 1
    #define HAS_analogIn4 1
    #define HAS_analogIn5 1
#if HAS_analogIn0
    AnalogIn analogIn0(AIN_0); // TARGET_MAX32630 J1.5 AIN_0 = AIN0 pin       fullscale is 1.2V
#endif
#if HAS_analogIn1
    AnalogIn analogIn1(AIN_1); // TARGET_MAX32630 J1.6 AIN_1 = AIN1 pin       fullscale is 1.2V
#endif
#if HAS_analogIn2
    AnalogIn analogIn2(AIN_2); // TARGET_MAX32630 J1.7 AIN_2 = AIN2 pin       fullscale is 1.2V
#endif
#if HAS_analogIn3
    AnalogIn analogIn3(AIN_3); // TARGET_MAX32630 J1.8 AIN_3 = AIN3 pin       fullscale is 1.2V
#endif
#if HAS_analogIn4
    AnalogIn analogIn4(AIN_4); // TARGET_MAX32630 J1.5 AIN_4 = AIN0 / 5.0     fullscale is 6.0V
#endif
#if HAS_analogIn5
    AnalogIn analogIn5(AIN_5); // TARGET_MAX32630 J1.6 AIN_5 = AIN1 / 5.0     fullscale is 6.0V
#endif
//--------------------------------------------------
#elif defined(TARGET_MAX32600)
    #define HAS_analogIn0 1
    #define HAS_analogIn1 1
    #define HAS_analogIn2 1
    #define HAS_analogIn3 1
    #define HAS_analogIn4 1
    #define HAS_analogIn5 1
#if HAS_analogIn0
    AnalogIn analogIn0(A0);
#endif
#if HAS_analogIn1
    AnalogIn analogIn1(A1);
#endif
#if HAS_analogIn2
    AnalogIn analogIn2(A2);
#endif
#if HAS_analogIn3
    AnalogIn analogIn3(A3);
#endif
#if HAS_analogIn4
    AnalogIn analogIn4(A4);
#endif
#if HAS_analogIn5
    AnalogIn analogIn5(A5);
#endif
//--------------------------------------------------
#elif defined(TARGET_NUCLEO_F446RE)
    #define HAS_analogIn0 1
    #define HAS_analogIn1 1
    #define HAS_analogIn2 1
    #define HAS_analogIn3 1
    #define HAS_analogIn4 1
    #define HAS_analogIn5 1
#if HAS_analogIn0
    AnalogIn analogIn0(A0);
#endif
#if HAS_analogIn1
    AnalogIn analogIn1(A1);
#endif
#if HAS_analogIn2
    AnalogIn analogIn2(A2);
#endif
#if HAS_analogIn3
    AnalogIn analogIn3(A3);
#endif
#if HAS_analogIn4
    AnalogIn analogIn4(A4);
#endif
#if HAS_analogIn5
    AnalogIn analogIn5(A5);
#endif
//--------------------------------------------------
#elif defined(TARGET_NUCLEO_F401RE)
    #define HAS_analogIn0 1
    #define HAS_analogIn1 1
    #define HAS_analogIn2 1
    #define HAS_analogIn3 1
    #define HAS_analogIn4 1
    #define HAS_analogIn5 1
#if HAS_analogIn0
    AnalogIn analogIn0(A0);
#endif
#if HAS_analogIn1
    AnalogIn analogIn1(A1);
#endif
#if HAS_analogIn2
    AnalogIn analogIn2(A2);
#endif
#if HAS_analogIn3
    AnalogIn analogIn3(A3);
#endif
#if HAS_analogIn4
    AnalogIn analogIn4(A4);
#endif
#if HAS_analogIn5
    AnalogIn analogIn5(A5);
#endif
//--------------------------------------------------
// TODO1: TARGET=MAX32625MBED ARM Cortex-M4F 96MHz 512kB Flash 160kB SRAM
#elif defined(TARGET_LPC1768)
    #define HAS_analogIn0 1
    #define HAS_analogIn1 1
    #define HAS_analogIn2 1
    #define HAS_analogIn3 1
    #define HAS_analogIn4 1
    #define HAS_analogIn5 1
//    #define HAS_analogIn6 1
//    #define HAS_analogIn7 1
//    #define HAS_analogIn8 1
//    #define HAS_analogIn9 1
//    #define HAS_analogIn10 1
//    #define HAS_analogIn11 1
//    #define HAS_analogIn12 1
//    #define HAS_analogIn13 1
//    #define HAS_analogIn14 1
//    #define HAS_analogIn15 1
#if HAS_analogIn0
    AnalogIn analogIn0(p15); // TARGET_LPC1768 P0.23/AD0.0/I2SRX_CLK/CAP3.0
#endif
#if HAS_analogIn1
    AnalogIn analogIn1(p16); // TARGET_LPC1768 P0.24/AD0.1/I2SRX_WS/CAP3.1
#endif
#if HAS_analogIn2
    AnalogIn analogIn2(p17); // TARGET_LPC1768 P0.25/AD0.2/I2SRX_SDA/TXD3
#endif
#if HAS_analogIn3
    AnalogIn analogIn3(p18); // TARGET_LPC1768 P0.26/AD0.3/AOUT/RXD3
#endif
#if HAS_analogIn4
    AnalogIn analogIn4(p19); // TARGET_LPC1768 P1.30/VBUS/AD0.4
#endif
#if HAS_analogIn5
    AnalogIn analogIn5(p20); // TARGET_LPC1768 P1.31/SCK1/AD0.5
#endif
#if HAS_analogIn6
    AnalogIn analogIn6(____);
#endif
#if HAS_analogIn7
    AnalogIn analogIn7(____);
#endif
#if HAS_analogIn8
    AnalogIn analogIn8(____);
#endif
#if HAS_analogIn9
    AnalogIn analogIn9(____);
#endif
#if HAS_analogIn10
    AnalogIn analogIn10(____);
#endif
#if HAS_analogIn11
    AnalogIn analogIn11(____);
#endif
#if HAS_analogIn12
    AnalogIn analogIn12(____);
#endif
#if HAS_analogIn13
    AnalogIn analogIn13(____);
#endif
#if HAS_analogIn14
    AnalogIn analogIn14(____);
#endif
#if HAS_analogIn15
    AnalogIn analogIn15(____);
#endif
#else
    // unknown target
#endif
// uncrustify-0.66.1 *INDENT-ON*
#if HAS_analogIn0 || HAS_analogIn1 \
    || HAS_analogIn2 || HAS_analogIn3 \
    || HAS_analogIn4 || HAS_analogIn5 \
    || HAS_analogIn6 || HAS_analogIn7 \
    || HAS_analogIn8 || HAS_analogIn9 \
    || HAS_analogIn10 || HAS_analogIn11 \
    || HAS_analogIn12 || HAS_analogIn13 \
    || HAS_analogIn14 || HAS_analogIn15
#define HAS_analogIns 1
#else
#warning "Note: There are no analogIn resources defined"
#endif

// DigitalInOut pin resource: print the pin index names to serial
#if HAS_digitalInOuts
void list_digitalInOutPins(Stream& serialStream)
{
#if HAS_digitalInOut0
    serialStream.printf(" 0");
#endif
#if HAS_digitalInOut1
    serialStream.printf(" 1");
#endif
#if HAS_digitalInOut2
    serialStream.printf(" 2");
#endif
#if HAS_digitalInOut3
    serialStream.printf(" 3");
#endif
#if HAS_digitalInOut4
    serialStream.printf(" 4");
#endif
#if HAS_digitalInOut5
    serialStream.printf(" 5");
#endif
#if HAS_digitalInOut6
    serialStream.printf(" 6");
#endif
#if HAS_digitalInOut7
    serialStream.printf(" 7");
#endif
#if HAS_digitalInOut8
    serialStream.printf(" 8");
#endif
#if HAS_digitalInOut9
    serialStream.printf(" 9");
#endif
#if HAS_digitalInOut10
    serialStream.printf(" 10");
#endif
#if HAS_digitalInOut11
    serialStream.printf(" 11");
#endif
#if HAS_digitalInOut12
    serialStream.printf(" 12");
#endif
#if HAS_digitalInOut13
    serialStream.printf(" 13");
#endif
#if HAS_digitalInOut14
    serialStream.printf(" 14");
#endif
#if HAS_digitalInOut15
    serialStream.printf(" 15");
#endif
#if HAS_digitalInOut16
    serialStream.printf(" 16");
#endif
#if HAS_digitalInOut17
    serialStream.printf(" 17");
#endif
}
#endif


// DigitalInOut pin resource: search index
#if HAS_digitalInOuts
DigitalInOut& find_digitalInOutPin(int cPinIndex)
{
    switch (cPinIndex)
    {
        default: // default to the first defined digitalInOut pin
#if HAS_digitalInOut0
        case '0': case 0x00: return digitalInOut0;
#endif
#if HAS_digitalInOut1
        case '1': case 0x01: return digitalInOut1;
#endif
#if HAS_digitalInOut2
        case '2': case 0x02: return digitalInOut2;
#endif
#if HAS_digitalInOut3
        case '3': case 0x03: return digitalInOut3;
#endif
#if HAS_digitalInOut4
        case '4': case 0x04: return digitalInOut4;
#endif
#if HAS_digitalInOut5
        case '5': case 0x05: return digitalInOut5;
#endif
#if HAS_digitalInOut6
        case '6': case 0x06: return digitalInOut6;
#endif
#if HAS_digitalInOut7
        case '7': case 0x07: return digitalInOut7;
#endif
#if HAS_digitalInOut8
        case '8': case 0x08: return digitalInOut8;
#endif
#if HAS_digitalInOut9
        case '9': case 0x09: return digitalInOut9;
#endif
#if HAS_digitalInOut10
        case 'a': case 0x0a: return digitalInOut10;
#endif
#if HAS_digitalInOut11
        case 'b': case 0x0b: return digitalInOut11;
#endif
#if HAS_digitalInOut12
        case 'c': case 0x0c: return digitalInOut12;
#endif
#if HAS_digitalInOut13
        case 'd': case 0x0d: return digitalInOut13;
#endif
#if HAS_digitalInOut14
        case 'e': case 0x0e: return digitalInOut14;
#endif
#if HAS_digitalInOut15
        case 'f': case 0x0f: return digitalInOut15;
#endif
#if HAS_digitalInOut16
        case 'g': case 0x10: return digitalInOut16;
#endif
#if HAS_digitalInOut17
        case 'h': case 0x11: return digitalInOut17;
#endif
    }
}
#endif


// AnalogIn pin resource: search index
#if HAS_analogIns
AnalogIn& find_analogInPin(int cPinIndex)
{
    switch (cPinIndex)
    {
        default: // default to the first defined analogIn pin
#if HAS_analogIn0
        case '0': case 0x00: return analogIn0;
#endif
#if HAS_analogIn1
        case '1': case 0x01: return analogIn1;
#endif
#if HAS_analogIn2
        case '2': case 0x02: return analogIn2;
#endif
#if HAS_analogIn3
        case '3': case 0x03: return analogIn3;
#endif
#if HAS_analogIn4
        case '4': case 0x04: return analogIn4;
#endif
#if HAS_analogIn5
        case '5': case 0x05: return analogIn5;
#endif
#if HAS_analogIn6
        case '6': case 0x06: return analogIn6;
#endif
#if HAS_analogIn7
        case '7': case 0x07: return analogIn7;
#endif
#if HAS_analogIn8
        case '8': case 0x08: return analogIn8;
#endif
#if HAS_analogIn9
        case '9': case 0x09: return analogIn9;
#endif
#if HAS_analogIn10
        case 'a': case 0x0a: return analogIn10;
#endif
#if HAS_analogIn11
        case 'b': case 0x0b: return analogIn11;
#endif
#if HAS_analogIn12
        case 'c': case 0x0c: return analogIn12;
#endif
#if HAS_analogIn13
        case 'd': case 0x0d: return analogIn13;
#endif
#if HAS_analogIn14
        case 'e': case 0x0e: return analogIn14;
#endif
#if HAS_analogIn15
        case 'f': case 0x0f: return analogIn15;
#endif
    }
}
#endif

#if HAS_analogIns
const float analogInPin_fullScaleVoltage[] = {
# if defined(TARGET_MAX32630)
    ADC_FULL_SCALE_VOLTAGE, // analogIn0
    ADC_FULL_SCALE_VOLTAGE, // analogIn1
    ADC_FULL_SCALE_VOLTAGE, // analogIn2
    ADC_FULL_SCALE_VOLTAGE, // analogIn3
    ADC_FULL_SCALE_VOLTAGE * 5.0f, // analogIn4 // AIN_4 = AIN0 / 5.0     fullscale is 6.0V
    ADC_FULL_SCALE_VOLTAGE * 5.0f, // analogIn4 // AIN_5 = AIN1 / 5.0     fullscale is 6.0V
    ADC_FULL_SCALE_VOLTAGE * 4.0f, // analogIn6 // AIN_6 = VDDB / 4.0     fullscale is 4.8V
    ADC_FULL_SCALE_VOLTAGE, // analogIn7 // AIN_7 = VDD18          fullscale is 1.2V
    ADC_FULL_SCALE_VOLTAGE, // analogIn8 // AIN_8 = VDD12          fullscale is 1.2V
    ADC_FULL_SCALE_VOLTAGE * 2.0f, // analogIn9 // AIN_9 = VRTC / 2.0     fullscale is 2.4V
    ADC_FULL_SCALE_VOLTAGE, // analogIn10  // AIN_10 = x undefined?
    ADC_FULL_SCALE_VOLTAGE * 4.0f, // analogIn11 // AIN_11 = VDDIO / 4.0   fullscale is 4.8V
    ADC_FULL_SCALE_VOLTAGE * 4.0f, // analogIn12 // AIN_12 = VDDIOH / 4.0  fullscale is 4.8V
    ADC_FULL_SCALE_VOLTAGE, // analogIn13
    ADC_FULL_SCALE_VOLTAGE, // analogIn14
    ADC_FULL_SCALE_VOLTAGE // analogIn15
# elif defined(TARGET_MAX32620FTHR)
#warning "TARGET_MAX32620FTHR not previously tested; need to verify analogIn0..."
    ADC_FULL_SCALE_VOLTAGE, // analogIn0
    ADC_FULL_SCALE_VOLTAGE, // analogIn1
    ADC_FULL_SCALE_VOLTAGE, // analogIn2
    ADC_FULL_SCALE_VOLTAGE, // analogIn3
    ADC_FULL_SCALE_VOLTAGE * 5.0f, // analogIn4 // AIN_4 = AIN0 / 5.0     fullscale is 6.0V
    ADC_FULL_SCALE_VOLTAGE * 5.0f, // analogIn4 // AIN_5 = AIN1 / 5.0     fullscale is 6.0V
    ADC_FULL_SCALE_VOLTAGE * 4.0f, // analogIn6 // AIN_6 = VDDB / 4.0     fullscale is 4.8V
    ADC_FULL_SCALE_VOLTAGE, // analogIn7 // AIN_7 = VDD18          fullscale is 1.2V
    ADC_FULL_SCALE_VOLTAGE, // analogIn8 // AIN_8 = VDD12          fullscale is 1.2V
    ADC_FULL_SCALE_VOLTAGE * 2.0f, // analogIn9 // AIN_9 = VRTC / 2.0     fullscale is 2.4V
    ADC_FULL_SCALE_VOLTAGE, // analogIn10  // AIN_10 = x undefined?
    ADC_FULL_SCALE_VOLTAGE * 4.0f, // analogIn11 // AIN_11 = VDDIO / 4.0   fullscale is 4.8V
    ADC_FULL_SCALE_VOLTAGE * 4.0f, // analogIn12 // AIN_12 = VDDIOH / 4.0  fullscale is 4.8V
    ADC_FULL_SCALE_VOLTAGE, // analogIn13
    ADC_FULL_SCALE_VOLTAGE, // analogIn14
    ADC_FULL_SCALE_VOLTAGE // analogIn15
#elif defined(TARGET_MAX32625MBED) || defined(TARGET_MAX32625PICO)
    ADC_FULL_SCALE_VOLTAGE * 1.0f, // analogIn0 // fullscale is 1.2V
    ADC_FULL_SCALE_VOLTAGE * 1.0f, // analogIn1 // fullscale is 1.2V
    ADC_FULL_SCALE_VOLTAGE * 1.0f, // analogIn2 // fullscale is 1.2V
    ADC_FULL_SCALE_VOLTAGE * 1.0f, // analogIn3 // fullscale is 1.2V
    ADC_FULL_SCALE_VOLTAGE * 5.0f, // analogIn4 // AIN_4 = AIN0 / 5.0     fullscale is 6.0V
    ADC_FULL_SCALE_VOLTAGE * 5.0f, // analogIn4 // AIN_5 = AIN1 / 5.0     fullscale is 6.0V
    ADC_FULL_SCALE_VOLTAGE * 4.0f, // analogIn6 // AIN_6 = VDDB / 4.0     fullscale is 4.8V
    ADC_FULL_SCALE_VOLTAGE, // analogIn7 // AIN_7 = VDD18          fullscale is 1.2V
    ADC_FULL_SCALE_VOLTAGE, // analogIn8 // AIN_8 = VDD12          fullscale is 1.2V
    ADC_FULL_SCALE_VOLTAGE * 2.0f, // analogIn9 // AIN_9 = VRTC / 2.0     fullscale is 2.4V
    ADC_FULL_SCALE_VOLTAGE, // analogIn10  // AIN_10 = x undefined?
    ADC_FULL_SCALE_VOLTAGE * 4.0f, // analogIn11 // AIN_11 = VDDIO / 4.0   fullscale is 4.8V
    ADC_FULL_SCALE_VOLTAGE * 4.0f, // analogIn12 // AIN_12 = VDDIOH / 4.0  fullscale is 4.8V
    ADC_FULL_SCALE_VOLTAGE, // analogIn13
    ADC_FULL_SCALE_VOLTAGE, // analogIn14
    ADC_FULL_SCALE_VOLTAGE // analogIn15
#elif defined(TARGET_NUCLEO_F446RE)
    ADC_FULL_SCALE_VOLTAGE, // analogIn0
    ADC_FULL_SCALE_VOLTAGE, // analogIn1
    ADC_FULL_SCALE_VOLTAGE, // analogIn2
    ADC_FULL_SCALE_VOLTAGE, // analogIn3
    ADC_FULL_SCALE_VOLTAGE, // analogIn4
    ADC_FULL_SCALE_VOLTAGE, // analogIn5
    ADC_FULL_SCALE_VOLTAGE, // analogIn6
    ADC_FULL_SCALE_VOLTAGE, // analogIn7
    ADC_FULL_SCALE_VOLTAGE, // analogIn8
    ADC_FULL_SCALE_VOLTAGE, // analogIn9
    ADC_FULL_SCALE_VOLTAGE, // analogIn10
    ADC_FULL_SCALE_VOLTAGE, // analogIn11
    ADC_FULL_SCALE_VOLTAGE, // analogIn12
    ADC_FULL_SCALE_VOLTAGE, // analogIn13
    ADC_FULL_SCALE_VOLTAGE, // analogIn14
    ADC_FULL_SCALE_VOLTAGE // analogIn15
#elif defined(TARGET_NUCLEO_F401RE)
    ADC_FULL_SCALE_VOLTAGE, // analogIn0
    ADC_FULL_SCALE_VOLTAGE, // analogIn1
    ADC_FULL_SCALE_VOLTAGE, // analogIn2
    ADC_FULL_SCALE_VOLTAGE, // analogIn3
    ADC_FULL_SCALE_VOLTAGE, // analogIn4
    ADC_FULL_SCALE_VOLTAGE, // analogIn5
    ADC_FULL_SCALE_VOLTAGE, // analogIn6
    ADC_FULL_SCALE_VOLTAGE, // analogIn7
    ADC_FULL_SCALE_VOLTAGE, // analogIn8
    ADC_FULL_SCALE_VOLTAGE, // analogIn9
    ADC_FULL_SCALE_VOLTAGE, // analogIn10
    ADC_FULL_SCALE_VOLTAGE, // analogIn11
    ADC_FULL_SCALE_VOLTAGE, // analogIn12
    ADC_FULL_SCALE_VOLTAGE, // analogIn13
    ADC_FULL_SCALE_VOLTAGE, // analogIn14
    ADC_FULL_SCALE_VOLTAGE // analogIn15
//#elif defined(TARGET_LPC1768)
#else
    // unknown target
    ADC_FULL_SCALE_VOLTAGE, // analogIn0
    ADC_FULL_SCALE_VOLTAGE, // analogIn1
    ADC_FULL_SCALE_VOLTAGE, // analogIn2
    ADC_FULL_SCALE_VOLTAGE, // analogIn3
    ADC_FULL_SCALE_VOLTAGE, // analogIn4
    ADC_FULL_SCALE_VOLTAGE, // analogIn5
    ADC_FULL_SCALE_VOLTAGE, // analogIn6
    ADC_FULL_SCALE_VOLTAGE, // analogIn7
    ADC_FULL_SCALE_VOLTAGE, // analogIn8
    ADC_FULL_SCALE_VOLTAGE, // analogIn9
    ADC_FULL_SCALE_VOLTAGE, // analogIn10
    ADC_FULL_SCALE_VOLTAGE, // analogIn11
    ADC_FULL_SCALE_VOLTAGE, // analogIn12
    ADC_FULL_SCALE_VOLTAGE, // analogIn13
    ADC_FULL_SCALE_VOLTAGE, // analogIn14
    ADC_FULL_SCALE_VOLTAGE // analogIn15
# endif
};
#endif




//--------------------------------------------------
// Option to use LEDs to show status
#ifndef USE_LEDS
#define USE_LEDS 1
#endif
#if USE_LEDS
#if defined(TARGET_MAX32630)
# define LED_ON  0
# define LED_OFF 1
//--------------------------------------------------
#elif defined(TARGET_MAX32625MBED)
# define LED_ON  0
# define LED_OFF 1
#elif defined(TARGET_MAX32625PICO)
# define LED_ON  0
# define LED_OFF 1
//--------------------------------------------------
// TODO1: TARGET=MAX32625MBED ARM Cortex-M4F 96MHz 512kB Flash 160kB SRAM
#elif defined(TARGET_LPC1768)
# define LED_ON  1
# define LED_OFF 0
#else // not defined(TARGET_LPC1768 etc.)
// USE_LEDS with some platform other than MAX32630, MAX32625MBED, LPC1768
// bugfix for MAX32600MBED LED blink pattern: check if LED_ON/LED_OFF already defined
# ifndef LED_ON
#  define LED_ON  0
# endif
# ifndef LED_OFF
#  define LED_OFF 1
# endif
//# define LED_ON  1
//# define LED_OFF 0
#endif // target definition
DigitalOut led1(LED1, LED_OFF); // MAX32630FTHR: LED1 = LED_RED
DigitalOut led2(LED2, LED_OFF); // MAX32630FTHR: LED2 = LED_GREEN
DigitalOut led3(LED3, LED_OFF); // MAX32630FTHR: LED3 = LED_BLUE
DigitalOut led4(LED4, LED_OFF);
#else // USE_LEDS=0
// issue #41 support Nucleo_F446RE
// there are no LED indicators on the board, LED1 interferes with SPI;
// but we still need placeholders led1 led2 led3 led4.
// Declare DigitalOut led1 led2 led3 led4 targeting safe pins.
// PinName NC means NOT_CONNECTED; DigitalOut::is_connected() returns false
# define LED_ON  0
# define LED_OFF 1
DigitalOut led1(NC, LED_OFF);
DigitalOut led2(NC, LED_OFF);
DigitalOut led3(NC, LED_OFF);
DigitalOut led4(NC, LED_OFF);
#endif // USE_LEDS
#define led1_RFailLED led1
#define led2_GPassLED led2
#define led3_BBusyLED led3

//--------------------------------------------------


// example code board support
//MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);
//DigitalOut rLED(LED1);
//DigitalOut gLED(LED2);
//DigitalOut bLED(LED3);
//
// Arduino "shield" connector port definitions (MAX32625MBED shown)
#if defined(TARGET_MAX32625MBED)
#define A0 AIN_0
#define A1 AIN_1
#define A2 AIN_2
#define A3 AIN_3
#define D0 P0_0
#define D1 P0_1
#define D2 P0_2
#define D3 P0_3
#define D4 P0_4
#define D5 P0_5
#define D6 P0_6
#define D7 P0_7
#define D8 P1_4
#define D9 P1_5
#define D10 P1_3
#define D11 P1_1
#define D12 P1_2
#define D13 P1_0
#elif defined(TARGET_MAX32625PICO)
#warning "TARGET_MAX32625PICO not previously tested; need to define pins..."
#define A0 AIN_1
#define A1 AIN_2
// #define A2 AIN_3
// #define A3 AIN_0
#define D0 P0_0
#define D1 P0_1
#define D2 P0_2
#define D3 P0_3
#define D4 P1_7
#define D5 P1_6
#define D6 P4_4
#define D7 P4_5
#define D8 P4_6
#define D9 P4_7
#define D10 P0_7
#define D11 P0_6
#define D12 P0_5
#define D13 P0_4
#endif

// example code declare SPI interface (GPIO controlled CS)
#if defined(TARGET_MAX32625MBED)
SPI spi(SPI1_MOSI, SPI1_MISO, SPI1_SCK); // mosi, miso, sclk spi1 TARGET_MAX32625MBED: P1_1 P1_2 P1_0 Arduino 10-pin header D11 D12 D13
DigitalOut spi_cs(SPI1_SS); // TARGET_MAX32625MBED: P1_3 Arduino 10-pin header D10
#elif defined(TARGET_MAX32625PICO)
#warning "TARGET_MAX32625PICO not previously tested; need to define pins..."
SPI spi(SPI0_MOSI, SPI0_MISO, SPI0_SCK); // mosi, miso, sclk spi1 TARGET_MAX32625PICO: pin P0_5 P0_6 P0_4
DigitalOut spi_cs(SPI0_SS); // TARGET_MAX32625PICO: pin P0_7
#elif defined(TARGET_MAX32600MBED)
SPI spi(SPI2_MOSI, SPI2_MISO, SPI2_SCK); // mosi, miso, sclk spi1 TARGET_MAX32600MBED: Arduino 10-pin header D11 D12 D13
DigitalOut spi_cs(SPI2_SS); // Generic: Arduino 10-pin header D10
#elif defined(TARGET_NUCLEO_F446RE) || defined(TARGET_NUCLEO_F401RE)
// TODO1: avoid resource conflict between P5_0, P5_1, P5_2 SPI and DigitalInOut
// void spi_init(spi_t *obj, PinName mosi, PinName miso, PinName sclk, PinName ssel)
//
// TODO1: NUCLEO_F446RE SPI not working; CS and MOSI data looks OK but no SCLK clock pulses.
SPI spi(SPI_MOSI, SPI_MISO, SPI_SCK); // mosi, miso, sclk spi1 TARGET_NUCLEO_F446RE: Arduino 10-pin header D11 D12 D13
DigitalOut spi_cs(SPI_CS); // TARGET_NUCLEO_F446RE: PB_6 Arduino 10-pin header D10
//
#else
SPI spi(D11, D12, D13); // mosi, miso, sclk spi1 TARGET_MAX32600MBED: Arduino 10-pin header D11 D12 D13
DigitalOut spi_cs(D10); // Generic: Arduino 10-pin header D10
#endif

// example code declare GPIO interface pins
// example code declare device instance
MAX11410 g_MAX11410_device(spi, spi_cs, MAX11410::MAX11410_IC);


//----------------------------------------
// Global SPI options
//

//--------------------------------------------------
// Optional Diagnostic function to print SPI transactions
#ifndef MAX11410_ONSPIPRINT
#define MAX11410_ONSPIPRINT 1
#endif // MAX11410_ONSPIPRINT
// Enable the onSPIprint diagnostic at startup (toggle with %SD menu item)
#ifndef MAX11410_ONSPIPRINT_ENABLED
#define MAX11410_ONSPIPRINT_ENABLED 1
#endif // MAX11410_ONSPIPRINT_ENABLED

#define APPLICATION_ArduinoPinsMonitor 1

//--------------------------------------------------
// use BUTTON1 trigger some action
#if defined(TARGET_MAX32630)
#define HAS_BUTTON1_DEMO_INTERRUPT 1
#define HAS_BUTTON2_DEMO 0
#define HAS_BUTTON2_DEMO_INTERRUPT 0
#elif defined(TARGET_MAX32625PICO)
#warning "TARGET_MAX32625PICO not previously tested; need to define buttons..."
#define HAS_BUTTON1_DEMO_INTERRUPT 1
#define HAS_BUTTON2_DEMO 0
#define HAS_BUTTON2_DEMO_INTERRUPT 0
#elif defined(TARGET_MAX32625)
#define HAS_BUTTON1_DEMO_INTERRUPT 1
#define HAS_BUTTON2_DEMO_INTERRUPT 1
#elif defined(TARGET_MAX32620FTHR)
#warning "TARGET_MAX32620FTHR not previously tested; need to define buttons..."
#define BUTTON1 SW1
#define HAS_BUTTON1_DEMO_INTERRUPT 1
#define HAS_BUTTON2_DEMO 0
#define HAS_BUTTON2_DEMO_INTERRUPT 0
#elif defined(TARGET_NUCLEO_F446RE)
#define HAS_BUTTON1_DEMO_INTERRUPT 0
#define HAS_BUTTON2_DEMO_INTERRUPT 0
#elif defined(TARGET_NUCLEO_F401RE)
#define HAS_BUTTON1_DEMO_INTERRUPT 0
#define HAS_BUTTON2_DEMO_INTERRUPT 0
#else
#warning "target not previously tested; need to define buttons..."
#endif
//
#ifndef HAS_BUTTON1_DEMO
#define HAS_BUTTON1_DEMO 0
#endif
#ifndef HAS_BUTTON2_DEMO
#define HAS_BUTTON2_DEMO 0
#endif
//
// avoid runtime error on button1 press [mbed-os-5.11]
// instead of using InterruptIn, use DigitalIn and poll in main while(1)
#ifndef HAS_BUTTON1_DEMO_INTERRUPT_POLLING
#define HAS_BUTTON1_DEMO_INTERRUPT_POLLING 1
#endif
//
#ifndef HAS_BUTTON1_DEMO_INTERRUPT
#define HAS_BUTTON1_DEMO_INTERRUPT 1
#endif
#ifndef HAS_BUTTON2_DEMO_INTERRUPT
#define HAS_BUTTON2_DEMO_INTERRUPT 1
#endif
//
#if HAS_BUTTON1_DEMO_INTERRUPT
# if HAS_BUTTON1_DEMO_INTERRUPT_POLLING
// avoid runtime error on button1 press [mbed-os-5.11]
// instead of using InterruptIn, use DigitalIn and poll in main while(1)
DigitalIn button1(BUTTON1);
# else
InterruptIn button1(BUTTON1);
# endif
#elif HAS_BUTTON1_DEMO
DigitalIn button1(BUTTON1);
#endif
#if HAS_BUTTON2_DEMO_INTERRUPT
# if HAS_BUTTON1_DEMO_INTERRUPT_POLLING
// avoid runtime error on button1 press [mbed-os-5.11]
// instead of using InterruptIn, use DigitalIn and poll in main while(1)
DigitalIn button2(BUTTON2);
# else
InterruptIn button2(BUTTON2);
# endif
#elif HAS_BUTTON2_DEMO
DigitalIn button2(BUTTON2);
#endif

//--------------------------------------------------
// functions tested by SelfTest()
extern uint8_t fn_MAX11410_Init(void);
extern uint8_t fn_MAX11410_RegRead(int commandByte, uint32_t* ptrRegData);
extern uint8_t fn_MAX11410_RegWrite(int commandByte, uint32_t regData);
extern double fn_MAX11410_Measure_Voltage(int ainp, int ainn);
extern uint8_t fn_MAX11410_Configure_CTRL_REF(uint8_t ref_sel);
extern uint8_t fn_MAX11410_Configure_PGA(uint8_t sigpath, uint8_t gain);
extern double fn_MAX11410_VoltageOfCode_Unipolar(uint32_t value_u24);
extern double fn_MAX11410_VoltageOfCode_Bipolar_OffsetBinary(uint32_t value_u24);
extern double fn_MAX11410_VoltageOfCode_Bipolar_2sComplement(uint32_t value_u24);
extern double fn_MAX11410_TemperatureOfRTD_PT1000(double rtd_ohm);
extern double fn_MAX11410_TemperatureOfRTD_PT100(double rtd_ohm);
extern double fn_MAX11410_TemperatureOfRTD(double rtd_ohm);
extern double fn_MAX11410_TemperatureOfTC_TypeK(double tc_v);

//--------------------------------------------------
// optional self-test groups for self test function SelfTest()
// enable by changing the #define value from 0 to 1

// SelfTest group POR description:
// verify initial register values
#ifndef MAX11410_SELFTEST_POR
#define MAX11410_SELFTEST_POR 1
#endif

// SelfTest group PORverbose description:
// verify initial register values
#ifndef MAX11410_SELFTEST_PORverbose
#define MAX11410_SELFTEST_PORverbose 1
#endif

// SelfTest group RES1KA2A3TOGND description:
// measure a 1kohm resistor between (AIN2,AIN3) and AGND to verify ref2_v (disabled by default)
#ifndef MAX11410_SELFTEST_RES1KA2A3TOGND
#define MAX11410_SELFTEST_RES1KA2A3TOGND 1
#endif

// SelfTest group RES1KA2A3TOGNDMORE description:
// measure a 1kohm resistor between (AIN2,AIN3) and AGND to verify ref2_v in more detail
#ifndef MAX11410_SELFTEST_RES1KA2A3TOGNDMORE
#define MAX11410_SELFTEST_RES1KA2A3TOGNDMORE 1
#endif

// SelfTest group UNIPOLAR description:
// Verify function VoltageOfCode_Unipolar
#ifndef MAX11410_SELFTEST_UNIPOLAR
#define MAX11410_SELFTEST_UNIPOLAR 1
#endif

// SelfTest group BIPOB description:
// Verify function VoltageOfCode_Bipolar_OffsetBinary
#ifndef MAX11410_SELFTEST_BIPOB
#define MAX11410_SELFTEST_BIPOB 1
#endif

// SelfTest group BIP2C description:
// Verify function VoltageOfCode_Bipolar_2sComplement
#ifndef MAX11410_SELFTEST_BIP2C
#define MAX11410_SELFTEST_BIP2C 1
#endif

// SelfTest group RTD_PT1000 description:
// PT1000 type Resistive Temperature Device (RTD)
#ifndef MAX11410_SELFTEST_RTD_PT1000
#define MAX11410_SELFTEST_RTD_PT1000 1
#endif

// SelfTest group RTD_PT100 description:
// PT100 type Resistive Temperature Device (RTD)
#ifndef MAX11410_SELFTEST_RTD_PT100
#define MAX11410_SELFTEST_RTD_PT100 1
#endif

// SelfTest group RTD description:
// Verify function TemperatureOfRTD
#ifndef MAX11410_SELFTEST_RTD
#define MAX11410_SELFTEST_RTD 1
#endif

// SelfTest group TC_1 description:
// Verify Thermocouple function TemperatureOfTC_TypeK
#ifndef MAX11410_SELFTEST_TC_1
#define MAX11410_SELFTEST_TC_1 1
#endif

// SelfTest group TC_2 description:
// Verify Thermocouple function TemperatureOfTC_TypeK in more detail
#ifndef MAX11410_SELFTEST_TC_2
#define MAX11410_SELFTEST_TC_2 1
#endif

//--------------------------------------------------
// When user presses button BUTTON1, perform self test
#if HAS_BUTTON1_DEMO_INTERRUPT
void onButton1FallingEdge(void)
{
    void SelfTest(CmdLine & cmdLine);
    SelfTest(cmdLine_serial);
}
#endif // HAS_BUTTON1_DEMO_INTERRUPT

//--------------------------------------------------
// When user presses button BUTTON2, perform demo configuration
#if HAS_BUTTON2_DEMO_INTERRUPT
void onButton2FallingEdge(void)
{
    // TBD demo configuration
    // CODE GENERATOR: example code: has no member function Configure_Demo
    // TODO diagnostic LED
    led1 = LED_OFF; led2 = LED_OFF; led3 = LED_ON;     // diagnostic rbg led BLUE
}
#endif // HAS_BUTTON2_DEMO_INTERRUPT

//--------------------------------------------------
void SelfTest(CmdLine & cmdLine)
{
    //--------------------------------------------------
#if analogIn4_IS_HIGH_RANGE_OF_analogIn0
    // Platform board uses AIN4,AIN5,.. as high range of AIN0,AIN1,..
    MaximTinyTester tinyTester(cmdLine, analogIn4, analogIn5, analogIn2, analogIn3, analogIn0, analogIn4, led1_RFailLED, led2_GPassLED, led3_BBusyLED);
    tinyTester.analogInPin_fullScaleVoltage[0] = analogInPin_fullScaleVoltage[4]; // board support
    tinyTester.analogInPin_fullScaleVoltage[1] = analogInPin_fullScaleVoltage[5]; // board support
    tinyTester.analogInPin_fullScaleVoltage[2] = analogInPin_fullScaleVoltage[2]; // board support
    tinyTester.analogInPin_fullScaleVoltage[3] = analogInPin_fullScaleVoltage[3]; // board support
    tinyTester.analogInPin_fullScaleVoltage[4] = analogInPin_fullScaleVoltage[0]; // board support
    tinyTester.analogInPin_fullScaleVoltage[5] = analogInPin_fullScaleVoltage[1]; // board support
    // low range channels AIN0, AIN1, AIN2, AIN3
#else // analogIn4_IS_HIGH_RANGE_OF_analogIn0
    // Platform board uses simple analog inputs
    MaximTinyTester tinyTester(cmdLine, analogIn0, analogIn1, analogIn2, analogIn3, analogIn4, analogIn5, led1_RFailLED, led2_GPassLED, led3_BBusyLED);
    tinyTester.analogInPin_fullScaleVoltage[0] = analogInPin_fullScaleVoltage[0]; // board support
    tinyTester.analogInPin_fullScaleVoltage[1] = analogInPin_fullScaleVoltage[1]; // board support
    tinyTester.analogInPin_fullScaleVoltage[2] = analogInPin_fullScaleVoltage[2]; // board support
    tinyTester.analogInPin_fullScaleVoltage[3] = analogInPin_fullScaleVoltage[3]; // board support
    tinyTester.analogInPin_fullScaleVoltage[4] = analogInPin_fullScaleVoltage[4]; // board support
    tinyTester.analogInPin_fullScaleVoltage[5] = analogInPin_fullScaleVoltage[5]; // board support
#endif
    tinyTester.clear();

    // CODE GENERATOR: generate SelfTest based on function docstrings @test lines

    // @test Init() expect 1
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['action'] = 'Init() expect 1'
    // docTest_item['funcName'] = 'Init'
    // docTest_item['expect-value'] = '1'
    // call-function
    // ASSERT_EQ(g_MAX11410_device.Init(()), (uint8_t)1); // 
    tinyTester.FunctionCall_su_Expect("MAX11410.Init", fn_MAX11410_Init, /* empty docTest_argList */ /* expect: */ (uint8_t)1); // 

    // @test group POR // verify initial register values
    // @test group PORverbose // verify initial register values
    // @test group PORverbose tinyTester.print("PART_ID value")
    // docTest_item['actionType'] = 'print-string'
    // docTest_item['group-id-value'] = 'PORverbose'
    // docTest_item['action'] = 'tinyTester.print("PART_ID value")'
    // docTest_item['arglist'] = 'PART_ID value'
#if MAX11410_SELFTEST_PORverbose // group PORverbose None 
    // print-string
    // tinyTesterFuncName = "tinyTester.print"
    // tinyTesterPrintStringLiteral = "PART_ID value"
    tinyTester.print("PART_ID value");
#endif // MAX11410_SELFTEST_PORverbose // group PORverbose

    // @test group POR RegRead(MAX11410::CMD_r001_0001_xxxx_xxxx_xxxx_xxxx_xxxx_xddd_PART_ID, buffer) expect 1 expect-buffer 0x000F02
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'POR'
    // docTest_item['action'] = 'RegRead(MAX11410::CMD_r001_0001_xxxx_xxxx_xxxx_xxxx_xxxx_xddd_PART_ID, buffer) expect 1 expect-buffer 0x000F02'
    // docTest_item['funcName'] = 'RegRead'
    // docTest_item['arglist'] = 'MAX11410::CMD_r001_0001_xxxx_xxxx_xxxx_xxxx_xxxx_xddd_PART_ID, buffer'
    // docTest_item['expect-value'] = '1'
    // docTest_item['expect-buffer-value'] = '0x000F02'
#if MAX11410_SELFTEST_POR // group POR RegRead 
    // call-function
    // ASSERT_EQ(g_MAX11410_device.RegRead((MAX11410::MAX11410_CMD_enum_t)MAX11410::CMD_r001_0001_xxxx_xxxx_xxxx_xxxx_xxxx_xddd_PART_ID, (uint32_t*)buffer), (uint8_t)1); // 
    { // expect-buffer 0x000F02
        uint32_t buffer = 1234; // expect-buffer initial value
        //
        tinyTester.FunctionCall_su_d_plu_Expect("MAX11410.RegRead", fn_MAX11410_RegRead, (MAX11410::MAX11410_CMD_enum_t)MAX11410::CMD_r001_0001_xxxx_xxxx_xxxx_xxxx_xxxx_xddd_PART_ID, &buffer, /* expect: */ (uint8_t)1, /* expect-buffer: */ 0x000F02); // 
    } // expect-buffer 0x000F02
#endif // MAX11410_SELFTEST_POR // group POR

    // @test group PORverbose tinyTester.print("POR value 0x04 CMD_r000_0100_dddd_xddd_GP0_CTRL")
    // docTest_item['actionType'] = 'print-string'
    // docTest_item['group-id-value'] = 'PORverbose'
    // docTest_item['action'] = 'tinyTester.print("POR value 0x04 CMD_r000_0100_dddd_xddd_GP0_CTRL")'
    // docTest_item['arglist'] = 'POR value 0x04 CMD_r000_0100_dddd_xddd_GP0_CTRL'
#if MAX11410_SELFTEST_PORverbose // group PORverbose None 
    // print-string
    // tinyTesterFuncName = "tinyTester.print"
    // tinyTesterPrintStringLiteral = "POR value 0x04 CMD_r000_0100_dddd_xddd_GP0_CTRL"
    tinyTester.print("POR value 0x04 CMD_r000_0100_dddd_xddd_GP0_CTRL");
#endif // MAX11410_SELFTEST_PORverbose // group PORverbose

    // @test group POR RegRead(MAX11410::CMD_r000_0100_dddd_xddd_GP0_CTRL, buffer) expect 1 expect-buffer 0x00
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'POR'
    // docTest_item['action'] = 'RegRead(MAX11410::CMD_r000_0100_dddd_xddd_GP0_CTRL, buffer) expect 1 expect-buffer 0x00'
    // docTest_item['funcName'] = 'RegRead'
    // docTest_item['arglist'] = 'MAX11410::CMD_r000_0100_dddd_xddd_GP0_CTRL, buffer'
    // docTest_item['expect-value'] = '1'
    // docTest_item['expect-buffer-value'] = '0x00'
#if MAX11410_SELFTEST_POR // group POR RegRead 
    // call-function
    // ASSERT_EQ(g_MAX11410_device.RegRead((MAX11410::MAX11410_CMD_enum_t)MAX11410::CMD_r000_0100_dddd_xddd_GP0_CTRL, (uint32_t*)buffer), (uint8_t)1); // 
    { // expect-buffer 0x00
        uint32_t buffer = 1234; // expect-buffer initial value
        //
        tinyTester.FunctionCall_su_d_plu_Expect("MAX11410.RegRead", fn_MAX11410_RegRead, (MAX11410::MAX11410_CMD_enum_t)MAX11410::CMD_r000_0100_dddd_xddd_GP0_CTRL, &buffer, /* expect: */ (uint8_t)1, /* expect-buffer: */ 0x00); // 
    } // expect-buffer 0x00
#endif // MAX11410_SELFTEST_POR // group POR

    // @test group PORverbose tinyTester.print("POR value 0x05 CMD_r000_0101_dddd_xddd_GP1_CTRL")
    // docTest_item['actionType'] = 'print-string'
    // docTest_item['group-id-value'] = 'PORverbose'
    // docTest_item['action'] = 'tinyTester.print("POR value 0x05 CMD_r000_0101_dddd_xddd_GP1_CTRL")'
    // docTest_item['arglist'] = 'POR value 0x05 CMD_r000_0101_dddd_xddd_GP1_CTRL'
#if MAX11410_SELFTEST_PORverbose // group PORverbose None 
    // print-string
    // tinyTesterFuncName = "tinyTester.print"
    // tinyTesterPrintStringLiteral = "POR value 0x05 CMD_r000_0101_dddd_xddd_GP1_CTRL"
    tinyTester.print("POR value 0x05 CMD_r000_0101_dddd_xddd_GP1_CTRL");
#endif // MAX11410_SELFTEST_PORverbose // group PORverbose

    // @test group POR RegRead(MAX11410::CMD_r000_0101_dddd_xddd_GP1_CTRL, buffer) expect 1 expect-buffer 0x00
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'POR'
    // docTest_item['action'] = 'RegRead(MAX11410::CMD_r000_0101_dddd_xddd_GP1_CTRL, buffer) expect 1 expect-buffer 0x00'
    // docTest_item['funcName'] = 'RegRead'
    // docTest_item['arglist'] = 'MAX11410::CMD_r000_0101_dddd_xddd_GP1_CTRL, buffer'
    // docTest_item['expect-value'] = '1'
    // docTest_item['expect-buffer-value'] = '0x00'
#if MAX11410_SELFTEST_POR // group POR RegRead 
    // call-function
    // ASSERT_EQ(g_MAX11410_device.RegRead((MAX11410::MAX11410_CMD_enum_t)MAX11410::CMD_r000_0101_dddd_xddd_GP1_CTRL, (uint32_t*)buffer), (uint8_t)1); // 
    { // expect-buffer 0x00
        uint32_t buffer = 1234; // expect-buffer initial value
        //
        tinyTester.FunctionCall_su_d_plu_Expect("MAX11410.RegRead", fn_MAX11410_RegRead, (MAX11410::MAX11410_CMD_enum_t)MAX11410::CMD_r000_0101_dddd_xddd_GP1_CTRL, &buffer, /* expect: */ (uint8_t)1, /* expect-buffer: */ 0x00); // 
    } // expect-buffer 0x00
#endif // MAX11410_SELFTEST_POR // group POR

    // @test group PORverbose tinyTester.print("POR value 0x07 CMD_r000_0111_xddd_dddd_GP_SEQ_ADDR")
    // docTest_item['actionType'] = 'print-string'
    // docTest_item['group-id-value'] = 'PORverbose'
    // docTest_item['action'] = 'tinyTester.print("POR value 0x07 CMD_r000_0111_xddd_dddd_GP_SEQ_ADDR")'
    // docTest_item['arglist'] = 'POR value 0x07 CMD_r000_0111_xddd_dddd_GP_SEQ_ADDR'
#if MAX11410_SELFTEST_PORverbose // group PORverbose None 
    // print-string
    // tinyTesterFuncName = "tinyTester.print"
    // tinyTesterPrintStringLiteral = "POR value 0x07 CMD_r000_0111_xddd_dddd_GP_SEQ_ADDR"
    tinyTester.print("POR value 0x07 CMD_r000_0111_xddd_dddd_GP_SEQ_ADDR");
#endif // MAX11410_SELFTEST_PORverbose // group PORverbose

    // @test group POR RegRead(MAX11410::CMD_r000_0111_xddd_dddd_GP_SEQ_ADDR, buffer) expect 1 expect-buffer 0x00003a
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'POR'
    // docTest_item['action'] = 'RegRead(MAX11410::CMD_r000_0111_xddd_dddd_GP_SEQ_ADDR, buffer) expect 1 expect-buffer 0x00003a'
    // docTest_item['funcName'] = 'RegRead'
    // docTest_item['arglist'] = 'MAX11410::CMD_r000_0111_xddd_dddd_GP_SEQ_ADDR, buffer'
    // docTest_item['expect-value'] = '1'
    // docTest_item['expect-buffer-value'] = '0x00003a'
#if MAX11410_SELFTEST_POR // group POR RegRead 
    // call-function
    // ASSERT_EQ(g_MAX11410_device.RegRead((MAX11410::MAX11410_CMD_enum_t)MAX11410::CMD_r000_0111_xddd_dddd_GP_SEQ_ADDR, (uint32_t*)buffer), (uint8_t)1); // 
    { // expect-buffer 0x00003a
        uint32_t buffer = 1234; // expect-buffer initial value
        //
        tinyTester.FunctionCall_su_d_plu_Expect("MAX11410.RegRead", fn_MAX11410_RegRead, (MAX11410::MAX11410_CMD_enum_t)MAX11410::CMD_r000_0111_xddd_dddd_GP_SEQ_ADDR, &buffer, /* expect: */ (uint8_t)1, /* expect-buffer: */ 0x00003a); // 
    } // expect-buffer 0x00003a
#endif // MAX11410_SELFTEST_POR // group POR

    // @test group PORverbose tinyTester.print("POR value 0x08 CMD_r000_1000_x0dd_dddd_FILTER")
    // docTest_item['actionType'] = 'print-string'
    // docTest_item['group-id-value'] = 'PORverbose'
    // docTest_item['action'] = 'tinyTester.print("POR value 0x08 CMD_r000_1000_x0dd_dddd_FILTER")'
    // docTest_item['arglist'] = 'POR value 0x08 CMD_r000_1000_x0dd_dddd_FILTER'
#if MAX11410_SELFTEST_PORverbose // group PORverbose None 
    // print-string
    // tinyTesterFuncName = "tinyTester.print"
    // tinyTesterPrintStringLiteral = "POR value 0x08 CMD_r000_1000_x0dd_dddd_FILTER"
    tinyTester.print("POR value 0x08 CMD_r000_1000_x0dd_dddd_FILTER");
#endif // MAX11410_SELFTEST_PORverbose // group PORverbose

    // @test group POR RegRead(MAX11410::CMD_r000_1000_x0dd_dddd_FILTER, buffer) expect 1 expect-buffer 0x00
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'POR'
    // docTest_item['action'] = 'RegRead(MAX11410::CMD_r000_1000_x0dd_dddd_FILTER, buffer) expect 1 expect-buffer 0x00'
    // docTest_item['funcName'] = 'RegRead'
    // docTest_item['arglist'] = 'MAX11410::CMD_r000_1000_x0dd_dddd_FILTER, buffer'
    // docTest_item['expect-value'] = '1'
    // docTest_item['expect-buffer-value'] = '0x00'
#if MAX11410_SELFTEST_POR // group POR RegRead 
    // call-function
    // ASSERT_EQ(g_MAX11410_device.RegRead((MAX11410::MAX11410_CMD_enum_t)MAX11410::CMD_r000_1000_x0dd_dddd_FILTER, (uint32_t*)buffer), (uint8_t)1); // 
    { // expect-buffer 0x00
        uint32_t buffer = 1234; // expect-buffer initial value
        //
        tinyTester.FunctionCall_su_d_plu_Expect("MAX11410.RegRead", fn_MAX11410_RegRead, (MAX11410::MAX11410_CMD_enum_t)MAX11410::CMD_r000_1000_x0dd_dddd_FILTER, &buffer, /* expect: */ (uint8_t)1, /* expect-buffer: */ 0x00); // 
    } // expect-buffer 0x00
#endif // MAX11410_SELFTEST_POR // group POR

    // @test group PORverbose tinyTester.print("POR value 0x09 CMD_r000_1001_dddd_dddd_CTRL")
    // docTest_item['actionType'] = 'print-string'
    // docTest_item['group-id-value'] = 'PORverbose'
    // docTest_item['action'] = 'tinyTester.print("POR value 0x09 CMD_r000_1001_dddd_dddd_CTRL")'
    // docTest_item['arglist'] = 'POR value 0x09 CMD_r000_1001_dddd_dddd_CTRL'
#if MAX11410_SELFTEST_PORverbose // group PORverbose None 
    // print-string
    // tinyTesterFuncName = "tinyTester.print"
    // tinyTesterPrintStringLiteral = "POR value 0x09 CMD_r000_1001_dddd_dddd_CTRL"
    tinyTester.print("POR value 0x09 CMD_r000_1001_dddd_dddd_CTRL");
#endif // MAX11410_SELFTEST_PORverbose // group PORverbose

    // @test group POR RegRead(MAX11410::CMD_r000_1001_dddd_dddd_CTRL, buffer) expect 1 expect-buffer 0x000001
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'POR'
    // docTest_item['action'] = 'RegRead(MAX11410::CMD_r000_1001_dddd_dddd_CTRL, buffer) expect 1 expect-buffer 0x000001'
    // docTest_item['funcName'] = 'RegRead'
    // docTest_item['arglist'] = 'MAX11410::CMD_r000_1001_dddd_dddd_CTRL, buffer'
    // docTest_item['expect-value'] = '1'
    // docTest_item['expect-buffer-value'] = '0x000001'
#if MAX11410_SELFTEST_POR // group POR RegRead 
    // call-function
    // ASSERT_EQ(g_MAX11410_device.RegRead((MAX11410::MAX11410_CMD_enum_t)MAX11410::CMD_r000_1001_dddd_dddd_CTRL, (uint32_t*)buffer), (uint8_t)1); // 
    { // expect-buffer 0x000001
        uint32_t buffer = 1234; // expect-buffer initial value
        //
        tinyTester.FunctionCall_su_d_plu_Expect("MAX11410.RegRead", fn_MAX11410_RegRead, (MAX11410::MAX11410_CMD_enum_t)MAX11410::CMD_r000_1001_dddd_dddd_CTRL, &buffer, /* expect: */ (uint8_t)1, /* expect-buffer: */ 0x000001); // 
    } // expect-buffer 0x000001
#endif // MAX11410_SELFTEST_POR // group POR

    // @test group PORverbose tinyTester.print("POR value 0x0a CMD_r000_1010_dddd_dddd_SOURCE")
    // docTest_item['actionType'] = 'print-string'
    // docTest_item['group-id-value'] = 'PORverbose'
    // docTest_item['action'] = 'tinyTester.print("POR value 0x0a CMD_r000_1010_dddd_dddd_SOURCE")'
    // docTest_item['arglist'] = 'POR value 0x0a CMD_r000_1010_dddd_dddd_SOURCE'
#if MAX11410_SELFTEST_PORverbose // group PORverbose None 
    // print-string
    // tinyTesterFuncName = "tinyTester.print"
    // tinyTesterPrintStringLiteral = "POR value 0x0a CMD_r000_1010_dddd_dddd_SOURCE"
    tinyTester.print("POR value 0x0a CMD_r000_1010_dddd_dddd_SOURCE");
#endif // MAX11410_SELFTEST_PORverbose // group PORverbose

    // @test group POR RegRead(MAX11410::CMD_r000_1010_dddd_dddd_SOURCE, buffer) expect 1 expect-buffer 0x00
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'POR'
    // docTest_item['action'] = 'RegRead(MAX11410::CMD_r000_1010_dddd_dddd_SOURCE, buffer) expect 1 expect-buffer 0x00'
    // docTest_item['funcName'] = 'RegRead'
    // docTest_item['arglist'] = 'MAX11410::CMD_r000_1010_dddd_dddd_SOURCE, buffer'
    // docTest_item['expect-value'] = '1'
    // docTest_item['expect-buffer-value'] = '0x00'
#if MAX11410_SELFTEST_POR // group POR RegRead 
    // call-function
    // ASSERT_EQ(g_MAX11410_device.RegRead((MAX11410::MAX11410_CMD_enum_t)MAX11410::CMD_r000_1010_dddd_dddd_SOURCE, (uint32_t*)buffer), (uint8_t)1); // 
    { // expect-buffer 0x00
        uint32_t buffer = 1234; // expect-buffer initial value
        //
        tinyTester.FunctionCall_su_d_plu_Expect("MAX11410.RegRead", fn_MAX11410_RegRead, (MAX11410::MAX11410_CMD_enum_t)MAX11410::CMD_r000_1010_dddd_dddd_SOURCE, &buffer, /* expect: */ (uint8_t)1, /* expect-buffer: */ 0x00); // 
    } // expect-buffer 0x00
#endif // MAX11410_SELFTEST_POR // group POR

    // @test group PORverbose tinyTester.print("POR value 0x0b CMD_r000_1011_dddd_dddd_MUX_CTRL0")
    // docTest_item['actionType'] = 'print-string'
    // docTest_item['group-id-value'] = 'PORverbose'
    // docTest_item['action'] = 'tinyTester.print("POR value 0x0b CMD_r000_1011_dddd_dddd_MUX_CTRL0")'
    // docTest_item['arglist'] = 'POR value 0x0b CMD_r000_1011_dddd_dddd_MUX_CTRL0'
#if MAX11410_SELFTEST_PORverbose // group PORverbose None 
    // print-string
    // tinyTesterFuncName = "tinyTester.print"
    // tinyTesterPrintStringLiteral = "POR value 0x0b CMD_r000_1011_dddd_dddd_MUX_CTRL0"
    tinyTester.print("POR value 0x0b CMD_r000_1011_dddd_dddd_MUX_CTRL0");
#endif // MAX11410_SELFTEST_PORverbose // group PORverbose

    // @test group POR RegRead(MAX11410::CMD_r000_1011_dddd_dddd_MUX_CTRL0, buffer) expect 1 expect-buffer 0x0000ff
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'POR'
    // docTest_item['action'] = 'RegRead(MAX11410::CMD_r000_1011_dddd_dddd_MUX_CTRL0, buffer) expect 1 expect-buffer 0x0000ff'
    // docTest_item['funcName'] = 'RegRead'
    // docTest_item['arglist'] = 'MAX11410::CMD_r000_1011_dddd_dddd_MUX_CTRL0, buffer'
    // docTest_item['expect-value'] = '1'
    // docTest_item['expect-buffer-value'] = '0x0000ff'
#if MAX11410_SELFTEST_POR // group POR RegRead 
    // call-function
    // ASSERT_EQ(g_MAX11410_device.RegRead((MAX11410::MAX11410_CMD_enum_t)MAX11410::CMD_r000_1011_dddd_dddd_MUX_CTRL0, (uint32_t*)buffer), (uint8_t)1); // 
    { // expect-buffer 0x0000ff
        uint32_t buffer = 1234; // expect-buffer initial value
        //
        tinyTester.FunctionCall_su_d_plu_Expect("MAX11410.RegRead", fn_MAX11410_RegRead, (MAX11410::MAX11410_CMD_enum_t)MAX11410::CMD_r000_1011_dddd_dddd_MUX_CTRL0, &buffer, /* expect: */ (uint8_t)1, /* expect-buffer: */ 0x0000ff); // 
    } // expect-buffer 0x0000ff
#endif // MAX11410_SELFTEST_POR // group POR

    // @test group PORverbose tinyTester.print("POR value 0x0c CMD_r000_1100_dddd_dddd_MUX_CTRL1")
    // docTest_item['actionType'] = 'print-string'
    // docTest_item['group-id-value'] = 'PORverbose'
    // docTest_item['action'] = 'tinyTester.print("POR value 0x0c CMD_r000_1100_dddd_dddd_MUX_CTRL1")'
    // docTest_item['arglist'] = 'POR value 0x0c CMD_r000_1100_dddd_dddd_MUX_CTRL1'
#if MAX11410_SELFTEST_PORverbose // group PORverbose None 
    // print-string
    // tinyTesterFuncName = "tinyTester.print"
    // tinyTesterPrintStringLiteral = "POR value 0x0c CMD_r000_1100_dddd_dddd_MUX_CTRL1"
    tinyTester.print("POR value 0x0c CMD_r000_1100_dddd_dddd_MUX_CTRL1");
#endif // MAX11410_SELFTEST_PORverbose // group PORverbose

    // @test group POR RegRead(MAX11410::CMD_r000_1100_dddd_dddd_MUX_CTRL1, buffer) expect 1 expect-buffer 0x0000ff
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'POR'
    // docTest_item['action'] = 'RegRead(MAX11410::CMD_r000_1100_dddd_dddd_MUX_CTRL1, buffer) expect 1 expect-buffer 0x0000ff'
    // docTest_item['funcName'] = 'RegRead'
    // docTest_item['arglist'] = 'MAX11410::CMD_r000_1100_dddd_dddd_MUX_CTRL1, buffer'
    // docTest_item['expect-value'] = '1'
    // docTest_item['expect-buffer-value'] = '0x0000ff'
#if MAX11410_SELFTEST_POR // group POR RegRead 
    // call-function
    // ASSERT_EQ(g_MAX11410_device.RegRead((MAX11410::MAX11410_CMD_enum_t)MAX11410::CMD_r000_1100_dddd_dddd_MUX_CTRL1, (uint32_t*)buffer), (uint8_t)1); // 
    { // expect-buffer 0x0000ff
        uint32_t buffer = 1234; // expect-buffer initial value
        //
        tinyTester.FunctionCall_su_d_plu_Expect("MAX11410.RegRead", fn_MAX11410_RegRead, (MAX11410::MAX11410_CMD_enum_t)MAX11410::CMD_r000_1100_dddd_dddd_MUX_CTRL1, &buffer, /* expect: */ (uint8_t)1, /* expect-buffer: */ 0x0000ff); // 
    } // expect-buffer 0x0000ff
#endif // MAX11410_SELFTEST_POR // group POR

    // @test group PORverbose tinyTester.print("POR value 0x0d CMD_r000_1101_dddd_dddd_MUX_CTRL2")
    // docTest_item['actionType'] = 'print-string'
    // docTest_item['group-id-value'] = 'PORverbose'
    // docTest_item['action'] = 'tinyTester.print("POR value 0x0d CMD_r000_1101_dddd_dddd_MUX_CTRL2")'
    // docTest_item['arglist'] = 'POR value 0x0d CMD_r000_1101_dddd_dddd_MUX_CTRL2'
#if MAX11410_SELFTEST_PORverbose // group PORverbose None 
    // print-string
    // tinyTesterFuncName = "tinyTester.print"
    // tinyTesterPrintStringLiteral = "POR value 0x0d CMD_r000_1101_dddd_dddd_MUX_CTRL2"
    tinyTester.print("POR value 0x0d CMD_r000_1101_dddd_dddd_MUX_CTRL2");
#endif // MAX11410_SELFTEST_PORverbose // group PORverbose

    // @test group POR RegRead(MAX11410::CMD_r000_1101_dddd_dddd_MUX_CTRL2, buffer) expect 1 expect-buffer 0x00
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'POR'
    // docTest_item['action'] = 'RegRead(MAX11410::CMD_r000_1101_dddd_dddd_MUX_CTRL2, buffer) expect 1 expect-buffer 0x00'
    // docTest_item['funcName'] = 'RegRead'
    // docTest_item['arglist'] = 'MAX11410::CMD_r000_1101_dddd_dddd_MUX_CTRL2, buffer'
    // docTest_item['expect-value'] = '1'
    // docTest_item['expect-buffer-value'] = '0x00'
#if MAX11410_SELFTEST_POR // group POR RegRead 
    // call-function
    // ASSERT_EQ(g_MAX11410_device.RegRead((MAX11410::MAX11410_CMD_enum_t)MAX11410::CMD_r000_1101_dddd_dddd_MUX_CTRL2, (uint32_t*)buffer), (uint8_t)1); // 
    { // expect-buffer 0x00
        uint32_t buffer = 1234; // expect-buffer initial value
        //
        tinyTester.FunctionCall_su_d_plu_Expect("MAX11410.RegRead", fn_MAX11410_RegRead, (MAX11410::MAX11410_CMD_enum_t)MAX11410::CMD_r000_1101_dddd_dddd_MUX_CTRL2, &buffer, /* expect: */ (uint8_t)1, /* expect-buffer: */ 0x00); // 
    } // expect-buffer 0x00
#endif // MAX11410_SELFTEST_POR // group POR

    // @test group PORverbose tinyTester.print("POR value 0x0e CMD_r000_1110_00ss_0ggg_PGA")
    // docTest_item['actionType'] = 'print-string'
    // docTest_item['group-id-value'] = 'PORverbose'
    // docTest_item['action'] = 'tinyTester.print("POR value 0x0e CMD_r000_1110_00ss_0ggg_PGA")'
    // docTest_item['arglist'] = 'POR value 0x0e CMD_r000_1110_00ss_0ggg_PGA'
#if MAX11410_SELFTEST_PORverbose // group PORverbose None 
    // print-string
    // tinyTesterFuncName = "tinyTester.print"
    // tinyTesterPrintStringLiteral = "POR value 0x0e CMD_r000_1110_00ss_0ggg_PGA"
    tinyTester.print("POR value 0x0e CMD_r000_1110_00ss_0ggg_PGA");
#endif // MAX11410_SELFTEST_PORverbose // group PORverbose

    // @test group POR RegRead(MAX11410::CMD_r000_1110_00ss_0ggg_PGA, buffer) expect 1 expect-buffer 0x00
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'POR'
    // docTest_item['action'] = 'RegRead(MAX11410::CMD_r000_1110_00ss_0ggg_PGA, buffer) expect 1 expect-buffer 0x00'
    // docTest_item['funcName'] = 'RegRead'
    // docTest_item['arglist'] = 'MAX11410::CMD_r000_1110_00ss_0ggg_PGA, buffer'
    // docTest_item['expect-value'] = '1'
    // docTest_item['expect-buffer-value'] = '0x00'
#if MAX11410_SELFTEST_POR // group POR RegRead 
    // call-function
    // ASSERT_EQ(g_MAX11410_device.RegRead((MAX11410::MAX11410_CMD_enum_t)MAX11410::CMD_r000_1110_00ss_0ggg_PGA, (uint32_t*)buffer), (uint8_t)1); // 
    { // expect-buffer 0x00
        uint32_t buffer = 1234; // expect-buffer initial value
        //
        tinyTester.FunctionCall_su_d_plu_Expect("MAX11410.RegRead", fn_MAX11410_RegRead, (MAX11410::MAX11410_CMD_enum_t)MAX11410::CMD_r000_1110_00ss_0ggg_PGA, &buffer, /* expect: */ (uint8_t)1, /* expect-buffer: */ 0x00); // 
    } // expect-buffer 0x00
#endif // MAX11410_SELFTEST_POR // group POR

    // @test group RES1KA2A3TOGND // measure a 1kohm resistor between (AIN2,AIN3) and AGND to verify ref2_v (disabled by default)
    // @test group RES1KA2A3TOGNDMORE // measure a 1kohm resistor between (AIN2,AIN3) and AGND to verify ref2_v in more detail
    // @test group RES1KA2A3TOGNDMORE tinyTester.print("measure a 1kohm resistor between (AIN2,AIN3) and AGND to verify ref2_v")
    // docTest_item['actionType'] = 'print-string'
    // docTest_item['group-id-value'] = 'RES1KA2A3TOGNDMORE'
    // docTest_item['action'] = 'tinyTester.print("measure a 1kohm resistor between (AIN2,AIN3) and AGND to verify ref2_v")'
    // docTest_item['arglist'] = 'measure a 1kohm resistor between (AIN2,AIN3) and AGND to verify ref2_v'
#if MAX11410_SELFTEST_RES1KA2A3TOGNDMORE // group RES1KA2A3TOGNDMORE None 
    // print-string
    // tinyTesterFuncName = "tinyTester.print"
    // tinyTesterPrintStringLiteral = "measure a 1kohm resistor between (AIN2,AIN3) and AGND to verify ref2_v"
    tinyTester.print("measure a 1kohm resistor between (AIN2,AIN3) and AGND to verify ref2_v");
#endif // MAX11410_SELFTEST_RES1KA2A3TOGNDMORE // group RES1KA2A3TOGNDMORE

    // @test group RES1KA2A3TOGND tinyTester.settle_time_msec = 1000 // default 250
    // docTest_item['actionType'] = 'assign-propname-value'
    // docTest_item['group-id-value'] = 'RES1KA2A3TOGND'
    // docTest_item['action'] = 'tinyTester.settle_time_msec = 1000'
    // docTest_item['remarks'] = 'default 250'
    // docTest_item['propName'] = 'tinyTester.settle_time_msec'
    // docTest_item['propValue'] = '1000'
#if MAX11410_SELFTEST_RES1KA2A3TOGND // group RES1KA2A3TOGND None default 250
    // assign-propname-value
    // tinyTesterPropName = "tinyTester.settle_time_msec"
    // tinyTesterPropValue = "1000"
    tinyTester.settle_time_msec = 1000;
#endif // MAX11410_SELFTEST_RES1KA2A3TOGND // group RES1KA2A3TOGND

    // @test group RES1KA2A3TOGND RegWrite(0x0C, 0xF3) expect 1 // *mux_ctrl1=0xf3 drives current source from AIN3
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'RES1KA2A3TOGND'
    // docTest_item['action'] = 'RegWrite(0x0C, 0xF3) expect 1'
    // docTest_item['remarks'] = '*mux_ctrl1=0xf3 drives current source from AIN3'
    // docTest_item['funcName'] = 'RegWrite'
    // docTest_item['arglist'] = '0x0C, 0xF3'
    // docTest_item['expect-value'] = '1'
#if MAX11410_SELFTEST_RES1KA2A3TOGND // group RES1KA2A3TOGND RegWrite *mux_ctrl1=0xf3 drives current source from AIN3
    // call-function
    // ASSERT_EQ(g_MAX11410_device.RegWrite((MAX11410::MAX11410_CMD_enum_t)0x0C, (uint32_t)0xF3), (uint8_t)1); // *mux_ctrl1=0xf3 drives current source from AIN3
    tinyTester.FunctionCall_su_d_lu_Expect("MAX11410.RegWrite", fn_MAX11410_RegWrite, (MAX11410::MAX11410_CMD_enum_t)0x0C, (uint32_t)0xF3, /* expect: */ (uint8_t)1); // *mux_ctrl1=0xf3 drives current source from AIN3
#endif // MAX11410_SELFTEST_RES1KA2A3TOGND // group RES1KA2A3TOGND

    // @test group RES1KA2A3TOGNDMORE RegWrite(0x0A, 0x03) expect 1 // *source=0x03 idac_mode=100uA, 1k resistor 0.1V
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'RES1KA2A3TOGNDMORE'
    // docTest_item['action'] = 'RegWrite(0x0A, 0x03) expect 1'
    // docTest_item['remarks'] = '*source=0x03 idac_mode=100uA, 1k resistor 0.1V'
    // docTest_item['funcName'] = 'RegWrite'
    // docTest_item['arglist'] = '0x0A, 0x03'
    // docTest_item['expect-value'] = '1'
#if MAX11410_SELFTEST_RES1KA2A3TOGNDMORE // group RES1KA2A3TOGNDMORE RegWrite *source=0x03 idac_mode=100uA, 1k resistor 0.1V
    // call-function
    // ASSERT_EQ(g_MAX11410_device.RegWrite((MAX11410::MAX11410_CMD_enum_t)0x0A, (uint32_t)0x03), (uint8_t)1); // *source=0x03 idac_mode=100uA, 1k resistor 0.1V
    tinyTester.FunctionCall_su_d_lu_Expect("MAX11410.RegWrite", fn_MAX11410_RegWrite, (MAX11410::MAX11410_CMD_enum_t)0x0A, (uint32_t)0x03, /* expect: */ (uint8_t)1); // *source=0x03 idac_mode=100uA, 1k resistor 0.1V
#endif // MAX11410_SELFTEST_RES1KA2A3TOGNDMORE // group RES1KA2A3TOGNDMORE

    // @test group RES1KA2A3TOGNDMORE tinyTester.print("idac_mode=100uA, 1k resistor 0.1V")
    // docTest_item['actionType'] = 'print-string'
    // docTest_item['group-id-value'] = 'RES1KA2A3TOGNDMORE'
    // docTest_item['action'] = 'tinyTester.print("idac_mode=100uA, 1k resistor 0.1V")'
    // docTest_item['arglist'] = 'idac_mode=100uA, 1k resistor 0.1V'
#if MAX11410_SELFTEST_RES1KA2A3TOGNDMORE // group RES1KA2A3TOGNDMORE None 
    // print-string
    // tinyTesterFuncName = "tinyTester.print"
    // tinyTesterPrintStringLiteral = "idac_mode=100uA, 1k resistor 0.1V"
    tinyTester.print("idac_mode=100uA, 1k resistor 0.1V");
#endif // MAX11410_SELFTEST_RES1KA2A3TOGNDMORE // group RES1KA2A3TOGNDMORE

    // @test group RES1KA2A3TOGNDMORE tinyTester.Wait_Output_Settling()
    // docTest_item['actionType'] = 'call-tinytester-function'
    // docTest_item['group-id-value'] = 'RES1KA2A3TOGNDMORE'
    // docTest_item['action'] = 'tinyTester.Wait_Output_Settling()'
    // docTest_item['propName'] = 'Wait_Output_Settling'
#if MAX11410_SELFTEST_RES1KA2A3TOGNDMORE // group RES1KA2A3TOGNDMORE None 
    // call-tinytester-function
    // tinyTesterFuncName = "tinyTester.Wait_Output_Settling"
    // docTest_argList = ""
    tinyTester.Wait_Output_Settling(); // 
#endif // MAX11410_SELFTEST_RES1KA2A3TOGNDMORE // group RES1KA2A3TOGNDMORE

    // @test group RES1KA2A3TOGNDMORE Measure_Voltage(2,10) expect 0.1
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'RES1KA2A3TOGNDMORE'
    // docTest_item['action'] = 'Measure_Voltage(2,10) expect 0.1'
    // docTest_item['funcName'] = 'Measure_Voltage'
    // docTest_item['arglist'] = '2,10'
    // docTest_item['expect-value'] = '0.1'
#if MAX11410_SELFTEST_RES1KA2A3TOGNDMORE // group RES1KA2A3TOGNDMORE Measure_Voltage 
    // call-function
    // ASSERT_EQ(g_MAX11410_device.Measure_Voltage((MAX11410::MAX11410_AINP_SEL_enum_t)2, (MAX11410::MAX11410_AINN_SEL_enum_t)10), (double)0.1); // 
    tinyTester.FunctionCall_f_d_d_Expect("MAX11410.Measure_Voltage", fn_MAX11410_Measure_Voltage, (MAX11410::MAX11410_AINP_SEL_enum_t)2, (MAX11410::MAX11410_AINN_SEL_enum_t)10, /* expect: */ (double)0.1); // 
#endif // MAX11410_SELFTEST_RES1KA2A3TOGNDMORE // group RES1KA2A3TOGNDMORE

    // @test group RES1KA2A3TOGNDMORE AINcode[2] expect (uint32_t)337731 within 33773 // idac_mode=100uA, 1k resistor 0.1V
    // @test group RES1KA2A3TOGNDMORE RegWrite(0x0A, 0x0D) expect 1 // *source=0x0d idac_mode=800uA, 1k resistor 0.8V
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'RES1KA2A3TOGNDMORE'
    // docTest_item['action'] = 'RegWrite(0x0A, 0x0D) expect 1'
    // docTest_item['remarks'] = '*source=0x0d idac_mode=800uA, 1k resistor 0.8V'
    // docTest_item['funcName'] = 'RegWrite'
    // docTest_item['arglist'] = '0x0A, 0x0D'
    // docTest_item['expect-value'] = '1'
#if MAX11410_SELFTEST_RES1KA2A3TOGNDMORE // group RES1KA2A3TOGNDMORE RegWrite *source=0x0d idac_mode=800uA, 1k resistor 0.8V
    // call-function
    // ASSERT_EQ(g_MAX11410_device.RegWrite((MAX11410::MAX11410_CMD_enum_t)0x0A, (uint32_t)0x0D), (uint8_t)1); // *source=0x0d idac_mode=800uA, 1k resistor 0.8V
    tinyTester.FunctionCall_su_d_lu_Expect("MAX11410.RegWrite", fn_MAX11410_RegWrite, (MAX11410::MAX11410_CMD_enum_t)0x0A, (uint32_t)0x0D, /* expect: */ (uint8_t)1); // *source=0x0d idac_mode=800uA, 1k resistor 0.8V
#endif // MAX11410_SELFTEST_RES1KA2A3TOGNDMORE // group RES1KA2A3TOGNDMORE

    // @test group RES1KA2A3TOGNDMORE tinyTester.print("idac_mode=800uA, 1k resistor 0.8V")
    // docTest_item['actionType'] = 'print-string'
    // docTest_item['group-id-value'] = 'RES1KA2A3TOGNDMORE'
    // docTest_item['action'] = 'tinyTester.print("idac_mode=800uA, 1k resistor 0.8V")'
    // docTest_item['arglist'] = 'idac_mode=800uA, 1k resistor 0.8V'
#if MAX11410_SELFTEST_RES1KA2A3TOGNDMORE // group RES1KA2A3TOGNDMORE None 
    // print-string
    // tinyTesterFuncName = "tinyTester.print"
    // tinyTesterPrintStringLiteral = "idac_mode=800uA, 1k resistor 0.8V"
    tinyTester.print("idac_mode=800uA, 1k resistor 0.8V");
#endif // MAX11410_SELFTEST_RES1KA2A3TOGNDMORE // group RES1KA2A3TOGNDMORE

    // @test group RES1KA2A3TOGNDMORE tinyTester.Wait_Output_Settling()
    // docTest_item['actionType'] = 'call-tinytester-function'
    // docTest_item['group-id-value'] = 'RES1KA2A3TOGNDMORE'
    // docTest_item['action'] = 'tinyTester.Wait_Output_Settling()'
    // docTest_item['propName'] = 'Wait_Output_Settling'
#if MAX11410_SELFTEST_RES1KA2A3TOGNDMORE // group RES1KA2A3TOGNDMORE None 
    // call-tinytester-function
    // tinyTesterFuncName = "tinyTester.Wait_Output_Settling"
    // docTest_argList = ""
    tinyTester.Wait_Output_Settling(); // 
#endif // MAX11410_SELFTEST_RES1KA2A3TOGNDMORE // group RES1KA2A3TOGNDMORE

    // @test group RES1KA2A3TOGNDMORE Measure_Voltage(2,10) expect 0.8
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'RES1KA2A3TOGNDMORE'
    // docTest_item['action'] = 'Measure_Voltage(2,10) expect 0.8'
    // docTest_item['funcName'] = 'Measure_Voltage'
    // docTest_item['arglist'] = '2,10'
    // docTest_item['expect-value'] = '0.8'
#if MAX11410_SELFTEST_RES1KA2A3TOGNDMORE // group RES1KA2A3TOGNDMORE Measure_Voltage 
    // call-function
    // ASSERT_EQ(g_MAX11410_device.Measure_Voltage((MAX11410::MAX11410_AINP_SEL_enum_t)2, (MAX11410::MAX11410_AINN_SEL_enum_t)10), (double)0.8); // 
    tinyTester.FunctionCall_f_d_d_Expect("MAX11410.Measure_Voltage", fn_MAX11410_Measure_Voltage, (MAX11410::MAX11410_AINP_SEL_enum_t)2, (MAX11410::MAX11410_AINN_SEL_enum_t)10, /* expect: */ (double)0.8); // 
#endif // MAX11410_SELFTEST_RES1KA2A3TOGNDMORE // group RES1KA2A3TOGNDMORE

    // @test group RES1KA2A3TOGNDMORE AINcode[2] expect (uint32_t)2724467 within 33773 // idac_mode=800uA, 1k resistor 0.8V
    // @test group RES1KA2A3TOGND RegWrite(0x0A, 0x0B) expect 1 // *source=0x0b idac_mode=400uA, 1k resistor 0.4V
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'RES1KA2A3TOGND'
    // docTest_item['action'] = 'RegWrite(0x0A, 0x0B) expect 1'
    // docTest_item['remarks'] = '*source=0x0b idac_mode=400uA, 1k resistor 0.4V'
    // docTest_item['funcName'] = 'RegWrite'
    // docTest_item['arglist'] = '0x0A, 0x0B'
    // docTest_item['expect-value'] = '1'
#if MAX11410_SELFTEST_RES1KA2A3TOGND // group RES1KA2A3TOGND RegWrite *source=0x0b idac_mode=400uA, 1k resistor 0.4V
    // call-function
    // ASSERT_EQ(g_MAX11410_device.RegWrite((MAX11410::MAX11410_CMD_enum_t)0x0A, (uint32_t)0x0B), (uint8_t)1); // *source=0x0b idac_mode=400uA, 1k resistor 0.4V
    tinyTester.FunctionCall_su_d_lu_Expect("MAX11410.RegWrite", fn_MAX11410_RegWrite, (MAX11410::MAX11410_CMD_enum_t)0x0A, (uint32_t)0x0B, /* expect: */ (uint8_t)1); // *source=0x0b idac_mode=400uA, 1k resistor 0.4V
#endif // MAX11410_SELFTEST_RES1KA2A3TOGND // group RES1KA2A3TOGND

    // @test group RES1KA2A3TOGNDMORE tinyTester.print("idac_mode=400uA, 1k resistor 0.4V")
    // docTest_item['actionType'] = 'print-string'
    // docTest_item['group-id-value'] = 'RES1KA2A3TOGNDMORE'
    // docTest_item['action'] = 'tinyTester.print("idac_mode=400uA, 1k resistor 0.4V")'
    // docTest_item['arglist'] = 'idac_mode=400uA, 1k resistor 0.4V'
#if MAX11410_SELFTEST_RES1KA2A3TOGNDMORE // group RES1KA2A3TOGNDMORE None 
    // print-string
    // tinyTesterFuncName = "tinyTester.print"
    // tinyTesterPrintStringLiteral = "idac_mode=400uA, 1k resistor 0.4V"
    tinyTester.print("idac_mode=400uA, 1k resistor 0.4V");
#endif // MAX11410_SELFTEST_RES1KA2A3TOGNDMORE // group RES1KA2A3TOGNDMORE

    // @test group RES1KA2A3TOGND tinyTester.Wait_Output_Settling()
    // docTest_item['actionType'] = 'call-tinytester-function'
    // docTest_item['group-id-value'] = 'RES1KA2A3TOGND'
    // docTest_item['action'] = 'tinyTester.Wait_Output_Settling()'
    // docTest_item['propName'] = 'Wait_Output_Settling'
#if MAX11410_SELFTEST_RES1KA2A3TOGND // group RES1KA2A3TOGND None 
    // call-tinytester-function
    // tinyTesterFuncName = "tinyTester.Wait_Output_Settling"
    // docTest_argList = ""
    tinyTester.Wait_Output_Settling(); // 
#endif // MAX11410_SELFTEST_RES1KA2A3TOGND // group RES1KA2A3TOGND

    // @test group RES1KA2A3TOGND Measure_Voltage(2,10) expect 0.4
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'RES1KA2A3TOGND'
    // docTest_item['action'] = 'Measure_Voltage(2,10) expect 0.4'
    // docTest_item['funcName'] = 'Measure_Voltage'
    // docTest_item['arglist'] = '2,10'
    // docTest_item['expect-value'] = '0.4'
#if MAX11410_SELFTEST_RES1KA2A3TOGND // group RES1KA2A3TOGND Measure_Voltage 
    // call-function
    // ASSERT_EQ(g_MAX11410_device.Measure_Voltage((MAX11410::MAX11410_AINP_SEL_enum_t)2, (MAX11410::MAX11410_AINN_SEL_enum_t)10), (double)0.4); // 
    tinyTester.FunctionCall_f_d_d_Expect("MAX11410.Measure_Voltage", fn_MAX11410_Measure_Voltage, (MAX11410::MAX11410_AINP_SEL_enum_t)2, (MAX11410::MAX11410_AINN_SEL_enum_t)10, /* expect: */ (double)0.4); // 
#endif // MAX11410_SELFTEST_RES1KA2A3TOGND // group RES1KA2A3TOGND

    // @test group RES1KA2A3TOGNDMORE AINcode[2] expect (uint32_t)1343163 within 33773 // idac_mode=400uA, 1k resistor 0.4V
    // @test tinyTester.print("check filter register is writeable")
    // docTest_item['actionType'] = 'print-string'
    // docTest_item['action'] = 'tinyTester.print("check filter register is writeable")'
    // docTest_item['arglist'] = 'check filter register is writeable'
    // print-string
    // tinyTesterFuncName = "tinyTester.print"
    // tinyTesterPrintStringLiteral = "check filter register is writeable"
    tinyTester.print("check filter register is writeable");

    // @test RegWrite(0x08, 0x34) expect 1
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['action'] = 'RegWrite(0x08, 0x34) expect 1'
    // docTest_item['funcName'] = 'RegWrite'
    // docTest_item['arglist'] = '0x08, 0x34'
    // docTest_item['expect-value'] = '1'
    // call-function
    // ASSERT_EQ(g_MAX11410_device.RegWrite((MAX11410::MAX11410_CMD_enum_t)0x08, (uint32_t)0x34), (uint8_t)1); // 
    tinyTester.FunctionCall_su_d_lu_Expect("MAX11410.RegWrite", fn_MAX11410_RegWrite, (MAX11410::MAX11410_CMD_enum_t)0x08, (uint32_t)0x34, /* expect: */ (uint8_t)1); // 

    // @test tinyTester.print("check filter register is readable")
    // docTest_item['actionType'] = 'print-string'
    // docTest_item['action'] = 'tinyTester.print("check filter register is readable")'
    // docTest_item['arglist'] = 'check filter register is readable'
    // print-string
    // tinyTesterFuncName = "tinyTester.print"
    // tinyTesterPrintStringLiteral = "check filter register is readable"
    tinyTester.print("check filter register is readable");

    // @test RegRead(0x08, buffer) expect 1 expect-buffer 0x34
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['action'] = 'RegRead(0x08, buffer) expect 1 expect-buffer 0x34'
    // docTest_item['funcName'] = 'RegRead'
    // docTest_item['arglist'] = '0x08, buffer'
    // docTest_item['expect-value'] = '1'
    // docTest_item['expect-buffer-value'] = '0x34'
    // call-function
    // ASSERT_EQ(g_MAX11410_device.RegRead((MAX11410::MAX11410_CMD_enum_t)0x08, (uint32_t*)buffer), (uint8_t)1); // 
    { // expect-buffer 0x34
        uint32_t buffer = 1234; // expect-buffer initial value
        //
        tinyTester.FunctionCall_su_d_plu_Expect("MAX11410.RegRead", fn_MAX11410_RegRead, (MAX11410::MAX11410_CMD_enum_t)0x08, &buffer, /* expect: */ (uint8_t)1, /* expect-buffer: */ 0x34); // 
    } // expect-buffer 0x34

    // @test tinyTester.settle_time_msec = 250 // default 250
    // docTest_item['actionType'] = 'assign-propname-value'
    // docTest_item['action'] = 'tinyTester.settle_time_msec = 250'
    // docTest_item['remarks'] = 'default 250'
    // docTest_item['propName'] = 'tinyTester.settle_time_msec'
    // docTest_item['propValue'] = '250'
    // assign-propname-value
    // tinyTesterPropName = "tinyTester.settle_time_msec"
    // tinyTesterPropValue = "250"
    tinyTester.settle_time_msec = 250;

    // @test tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
    // docTest_item['actionType'] = 'assign-propname-value'
    // docTest_item['action'] = 'tinyTester.blink_time_msec = 75'
    // docTest_item['remarks'] = 'default 75 resume hardware self test'
    // docTest_item['propName'] = 'tinyTester.blink_time_msec'
    // docTest_item['propValue'] = '75'
    // assign-propname-value
    // tinyTesterPropName = "tinyTester.blink_time_msec"
    // tinyTesterPropValue = "75"
    tinyTester.blink_time_msec = 75;

    // @test tinyTester.input_timeout_time_msec = 250 // default 250
    // docTest_item['actionType'] = 'assign-propname-value'
    // docTest_item['action'] = 'tinyTester.input_timeout_time_msec = 250'
    // docTest_item['remarks'] = 'default 250'
    // docTest_item['propName'] = 'tinyTester.input_timeout_time_msec'
    // docTest_item['propValue'] = '250'
    // assign-propname-value
    // tinyTesterPropName = "tinyTester.input_timeout_time_msec"
    // tinyTesterPropValue = "250"
    tinyTester.input_timeout_time_msec = 250;

    // @test tinyTester.settle_time_msec = 20 // default 250
    // docTest_item['actionType'] = 'assign-propname-value'
    // docTest_item['action'] = 'tinyTester.settle_time_msec = 20'
    // docTest_item['remarks'] = 'default 250'
    // docTest_item['propName'] = 'tinyTester.settle_time_msec'
    // docTest_item['propValue'] = '20'
    // assign-propname-value
    // tinyTesterPropName = "tinyTester.settle_time_msec"
    // tinyTesterPropValue = "20"
    tinyTester.settle_time_msec = 20;

    // @test tinyTester.blink_time_msec = 20 // quickly speed through the software verification
    // docTest_item['actionType'] = 'assign-propname-value'
    // docTest_item['action'] = 'tinyTester.blink_time_msec = 20'
    // docTest_item['remarks'] = 'quickly speed through the software verification'
    // docTest_item['propName'] = 'tinyTester.blink_time_msec'
    // docTest_item['propValue'] = '20'
    // assign-propname-value
    // tinyTesterPropName = "tinyTester.blink_time_msec"
    // tinyTesterPropValue = "20"
    tinyTester.blink_time_msec = 20;

    // @test tinyTester.input_timeout_time_msec = 100 // default 250
    // docTest_item['actionType'] = 'assign-propname-value'
    // docTest_item['action'] = 'tinyTester.input_timeout_time_msec = 100'
    // docTest_item['remarks'] = 'default 250'
    // docTest_item['propName'] = 'tinyTester.input_timeout_time_msec'
    // docTest_item['propValue'] = '100'
    // assign-propname-value
    // tinyTesterPropName = "tinyTester.input_timeout_time_msec"
    // tinyTesterPropValue = "100"
    tinyTester.input_timeout_time_msec = 100;

    // @test tinyTester.Wait_Output_Settling()
    // docTest_item['actionType'] = 'call-tinytester-function'
    // docTest_item['action'] = 'tinyTester.Wait_Output_Settling()'
    // docTest_item['propName'] = 'Wait_Output_Settling'
    // call-tinytester-function
    // tinyTesterFuncName = "tinyTester.Wait_Output_Settling"
    // docTest_argList = ""
    tinyTester.Wait_Output_Settling(); // 

    // @test group UNIPOLAR // Verify function VoltageOfCode_Unipolar
    // @test group UNIPOLAR tinyTester.blink_time_msec = 20 // quickly speed through the software verification
    // docTest_item['actionType'] = 'assign-propname-value'
    // docTest_item['group-id-value'] = 'UNIPOLAR'
    // docTest_item['action'] = 'tinyTester.blink_time_msec = 20'
    // docTest_item['remarks'] = 'quickly speed through the software verification'
    // docTest_item['propName'] = 'tinyTester.blink_time_msec'
    // docTest_item['propValue'] = '20'
#if MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR None quickly speed through the software verification
    // assign-propname-value
    // tinyTesterPropName = "tinyTester.blink_time_msec"
    // tinyTesterPropValue = "20"
    tinyTester.blink_time_msec = 20;
#endif // MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR

    // @test group UNIPOLAR Configure_CTRL_REF(2) expect 1 // These tests require REF2 = 2.500V
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'UNIPOLAR'
    // docTest_item['action'] = 'Configure_CTRL_REF(2) expect 1'
    // docTest_item['remarks'] = 'These tests require REF2 = 2.500V'
    // docTest_item['funcName'] = 'Configure_CTRL_REF'
    // docTest_item['arglist'] = '2'
    // docTest_item['expect-value'] = '1'
#if MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR Configure_CTRL_REF These tests require REF2 = 2.500V
    // call-function
    // ASSERT_EQ(g_MAX11410_device.Configure_CTRL_REF((uint8_t)2), (uint8_t)1); // These tests require REF2 = 2.500V
    tinyTester.FunctionCall_su_su_Expect("MAX11410.Configure_CTRL_REF", fn_MAX11410_Configure_CTRL_REF, (uint8_t)2, /* expect: */ (uint8_t)1); // These tests require REF2 = 2.500V
#endif // MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR

    // @test group UNIPOLAR Configure_PGA(0,0) expect 1 // These tests require PGA gain=1
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'UNIPOLAR'
    // docTest_item['action'] = 'Configure_PGA(0,0) expect 1'
    // docTest_item['remarks'] = 'These tests require PGA gain=1'
    // docTest_item['funcName'] = 'Configure_PGA'
    // docTest_item['arglist'] = '0,0'
    // docTest_item['expect-value'] = '1'
#if MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR Configure_PGA These tests require PGA gain=1
    // call-function
    // ASSERT_EQ(g_MAX11410_device.Configure_PGA((uint8_t)0, (uint8_t)0), (uint8_t)1); // These tests require PGA gain=1
    tinyTester.FunctionCall_su_su_su_Expect("MAX11410.Configure_PGA", fn_MAX11410_Configure_PGA, (uint8_t)0, (uint8_t)0, /* expect: */ (uint8_t)1); // These tests require PGA gain=1
#endif // MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR

    // @test group UNIPOLAR VoltageOfCode_Unipolar(0xFFFFFF) expect 2.500 within 0.030 // Full Scale
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'UNIPOLAR'
    // docTest_item['action'] = 'VoltageOfCode_Unipolar(0xFFFFFF) expect 2.500 within 0.030'
    // docTest_item['remarks'] = 'Full Scale'
    // docTest_item['funcName'] = 'VoltageOfCode_Unipolar'
    // docTest_item['arglist'] = '0xFFFFFF'
    // docTest_item['expect-value'] = '2.500'
    // docTest_item['within-value'] = '0.030'
#if MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR VoltageOfCode_Unipolar Full Scale
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Unipolar((uint32_t)0xFFFFFF), (double)2.500); // Full Scale
    tinyTester.err_threshold = 0.030; // within 0.030
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Unipolar", fn_MAX11410_VoltageOfCode_Unipolar, (uint32_t)0xFFFFFF, /* expect: */ (double)2.500); // Full Scale
#endif // MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR

    // @test group UNIPOLAR VoltageOfCode_Unipolar(0xFFFFFE) expect 2.500              // Full Scale
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'UNIPOLAR'
    // docTest_item['action'] = 'VoltageOfCode_Unipolar(0xFFFFFE) expect 2.500'
    // docTest_item['remarks'] = 'Full Scale'
    // docTest_item['funcName'] = 'VoltageOfCode_Unipolar'
    // docTest_item['arglist'] = '0xFFFFFE'
    // docTest_item['expect-value'] = '2.500'
#if MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR VoltageOfCode_Unipolar Full Scale
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Unipolar((uint32_t)0xFFFFFE), (double)2.500); // Full Scale
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Unipolar", fn_MAX11410_VoltageOfCode_Unipolar, (uint32_t)0xFFFFFE, /* expect: */ (double)2.500); // Full Scale
#endif // MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR

    // @test group UNIPOLAR VoltageOfCode_Unipolar(0xCCCCCC) expect 2.000              // Two Volts
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'UNIPOLAR'
    // docTest_item['action'] = 'VoltageOfCode_Unipolar(0xCCCCCC) expect 2.000'
    // docTest_item['remarks'] = 'Two Volts'
    // docTest_item['funcName'] = 'VoltageOfCode_Unipolar'
    // docTest_item['arglist'] = '0xCCCCCC'
    // docTest_item['expect-value'] = '2.000'
#if MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR VoltageOfCode_Unipolar Two Volts
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Unipolar((uint32_t)0xCCCCCC), (double)2.000); // Two Volts
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Unipolar", fn_MAX11410_VoltageOfCode_Unipolar, (uint32_t)0xCCCCCC, /* expect: */ (double)2.000); // Two Volts
#endif // MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR

    // @test group UNIPOLAR VoltageOfCode_Unipolar(0xC00000) expect 1.875              // 75% Scale
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'UNIPOLAR'
    // docTest_item['action'] = 'VoltageOfCode_Unipolar(0xC00000) expect 1.875'
    // docTest_item['remarks'] = '75% Scale'
    // docTest_item['funcName'] = 'VoltageOfCode_Unipolar'
    // docTest_item['arglist'] = '0xC00000'
    // docTest_item['expect-value'] = '1.875'
#if MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR VoltageOfCode_Unipolar 75% Scale
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Unipolar((uint32_t)0xC00000), (double)1.875); // 75% Scale
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Unipolar", fn_MAX11410_VoltageOfCode_Unipolar, (uint32_t)0xC00000, /* expect: */ (double)1.875); // 75% Scale
#endif // MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR

    // @test group UNIPOLAR VoltageOfCode_Unipolar(0x800000) expect 1.250              // Mid Scale
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'UNIPOLAR'
    // docTest_item['action'] = 'VoltageOfCode_Unipolar(0x800000) expect 1.250'
    // docTest_item['remarks'] = 'Mid Scale'
    // docTest_item['funcName'] = 'VoltageOfCode_Unipolar'
    // docTest_item['arglist'] = '0x800000'
    // docTest_item['expect-value'] = '1.250'
#if MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR VoltageOfCode_Unipolar Mid Scale
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Unipolar((uint32_t)0x800000), (double)1.250); // Mid Scale
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Unipolar", fn_MAX11410_VoltageOfCode_Unipolar, (uint32_t)0x800000, /* expect: */ (double)1.250); // Mid Scale
#endif // MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR

    // @test group UNIPOLAR VoltageOfCode_Unipolar(0x666666) expect 1.000              // One Volt
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'UNIPOLAR'
    // docTest_item['action'] = 'VoltageOfCode_Unipolar(0x666666) expect 1.000'
    // docTest_item['remarks'] = 'One Volt'
    // docTest_item['funcName'] = 'VoltageOfCode_Unipolar'
    // docTest_item['arglist'] = '0x666666'
    // docTest_item['expect-value'] = '1.000'
#if MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR VoltageOfCode_Unipolar One Volt
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Unipolar((uint32_t)0x666666), (double)1.000); // One Volt
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Unipolar", fn_MAX11410_VoltageOfCode_Unipolar, (uint32_t)0x666666, /* expect: */ (double)1.000); // One Volt
#endif // MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR

    // @test group UNIPOLAR VoltageOfCode_Unipolar(0x400000) expect 0.625              // 25% Scale
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'UNIPOLAR'
    // docTest_item['action'] = 'VoltageOfCode_Unipolar(0x400000) expect 0.625'
    // docTest_item['remarks'] = '25% Scale'
    // docTest_item['funcName'] = 'VoltageOfCode_Unipolar'
    // docTest_item['arglist'] = '0x400000'
    // docTest_item['expect-value'] = '0.625'
#if MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR VoltageOfCode_Unipolar 25% Scale
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Unipolar((uint32_t)0x400000), (double)0.625); // 25% Scale
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Unipolar", fn_MAX11410_VoltageOfCode_Unipolar, (uint32_t)0x400000, /* expect: */ (double)0.625); // 25% Scale
#endif // MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR

    // @test group UNIPOLAR VoltageOfCode_Unipolar(0x0A3D70) expect 0.100              // 100mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'UNIPOLAR'
    // docTest_item['action'] = 'VoltageOfCode_Unipolar(0x0A3D70) expect 0.100'
    // docTest_item['remarks'] = '100mV'
    // docTest_item['funcName'] = 'VoltageOfCode_Unipolar'
    // docTest_item['arglist'] = '0x0A3D70'
    // docTest_item['expect-value'] = '0.100'
#if MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR VoltageOfCode_Unipolar 100mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Unipolar((uint32_t)0x0A3D70), (double)0.100); // 100mV
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Unipolar", fn_MAX11410_VoltageOfCode_Unipolar, (uint32_t)0x0A3D70, /* expect: */ (double)0.100); // 100mV
#endif // MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR

    // @test group UNIPOLAR VoltageOfCode_Unipolar(0x000064) expect 0.000014901162     // 100 LSB
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'UNIPOLAR'
    // docTest_item['action'] = 'VoltageOfCode_Unipolar(0x000064) expect 0.000014901162'
    // docTest_item['remarks'] = '100 LSB'
    // docTest_item['funcName'] = 'VoltageOfCode_Unipolar'
    // docTest_item['arglist'] = '0x000064'
    // docTest_item['expect-value'] = '0.000014901162'
#if MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR VoltageOfCode_Unipolar 100 LSB
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Unipolar((uint32_t)0x000064), (double)0.000014901162); // 100 LSB
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Unipolar", fn_MAX11410_VoltageOfCode_Unipolar, (uint32_t)0x000064, /* expect: */ (double)0.000014901162); // 100 LSB
#endif // MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR

    // @test group UNIPOLAR VoltageOfCode_Unipolar(0x00000A) expect 0.0000014901162    // Ten LSB
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'UNIPOLAR'
    // docTest_item['action'] = 'VoltageOfCode_Unipolar(0x00000A) expect 0.0000014901162'
    // docTest_item['remarks'] = 'Ten LSB'
    // docTest_item['funcName'] = 'VoltageOfCode_Unipolar'
    // docTest_item['arglist'] = '0x00000A'
    // docTest_item['expect-value'] = '0.0000014901162'
#if MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR VoltageOfCode_Unipolar Ten LSB
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Unipolar((uint32_t)0x00000A), (double)0.0000014901162); // Ten LSB
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Unipolar", fn_MAX11410_VoltageOfCode_Unipolar, (uint32_t)0x00000A, /* expect: */ (double)0.0000014901162); // Ten LSB
#endif // MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR

    // @test group UNIPOLAR VoltageOfCode_Unipolar(0x000003) expect 0.00000044703483   // Three LSB
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'UNIPOLAR'
    // docTest_item['action'] = 'VoltageOfCode_Unipolar(0x000003) expect 0.00000044703483'
    // docTest_item['remarks'] = 'Three LSB'
    // docTest_item['funcName'] = 'VoltageOfCode_Unipolar'
    // docTest_item['arglist'] = '0x000003'
    // docTest_item['expect-value'] = '0.00000044703483'
#if MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR VoltageOfCode_Unipolar Three LSB
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Unipolar((uint32_t)0x000003), (double)0.00000044703483); // Three LSB
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Unipolar", fn_MAX11410_VoltageOfCode_Unipolar, (uint32_t)0x000003, /* expect: */ (double)0.00000044703483); // Three LSB
#endif // MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR

    // @test group UNIPOLAR VoltageOfCode_Unipolar(0x000002) expect 0.00000029802326   // Two LSB
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'UNIPOLAR'
    // docTest_item['action'] = 'VoltageOfCode_Unipolar(0x000002) expect 0.00000029802326'
    // docTest_item['remarks'] = 'Two LSB'
    // docTest_item['funcName'] = 'VoltageOfCode_Unipolar'
    // docTest_item['arglist'] = '0x000002'
    // docTest_item['expect-value'] = '0.00000029802326'
#if MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR VoltageOfCode_Unipolar Two LSB
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Unipolar((uint32_t)0x000002), (double)0.00000029802326); // Two LSB
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Unipolar", fn_MAX11410_VoltageOfCode_Unipolar, (uint32_t)0x000002, /* expect: */ (double)0.00000029802326); // Two LSB
#endif // MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR

    // @test group UNIPOLAR VoltageOfCode_Unipolar(0x000001) expect 0.00000014901162   // One LSB
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'UNIPOLAR'
    // docTest_item['action'] = 'VoltageOfCode_Unipolar(0x000001) expect 0.00000014901162'
    // docTest_item['remarks'] = 'One LSB'
    // docTest_item['funcName'] = 'VoltageOfCode_Unipolar'
    // docTest_item['arglist'] = '0x000001'
    // docTest_item['expect-value'] = '0.00000014901162'
#if MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR VoltageOfCode_Unipolar One LSB
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Unipolar((uint32_t)0x000001), (double)0.00000014901162); // One LSB
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Unipolar", fn_MAX11410_VoltageOfCode_Unipolar, (uint32_t)0x000001, /* expect: */ (double)0.00000014901162); // One LSB
#endif // MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR

    // @test group UNIPOLAR VoltageOfCode_Unipolar(0x000000) expect 0.0                // Zero Scale
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'UNIPOLAR'
    // docTest_item['action'] = 'VoltageOfCode_Unipolar(0x000000) expect 0.0'
    // docTest_item['remarks'] = 'Zero Scale'
    // docTest_item['funcName'] = 'VoltageOfCode_Unipolar'
    // docTest_item['arglist'] = '0x000000'
    // docTest_item['expect-value'] = '0.0'
#if MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR VoltageOfCode_Unipolar Zero Scale
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Unipolar((uint32_t)0x000000), (double)0.0); // Zero Scale
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Unipolar", fn_MAX11410_VoltageOfCode_Unipolar, (uint32_t)0x000000, /* expect: */ (double)0.0); // Zero Scale
#endif // MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR

    // @test group UNIPOLAR tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
    // docTest_item['actionType'] = 'assign-propname-value'
    // docTest_item['group-id-value'] = 'UNIPOLAR'
    // docTest_item['action'] = 'tinyTester.blink_time_msec = 75'
    // docTest_item['remarks'] = 'default 75 resume hardware self test'
    // docTest_item['propName'] = 'tinyTester.blink_time_msec'
    // docTest_item['propValue'] = '75'
#if MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR None default 75 resume hardware self test
    // assign-propname-value
    // tinyTesterPropName = "tinyTester.blink_time_msec"
    // tinyTesterPropValue = "75"
    tinyTester.blink_time_msec = 75;
#endif // MAX11410_SELFTEST_UNIPOLAR // group UNIPOLAR

    // @test group BIPOB // Verify function VoltageOfCode_Bipolar_OffsetBinary
    // @test group BIPOB tinyTester.blink_time_msec = 20 // quickly speed through the software verification
    // docTest_item['actionType'] = 'assign-propname-value'
    // docTest_item['group-id-value'] = 'BIPOB'
    // docTest_item['action'] = 'tinyTester.blink_time_msec = 20'
    // docTest_item['remarks'] = 'quickly speed through the software verification'
    // docTest_item['propName'] = 'tinyTester.blink_time_msec'
    // docTest_item['propValue'] = '20'
#if MAX11410_SELFTEST_BIPOB // group BIPOB None quickly speed through the software verification
    // assign-propname-value
    // tinyTesterPropName = "tinyTester.blink_time_msec"
    // tinyTesterPropValue = "20"
    tinyTester.blink_time_msec = 20;
#endif // MAX11410_SELFTEST_BIPOB // group BIPOB

    // @test group BIPOB Configure_CTRL_REF(2) expect 1 // These tests require REF2 = 2.500V
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIPOB'
    // docTest_item['action'] = 'Configure_CTRL_REF(2) expect 1'
    // docTest_item['remarks'] = 'These tests require REF2 = 2.500V'
    // docTest_item['funcName'] = 'Configure_CTRL_REF'
    // docTest_item['arglist'] = '2'
    // docTest_item['expect-value'] = '1'
#if MAX11410_SELFTEST_BIPOB // group BIPOB Configure_CTRL_REF These tests require REF2 = 2.500V
    // call-function
    // ASSERT_EQ(g_MAX11410_device.Configure_CTRL_REF((uint8_t)2), (uint8_t)1); // These tests require REF2 = 2.500V
    tinyTester.FunctionCall_su_su_Expect("MAX11410.Configure_CTRL_REF", fn_MAX11410_Configure_CTRL_REF, (uint8_t)2, /* expect: */ (uint8_t)1); // These tests require REF2 = 2.500V
#endif // MAX11410_SELFTEST_BIPOB // group BIPOB

    // @test group BIPOB Configure_PGA(0,0) expect 1 // These tests require PGA gain=1
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIPOB'
    // docTest_item['action'] = 'Configure_PGA(0,0) expect 1'
    // docTest_item['remarks'] = 'These tests require PGA gain=1'
    // docTest_item['funcName'] = 'Configure_PGA'
    // docTest_item['arglist'] = '0,0'
    // docTest_item['expect-value'] = '1'
#if MAX11410_SELFTEST_BIPOB // group BIPOB Configure_PGA These tests require PGA gain=1
    // call-function
    // ASSERT_EQ(g_MAX11410_device.Configure_PGA((uint8_t)0, (uint8_t)0), (uint8_t)1); // These tests require PGA gain=1
    tinyTester.FunctionCall_su_su_su_Expect("MAX11410.Configure_PGA", fn_MAX11410_Configure_PGA, (uint8_t)0, (uint8_t)0, /* expect: */ (uint8_t)1); // These tests require PGA gain=1
#endif // MAX11410_SELFTEST_BIPOB // group BIPOB

    // @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0xFFFFFF) expect 2.5 within 0.030  // Full Scale
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIPOB'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_OffsetBinary(0xFFFFFF) expect 2.5 within 0.030'
    // docTest_item['remarks'] = 'Full Scale'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_OffsetBinary'
    // docTest_item['arglist'] = '0xFFFFFF'
    // docTest_item['expect-value'] = '2.5'
    // docTest_item['within-value'] = '0.030'
#if MAX11410_SELFTEST_BIPOB // group BIPOB VoltageOfCode_Bipolar_OffsetBinary Full Scale
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_OffsetBinary((uint32_t)0xFFFFFF), (double)2.5); // Full Scale
    tinyTester.err_threshold = 0.030; // within 0.030
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_OffsetBinary", fn_MAX11410_VoltageOfCode_Bipolar_OffsetBinary, (uint32_t)0xFFFFFF, /* expect: */ (double)2.5); // Full Scale
#endif // MAX11410_SELFTEST_BIPOB // group BIPOB

    // @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0xFFFFFE) expect 2.5               // Full Scale
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIPOB'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_OffsetBinary(0xFFFFFE) expect 2.5'
    // docTest_item['remarks'] = 'Full Scale'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_OffsetBinary'
    // docTest_item['arglist'] = '0xFFFFFE'
    // docTest_item['expect-value'] = '2.5'
#if MAX11410_SELFTEST_BIPOB // group BIPOB VoltageOfCode_Bipolar_OffsetBinary Full Scale
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_OffsetBinary((uint32_t)0xFFFFFE), (double)2.5); // Full Scale
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_OffsetBinary", fn_MAX11410_VoltageOfCode_Bipolar_OffsetBinary, (uint32_t)0xFFFFFE, /* expect: */ (double)2.5); // Full Scale
#endif // MAX11410_SELFTEST_BIPOB // group BIPOB

    // @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0xC00000) expect 1.25              // Mid Scale
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIPOB'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_OffsetBinary(0xC00000) expect 1.25'
    // docTest_item['remarks'] = 'Mid Scale'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_OffsetBinary'
    // docTest_item['arglist'] = '0xC00000'
    // docTest_item['expect-value'] = '1.25'
#if MAX11410_SELFTEST_BIPOB // group BIPOB VoltageOfCode_Bipolar_OffsetBinary Mid Scale
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_OffsetBinary((uint32_t)0xC00000), (double)1.25); // Mid Scale
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_OffsetBinary", fn_MAX11410_VoltageOfCode_Bipolar_OffsetBinary, (uint32_t)0xC00000, /* expect: */ (double)1.25); // Mid Scale
#endif // MAX11410_SELFTEST_BIPOB // group BIPOB

    // @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0x800003) expect 0.00000894069671  // Three LSB
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIPOB'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_OffsetBinary(0x800003) expect 0.00000894069671'
    // docTest_item['remarks'] = 'Three LSB'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_OffsetBinary'
    // docTest_item['arglist'] = '0x800003'
    // docTest_item['expect-value'] = '0.00000894069671'
#if MAX11410_SELFTEST_BIPOB // group BIPOB VoltageOfCode_Bipolar_OffsetBinary Three LSB
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_OffsetBinary((uint32_t)0x800003), (double)0.00000894069671); // Three LSB
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_OffsetBinary", fn_MAX11410_VoltageOfCode_Bipolar_OffsetBinary, (uint32_t)0x800003, /* expect: */ (double)0.00000894069671); // Three LSB
#endif // MAX11410_SELFTEST_BIPOB // group BIPOB

    // @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0x800002) expect 0.00000596046447  // Two LSB
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIPOB'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_OffsetBinary(0x800002) expect 0.00000596046447'
    // docTest_item['remarks'] = 'Two LSB'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_OffsetBinary'
    // docTest_item['arglist'] = '0x800002'
    // docTest_item['expect-value'] = '0.00000596046447'
#if MAX11410_SELFTEST_BIPOB // group BIPOB VoltageOfCode_Bipolar_OffsetBinary Two LSB
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_OffsetBinary((uint32_t)0x800002), (double)0.00000596046447); // Two LSB
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_OffsetBinary", fn_MAX11410_VoltageOfCode_Bipolar_OffsetBinary, (uint32_t)0x800002, /* expect: */ (double)0.00000596046447); // Two LSB
#endif // MAX11410_SELFTEST_BIPOB // group BIPOB

    // @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0x800001) expect 0.0000029802326   // One LSB
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIPOB'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_OffsetBinary(0x800001) expect 0.0000029802326'
    // docTest_item['remarks'] = 'One LSB'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_OffsetBinary'
    // docTest_item['arglist'] = '0x800001'
    // docTest_item['expect-value'] = '0.0000029802326'
#if MAX11410_SELFTEST_BIPOB // group BIPOB VoltageOfCode_Bipolar_OffsetBinary One LSB
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_OffsetBinary((uint32_t)0x800001), (double)0.0000029802326); // One LSB
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_OffsetBinary", fn_MAX11410_VoltageOfCode_Bipolar_OffsetBinary, (uint32_t)0x800001, /* expect: */ (double)0.0000029802326); // One LSB
#endif // MAX11410_SELFTEST_BIPOB // group BIPOB

    // @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0x800000) expect 0.0               // Zero Scale
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIPOB'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_OffsetBinary(0x800000) expect 0.0'
    // docTest_item['remarks'] = 'Zero Scale'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_OffsetBinary'
    // docTest_item['arglist'] = '0x800000'
    // docTest_item['expect-value'] = '0.0'
#if MAX11410_SELFTEST_BIPOB // group BIPOB VoltageOfCode_Bipolar_OffsetBinary Zero Scale
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_OffsetBinary((uint32_t)0x800000), (double)0.0); // Zero Scale
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_OffsetBinary", fn_MAX11410_VoltageOfCode_Bipolar_OffsetBinary, (uint32_t)0x800000, /* expect: */ (double)0.0); // Zero Scale
#endif // MAX11410_SELFTEST_BIPOB // group BIPOB

    // @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0x7FFFFF) expect -0.0000029802326  // Negative One LSB
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIPOB'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_OffsetBinary(0x7FFFFF) expect -0.0000029802326'
    // docTest_item['remarks'] = 'Negative One LSB'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_OffsetBinary'
    // docTest_item['arglist'] = '0x7FFFFF'
    // docTest_item['expect-value'] = '-0.0000029802326'
#if MAX11410_SELFTEST_BIPOB // group BIPOB VoltageOfCode_Bipolar_OffsetBinary Negative One LSB
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_OffsetBinary((uint32_t)0x7FFFFF), (double)-0.0000029802326); // Negative One LSB
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_OffsetBinary", fn_MAX11410_VoltageOfCode_Bipolar_OffsetBinary, (uint32_t)0x7FFFFF, /* expect: */ (double)-0.0000029802326); // Negative One LSB
#endif // MAX11410_SELFTEST_BIPOB // group BIPOB

    // @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0x7FFFFE) expect -0.0000059604644  // Negative Two LSB
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIPOB'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_OffsetBinary(0x7FFFFE) expect -0.0000059604644'
    // docTest_item['remarks'] = 'Negative Two LSB'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_OffsetBinary'
    // docTest_item['arglist'] = '0x7FFFFE'
    // docTest_item['expect-value'] = '-0.0000059604644'
#if MAX11410_SELFTEST_BIPOB // group BIPOB VoltageOfCode_Bipolar_OffsetBinary Negative Two LSB
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_OffsetBinary((uint32_t)0x7FFFFE), (double)-0.0000059604644); // Negative Two LSB
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_OffsetBinary", fn_MAX11410_VoltageOfCode_Bipolar_OffsetBinary, (uint32_t)0x7FFFFE, /* expect: */ (double)-0.0000059604644); // Negative Two LSB
#endif // MAX11410_SELFTEST_BIPOB // group BIPOB

    // @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0x7FFFFD) expect -0.0000089406967  // Negative Three LSB
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIPOB'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_OffsetBinary(0x7FFFFD) expect -0.0000089406967'
    // docTest_item['remarks'] = 'Negative Three LSB'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_OffsetBinary'
    // docTest_item['arglist'] = '0x7FFFFD'
    // docTest_item['expect-value'] = '-0.0000089406967'
#if MAX11410_SELFTEST_BIPOB // group BIPOB VoltageOfCode_Bipolar_OffsetBinary Negative Three LSB
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_OffsetBinary((uint32_t)0x7FFFFD), (double)-0.0000089406967); // Negative Three LSB
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_OffsetBinary", fn_MAX11410_VoltageOfCode_Bipolar_OffsetBinary, (uint32_t)0x7FFFFD, /* expect: */ (double)-0.0000089406967); // Negative Three LSB
#endif // MAX11410_SELFTEST_BIPOB // group BIPOB

    // @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0x400000) expect -1.25             // Negative Mid Scale
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIPOB'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_OffsetBinary(0x400000) expect -1.25'
    // docTest_item['remarks'] = 'Negative Mid Scale'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_OffsetBinary'
    // docTest_item['arglist'] = '0x400000'
    // docTest_item['expect-value'] = '-1.25'
#if MAX11410_SELFTEST_BIPOB // group BIPOB VoltageOfCode_Bipolar_OffsetBinary Negative Mid Scale
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_OffsetBinary((uint32_t)0x400000), (double)-1.25); // Negative Mid Scale
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_OffsetBinary", fn_MAX11410_VoltageOfCode_Bipolar_OffsetBinary, (uint32_t)0x400000, /* expect: */ (double)-1.25); // Negative Mid Scale
#endif // MAX11410_SELFTEST_BIPOB // group BIPOB

    // @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0x000001) expect -2.5              // Negative Full Scale
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIPOB'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_OffsetBinary(0x000001) expect -2.5'
    // docTest_item['remarks'] = 'Negative Full Scale'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_OffsetBinary'
    // docTest_item['arglist'] = '0x000001'
    // docTest_item['expect-value'] = '-2.5'
#if MAX11410_SELFTEST_BIPOB // group BIPOB VoltageOfCode_Bipolar_OffsetBinary Negative Full Scale
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_OffsetBinary((uint32_t)0x000001), (double)-2.5); // Negative Full Scale
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_OffsetBinary", fn_MAX11410_VoltageOfCode_Bipolar_OffsetBinary, (uint32_t)0x000001, /* expect: */ (double)-2.5); // Negative Full Scale
#endif // MAX11410_SELFTEST_BIPOB // group BIPOB

    // @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0x000000) expect -2.5              // Negative Full Scale
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIPOB'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_OffsetBinary(0x000000) expect -2.5'
    // docTest_item['remarks'] = 'Negative Full Scale'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_OffsetBinary'
    // docTest_item['arglist'] = '0x000000'
    // docTest_item['expect-value'] = '-2.5'
#if MAX11410_SELFTEST_BIPOB // group BIPOB VoltageOfCode_Bipolar_OffsetBinary Negative Full Scale
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_OffsetBinary((uint32_t)0x000000), (double)-2.5); // Negative Full Scale
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_OffsetBinary", fn_MAX11410_VoltageOfCode_Bipolar_OffsetBinary, (uint32_t)0x000000, /* expect: */ (double)-2.5); // Negative Full Scale
#endif // MAX11410_SELFTEST_BIPOB // group BIPOB

    // @test group BIPOB tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
    // docTest_item['actionType'] = 'assign-propname-value'
    // docTest_item['group-id-value'] = 'BIPOB'
    // docTest_item['action'] = 'tinyTester.blink_time_msec = 75'
    // docTest_item['remarks'] = 'default 75 resume hardware self test'
    // docTest_item['propName'] = 'tinyTester.blink_time_msec'
    // docTest_item['propValue'] = '75'
#if MAX11410_SELFTEST_BIPOB // group BIPOB None default 75 resume hardware self test
    // assign-propname-value
    // tinyTesterPropName = "tinyTester.blink_time_msec"
    // tinyTesterPropValue = "75"
    tinyTester.blink_time_msec = 75;
#endif // MAX11410_SELFTEST_BIPOB // group BIPOB

    // @test group BIP2C // Verify function VoltageOfCode_Bipolar_2sComplement
    // @test group BIP2C tinyTester.blink_time_msec = 20 // quickly speed through the software verification
    // docTest_item['actionType'] = 'assign-propname-value'
    // docTest_item['group-id-value'] = 'BIP2C'
    // docTest_item['action'] = 'tinyTester.blink_time_msec = 20'
    // docTest_item['remarks'] = 'quickly speed through the software verification'
    // docTest_item['propName'] = 'tinyTester.blink_time_msec'
    // docTest_item['propValue'] = '20'
#if MAX11410_SELFTEST_BIP2C // group BIP2C None quickly speed through the software verification
    // assign-propname-value
    // tinyTesterPropName = "tinyTester.blink_time_msec"
    // tinyTesterPropValue = "20"
    tinyTester.blink_time_msec = 20;
#endif // MAX11410_SELFTEST_BIP2C // group BIP2C

    // @test group BIP2C Configure_CTRL_REF(2) expect 1 // These tests require REF2 = 2.500V
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIP2C'
    // docTest_item['action'] = 'Configure_CTRL_REF(2) expect 1'
    // docTest_item['remarks'] = 'These tests require REF2 = 2.500V'
    // docTest_item['funcName'] = 'Configure_CTRL_REF'
    // docTest_item['arglist'] = '2'
    // docTest_item['expect-value'] = '1'
#if MAX11410_SELFTEST_BIP2C // group BIP2C Configure_CTRL_REF These tests require REF2 = 2.500V
    // call-function
    // ASSERT_EQ(g_MAX11410_device.Configure_CTRL_REF((uint8_t)2), (uint8_t)1); // These tests require REF2 = 2.500V
    tinyTester.FunctionCall_su_su_Expect("MAX11410.Configure_CTRL_REF", fn_MAX11410_Configure_CTRL_REF, (uint8_t)2, /* expect: */ (uint8_t)1); // These tests require REF2 = 2.500V
#endif // MAX11410_SELFTEST_BIP2C // group BIP2C

    // @test group BIP2C Configure_PGA(0,0) expect 1 // These tests require PGA gain=1
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIP2C'
    // docTest_item['action'] = 'Configure_PGA(0,0) expect 1'
    // docTest_item['remarks'] = 'These tests require PGA gain=1'
    // docTest_item['funcName'] = 'Configure_PGA'
    // docTest_item['arglist'] = '0,0'
    // docTest_item['expect-value'] = '1'
#if MAX11410_SELFTEST_BIP2C // group BIP2C Configure_PGA These tests require PGA gain=1
    // call-function
    // ASSERT_EQ(g_MAX11410_device.Configure_PGA((uint8_t)0, (uint8_t)0), (uint8_t)1); // These tests require PGA gain=1
    tinyTester.FunctionCall_su_su_su_Expect("MAX11410.Configure_PGA", fn_MAX11410_Configure_PGA, (uint8_t)0, (uint8_t)0, /* expect: */ (uint8_t)1); // These tests require PGA gain=1
#endif // MAX11410_SELFTEST_BIP2C // group BIP2C

    // @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x7FFFFF) expect 2.500 within 0.030 // Full Scale
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIP2C'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_2sComplement(0x7FFFFF) expect 2.500 within 0.030'
    // docTest_item['remarks'] = 'Full Scale'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_2sComplement'
    // docTest_item['arglist'] = '0x7FFFFF'
    // docTest_item['expect-value'] = '2.500'
    // docTest_item['within-value'] = '0.030'
#if MAX11410_SELFTEST_BIP2C // group BIP2C VoltageOfCode_Bipolar_2sComplement Full Scale
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_2sComplement((uint32_t)0x7FFFFF), (double)2.500); // Full Scale
    tinyTester.err_threshold = 0.030; // within 0.030
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_2sComplement", fn_MAX11410_VoltageOfCode_Bipolar_2sComplement, (uint32_t)0x7FFFFF, /* expect: */ (double)2.500); // Full Scale
#endif // MAX11410_SELFTEST_BIP2C // group BIP2C

    // @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x7FFFFE) expect 2.500              // Full Scale
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIP2C'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_2sComplement(0x7FFFFE) expect 2.500'
    // docTest_item['remarks'] = 'Full Scale'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_2sComplement'
    // docTest_item['arglist'] = '0x7FFFFE'
    // docTest_item['expect-value'] = '2.500'
#if MAX11410_SELFTEST_BIP2C // group BIP2C VoltageOfCode_Bipolar_2sComplement Full Scale
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_2sComplement((uint32_t)0x7FFFFE), (double)2.500); // Full Scale
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_2sComplement", fn_MAX11410_VoltageOfCode_Bipolar_2sComplement, (uint32_t)0x7FFFFE, /* expect: */ (double)2.500); // Full Scale
#endif // MAX11410_SELFTEST_BIP2C // group BIP2C

    // @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x666666) expect 2.000              // Two Volts
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIP2C'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_2sComplement(0x666666) expect 2.000'
    // docTest_item['remarks'] = 'Two Volts'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_2sComplement'
    // docTest_item['arglist'] = '0x666666'
    // docTest_item['expect-value'] = '2.000'
#if MAX11410_SELFTEST_BIP2C // group BIP2C VoltageOfCode_Bipolar_2sComplement Two Volts
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_2sComplement((uint32_t)0x666666), (double)2.000); // Two Volts
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_2sComplement", fn_MAX11410_VoltageOfCode_Bipolar_2sComplement, (uint32_t)0x666666, /* expect: */ (double)2.000); // Two Volts
#endif // MAX11410_SELFTEST_BIP2C // group BIP2C

    // @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x600000) expect 1.875              // 75% Scale
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIP2C'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_2sComplement(0x600000) expect 1.875'
    // docTest_item['remarks'] = '75% Scale'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_2sComplement'
    // docTest_item['arglist'] = '0x600000'
    // docTest_item['expect-value'] = '1.875'
#if MAX11410_SELFTEST_BIP2C // group BIP2C VoltageOfCode_Bipolar_2sComplement 75% Scale
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_2sComplement((uint32_t)0x600000), (double)1.875); // 75% Scale
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_2sComplement", fn_MAX11410_VoltageOfCode_Bipolar_2sComplement, (uint32_t)0x600000, /* expect: */ (double)1.875); // 75% Scale
#endif // MAX11410_SELFTEST_BIP2C // group BIP2C

    // @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x400000) expect 1.250              // Mid Scale
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIP2C'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_2sComplement(0x400000) expect 1.250'
    // docTest_item['remarks'] = 'Mid Scale'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_2sComplement'
    // docTest_item['arglist'] = '0x400000'
    // docTest_item['expect-value'] = '1.250'
#if MAX11410_SELFTEST_BIP2C // group BIP2C VoltageOfCode_Bipolar_2sComplement Mid Scale
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_2sComplement((uint32_t)0x400000), (double)1.250); // Mid Scale
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_2sComplement", fn_MAX11410_VoltageOfCode_Bipolar_2sComplement, (uint32_t)0x400000, /* expect: */ (double)1.250); // Mid Scale
#endif // MAX11410_SELFTEST_BIP2C // group BIP2C

    // @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x333333) expect 1.000              // One Volt
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIP2C'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_2sComplement(0x333333) expect 1.000'
    // docTest_item['remarks'] = 'One Volt'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_2sComplement'
    // docTest_item['arglist'] = '0x333333'
    // docTest_item['expect-value'] = '1.000'
#if MAX11410_SELFTEST_BIP2C // group BIP2C VoltageOfCode_Bipolar_2sComplement One Volt
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_2sComplement((uint32_t)0x333333), (double)1.000); // One Volt
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_2sComplement", fn_MAX11410_VoltageOfCode_Bipolar_2sComplement, (uint32_t)0x333333, /* expect: */ (double)1.000); // One Volt
#endif // MAX11410_SELFTEST_BIP2C // group BIP2C

    // @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x200000) expect 0.625              // 25% Scale
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIP2C'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_2sComplement(0x200000) expect 0.625'
    // docTest_item['remarks'] = '25% Scale'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_2sComplement'
    // docTest_item['arglist'] = '0x200000'
    // docTest_item['expect-value'] = '0.625'
#if MAX11410_SELFTEST_BIP2C // group BIP2C VoltageOfCode_Bipolar_2sComplement 25% Scale
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_2sComplement((uint32_t)0x200000), (double)0.625); // 25% Scale
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_2sComplement", fn_MAX11410_VoltageOfCode_Bipolar_2sComplement, (uint32_t)0x200000, /* expect: */ (double)0.625); // 25% Scale
#endif // MAX11410_SELFTEST_BIP2C // group BIP2C

    // @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x051eb8) expect 0.100              // 100mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIP2C'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_2sComplement(0x051eb8) expect 0.100'
    // docTest_item['remarks'] = '100mV'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_2sComplement'
    // docTest_item['arglist'] = '0x051eb8'
    // docTest_item['expect-value'] = '0.100'
#if MAX11410_SELFTEST_BIP2C // group BIP2C VoltageOfCode_Bipolar_2sComplement 100mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_2sComplement((uint32_t)0x051eb8), (double)0.100); // 100mV
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_2sComplement", fn_MAX11410_VoltageOfCode_Bipolar_2sComplement, (uint32_t)0x051eb8, /* expect: */ (double)0.100); // 100mV
#endif // MAX11410_SELFTEST_BIP2C // group BIP2C

    // @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x000003) expect 0.00000894069671   // Three LSB
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIP2C'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_2sComplement(0x000003) expect 0.00000894069671'
    // docTest_item['remarks'] = 'Three LSB'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_2sComplement'
    // docTest_item['arglist'] = '0x000003'
    // docTest_item['expect-value'] = '0.00000894069671'
#if MAX11410_SELFTEST_BIP2C // group BIP2C VoltageOfCode_Bipolar_2sComplement Three LSB
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_2sComplement((uint32_t)0x000003), (double)0.00000894069671); // Three LSB
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_2sComplement", fn_MAX11410_VoltageOfCode_Bipolar_2sComplement, (uint32_t)0x000003, /* expect: */ (double)0.00000894069671); // Three LSB
#endif // MAX11410_SELFTEST_BIP2C // group BIP2C

    // @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x000002) expect 0.00000596046447   // Two LSB
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIP2C'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_2sComplement(0x000002) expect 0.00000596046447'
    // docTest_item['remarks'] = 'Two LSB'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_2sComplement'
    // docTest_item['arglist'] = '0x000002'
    // docTest_item['expect-value'] = '0.00000596046447'
#if MAX11410_SELFTEST_BIP2C // group BIP2C VoltageOfCode_Bipolar_2sComplement Two LSB
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_2sComplement((uint32_t)0x000002), (double)0.00000596046447); // Two LSB
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_2sComplement", fn_MAX11410_VoltageOfCode_Bipolar_2sComplement, (uint32_t)0x000002, /* expect: */ (double)0.00000596046447); // Two LSB
#endif // MAX11410_SELFTEST_BIP2C // group BIP2C

    // @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x000001) expect 0.0000029802326    // One LSB
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIP2C'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_2sComplement(0x000001) expect 0.0000029802326'
    // docTest_item['remarks'] = 'One LSB'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_2sComplement'
    // docTest_item['arglist'] = '0x000001'
    // docTest_item['expect-value'] = '0.0000029802326'
#if MAX11410_SELFTEST_BIP2C // group BIP2C VoltageOfCode_Bipolar_2sComplement One LSB
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_2sComplement((uint32_t)0x000001), (double)0.0000029802326); // One LSB
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_2sComplement", fn_MAX11410_VoltageOfCode_Bipolar_2sComplement, (uint32_t)0x000001, /* expect: */ (double)0.0000029802326); // One LSB
#endif // MAX11410_SELFTEST_BIP2C // group BIP2C

    // @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x000000) expect 0.0                // Zero Scale
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIP2C'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_2sComplement(0x000000) expect 0.0'
    // docTest_item['remarks'] = 'Zero Scale'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_2sComplement'
    // docTest_item['arglist'] = '0x000000'
    // docTest_item['expect-value'] = '0.0'
#if MAX11410_SELFTEST_BIP2C // group BIP2C VoltageOfCode_Bipolar_2sComplement Zero Scale
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_2sComplement((uint32_t)0x000000), (double)0.0); // Zero Scale
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_2sComplement", fn_MAX11410_VoltageOfCode_Bipolar_2sComplement, (uint32_t)0x000000, /* expect: */ (double)0.0); // Zero Scale
#endif // MAX11410_SELFTEST_BIP2C // group BIP2C

    // @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0xFFFFFF) expect -0.0000029802326   // Negative One LSB
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIP2C'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_2sComplement(0xFFFFFF) expect -0.0000029802326'
    // docTest_item['remarks'] = 'Negative One LSB'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_2sComplement'
    // docTest_item['arglist'] = '0xFFFFFF'
    // docTest_item['expect-value'] = '-0.0000029802326'
#if MAX11410_SELFTEST_BIP2C // group BIP2C VoltageOfCode_Bipolar_2sComplement Negative One LSB
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_2sComplement((uint32_t)0xFFFFFF), (double)-0.0000029802326); // Negative One LSB
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_2sComplement", fn_MAX11410_VoltageOfCode_Bipolar_2sComplement, (uint32_t)0xFFFFFF, /* expect: */ (double)-0.0000029802326); // Negative One LSB
#endif // MAX11410_SELFTEST_BIP2C // group BIP2C

    // @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0xFFFFFE) expect -0.0000059604644   // Negative Two LSB
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIP2C'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_2sComplement(0xFFFFFE) expect -0.0000059604644'
    // docTest_item['remarks'] = 'Negative Two LSB'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_2sComplement'
    // docTest_item['arglist'] = '0xFFFFFE'
    // docTest_item['expect-value'] = '-0.0000059604644'
#if MAX11410_SELFTEST_BIP2C // group BIP2C VoltageOfCode_Bipolar_2sComplement Negative Two LSB
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_2sComplement((uint32_t)0xFFFFFE), (double)-0.0000059604644); // Negative Two LSB
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_2sComplement", fn_MAX11410_VoltageOfCode_Bipolar_2sComplement, (uint32_t)0xFFFFFE, /* expect: */ (double)-0.0000059604644); // Negative Two LSB
#endif // MAX11410_SELFTEST_BIP2C // group BIP2C

    // @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0xFFFFFD) expect -0.0000089406967   // Negative Three LSB
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIP2C'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_2sComplement(0xFFFFFD) expect -0.0000089406967'
    // docTest_item['remarks'] = 'Negative Three LSB'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_2sComplement'
    // docTest_item['arglist'] = '0xFFFFFD'
    // docTest_item['expect-value'] = '-0.0000089406967'
#if MAX11410_SELFTEST_BIP2C // group BIP2C VoltageOfCode_Bipolar_2sComplement Negative Three LSB
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_2sComplement((uint32_t)0xFFFFFD), (double)-0.0000089406967); // Negative Three LSB
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_2sComplement", fn_MAX11410_VoltageOfCode_Bipolar_2sComplement, (uint32_t)0xFFFFFD, /* expect: */ (double)-0.0000089406967); // Negative Three LSB
#endif // MAX11410_SELFTEST_BIP2C // group BIP2C

    // @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0xFAE148) expect -0.100             // Negative 100mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIP2C'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_2sComplement(0xFAE148) expect -0.100'
    // docTest_item['remarks'] = 'Negative 100mV'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_2sComplement'
    // docTest_item['arglist'] = '0xFAE148'
    // docTest_item['expect-value'] = '-0.100'
#if MAX11410_SELFTEST_BIP2C // group BIP2C VoltageOfCode_Bipolar_2sComplement Negative 100mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_2sComplement((uint32_t)0xFAE148), (double)-0.100); // Negative 100mV
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_2sComplement", fn_MAX11410_VoltageOfCode_Bipolar_2sComplement, (uint32_t)0xFAE148, /* expect: */ (double)-0.100); // Negative 100mV
#endif // MAX11410_SELFTEST_BIP2C // group BIP2C

    // @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0xE00000) expect -0.625             // Negative 25% Scale
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIP2C'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_2sComplement(0xE00000) expect -0.625'
    // docTest_item['remarks'] = 'Negative 25% Scale'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_2sComplement'
    // docTest_item['arglist'] = '0xE00000'
    // docTest_item['expect-value'] = '-0.625'
#if MAX11410_SELFTEST_BIP2C // group BIP2C VoltageOfCode_Bipolar_2sComplement Negative 25% Scale
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_2sComplement((uint32_t)0xE00000), (double)-0.625); // Negative 25% Scale
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_2sComplement", fn_MAX11410_VoltageOfCode_Bipolar_2sComplement, (uint32_t)0xE00000, /* expect: */ (double)-0.625); // Negative 25% Scale
#endif // MAX11410_SELFTEST_BIP2C // group BIP2C

    // @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0xCCCCCD) expect -1.000             // Negative One Volt
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIP2C'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_2sComplement(0xCCCCCD) expect -1.000'
    // docTest_item['remarks'] = 'Negative One Volt'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_2sComplement'
    // docTest_item['arglist'] = '0xCCCCCD'
    // docTest_item['expect-value'] = '-1.000'
#if MAX11410_SELFTEST_BIP2C // group BIP2C VoltageOfCode_Bipolar_2sComplement Negative One Volt
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_2sComplement((uint32_t)0xCCCCCD), (double)-1.000); // Negative One Volt
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_2sComplement", fn_MAX11410_VoltageOfCode_Bipolar_2sComplement, (uint32_t)0xCCCCCD, /* expect: */ (double)-1.000); // Negative One Volt
#endif // MAX11410_SELFTEST_BIP2C // group BIP2C

    // @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0xC00000) expect -1.250             // Negative Mid Scale
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIP2C'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_2sComplement(0xC00000) expect -1.250'
    // docTest_item['remarks'] = 'Negative Mid Scale'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_2sComplement'
    // docTest_item['arglist'] = '0xC00000'
    // docTest_item['expect-value'] = '-1.250'
#if MAX11410_SELFTEST_BIP2C // group BIP2C VoltageOfCode_Bipolar_2sComplement Negative Mid Scale
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_2sComplement((uint32_t)0xC00000), (double)-1.250); // Negative Mid Scale
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_2sComplement", fn_MAX11410_VoltageOfCode_Bipolar_2sComplement, (uint32_t)0xC00000, /* expect: */ (double)-1.250); // Negative Mid Scale
#endif // MAX11410_SELFTEST_BIP2C // group BIP2C

    // @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0xA00000) expect -1.875             // Negative 75% Scale
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIP2C'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_2sComplement(0xA00000) expect -1.875'
    // docTest_item['remarks'] = 'Negative 75% Scale'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_2sComplement'
    // docTest_item['arglist'] = '0xA00000'
    // docTest_item['expect-value'] = '-1.875'
#if MAX11410_SELFTEST_BIP2C // group BIP2C VoltageOfCode_Bipolar_2sComplement Negative 75% Scale
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_2sComplement((uint32_t)0xA00000), (double)-1.875); // Negative 75% Scale
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_2sComplement", fn_MAX11410_VoltageOfCode_Bipolar_2sComplement, (uint32_t)0xA00000, /* expect: */ (double)-1.875); // Negative 75% Scale
#endif // MAX11410_SELFTEST_BIP2C // group BIP2C

    // @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x99999A) expect -2.000             // Negative Two Volts
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIP2C'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_2sComplement(0x99999A) expect -2.000'
    // docTest_item['remarks'] = 'Negative Two Volts'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_2sComplement'
    // docTest_item['arglist'] = '0x99999A'
    // docTest_item['expect-value'] = '-2.000'
#if MAX11410_SELFTEST_BIP2C // group BIP2C VoltageOfCode_Bipolar_2sComplement Negative Two Volts
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_2sComplement((uint32_t)0x99999A), (double)-2.000); // Negative Two Volts
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_2sComplement", fn_MAX11410_VoltageOfCode_Bipolar_2sComplement, (uint32_t)0x99999A, /* expect: */ (double)-2.000); // Negative Two Volts
#endif // MAX11410_SELFTEST_BIP2C // group BIP2C

    // @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x800001) expect -2.500             // Negative Full Scale
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIP2C'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_2sComplement(0x800001) expect -2.500'
    // docTest_item['remarks'] = 'Negative Full Scale'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_2sComplement'
    // docTest_item['arglist'] = '0x800001'
    // docTest_item['expect-value'] = '-2.500'
#if MAX11410_SELFTEST_BIP2C // group BIP2C VoltageOfCode_Bipolar_2sComplement Negative Full Scale
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_2sComplement((uint32_t)0x800001), (double)-2.500); // Negative Full Scale
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_2sComplement", fn_MAX11410_VoltageOfCode_Bipolar_2sComplement, (uint32_t)0x800001, /* expect: */ (double)-2.500); // Negative Full Scale
#endif // MAX11410_SELFTEST_BIP2C // group BIP2C

    // @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x800000) expect -2.500             // Negative Full Scale
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'BIP2C'
    // docTest_item['action'] = 'VoltageOfCode_Bipolar_2sComplement(0x800000) expect -2.500'
    // docTest_item['remarks'] = 'Negative Full Scale'
    // docTest_item['funcName'] = 'VoltageOfCode_Bipolar_2sComplement'
    // docTest_item['arglist'] = '0x800000'
    // docTest_item['expect-value'] = '-2.500'
#if MAX11410_SELFTEST_BIP2C // group BIP2C VoltageOfCode_Bipolar_2sComplement Negative Full Scale
    // call-function
    // ASSERT_EQ(g_MAX11410_device.VoltageOfCode_Bipolar_2sComplement((uint32_t)0x800000), (double)-2.500); // Negative Full Scale
    tinyTester.FunctionCall_f_lu_Expect("MAX11410.VoltageOfCode_Bipolar_2sComplement", fn_MAX11410_VoltageOfCode_Bipolar_2sComplement, (uint32_t)0x800000, /* expect: */ (double)-2.500); // Negative Full Scale
#endif // MAX11410_SELFTEST_BIP2C // group BIP2C

    // @test group BIP2C tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
    // docTest_item['actionType'] = 'assign-propname-value'
    // docTest_item['group-id-value'] = 'BIP2C'
    // docTest_item['action'] = 'tinyTester.blink_time_msec = 75'
    // docTest_item['remarks'] = 'default 75 resume hardware self test'
    // docTest_item['propName'] = 'tinyTester.blink_time_msec'
    // docTest_item['propValue'] = '75'
#if MAX11410_SELFTEST_BIP2C // group BIP2C None default 75 resume hardware self test
    // assign-propname-value
    // tinyTesterPropName = "tinyTester.blink_time_msec"
    // tinyTesterPropValue = "75"
    tinyTester.blink_time_msec = 75;
#endif // MAX11410_SELFTEST_BIP2C // group BIP2C

    // @test group RTD_PT1000 // PT1000 type Resistive Temperature Device (RTD)
    // @test group RTD_PT1000 tinyTester.blink_time_msec = 20 // quickly speed through the software verification
    // docTest_item['actionType'] = 'assign-propname-value'
    // docTest_item['group-id-value'] = 'RTD_PT1000'
    // docTest_item['action'] = 'tinyTester.blink_time_msec = 20'
    // docTest_item['remarks'] = 'quickly speed through the software verification'
    // docTest_item['propName'] = 'tinyTester.blink_time_msec'
    // docTest_item['propValue'] = '20'
#if MAX11410_SELFTEST_RTD_PT1000 // group RTD_PT1000 None quickly speed through the software verification
    // assign-propname-value
    // tinyTesterPropName = "tinyTester.blink_time_msec"
    // tinyTesterPropValue = "20"
    tinyTester.blink_time_msec = 20;
#endif // MAX11410_SELFTEST_RTD_PT1000 // group RTD_PT1000

    // @test group RTD_PT1000 TemperatureOfRTD_PT1000(842.94) expect -40.0 within 0.1 // PT-1000 RTD at -40C
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'RTD_PT1000'
    // docTest_item['action'] = 'TemperatureOfRTD_PT1000(842.94) expect -40.0 within 0.1'
    // docTest_item['remarks'] = 'PT-1000 RTD at -40C'
    // docTest_item['funcName'] = 'TemperatureOfRTD_PT1000'
    // docTest_item['arglist'] = '842.94'
    // docTest_item['expect-value'] = '-40.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_RTD_PT1000 // group RTD_PT1000 TemperatureOfRTD_PT1000 PT-1000 RTD at -40C
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfRTD_PT1000((double)842.94), (double)-40.0); // PT-1000 RTD at -40C
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfRTD_PT1000", fn_MAX11410_TemperatureOfRTD_PT1000, (double)842.94, /* expect: */ (double)-40.0); // PT-1000 RTD at -40C
#endif // MAX11410_SELFTEST_RTD_PT1000 // group RTD_PT1000

    // @test group RTD_PT1000 TemperatureOfRTD_PT1000(1000.0) expect 0.0   within 0.1 // PT-1000 RTD at 0C
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'RTD_PT1000'
    // docTest_item['action'] = 'TemperatureOfRTD_PT1000(1000.0) expect 0.0   within 0.1'
    // docTest_item['remarks'] = 'PT-1000 RTD at 0C'
    // docTest_item['funcName'] = 'TemperatureOfRTD_PT1000'
    // docTest_item['arglist'] = '1000.0'
    // docTest_item['expect-value'] = '0.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_RTD_PT1000 // group RTD_PT1000 TemperatureOfRTD_PT1000 PT-1000 RTD at 0C
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfRTD_PT1000((double)1000.0), (double)0.0); // PT-1000 RTD at 0C
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfRTD_PT1000", fn_MAX11410_TemperatureOfRTD_PT1000, (double)1000.0, /* expect: */ (double)0.0); // PT-1000 RTD at 0C
#endif // MAX11410_SELFTEST_RTD_PT1000 // group RTD_PT1000

    // @test group RTD_PT1000 TemperatureOfRTD_PT1000(1097.3) expect 25.0  within 0.1 // PT-1000 RTD at 25C
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'RTD_PT1000'
    // docTest_item['action'] = 'TemperatureOfRTD_PT1000(1097.3) expect 25.0  within 0.1'
    // docTest_item['remarks'] = 'PT-1000 RTD at 25C'
    // docTest_item['funcName'] = 'TemperatureOfRTD_PT1000'
    // docTest_item['arglist'] = '1097.3'
    // docTest_item['expect-value'] = '25.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_RTD_PT1000 // group RTD_PT1000 TemperatureOfRTD_PT1000 PT-1000 RTD at 25C
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfRTD_PT1000((double)1097.3), (double)25.0); // PT-1000 RTD at 25C
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfRTD_PT1000", fn_MAX11410_TemperatureOfRTD_PT1000, (double)1097.3, /* expect: */ (double)25.0); // PT-1000 RTD at 25C
#endif // MAX11410_SELFTEST_RTD_PT1000 // group RTD_PT1000

    // @test group RTD_PT1000 TemperatureOfRTD_PT1000(1328.1) expect 85.0  within 0.1 // PT-1000 RTD at 85C
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'RTD_PT1000'
    // docTest_item['action'] = 'TemperatureOfRTD_PT1000(1328.1) expect 85.0  within 0.1'
    // docTest_item['remarks'] = 'PT-1000 RTD at 85C'
    // docTest_item['funcName'] = 'TemperatureOfRTD_PT1000'
    // docTest_item['arglist'] = '1328.1'
    // docTest_item['expect-value'] = '85.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_RTD_PT1000 // group RTD_PT1000 TemperatureOfRTD_PT1000 PT-1000 RTD at 85C
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfRTD_PT1000((double)1328.1), (double)85.0); // PT-1000 RTD at 85C
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfRTD_PT1000", fn_MAX11410_TemperatureOfRTD_PT1000, (double)1328.1, /* expect: */ (double)85.0); // PT-1000 RTD at 85C
#endif // MAX11410_SELFTEST_RTD_PT1000 // group RTD_PT1000

    // @test group RTD_PT1000 TemperatureOfRTD_PT1000(1479.5) expect 125.0 within 0.1 // PT-1000 RTD at 125C
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'RTD_PT1000'
    // docTest_item['action'] = 'TemperatureOfRTD_PT1000(1479.5) expect 125.0 within 0.1'
    // docTest_item['remarks'] = 'PT-1000 RTD at 125C'
    // docTest_item['funcName'] = 'TemperatureOfRTD_PT1000'
    // docTest_item['arglist'] = '1479.5'
    // docTest_item['expect-value'] = '125.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_RTD_PT1000 // group RTD_PT1000 TemperatureOfRTD_PT1000 PT-1000 RTD at 125C
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfRTD_PT1000((double)1479.5), (double)125.0); // PT-1000 RTD at 125C
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfRTD_PT1000", fn_MAX11410_TemperatureOfRTD_PT1000, (double)1479.5, /* expect: */ (double)125.0); // PT-1000 RTD at 125C
#endif // MAX11410_SELFTEST_RTD_PT1000 // group RTD_PT1000

    // @test group RTD_PT1000 tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
    // docTest_item['actionType'] = 'assign-propname-value'
    // docTest_item['group-id-value'] = 'RTD_PT1000'
    // docTest_item['action'] = 'tinyTester.blink_time_msec = 75'
    // docTest_item['remarks'] = 'default 75 resume hardware self test'
    // docTest_item['propName'] = 'tinyTester.blink_time_msec'
    // docTest_item['propValue'] = '75'
#if MAX11410_SELFTEST_RTD_PT1000 // group RTD_PT1000 None default 75 resume hardware self test
    // assign-propname-value
    // tinyTesterPropName = "tinyTester.blink_time_msec"
    // tinyTesterPropValue = "75"
    tinyTester.blink_time_msec = 75;
#endif // MAX11410_SELFTEST_RTD_PT1000 // group RTD_PT1000

    // @test group RTD_PT100 // PT100 type Resistive Temperature Device (RTD)
    // @test group RTD_PT100 tinyTester.blink_time_msec = 20 // quickly speed through the software verification
    // docTest_item['actionType'] = 'assign-propname-value'
    // docTest_item['group-id-value'] = 'RTD_PT100'
    // docTest_item['action'] = 'tinyTester.blink_time_msec = 20'
    // docTest_item['remarks'] = 'quickly speed through the software verification'
    // docTest_item['propName'] = 'tinyTester.blink_time_msec'
    // docTest_item['propValue'] = '20'
#if MAX11410_SELFTEST_RTD_PT100 // group RTD_PT100 None quickly speed through the software verification
    // assign-propname-value
    // tinyTesterPropName = "tinyTester.blink_time_msec"
    // tinyTesterPropValue = "20"
    tinyTester.blink_time_msec = 20;
#endif // MAX11410_SELFTEST_RTD_PT100 // group RTD_PT100

    // @test group RTD_PT100 TemperatureOfRTD_PT100(84.294) expect -40.0 within 0.1 // PT-100 RTD at -40C
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'RTD_PT100'
    // docTest_item['action'] = 'TemperatureOfRTD_PT100(84.294) expect -40.0 within 0.1'
    // docTest_item['remarks'] = 'PT-100 RTD at -40C'
    // docTest_item['funcName'] = 'TemperatureOfRTD_PT100'
    // docTest_item['arglist'] = '84.294'
    // docTest_item['expect-value'] = '-40.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_RTD_PT100 // group RTD_PT100 TemperatureOfRTD_PT100 PT-100 RTD at -40C
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfRTD_PT100((double)84.294), (double)-40.0); // PT-100 RTD at -40C
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfRTD_PT100", fn_MAX11410_TemperatureOfRTD_PT100, (double)84.294, /* expect: */ (double)-40.0); // PT-100 RTD at -40C
#endif // MAX11410_SELFTEST_RTD_PT100 // group RTD_PT100

    // @test group RTD_PT100 TemperatureOfRTD_PT100(100.00) expect 0.0   within 0.1 // PT-100 RTD at 0C
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'RTD_PT100'
    // docTest_item['action'] = 'TemperatureOfRTD_PT100(100.00) expect 0.0   within 0.1'
    // docTest_item['remarks'] = 'PT-100 RTD at 0C'
    // docTest_item['funcName'] = 'TemperatureOfRTD_PT100'
    // docTest_item['arglist'] = '100.00'
    // docTest_item['expect-value'] = '0.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_RTD_PT100 // group RTD_PT100 TemperatureOfRTD_PT100 PT-100 RTD at 0C
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfRTD_PT100((double)100.00), (double)0.0); // PT-100 RTD at 0C
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfRTD_PT100", fn_MAX11410_TemperatureOfRTD_PT100, (double)100.00, /* expect: */ (double)0.0); // PT-100 RTD at 0C
#endif // MAX11410_SELFTEST_RTD_PT100 // group RTD_PT100

    // @test group RTD_PT100 TemperatureOfRTD_PT100(109.73) expect 25.0  within 0.1 // PT-100 RTD at 25C
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'RTD_PT100'
    // docTest_item['action'] = 'TemperatureOfRTD_PT100(109.73) expect 25.0  within 0.1'
    // docTest_item['remarks'] = 'PT-100 RTD at 25C'
    // docTest_item['funcName'] = 'TemperatureOfRTD_PT100'
    // docTest_item['arglist'] = '109.73'
    // docTest_item['expect-value'] = '25.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_RTD_PT100 // group RTD_PT100 TemperatureOfRTD_PT100 PT-100 RTD at 25C
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfRTD_PT100((double)109.73), (double)25.0); // PT-100 RTD at 25C
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfRTD_PT100", fn_MAX11410_TemperatureOfRTD_PT100, (double)109.73, /* expect: */ (double)25.0); // PT-100 RTD at 25C
#endif // MAX11410_SELFTEST_RTD_PT100 // group RTD_PT100

    // @test group RTD_PT100 TemperatureOfRTD_PT100(132.81) expect 85.0  within 0.1 // PT-100 RTD at 85C
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'RTD_PT100'
    // docTest_item['action'] = 'TemperatureOfRTD_PT100(132.81) expect 85.0  within 0.1'
    // docTest_item['remarks'] = 'PT-100 RTD at 85C'
    // docTest_item['funcName'] = 'TemperatureOfRTD_PT100'
    // docTest_item['arglist'] = '132.81'
    // docTest_item['expect-value'] = '85.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_RTD_PT100 // group RTD_PT100 TemperatureOfRTD_PT100 PT-100 RTD at 85C
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfRTD_PT100((double)132.81), (double)85.0); // PT-100 RTD at 85C
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfRTD_PT100", fn_MAX11410_TemperatureOfRTD_PT100, (double)132.81, /* expect: */ (double)85.0); // PT-100 RTD at 85C
#endif // MAX11410_SELFTEST_RTD_PT100 // group RTD_PT100

    // @test group RTD_PT100 TemperatureOfRTD_PT100(147.95) expect 125.0 within 0.1 // PT-100 RTD at 125C
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'RTD_PT100'
    // docTest_item['action'] = 'TemperatureOfRTD_PT100(147.95) expect 125.0 within 0.1'
    // docTest_item['remarks'] = 'PT-100 RTD at 125C'
    // docTest_item['funcName'] = 'TemperatureOfRTD_PT100'
    // docTest_item['arglist'] = '147.95'
    // docTest_item['expect-value'] = '125.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_RTD_PT100 // group RTD_PT100 TemperatureOfRTD_PT100 PT-100 RTD at 125C
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfRTD_PT100((double)147.95), (double)125.0); // PT-100 RTD at 125C
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfRTD_PT100", fn_MAX11410_TemperatureOfRTD_PT100, (double)147.95, /* expect: */ (double)125.0); // PT-100 RTD at 125C
#endif // MAX11410_SELFTEST_RTD_PT100 // group RTD_PT100

    // @test group RTD_PT100 tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
    // docTest_item['actionType'] = 'assign-propname-value'
    // docTest_item['group-id-value'] = 'RTD_PT100'
    // docTest_item['action'] = 'tinyTester.blink_time_msec = 75'
    // docTest_item['remarks'] = 'default 75 resume hardware self test'
    // docTest_item['propName'] = 'tinyTester.blink_time_msec'
    // docTest_item['propValue'] = '75'
#if MAX11410_SELFTEST_RTD_PT100 // group RTD_PT100 None default 75 resume hardware self test
    // assign-propname-value
    // tinyTesterPropName = "tinyTester.blink_time_msec"
    // tinyTesterPropValue = "75"
    tinyTester.blink_time_msec = 75;
#endif // MAX11410_SELFTEST_RTD_PT100 // group RTD_PT100

    // @test group RTD // Verify function TemperatureOfRTD
    // @test group RTD tinyTester.blink_time_msec = 20 // quickly speed through the software verification
    // docTest_item['actionType'] = 'assign-propname-value'
    // docTest_item['group-id-value'] = 'RTD'
    // docTest_item['action'] = 'tinyTester.blink_time_msec = 20'
    // docTest_item['remarks'] = 'quickly speed through the software verification'
    // docTest_item['propName'] = 'tinyTester.blink_time_msec'
    // docTest_item['propValue'] = '20'
#if MAX11410_SELFTEST_RTD // group RTD None quickly speed through the software verification
    // assign-propname-value
    // tinyTesterPropName = "tinyTester.blink_time_msec"
    // tinyTesterPropValue = "20"
    tinyTester.blink_time_msec = 20;
#endif // MAX11410_SELFTEST_RTD // group RTD

    // @test group RTD TemperatureOfRTD(84.294) expect -40.0 within 0.1 // PT-100 RTD at -40C
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'RTD'
    // docTest_item['action'] = 'TemperatureOfRTD(84.294) expect -40.0 within 0.1'
    // docTest_item['remarks'] = 'PT-100 RTD at -40C'
    // docTest_item['funcName'] = 'TemperatureOfRTD'
    // docTest_item['arglist'] = '84.294'
    // docTest_item['expect-value'] = '-40.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_RTD // group RTD TemperatureOfRTD PT-100 RTD at -40C
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfRTD((double)84.294), (double)-40.0); // PT-100 RTD at -40C
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfRTD", fn_MAX11410_TemperatureOfRTD, (double)84.294, /* expect: */ (double)-40.0); // PT-100 RTD at -40C
#endif // MAX11410_SELFTEST_RTD // group RTD

    // @test group RTD TemperatureOfRTD(100.00) expect 0.0   within 0.1 // PT-100 RTD at 0C
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'RTD'
    // docTest_item['action'] = 'TemperatureOfRTD(100.00) expect 0.0   within 0.1'
    // docTest_item['remarks'] = 'PT-100 RTD at 0C'
    // docTest_item['funcName'] = 'TemperatureOfRTD'
    // docTest_item['arglist'] = '100.00'
    // docTest_item['expect-value'] = '0.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_RTD // group RTD TemperatureOfRTD PT-100 RTD at 0C
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfRTD((double)100.00), (double)0.0); // PT-100 RTD at 0C
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfRTD", fn_MAX11410_TemperatureOfRTD, (double)100.00, /* expect: */ (double)0.0); // PT-100 RTD at 0C
#endif // MAX11410_SELFTEST_RTD // group RTD

    // @test group RTD TemperatureOfRTD(109.73) expect 25.0  within 0.1 // PT-100 RTD at 25C
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'RTD'
    // docTest_item['action'] = 'TemperatureOfRTD(109.73) expect 25.0  within 0.1'
    // docTest_item['remarks'] = 'PT-100 RTD at 25C'
    // docTest_item['funcName'] = 'TemperatureOfRTD'
    // docTest_item['arglist'] = '109.73'
    // docTest_item['expect-value'] = '25.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_RTD // group RTD TemperatureOfRTD PT-100 RTD at 25C
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfRTD((double)109.73), (double)25.0); // PT-100 RTD at 25C
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfRTD", fn_MAX11410_TemperatureOfRTD, (double)109.73, /* expect: */ (double)25.0); // PT-100 RTD at 25C
#endif // MAX11410_SELFTEST_RTD // group RTD

    // @test group RTD TemperatureOfRTD(132.81) expect 85.0  within 0.1 // PT-100 RTD at 85C
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'RTD'
    // docTest_item['action'] = 'TemperatureOfRTD(132.81) expect 85.0  within 0.1'
    // docTest_item['remarks'] = 'PT-100 RTD at 85C'
    // docTest_item['funcName'] = 'TemperatureOfRTD'
    // docTest_item['arglist'] = '132.81'
    // docTest_item['expect-value'] = '85.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_RTD // group RTD TemperatureOfRTD PT-100 RTD at 85C
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfRTD((double)132.81), (double)85.0); // PT-100 RTD at 85C
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfRTD", fn_MAX11410_TemperatureOfRTD, (double)132.81, /* expect: */ (double)85.0); // PT-100 RTD at 85C
#endif // MAX11410_SELFTEST_RTD // group RTD

    // @test group RTD TemperatureOfRTD(147.95) expect 125.0 within 0.1 // PT-100 RTD at 125C
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'RTD'
    // docTest_item['action'] = 'TemperatureOfRTD(147.95) expect 125.0 within 0.1'
    // docTest_item['remarks'] = 'PT-100 RTD at 125C'
    // docTest_item['funcName'] = 'TemperatureOfRTD'
    // docTest_item['arglist'] = '147.95'
    // docTest_item['expect-value'] = '125.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_RTD // group RTD TemperatureOfRTD PT-100 RTD at 125C
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfRTD((double)147.95), (double)125.0); // PT-100 RTD at 125C
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfRTD", fn_MAX11410_TemperatureOfRTD, (double)147.95, /* expect: */ (double)125.0); // PT-100 RTD at 125C
#endif // MAX11410_SELFTEST_RTD // group RTD

    // @test group RTD TemperatureOfRTD(842.94) expect -40.0 within 0.1 // PT-1000 RTD at -40C
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'RTD'
    // docTest_item['action'] = 'TemperatureOfRTD(842.94) expect -40.0 within 0.1'
    // docTest_item['remarks'] = 'PT-1000 RTD at -40C'
    // docTest_item['funcName'] = 'TemperatureOfRTD'
    // docTest_item['arglist'] = '842.94'
    // docTest_item['expect-value'] = '-40.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_RTD // group RTD TemperatureOfRTD PT-1000 RTD at -40C
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfRTD((double)842.94), (double)-40.0); // PT-1000 RTD at -40C
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfRTD", fn_MAX11410_TemperatureOfRTD, (double)842.94, /* expect: */ (double)-40.0); // PT-1000 RTD at -40C
#endif // MAX11410_SELFTEST_RTD // group RTD

    // @test group RTD TemperatureOfRTD(1000.0) expect 0.0   within 0.1 // PT-1000 RTD at 0C
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'RTD'
    // docTest_item['action'] = 'TemperatureOfRTD(1000.0) expect 0.0   within 0.1'
    // docTest_item['remarks'] = 'PT-1000 RTD at 0C'
    // docTest_item['funcName'] = 'TemperatureOfRTD'
    // docTest_item['arglist'] = '1000.0'
    // docTest_item['expect-value'] = '0.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_RTD // group RTD TemperatureOfRTD PT-1000 RTD at 0C
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfRTD((double)1000.0), (double)0.0); // PT-1000 RTD at 0C
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfRTD", fn_MAX11410_TemperatureOfRTD, (double)1000.0, /* expect: */ (double)0.0); // PT-1000 RTD at 0C
#endif // MAX11410_SELFTEST_RTD // group RTD

    // @test group RTD TemperatureOfRTD(1097.3) expect 25.0  within 0.1 // PT-1000 RTD at 25C
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'RTD'
    // docTest_item['action'] = 'TemperatureOfRTD(1097.3) expect 25.0  within 0.1'
    // docTest_item['remarks'] = 'PT-1000 RTD at 25C'
    // docTest_item['funcName'] = 'TemperatureOfRTD'
    // docTest_item['arglist'] = '1097.3'
    // docTest_item['expect-value'] = '25.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_RTD // group RTD TemperatureOfRTD PT-1000 RTD at 25C
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfRTD((double)1097.3), (double)25.0); // PT-1000 RTD at 25C
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfRTD", fn_MAX11410_TemperatureOfRTD, (double)1097.3, /* expect: */ (double)25.0); // PT-1000 RTD at 25C
#endif // MAX11410_SELFTEST_RTD // group RTD

    // @test group RTD TemperatureOfRTD(1328.1) expect 85.0  within 0.1 // PT-1000 RTD at 85C
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'RTD'
    // docTest_item['action'] = 'TemperatureOfRTD(1328.1) expect 85.0  within 0.1'
    // docTest_item['remarks'] = 'PT-1000 RTD at 85C'
    // docTest_item['funcName'] = 'TemperatureOfRTD'
    // docTest_item['arglist'] = '1328.1'
    // docTest_item['expect-value'] = '85.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_RTD // group RTD TemperatureOfRTD PT-1000 RTD at 85C
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfRTD((double)1328.1), (double)85.0); // PT-1000 RTD at 85C
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfRTD", fn_MAX11410_TemperatureOfRTD, (double)1328.1, /* expect: */ (double)85.0); // PT-1000 RTD at 85C
#endif // MAX11410_SELFTEST_RTD // group RTD

    // @test group RTD TemperatureOfRTD(1479.5) expect 125.0 within 0.1 // PT-1000 RTD at 125C
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'RTD'
    // docTest_item['action'] = 'TemperatureOfRTD(1479.5) expect 125.0 within 0.1'
    // docTest_item['remarks'] = 'PT-1000 RTD at 125C'
    // docTest_item['funcName'] = 'TemperatureOfRTD'
    // docTest_item['arglist'] = '1479.5'
    // docTest_item['expect-value'] = '125.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_RTD // group RTD TemperatureOfRTD PT-1000 RTD at 125C
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfRTD((double)1479.5), (double)125.0); // PT-1000 RTD at 125C
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfRTD", fn_MAX11410_TemperatureOfRTD, (double)1479.5, /* expect: */ (double)125.0); // PT-1000 RTD at 125C
#endif // MAX11410_SELFTEST_RTD // group RTD

    // @test group RTD tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
    // docTest_item['actionType'] = 'assign-propname-value'
    // docTest_item['group-id-value'] = 'RTD'
    // docTest_item['action'] = 'tinyTester.blink_time_msec = 75'
    // docTest_item['remarks'] = 'default 75 resume hardware self test'
    // docTest_item['propName'] = 'tinyTester.blink_time_msec'
    // docTest_item['propValue'] = '75'
#if MAX11410_SELFTEST_RTD // group RTD None default 75 resume hardware self test
    // assign-propname-value
    // tinyTesterPropName = "tinyTester.blink_time_msec"
    // tinyTesterPropValue = "75"
    tinyTester.blink_time_msec = 75;
#endif // MAX11410_SELFTEST_RTD // group RTD

    // @test group TC_1 // Verify Thermocouple function TemperatureOfTC_TypeK
    // @test group TC_2 // Verify Thermocouple function TemperatureOfTC_TypeK in more detail
    // @test group TC_1 tinyTester.blink_time_msec = 20 // quickly speed through the software verification
    // docTest_item['actionType'] = 'assign-propname-value'
    // docTest_item['group-id-value'] = 'TC_1'
    // docTest_item['action'] = 'tinyTester.blink_time_msec = 20'
    // docTest_item['remarks'] = 'quickly speed through the software verification'
    // docTest_item['propName'] = 'tinyTester.blink_time_msec'
    // docTest_item['propValue'] = '20'
#if MAX11410_SELFTEST_TC_1 // group TC_1 None quickly speed through the software verification
    // assign-propname-value
    // tinyTesterPropName = "tinyTester.blink_time_msec"
    // tinyTesterPropValue = "20"
    tinyTester.blink_time_msec = 20;
#endif // MAX11410_SELFTEST_TC_1 // group TC_1

    // @test group TC_1 TemperatureOfTC_TypeK(0.000e-3) expect  0.0    within 0.1 // TC_TypeK at   0C = 0.000mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_1'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(0.000e-3) expect  0.0    within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at   0C = 0.000mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '0.000e-3'
    // docTest_item['expect-value'] = '0.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_1 // group TC_1 TemperatureOfTC_TypeK TC_TypeK at   0C = 0.000mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)0.000e-3), (double)0.0); // TC_TypeK at   0C = 0.000mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)0.000e-3, /* expect: */ (double)0.0); // TC_TypeK at   0C = 0.000mV
#endif // MAX11410_SELFTEST_TC_1 // group TC_1

    // @test group TC_1 TemperatureOfTC_TypeK(0.039e-3) expect  1.0    within 0.1 // TC_TypeK at   1C = 0.039mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_1'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(0.039e-3) expect  1.0    within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at   1C = 0.039mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '0.039e-3'
    // docTest_item['expect-value'] = '1.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_1 // group TC_1 TemperatureOfTC_TypeK TC_TypeK at   1C = 0.039mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)0.039e-3), (double)1.0); // TC_TypeK at   1C = 0.039mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)0.039e-3, /* expect: */ (double)1.0); // TC_TypeK at   1C = 0.039mV
#endif // MAX11410_SELFTEST_TC_1 // group TC_1

    // @test group TC_1 TemperatureOfTC_TypeK(0.079e-3) expect  2.0    within 0.1 // TC_TypeK at   2C = 0.079mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_1'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(0.079e-3) expect  2.0    within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at   2C = 0.079mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '0.079e-3'
    // docTest_item['expect-value'] = '2.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_1 // group TC_1 TemperatureOfTC_TypeK TC_TypeK at   2C = 0.079mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)0.079e-3), (double)2.0); // TC_TypeK at   2C = 0.079mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)0.079e-3, /* expect: */ (double)2.0); // TC_TypeK at   2C = 0.079mV
#endif // MAX11410_SELFTEST_TC_1 // group TC_1

    // @test group TC_1 TemperatureOfTC_TypeK(0.119e-3) expect  3.0    within 0.1 // TC_TypeK at   3C = 0.119mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_1'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(0.119e-3) expect  3.0    within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at   3C = 0.119mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '0.119e-3'
    // docTest_item['expect-value'] = '3.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_1 // group TC_1 TemperatureOfTC_TypeK TC_TypeK at   3C = 0.119mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)0.119e-3), (double)3.0); // TC_TypeK at   3C = 0.119mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)0.119e-3, /* expect: */ (double)3.0); // TC_TypeK at   3C = 0.119mV
#endif // MAX11410_SELFTEST_TC_1 // group TC_1

    // @test group TC_2 TemperatureOfTC_TypeK(0.158e-3) expect  4.0     within 0.1 // TC_TypeK at   4C = 0.158mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_2'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(0.158e-3) expect  4.0     within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at   4C = 0.158mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '0.158e-3'
    // docTest_item['expect-value'] = '4.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_2 // group TC_2 TemperatureOfTC_TypeK TC_TypeK at   4C = 0.158mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)0.158e-3), (double)4.0); // TC_TypeK at   4C = 0.158mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)0.158e-3, /* expect: */ (double)4.0); // TC_TypeK at   4C = 0.158mV
#endif // MAX11410_SELFTEST_TC_2 // group TC_2

    // @test group TC_2 TemperatureOfTC_TypeK(0.198e-3) expect  5.0     within 0.1 // TC_TypeK at   5C = 0.198mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_2'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(0.198e-3) expect  5.0     within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at   5C = 0.198mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '0.198e-3'
    // docTest_item['expect-value'] = '5.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_2 // group TC_2 TemperatureOfTC_TypeK TC_TypeK at   5C = 0.198mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)0.198e-3), (double)5.0); // TC_TypeK at   5C = 0.198mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)0.198e-3, /* expect: */ (double)5.0); // TC_TypeK at   5C = 0.198mV
#endif // MAX11410_SELFTEST_TC_2 // group TC_2

    // @test group TC_2 TemperatureOfTC_TypeK(0.238e-3) expect  6.0     within 0.1 // TC_TypeK at   6C = 0.238mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_2'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(0.238e-3) expect  6.0     within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at   6C = 0.238mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '0.238e-3'
    // docTest_item['expect-value'] = '6.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_2 // group TC_2 TemperatureOfTC_TypeK TC_TypeK at   6C = 0.238mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)0.238e-3), (double)6.0); // TC_TypeK at   6C = 0.238mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)0.238e-3, /* expect: */ (double)6.0); // TC_TypeK at   6C = 0.238mV
#endif // MAX11410_SELFTEST_TC_2 // group TC_2

    // @test group TC_2 TemperatureOfTC_TypeK(0.2775e-3) expect  7.0    within 0.1 // TC_TypeK at   7C = 0.2775mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_2'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(0.2775e-3) expect  7.0    within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at   7C = 0.2775mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '0.2775e-3'
    // docTest_item['expect-value'] = '7.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_2 // group TC_2 TemperatureOfTC_TypeK TC_TypeK at   7C = 0.2775mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)0.2775e-3), (double)7.0); // TC_TypeK at   7C = 0.2775mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)0.2775e-3, /* expect: */ (double)7.0); // TC_TypeK at   7C = 0.2775mV
#endif // MAX11410_SELFTEST_TC_2 // group TC_2

    // @test group TC_2 TemperatureOfTC_TypeK(0.317e-3) expect  8.0     within 0.1 // TC_TypeK at   8C = 0.317mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_2'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(0.317e-3) expect  8.0     within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at   8C = 0.317mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '0.317e-3'
    // docTest_item['expect-value'] = '8.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_2 // group TC_2 TemperatureOfTC_TypeK TC_TypeK at   8C = 0.317mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)0.317e-3), (double)8.0); // TC_TypeK at   8C = 0.317mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)0.317e-3, /* expect: */ (double)8.0); // TC_TypeK at   8C = 0.317mV
#endif // MAX11410_SELFTEST_TC_2 // group TC_2

    // @test group TC_2 TemperatureOfTC_TypeK(0.357e-3) expect  9.0     within 0.1 // TC_TypeK at   9C = 0.357mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_2'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(0.357e-3) expect  9.0     within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at   9C = 0.357mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '0.357e-3'
    // docTest_item['expect-value'] = '9.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_2 // group TC_2 TemperatureOfTC_TypeK TC_TypeK at   9C = 0.357mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)0.357e-3), (double)9.0); // TC_TypeK at   9C = 0.357mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)0.357e-3, /* expect: */ (double)9.0); // TC_TypeK at   9C = 0.357mV
#endif // MAX11410_SELFTEST_TC_2 // group TC_2

    // @test group TC_1 TemperatureOfTC_TypeK(0.397e-3) expect 10.0    within 0.1 // TC_TypeK at  10C = 0.397mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_1'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(0.397e-3) expect 10.0    within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  10C = 0.397mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '0.397e-3'
    // docTest_item['expect-value'] = '10.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_1 // group TC_1 TemperatureOfTC_TypeK TC_TypeK at  10C = 0.397mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)0.397e-3), (double)10.0); // TC_TypeK at  10C = 0.397mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)0.397e-3, /* expect: */ (double)10.0); // TC_TypeK at  10C = 0.397mV
#endif // MAX11410_SELFTEST_TC_1 // group TC_1

    // @test group TC_1 TemperatureOfTC_TypeK(0.798e-3) expect 20.0    within 0.1 // TC_TypeK at  20C = 0.798mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_1'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(0.798e-3) expect 20.0    within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  20C = 0.798mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '0.798e-3'
    // docTest_item['expect-value'] = '20.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_1 // group TC_1 TemperatureOfTC_TypeK TC_TypeK at  20C = 0.798mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)0.798e-3), (double)20.0); // TC_TypeK at  20C = 0.798mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)0.798e-3, /* expect: */ (double)20.0); // TC_TypeK at  20C = 0.798mV
#endif // MAX11410_SELFTEST_TC_1 // group TC_1

    // @test group TC_1 TemperatureOfTC_TypeK(1.081e-3) expect 27.0    within 0.1 // TC_TypeK at  27C = 1.081mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_1'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(1.081e-3) expect 27.0    within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  27C = 1.081mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '1.081e-3'
    // docTest_item['expect-value'] = '27.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_1 // group TC_1 TemperatureOfTC_TypeK TC_TypeK at  27C = 1.081mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)1.081e-3), (double)27.0); // TC_TypeK at  27C = 1.081mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)1.081e-3, /* expect: */ (double)27.0); // TC_TypeK at  27C = 1.081mV
#endif // MAX11410_SELFTEST_TC_1 // group TC_1

    // @test group TC_1 TemperatureOfTC_TypeK(1.203e-3) expect 30.0    within 0.1 // TC_TypeK at  30C = 1.203mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_1'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(1.203e-3) expect 30.0    within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  30C = 1.203mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '1.203e-3'
    // docTest_item['expect-value'] = '30.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_1 // group TC_1 TemperatureOfTC_TypeK TC_TypeK at  30C = 1.203mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)1.203e-3), (double)30.0); // TC_TypeK at  30C = 1.203mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)1.203e-3, /* expect: */ (double)30.0); // TC_TypeK at  30C = 1.203mV
#endif // MAX11410_SELFTEST_TC_1 // group TC_1

    // @test group TC_1 TemperatureOfTC_TypeK(1.612e-3) expect 40.0    within 0.1 // TC_TypeK at  40C = 1.612mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_1'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(1.612e-3) expect 40.0    within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  40C = 1.612mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '1.612e-3'
    // docTest_item['expect-value'] = '40.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_1 // group TC_1 TemperatureOfTC_TypeK TC_TypeK at  40C = 1.612mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)1.612e-3), (double)40.0); // TC_TypeK at  40C = 1.612mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)1.612e-3, /* expect: */ (double)40.0); // TC_TypeK at  40C = 1.612mV
#endif // MAX11410_SELFTEST_TC_1 // group TC_1

    // @test group TC_1 TemperatureOfTC_TypeK(2.023e-3) expect 50.0    within 0.1 // TC_TypeK at  50C = 2.023mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_1'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(2.023e-3) expect 50.0    within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  50C = 2.023mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '2.023e-3'
    // docTest_item['expect-value'] = '50.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_1 // group TC_1 TemperatureOfTC_TypeK TC_TypeK at  50C = 2.023mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)2.023e-3), (double)50.0); // TC_TypeK at  50C = 2.023mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)2.023e-3, /* expect: */ (double)50.0); // TC_TypeK at  50C = 2.023mV
#endif // MAX11410_SELFTEST_TC_1 // group TC_1

    // @test group TC_1 TemperatureOfTC_TypeK(2.436e-3) expect 60.0    within 0.1 // TC_TypeK at  60C = 2.436mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_1'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(2.436e-3) expect 60.0    within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  60C = 2.436mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '2.436e-3'
    // docTest_item['expect-value'] = '60.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_1 // group TC_1 TemperatureOfTC_TypeK TC_TypeK at  60C = 2.436mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)2.436e-3), (double)60.0); // TC_TypeK at  60C = 2.436mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)2.436e-3, /* expect: */ (double)60.0); // TC_TypeK at  60C = 2.436mV
#endif // MAX11410_SELFTEST_TC_1 // group TC_1

    // @test group TC_1 TemperatureOfTC_TypeK(2.851e-3) expect 70.0    within 0.1 // TC_TypeK at  70C = 2.851mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_1'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(2.851e-3) expect 70.0    within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  70C = 2.851mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '2.851e-3'
    // docTest_item['expect-value'] = '70.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_1 // group TC_1 TemperatureOfTC_TypeK TC_TypeK at  70C = 2.851mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)2.851e-3), (double)70.0); // TC_TypeK at  70C = 2.851mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)2.851e-3, /* expect: */ (double)70.0); // TC_TypeK at  70C = 2.851mV
#endif // MAX11410_SELFTEST_TC_1 // group TC_1

    // @test group TC_1 TemperatureOfTC_TypeK(3.267e-3) expect 80.0    within 0.1 // TC_TypeK at  80C = 3.267mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_1'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(3.267e-3) expect 80.0    within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  80C = 3.267mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '3.267e-3'
    // docTest_item['expect-value'] = '80.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_1 // group TC_1 TemperatureOfTC_TypeK TC_TypeK at  80C = 3.267mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)3.267e-3), (double)80.0); // TC_TypeK at  80C = 3.267mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)3.267e-3, /* expect: */ (double)80.0); // TC_TypeK at  80C = 3.267mV
#endif // MAX11410_SELFTEST_TC_1 // group TC_1

    // @test group TC_1 TemperatureOfTC_TypeK(3.682e-3) expect 90.0    within 0.1 // TC_TypeK at  90C = 3.682mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_1'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(3.682e-3) expect 90.0    within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  90C = 3.682mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '3.682e-3'
    // docTest_item['expect-value'] = '90.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_1 // group TC_1 TemperatureOfTC_TypeK TC_TypeK at  90C = 3.682mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)3.682e-3), (double)90.0); // TC_TypeK at  90C = 3.682mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)3.682e-3, /* expect: */ (double)90.0); // TC_TypeK at  90C = 3.682mV
#endif // MAX11410_SELFTEST_TC_1 // group TC_1

    // @test group TC_1 TemperatureOfTC_TypeK(4.096e-3) expect 100.0   within 0.1 // TC_TypeK at  100C = 4.096mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_1'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(4.096e-3) expect 100.0   within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  100C = 4.096mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '4.096e-3'
    // docTest_item['expect-value'] = '100.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_1 // group TC_1 TemperatureOfTC_TypeK TC_TypeK at  100C = 4.096mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)4.096e-3), (double)100.0); // TC_TypeK at  100C = 4.096mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)4.096e-3, /* expect: */ (double)100.0); // TC_TypeK at  100C = 4.096mV
#endif // MAX11410_SELFTEST_TC_1 // group TC_1

    // @test group TC_2 TemperatureOfTC_TypeK(4.509e-3) expect 110.0    within 0.1 // TC_TypeK at  110C = 4.509mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_2'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(4.509e-3) expect 110.0    within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  110C = 4.509mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '4.509e-3'
    // docTest_item['expect-value'] = '110.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_2 // group TC_2 TemperatureOfTC_TypeK TC_TypeK at  110C = 4.509mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)4.509e-3), (double)110.0); // TC_TypeK at  110C = 4.509mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)4.509e-3, /* expect: */ (double)110.0); // TC_TypeK at  110C = 4.509mV
#endif // MAX11410_SELFTEST_TC_2 // group TC_2

    // @test group TC_2 TemperatureOfTC_TypeK(4.920e-3) expect 120.0    within 0.1 // TC_TypeK at  120C = 4.920mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_2'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(4.920e-3) expect 120.0    within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  120C = 4.920mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '4.920e-3'
    // docTest_item['expect-value'] = '120.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_2 // group TC_2 TemperatureOfTC_TypeK TC_TypeK at  120C = 4.920mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)4.920e-3), (double)120.0); // TC_TypeK at  120C = 4.920mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)4.920e-3, /* expect: */ (double)120.0); // TC_TypeK at  120C = 4.920mV
#endif // MAX11410_SELFTEST_TC_2 // group TC_2

    // @test group TC_2 TemperatureOfTC_TypeK(5.328e-3) expect 130.0    within 0.1 // TC_TypeK at  130C = 5.328mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_2'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(5.328e-3) expect 130.0    within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  130C = 5.328mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '5.328e-3'
    // docTest_item['expect-value'] = '130.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_2 // group TC_2 TemperatureOfTC_TypeK TC_TypeK at  130C = 5.328mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)5.328e-3), (double)130.0); // TC_TypeK at  130C = 5.328mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)5.328e-3, /* expect: */ (double)130.0); // TC_TypeK at  130C = 5.328mV
#endif // MAX11410_SELFTEST_TC_2 // group TC_2

    // @test group TC_2 TemperatureOfTC_TypeK(5.735e-3) expect 140.0    within 0.1 // TC_TypeK at  140C = 5.735mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_2'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(5.735e-3) expect 140.0    within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  140C = 5.735mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '5.735e-3'
    // docTest_item['expect-value'] = '140.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_2 // group TC_2 TemperatureOfTC_TypeK TC_TypeK at  140C = 5.735mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)5.735e-3), (double)140.0); // TC_TypeK at  140C = 5.735mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)5.735e-3, /* expect: */ (double)140.0); // TC_TypeK at  140C = 5.735mV
#endif // MAX11410_SELFTEST_TC_2 // group TC_2

    // @test group TC_2 TemperatureOfTC_TypeK(6.138e-3) expect 150.0    within 0.1 // TC_TypeK at  150C = 6.138mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_2'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(6.138e-3) expect 150.0    within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  150C = 6.138mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '6.138e-3'
    // docTest_item['expect-value'] = '150.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_2 // group TC_2 TemperatureOfTC_TypeK TC_TypeK at  150C = 6.138mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)6.138e-3), (double)150.0); // TC_TypeK at  150C = 6.138mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)6.138e-3, /* expect: */ (double)150.0); // TC_TypeK at  150C = 6.138mV
#endif // MAX11410_SELFTEST_TC_2 // group TC_2

    // @test group TC_2 TemperatureOfTC_TypeK(6.540e-3) expect 160.0    within 0.1 // TC_TypeK at  160C = 6.540mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_2'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(6.540e-3) expect 160.0    within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  160C = 6.540mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '6.540e-3'
    // docTest_item['expect-value'] = '160.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_2 // group TC_2 TemperatureOfTC_TypeK TC_TypeK at  160C = 6.540mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)6.540e-3), (double)160.0); // TC_TypeK at  160C = 6.540mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)6.540e-3, /* expect: */ (double)160.0); // TC_TypeK at  160C = 6.540mV
#endif // MAX11410_SELFTEST_TC_2 // group TC_2

    // @test group TC_2 TemperatureOfTC_TypeK(6.941e-3) expect 170.0    within 0.1 // TC_TypeK at  170C = 6.941mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_2'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(6.941e-3) expect 170.0    within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  170C = 6.941mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '6.941e-3'
    // docTest_item['expect-value'] = '170.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_2 // group TC_2 TemperatureOfTC_TypeK TC_TypeK at  170C = 6.941mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)6.941e-3), (double)170.0); // TC_TypeK at  170C = 6.941mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)6.941e-3, /* expect: */ (double)170.0); // TC_TypeK at  170C = 6.941mV
#endif // MAX11410_SELFTEST_TC_2 // group TC_2

    // @test group TC_2 TemperatureOfTC_TypeK(7.340e-3) expect 180.0    within 0.1 // TC_TypeK at  180C = 7.340mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_2'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(7.340e-3) expect 180.0    within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  180C = 7.340mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '7.340e-3'
    // docTest_item['expect-value'] = '180.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_2 // group TC_2 TemperatureOfTC_TypeK TC_TypeK at  180C = 7.340mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)7.340e-3), (double)180.0); // TC_TypeK at  180C = 7.340mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)7.340e-3, /* expect: */ (double)180.0); // TC_TypeK at  180C = 7.340mV
#endif // MAX11410_SELFTEST_TC_2 // group TC_2

    // @test group TC_1 TemperatureOfTC_TypeK(7.739e-3) expect 190.0   within 0.1 // TC_TypeK at  190C = 7.739mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_1'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(7.739e-3) expect 190.0   within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  190C = 7.739mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '7.739e-3'
    // docTest_item['expect-value'] = '190.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_1 // group TC_1 TemperatureOfTC_TypeK TC_TypeK at  190C = 7.739mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)7.739e-3), (double)190.0); // TC_TypeK at  190C = 7.739mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)7.739e-3, /* expect: */ (double)190.0); // TC_TypeK at  190C = 7.739mV
#endif // MAX11410_SELFTEST_TC_1 // group TC_1

    // @test group TC_1 TemperatureOfTC_TypeK(8.138e-3) expect 200.0   within 0.1 // TC_TypeK at  200C = 8.138mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_1'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(8.138e-3) expect 200.0   within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  200C = 8.138mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '8.138e-3'
    // docTest_item['expect-value'] = '200.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_1 // group TC_1 TemperatureOfTC_TypeK TC_TypeK at  200C = 8.138mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)8.138e-3), (double)200.0); // TC_TypeK at  200C = 8.138mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)8.138e-3, /* expect: */ (double)200.0); // TC_TypeK at  200C = 8.138mV
#endif // MAX11410_SELFTEST_TC_1 // group TC_1

    // @test group TC_1 TemperatureOfTC_TypeK(8.539e-3) expect 210.0   within 0.1 // TC_TypeK at  210C = 8.539mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_1'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(8.539e-3) expect 210.0   within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  210C = 8.539mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '8.539e-3'
    // docTest_item['expect-value'] = '210.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_1 // group TC_1 TemperatureOfTC_TypeK TC_TypeK at  210C = 8.539mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)8.539e-3), (double)210.0); // TC_TypeK at  210C = 8.539mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)8.539e-3, /* expect: */ (double)210.0); // TC_TypeK at  210C = 8.539mV
#endif // MAX11410_SELFTEST_TC_1 // group TC_1

    // @test group TC_1 TemperatureOfTC_TypeK(8.940e-3) expect 220.0   within 0.1 // TC_TypeK at  220C = 8.940mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_1'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(8.940e-3) expect 220.0   within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  220C = 8.940mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '8.940e-3'
    // docTest_item['expect-value'] = '220.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_1 // group TC_1 TemperatureOfTC_TypeK TC_TypeK at  220C = 8.940mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)8.940e-3), (double)220.0); // TC_TypeK at  220C = 8.940mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)8.940e-3, /* expect: */ (double)220.0); // TC_TypeK at  220C = 8.940mV
#endif // MAX11410_SELFTEST_TC_1 // group TC_1

    // @test group TC_2 TemperatureOfTC_TypeK(9.343e-3) expect 230.0    within 0.1 // TC_TypeK at  230C = 9.343mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_2'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(9.343e-3) expect 230.0    within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  230C = 9.343mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '9.343e-3'
    // docTest_item['expect-value'] = '230.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_2 // group TC_2 TemperatureOfTC_TypeK TC_TypeK at  230C = 9.343mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)9.343e-3), (double)230.0); // TC_TypeK at  230C = 9.343mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)9.343e-3, /* expect: */ (double)230.0); // TC_TypeK at  230C = 9.343mV
#endif // MAX11410_SELFTEST_TC_2 // group TC_2

    // @test group TC_2 TemperatureOfTC_TypeK(9.747e-3) expect 240.0    within 0.1 // TC_TypeK at  240C = 9.747mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_2'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(9.747e-3) expect 240.0    within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  240C = 9.747mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '9.747e-3'
    // docTest_item['expect-value'] = '240.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_2 // group TC_2 TemperatureOfTC_TypeK TC_TypeK at  240C = 9.747mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)9.747e-3), (double)240.0); // TC_TypeK at  240C = 9.747mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)9.747e-3, /* expect: */ (double)240.0); // TC_TypeK at  240C = 9.747mV
#endif // MAX11410_SELFTEST_TC_2 // group TC_2

    // @test group TC_2 TemperatureOfTC_TypeK(10.153e-3) expect 250.0   within 0.1 // TC_TypeK at  250C = 10.153mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_2'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(10.153e-3) expect 250.0   within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  250C = 10.153mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '10.153e-3'
    // docTest_item['expect-value'] = '250.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_2 // group TC_2 TemperatureOfTC_TypeK TC_TypeK at  250C = 10.153mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)10.153e-3), (double)250.0); // TC_TypeK at  250C = 10.153mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)10.153e-3, /* expect: */ (double)250.0); // TC_TypeK at  250C = 10.153mV
#endif // MAX11410_SELFTEST_TC_2 // group TC_2

    // @test group TC_2 TemperatureOfTC_TypeK(10.561e-3) expect 260.0   within 0.1 // TC_TypeK at  260C = 10.561mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_2'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(10.561e-3) expect 260.0   within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  260C = 10.561mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '10.561e-3'
    // docTest_item['expect-value'] = '260.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_2 // group TC_2 TemperatureOfTC_TypeK TC_TypeK at  260C = 10.561mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)10.561e-3), (double)260.0); // TC_TypeK at  260C = 10.561mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)10.561e-3, /* expect: */ (double)260.0); // TC_TypeK at  260C = 10.561mV
#endif // MAX11410_SELFTEST_TC_2 // group TC_2

    // @test group TC_2 TemperatureOfTC_TypeK(10.971e-3) expect 270.0   within 0.1 // TC_TypeK at  270C = 10.971mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_2'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(10.971e-3) expect 270.0   within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  270C = 10.971mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '10.971e-3'
    // docTest_item['expect-value'] = '270.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_2 // group TC_2 TemperatureOfTC_TypeK TC_TypeK at  270C = 10.971mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)10.971e-3), (double)270.0); // TC_TypeK at  270C = 10.971mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)10.971e-3, /* expect: */ (double)270.0); // TC_TypeK at  270C = 10.971mV
#endif // MAX11410_SELFTEST_TC_2 // group TC_2

    // @test group TC_2 TemperatureOfTC_TypeK(11.382e-3) expect 280.0   within 0.1 // TC_TypeK at  280C = 11.382mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_2'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(11.382e-3) expect 280.0   within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  280C = 11.382mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '11.382e-3'
    // docTest_item['expect-value'] = '280.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_2 // group TC_2 TemperatureOfTC_TypeK TC_TypeK at  280C = 11.382mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)11.382e-3), (double)280.0); // TC_TypeK at  280C = 11.382mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)11.382e-3, /* expect: */ (double)280.0); // TC_TypeK at  280C = 11.382mV
#endif // MAX11410_SELFTEST_TC_2 // group TC_2

    // @test group TC_2 TemperatureOfTC_TypeK(11.795e-3) expect 290.0   within 0.1 // TC_TypeK at  290C = 11.795mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_2'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(11.795e-3) expect 290.0   within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  290C = 11.795mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '11.795e-3'
    // docTest_item['expect-value'] = '290.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_2 // group TC_2 TemperatureOfTC_TypeK TC_TypeK at  290C = 11.795mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)11.795e-3), (double)290.0); // TC_TypeK at  290C = 11.795mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)11.795e-3, /* expect: */ (double)290.0); // TC_TypeK at  290C = 11.795mV
#endif // MAX11410_SELFTEST_TC_2 // group TC_2

    // @test group TC_1 TemperatureOfTC_TypeK(12.209e-3) expect 300.0  within 0.1 // TC_TypeK at  300C = 12.209mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_1'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(12.209e-3) expect 300.0  within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  300C = 12.209mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '12.209e-3'
    // docTest_item['expect-value'] = '300.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_1 // group TC_1 TemperatureOfTC_TypeK TC_TypeK at  300C = 12.209mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)12.209e-3), (double)300.0); // TC_TypeK at  300C = 12.209mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)12.209e-3, /* expect: */ (double)300.0); // TC_TypeK at  300C = 12.209mV
#endif // MAX11410_SELFTEST_TC_1 // group TC_1

    // @test group TC_2 TemperatureOfTC_TypeK(14.293e-3) expect 350.0   within 0.1 // TC_TypeK at  350C = 14.293mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_2'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(14.293e-3) expect 350.0   within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  350C = 14.293mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '14.293e-3'
    // docTest_item['expect-value'] = '350.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_2 // group TC_2 TemperatureOfTC_TypeK TC_TypeK at  350C = 14.293mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)14.293e-3), (double)350.0); // TC_TypeK at  350C = 14.293mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)14.293e-3, /* expect: */ (double)350.0); // TC_TypeK at  350C = 14.293mV
#endif // MAX11410_SELFTEST_TC_2 // group TC_2

    // @test group TC_1 TemperatureOfTC_TypeK(16.397e-3) expect 400.0  within 0.1 // TC_TypeK at  400C = 16.397mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_1'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(16.397e-3) expect 400.0  within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  400C = 16.397mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '16.397e-3'
    // docTest_item['expect-value'] = '400.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_1 // group TC_1 TemperatureOfTC_TypeK TC_TypeK at  400C = 16.397mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)16.397e-3), (double)400.0); // TC_TypeK at  400C = 16.397mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)16.397e-3, /* expect: */ (double)400.0); // TC_TypeK at  400C = 16.397mV
#endif // MAX11410_SELFTEST_TC_1 // group TC_1

    // @test group TC_1 TemperatureOfTC_TypeK(18.516e-3) expect 450.0  within 0.1 // TC_TypeK at  450C = 18.516mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_1'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(18.516e-3) expect 450.0  within 0.1'
    // docTest_item['remarks'] = 'TC_TypeK at  450C = 18.516mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '18.516e-3'
    // docTest_item['expect-value'] = '450.0'
    // docTest_item['within-value'] = '0.1'
#if MAX11410_SELFTEST_TC_1 // group TC_1 TemperatureOfTC_TypeK TC_TypeK at  450C = 18.516mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)18.516e-3), (double)450.0); // TC_TypeK at  450C = 18.516mV
    tinyTester.err_threshold = 0.1; // within 0.1
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)18.516e-3, /* expect: */ (double)450.0); // TC_TypeK at  450C = 18.516mV
#endif // MAX11410_SELFTEST_TC_1 // group TC_1

    // @test group TC_1 TemperatureOfTC_TypeK(20.218e-3) expect 490.0  // TC_TypeK at  490C = 20.218mV
    // docTest_item['actionType'] = 'call-function'
    // docTest_item['group-id-value'] = 'TC_1'
    // docTest_item['action'] = 'TemperatureOfTC_TypeK(20.218e-3) expect 490.0'
    // docTest_item['remarks'] = 'TC_TypeK at  490C = 20.218mV'
    // docTest_item['funcName'] = 'TemperatureOfTC_TypeK'
    // docTest_item['arglist'] = '20.218e-3'
    // docTest_item['expect-value'] = '490.0'
#if MAX11410_SELFTEST_TC_1 // group TC_1 TemperatureOfTC_TypeK TC_TypeK at  490C = 20.218mV
    // call-function
    // ASSERT_EQ(g_MAX11410_device.TemperatureOfTC_TypeK((double)20.218e-3), (double)490.0); // TC_TypeK at  490C = 20.218mV
    tinyTester.FunctionCall_f_f_Expect("MAX11410.TemperatureOfTC_TypeK", fn_MAX11410_TemperatureOfTC_TypeK, (double)20.218e-3, /* expect: */ (double)490.0); // TC_TypeK at  490C = 20.218mV
#endif // MAX11410_SELFTEST_TC_1 // group TC_1

    // @test group TC_1 tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
    // docTest_item['actionType'] = 'assign-propname-value'
    // docTest_item['group-id-value'] = 'TC_1'
    // docTest_item['action'] = 'tinyTester.blink_time_msec = 75'
    // docTest_item['remarks'] = 'default 75 resume hardware self test'
    // docTest_item['propName'] = 'tinyTester.blink_time_msec'
    // docTest_item['propValue'] = '75'
#if MAX11410_SELFTEST_TC_1 // group TC_1 None default 75 resume hardware self test
    // assign-propname-value
    // tinyTesterPropName = "tinyTester.blink_time_msec"
    // tinyTesterPropValue = "75"
    tinyTester.blink_time_msec = 75;
#endif // MAX11410_SELFTEST_TC_1 // group TC_1

    //
#if INJECT_SELFTEST_FAIL
    // Test of the pass/fail report mechanism
    tinyTester.FAIL();
    cmdLine.serial().print(F("injecting one false failure for test reporting"));
#endif
    //
    // Report number of pass and number of fail test results
    tinyTester.Report_Summary();
}

//--------------------------------------------------
// selfTestFunctionClosures[functionName]['functionName'] = 'Init'
// selfTestFunctionClosures[functionName]['argListDeclaration'] = 'void'
// selfTestFunctionClosures[functionName]['returnType'] = 'uint8_t'
// selfTestFunctionClosures[functionName]['argNames'] = ''
// CommandParamIn_declaration = 'void'
// argNames_recast_implementation = ''
//--------------------------------------------------
// selftest: define function under test
// uint8_t MAX11410::Init(void)
uint8_t fn_MAX11410_Init(void)
{
    return g_MAX11410_device.Init();
}

//--------------------------------------------------
// selfTestFunctionClosures[functionName]['functionName'] = 'RegRead'
// selfTestFunctionClosures[functionName]['argListDeclaration'] = 'MAX11410::MAX11410_CMD_enum_t commandByte, uint32_t* ptrRegData'
// selfTestFunctionClosures[functionName]['returnType'] = 'uint8_t'
// selfTestFunctionClosures[functionName]['argNames'] = 'commandByte, ptrRegData'
// CommandParamIn_declaration = 'int commandByte, uint32_t* ptrRegData'
// argNames_recast_implementation = '(MAX11410::MAX11410_CMD_enum_t)commandByte, /*(uint32_t*) */ ptrRegData'
//--------------------------------------------------
// selftest: define function under test
// uint8_t MAX11410::RegRead(MAX11410::MAX11410_CMD_enum_t commandByte, uint32_t* ptrRegData)
uint8_t fn_MAX11410_RegRead(int commandByte, uint32_t* ptrRegData)
{
    return g_MAX11410_device.RegRead((MAX11410::MAX11410_CMD_enum_t)commandByte, /*(uint32_t*) */ ptrRegData);
}

//--------------------------------------------------
// selfTestFunctionClosures[functionName]['functionName'] = 'RegWrite'
// selfTestFunctionClosures[functionName]['argListDeclaration'] = 'MAX11410::MAX11410_CMD_enum_t commandByte, uint32_t regData'
// selfTestFunctionClosures[functionName]['returnType'] = 'uint8_t'
// selfTestFunctionClosures[functionName]['argNames'] = 'commandByte, regData'
// CommandParamIn_declaration = 'int commandByte, uint32_t regData'
// argNames_recast_implementation = '(MAX11410::MAX11410_CMD_enum_t)commandByte, (uint32_t)regData'
//--------------------------------------------------
// selftest: define function under test
// uint8_t MAX11410::RegWrite(MAX11410::MAX11410_CMD_enum_t commandByte, uint32_t regData)
uint8_t fn_MAX11410_RegWrite(int commandByte, uint32_t regData)
{
    return g_MAX11410_device.RegWrite((MAX11410::MAX11410_CMD_enum_t)commandByte, (uint32_t)regData);
}

//--------------------------------------------------
// selfTestFunctionClosures[functionName]['functionName'] = 'Measure_Voltage'
// selfTestFunctionClosures[functionName]['argListDeclaration'] = 'MAX11410::MAX11410_AINP_SEL_enum_t ainp, MAX11410::MAX11410_AINN_SEL_enum_t ainn'
// selfTestFunctionClosures[functionName]['returnType'] = 'double'
// selfTestFunctionClosures[functionName]['argNames'] = 'ainp, ainn'
// CommandParamIn_declaration = 'int ainp, int ainn'
// argNames_recast_implementation = '(MAX11410::MAX11410_AINP_SEL_enum_t)ainp, (MAX11410::MAX11410_AINN_SEL_enum_t)ainn'
//--------------------------------------------------
// selftest: define function under test
// double MAX11410::Measure_Voltage(MAX11410::MAX11410_AINP_SEL_enum_t ainp, MAX11410::MAX11410_AINN_SEL_enum_t ainn)
double fn_MAX11410_Measure_Voltage(int ainp, int ainn)
{
    return g_MAX11410_device.Measure_Voltage((MAX11410::MAX11410_AINP_SEL_enum_t)ainp, (MAX11410::MAX11410_AINN_SEL_enum_t)ainn);
}

//--------------------------------------------------
// selfTestFunctionClosures[functionName]['functionName'] = 'Configure_CTRL_REF'
// selfTestFunctionClosures[functionName]['argListDeclaration'] = 'uint8_t ref_sel'
// selfTestFunctionClosures[functionName]['returnType'] = 'uint8_t'
// selfTestFunctionClosures[functionName]['argNames'] = 'ref_sel'
// CommandParamIn_declaration = 'uint8_t ref_sel'
// argNames_recast_implementation = '(uint8_t)ref_sel'
//--------------------------------------------------
// selftest: define function under test
// uint8_t MAX11410::Configure_CTRL_REF(uint8_t ref_sel)
uint8_t fn_MAX11410_Configure_CTRL_REF(uint8_t ref_sel)
{
    return g_MAX11410_device.Configure_CTRL_REF((uint8_t)ref_sel);
}

//--------------------------------------------------
// selfTestFunctionClosures[functionName]['functionName'] = 'Configure_PGA'
// selfTestFunctionClosures[functionName]['argListDeclaration'] = 'uint8_t sigpath, uint8_t gain'
// selfTestFunctionClosures[functionName]['returnType'] = 'uint8_t'
// selfTestFunctionClosures[functionName]['argNames'] = 'sigpath, gain'
// CommandParamIn_declaration = 'uint8_t sigpath, uint8_t gain'
// argNames_recast_implementation = '(uint8_t)sigpath, (uint8_t)gain'
//--------------------------------------------------
// selftest: define function under test
// uint8_t MAX11410::Configure_PGA(uint8_t sigpath, uint8_t gain)
uint8_t fn_MAX11410_Configure_PGA(uint8_t sigpath, uint8_t gain)
{
    return g_MAX11410_device.Configure_PGA((uint8_t)sigpath, (uint8_t)gain);
}

//--------------------------------------------------
// selfTestFunctionClosures[functionName]['functionName'] = 'VoltageOfCode_Unipolar'
// selfTestFunctionClosures[functionName]['argListDeclaration'] = 'uint32_t value_u24'
// selfTestFunctionClosures[functionName]['returnType'] = 'double'
// selfTestFunctionClosures[functionName]['argNames'] = 'value_u24'
// CommandParamIn_declaration = 'uint32_t value_u24'
// argNames_recast_implementation = '(uint32_t)value_u24'
//--------------------------------------------------
// selftest: define function under test
// double MAX11410::VoltageOfCode_Unipolar(uint32_t value_u24)
double fn_MAX11410_VoltageOfCode_Unipolar(uint32_t value_u24)
{
    return g_MAX11410_device.VoltageOfCode_Unipolar((uint32_t)value_u24);
}

//--------------------------------------------------
// selfTestFunctionClosures[functionName]['functionName'] = 'VoltageOfCode_Bipolar_OffsetBinary'
// selfTestFunctionClosures[functionName]['argListDeclaration'] = 'uint32_t value_u24'
// selfTestFunctionClosures[functionName]['returnType'] = 'double'
// selfTestFunctionClosures[functionName]['argNames'] = 'value_u24'
// CommandParamIn_declaration = 'uint32_t value_u24'
// argNames_recast_implementation = '(uint32_t)value_u24'
//--------------------------------------------------
// selftest: define function under test
// double MAX11410::VoltageOfCode_Bipolar_OffsetBinary(uint32_t value_u24)
double fn_MAX11410_VoltageOfCode_Bipolar_OffsetBinary(uint32_t value_u24)
{
    return g_MAX11410_device.VoltageOfCode_Bipolar_OffsetBinary((uint32_t)value_u24);
}

//--------------------------------------------------
// selfTestFunctionClosures[functionName]['functionName'] = 'VoltageOfCode_Bipolar_2sComplement'
// selfTestFunctionClosures[functionName]['argListDeclaration'] = 'uint32_t value_u24'
// selfTestFunctionClosures[functionName]['returnType'] = 'double'
// selfTestFunctionClosures[functionName]['argNames'] = 'value_u24'
// CommandParamIn_declaration = 'uint32_t value_u24'
// argNames_recast_implementation = '(uint32_t)value_u24'
//--------------------------------------------------
// selftest: define function under test
// double MAX11410::VoltageOfCode_Bipolar_2sComplement(uint32_t value_u24)
double fn_MAX11410_VoltageOfCode_Bipolar_2sComplement(uint32_t value_u24)
{
    return g_MAX11410_device.VoltageOfCode_Bipolar_2sComplement((uint32_t)value_u24);
}

//--------------------------------------------------
// selfTestFunctionClosures[functionName]['functionName'] = 'TemperatureOfRTD_PT1000'
// selfTestFunctionClosures[functionName]['argListDeclaration'] = 'double rtd_ohm'
// selfTestFunctionClosures[functionName]['returnType'] = 'double'
// selfTestFunctionClosures[functionName]['argNames'] = 'rtd_ohm'
// CommandParamIn_declaration = 'double rtd_ohm'
// argNames_recast_implementation = '(double)rtd_ohm'
//--------------------------------------------------
// selftest: define function under test
// double MAX11410::TemperatureOfRTD_PT1000(double rtd_ohm)
double fn_MAX11410_TemperatureOfRTD_PT1000(double rtd_ohm)
{
    return g_MAX11410_device.TemperatureOfRTD_PT1000((double)rtd_ohm);
}

//--------------------------------------------------
// selfTestFunctionClosures[functionName]['functionName'] = 'TemperatureOfRTD_PT100'
// selfTestFunctionClosures[functionName]['argListDeclaration'] = 'double rtd_ohm'
// selfTestFunctionClosures[functionName]['returnType'] = 'double'
// selfTestFunctionClosures[functionName]['argNames'] = 'rtd_ohm'
// CommandParamIn_declaration = 'double rtd_ohm'
// argNames_recast_implementation = '(double)rtd_ohm'
//--------------------------------------------------
// selftest: define function under test
// double MAX11410::TemperatureOfRTD_PT100(double rtd_ohm)
double fn_MAX11410_TemperatureOfRTD_PT100(double rtd_ohm)
{
    return g_MAX11410_device.TemperatureOfRTD_PT100((double)rtd_ohm);
}

//--------------------------------------------------
// selfTestFunctionClosures[functionName]['functionName'] = 'TemperatureOfRTD'
// selfTestFunctionClosures[functionName]['argListDeclaration'] = 'double rtd_ohm'
// selfTestFunctionClosures[functionName]['returnType'] = 'double'
// selfTestFunctionClosures[functionName]['argNames'] = 'rtd_ohm'
// CommandParamIn_declaration = 'double rtd_ohm'
// argNames_recast_implementation = '(double)rtd_ohm'
//--------------------------------------------------
// selftest: define function under test
// double MAX11410::TemperatureOfRTD(double rtd_ohm)
double fn_MAX11410_TemperatureOfRTD(double rtd_ohm)
{
    return g_MAX11410_device.TemperatureOfRTD((double)rtd_ohm);
}

//--------------------------------------------------
// selfTestFunctionClosures[functionName]['functionName'] = 'TemperatureOfTC_TypeK'
// selfTestFunctionClosures[functionName]['argListDeclaration'] = 'double tc_v'
// selfTestFunctionClosures[functionName]['returnType'] = 'double'
// selfTestFunctionClosures[functionName]['argNames'] = 'tc_v'
// CommandParamIn_declaration = 'double tc_v'
// argNames_recast_implementation = '(double)tc_v'
//--------------------------------------------------
// selftest: define function under test
// double MAX11410::TemperatureOfTC_TypeK(double tc_v)
double fn_MAX11410_TemperatureOfTC_TypeK(double tc_v)
{
    return g_MAX11410_device.TemperatureOfTC_TypeK((double)tc_v);
}


//--------------------------------------------------
inline void print_command_prompt()
{
    cmdLine_serial.serial().printf("\r\n> ");

}


//--------------------------------------------------
void pinsMonitor_submenu_onEOLcommandParser(CmdLine& cmdLine)
{
    // % diagnostic commands submenu
    // %Hpin -- digital output high
    // %Lpin -- digital output low
    // %?pin -- digital input
    // %A %Apin -- analog input
    // %Ppin df=xx -- pwm output
    // %Wpin -- measure high pulsewidth input in usec
    // %wpin -- measure low pulsewidth input in usec
    // %I... -- I2C diagnostics
    // %IP -- I2C probe
    // %IC scl=100khz ADDR=? -- I2C configure
    // %IW byte byte ... byte RD=? ADDR=0x -- write
    // %IR ADDR=? RD=? -- read
    // %I^ cmd=? -- i2c_smbus_read_word_data
    // %S... -- SPI diagnostics
    // %SC sclk=1Mhz -- SPI configure
    // %SW -- write (write and read)
    // %SR -- read (alias for %SW because SPI always write and read)
    // A-Z,a-z,0-9 reserved for application use
    //
    char strPinIndex[3];
    strPinIndex[0] = cmdLine[2];
    strPinIndex[1] = cmdLine[3];
    strPinIndex[2] = '\0';
    int pinIndex = strtoul(strPinIndex, NULL, 10);         // strtol(str, NULL, 10): get decimal value
    //cmdLine.serial().printf(" pinIndex=%d ", pinIndex);
    //
    // get next character
    switch (cmdLine[1])
    {
#if HAS_digitalInOuts
        case 'H': case 'h':
        {
            // %Hpin -- digital output high
#if ARDUINO_STYLE
            pinMode(pinIndex, OUTPUT);             // digital pins 0, 1, 2, .. 13, analog input pins A0, A1, .. A5
            digitalWrite(pinIndex, HIGH);             // digital pins 0, 1, 2, .. 13, analog input pins A0, A1, .. A5
#else
            DigitalInOut& digitalInOutPin = find_digitalInOutPin(pinIndex);
            digitalInOutPin.output();
            digitalInOutPin.write(1);
#endif
            cmdLine.serial().printf(" digitalInOutPin %d Output High ", pinIndex);
        }
        break;
        case 'L': case 'l':
        {
            // %Lpin -- digital output low
#if ARDUINO_STYLE
            pinMode(pinIndex, OUTPUT);             // digital pins 0, 1, 2, .. 13, analog input pins A0, A1, .. A5
            digitalWrite(pinIndex, LOW);             // digital pins 0, 1, 2, .. 13, analog input pins A0, A1, .. A5
#else
            DigitalInOut& digitalInOutPin = find_digitalInOutPin(pinIndex);
            digitalInOutPin.output();
            digitalInOutPin.write(0);
#endif
            cmdLine.serial().printf(" digitalInOutPin %d Output Low ", pinIndex);
        }
        break;
        case '?':
        {
            // %?pin -- digital input
#if ARDUINO_STYLE
            pinMode(pinIndex, INPUT);             // digital pins 0, 1, 2, .. 13, analog input pins A0, A1, .. A5
#else
            DigitalInOut& digitalInOutPin = find_digitalInOutPin(pinIndex);
            digitalInOutPin.input();
#endif
            serial.printf(" digitalInOutPin %d Input ", pinIndex);
#if ARDUINO_STYLE
            int value = digitalRead(pinIndex);
#else
            int value = digitalInOutPin.read();
#endif
            cmdLine.serial().printf("%d ", value);
        }
        break;
#endif
        //
#if HAS_analogIns
        case 'A': case 'a':
        {
            // %A %Apin -- analog input
#if analogIn4_IS_HIGH_RANGE_OF_analogIn0
            // Platform board uses AIN4,AIN5,.. as high range of AIN0,AIN1,..
            for (int pinIndex = 0; pinIndex < 2; pinIndex++)
            {
                int cPinIndex = '0' + pinIndex;
                AnalogIn& analogInPin = find_analogInPin(cPinIndex);
                float adc_full_scale_voltage = analogInPin_fullScaleVoltage[pinIndex];
                float normValue_0_1 = analogInPin.read();
                //
                int pinIndexH = pinIndex + 4;
                int cPinIndexH = '0' + pinIndexH;
                AnalogIn& analogInPinH = find_analogInPin(cPinIndexH);
                float adc_full_scale_voltageH = analogInPin_fullScaleVoltage[pinIndexH];
                float normValueH_0_1 = analogInPinH.read();
                //
                cmdLine.serial().printf("AIN%c = %7.3f%% = %1.3fV  AIN%c = %7.3f%% = %1.3fV  \r\n",
                                        cPinIndex,
                                        normValue_0_1 * 100.0,
                                        normValue_0_1 * adc_full_scale_voltage,
                                        cPinIndexH,
                                        normValueH_0_1 * 100.0,
                                        normValueH_0_1 * adc_full_scale_voltageH
                                        );
            }
            for (int pinIndex = 2; pinIndex < 4; pinIndex++)
            {
                int cPinIndex = '0' + pinIndex;
                AnalogIn& analogInPin = find_analogInPin(cPinIndex);
                float adc_full_scale_voltage = analogInPin_fullScaleVoltage[pinIndex];
                float normValue_0_1 = analogInPin.read();
                //
                cmdLine.serial().printf("AIN%c = %7.3f%% = %1.3fV\r\n",
                                        cPinIndex,
                                        normValue_0_1 * 100.0,
                                        normValue_0_1 * adc_full_scale_voltage
                                        );
            }
#else // analogIn4_IS_HIGH_RANGE_OF_analogIn0
            // Platform board uses simple analog inputs
            // assume standard Arduino analog inputs A0-A5
            for (int pinIndex = 0; pinIndex < 6; pinIndex++)
            {
                int cPinIndex = '0' + pinIndex;
                AnalogIn& analogInPin = find_analogInPin(cPinIndex);
                float adc_full_scale_voltage = analogInPin_fullScaleVoltage[pinIndex];
                float normValue_0_1 = analogInPin.read();
                //
                cmdLine.serial().printf("AIN%c = %7.3f%% = %1.3fV\r\n",
                                        cPinIndex,
                                        normValue_0_1 * 100.0,
                                        normValue_0_1 * adc_full_scale_voltage
                                        );
            }
#endif // analogIn4_IS_HIGH_RANGE_OF_analogIn0
        }
        break;
#endif
        //
#if HAS_SPI2_MAX541
        case 'D': case 'd':
        {
            // %D -- DAC output MAX541 (SPI2) -- need cmdLine.parse_float(voltageV)
            // MAX541 max541(spi2_max541, spi2_max541_cs);
            float voltageV = max541.Get_Voltage();
            // if (cmdLine[2] == '+') {
            //     // %D+
            //     voltageV = voltageV * 1.25f;
            //     if (voltageV >= max541.VRef) voltageV = max541.VRef;
            //     SelfTest_MAX541_Voltage(cmdLine, max541, voltageV);
            // }
            // else if (cmdLine[2] == '-') {
            //     // %D-
            //     voltageV = voltageV * 0.75f;
            //     if (voltageV < 0.1f) voltageV = 0.1f;
            //     SelfTest_MAX541_Voltage(cmdLine, max541, voltageV);
            // }
            if (cmdLine.parse_float("V", voltageV))
            {
                // %D V=1.234 -- set voltage
                max541.Set_Voltage(voltageV);
            }
            else if (cmdLine.parse_float("TEST", voltageV))
            {
                // %D TEST=1.234 -- set voltage and compare with AIN0
                SelfTest_MAX541_Voltage(cmdLine, max541, voltageV);
            }
            else if (cmdLine.parse_float("CAL", voltageV))
            {
                // %D CAL=1.234 -- calibrate VRef and compare with AIN0

                max541.Set_Code(0x8000); // we don't know the fullscale voltage yet, so set code to midscale
                double max541_midscale_V = analogInPin_fullScaleVoltage[4] * analogIn4.read(); // TARGET_MAX32630 J1.5 AIN_4 = AIN0 / 5.0     fullscale is 6.0V
                const int average_count = 100;
                const double average_K = 0.25;
                for (int count = 0; count < average_count; count++) {
                    double measurement_V = analogInPin_fullScaleVoltage[4] * analogIn4.read(); // TARGET_MAX32630 J1.5 AIN_4 = AIN0 / 5.0     fullscale is 6.0V
                    max541_midscale_V = ((1 - average_K) * max541_midscale_V) + (average_K * measurement_V);
                }
                max541.VRef = 2.0 * max541_midscale_V;
                cmdLine.serial().printf(
                    "\r\n      MAX541 midscale = %1.3fV, so fullscale = %1.3fV",
                    max541_midscale_V, max541.VRef);
                // Detect whether MAX541 is really connected to MAX32625MBED.AIN0/AIN4
                voltageV = 1.0f;
                SelfTest_MAX541_Voltage(cmdLine, max541, voltageV);
            }
            else {
                // %D -- print MAX541 DAC status
                cmdLine.serial().printf("MAX541 code=0x%4.4x = %1.3fV  VRef=%1.3fV\r\n",
                                        max541.Get_Code(), max541.Get_Voltage(), max541.VRef);
            }
        }
        break;
#endif

        //
#if HAS_I2C // SUPPORT_I2C
        case 'I': case 'i':
            // %I... -- I2C diagnostics
            // %IP -- I2C probe
            // %IC scl=100khz ADDR=? -- I2C configure
            // %IW byte byte ... byte RD=? ADDR=0x -- write
            // %IR ADDR=? RD=? -- read
            // %I^ cmd=? -- i2c_smbus_read_word_data
            // get next character
            // TODO: parse cmdLine arg (ADDR=\d+)? --> g_I2C_deviceAddress7
            cmdLine.parse_byte_hex("ADDR", g_I2C_deviceAddress7);
            // TODO: parse cmdLine arg (RD=\d)? --> g_I2C_read_count
            g_I2C_read_count = 0;         // read count must be reset every command
            cmdLine.parse_byte_dec("RD", g_I2C_read_count);
            // TODO: parse cmdLine arg (CMD=\d)? --> g_I2C_command_regAddress
            cmdLine.parse_byte_hex("CMD", g_I2C_command_regAddress);
            switch (cmdLine[2])
            {
                case 'P': case 'p':
                {
                    // %IP -- I2C probe
                    HuntAttachedI2CDevices(cmdLine, 0x03, 0x77);
                }
                break;
                case 'C': case 'c':
                {
                    bool isUpdatedI2CConfig = false;
                    // %IC scl=100khz ADDR=? -- I2C configure
                    // parse cmdLine arg (SCL=\d+(kHZ|MHZ)?)? --> g_I2C_SCL_Hz
                    if (cmdLine.parse_frequency_Hz("SCL", g_I2C_SCL_Hz))
                    {
                        isUpdatedI2CConfig = true;
                        // TODO1: validate g_I2C_SCL_Hz against system clock frequency F_CPU
                        if (g_I2C_SCL_Hz > limit_max_I2C_SCL_Hz)
                        {
                            g_I2C_SCL_Hz = limit_max_I2C_SCL_Hz;
                        }
                        if (g_I2C_SCL_Hz < limit_min_I2C_SCL_Hz)
                        {
                            g_I2C_SCL_Hz = limit_min_I2C_SCL_Hz;
                        }
                    }
                    if (isUpdatedI2CConfig)
                    {
                        // declare in narrower scope: MAX32625MBED I2C i2cMaster(...)
                        I2C i2cMaster(I2C0_SDA, I2C0_SCL);             // sda scl TARGET_MAX32635MBED: P1_6, P1_7 Arduino 10-pin header
                        i2cMaster.frequency(g_I2C_SCL_Hz);
                        i2cMaster.start();
                        i2cMaster.stop();
                        i2cMaster.frequency(g_I2C_SCL_Hz);
                        cmdLine.serial().printf(
                            "\r\n %%IC ADDR=0x%2.2x=(0x%2.2x>>1) SCL=%d=%1.3fkHz -- I2C config",
                            g_I2C_deviceAddress7, (g_I2C_deviceAddress7 << 1), g_I2C_SCL_Hz,
                            (g_I2C_SCL_Hz / 1000.));
                        i2cMaster.start();
                        i2cMaster.stop();
                    }
                }
                break;
                case 'W': case 'w':
                {
                    // declare in narrower scope: MAX32625MBED I2C i2cMaster(...)
                    I2C i2cMaster(I2C0_SDA, I2C0_SCL);             // sda scl TARGET_MAX32635MBED: P1_6, P1_7 Arduino 10-pin header
                    i2cMaster.frequency(g_I2C_SCL_Hz);
                    // %IW byte byte ... byte RD=? ADDR=0x -- write
                    // parse cmdLine byte list --> int byteCount; int mosiData[MAX_SPI_BYTE_COUNT];
                    #define MAX_I2C_BYTE_COUNT 32
                    size_t byteCount = byteCount;
                    static char mosiData[MAX_I2C_BYTE_COUNT];
                    static char misoData[MAX_I2C_BYTE_COUNT];
                    if (cmdLine.parse_byteCount_byteList_hex(byteCount, mosiData,
                                                             MAX_I2C_BYTE_COUNT))
                    {
                        // hex dump mosiData[0..byteCount-1]
                        cmdLine.serial().printf(
                            "\r\nADDR=0x%2.2x=(0x%2.2x>>1) byteCount:%d RD=%d\r\nI2C MOSI->",
                            g_I2C_deviceAddress7,
                            (g_I2C_deviceAddress7 << 1), byteCount, g_I2C_read_count);
                        for (unsigned int byteIndex = 0; byteIndex < byteCount; byteIndex++)
                        {
                            cmdLine.serial().printf(" 0x%2.2X", mosiData[byteIndex]);
                        }
                        //
                        // TODO: i2c transfer
                        //const int addr7bit = 0x48;      // 7 bit I2C address
                        //const int addr8bit = 0x48 << 1; // 8bit I2C address, 0x90
                        // /* int  */   i2cMaster.read (int addr8bit, char *data, int length, bool repeated=false) // Read from an I2C slave.
                        // /* int  */   i2cMaster.read (int ack) // Read a single byte from the I2C bus.
                        // /* int  */   i2cMaster.write (int addr8bit, const char *data, int length, bool repeated=false) // Write to an I2C slave.
                        // /* int  */   i2cMaster.write (int data) // Write single byte out on the I2C bus.
                        // /* void */   i2cMaster.start (void) // Creates a start condition on the I2C bus.
                        // /* void */   i2cMaster.stop (void) // Creates a stop condition on the I2C bus.
                        // /* int */    i2cMaster.transfer (int addr8bit, const char *tx_buffer, int tx_length, char *rx_buffer, int rx_length, const event_callback_t &callback, int event=I2C_EVENT_TRANSFER_COMPLETE, bool repeated=false) // Start nonblocking I2C transfer. More...
                        // /* void */   i2cMaster.abort_transfer () // Abort the ongoing I2C transfer. More...
                        const int addr8bit = g_I2C_deviceAddress7 << 1;             // 8bit I2C address, 0x90
                        unsigned int misoLength = 0;
                        bool repeated = (g_I2C_read_count > 0);
                        //
                        int writeStatus = i2cMaster.write (addr8bit, mosiData, byteCount, repeated);
                        switch (writeStatus)
                        {
                            case 0: cmdLine.serial().printf(" ack "); break;
                            case 1: cmdLine.serial().printf(" nack "); break;
                            default: cmdLine.serial().printf(" {writeStatus 0x%2.2X} ",
                                                             writeStatus);
                        }
                        if (repeated)
                        {
                            int readStatus =
                                i2cMaster.read (addr8bit, misoData, g_I2C_read_count, false);
                            switch (readStatus)
                            {
                                case 1: cmdLine.serial().printf(" nack "); break;
                                case 0: cmdLine.serial().printf(" ack "); break;
                                default: cmdLine.serial().printf(" {readStatus 0x%2.2X} ",
                                                                 readStatus);
                            }
                        }
                        //
                        if (misoLength > 0)
                        {
                            // hex dump misoData[0..byteCount-1]
                            cmdLine.serial().printf(" MISO<-");
                            for (unsigned int byteIndex = 0; byteIndex < g_I2C_read_count;
                                 byteIndex++)
                            {
                                cmdLine.serial().printf(" 0x%2.2X", misoData[byteIndex]);
                            }
                        }
                        cmdLine.serial().printf(" ");
                    }
                }
                break;
                case 'R': case 'r':
                {
                    // declare in narrower scope: MAX32625MBED I2C i2cMaster(...)
                    I2C i2cMaster(I2C0_SDA, I2C0_SCL);             // sda scl TARGET_MAX32635MBED: P1_6, P1_7 Arduino 10-pin header
                    i2cMaster.frequency(g_I2C_SCL_Hz);
                    // %IR ADDR=? RD=? -- read
                    // TODO: i2c transfer
                    //const int addr7bit = 0x48;      // 7 bit I2C address
                    //const int addr8bit = 0x48 << 1; // 8bit I2C address, 0x90
                    // /* int  */   i2cMaster.read (int addr8bit, char *data, int length, bool repeated=false) // Read from an I2C slave.
                    // /* int  */   i2cMaster.read (int ack) // Read a single byte from the I2C bus.
                    // /* int  */   i2cMaster.write (int addr8bit, const char *data, int length, bool repeated=false) // Write to an I2C slave.
                    // /* int  */   i2cMaster.write (int data) // Write single byte out on the I2C bus.
                    // /* void */   i2cMaster.start (void) // Creates a start condition on the I2C bus.
                    // /* void */   i2cMaster.stop (void) // Creates a stop condition on the I2C bus.
                    // /* int */    i2cMaster.transfer (int addr8bit, const char *tx_buffer, int tx_length, char *rx_buffer, int rx_length, const event_callback_t &callback, int event=I2C_EVENT_TRANSFER_COMPLETE, bool repeated=false) // Start nonblocking I2C transfer. More...
                    // /* void */   i2cMaster.abort_transfer () // Abort the ongoing I2C transfer. More...
                }
                break;
                case '^':
                {
                    // declare in narrower scope: MAX32625MBED I2C i2cMaster(...)
                    I2C i2cMaster(I2C0_SDA, I2C0_SCL);             // sda scl TARGET_MAX32635MBED: P1_6, P1_7 Arduino 10-pin header
                    i2cMaster.frequency(g_I2C_SCL_Hz);
                    // %I^ cmd=? -- i2c_smbus_read_word_data
                    // TODO: i2c transfer
                    //const int addr7bit = 0x48;      // 7 bit I2C address
                    //const int addr8bit = 0x48 << 1; // 8bit I2C address, 0x90
                    // /* int  */   i2cMaster.read (int addr8bit, char *data, int length, bool repeated=false) // Read from an I2C slave.
                    // /* int  */   i2cMaster.read (int ack) // Read a single byte from the I2C bus.
                    // /* int  */   i2cMaster.write (int addr8bit, const char *data, int length, bool repeated=false) // Write to an I2C slave.
                    // /* int  */   i2cMaster.write (int data) // Write single byte out on the I2C bus.
                    // /* void */   i2cMaster.start (void) // Creates a start condition on the I2C bus.
                    // /* void */   i2cMaster.stop (void) // Creates a stop condition on the I2C bus.
                    // /* int */    i2cMaster.transfer (int addr8bit, const char *tx_buffer, int tx_length, char *rx_buffer, int rx_length, const event_callback_t &callback, int event=I2C_EVENT_TRANSFER_COMPLETE, bool repeated=false) // Start nonblocking I2C transfer. More...
                    // /* void */   i2cMaster.abort_transfer () // Abort the ongoing I2C transfer. More...
                }
                break;
            }         // switch(cmdLine[2])
            break;
#endif
        //
#if HAS_SPI // SUPPORT_SPI
        case 'S': case 's':
        {
            // %S... -- SPI diagnostics
            // %SC sclk=1Mhz -- SPI configure
            // %SW -- write (write and read)
            // %SR -- read (alias for %SW because SPI always write and read)
            //
            // Process arguments SCLK=\d+(kHZ|MHZ) CPOL=\d CPHA=\d
            bool isUpdatedSPIConfig = false;
            // parse cmdLine arg (CPOL=\d)? --> g_SPI_dataMode | SPI_MODE2
            // parse cmdLine arg (CPHA=\d)? --> g_SPI_dataMode | SPI_MODE1
            if (cmdLine.parse_flag("CPOL", g_SPI_dataMode, SPI_MODE2))
            {
                isUpdatedSPIConfig = true;
            }
            if (cmdLine.parse_flag("CPHA", g_SPI_dataMode, SPI_MODE1))
            {
                isUpdatedSPIConfig = true;
            }
            if (cmdLine.parse_flag("CS", g_SPI_cs_state, 1))
            {
                isUpdatedSPIConfig = true;
            }
            // parse cmdLine arg (SCLK=\d+(kHZ|MHZ)?)? --> g_SPI_SCLK_Hz
            if (cmdLine.parse_frequency_Hz("SCLK", g_SPI_SCLK_Hz))
            {
                isUpdatedSPIConfig = true;
                // TODO1: validate g_SPI_SCLK_Hz against system clock frequency F_CPU
                if (g_SPI_SCLK_Hz > limit_max_SPI_SCLK_Hz)
                {
                    g_SPI_SCLK_Hz = limit_max_SPI_SCLK_Hz;
                }
                if (g_SPI_SCLK_Hz < limit_min_SPI_SCLK_Hz)
                {
                    g_SPI_SCLK_Hz = limit_min_SPI_SCLK_Hz;
                }
            }
            // Update SPI configuration
            if (isUpdatedSPIConfig)
            {
                // %SC sclk=1Mhz -- SPI configure
                spi_cs = g_SPI_cs_state;
                spi.format(8,g_SPI_dataMode);             // int bits_must_be_8, int mode=0_3 CPOL=0,CPHA=0
#if APPLICATION_MAX5715
                g_MAX5715_device.spi_frequency(g_SPI_SCLK_Hz);
#elif APPLICATION_MAX11131
                g_MAX11131_device.spi_frequency(g_SPI_SCLK_Hz);
#elif APPLICATION_MAX5171
                g_MAX5171_device.spi_frequency(g_SPI_SCLK_Hz);
#elif APPLICATION_MAX11410
                g_MAX11410_device.spi_frequency(g_SPI_SCLK_Hz);
#elif APPLICATION_MAX12345
                g_MAX12345_device.spi_frequency(g_SPI_SCLK_Hz);
#else
                spi.frequency(g_SPI_SCLK_Hz);             // int SCLK_Hz=1000000 = 1MHz (initial default)
#endif
                //
                double ideal_divisor = ((double)SystemCoreClock) / g_SPI_SCLK_Hz;
                int actual_divisor = (int)(ideal_divisor + 0.0);             // frequency divisor truncate
                double actual_SCLK_Hz = SystemCoreClock / actual_divisor;
                //
                // fixed: mbed-os-5.11: [Warning] format '%d' expects argument of type 'int', but argument 6 has type 'uint32_t {aka long unsigned int}' [-Wformat=]
                cmdLine.serial().printf(
                    "\r\n %%SC CPOL=%d CPHA=%d CS=%d SCLK=%ld=%1.3fMHz (%1.1fMHz/%1.2f = actual %1.3fMHz) -- SPI config",
                    ((g_SPI_dataMode & SPI_MODE2) ? 1 : 0),
                    ((g_SPI_dataMode & SPI_MODE1) ? 1 : 0),
                    g_SPI_cs_state,
                    g_SPI_SCLK_Hz,
                    (g_SPI_SCLK_Hz / 1000000.),
                    ((double)(SystemCoreClock / 1000000.)),
                    ideal_divisor,
                    (actual_SCLK_Hz / 1000000.)
                    );
            }
            // get next character
            switch (cmdLine[2])
            {
                case 'C': case 's':
                    // %SC sclk=1Mhz -- SPI configure
                    break;
                case 'D': case 'd':
                    // %SD -- SPI diagnostic messages enable
                    if (g_MAX11410_device.onSPIprint) {
                        g_MAX11410_device.onSPIprint = NULL;
                        g_MAX11410_device.loop_limit = 3000; // Platform_futility_countdown_limit_fast
                    }
                    else {
                        void onSPIprint_handler(size_t byteCount, uint8_t mosiData[], uint8_t misoData[]);
                        g_MAX11410_device.onSPIprint = onSPIprint_handler;
                        g_MAX11410_device.loop_limit = 30; // Platform_futility_countdown_limit_diagnostic
                    }
                    break;
                case 'W': case 'R': case 'w': case 'r':
                {
                    // %SW -- write (write and read)
                    // %SR -- read (alias for %SW because SPI always write and read)
                    // parse cmdLine byte list --> int byteCount; int mosiData[MAX_SPI_BYTE_COUNT];
                    #define MAX_SPI_BYTE_COUNT 32
                    size_t byteCount = byteCount;
                    static char mosiData[MAX_SPI_BYTE_COUNT];
                    static char misoData[MAX_SPI_BYTE_COUNT];
                    if (cmdLine.parse_byteCount_byteList_hex(byteCount, mosiData,
                                                             MAX_SPI_BYTE_COUNT))
                    {
                        // hex dump mosiData[0..byteCount-1]
                        cmdLine.serial().printf("\r\nSPI");
                        if (byteCount > 7) {
                            cmdLine.serial().printf(" byteCount:%d", byteCount);
                        }
                        cmdLine.serial().printf(" MOSI->");
                        for (unsigned int byteIndex = 0; byteIndex < byteCount; byteIndex++)
                        {
                            cmdLine.serial().printf(" 0x%2.2X", mosiData[byteIndex]);
                        }
                        spi_cs = 0;
                        unsigned int numBytesTransferred =
                            spi.write(mosiData, byteCount, misoData, byteCount);
                        spi_cs = 1;
                        // hex dump misoData[0..byteCount-1]
                        cmdLine.serial().printf(" MISO<-");
                        for (unsigned int byteIndex = 0; byteIndex < numBytesTransferred;
                             byteIndex++)
                        {
                            cmdLine.serial().printf(" 0x%2.2X", misoData[byteIndex]);
                        }
                        cmdLine.serial().printf(" ");
                    }
                }
                break;
            }             // switch(cmdLine[2])
        }             // case 'S': // %S... -- SPI diagnostics
        break;
#endif
        //
        // A-Z,a-z,0-9 reserved for application use
    }         // switch(cmdLine[1])
} // end void pinsMonitor_submenu_onEOLcommandParser(CmdLine & cmdLine)


//--------------------------------------------------
void main_menu_status(CmdLine & cmdLine)
{
    cmdLine.serial().printf("\r\nMain menu");

    cmdLine.serial().printf(" MAX11410 24-bit 1.9ksps Delta-Sigma ADC");

    //cmdLine.serial().print(" %s", TARGET_NAME);
    if (cmdLine.nameStr())
    {
        cmdLine.serial().printf(" [%s]", cmdLine.nameStr());

    }
    cmdLine.serial().printf("\r\n ? -- help");

}


//--------------------------------------------------
void main_menu_help(CmdLine & cmdLine)
{
    // ? -- help
    //~ cmdLine.serial().print(F("\r\nMenu:"));
    cmdLine.serial().printf("\r\n # -- lines beginning with # are comments");

    cmdLine.serial().printf("\r\n . -- SelfTest");

    //cmdLine.serial().print(F("\r\n ! -- Initial Configuration"));
    //
    // % standardize diagnostic commands
    // %Hpin -- digital output high
    // %Lpin -- digital output low
    // %?pin -- digital input
    // %A %Apin -- analog input
    // %Ppin df=xx -- pwm output
    // %Wpin -- measure high pulsewidth input in usec
    // %wpin -- measure low pulsewidth input in usec
    // %I... -- I2C diagnostics
    // %IP -- I2C probe
    // %IC scl=100khz ADDR=? -- I2C configure
    // %IW ADDR=? cmd=? data,data,data -- write
    // %IR ADDR=? RD=? -- read
    // %I^ cmd=? -- i2c_smbus_read_word_data
    // %S... -- SPI diagnostics
    // %SC sclk=1Mhz -- SPI configure
    // %SW -- write (write and read)
    // %SR -- read (alias for %SW because SPI always write and read)
    // A-Z,a-z,0-9 reserved for application use
    //
#if HAS_digitalInOuts
    // %Hpin -- digital output high
    // %Lpin -- digital output low
    // %?pin -- digital input
    cmdLine.serial().printf("\r\n %%Hn {pin:");
    list_digitalInOutPins(cmdLine.serial());
    cmdLine.serial().printf("} -- High Output");
    cmdLine.serial().printf("\r\n %%Ln {pin:");
    list_digitalInOutPins(cmdLine.serial());
    cmdLine.serial().printf("} -- Low Output");
    cmdLine.serial().printf("\r\n %%?n {pin:");
    list_digitalInOutPins(cmdLine.serial());
    cmdLine.serial().printf("} -- Input");
#endif

#if HAS_analogIns
    // Menu A) analogRead A0..7
    // %A %Apin -- analog input
    // analogRead(pinIndex) // analog input pins A0, A1, A2, A3, A4, A5; float voltage = analogRead(A0) * (5.0 / 1023.0)
    cmdLine.serial().printf("\r\n %%A -- analogRead");
#endif

#if HAS_SPI2_MAX541
    // TODO1: MAX541 max541(spi2_max541, spi2_max541_cs);
    cmdLine.serial().printf("\r\n %%D -- DAC output MAX541 (SPI2)");
#endif

#if HAS_I2C // SUPPORT_I2C
    // TODO: support I2C HAS_I2C // SUPPORT_I2C
    // VERIFY: I2C utility commands SUPPORT_I2C
    // VERIFY: report g_I2C_SCL_Hz = (F_CPU / ((TWBR * 2) + 16)) from last Wire_Sr.setClock(I2C_SCL_Hz);
    // %I... -- I2C diagnostics
    // %IP -- I2C probe
    // %IC scl=100khz ADDR=? -- I2C configure
    // %IW byte byte ... byte RD=? ADDR=0x -- write
    // %IR ADDR=? RD=? -- read
    // %I^ cmd=? -- i2c_smbus_read_word_data
    //g_I2C_SCL_Hz = (F_CPU / ((TWBR * 2) + 16));   // 'F_CPU' 'TWBR' not declared in this scope
    cmdLine.serial().printf("\r\n %%IC ADDR=0x%2.2x=(0x%2.2x>>1) SCL=%d=%1.3fkHz -- I2C config",
                            g_I2C_deviceAddress7, (g_I2C_deviceAddress7 << 1), g_I2C_SCL_Hz,
                            (g_I2C_SCL_Hz / 1000.));
    cmdLine.serial().printf("\r\n %%IW byte byte ... byte RD=? ADDR=0x%2.2x -- I2C write/read",
                            g_I2C_deviceAddress7);
    //
#if SUPPORT_I2C
    // Menu ^ cmd=?) i2c_smbus_read_word_data
    cmdLine.serial().printf("\r\n %%I^ cmd=? -- i2c_smbus_read_word_data");
    // test low-level I2C i2c_smbus_read_word_data
#endif // SUPPORT_I2C
    //cmdLine.serial().printf(" H) Hunt for attached I2C devices");
    cmdLine.serial().printf("\r\n %%IP -- I2C Probe for attached devices");
    // cmdLine.serial().printf(" s) search i2c address");
#endif // SUPPORT_I2C

#if HAS_SPI // SUPPORT_SPI
    // TODO: support SPI HAS_SPI // SUPPORT_SPI
    // SPI test command  S (mosiData)+
    // %S... -- SPI diagnostics
    // %SC sclk=1Mhz -- SPI configure
    // %SW -- write (write and read)
    // %SR -- read (alias for %SW because SPI always write and read)
    // spi.format(8,0); // int bits_must_be_8, int mode=0_3 CPOL=0,CPHA=0 rising edge (initial default)
    // spi.format(8,1); // int bits_must_be_8, int mode=0_3 CPOL=0,CPHA=1 falling edge (initial default)
    // spi.format(8,2); // int bits_must_be_8, int mode=0_3 CPOL=1,CPHA=0 falling edge (initial default)
    // spi.format(8,3); // int bits_must_be_8, int mode=0_3 CPOL=1,CPHA=1 rising edge (initial default)
    // spi.frequency(1000000); // int SCLK_Hz=1000000 = 1MHz (initial default)
    // mode | POL PHA
    // -----+--------
    //   0  |  0   0
    //   1  |  0   1
    //   2  |  1   0
    //   3  |  1   1
    //cmdLine.serial().printf(" S) SPI mosi,mosi,...mosi hex bytes SCLK=1000000 CPOL=0 CPHA=0");
    // fixed: mbed-os-5.11: [Warning] format '%d' expects argument of type 'int', but argument 3 has type 'uint32_t {aka long unsigned int}' [-Wformat=]
    cmdLine.serial().printf("\r\n %%SC SCLK=%ld=%1.3fMHz CPOL=%d CPHA=%d -- SPI config",
                            g_SPI_SCLK_Hz, (g_SPI_SCLK_Hz / 1000000.),
                            ((g_SPI_dataMode & SPI_MODE2) ? 1 : 0),
                            ((g_SPI_dataMode & SPI_MODE1) ? 1 : 0));
    cmdLine.serial().printf("\r\n %%SD -- SPI diagnostic messages ");
    if (g_MAX11410_device.onSPIprint) {
        cmdLine.serial().printf("hide");
    }
    else {
        cmdLine.serial().printf("show");
    }
    cmdLine.serial().printf("\r\n %%SW mosi,mosi,...mosi -- SPI write hex bytes");
    // VERIFY: parse new SPI settings parse_strCommandArgs() SCLK=1000000 CPOL=0 CPHA=0
#endif // SUPPORT_SPI
       //
       // Application-specific commands (help text) here
       //
#if APPLICATION_ArduinoPinsMonitor
    cmdLine.serial().printf("\r\n A-Z,a-z,0-9 -- reserved for application use");     // ArduinoPinsMonitor
#endif // APPLICATION_ArduinoPinsMonitor
       //

    extern void MAX11410_menu_help(CmdLine & cmdLine); // defined in Test_Menu_MAX11410.cpp\n
    MAX11410_menu_help(cmdLine);
}



//--------------------------------------------------
// main menu command-line parser
// invoked by CmdLine::append(char ch) or CmdLine::idleAppendIfReadable()
void main_menu_onEOLcommandParser(CmdLine & cmdLine)
{
    // DIAGNOSTIC: print line buffer
    //~ cmdLine.serial().printf("\r\nmain_menu_onEOLcommandParser: ~%s~\r\n", cmdLine.str());
    //
    switch (cmdLine[0])
    {
        case '?':
            main_menu_status(cmdLine);
            main_menu_help(cmdLine);
            // print command prompt
            //cmdLine.serial().printf("\r\n>");
            break;
        case '\r': case '\n':     // ignore blank line
        case '\0':     // ignore empty line
        case '#':     // ignore comment line
            // # -- lines beginning with # are comments
            main_menu_status(cmdLine);
            //~ main_menu_help(cmdLine);
            // print command prompt
            //cmdLine.serial().printf("\r\n>");
            break;
#if ECHO_EOF_ON_EOL
        case '\x04':     // Unicode (U+0004) EOT END OF TRANSMISSION = CTRL+D as EOF end of file
            cmdLine.serial().printf("\x04");     // immediately echo EOF for test scripting
            diagnostic_led_EOF();
            break;
        case '\x1a':     // Unicode (U+001A) SUB SUBSTITUTE = CTRL+Z as EOF end of file
            cmdLine.serial().printf("\x1a");     // immediately echo EOF for test scripting
            diagnostic_led_EOF();
            break;
#endif
#if APPLICATION_ArduinoPinsMonitor
        case '.':
        {
            // . -- SelfTest
            cmdLine.serial().printf("SelfTest()");
            SelfTest(cmdLine);
        }
        break;
        case '%':
        {
            pinsMonitor_submenu_onEOLcommandParser(cmdLine);
        }
        break;         // case '%'
#endif // APPLICATION_ArduinoPinsMonitor
       //
       // Application-specific commands here
       // alphanumeric command codes A-Z,a-z,0-9 reserved for application use
       //
#if APPLICATION_ArduinoPinsMonitor
#endif // APPLICATION_ArduinoPinsMonitor

        //
        // add new commands here
        //
        default:
            extern bool MAX11410_menu_onEOLcommandParser(CmdLine & cmdLine); // defined in Test_Menu_MAX11410.cpp
            if (!MAX11410_menu_onEOLcommandParser(cmdLine))
            { // not_handled_by_device_submenu
                cmdLine.serial().printf("\r\n unknown command 0x%2.2x \"%s\"\r\n", cmdLine.str()[0], cmdLine.str());

# if HAS_DAPLINK_SERIAL
                cmdLine_DAPLINKserial.serial().printf("\r\n unknown command 0x%2.2x \"%s\"\r\n", cmdLine.str()[0], cmdLine.str());

# endif // HAS_DAPLINK_SERIAL
            }
    }     // switch (cmdLine[0])
//
// print command prompt
    cmdLine.serial().printf("\r\nMAX11410 > ");

} // end void main_menu_onEOLcommandParser(CmdLine & cmdLine)

//--------------------------------------------------
#if MAX11410_ONSPIPRINT
// Optional Diagnostic function to print SPI transactions
void onSPIprint_handler(size_t byteCount, uint8_t mosiData[], uint8_t misoData[])
{
    cmdLine_serial.serial().printf("\r\n      SPI MOSI->");
    for (uint8_t index = 0; index < byteCount; index++) {
        cmdLine_serial.serial().printf(" 0x%2.2X", mosiData[index]);
    }
    cmdLine_serial.serial().printf(" MISO<-");
    for (uint8_t index = 0; index < byteCount; index++) {
        cmdLine_serial.serial().printf(" 0x%2.2X", misoData[index]);
    }
    cmdLine_serial.serial().printf(" ");
}
#endif // MAX11410_ONSPIPRINT

//--------------------------------------------------
void InitializeConfiguration()
{
    // CODE GENERATOR: example code: member function Init
# if HAS_DAPLINK_SERIAL
    cmdLine_DAPLINKserial.serial().printf("\r\nMAX11410_Init()");

# endif
    cmdLine_serial.serial().printf("\r\nMAX11410_Init()");

    // Initialize MAX11410 and verify device ID
    if (g_MAX11410_device.Init() == 0)
    {  // init failed; try "safe mode" SPI at slower SCLK rate
        cmdLine_serial.serial().printf("\r\nMAX11410 Init failed; retry at SPI SCLK frequency 2000000 Hz\r\n");

        g_SPI_SCLK_Hz = 2000000;
        g_MAX11410_device.spi_frequency(2000000);
        g_MAX11410_device.Init();
    }
    // CODE GENERATOR: get spi properties from device
    if (g_SPI_SCLK_Hz > g_MAX11410_device.get_spi_frequency())
    {  // Device limits SPI SCLK frequency
        g_SPI_SCLK_Hz = g_MAX11410_device.get_spi_frequency();
        cmdLine_serial.serial().printf("\r\nMAX11410 limits SPI SCLK frequency to %ld Hz\r\n", g_SPI_SCLK_Hz);

        g_MAX11410_device.Init();
    }
    if (g_MAX11410_device.get_spi_frequency() > g_SPI_SCLK_Hz)
    {  // Platform limits SPI SCLK frequency
        g_MAX11410_device.spi_frequency(g_SPI_SCLK_Hz);
        cmdLine_serial.serial().printf("\r\nPlatform limits MAX11410 SPI SCLK frequency to %ld Hz\r\n", g_SPI_SCLK_Hz);

        g_MAX11410_device.Init();
    }
    g_SPI_dataMode = g_MAX11410_device.get_spi_dataMode();

# if MAX11410_ONSPIPRINT
  // Optional Diagnostic function to print SPI transactions
#  if MAX11410_ONSPIPRINT_ENABLED
  g_MAX11410_device.onSPIprint = onSPIprint_handler;
#  else
  g_MAX11410_device.onSPIprint = NULL;
#  endif
# endif
} // end of void InitializeConfiguration()

//--------------------------------------------------
// diagnostic rbg led GREEN
void diagnostic_led_EOF()
{
#if USE_LEDS
    led1 = LED_ON; led2 = LED_ON; led3 = LED_OFF;     // diagnostic rbg led RED+GREEN=YELLOW
    // TODO1: mbed-os-5.11: [Warning] 'static osStatus rtos::Thread::wait(uint32_t)' is deprecated: Static methods only affecting current thread cause confusion. Replaced by ThisThread::sleep_for. [since mbed-os-5.10] [-Wdeprecated-declarations]
    ThisThread::sleep_for(250); // [since mbed-os-5.10] vs Thread::wait(250);
    led1 = LED_OFF; led2 = LED_ON; led3 = LED_OFF;     // diagnostic rbg led GREEN
    ThisThread::sleep_for(250); // [since mbed-os-5.10] vs Thread::wait(250);
    led1 = LED_ON; led2 = LED_ON; led3 = LED_OFF;     // diagnostic rbg led RED+GREEN=YELLOW
    ThisThread::sleep_for(250); // [since mbed-os-5.10] vs Thread::wait(250);
    led1 = LED_OFF; led2 = LED_ON; led3 = LED_OFF;     // diagnostic rbg led GREEN
    ThisThread::sleep_for(250); // [since mbed-os-5.10] vs Thread::wait(250);
#endif // USE_LEDS
}

//--------------------------------------------------
// Support commands that get handled immediately w/o waiting for EOL
// handled as immediate command, do not append to buffer
void on_immediate_0x21() // Unicode (U+0021) ! EXCLAMATION MARK
{
#if USE_LEDS
    led1 = LED_OFF; led2 = LED_OFF; led3 = LED_ON;     // diagnostic rbg led BLUE
#endif // USE_LEDS
    InitializeConfiguration();
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
}

//--------------------------------------------------
// Support commands that get handled immediately w/o waiting for EOL
// handled as immediate command, do not append to buffer
void on_immediate_0x7b() // Unicode (U+007B) { LEFT CURLY BRACKET
{
#if HAS_BUTTON2_DEMO_INTERRUPT
    onButton2FallingEdge();
#endif
}

//--------------------------------------------------
// Support commands that get handled immediately w/o waiting for EOL
// handled as immediate command, do not append to buffer
void on_immediate_0x7d() // Unicode (U+007D) } RIGHT CURLY BRACKET
{
#if HAS_BUTTON1_DEMO_INTERRUPT
    onButton1FallingEdge();
#endif
}

//----------------------------------------
// example code main function
int main()
{
    // Configure serial ports
    cmdLine_serial.clear();
    //~ cmdLine_serial.serial().printf("\r\n cmdLine_serial.serial().printf test\r\n");
    cmdLine_serial.onEOLcommandParser = main_menu_onEOLcommandParser;
    cmdLine_serial.diagnostic_led_EOF = diagnostic_led_EOF;
    /// CmdLine::set_immediate_handler(char, functionPointer_void_void_on_immediate_0x21);
    cmdLine_serial.on_immediate_0x21 = on_immediate_0x21;
    cmdLine_serial.on_immediate_0x7b = on_immediate_0x7b;
    cmdLine_serial.on_immediate_0x7d = on_immediate_0x7d;
# if HAS_DAPLINK_SERIAL
    cmdLine_DAPLINKserial.clear();
    //~ cmdLine_DAPLINKserial.serial().printf("\r\n cmdLine_DAPLINKserial.serial().printf test\r\n");
    cmdLine_DAPLINKserial.onEOLcommandParser = main_menu_onEOLcommandParser;
    /// @todo CmdLine::set_immediate_handler(char, functionPointer_void_void_on_immediate_0x21);
    cmdLine_DAPLINKserial.on_immediate_0x21 = on_immediate_0x21;
    cmdLine_DAPLINKserial.on_immediate_0x7b = on_immediate_0x7b;
    cmdLine_DAPLINKserial.on_immediate_0x7d = on_immediate_0x7d;
# endif


    //print_banner();

#if HAS_I2C
// i2c init
// declare in narrower scope: MAX32625MBED I2C i2cMaster(...)
//    i2cMaster.frequency(g_I2C_SCL_Hz);
#else
    // Ensure that the unused I2C pins do not interfere with analog inputs A4 and A5
#if HAS_digitalInOut14
    // DigitalInOut digitalInOut14(P1_6, PIN_INPUT, PullUp, 1); // P1_6 TARGET_MAX32635MBED A4/SDA (10pin digital connector)
    digitalInOut14.input();
#endif
#if HAS_digitalInOut15
    // DigitalInOut digitalInOut15(P1_7, PIN_INPUT, PullUp, 1); // P1_7 TARGET_MAX32635MBED A5/SCL (10pin digital connector)
    digitalInOut15.input();
#endif
#if HAS_digitalInOut16
    // DigitalInOut mode can be one of PullUp, PullDown, PullNone, OpenDrain
    // PullUp-->3.4V, PullDown-->1.7V, PullNone-->3.5V, OpenDrain-->0.00V
    //DigitalInOut digitalInOut16(P3_4, PIN_INPUT, OpenDrain, 0); // P3_4 TARGET_MAX32635MBED A4/SDA (6pin analog connector)
    digitalInOut16.input();
#endif
#if HAS_digitalInOut17
    //DigitalInOut digitalInOut17(P3_5, PIN_INPUT, OpenDrain, 0); // P3_5 TARGET_MAX32635MBED A5/SCL (6pin analog connector)
    digitalInOut17.input();
#endif
#endif // HAS_I2C


#if USE_LEDS
#if defined(TARGET_MAX32630)
    led1 = LED_ON; led2 = LED_OFF; led3 = LED_OFF;     // diagnostic rbg led RED
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
    led1 = LED_OFF; led2 = LED_ON; led3 = LED_OFF;     // diagnostic rbg led GREEN
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
    led1 = LED_OFF; led2 = LED_OFF; led3 = LED_ON;     // diagnostic rbg led BLUE
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
    led1 = LED_ON; led2 = LED_ON; led3 = LED_ON;     // diagnostic rbg led RED+GREEN+BLUE=WHITE
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
    led1 = LED_OFF; led2 = LED_ON; led3 = LED_ON;     // diagnostic rbg led GREEN+BLUE=CYAN
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
    led1 = LED_ON; led2 = LED_OFF; led3 = LED_ON;     // diagnostic rbg led RED+BLUE=MAGENTA
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
    led1 = LED_ON; led2 = LED_ON; led3 = LED_OFF;     // diagnostic rbg led RED+GREEN=YELLOW
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
    led1 = LED_OFF; led2 = LED_OFF; led3 = LED_OFF;     // diagnostic rbg led BLACK
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
#elif defined(TARGET_MAX32625MBED)
    led1 = LED_ON; led2 = LED_OFF; led3 = LED_OFF;     // diagnostic rbg led RED
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
    led1 = LED_OFF; led2 = LED_ON; led3 = LED_OFF;     // diagnostic rbg led GREEN
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
    led1 = LED_OFF; led2 = LED_OFF; led3 = LED_ON;     // diagnostic rbg led BLUE
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
    led1 = LED_ON; led2 = LED_ON; led3 = LED_ON;     // diagnostic rbg led RED+GREEN+BLUE=WHITE
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
    led1 = LED_OFF; led2 = LED_ON; led3 = LED_ON;     // diagnostic rbg led GREEN+BLUE=CYAN
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
    led1 = LED_ON; led2 = LED_OFF; led3 = LED_ON;     // diagnostic rbg led RED+BLUE=MAGENTA
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
    led1 = LED_ON; led2 = LED_ON; led3 = LED_OFF;     // diagnostic rbg led RED+GREEN=YELLOW
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
    led1 = LED_OFF; led2 = LED_OFF; led3 = LED_OFF;     // diagnostic rbg led BLACK
    ThisThread::sleep_for(125); // [since mbed-os-5.10] vs Thread::wait(125);
#else // not defined(TARGET_LPC1768 etc.)
    led1 = LED_ON;
    led2 = LED_OFF;
    led3 = LED_OFF;
    led4 = LED_OFF;
    ThisThread::sleep_for(75); // [since mbed-os-5.10] vs Thread::wait(75);
    //led1 = LED_ON;
    led2 = LED_ON;
    ThisThread::sleep_for(75); // [since mbed-os-5.10] vs Thread::wait(75);
    led1 = LED_OFF;
    //led2 = LED_ON;
    led3 = LED_ON;
    ThisThread::sleep_for(75); // [since mbed-os-5.10] vs Thread::wait(75);
    led2 = LED_OFF;
    //led3 = LED_ON;
    led4 = LED_ON;
    ThisThread::sleep_for(75); // [since mbed-os-5.10] vs Thread::wait(75);
    led3 = LED_OFF;
    led4 = LED_ON;
    //
#endif // target definition
#endif

    // cmd_TE();

// #if USE_LEDS
//     rgb_led.white();     // diagnostic rbg led RED+GREEN+BLUE=WHITE
// #endif // USE_LEDS
    if (led1.is_connected()) {
        led1 = LED_ON;
    }
    if (led2.is_connected()) {
        led2 = LED_ON;
    }
    if (led3.is_connected()) {
        led3 = LED_ON;
    }

    InitializeConfiguration();
        // example code: serial port banner message
    #if defined(TARGET_MAX32625MBED)
        serial.printf("MAX32625MBED ");
    #elif defined(TARGET_MAX32625PICO)
        serial.printf("MAX32625PICO ");
    #elif defined(TARGET_MAX32600MBED)
        serial.printf("MAX32600MBED ");
    #elif defined(TARGET_NUCLEO_F446RE)
        serial.printf("NUCLEO_F446RE ");
    #endif
        serial.printf("MAX11410BOB\r\n");


    while (1) {
#if HAS_BUTTON1_DEMO_INTERRUPT_POLLING
        // avoid runtime error on button1 press [mbed-os-5.11]
        // instead of using InterruptIn, use DigitalIn and poll in main while(1)
# if HAS_BUTTON1_DEMO_INTERRUPT
        static int button1_value_prev = 1;
        static int button1_value_now = 1;
        button1_value_prev = button1_value_now;
        button1_value_now = button1.read();
        if ((button1_value_prev - button1_value_now) == 1)
        {
            // on button1 falling edge (button1 press)
            onButton1FallingEdge();
        }
# endif // HAS_BUTTON1_DEMO_INTERRUPT
# if HAS_BUTTON2_DEMO_INTERRUPT
        static int button2_value_prev = 1;
        static int button2_value_now = 1;
        button2_value_prev = button2_value_now;
        button2_value_now = button2.read();
        if ((button2_value_prev - button2_value_now) == 1)
        {
            // on button2 falling edge (button2 press)
            onButton2FallingEdge();
        }
# endif // HAS_BUTTON2_DEMO_INTERRUPT
#endif
    # if HAS_DAPLINK_SERIAL
        if (DAPLINKserial.readable()) {
            cmdLine_DAPLINKserial.append(DAPLINKserial.getc());
        }
    # endif // HAS_DAPLINK_SERIAL
        if (serial.readable()) {
            int c = serial.getc();
            cmdLine_serial.append(c);
#if IGNORE_AT_COMMANDS
# if HAS_DAPLINK_SERIAL
            cmdLine_DAPLINKserial.serial().printf("%c", c);
# endif // HAS_DAPLINK_SERIAL
#endif // IGNORE_AT_COMMANDS
            //
        }
    }     // while(1)
}
//---------- CODE GENERATOR: end testMainCppCodeList
