// /*******************************************************************************
// * Copyright (C) 2020 Maxim Integrated Products, Inc., All Rights Reserved.
// *
// * Permission is hereby granted, free of charge, to any person obtaining a
// * copy of this software and associated documentation files (the "Software"),
// * to deal in the Software without restriction, including without limitation
// * the rights to use, copy, modify, merge, publish, distribute, sublicense,
// * and/or sell copies of the Software, and to permit persons to whom the
// * Software is furnished to do so, subject to the following conditions:
// *
// * The above copyright notice and this permission notice shall be included
// * in all copies or substantial portions of the Software.
// *
// * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
// * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// * OTHER DEALINGS IN THE SOFTWARE.
// *
// * Except as contained in this notice, the name of Maxim Integrated
// * Products, Inc. shall not be used except as stated in the Maxim Integrated
// * Products, Inc. Branding Policy.
// *
// * The mere transfer of this software does not imply any licenses
// * of trade secrets, proprietary technology, copyrights, patents,
// * trademarks, maskwork rights, or any other form of intellectual
// * property whatsoever. Maxim Integrated Products, Inc. retains all
// * ownership rights.
// *******************************************************************************
// */
//---------- CODE GENERATOR: helloCppCodeList
// CODE GENERATOR: example code includes

// example code includes
// standard include for target platform -- Platform_Include_Boilerplate
#include "mbed.h"
// Platforms:
//   - MAX32625MBED
//      - supports mbed-os-5.11, requires USBDevice library
//      - add https://developer.mbed.org/teams/MaximIntegrated/code/USBDevice/
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - MAX32600MBED
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//      - Windows 10 note:  Don't connect HDK until you are ready to load new firmware into the board.
//   - NUCLEO_F446RE
//      - remove USBDevice library
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - NUCLEO_F401RE
//      - remove USBDevice library
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - MAX32630FTHR
//      - #include "max32630fthr.h"
//      - add http://os.mbed.org/teams/MaximIntegrated/code/max32630fthr/
//      - remove MAX32620FTHR library (if present)
//   - MAX32620FTHR
//      - #include "MAX32620FTHR.h"
//      - remove max32630fthr library (if present)
//      - add https://os.mbed.com/teams/MaximIntegrated/code/MAX32620FTHR/
//      - not tested yet
//   - MAX32625PICO
//      - #include "max32625pico.h"
//      - add https://os.mbed.com/users/switches/code/max32625pico/
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//      - not tested yet
//      - see https://os.mbed.com/users/switches/code/max32625pico/
//      - see https://os.mbed.com/users/switches/code/PICO_board_demo/
//      - see https://os.mbed.com/users/switches/code/PICO_USB_I2C_SPI/
//      - see https://os.mbed.com/users/switches/code/SerialInterface/
//      - Note: To load the MAX32625PICO firmware, hold the button while
//        connecting the USB cable, then copy firmware bin file 
//        to the MAINTENANCE drive.
//      - see https://os.mbed.com/platforms/MAX32625PICO/
//      - see https://os.mbed.com/teams/MaximIntegrated/wiki/MAX32625PICO-Firmware-Updates
//
// end Platform_Include_Boilerplate
#include "MAX11410.h"

// example code board support
//MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);
//DigitalOut rLED(LED1);
//DigitalOut gLED(LED2);
//DigitalOut bLED(LED3);
//
// Arduino "shield" connector port definitions (MAX32625MBED shown)
#if defined(TARGET_MAX32625MBED)
#define A0 AIN_0
#define A1 AIN_1
#define A2 AIN_2
#define A3 AIN_3
#define D0 P0_0
#define D1 P0_1
#define D2 P0_2
#define D3 P0_3
#define D4 P0_4
#define D5 P0_5
#define D6 P0_6
#define D7 P0_7
#define D8 P1_4
#define D9 P1_5
#define D10 P1_3
#define D11 P1_1
#define D12 P1_2
#define D13 P1_0
#elif defined(TARGET_MAX32625PICO)
#warning "TARGET_MAX32625PICO not previously tested; need to define pins..."
#define A0 AIN_1
#define A1 AIN_2
// #define A2 AIN_3
// #define A3 AIN_0
#define D0 P0_0
#define D1 P0_1
#define D2 P0_2
#define D3 P0_3
#define D4 P1_7
#define D5 P1_6
#define D6 P4_4
#define D7 P4_5
#define D8 P4_6
#define D9 P4_7
#define D10 P0_7
#define D11 P0_6
#define D12 P0_5
#define D13 P0_4
#endif

// example code declare SPI interface (GPIO controlled CS)
#if defined(TARGET_MAX32625MBED)
SPI spi(SPI1_MOSI, SPI1_MISO, SPI1_SCK); // mosi, miso, sclk spi1 TARGET_MAX32625MBED: P1_1 P1_2 P1_0 Arduino 10-pin header D11 D12 D13
DigitalOut spi_cs(SPI1_SS); // TARGET_MAX32625MBED: P1_3 Arduino 10-pin header D10
#elif defined(TARGET_MAX32625PICO)
#warning "TARGET_MAX32625PICO not previously tested; need to define pins..."
SPI spi(SPI0_MOSI, SPI0_MISO, SPI0_SCK); // mosi, miso, sclk spi1 TARGET_MAX32625PICO: pin P0_5 P0_6 P0_4
DigitalOut spi_cs(SPI0_SS); // TARGET_MAX32625PICO: pin P0_7
#elif defined(TARGET_MAX32600MBED)
SPI spi(SPI2_MOSI, SPI2_MISO, SPI2_SCK); // mosi, miso, sclk spi1 TARGET_MAX32600MBED: Arduino 10-pin header D11 D12 D13
DigitalOut spi_cs(SPI2_SS); // Generic: Arduino 10-pin header D10
#elif defined(TARGET_NUCLEO_F446RE) || defined(TARGET_NUCLEO_F401RE)
// TODO1: avoid resource conflict between P5_0, P5_1, P5_2 SPI and DigitalInOut
// void spi_init(spi_t *obj, PinName mosi, PinName miso, PinName sclk, PinName ssel)
//
// TODO1: NUCLEO_F446RE SPI not working; CS and MOSI data looks OK but no SCLK clock pulses.
SPI spi(SPI_MOSI, SPI_MISO, SPI_SCK); // mosi, miso, sclk spi1 TARGET_NUCLEO_F446RE: Arduino 10-pin header D11 D12 D13
DigitalOut spi_cs(SPI_CS); // TARGET_NUCLEO_F446RE: PB_6 Arduino 10-pin header D10
//
#else
SPI spi(D11, D12, D13); // mosi, miso, sclk spi1 TARGET_MAX32600MBED: Arduino 10-pin header D11 D12 D13
DigitalOut spi_cs(D10); // Generic: Arduino 10-pin header D10
#endif

// example code declare GPIO interface pins
// example code declare device instance
MAX11410 g_MAX11410_device(spi, spi_cs, MAX11410::MAX11410_IC);

// CODE GENERATOR: example code for ADC: serial port declaration
//--------------------------------------------------
// Declare the Serial driver
// default baud rate settings are 9600 8N1
// install device driver from http://developer.mbed.org/media/downloads/drivers/mbedWinSerial_16466.exe
// see docs https://docs.mbed.com/docs/mbed-os-handbook/en/5.5/getting_started/what_need/
#if defined(TARGET_MAX32630)
    #include "USBSerial.h"
// Hardware serial port over DAPLink
// The default baud rate for the DapLink UART is 9600
//Serial DAPLINKserial(P2_1, P2_0);     // tx, rx
//    #define HAS_DAPLINK_SERIAL 1
// Virtual serial port over USB
// The baud rate does not affect the virtual USBSerial UART.
USBSerial serial;
//--------------------------------------------------
#elif defined(TARGET_MAX32625MBED)
    #include "USBSerial.h"
// Hardware serial port over DAPLink
// The default baud rate for the DapLink UART is 9600
//Serial DAPLINKserial(P2_1, P2_0);     // tx, rx
//    #define HAS_DAPLINK_SERIAL 1
// Virtual serial port over USB
// The baud rate does not affect the virtual USBSerial UART.
USBSerial serial;
//--------------------------------------------------
#elif defined(TARGET_MAX32600)
    #include "USBSerial.h"
// Hardware serial port over DAPLink
// The default baud rate for the DapLink UART is 9600
Serial DAPLINKserial(P1_1, P1_0);     // tx, rx
    #define HAS_DAPLINK_SERIAL 1
// Virtual serial port over USB
// The baud rate does not affect the virtual USBSerial UART.
USBSerial serial;
//--------------------------------------------------
#elif defined(TARGET_NUCLEO_F446RE) || defined(TARGET_NUCLEO_F401RE)
Serial serial(SERIAL_TX, SERIAL_RX);     // tx, rx
//--------------------------------------------------
#else
#if defined(SERIAL_TX)
#warning "target not previously tested; guess serial pins are SERIAL_TX, SERIAL_RX..."
Serial serial(SERIAL_TX, SERIAL_RX);     // tx, rx
#elif defined(USBTX)
#warning "target not previously tested; guess serial pins are USBTX, USBRX..."
Serial serial(USBTX, USBRX);     // tx, rx
#elif defined(UART_TX)
#warning "target not previously tested; guess serial pins are UART_TX, UART_RX..."
Serial serial(UART_TX, UART_RX);     // tx, rx
#else
#warning "target not previously tested; need to define serial pins..."
#endif
#endif
//
#include "CmdLine.h"
CmdLine cmdLine(serial, "serial");

// example code main function
int main()
{
    // setup: put your setup code here, to run once

    // example code: serial port banner message
    wait(3); // 3000ms timing delay function, platform-specific
    cmdLine.serial().printf("\r\nHello_MAX11410\r\n");

    // CODE GENERATOR: example code: member function Init
    // Initialize MAX11410 and verify device ID
    uint32_t g_SPI_SCLK_Hz = 24000000; // platform limit 24MHz intSPI_SCLK_Platform_Max_MHz * 1000000
    if (g_MAX11410_device.Init() == 0)
    {  // init failed; try "safe mode" SPI at slower SCLK rate
        cmdLine.serial().printf("\r\nMAX11410 Init failed; retry at SPI SCLK frequency 2000000 Hz\r\n");

        g_SPI_SCLK_Hz = 2000000;
        g_MAX11410_device.spi_frequency(2000000);
        g_MAX11410_device.Init();
    }
    // CODE GENERATOR: get spi properties from device
    if (g_SPI_SCLK_Hz > g_MAX11410_device.get_spi_frequency())
    {  // Device limits SPI SCLK frequency
        g_SPI_SCLK_Hz = g_MAX11410_device.get_spi_frequency();
        cmdLine.serial().printf("\r\nMAX11410 limits SPI SCLK frequency to %ld Hz\r\n", g_SPI_SCLK_Hz);

        g_MAX11410_device.Init();
    }
    if (g_MAX11410_device.get_spi_frequency() > g_SPI_SCLK_Hz)
    {  // Platform limits SPI SCLK frequency
        g_MAX11410_device.spi_frequency(g_SPI_SCLK_Hz);
        cmdLine.serial().printf("\r\nPlatform limits MAX11410 SPI SCLK frequency to %ld Hz\r\n", g_SPI_SCLK_Hz);

        g_MAX11410_device.Init();
    }
    // g_SPI_dataMode = g_MAX11410_device.get_spi_dataMode();
    while (g_MAX11410_device.Init() == 0)
    {
        wait(3); // 3000ms timing delay function, platform-specific
        cmdLine.serial().printf("\r\nMAX11410 Init failed; retry...\r\n");

    }

    while (1)
    {
        // loop: put your main code here, to run repeatedly

        // CODE GENERATOR: example code: has no member function REF
        // CODE GENERATOR: example code for ADC: repeat-forever convert and print conversion result, one record per line
        // CODE GENERATOR: ResolutionBits = 24
        // CODE GENERATOR: FScode = 0xffffff
        // CODE GENERATOR: NumChannels = 10
        // CODE GENERATOR: banner before helloCppCodeList while(1)
        cmdLine.serial().printf("v_filter = 0x%2.2x\r\n", g_MAX11410_device.v_filter);

        cmdLine.serial().printf("v_pga = 0x%2.2x\r\n", g_MAX11410_device.v_pga);

        cmdLine.serial().printf("v_ctrl = 0x%2.2x\r\n", g_MAX11410_device.v_ctrl);

        // banner for csv data columns
        cmdLine.serial().printf("\"AIN0_LSB\",\"AIN1_LSB\",\"AIN2_LSB\",\"AIN3_LSB\",\"AIN4_LSB\",\"AIN5_LSB\",\"AIN6_LSB\",\"AIN7_LSB\",\"AIN8_LSB\",\"AIN9_LSB\"");

        cmdLine.serial().printf("\r\n");

        while(1) { // this code repeats forever
            // this code repeats forever
            // CODE GENERATOR: example code: has no member function ScanStandardExternalClock
            // CODE GENERATOR: example code: has no member function ReadAINcode
            // CODE GENERATOR: example code: member function Read_All_Voltages
            // Measure ADC channels in sequence from AIN0 to channelNumber_0_9.
            // @param[in] g_MAX11410_device.channelNumber_0_15: AIN Channel Number
            // @param[in] g_MAX11410_device.PowerManagement_0_2: 0=Normal, 1=AutoShutdown, 2=AutoStandby
            // @param[in] g_MAX11410_device.chan_id_0_1: ADC_MODE_CONTROL.CHAN_ID
            int channelId_0_9 = 9;
            //g_MAX11410_device.channelNumber_0_15 = channelId_0_9;
            //g_MAX11410_device.PowerManagement_0_2 = 0;
            //g_MAX11410_device.chan_id_0_1 = 1;
            g_MAX11410_device.Read_All_Voltages();

            // wait(3.0);
            // CODE GENERATOR: print conversion result
            // Use Arduino Serial Plotter to view output: Tools | Serial Plotter
            cmdLine.serial().printf("%d", g_MAX11410_device.AINcode[0]);
            for (int index = 1; index <= channelId_0_9; index++) {
                cmdLine.serial().printf(",%d", g_MAX11410_device.AINcode[index]);
            }
            cmdLine.serial().printf("\r\n");

        } // this code repeats forever
    }
}
//---------- CODE GENERATOR: end helloCppCodeList
