// /*******************************************************************************
// * Copyright (C) 2020 Maxim Integrated Products, Inc., All Rights Reserved.
// *
// * Permission is hereby granted, free of charge, to any person obtaining a
// * copy of this software and associated documentation files (the "Software"),
// * to deal in the Software without restriction, including without limitation
// * the rights to use, copy, modify, merge, publish, distribute, sublicense,
// * and/or sell copies of the Software, and to permit persons to whom the
// * Software is furnished to do so, subject to the following conditions:
// *
// * The above copyright notice and this permission notice shall be included
// * in all copies or substantial portions of the Software.
// *
// * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
// * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// * OTHER DEALINGS IN THE SOFTWARE.
// *
// * Except as contained in this notice, the name of Maxim Integrated
// * Products, Inc. shall not be used except as stated in the Maxim Integrated
// * Products, Inc. Branding Policy.
// *
// * The mere transfer of this software does not imply any licenses
// * of trade secrets, proprietary technology, copyrights, patents,
// * trademarks, maskwork rights, or any other form of intellectual
// * property whatsoever. Maxim Integrated Products, Inc. retains all
// * ownership rights.
// *******************************************************************************
// */
// *********************************************************************
// @file MAX11410.cpp
// *********************************************************************
// Device Driver file
// DO NOT EDIT; except areas designated "CUSTOMIZE". Automatically generated file.
// generated by XMLSystemOfDevicesToMBED.py
// System Name = ExampleSystem
// System Description = Device driver example

#include "MAX11410.h"

// Device Name = MAX11410
// Device Description = 1.9ksps, Low-Power, Serial SPI 24-Bit, 10-Channel, Differential/Single-Ended Input, SAR ADC
// Device DeviceBriefDescription = 24-bit 1.9ksps Delta-Sigma ADC
// Device Manufacturer = Maxim Integrated
// Device PartNumber = MAX11410ATI+
// Device RegValue_Width = DataWidth16bit_HL
//
// ADC MaxOutputDataRate = 1.9ksps
// ADC NumChannels = 10
// ADC ResolutionBits = 24
//
// SPI CS = ActiveLow
// SPI FrameStart = CS
// SPI CPOL = 0
// SPI CPHA = 0
// SPI MOSI and MISO Data are both stable on Rising edge of SCLK
// SPI SCLK Idle Low
// SPI SCLKMaxMHz = 8
// SPI SCLKMinMHz = 0
//

// CODE GENERATOR: class constructor definition
MAX11410::MAX11410(SPI &spi, DigitalOut &cs_pin, // SPI interface
                 // CODE GENERATOR: class constructor definition gpio InputPin pins
                 // CODE GENERATOR: class constructor definition gpio OutputPin pins
                 // CODE GENERATOR: class constructor definition ic_variant
                 MAX11410_ic_t ic_variant)
    // CODE GENERATOR: class constructor initializer list
    : m_spi(spi), m_cs_pin(cs_pin), // SPI interface
    // CODE GENERATOR: class constructor initializer list gpio InputPin pins
    // CODE GENERATOR: class constructor initializer list gpio OutputPin pins
    // CODE GENERATOR: class constructor initializer list ic_variant
    m_ic_variant(ic_variant)
{
    // CODE GENERATOR: class constructor definition SPI interface initialization
    //
    // SPI CS = ActiveLow
    // SPI FrameStart = CS
    m_SPI_cs_state = 1;
    if (m_cs_pin.is_connected()) { // avoid mbed runtime error if pin is NC not connected
        m_cs_pin = m_SPI_cs_state;
    }

    // SPI CPOL = 0
    // SPI CPHA = 0
    // SPI MOSI and MISO Data are both stable on Rising edge of SCLK
    // SPI SCLK Idle Low
    m_SPI_dataMode = 0; //SPI_MODE0; // CPOL=0,CPHA=0: Rising Edge stable; SCLK idle Low
    m_spi.format(8,m_SPI_dataMode);         // int bits_must_be_8, int mode=0_3 CPOL=0,CPHA=0

    // SPI SCLKMaxMHz = 8
    // SPI SCLKMinMHz = 0
    //#define SPI_SCLK_Hz 48000000 // 48MHz
    //#define SPI_SCLK_Hz 24000000 // 24MHz
    //#define SPI_SCLK_Hz 12000000 // 12MHz
    //#define SPI_SCLK_Hz 6000000 // 6MHz
    //#define SPI_SCLK_Hz 4000000 // 4MHz
    //#define SPI_SCLK_Hz 2000000 // 2MHz
    //#define SPI_SCLK_Hz 1000000 // 1MHz
    m_SPI_SCLK_Hz = 8000000; // 8MHz; MAX11410 limit is 8MHz
    m_spi.frequency(m_SPI_SCLK_Hz);

}

// CODE GENERATOR: class destructor definition
MAX11410::~MAX11410()
{
    // do nothing
}

// CODE GENERATOR: spi_frequency setter definition
/// set SPI SCLK frequency
void MAX11410::spi_frequency(int spi_sclk_Hz)
{
    m_SPI_SCLK_Hz = spi_sclk_Hz;
    m_spi.frequency(m_SPI_SCLK_Hz);
}

// CODE GENERATOR: omit global g_MAX11410_device
// CODE GENERATOR: extern function declarations
// CODE GENERATOR: extern function requirement MAX11410::SPIoutputCS
// Assert SPI Chip Select
// SPI chip-select for MAX11410
//
inline void MAX11410::SPIoutputCS(int isLogicHigh)
{
    // CODE GENERATOR: extern function definition for function SPIoutputCS
    // CODE GENERATOR: extern function definition for standard SPI interface function SPIoutputCS(int isLogicHigh)
    m_SPI_cs_state = isLogicHigh;
    if (m_cs_pin.is_connected()) { // avoid mbed runtime error if pin is NC not connected
        m_cs_pin = m_SPI_cs_state;
    }
}

// CODE GENERATOR: extern function requirement MAX11410::SPIwrite16bits
// SPI write 16 bits
// SPI interface to MAX11410 shift 16 bits mosiData into MAX11410 DIN
//
void MAX11410::SPIwrite16bits(int16_t mosiData16)
{
    // CODE GENERATOR: extern function definition for function SPIwrite16bits
    // TODO1: CODE GENERATOR: extern function definition for standard SPI interface function SPIwrite16bits(int16_t mosiData16)
    size_t byteCount = 2;
    static char mosiData[2];
    static char misoData[2];
    mosiData[0] = (char)((mosiData16 >> 8) & 0xFF); // MSByte
    mosiData[1] = (char)((mosiData16 >> 0) & 0xFF); // LSByte
    //
    // Arduino: begin critical section: noInterrupts() masks all interrupt sources; end critical section with interrupts()
    //~ noInterrupts();
    //
    //~ digitalWrite(Scope_Trigger_Pin, LOW); // diagnostic Scope_Trigger_Pin
    //
    unsigned int numBytesTransferred = m_spi.write(mosiData, byteCount, misoData, byteCount);
    //~ m_spi.transfer(mosiData8_FF0000);
    //~ m_spi.transfer(mosiData16_00FF00);
    //~ m_spi.transfer(mosiData16_0000FF);
    //
    //~ digitalWrite(Scope_Trigger_Pin, HIGH); // diagnostic Scope_Trigger_Pin
    //
    // Arduino: begin critical section: noInterrupts() masks all interrupt sources; end critical section with interrupts()
    //~ interrupts();
    // Optional Diagnostic function to print SPI transactions
    if (onSPIprint)
    {
        onSPIprint(byteCount, (uint8_t*)mosiData, (uint8_t*)misoData);
    }
    //
    // VERIFY: SPIwrite24bits print diagnostic information
    //cmdLine.serial().printf(" MOSI->"));
    //cmdLine.serial().printf(" 0x"));
    //Serial.print( (mosiData8_FF0000 & 0xFF), HEX);
    //cmdLine.serial().printf(" 0x"));
    //Serial.print( (mosiData16_00FF00 & 0xFF), HEX);
    //cmdLine.serial().printf(" 0x"));
    //Serial.print( (mosiData16_0000FF & 0xFF), HEX);
    // hex dump mosiData[0..byteCount-1]
#if 0 // HAS_MICROUSBSERIAL
    cmdLine_microUSBserial.serial().printf("\r\nSPI");
    if (byteCount > 7) {
        cmdLine_microUSBserial.serial().printf(" byteCount:%d", byteCount);
    }
    cmdLine_microUSBserial.serial().printf(" MOSI->");
    for (unsigned int byteIndex = 0; byteIndex < byteCount; byteIndex++)
    {
        cmdLine_microUSBserial.serial().printf(" 0x%2.2X", mosiData[byteIndex]);
    }
    // hex dump misoData[0..byteCount-1]
    cmdLine_microUSBserial.serial().printf(" MISO<-");
    for (unsigned int byteIndex = 0; byteIndex < numBytesTransferred; byteIndex++)
    {
        cmdLine_microUSBserial.serial().printf(" 0x%2.2X", misoData[byteIndex]);
    }
    cmdLine_microUSBserial.serial().printf(" ");
#endif
#if 0 // HAS_DAPLINK_SERIAL
    cmdLine_DAPLINKserial.serial().printf("\r\nSPI");
    if (byteCount > 7) {
        cmdLine_DAPLINKserial.serial().printf(" byteCount:%d", byteCount);
    }
    cmdLine_DAPLINKserial.serial().printf(" MOSI->");
    for (unsigned int byteIndex = 0; byteIndex < byteCount; byteIndex++)
    {
        cmdLine_DAPLINKserial.serial().printf(" 0x%2.2X", mosiData[byteIndex]);
    }
    // hex dump misoData[0..byteCount-1]
    cmdLine_DAPLINKserial.serial().printf(" MISO<-");
    for (unsigned int byteIndex = 0; byteIndex < numBytesTransferred; byteIndex++)
    {
        cmdLine_DAPLINKserial.serial().printf(" 0x%2.2X", misoData[byteIndex]);
    }
    cmdLine_DAPLINKserial.serial().printf(" ");
#endif
    // VERIFY: DIAGNOSTIC: print MAX5715 device register write
    // TODO: MAX5715_print_register_verbose(mosiData8_FF0000, mosiData16_00FFFF);
    // TODO: print_verbose_SPI_diagnostic(mosiData16_FF00, mosiData16_00FF, misoData16_FF00, misoData16_00FF);
    //
    // int misoData16 = (misoData16_FF00 << 8) | misoData16_00FF;
    // return misoData16;
}

// CODE GENERATOR: extern function requirement MAX11410::SPIreadWrite16bits
// SPI read and write 16 bits
// SPI interface to MAX11410 shift 16 bits mosiData16 into MAX11410 DIN
// while simultaneously capturing 16 bits miso data from MAX11410 DOUT
//
int16_t MAX11410::SPIreadWrite16bits(int16_t mosiData16)
{
    // CODE GENERATOR: extern function definition for function SPIreadWrite16bits
    // TODO1: CODE GENERATOR: extern function definition for standard SPI interface function SPIreadWrite16bits(int16_t mosiData16)
    size_t byteCount = 2;
    static char mosiData[2];
    static char misoData[2];
    mosiData[0] = (char)((mosiData16 >> 8) & 0xFF); // MSByte
    mosiData[1] = (char)((mosiData16 >> 0) & 0xFF); // LSByte
    //
    // Arduino: begin critical section: noInterrupts() masks all interrupt sources; end critical section with interrupts()
    //~ noInterrupts();
    //
    //~ digitalWrite(Scope_Trigger_Pin, LOW); // diagnostic Scope_Trigger_Pin
    //
    unsigned int numBytesTransferred = m_spi.write(mosiData, byteCount, misoData, byteCount);
    //~ m_spi.transfer(mosiData8_FF0000);
    //~ m_spi.transfer(mosiData16_00FF00);
    //~ m_spi.transfer(mosiData16_0000FF);
    //
    //~ digitalWrite(Scope_Trigger_Pin, HIGH); // diagnostic Scope_Trigger_Pin
    //
    // Arduino: begin critical section: noInterrupts() masks all interrupt sources; end critical section with interrupts()
    //~ interrupts();
    // Optional Diagnostic function to print SPI transactions
    if (onSPIprint)
    {
        onSPIprint(byteCount, (uint8_t*)mosiData, (uint8_t*)misoData);
    }
    //
    // VERIFY: SPIwrite24bits print diagnostic information
    //cmdLine.serial().printf(" MOSI->"));
    //cmdLine.serial().printf(" 0x"));
    //Serial.print( (mosiData8_FF0000 & 0xFF), HEX);
    //cmdLine.serial().printf(" 0x"));
    //Serial.print( (mosiData16_00FF00 & 0xFF), HEX);
    //cmdLine.serial().printf(" 0x"));
    //Serial.print( (mosiData16_0000FF & 0xFF), HEX);
    // hex dump mosiData[0..byteCount-1]
#if 0 // HAS_MICROUSBSERIAL
    cmdLine_microUSBserial.serial().printf("\r\nSPI");
    if (byteCount > 7) {
        cmdLine_microUSBserial.serial().printf(" byteCount:%d", byteCount);
    }
    cmdLine_microUSBserial.serial().printf(" MOSI->");
    for (unsigned int byteIndex = 0; byteIndex < byteCount; byteIndex++)
    {
        cmdLine_microUSBserial.serial().printf(" 0x%2.2X", mosiData[byteIndex]);
    }
    // hex dump misoData[0..byteCount-1]
    cmdLine_microUSBserial.serial().printf(" MISO<-");
    for (unsigned int byteIndex = 0; byteIndex < numBytesTransferred; byteIndex++)
    {
        cmdLine_microUSBserial.serial().printf(" 0x%2.2X", misoData[byteIndex]);
    }
    cmdLine_microUSBserial.serial().printf(" ");
#endif
#if 0 // HAS_DAPLINK_SERIAL
    cmdLine_DAPLINKserial.serial().printf("\r\nSPI");
    if (byteCount > 7) {
        cmdLine_DAPLINKserial.serial().printf(" byteCount:%d", byteCount);
    }
    cmdLine_DAPLINKserial.serial().printf(" MOSI->");
    for (unsigned int byteIndex = 0; byteIndex < byteCount; byteIndex++)
    {
        cmdLine_DAPLINKserial.serial().printf(" 0x%2.2X", mosiData[byteIndex]);
    }
    // hex dump misoData[0..byteCount-1]
    cmdLine_DAPLINKserial.serial().printf(" MISO<-");
    for (unsigned int byteIndex = 0; byteIndex < numBytesTransferred; byteIndex++)
    {
        cmdLine_DAPLINKserial.serial().printf(" 0x%2.2X", misoData[byteIndex]);
    }
    cmdLine_DAPLINKserial.serial().printf(" ");
#endif
    // VERIFY: DIAGNOSTIC: print MAX5715 device register write
    // TODO: MAX5715_print_register_verbose(mosiData8_FF0000, mosiData16_00FFFF);
    // TODO: print_verbose_SPI_diagnostic(mosiData16_FF00, mosiData16_00FF, misoData16_FF00, misoData16_00FF);
    //
    //int misoData16 = (misoData16_FF00 << 8) | misoData16_00FF;
    int misoData16 = (misoData[0] << 8) | misoData[1];
    return misoData16;
}

// CODE GENERATOR: extern function requirement MAX11410::SPIreadWrite32bits
// SPI read and write 32 bits
// SPI interface to MAX11410 shift 32 bits mosiData into MAX11410 DIN
// while simultaneously capturing 32 bits miso data from MAX11410 DOUT
//
int32_t MAX11410::SPIreadWrite32bits(int32_t mosiData32)
{
    // CODE GENERATOR: extern function definition for function SPIreadWrite32bits
    // TODO1: CODE GENERATOR: extern function definition for standard SPI interface function SPIreadWrite32bits(int32_t mosiData32)
    size_t byteCount = 4;
    static char mosiData[4];
    static char misoData[4];
    mosiData[0] = (char)((mosiData32 >> 24) & 0xFF); // MSByte
    mosiData[1] = (char)((mosiData32 >> 16) & 0xFF);
    mosiData[2] = (char)((mosiData32 >>  8) & 0xFF);
    mosiData[3] = (char)((mosiData32 >>  0) & 0xFF); // LSByte
    //
    // Arduino: begin critical section: noInterrupts() masks all interrupt sources; end critical section with interrupts()
    //~ noInterrupts();
    //
    //~ digitalWrite(Scope_Trigger_Pin, LOW); // diagnostic Scope_Trigger_Pin
    //
    unsigned int numBytesTransferred = m_spi.write(mosiData, byteCount, misoData, byteCount);
    //~ m_spi.transfer(mosiData8_FF0000);
    //~ m_spi.transfer(mosiData16_00FF00);
    //~ m_spi.transfer(mosiData16_0000FF);
    //
    //~ digitalWrite(Scope_Trigger_Pin, HIGH); // diagnostic Scope_Trigger_Pin
    //
    // Arduino: begin critical section: noInterrupts() masks all interrupt sources; end critical section with interrupts()
    //~ interrupts();
    // Optional Diagnostic function to print SPI transactions
    if (onSPIprint)
    {
        onSPIprint(byteCount, (uint8_t*)mosiData, (uint8_t*)misoData);
    }
    //
    // VERIFY: SPIwrite24bits print diagnostic information
    //cmdLine.serial().printf(" MOSI->"));
    //cmdLine.serial().printf(" 0x"));
    //Serial.print( (mosiData8_FF0000 & 0xFF), HEX);
    //cmdLine.serial().printf(" 0x"));
    //Serial.print( (mosiData16_00FF00 & 0xFF), HEX);
    //cmdLine.serial().printf(" 0x"));
    //Serial.print( (mosiData16_0000FF & 0xFF), HEX);
    // hex dump mosiData[0..byteCount-1]
#if 0 // HAS_MICROUSBSERIAL
    cmdLine_microUSBserial.serial().printf("\r\nSPI");
    if (byteCount > 7) {
        cmdLine_microUSBserial.serial().printf(" byteCount:%d", byteCount);
    }
    cmdLine_microUSBserial.serial().printf(" MOSI->");
    for (unsigned int byteIndex = 0; byteIndex < byteCount; byteIndex++)
    {
        cmdLine_microUSBserial.serial().printf(" 0x%2.2X", mosiData[byteIndex]);
    }
    // hex dump misoData[0..byteCount-1]
    cmdLine_microUSBserial.serial().printf(" MISO<-");
    for (unsigned int byteIndex = 0; byteIndex < numBytesTransferred; byteIndex++)
    {
        cmdLine_microUSBserial.serial().printf(" 0x%2.2X", misoData[byteIndex]);
    }
    cmdLine_microUSBserial.serial().printf(" ");
#endif
#if 0 // HAS_DAPLINK_SERIAL
    cmdLine_DAPLINKserial.serial().printf("\r\nSPI");
    if (byteCount > 7) {
        cmdLine_DAPLINKserial.serial().printf(" byteCount:%d", byteCount);
    }
    cmdLine_DAPLINKserial.serial().printf(" MOSI->");
    for (unsigned int byteIndex = 0; byteIndex < byteCount; byteIndex++)
    {
        cmdLine_DAPLINKserial.serial().printf(" 0x%2.2X", mosiData[byteIndex]);
    }
    // hex dump misoData[0..byteCount-1]
    cmdLine_DAPLINKserial.serial().printf(" MISO<-");
    for (unsigned int byteIndex = 0; byteIndex < numBytesTransferred; byteIndex++)
    {
        cmdLine_DAPLINKserial.serial().printf(" 0x%2.2X", misoData[byteIndex]);
    }
    cmdLine_DAPLINKserial.serial().printf(" ");
#endif
    // VERIFY: DIAGNOSTIC: print MAX5715 device register write
    // TODO: MAX5715_print_register_verbose(mosiData8_FF0000, mosiData16_00FFFF);
    // TODO: print_verbose_SPI_diagnostic(mosiData16_FF00, mosiData16_00FF, misoData16_FF00, misoData16_00FF);
    //
    //int misoData32 = (misoData32_FF000000 << 24) | (misoData32_FF0000 << 16) | (misoData32_0000FF00 << 8) | misoData32_000000FF;
    int misoData32 = (misoData[0] << 24) | (misoData[1] << 16) | (misoData[2] << 8) | misoData[3];
    return misoData32;
}

// CODE GENERATOR: class member function definitions
//----------------------------------------
// Menu item '!'
// Initialize device
//
// @test Init() expect 1
//
// @test group POR // verify initial register values
// @test group PORverbose // verify initial register values
// @test group PORverbose tinyTester.print("PART_ID value")
// @test group POR RegRead(MAX11410::CMD_r001_0001_xxxx_xxxx_xxxx_xxxx_xxxx_xddd_PART_ID, buffer) expect 1 expect-buffer 0x000F02
//
// @test group PORverbose tinyTester.print("POR value 0x04 CMD_r000_0100_dddd_xddd_GP0_CTRL")
// @test group POR RegRead(MAX11410::CMD_r000_0100_dddd_xddd_GP0_CTRL, buffer) expect 1 expect-buffer 0x00
//
// @test group PORverbose tinyTester.print("POR value 0x05 CMD_r000_0101_dddd_xddd_GP1_CTRL")
// @test group POR RegRead(MAX11410::CMD_r000_0101_dddd_xddd_GP1_CTRL, buffer) expect 1 expect-buffer 0x00
//
// @test group PORverbose tinyTester.print("POR value 0x07 CMD_r000_0111_xddd_dddd_GP_SEQ_ADDR")
// @test group POR RegRead(MAX11410::CMD_r000_0111_xddd_dddd_GP_SEQ_ADDR, buffer) expect 1 expect-buffer 0x00003a
//
// @test group PORverbose tinyTester.print("POR value 0x08 CMD_r000_1000_x0dd_dddd_FILTER")
// @test group POR RegRead(MAX11410::CMD_r000_1000_x0dd_dddd_FILTER, buffer) expect 1 expect-buffer 0x00
//
// @test group PORverbose tinyTester.print("POR value 0x09 CMD_r000_1001_dddd_dddd_CTRL")
// @test group POR RegRead(MAX11410::CMD_r000_1001_dddd_dddd_CTRL, buffer) expect 1 expect-buffer 0x000001
//
// @test group PORverbose tinyTester.print("POR value 0x0a CMD_r000_1010_dddd_dddd_SOURCE")
// @test group POR RegRead(MAX11410::CMD_r000_1010_dddd_dddd_SOURCE, buffer) expect 1 expect-buffer 0x00
//
// @test group PORverbose tinyTester.print("POR value 0x0b CMD_r000_1011_dddd_dddd_MUX_CTRL0")
// @test group POR RegRead(MAX11410::CMD_r000_1011_dddd_dddd_MUX_CTRL0, buffer) expect 1 expect-buffer 0x0000ff
//
// @test group PORverbose tinyTester.print("POR value 0x0c CMD_r000_1100_dddd_dddd_MUX_CTRL1")
// @test group POR RegRead(MAX11410::CMD_r000_1100_dddd_dddd_MUX_CTRL1, buffer) expect 1 expect-buffer 0x0000ff
//
// @test group PORverbose tinyTester.print("POR value 0x0d CMD_r000_1101_dddd_dddd_MUX_CTRL2")
// @test group POR RegRead(MAX11410::CMD_r000_1101_dddd_dddd_MUX_CTRL2, buffer) expect 1 expect-buffer 0x00
//
// @test group PORverbose tinyTester.print("POR value 0x0e CMD_r000_1110_00ss_0ggg_PGA")
// @test group POR RegRead(MAX11410::CMD_r000_1110_00ss_0ggg_PGA, buffer) expect 1 expect-buffer 0x00
//
// @future test     CMD_r000_1111_dddd_dddd_WAIT_EXT = 0x0f, //!< 0b0001111
// @future test     CMD_r001_0000_xxxx_xxxx_WAIT_START = 0x10, //!< 0b0010000
//
// @test group RES1KA2A3TOGND // measure a 1kohm resistor between (AIN2,AIN3) and AGND to verify ref2_v (disabled by default)
// @test group RES1KA2A3TOGNDMORE // measure a 1kohm resistor between (AIN2,AIN3) and AGND to verify ref2_v in more detail
// @test group RES1KA2A3TOGNDMORE tinyTester.print("measure a 1kohm resistor between (AIN2,AIN3) and AGND to verify ref2_v")
// @test group RES1KA2A3TOGND tinyTester.settle_time_msec = 1000 // default 250
// @test group RES1KA2A3TOGND RegWrite(0x0C, 0xF3) expect 1 // *mux_ctrl1=0xf3 drives current source from AIN3
//
// @test group RES1KA2A3TOGNDMORE RegWrite(0x0A, 0x03) expect 1 // *source=0x03 idac_mode=100uA, 1k resistor 0.1V
// @test group RES1KA2A3TOGNDMORE tinyTester.print("idac_mode=100uA, 1k resistor 0.1V")
// @test group RES1KA2A3TOGNDMORE tinyTester.Wait_Output_Settling()
// @test group RES1KA2A3TOGNDMORE Measure_Voltage(2,10) expect 0.1
// @test group RES1KA2A3TOGNDMORE AINcode[2] expect (uint32_t)337731 within 33773 // idac_mode=100uA, 1k resistor 0.1V
//
// @test group RES1KA2A3TOGNDMORE RegWrite(0x0A, 0x0D) expect 1 // *source=0x0d idac_mode=800uA, 1k resistor 0.8V
// @test group RES1KA2A3TOGNDMORE tinyTester.print("idac_mode=800uA, 1k resistor 0.8V")
// @test group RES1KA2A3TOGNDMORE tinyTester.Wait_Output_Settling()
// @test group RES1KA2A3TOGNDMORE Measure_Voltage(2,10) expect 0.8
// @test group RES1KA2A3TOGNDMORE AINcode[2] expect (uint32_t)2724467 within 33773 // idac_mode=800uA, 1k resistor 0.8V
//
// @test group RES1KA2A3TOGND RegWrite(0x0A, 0x0B) expect 1 // *source=0x0b idac_mode=400uA, 1k resistor 0.4V
// @test group RES1KA2A3TOGNDMORE tinyTester.print("idac_mode=400uA, 1k resistor 0.4V")
// @test group RES1KA2A3TOGND tinyTester.Wait_Output_Settling()
// @test group RES1KA2A3TOGND Measure_Voltage(2,10) expect 0.4
// @test group RES1KA2A3TOGNDMORE AINcode[2] expect (uint32_t)1343163 within 33773 // idac_mode=400uA, 1k resistor 0.4V
//
// @test tinyTester.print("check filter register is writeable")
// @future test tinyTester.print("this is a real mess dealing with the custom types")
// @test RegWrite(0x08, 0x34) expect 1
// @future test tinyTester.print("error: no matching function for call to 'MaximTinyTester::FunctionCall_Expect(const char [18], uint8_t (&)(MAX11410::CMD_enum_t, uint32_t), MAX11410::CMD_enum_t, uint32_t, int)'")
// @future test RegWrite(CMD_r000_1000_x0dd_dddd_FILTER, 0x34) expect 1
// @future test RegWrite(CMD_enum_t::CMD_r000_1000_x0dd_dddd_FILTER, 0x34) expect 1
// @future test RegWrite(MAX11410::CMD_enum_t::CMD_r000_1000_x0dd_dddd_FILTER, 0x34) expect 1
//
// @test tinyTester.print("check filter register is readable")
// @test RegRead(0x08, buffer) expect 1 expect-buffer 0x34
// @future test RegRead(MAX11410::CMD_enum_t::CMD_r000_1000_x0dd_dddd_FILTER, &buffer) expect 1 expect-buffer 0x34
//
// @test tinyTester.settle_time_msec = 250 // default 250
// @test tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
// @test tinyTester.input_timeout_time_msec = 250 // default 250
// @test tinyTester.settle_time_msec = 20 // default 250
// @test tinyTester.blink_time_msec = 20 // quickly speed through the software verification
// @test tinyTester.input_timeout_time_msec = 100 // default 250
//
// @test tinyTester.Wait_Output_Settling()
//
// @future test tinyTester.DigitalIn_Read_Expect_WarnOnly(DigitalIn& digitalInPin, const char* pinName, int expect_result, const char *expect_description)
//
// @return 1 on success; 0 on failure
uint8_t MAX11410::Init(void)
{
    
    //----------------------------------------
    // AIN0-AIN1 reference voltage, in Volts
    ref0_v = 2.500;
    
    //----------------------------------------
    // REF1P-REF1N reference resistance, in Ohms
    ref1_v = 4999;
    
    //----------------------------------------
    // REF2P-REF2N reference voltage, in Volts
    ref2_v = 2.500;
    
    //----------------------------------------
    // AVDD-AGND supply voltage, in Volts
    avdd_v = 3.300;
    
    //----------------------------------------
    // RTD Resistance measurement; Thermocouple Cold Junction, in Ohms
    rtd_ohm = 1000.0;
    
    //----------------------------------------
    // Temperature calculated from RTD Resistance; Thermocouple Cold Junction, in degrees C
    rtd_degc = 25.0;
    
    //----------------------------------------
    // shadow of register ctrl CMD_r000_1001_dddd_dddd_CTRL
    ctrl = 0x01;
    
    //----------------------------------------
    // set by Configure_PGA gain index register pga CMD_r000_1110_00ss_0ggg_PGA
    pgaGain = 1;
    
    //----------------------------------------
    // When driver polls status of a pin signal or a register status bit,
    // and there is no device physically connected, the driver must
    // be able to halt and report failure if too many tries. Each attempt
    // counts down until loop_limit is reached or exceeded.
    //
    // If driver seems to hang or takes too long to decide that device
    // is not connected, reduce the futility countdown limit value.
    //
    // If driver sometimes works but sometimes intermittently fails to
    // recognize device is attached, increase the futility countdown limit.
    loop_limit = 30;
    
    //----------------------------------------
    // timing delay after enable RTD bias current in Measure_RTD()
    rtd_ms = 100;
    
    //----------------------------------------
    // filter register configuration in Measure_RTD() -- 0x34 LINEF_11_SINC4 RATE_0100 output data rate 60SPS
    rtd_filter = 0x34;
    
    //----------------------------------------
    // ctrl register configuration in Measure_RTD() -- 0x40 unipolar, 0x01 REF_SEL_001_REF1P_REF1N
    rtd_ctrl = 0x41;
    
    //----------------------------------------
    // source register configuration in Measure_RTD() -- 0x0B IDAC_MODE_1011_400uA
    rtd_source = 0x0B;
    
    //----------------------------------------
    // pga register configuration in Measure_RTD() -- 0x21 SIG_PATH_10_PGA GAIN_001_2
    rtd_pga = 0x21;
    
    //----------------------------------------
    // filter register configuration in Measure_Voltage() -- 0x34 LINEF_11_SINC4 RATE_0100 output data rate 60SPS
    v_filter = 0x34;
    
    //----------------------------------------
    // ctrl register configuration in Measure_Voltage() -- 0x02 bipolar REF_SEL_010_REF2P_REF2N
    v_ctrl = 0x02;
    
    //----------------------------------------
    // pga register configuration in Measure_Voltage() -- 0x00 SIG_PATH_00_BUFFERED GAIN_000_1
    v_pga = 0x00;
    
    //----------------------------------------
    // list of registers to be read by menu item * with no arguments
    static MAX11410::MAX11410_CMD_enum_t readAllStatusListValues[] = {
    MAX11410::CMD_r000_0000_xxxx_xxdd_PD,
    MAX11410::CMD_r000_0001_xddd_xxdd_CONV_START,
    MAX11410::CMD_r000_0010_xddd_dddd_SEQ_START,
    MAX11410::CMD_r000_0011_xxxx_xddd_CAL_START,
    MAX11410::CMD_r000_0100_dddd_xddd_GP0_CTRL,
    MAX11410::CMD_r000_0101_dddd_xddd_GP1_CTRL,
    MAX11410::CMD_r000_0110_xddd_xxdd_GP_CONV,
    MAX11410::CMD_r000_0111_xddd_dddd_GP_SEQ_ADDR,
    MAX11410::CMD_r000_1000_x0dd_dddd_FILTER,
    MAX11410::CMD_r000_1001_dddd_dddd_CTRL,
    MAX11410::CMD_r000_1010_dddd_dddd_SOURCE,
    MAX11410::CMD_r000_1011_dddd_dddd_MUX_CTRL0,
    MAX11410::CMD_r000_1100_dddd_dddd_MUX_CTRL1,
    MAX11410::CMD_r000_1101_dddd_dddd_MUX_CTRL2,
    MAX11410::CMD_r000_1110_00ss_0ggg_PGA,
    MAX11410::CMD_r000_1111_dddd_dddd_WAIT_EXT,
    MAX11410::CMD_r001_0000_xxxx_xxxx_WAIT_START,
    };
    readAllStatusList = readAllStatusListValues;
    
    //----------------------------------------
    // number of registers to be read by menu item * with no arguments
    readAllStatusListLen = 17;
    
    //----------------------------------------
    // Device ID Validation
    const uint32_t part_id_expect = 0x000F02;
    uint32_t part_id_readback;
    RegRead(CMD_r001_0001_xxxx_xxxx_xxxx_xxxx_xxxx_xddd_PART_ID, &part_id_readback);
    if (part_id_readback != part_id_expect) return 0;
    
    //----------------------------------------
    // write8 0x00 PD = 0x03 (Reset Registers; enter Standby mode)
    RegWrite(CMD_r000_0000_xxxx_xxdd_PD, PD_11_Reset);
    
    //----------------------------------------
    // write8 0x00 PD = 0x00 (NOP)
    RegWrite(CMD_r000_0000_xxxx_xxdd_PD, PD_00_Normal);
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Return the physical voltage corresponding to conversion result,
// for unipolar mode.
// Does not perform any offset or gain correction.
//
// @pre CTRL::U_BN = 1 -- Unipolar mode
// @pre CTRL::FORMAT = x
// @pre VRef = Voltage of REF input, in Volts
// @param[in] value_u24: raw 24-bit MAX11410 code (right justified).
// @return physical voltage corresponding to MAX11410 code.
//
// @test group UNIPOLAR // Verify function VoltageOfCode_Unipolar
// @test group UNIPOLAR tinyTester.blink_time_msec = 20 // quickly speed through the software verification
// @test group UNIPOLAR Configure_CTRL_REF(2) expect 1 // These tests require REF2 = 2.500V
// @test group UNIPOLAR Configure_PGA(0,0) expect 1 // These tests require PGA gain=1
// @test group UNIPOLAR VoltageOfCode_Unipolar(0xFFFFFF) expect 2.500 within 0.030 // Full Scale
// @test group UNIPOLAR VoltageOfCode_Unipolar(0xFFFFFE) expect 2.500              // Full Scale
// @test group UNIPOLAR VoltageOfCode_Unipolar(0xCCCCCC) expect 2.000              // Two Volts
// @test group UNIPOLAR VoltageOfCode_Unipolar(0xC00000) expect 1.875              // 75% Scale
// @test group UNIPOLAR VoltageOfCode_Unipolar(0x800000) expect 1.250              // Mid Scale
// @test group UNIPOLAR VoltageOfCode_Unipolar(0x666666) expect 1.000              // One Volt
// @test group UNIPOLAR VoltageOfCode_Unipolar(0x400000) expect 0.625              // 25% Scale
// @test group UNIPOLAR VoltageOfCode_Unipolar(0x0A3D70) expect 0.100              // 100mV
// @test group UNIPOLAR VoltageOfCode_Unipolar(0x000064) expect 0.000014901162     // 100 LSB
// @test group UNIPOLAR VoltageOfCode_Unipolar(0x00000A) expect 0.0000014901162    // Ten LSB
// @test group UNIPOLAR VoltageOfCode_Unipolar(0x000003) expect 0.00000044703483   // Three LSB
// @test group UNIPOLAR VoltageOfCode_Unipolar(0x000002) expect 0.00000029802326   // Two LSB
// @test group UNIPOLAR VoltageOfCode_Unipolar(0x000001) expect 0.00000014901162   // One LSB
// @test group UNIPOLAR VoltageOfCode_Unipolar(0x000000) expect 0.0                // Zero Scale
// @test group UNIPOLAR tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
//
double MAX11410::VoltageOfCode_Unipolar(uint32_t value_u24)
{
    
    //----------------------------------------
    // Linear map min and max endpoints
    double VRef = ref2_v;
    uint8_t ref_sel = (ctrl & 0x03); // MAX11410_REF_SEL_enum_t
    switch(ref_sel)
    {
    case REF_SEL_000_AIN0_AIN1:     VRef = ref0_v; break;
    case REF_SEL_001_REF1P_REF1N:   VRef = ref1_v; break;
    case REF_SEL_010_REF2P_REF2N:   VRef = ref2_v; break;
    case REF_SEL_011_AVDD_AGND:     VRef = avdd_v; break;
    case REF_SEL_100_AIN0_AGND:     VRef = ref0_v; break;
    case REF_SEL_101_REF1P_AGND:    VRef = ref1_v; break;
    case REF_SEL_110_REF2P_AGND:    VRef = ref2_v; break;
    case REF_SEL_111_AVDD_AGND:     VRef = avdd_v; break;
    }
    double MaxScaleVoltage = VRef; // voltage of maximum code 0xffffff
    double MinScaleVoltage = 0.0; // voltage of minimum code 0x000
    const uint32_t FULL_SCALE_CODE_24BIT = 0xffffff;
    const uint32_t MaxCode = FULL_SCALE_CODE_24BIT;
    const uint32_t MinCode = 0x000;
    double codeFraction = ((double)value_u24 - MinCode) / (MaxCode - MinCode + 1);
    return (MinScaleVoltage + ((MaxScaleVoltage - MinScaleVoltage) * codeFraction)) / pgaGain;
}

//----------------------------------------
// Return the physical voltage corresponding to conversion result,
// when conversion format is Bipolar mode, offset binary.
// Does not perform any offset or gain correction.
//
// @pre CTRL::U_BN = 0 -- Bipolar mode
// @pre CTRL::FORMAT = 1 -- offset binary
// @pre VRef = Voltage of REF input, in Volts
// @param[in] value_u24: raw 24-bit MAX11410 code (right justified).
// @return physical voltage corresponding to MAX11410 code.
//
// @test group BIPOB // Verify function VoltageOfCode_Bipolar_OffsetBinary
// @test group BIPOB tinyTester.blink_time_msec = 20 // quickly speed through the software verification
// @test group BIPOB Configure_CTRL_REF(2) expect 1 // These tests require REF2 = 2.500V
// @test group BIPOB Configure_PGA(0,0) expect 1 // These tests require PGA gain=1
// @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0xFFFFFF) expect 2.5 within 0.030  // Full Scale
// @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0xFFFFFE) expect 2.5               // Full Scale
// @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0xC00000) expect 1.25              // Mid Scale
// @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0x800003) expect 0.00000894069671  // Three LSB
// @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0x800002) expect 0.00000596046447  // Two LSB
// @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0x800001) expect 0.0000029802326   // One LSB
// @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0x800000) expect 0.0               // Zero Scale
// @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0x7FFFFF) expect -0.0000029802326  // Negative One LSB
// @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0x7FFFFE) expect -0.0000059604644  // Negative Two LSB
// @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0x7FFFFD) expect -0.0000089406967  // Negative Three LSB
// @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0x400000) expect -1.25             // Negative Mid Scale
// @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0x000001) expect -2.5              // Negative Full Scale
// @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0x000000) expect -2.5              // Negative Full Scale
// @test group BIPOB tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
//
double MAX11410::VoltageOfCode_Bipolar_OffsetBinary(uint32_t value_u24)
{
    
    //----------------------------------------
    // Linear map min and max endpoints
    double VRef = ref2_v;
    uint8_t ref_sel = (ctrl & 0x03); // MAX11410_REF_SEL_enum_t
    switch(ref_sel)
    {
    case REF_SEL_000_AIN0_AIN1:     VRef = ref0_v; break;
    case REF_SEL_001_REF1P_REF1N:   VRef = ref1_v; break;
    case REF_SEL_010_REF2P_REF2N:   VRef = ref2_v; break;
    case REF_SEL_011_AVDD_AGND:     VRef = avdd_v; break;
    case REF_SEL_100_AIN0_AGND:     VRef = ref0_v; break;
    case REF_SEL_101_REF1P_AGND:    VRef = ref1_v; break;
    case REF_SEL_110_REF2P_AGND:    VRef = ref2_v; break;
    case REF_SEL_111_AVDD_AGND:     VRef = avdd_v; break;
    }
    double MaxScaleVoltage = 2 * VRef; // voltage of maximum code 0x7fffff
    double MinScaleVoltage = 0; // voltage of minimum code 0x800000;
    // const uint32_t FULL_SCALE_CODE_24BIT = 0x7fffff;
    // const uint32_t MaxCode = FULL_SCALE_CODE_24BIT;
    const int32_t CodeSpan = 0x1000000;
    const uint32_t MinCode = 0x800000;
    double codeFraction = ((double)value_u24 - MinCode) / CodeSpan;
    return (MinScaleVoltage + ((MaxScaleVoltage - MinScaleVoltage) * codeFraction)) / pgaGain;
}

//----------------------------------------
// Return the physical voltage corresponding to conversion result,
// when conversion format is Bipolar mode, 2's complement.
// Does not perform any offset or gain correction.
//
// @pre CTRL::U_BN = 0 -- Bipolar mode
// @pre CTRL::FORMAT = 0 -- 2's complement
// @pre VRef = Voltage of REF input, in Volts
// @param[in] value_u24: raw 24-bit MAX11410 code (right justified).
// @return physical voltage corresponding to MAX11410 code.
//
// @test group BIP2C // Verify function VoltageOfCode_Bipolar_2sComplement
// @test group BIP2C tinyTester.blink_time_msec = 20 // quickly speed through the software verification
// @test group BIP2C Configure_CTRL_REF(2) expect 1 // These tests require REF2 = 2.500V
// @test group BIP2C Configure_PGA(0,0) expect 1 // These tests require PGA gain=1
// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x7FFFFF) expect 2.500 within 0.030 // Full Scale
// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x7FFFFE) expect 2.500              // Full Scale
// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x666666) expect 2.000              // Two Volts
// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x600000) expect 1.875              // 75% Scale
// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x400000) expect 1.250              // Mid Scale
// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x333333) expect 1.000              // One Volt
// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x200000) expect 0.625              // 25% Scale
// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x051eb8) expect 0.100              // 100mV
// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x000003) expect 0.00000894069671   // Three LSB
// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x000002) expect 0.00000596046447   // Two LSB
// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x000001) expect 0.0000029802326    // One LSB
// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x000000) expect 0.0                // Zero Scale
// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0xFFFFFF) expect -0.0000029802326   // Negative One LSB
// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0xFFFFFE) expect -0.0000059604644   // Negative Two LSB
// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0xFFFFFD) expect -0.0000089406967   // Negative Three LSB
// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0xFAE148) expect -0.100             // Negative 100mV
// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0xE00000) expect -0.625             // Negative 25% Scale
// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0xCCCCCD) expect -1.000             // Negative One Volt
// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0xC00000) expect -1.250             // Negative Mid Scale
// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0xA00000) expect -1.875             // Negative 75% Scale
// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x99999A) expect -2.000             // Negative Two Volts
// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x800001) expect -2.500             // Negative Full Scale
// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x800000) expect -2.500             // Negative Full Scale
// @test group BIP2C tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
//
double MAX11410::VoltageOfCode_Bipolar_2sComplement(uint32_t value_u24)
{
    
    //----------------------------------------
    // Linear map min and max endpoints
    double VRef = ref2_v;
    uint8_t ref_sel = (ctrl & 0x03); // MAX11410_REF_SEL_enum_t
    switch(ref_sel)
    {
    case REF_SEL_000_AIN0_AIN1:     VRef = ref0_v; break;
    case REF_SEL_001_REF1P_REF1N:   VRef = ref1_v; break;
    case REF_SEL_010_REF2P_REF2N:   VRef = ref2_v; break;
    case REF_SEL_011_AVDD_AGND:     VRef = avdd_v; break;
    case REF_SEL_100_AIN0_AGND:     VRef = ref0_v; break;
    case REF_SEL_101_REF1P_AGND:    VRef = ref1_v; break;
    case REF_SEL_110_REF2P_AGND:    VRef = ref2_v; break;
    case REF_SEL_111_AVDD_AGND:     VRef = avdd_v; break;
    }
    double MaxScaleVoltage = 2 * VRef; // voltage of maximum code 0x7fffff
    double MinScaleVoltage = 0; // voltage of minimum code 0x800000
    // const int32_t FULL_SCALE_CODE_24BIT_2S_COMPLEMENT = 0x7fffff;
    const int32_t SIGN_BIT_24BIT_2S_COMPLEMENT = 0x800000;
    if (value_u24 >= SIGN_BIT_24BIT_2S_COMPLEMENT) { value_u24 = value_u24 - (2 * SIGN_BIT_24BIT_2S_COMPLEMENT); }
    // const int32_t MaxCode = FULL_SCALE_CODE_24BIT_2S_COMPLEMENT;
    const int32_t CodeSpan = 0x1000000;
    const int32_t MinCode = 0;
    double codeFraction = ((double)((int32_t)value_u24) - MinCode) / CodeSpan;
    return (MinScaleVoltage + ((MaxScaleVoltage - MinScaleVoltage) * codeFraction)) / pgaGain;
}

//----------------------------------------
// Return the physical voltage corresponding to conversion result,
// when conversion format is determined by the CTRL register.
// Does not perform any offset or gain correction.
//
// @pre CTRL::U_BN and CTRL::FORMAT = 0 select offset binary, 2's complement, or straight binary
// @pre VRef = Voltage of REF input, in Volts
// @param[in] value_u24: raw 24-bit MAX11410 code (right justified).
// @return physical voltage corresponding to MAX11410 code.
double MAX11410::VoltageOfCode(uint32_t value_u24)
{
    
    //----------------------------------------
    // Determine format from CTRL register U_BN and FORMAT
    uint8_t u_bn_bitmask = (1 << 6);
    uint8_t format_bitmask = (1 << 5);
    if ((ctrl & u_bn_bitmask) != 0)
    {
        return VoltageOfCode_Unipolar(value_u24);
    }
    if ((ctrl & format_bitmask) != 0)
    {
        return VoltageOfCode_Bipolar_OffsetBinary(value_u24);
    }
    return VoltageOfCode_Bipolar_2sComplement(value_u24);
}

//----------------------------------------
// Write a MAX11410 register.
//
// CMDOP_1aaa_aaaa_ReadRegister bit is cleared 0 indicating a write operation.
//
// MAX11410 register length can be determined by function RegSize.
//
// For 8-bit register size:
//
//     SPI 16-bit transfer
//
//     SPI MOSI = 0aaa_aaaa_dddd_dddd
//
//     SPI MISO = xxxx_xxxx_xxxx_xxxx
//
// For 16-bit register size:
//
//     SPI 24-bit or 32-bit transfer
//
//     SPI MOSI = 0aaa_aaaa_dddd_dddd_dddd_dddd
//
//     SPI MISO = xxxx_xxxx_xxxx_xxxx_xxxx_xxxx
//
// For 24-bit register size:
//
//     SPI 32-bit transfer
//
//     SPI MOSI = 0aaa_aaaa_dddd_dddd_dddd_dddd_dddd_dddd
//
//     SPI MISO = xxxx_xxxx_xxxx_xxxx_xxxx_xxxx_xxxx_xxxx
//
// @return 1 on success; 0 on failure
uint8_t MAX11410::RegWrite(MAX11410_CMD_enum_t commandByte, uint32_t regData)
{
    
    //----------------------------------------
    // switch based on register address size RegSize(commandByte)
    commandByte = (MAX11410_CMD_enum_t)((commandByte &~ CMDOP_1aaa_aaaa_ReadRegister) & 0xFF);
    switch(RegSize(commandByte))
    {
        case 8:  // 8-bit register size
            {
                // SPI 16-bit transfer
                // SPI MOSI = 0aaa_aaaa_dddd_dddd
                // SPI MISO = xxxx_xxxx_xxxx_xxxx
                int16_t mosiData16 = ((int16_t)commandByte << 8) | ((int16_t)regData & 0xFF);
                SPIoutputCS(0);
                SPIwrite16bits(mosiData16);
                SPIoutputCS(1);
                //
                if (commandByte == CMD_r000_1110_00ss_0ggg_PGA)
                {
                    // update pgaGain with 1, 2, 4, 8, 16, 32, 64, or 128 based on gain index
                    static uint8_t pgaGainTable[8] = {1, 2, 4, 8, 16, 32, 64, 128};
                    pgaGain = (((regData >> 4) & 2) == SIG_PATH_10_PGA) 
                        ? pgaGainTable[(uint8_t)(regData & 7)] 
                        : 1;
                }
                if (commandByte == CMD_r000_0011_xxxx_xddd_CAL_START)
                {
                    // after RegWrite CMD_r000_0011_xxxx_xddd_CAL_START, poll status until 0x000004 CAL_RDY
                    RegRead(CMD_r011_1000_dddd_dddd_dddd_dddd_dxxx_dddd_STATUS, &status);
                    switch(regData & 0x07)
                    {
                    case 2: // CAL_TYPE_010_reserved = 0x02, //!< 0b010
                    case 3: // CAL_TYPE_011_reserved = 0x03, //!< 0b011
                        break; // do not wait for status
                    case 1: // CAL_TYPE_001_PGA_GAIN = 0x01, //!< 0b001
                        //
                        // Note: this case may fall through, by design.
#if __GNUC__
#pragma GCC diagnostic ignored "-Wimplicit-fallthrough"
#endif
                        if (pgaGain == 1) break; // do not wait for status
                        // fall through to case 0,4,5,6,7
#if __GNUC__
#pragma GCC diagnostic pop
#endif
                        // Note: this case may fall through, by design.
                    case 0: // CAL_TYPE_000_SELF_CAL = 0x00, //!< 0b000
                    case 4: // CAL_TYPE_100_SYS_OFF_A = 0x04, //!< 0b100
                    case 5: // CAL_TYPE_101_SYS_GAIN_A = 0x05, //!< 0b101
                    case 6: // CAL_TYPE_110_SYS_OFF_B = 0x06, //!< 0b110
                    case 7: // CAL_TYPE_111_SYS_GAIN_B = 0x07, //!< 0b111
                        {
                            // wait for status CAL_RDY
                            // Worst-case (longest) calibration time = 2 x 1 sample/second = 2 seconds
                            for (int futility_countdown = loop_limit;
                                ((futility_countdown > 0) &&
                                ((status &  /* MAX11410_STATUS_enum_t:: */ STATUS_000004_CAL_RDY) == 0));
                                futility_countdown--)
                            {
                                for (int futility_countdown_inner = 32767;
                                    ((futility_countdown_inner > 0) &&
                                    ((status &  /* MAX11410_STATUS_enum_t:: */ STATUS_000004_CAL_RDY) == 0));
                                    futility_countdown_inner--)
                                {
                                    RegRead(CMD_r011_1000_dddd_dddd_dddd_dddd_dxxx_dddd_STATUS, &status);
                                }
                            }
                        }
                        break;
                    }
                }
            }
            break;
        case 16:  // 16-bit register size
            {
                // SPI 24-bit or 32-bit transfer
                // SPI MOSI = 0aaa_aaaa_dddd_dddd_dddd_dddd
                // SPI MISO = xxxx_xxxx_xxxx_xxxx_xxxx_xxxx
                // SPI MOSI = 0aaa_aaaa_dddd_dddd_dddd_dddd_0000_0000
                // SPI MISO = xxxx_xxxx_xxxx_xxxx_xxxx_xxxx_xxxx_xxxx
                int32_t mosiData32 = ((int32_t)commandByte << 24) | (((int32_t)regData & 0xFFFF) << 8);
                SPIoutputCS(0);
                SPIreadWrite32bits(mosiData32);
                SPIoutputCS(1);
            }
            break;
        case 24:  // 24-bit register size
            {
                // SPI 32-bit transfer
                // SPI MOSI = 0aaa_aaaa_dddd_dddd_dddd_dddd_dddd_dddd
                // SPI MISO = xxxx_xxxx_xxxx_xxxx_xxxx_xxxx_xxxx_xxxx
                int32_t mosiData32 = ((int32_t)commandByte << 24) | ((int32_t)regData & 0x00FFFFFF);
                SPIoutputCS(0);
                SPIreadWrite32bits(mosiData32);
                SPIoutputCS(1);
            }
            break;
    }
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Read an 8-bit MAX11410 register
//
// CMDOP_1aaa_aaaa_ReadRegister bit is set 1 indicating a read operation.
//
// MAX11410 register length can be determined by function RegSize.
//
// For 8-bit register size:
//
//     SPI 16-bit transfer
//
//     SPI MOSI = 1aaa_aaaa_0000_0000
//
//     SPI MISO = xxxx_xxxx_dddd_dddd
//
// For 16-bit register size:
//
//     SPI 24-bit or 32-bit transfer
//
//     SPI MOSI = 1aaa_aaaa_0000_0000_0000_0000
//
//     SPI MISO = xxxx_xxxx_dddd_dddd_dddd_dddd
//
// For 24-bit register size:
//
//     SPI 32-bit transfer
//
//     SPI MOSI = 1aaa_aaaa_0000_0000_0000_0000_0000_0000
//
//     SPI MISO = xxxx_xxxx_dddd_dddd_dddd_dddd_dddd_dddd
//
//
// @return 1 on success; 0 on failure
uint8_t MAX11410::RegRead(MAX11410_CMD_enum_t commandByte, uint32_t* ptrRegData)
{
    
    //----------------------------------------
    // switch based on register address size RegSize(regAddress)
    commandByte = (MAX11410_CMD_enum_t)((commandByte &~ CMDOP_1aaa_aaaa_ReadRegister) & 0xFF);
    switch(RegSize(commandByte))
    {
        case 8:  // 8-bit register size
            {
                // SPI 16-bit transfer
                // SPI MOSI = 1aaa_aaaa_0000_0000
                // SPI MISO = xxxx_xxxx_dddd_dddd
                int16_t mosiData16 = ((CMDOP_1aaa_aaaa_ReadRegister | (int16_t)commandByte) << 8) | ((int16_t)0);
                SPIoutputCS(0);
                int16_t misoData16 = SPIreadWrite16bits(mosiData16);
                SPIoutputCS(1);
                (*ptrRegData) = (misoData16 & 0x00FF);
            }
            break;
        case 16:  // 16-bit register size
            {
                // SPI 24-bit or 32-bit transfer
                // SPI MOSI = 1aaa_aaaa_0000_0000_0000_0000
                // SPI MISO = xxxx_xxxx_dddd_dddd_dddd_dddd
                // SPI MOSI = 1aaa_aaaa_0000_0000_0000_0000_0000_0000
                // SPI MISO = xxxx_xxxx_dddd_dddd_dddd_dddd_xxxx_xxxx
                int32_t mosiData32 = ((CMDOP_1aaa_aaaa_ReadRegister | (int32_t)commandByte) << 24);
                SPIoutputCS(0);
                int32_t misoData32 = SPIreadWrite32bits(mosiData32);
                SPIoutputCS(1);
                (*ptrRegData) = ((misoData32 >> 8) & 0x00FFFF);
            }
            break;
        case 24:  // 24-bit register size
            {
                // SPI 32-bit transfer
                // SPI MOSI = 1aaa_aaaa_0000_0000_0000_0000_0000_0000
                // SPI MISO = xxxx_xxxx_dddd_dddd_dddd_dddd_dddd_dddd
                int32_t mosiData32 = ((CMDOP_1aaa_aaaa_ReadRegister | (int32_t)commandByte) << 24);
                SPIoutputCS(0);
                int32_t misoData32 = SPIreadWrite32bits(mosiData32);
                SPIoutputCS(1);
                (*ptrRegData) = (misoData32 & 0x00FFFFFF);
            }
            break;
    }
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Return the size of a MAX11410 register
//
// @return 8 for 8-bit, 16 for 16-bit, 24 for 24-bit, else 0 for undefined register size
uint8_t MAX11410::RegSize(MAX11410_CMD_enum_t commandByte)
{
    
    //----------------------------------------
    // switch based on register address value regAddress
    commandByte = (MAX11410_CMD_enum_t)((commandByte &~ CMDOP_1aaa_aaaa_ReadRegister) & 0xFF);
    switch(commandByte)
    {
        default:
            return 0;  // undefined register size
        case CMD_r000_0000_xxxx_xxdd_PD:
        case CMD_r000_0001_xddd_xxdd_CONV_START:
        case CMD_r000_0010_xddd_dddd_SEQ_START:
        case CMD_r000_0011_xxxx_xddd_CAL_START:
        case CMD_r000_0100_dddd_xddd_GP0_CTRL:
        case CMD_r000_0101_dddd_xddd_GP1_CTRL:
        case CMD_r000_0110_xddd_xxdd_GP_CONV:
        case CMD_r000_0111_xddd_dddd_GP_SEQ_ADDR:
        case CMD_r000_1000_x0dd_dddd_FILTER:
        case CMD_r000_1001_dddd_dddd_CTRL:
        case CMD_r000_1010_dddd_dddd_SOURCE:
        case CMD_r000_1011_dddd_dddd_MUX_CTRL0:
        case CMD_r000_1100_dddd_dddd_MUX_CTRL1:
        case CMD_r000_1101_dddd_dddd_MUX_CTRL2:
        case CMD_r000_1110_00ss_0ggg_PGA:
        case CMD_r000_1111_dddd_dddd_WAIT_EXT:
        case CMD_r001_0000_xxxx_xxxx_WAIT_START:
            return 8;  // 8-bit register size
        case CMD_r001_0001_xxxx_xxxx_xxxx_xxxx_xxxx_xddd_PART_ID:
        case CMD_r001_0010_xxxx_xxxx_dddd_xxdd_dddd_dddd_SYSC_SEL:
        case CMD_r001_0011_dddd_dddd_dddd_dddd_dddd_dddd_SYS_OFF_A:
        case CMD_r001_0100_dddd_dddd_dddd_dddd_dddd_dddd_SYS_OFF_B:
        case CMD_r001_0101_dddd_dddd_dddd_dddd_dddd_dddd_SYS_GAIN_A:
        case CMD_r001_0110_dddd_dddd_dddd_dddd_dddd_dddd_SYS_GAIN_B:
        case CMD_r001_0111_dddd_dddd_dddd_dddd_dddd_dddd_SELF_OFF:
        case CMD_r001_1000_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_1:
        case CMD_r001_1001_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_2:
        case CMD_r001_1010_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_4:
        case CMD_r001_1011_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_8:
        case CMD_r001_1100_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_16:
        case CMD_r001_1101_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_32:
        case CMD_r001_1110_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_64:
        case CMD_r001_1111_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_128:
        case CMD_r010_0000_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH0:
        case CMD_r010_0001_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH1:
        case CMD_r010_0010_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH2:
        case CMD_r010_0011_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH3:
        case CMD_r010_0100_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH4:
        case CMD_r010_0101_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH5:
        case CMD_r010_0110_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH6:
        case CMD_r010_0111_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH7:
        case CMD_r010_1000_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH0:
        case CMD_r010_1001_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH1:
        case CMD_r010_1010_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH2:
        case CMD_r010_1011_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH3:
        case CMD_r010_1100_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH4:
        case CMD_r010_1101_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH5:
        case CMD_r010_1110_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH6:
        case CMD_r010_1111_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH7:
        case CMD_r011_0000_dddd_dddd_dddd_dddd_dddd_dddd_DATA0:
        case CMD_r011_0001_dddd_dddd_dddd_dddd_dddd_dddd_DATA1:
        case CMD_r011_0010_dddd_dddd_dddd_dddd_dddd_dddd_DATA2:
        case CMD_r011_0011_dddd_dddd_dddd_dddd_dddd_dddd_DATA3:
        case CMD_r011_0100_dddd_dddd_dddd_dddd_dddd_dddd_DATA4:
        case CMD_r011_0101_dddd_dddd_dddd_dddd_dddd_dddd_DATA5:
        case CMD_r011_0110_dddd_dddd_dddd_dddd_dddd_dddd_DATA6:
        case CMD_r011_0111_dddd_dddd_dddd_dddd_dddd_dddd_DATA7:
        case CMD_r011_1000_dddd_dddd_dddd_dddd_dxxx_dddd_STATUS:
        case CMD_r011_1001_dddd_dddd_dddd_dddd_dxxd_dddd_STATUS_IE:
            return 24;  // 24-bit register size
        case CMD_r011_1010_xaaa_aaaa_dddd_dddd_UC_0:
        case CMD_r011_1011_xaaa_aaaa_dddd_dddd_UC_1:
        case CMD_r011_1100_xaaa_aaaa_dddd_dddd_UC_2:
        case CMD_r011_1101_xaaa_aaaa_dddd_dddd_UC_3:
        case CMD_r011_1110_xaaa_aaaa_dddd_dddd_UC_4:
        case CMD_r011_1111_xaaa_aaaa_dddd_dddd_UC_5:
        case CMD_r100_0000_xaaa_aaaa_dddd_dddd_UC_6:
        case CMD_r100_0001_xaaa_aaaa_dddd_dddd_UC_7:
        case CMD_r100_0010_xaaa_aaaa_dddd_dddd_UC_8:
        case CMD_r100_0011_xaaa_aaaa_dddd_dddd_UC_9:
        case CMD_r100_0100_xaaa_aaaa_dddd_dddd_UC_10:
        case CMD_r100_0101_xaaa_aaaa_dddd_dddd_UC_11:
        case CMD_r100_0110_xaaa_aaaa_dddd_dddd_UC_12:
        case CMD_r100_0111_xaaa_aaaa_dddd_dddd_UC_13:
        case CMD_r100_1000_xaaa_aaaa_dddd_dddd_UC_14:
        case CMD_r100_1001_xaaa_aaaa_dddd_dddd_UC_15:
        case CMD_r100_1010_xaaa_aaaa_dddd_dddd_UC_16:
        case CMD_r100_1011_xaaa_aaaa_dddd_dddd_UC_17:
        case CMD_r100_1100_xaaa_aaaa_dddd_dddd_UC_18:
        case CMD_r100_1101_xaaa_aaaa_dddd_dddd_UC_19:
        case CMD_r100_1110_xaaa_aaaa_dddd_dddd_UC_20:
        case CMD_r100_1111_xaaa_aaaa_dddd_dddd_UC_21:
        case CMD_r101_0000_xaaa_aaaa_dddd_dddd_UC_22:
        case CMD_r101_0001_xaaa_aaaa_dddd_dddd_UC_23:
        case CMD_r101_0010_xaaa_aaaa_dddd_dddd_UC_24:
        case CMD_r101_0011_xaaa_aaaa_dddd_dddd_UC_25:
        case CMD_r101_0100_xaaa_aaaa_dddd_dddd_UC_26:
        case CMD_r101_0101_xaaa_aaaa_dddd_dddd_UC_27:
        case CMD_r101_0110_xaaa_aaaa_dddd_dddd_UC_28:
        case CMD_r101_0111_xaaa_aaaa_dddd_dddd_UC_29:
        case CMD_r101_1000_xaaa_aaaa_dddd_dddd_UC_30:
        case CMD_r101_1001_xaaa_aaaa_dddd_dddd_UC_31:
        case CMD_r101_1010_xaaa_aaaa_dddd_dddd_UC_32:
        case CMD_r101_1011_xaaa_aaaa_dddd_dddd_UC_33:
        case CMD_r101_1100_xaaa_aaaa_dddd_dddd_UC_34:
        case CMD_r101_1101_xaaa_aaaa_dddd_dddd_UC_35:
        case CMD_r101_1110_xaaa_aaaa_dddd_dddd_UC_36:
        case CMD_r101_1111_xaaa_aaaa_dddd_dddd_UC_37:
        case CMD_r110_0000_xaaa_aaaa_dddd_dddd_UC_38:
        case CMD_r110_0001_xaaa_aaaa_dddd_dddd_UC_39:
        case CMD_r110_0010_xaaa_aaaa_dddd_dddd_UC_40:
        case CMD_r110_0011_xaaa_aaaa_dddd_dddd_UC_41:
        case CMD_r110_0100_xaaa_aaaa_dddd_dddd_UC_42:
        case CMD_r110_0101_xaaa_aaaa_dddd_dddd_UC_43:
        case CMD_r110_0110_xaaa_aaaa_dddd_dddd_UC_44:
        case CMD_r110_0111_xaaa_aaaa_dddd_dddd_UC_45:
        case CMD_r110_1000_xaaa_aaaa_dddd_dddd_UC_46:
        case CMD_r110_1001_xaaa_aaaa_dddd_dddd_UC_47:
        case CMD_r110_1010_xaaa_aaaa_dddd_dddd_UC_48:
        case CMD_r110_1011_xaaa_aaaa_dddd_dddd_UC_49:
        case CMD_r110_1100_xaaa_aaaa_dddd_dddd_UC_50:
        case CMD_r110_1101_xaaa_aaaa_dddd_dddd_UC_51:
        case CMD_r110_1110_xaaa_aaaa_dddd_dddd_UC_52:
        case CMD_r110_1111_xxxx_xxxx_xaaa_aaaa_UCADDR:
            return 16;  // 16-bit register size
    }
}

//----------------------------------------
// Decode operation from commandByte
//
// @return operation such as idle, read register, write register, etc.
MAX11410::MAX11410_CMDOP_enum_t MAX11410::DecodeCommand(MAX11410_CMD_enum_t commandByte)
{
    
    //----------------------------------------
    // decode operation from command byte
    switch (commandByte & 0x80)
    {
    default:
    case CMDOP_0aaa_aaaa_WriteRegister:
        return CMDOP_0aaa_aaaa_WriteRegister;
    case CMDOP_1aaa_aaaa_ReadRegister:
        return CMDOP_1aaa_aaaa_ReadRegister;
    }
}

//----------------------------------------
// Return the address field of a MAX11410 register
//
// @return register address field as given in datasheet
uint8_t MAX11410::RegAddrOfCommand(MAX11410_CMD_enum_t commandByte)
{
    
    //----------------------------------------
    // extract register address value from command byte
    return (uint8_t)((commandByte &~ CMDOP_1aaa_aaaa_ReadRegister) & 0xFF);
}

//----------------------------------------
// Test whether a command byte is a register read command
//
// @return true if command byte is a register read command
uint8_t MAX11410::IsRegReadCommand(MAX11410_CMD_enum_t commandByte)
{
    
    //----------------------------------------
    // Test whether a command byte is a register read command
    return (commandByte & CMDOP_1aaa_aaaa_ReadRegister) ? 1 : 0;
}

//----------------------------------------
// Test whether a command byte is a register write command
//
// @return true if command byte is a register write command
uint8_t MAX11410::IsRegWriteCommand(MAX11410_CMD_enum_t commandByte)
{
    
    //----------------------------------------
    // Test whether a command byte is a register write command
    return (commandByte & CMDOP_1aaa_aaaa_ReadRegister) ? 0 : 1;
}

//----------------------------------------
// Return the name of a MAX11410 register
//
// @return null-terminated constant C string containing register name or empty string
const char* MAX11410::RegName(MAX11410_CMD_enum_t commandByte)
{
    
    //----------------------------------------
    // switch based on register address value regAddress
    commandByte = (MAX11410_CMD_enum_t)((commandByte &~ CMDOP_1aaa_aaaa_ReadRegister) & 0xFF);
    switch(commandByte)
    {
        default:
            return "";  // undefined register
        case CMD_r000_0000_xxxx_xxdd_PD: return "PD";
        case CMD_r000_0001_xddd_xxdd_CONV_START: return "CONV_START";
        case CMD_r000_0010_xddd_dddd_SEQ_START: return "SEQ_START";
        case CMD_r000_0011_xxxx_xddd_CAL_START: return "CAL_START";
        case CMD_r000_0100_dddd_xddd_GP0_CTRL: return "GP0_CTRL";
        case CMD_r000_0101_dddd_xddd_GP1_CTRL: return "GP1_CTRL";
        case CMD_r000_0110_xddd_xxdd_GP_CONV: return "GP_CONV";
        case CMD_r000_0111_xddd_dddd_GP_SEQ_ADDR: return "GP_SEQ_ADDR";
        case CMD_r000_1000_x0dd_dddd_FILTER: return "FILTER";
        case CMD_r000_1001_dddd_dddd_CTRL: return "CTRL";
        case CMD_r000_1010_dddd_dddd_SOURCE: return "SOURCE";
        case CMD_r000_1011_dddd_dddd_MUX_CTRL0: return "MUX_CTRL0";
        case CMD_r000_1100_dddd_dddd_MUX_CTRL1: return "MUX_CTRL1";
        case CMD_r000_1101_dddd_dddd_MUX_CTRL2: return "MUX_CTRL2";
        case CMD_r000_1110_00ss_0ggg_PGA: return "PGA";
        case CMD_r000_1111_dddd_dddd_WAIT_EXT: return "WAIT_EXT";
        case CMD_r001_0000_xxxx_xxxx_WAIT_START: return "WAIT_START";
        case CMD_r001_0001_xxxx_xxxx_xxxx_xxxx_xxxx_xddd_PART_ID: return "PART_ID";
        case CMD_r001_0010_xxxx_xxxx_dddd_xxdd_dddd_dddd_SYSC_SEL: return "SYSC_SEL";
        case CMD_r001_0011_dddd_dddd_dddd_dddd_dddd_dddd_SYS_OFF_A: return "SYS_OFF_A";
        case CMD_r001_0100_dddd_dddd_dddd_dddd_dddd_dddd_SYS_OFF_B: return "SYS_OFF_B";
        case CMD_r001_0101_dddd_dddd_dddd_dddd_dddd_dddd_SYS_GAIN_A: return "SYS_GAIN_A";
        case CMD_r001_0110_dddd_dddd_dddd_dddd_dddd_dddd_SYS_GAIN_B: return "SYS_GAIN_B";
        case CMD_r001_0111_dddd_dddd_dddd_dddd_dddd_dddd_SELF_OFF: return "SELF_OFF";
        case CMD_r001_1000_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_1: return "SELF_GAIN_1";
        case CMD_r001_1001_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_2: return "SELF_GAIN_2";
        case CMD_r001_1010_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_4: return "SELF_GAIN_4";
        case CMD_r001_1011_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_8: return "SELF_GAIN_8";
        case CMD_r001_1100_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_16: return "SELF_GAIN_16";
        case CMD_r001_1101_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_32: return "SELF_GAIN_32";
        case CMD_r001_1110_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_64: return "SELF_GAIN_64";
        case CMD_r001_1111_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_128: return "SELF_GAIN_128";
        // Condense register names LTHRESH0..LTHRESH7 from CMD_r010_0000_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH0
        case CMD_r010_0000_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH0:
        case CMD_r010_0001_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH1:
        case CMD_r010_0010_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH2:
        case CMD_r010_0011_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH3:
        case CMD_r010_0100_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH4:
        case CMD_r010_0101_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH5:
        case CMD_r010_0110_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH6:
        case CMD_r010_0111_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH7:
            {
                // Condense register names "LTHRESH#" from CMD_r010_0000_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH0
                int index = commandByte - CMD_r010_0000_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH0;
                static char retValueString[] = "LTHRESH#";
                retValueString[7] = (index % 10) + '0';
                return retValueString;
            };
        // Condense register names UTHRESH0..UTHRESH7 from CMD_r010_1000_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH0
        case CMD_r010_1000_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH0:
        case CMD_r010_1001_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH1:
        case CMD_r010_1010_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH2:
        case CMD_r010_1011_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH3:
        case CMD_r010_1100_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH4:
        case CMD_r010_1101_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH5:
        case CMD_r010_1110_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH6:
        case CMD_r010_1111_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH7:
            {
                // Condense register names "UTHRESH#" from CMD_r010_1000_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH0
                int index = commandByte - CMD_r010_1000_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH0;
                static char retValueString[] = "UTHRESH#";
                retValueString[7] = (index % 10) + '0';
                return retValueString;
            };
        // Condense register names DATA0..DATA7 from CMD_r011_0000_dddd_dddd_dddd_dddd_dddd_dddd_DATA0
        case CMD_r011_0000_dddd_dddd_dddd_dddd_dddd_dddd_DATA0:
        case CMD_r011_0001_dddd_dddd_dddd_dddd_dddd_dddd_DATA1:
        case CMD_r011_0010_dddd_dddd_dddd_dddd_dddd_dddd_DATA2:
        case CMD_r011_0011_dddd_dddd_dddd_dddd_dddd_dddd_DATA3:
        case CMD_r011_0100_dddd_dddd_dddd_dddd_dddd_dddd_DATA4:
        case CMD_r011_0101_dddd_dddd_dddd_dddd_dddd_dddd_DATA5:
        case CMD_r011_0110_dddd_dddd_dddd_dddd_dddd_dddd_DATA6:
        case CMD_r011_0111_dddd_dddd_dddd_dddd_dddd_dddd_DATA7:
            {
                // Condense register names "DATA#" from CMD_r011_0000_dddd_dddd_dddd_dddd_dddd_dddd_DATA0
                int index = commandByte - CMD_r011_0000_dddd_dddd_dddd_dddd_dddd_dddd_DATA0;
                static char retValueString[] = "DATA#";
                retValueString[4] = (index % 10) + '0';
                return retValueString;
            };
        case CMD_r011_1000_dddd_dddd_dddd_dddd_dxxx_dddd_STATUS: return "STATUS";
        case CMD_r011_1001_dddd_dddd_dddd_dddd_dxxd_dddd_STATUS_IE: return "STATUS_IE";
        // Condense register names UC_00..UC_52 from CMD_r011_1010_xaaa_aaaa_dddd_dddd_UC_0
        case CMD_r011_1010_xaaa_aaaa_dddd_dddd_UC_0:
        case CMD_r011_1011_xaaa_aaaa_dddd_dddd_UC_1:
        case CMD_r011_1100_xaaa_aaaa_dddd_dddd_UC_2:
        case CMD_r011_1101_xaaa_aaaa_dddd_dddd_UC_3:
        case CMD_r011_1110_xaaa_aaaa_dddd_dddd_UC_4:
        case CMD_r011_1111_xaaa_aaaa_dddd_dddd_UC_5:
        case CMD_r100_0000_xaaa_aaaa_dddd_dddd_UC_6:
        case CMD_r100_0001_xaaa_aaaa_dddd_dddd_UC_7:
        case CMD_r100_0010_xaaa_aaaa_dddd_dddd_UC_8:
        case CMD_r100_0011_xaaa_aaaa_dddd_dddd_UC_9:
        case CMD_r100_0100_xaaa_aaaa_dddd_dddd_UC_10:
        case CMD_r100_0101_xaaa_aaaa_dddd_dddd_UC_11:
        case CMD_r100_0110_xaaa_aaaa_dddd_dddd_UC_12:
        case CMD_r100_0111_xaaa_aaaa_dddd_dddd_UC_13:
        case CMD_r100_1000_xaaa_aaaa_dddd_dddd_UC_14:
        case CMD_r100_1001_xaaa_aaaa_dddd_dddd_UC_15:
        case CMD_r100_1010_xaaa_aaaa_dddd_dddd_UC_16:
        case CMD_r100_1011_xaaa_aaaa_dddd_dddd_UC_17:
        case CMD_r100_1100_xaaa_aaaa_dddd_dddd_UC_18:
        case CMD_r100_1101_xaaa_aaaa_dddd_dddd_UC_19:
        case CMD_r100_1110_xaaa_aaaa_dddd_dddd_UC_20:
        case CMD_r100_1111_xaaa_aaaa_dddd_dddd_UC_21:
        case CMD_r101_0000_xaaa_aaaa_dddd_dddd_UC_22:
        case CMD_r101_0001_xaaa_aaaa_dddd_dddd_UC_23:
        case CMD_r101_0010_xaaa_aaaa_dddd_dddd_UC_24:
        case CMD_r101_0011_xaaa_aaaa_dddd_dddd_UC_25:
        case CMD_r101_0100_xaaa_aaaa_dddd_dddd_UC_26:
        case CMD_r101_0101_xaaa_aaaa_dddd_dddd_UC_27:
        case CMD_r101_0110_xaaa_aaaa_dddd_dddd_UC_28:
        case CMD_r101_0111_xaaa_aaaa_dddd_dddd_UC_29:
        case CMD_r101_1000_xaaa_aaaa_dddd_dddd_UC_30:
        case CMD_r101_1001_xaaa_aaaa_dddd_dddd_UC_31:
        case CMD_r101_1010_xaaa_aaaa_dddd_dddd_UC_32:
        case CMD_r101_1011_xaaa_aaaa_dddd_dddd_UC_33:
        case CMD_r101_1100_xaaa_aaaa_dddd_dddd_UC_34:
        case CMD_r101_1101_xaaa_aaaa_dddd_dddd_UC_35:
        case CMD_r101_1110_xaaa_aaaa_dddd_dddd_UC_36:
        case CMD_r101_1111_xaaa_aaaa_dddd_dddd_UC_37:
        case CMD_r110_0000_xaaa_aaaa_dddd_dddd_UC_38:
        case CMD_r110_0001_xaaa_aaaa_dddd_dddd_UC_39:
        case CMD_r110_0010_xaaa_aaaa_dddd_dddd_UC_40:
        case CMD_r110_0011_xaaa_aaaa_dddd_dddd_UC_41:
        case CMD_r110_0100_xaaa_aaaa_dddd_dddd_UC_42:
        case CMD_r110_0101_xaaa_aaaa_dddd_dddd_UC_43:
        case CMD_r110_0110_xaaa_aaaa_dddd_dddd_UC_44:
        case CMD_r110_0111_xaaa_aaaa_dddd_dddd_UC_45:
        case CMD_r110_1000_xaaa_aaaa_dddd_dddd_UC_46:
        case CMD_r110_1001_xaaa_aaaa_dddd_dddd_UC_47:
        case CMD_r110_1010_xaaa_aaaa_dddd_dddd_UC_48:
        case CMD_r110_1011_xaaa_aaaa_dddd_dddd_UC_49:
        case CMD_r110_1100_xaaa_aaaa_dddd_dddd_UC_50:
        case CMD_r110_1101_xaaa_aaaa_dddd_dddd_UC_51:
        case CMD_r110_1110_xaaa_aaaa_dddd_dddd_UC_52:
            {
                // Condense register names "UC_##" from CMD_r011_1010_xaaa_aaaa_dddd_dddd_UC_0
                int index = commandByte - CMD_r011_1010_xaaa_aaaa_dddd_dddd_UC_0;
                static char retValueString[] = "UC_00";
                retValueString[3] = (index / 10) + '0';
                retValueString[4] = (index % 10) + '0';
                return retValueString;
            };
        case CMD_r110_1111_xxxx_xxxx_xaaa_aaaa_UCADDR: return "UCADDR";
    }
}

//----------------------------------------
// Menu item 'XF'
//
// FILTER Select Filter and Rate.
// Sets conversion rate based on RATE, LINEF, and CONV_TYPE value. See Table 9a through Table 9d for details.
// For CONV_TYPE_01_Continuous, linef=LINEF_11_SINC4, rate=RATE_0100 selects output data rate 60SPS.
//
// @param[in] linef = filter type, default=MAX11410::LINEF_enum_t::LINEF_11_SINC4
// @param[in] rate = output data rate selection, default=MAX11410::RATE_enum_t::RATE_0100
//
// @return 1 on success; 0 on failure
uint8_t MAX11410::Configure_FILTER(uint8_t linef, uint8_t rate)
{
    
    //----------------------------------------
    // write8 0x08 FILTER
    RegWrite(CMD_r000_1000_x0dd_dddd_FILTER, (uint8_t)(0
        | (((uint8_t)linef &  3) << 4)
        | (((uint8_t)rate  & 15) << 0)
        ));
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Menu item 'XP'
//
// PGA Select Gain and Signal Path.
//
// @param[in] sigpath = signal path, default=MAX11410::SIG_PATH_enum_t::SIG_PATH_00_BUFFERED
// @param[in] gain = gain selection, default=MAX11410::GAIN_enum_t::GAIN_000_1
//
// @return 1 on success; 0 on failure
uint8_t MAX11410::Configure_PGA(uint8_t sigpath, uint8_t gain)
{
    
    //----------------------------------------
    // write8 0x0E PGA
    RegWrite(CMD_r000_1110_00ss_0ggg_PGA, (uint8_t)(0
        | (((uint8_t)sigpath & 2) << 4)
        | (((uint8_t)gain    & 7) << 0)
        ));
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Menu item 'XC'
//
// CTRL Select clock, format, and reference.
//
// @param[in] extclk = external clock enable, default=0
// @param[in] u_bn = unipolar input range enable, default=0
// @param[in] format = offset binary format enable, default=0
// @param[in] refbufp_en = REFP reference buffer enable, default=0
// @param[in] refbufn_en = REFN reference buffer enable, default=0
// @param[in] ref_sel = reference selection, default=MAX11410::REF_SEL_enum_t::REF_SEL_001_REF1P_REF1N
//
// @return 1 on success; 0 on failure
uint8_t MAX11410::Configure_CTRL(uint8_t extclk, uint8_t u_bn, uint8_t format, uint8_t refbufp_en, uint8_t refbufn_en, uint8_t ref_sel)
{
    
    //----------------------------------------
    // shadow of register CMD_r000_1001_dddd_dddd_CTRL
    ctrl = (uint8_t)(0
        | (((uint8_t)extclk     & 1) << 7)
        | (((uint8_t)u_bn       & 1) << 6)
        | (((uint8_t)format     & 1) << 5)
        | (((uint8_t)refbufp_en & 1) << 4)
        | (((uint8_t)refbufn_en & 1) << 3)
        | (((uint8_t)ref_sel    & 7) << 0)
        );
    
    //----------------------------------------
    // write8 0x09 CTRL
    RegWrite(CMD_r000_1001_dddd_dddd_CTRL, ctrl);
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Menu item 'XR'
//
// CTRL select reference, without changing the other fields.
//
// @pre ctrl = shadow of CTRL register
// @param[in] ref_sel = reference selection, default=MAX11410::REF_SEL_enum_t::REF_SEL_001_REF1P_REF1N
//
// @return 1 on success; 0 on failure
uint8_t MAX11410::Configure_CTRL_REF(uint8_t ref_sel)
{
    
    //----------------------------------------
    // shadow of register CMD_r000_1001_dddd_dddd_CTRL
    ctrl = (ctrl & ((uint8_t)(~ 7) << 0))
        | (((uint8_t)ref_sel    & 7) << 0);
    
    //----------------------------------------
    // write8 0x09 CTRL
    RegWrite(CMD_r000_1001_dddd_dddd_CTRL, ctrl);
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Menu item 'XS'
//
// SOURCE Configure voltage bias source, current source, burnout mode
//
// @param[in] vbias_mode = bias voltage mode, default=MAX11410::VBIAS_MODE_enum_t::VBIAS_MODE_00_Active
// @param[in] brn_mode = burnout source mode, default=MAX11410::BRN_MODE_enum_t::BRN_MODE_00_disabled
// @param[in] idac_mode = current source value, default=MAX11410::IDAC_MODE_enum_t::IDAC_MODE_0000_10uA
//
// @return 1 on success; 0 on failure
uint8_t MAX11410::Configure_SOURCE(uint8_t vbias_mode, uint8_t brn_mode, uint8_t idac_mode)
{
    
    //----------------------------------------
    // write8 0x0A SOURCE
    RegWrite(CMD_r000_1010_dddd_dddd_SOURCE, (uint8_t)(0
        | (((uint8_t)vbias_mode &  3) << 6)
        | (((uint8_t)brn_mode   &  3) << 4)
        | (((uint8_t)idac_mode  & 15) << 0)
        ));
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Menu item 'XM'
//
// MUX_CTRL0 Select pins for analog input AINP and AINN
//
// @param[in] ainp = channel high side, default=MAX11410::AINP_SEL_enum_t::AINP_SEL_0000_AIN0
// @param[in] ainn = channel low side, default=MAX11410::AINN_SEL_enum_t::AINN_SEL_1010_GND
//
// @return 1 on success; 0 on failure
uint8_t MAX11410::Configure_MUX_CTRL0(uint8_t ainp, uint8_t ainn)
{
    
    //----------------------------------------
    // write8 0x0B MUX_CTRL0
    RegWrite(CMD_r000_1011_dddd_dddd_MUX_CTRL0, (uint8_t)(0
        | (((uint8_t)ainp & 15) << 4)
        | (((uint8_t)ainn & 15) << 0)
        ));
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Menu item 'XI'
//
// MUX_CTRL1 Select pins for current source
//
// @param[in] idac1_sel = channel high side, default=MAX11410::IDAC1_SEL_enum_t::IDAC1_SEL_1111_unconnected
// @param[in] idac0_sel = channel low side, default=MAX11410::IDAC0_SEL_enum_t::IDAC0_SEL_1111_unconnected
//
// @return 1 on success; 0 on failure
uint8_t MAX11410::Configure_MUX_CTRL1(uint8_t idac1_sel, uint8_t idac0_sel)
{
    
    //----------------------------------------
    // write8 0x0C MUX_CTRL1
    RegWrite(CMD_r000_1100_dddd_dddd_MUX_CTRL1, (uint8_t)(0
        | (((uint8_t)idac1_sel & 15) << 4)
        | (((uint8_t)idac0_sel & 15) << 0)
        ));
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Menu item 'XV'
//
// MUX_CTRL2 Select pins for voltage bias source
//
// @param[in] vbias_ain7_ain0_bitmap = bit map of AIN7..AIN0 enables for voltage bias, default=0
//
// @return 1 on success; 0 on failure
uint8_t MAX11410::Configure_MUX_CTRL2(uint8_t vbias_ain7_ain0_bitmap)
{
    
    //----------------------------------------
    // write8 0x0D MUX_CTRL2
    RegWrite(CMD_r000_1101_dddd_dddd_MUX_CTRL2, vbias_ain7_ain0_bitmap);
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Menu item 'X0'
//
// CAL_START Calibrate Self Offset and Gain.
//
// @return 1 on success; 0 on failure
uint8_t MAX11410::Calibrate_Self_Offset_Gain(void)
{
    
    //----------------------------------------
    // write8 0x03 CAL_START -- RegWrite will poll status until CAL_RDY
    RegWrite(CMD_r000_0011_xxxx_xddd_CAL_START, (uint8_t)CAL_TYPE_000_SELF_CAL);
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Menu item 'X1'
//
// CAL_START Calibrate Selected PGA.
//
// @return 1 on success; 0 on failure
uint8_t MAX11410::Calibrate_PGA_Gain(void)
{
    
    //----------------------------------------
    // write8 0x03 CAL_START -- RegWrite will poll status until CAL_RDY
    RegWrite(CMD_r000_0011_xxxx_xddd_CAL_START, (uint8_t)CAL_TYPE_001_PGA_GAIN);
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// CAL_START Calibrate System Offset A.
//
// @return 1 on success; 0 on failure
uint8_t MAX11410::Calibrate_System_Offset_A(void)
{
    
    //----------------------------------------
    // write8 0x03 CAL_START -- RegWrite will poll status until CAL_RDY
    RegWrite(CMD_r000_0011_xxxx_xddd_CAL_START, (uint8_t)CAL_TYPE_100_SYS_OFF_A);
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// CAL_START Calibrate System Gain A.
//
// @return 1 on success; 0 on failure
uint8_t MAX11410::Calibrate_System_Gain_A(void)
{
    
    //----------------------------------------
    // write8 0x03 CAL_START -- RegWrite will poll status until CAL_RDY
    RegWrite(CMD_r000_0011_xxxx_xddd_CAL_START, (uint8_t)CAL_TYPE_101_SYS_GAIN_A);
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// CAL_START Calibrate System Offset B.
//
// @return 1 on success; 0 on failure
uint8_t MAX11410::Calibrate_System_Offset_B(void)
{
    
    //----------------------------------------
    // write8 0x03 CAL_START -- RegWrite will poll status until CAL_RDY
    RegWrite(CMD_r000_0011_xxxx_xddd_CAL_START, (uint8_t)CAL_TYPE_110_SYS_OFF_B);
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// CAL_START Calibrate System Gain B.
//
// @return 1 on success; 0 on failure
uint8_t MAX11410::Calibrate_System_Gain_B(void)
{
    
    //----------------------------------------
    // write8 0x03 CAL_START -- RegWrite will poll status until CAL_RDY
    RegWrite(CMD_r000_0011_xxxx_xddd_CAL_START, (uint8_t)CAL_TYPE_111_SYS_GAIN_B);
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Menu item '$' -> AINcode[0], AINcode[1], AINcode[2], AINcode[3], AINcode[4], AINcode[5], AINcode[6], AINcode[7], AINcode[8], AINcode[9], AINcode[10]
//
// Measure all ADC channels in sequence.
// Diagnostic output pulse on GP0 for each channel's measurement.
// Diagnostic output pulse on GP1 for entire loop.
//
// @post AINcode[0..10]: measurement result LSB code
//
// @return 1 on success; 0 on failure
uint8_t MAX11410::Read_All_Voltages(void)
{
    
    //----------------------------------------
    // scan AIN0..AIN9
    //
    // diagnostic GPIO pulse on MAX11410 GP1 pin (0xc3 = logic 0, 0xc4 = logic 1)
    RegWrite(CMD_r000_0101_dddd_xddd_GP1_CTRL, 0xc3); // GP1 = 0
    //
    const MAX11410_AINN_SEL_enum_t ainn = AINN_SEL_1010_GND;
    for(uint8_t ainp =  /* MAX11410_AINP_SEL_enum_t:: */ AINP_SEL_0000_AIN0; ainp <=  /* MAX11410_AINP_SEL_enum_t:: */ AINP_SEL_1010_AVDD; ainp++)
    {
        // diagnostic GPIO pulse on MAX11410 GP0 pin (0xc3 = logic 0, 0xc4 = logic 1)
        RegWrite(CMD_r000_0100_dddd_xddd_GP0_CTRL, 0xc3); // GP0 = 0
        //
        Measure_Voltage((MAX11410_AINP_SEL_enum_t)ainp, ainn);
        // @post AINcode[ainp]: measurement result LSB code
        //
        // diagnostic GPIO pulse on MAX11410 GP0 pin (0xc3 = logic 0, 0xc4 = logic 1)
        RegWrite(CMD_r000_0100_dddd_xddd_GP0_CTRL, 0xc4); // GP0 = 1
        //
    }
    // diagnostic GPIO pulse on MAX11410 GP1 pin (0xc3 = logic 0, 0xc4 = logic 1)
    RegWrite(CMD_r000_0101_dddd_xddd_GP1_CTRL, 0xc4); // GP1 = 1
    //
    
    //----------------------------------------
    // success
    return 1;
}

//----------------------------------------
// Menu item 'V'
// Trigger Measurement for voltage input.
//
// Example code for typical voltage measurement.
//
// @pre external connection REF2P-REF2N is a reference voltage
// @pre VRef = Voltage of REF input, in Volts
// @pre v_filter = filter register configuration, 0x34 for LINEF_11_SINC4 RATE_0100 output data rate 60SPS
// @pre v_ctrl = ctrl register configuration, 0x02 for bipolar REF_SEL_010_REF2P_REF2N
// @pre v_pga = pga register configuration, 0x00 for SIG_PATH_00_BUFFERED GAIN_000_1
// @param[in] ainp = channel high side, default=AINP_SEL_0000_AIN0
// @param[in] ainn = channel low side, default=AINN_SEL_1010_GND
// @post AINcode[ainp]: measurement result LSB code
//
// Output data rate (sample rate) is determined by filter register.
// filter register configuration in Measure_Voltage CONV_TYPE_01_Continuous
// v_filter=0x00 -- LINEF_00_50Hz_60Hz_FIR  RATE_0000 |  1.1SPS
// v_filter=0x01 -- LINEF_00_50Hz_60Hz_FIR  RATE_0001 |  2.1SPS
// v_filter=0x02 -- LINEF_00_50Hz_60Hz_FIR  RATE_0010 |  4.2SPS
// v_filter=0x03 -- LINEF_00_50Hz_60Hz_FIR  RATE_0011 |  8.4SPS
// v_filter=0x04 -- LINEF_00_50Hz_60Hz_FIR  RATE_0100 | 16.8SPS
// v_filter=0x10 -- LINEF_01_50Hz_FIR       RATE_0000 |  1.3SPS
// v_filter=0x11 -- LINEF_01_50Hz_FIR       RATE_0001 |  2.7SPS
// v_filter=0x12 -- LINEF_01_50Hz_FIR       RATE_0010 |  5.3SPS
// v_filter=0x13 -- LINEF_01_50Hz_FIR       RATE_0011 | 10.7SPS
// v_filter=0x14 -- LINEF_01_50Hz_FIR       RATE_0100 | 21.3SPS
// v_filter=0x15 -- LINEF_01_50Hz_FIR       RATE_0101 | 40.0SPS
// v_filter=0x20 -- LINEF_10_60Hz_FIR       RATE_0000 |   1.3SPS
// v_filter=0x21 -- LINEF_10_60Hz_FIR       RATE_0001 |   2.7SPS
// v_filter=0x22 -- LINEF_10_60Hz_FIR       RATE_0010 |   5.3SPS
// v_filter=0x23 -- LINEF_10_60Hz_FIR       RATE_0011 |  10.7SPS
// v_filter=0x24 -- LINEF_10_60Hz_FIR       RATE_0100 |  21.3SPS
// v_filter=0x25 -- LINEF_10_60Hz_FIR       RATE_0101 |  40.0SPS
// v_filter=0x30 -- LINEF_11_SINC4          RATE_0000 |    4SPS
// v_filter=0x31 -- LINEF_11_SINC4          RATE_0001 |   10SPS
// v_filter=0x32 -- LINEF_11_SINC4          RATE_0010 |   20SPS
// v_filter=0x33 -- LINEF_11_SINC4          RATE_0011 |   40SPS
// v_filter=0x34 --*LINEF_11_SINC4          RATE_0100 |   60SPS
// v_filter=0x35 -- LINEF_11_SINC4          RATE_0101 |  120SPS
// v_filter=0x36 -- LINEF_11_SINC4          RATE_0110 |  240SPS
// v_filter=0x37 -- LINEF_11_SINC4          RATE_0111 |  480SPS
// v_filter=0x38 -- LINEF_11_SINC4          RATE_1000 |  960SPS
// v_filter=0x39 -- LINEF_11_SINC4          RATE_1001 | 1920SPS
//
// @return ideal voltage calculated from raw LSB code and reference voltage
double MAX11410::Measure_Voltage(MAX11410_AINP_SEL_enum_t ainp, MAX11410_AINN_SEL_enum_t ainn)
{
    
    //----------------------------------------
    // restrict channel selection to valid index range
    if ((uint8_t)ainp >  /* MAX11410_AINP_SEL_enum_t:: */ AINP_SEL_1010_AVDD)
    {
        ainp =  /* MAX11410_AINP_SEL_enum_t:: */ AINP_SEL_1010_AVDD;
    }
    
    //----------------------------------------
    // restrict channel selection to valid index range
    if ((uint8_t)ainn >  /* MAX11410_AINN_SEL_enum_t:: */ AINN_SEL_1010_GND)
    {
        ainn =  /* MAX11410_AINN_SEL_enum_t:: */ AINN_SEL_1010_GND;
    }
    
    //----------------------------------------
    // write8 0x0B MUX_CTRL0 = 0x0A to select AINP=AIN0 and AINN=GND
    Configure_MUX_CTRL0((uint8_t)ainp, (uint8_t)ainn);
    
    //----------------------------------------
    // write8 0x09 CTRL to select reference and Data Format (Unipolar or Bipolar)
    RegWrite(CMD_r000_1001_dddd_dddd_CTRL, v_ctrl);
    ctrl = v_ctrl;
    
    //----------------------------------------
    // write8 0x0E PGA and update pgaGain
    Configure_PGA(
            ((v_pga >> 4) & 2),  // sigpath
            ( v_pga       & 7)); // gain
    
    //----------------------------------------
    // write8 0x08 FILTER to select output data rate
    RegWrite(CMD_r000_1000_x0dd_dddd_FILTER, v_filter);
    
    //----------------------------------------
    // write8 0x01 CONV_START = 0x01 to set Conversion Mode = Continuous
    RegWrite(CMD_r000_0001_xddd_xxdd_CONV_START, 0x01);
    
    //----------------------------------------
    // purge old data from data0 register
    RegRead(CMD_r011_0000_dddd_dddd_dddd_dddd_dddd_dddd_DATA0, &AINcode[((int)ainp & 0x0F)]);
    data0 = AINcode[((int)ainp & 0x0F)];
    
    //----------------------------------------
    // read24 0x80|0x38 STATUS (%SW 0xB8 0 0 0)
    RegRead(CMD_r011_1000_dddd_dddd_dddd_dddd_dxxx_dddd_STATUS, &status);
    
    //----------------------------------------
    // wait until STATUS_enum_t::STATUS_000010_DATA_RDY indicates data is available
    // A bad SPI interface can cause bit slippage, which makes this loop get stuck. Expect *PART_ID? = 0x000F02
    // while ((status &  /* MAX11410_STATUS_enum_t:: */ STATUS_000010_DATA_RDY) == 0) {
    // possible infinite loop; need a timeout or futility countdown to escape
    for (int futility_countdown = loop_limit;
        ((futility_countdown > 0) &&
        ((status &  /* MAX11410_STATUS_enum_t:: */ STATUS_000010_DATA_RDY) == 0));
        futility_countdown--)
    {
        RegRead(CMD_r011_1000_dddd_dddd_dddd_dddd_dxxx_dddd_STATUS, &status);
#if 1
        // improve response time at the cost of more program size
        if (futility_countdown < (loop_limit - 5)) {
            wait_ms(1); // timing delay function, platform-specific
        }
        if (futility_countdown < (loop_limit - 10)) {
            wait_ms(2); // timing delay function, platform-specific
        }
        if (futility_countdown < (loop_limit - 15)) {
            wait_ms(5); // timing delay function, platform-specific
        }
        if (futility_countdown < (loop_limit - 20)) {
            wait_ms(10); // timing delay function, platform-specific
        }
        if (futility_countdown < (loop_limit - 25)) {
            wait_ms(20); // timing delay function, platform-specific
        }
        if (futility_countdown < (loop_limit - 30)) {
            wait_ms(50); // timing delay function, platform-specific
        }
        if (futility_countdown < (loop_limit - 35)) {
            wait_ms(100); // timing delay function, platform-specific
        }
#else
        if (loop_limit > 5) {
            wait_ms(20); // timing delay function, platform-specific
        }
        if (loop_limit > 10) {
            wait_ms(50); // timing delay function, platform-specific
        }
        if (loop_limit > 30) {
            wait_ms(100); // timing delay function, platform-specific
        }
#endif
    }
    
    //----------------------------------------
    // read24 0x80|0x30 DATA0 (%SW 0xB0 0 0 0): AINcode[ainp] = measurement
    RegRead(CMD_r011_0000_dddd_dddd_dddd_dddd_dddd_dddd_DATA0, &AINcode[((int)ainp & 0x0F)]);
    data0 = AINcode[((int)ainp & 0x0F)];
    
    //----------------------------------------
    // ideal voltage calculated from raw LSB code and reference voltage
    return VoltageOfCode(AINcode[((int)ainp & 0x0F)]);
}

//----------------------------------------
// Menu item 'R' -> rtd_ohm, rtd_degc
// Trigger Measurement for Resistive Temperature Device (RTD).
//
// Example code for typical RTD measurement.
//
// @pre external connection REF1P-REF1N is a reference resistor
// @pre ref1_v = reference resistance in ohms, default=4999
// @pre rtd_filter = filter register configuration, 0x34 for LINEF_11_SINC4 RATE_0100 output data rate 60SPS
// @pre rtd_ctrl = ctrl register configuration, 0x40 for ref0_v, 0x41 for ref1_v, 0x42 for ref2_v
// @pre rtd_souce = souce register configuration, 0x0B for IDAC_MODE_1011_400uA
// @pre rtd_pga = pga register configuration, 0x21 for SIG_PATH_10_PGA GAIN_001_2
// @param[in] rtd_iout = channel RTD high side force, default=AINP_SEL_0111_AIN7
// @param[in] rtd_ainp = channel RTD high side sense, default=AINP_SEL_1000_AIN8
// @param[in] rtd_ainn = channel RTD low side, default=AINN_SEL_1001_AIN9
// @post AINcode[rtd_ainp]: measurement result LSB code
// @post rtd_ohm: measurement result resistance in Ohms
// @post rtd_degc: Temperature calculated from RTD Resistance; Thermocouple Cold Junction, in degrees C
//
// Output data rate (sample rate) is determined by filter register.
// filter register configuration in Measure_RTD CONV_TYPE_01_Continuous
// rtd_filter=0x00 -- LINEF_00_50Hz_60Hz_FIR  RATE_0000 |  1.1SPS
// rtd_filter=0x01 -- LINEF_00_50Hz_60Hz_FIR  RATE_0001 |  2.1SPS
// rtd_filter=0x02 -- LINEF_00_50Hz_60Hz_FIR  RATE_0010 |  4.2SPS
// rtd_filter=0x03 -- LINEF_00_50Hz_60Hz_FIR  RATE_0011 |  8.4SPS
// rtd_filter=0x04 -- LINEF_00_50Hz_60Hz_FIR  RATE_0100 | 16.8SPS
// rtd_filter=0x10 -- LINEF_01_50Hz_FIR       RATE_0000 |  1.3SPS
// rtd_filter=0x11 -- LINEF_01_50Hz_FIR       RATE_0001 |  2.7SPS
// rtd_filter=0x12 -- LINEF_01_50Hz_FIR       RATE_0010 |  5.3SPS
// rtd_filter=0x13 -- LINEF_01_50Hz_FIR       RATE_0011 | 10.7SPS
// rtd_filter=0x14 -- LINEF_01_50Hz_FIR       RATE_0100 | 21.3SPS
// rtd_filter=0x15 -- LINEF_01_50Hz_FIR       RATE_0101 | 40.0SPS
// rtd_filter=0x20 -- LINEF_10_60Hz_FIR       RATE_0000 |   1.3SPS
// rtd_filter=0x21 -- LINEF_10_60Hz_FIR       RATE_0001 |   2.7SPS
// rtd_filter=0x22 -- LINEF_10_60Hz_FIR       RATE_0010 |   5.3SPS
// rtd_filter=0x23 -- LINEF_10_60Hz_FIR       RATE_0011 |  10.7SPS
// rtd_filter=0x24 -- LINEF_10_60Hz_FIR       RATE_0100 |  21.3SPS
// rtd_filter=0x25 -- LINEF_10_60Hz_FIR       RATE_0101 |  40.0SPS
// rtd_filter=0x30 -- LINEF_11_SINC4          RATE_0000 |    4SPS
// rtd_filter=0x31 -- LINEF_11_SINC4          RATE_0001 |   10SPS
// rtd_filter=0x32 -- LINEF_11_SINC4          RATE_0010 |   20SPS
// rtd_filter=0x33 -- LINEF_11_SINC4          RATE_0011 |   40SPS
// rtd_filter=0x34 --*LINEF_11_SINC4          RATE_0100 |   60SPS
// rtd_filter=0x35 -- LINEF_11_SINC4          RATE_0101 |  120SPS
// rtd_filter=0x36 -- LINEF_11_SINC4          RATE_0110 |  240SPS
// rtd_filter=0x37 -- LINEF_11_SINC4          RATE_0111 |  480SPS
// rtd_filter=0x38 -- LINEF_11_SINC4          RATE_1000 |  960SPS
// rtd_filter=0x39 -- LINEF_11_SINC4          RATE_1001 | 1920SPS
//
// @return resistance calculated from raw LSB code and reference resistance
double MAX11410::Measure_RTD(MAX11410_AINP_SEL_enum_t rtd_iout, MAX11410_AINP_SEL_enum_t rtd_ainp, MAX11410_AINN_SEL_enum_t rtd_ainn)
{
    
    //----------------------------------------
    // restrict channel selection to valid index range
    if ((uint8_t)rtd_iout >  /* MAX11410_AINP_SEL_enum_t:: */ AINP_SEL_1010_AVDD)
    {
        rtd_iout =  /* MAX11410_AINP_SEL_enum_t:: */ AINP_SEL_1010_AVDD;
    }
    
    //----------------------------------------
    // restrict channel selection to valid index range
    if ((uint8_t)rtd_ainp >  /* MAX11410_AINP_SEL_enum_t:: */ AINP_SEL_1010_AVDD)
    {
        rtd_ainp =  /* MAX11410_AINP_SEL_enum_t:: */ AINP_SEL_1010_AVDD;
    }
    
    //----------------------------------------
    // restrict channel selection to valid index range
    if ((uint8_t)rtd_ainn >  /* MAX11410_AINN_SEL_enum_t:: */ AINN_SEL_1010_GND)
    { 
        rtd_ainn =  /* MAX11410_AINN_SEL_enum_t:: */ AINN_SEL_1010_GND;
    }
    
    //----------------------------------------
    // write8 0x08 FILTER to select output data rate
    RegWrite(CMD_r000_1000_x0dd_dddd_FILTER, rtd_filter);
    
    //----------------------------------------
    // write8 0x09 CTRL to select reference resistor REF1P/REF1N; Data Format = Unipolar
    RegWrite(CMD_r000_1001_dddd_dddd_CTRL, rtd_ctrl);
    ctrl = rtd_ctrl;
    
    //----------------------------------------
    // write8 0x0A SOURCE to select IDAC_MODE 400uA; AIN9=2.000V, AIN8(PT100)=2.040V, AIN8(PT1000)=2.400V
    RegWrite(CMD_r000_1010_dddd_dddd_SOURCE, rtd_source);
    
    //----------------------------------------
    // write8 0x0B MUX_CTRL0 = 0x89 to select AINP=AIN8 and AINN=AIN9
    Configure_MUX_CTRL0((uint8_t)rtd_ainp, (uint8_t)rtd_ainn);
    
    //----------------------------------------
    // write8 0x0C MUX_CTRL1 = 0xF7 to select IDAC1_SEL=NC, IDAC0_SEL=AIN7
    Configure_MUX_CTRL1((uint8_t)IDAC1_SEL_1111_unconnected, (uint8_t)rtd_iout);
    
    //----------------------------------------
    // write8 0x0E PGA and update pgaGain
    Configure_PGA(
            ((rtd_pga >> 4) & 2),  // sigpath
            ( rtd_pga       & 7)); // gain
    
    //----------------------------------------
    // diagnostic GPIO pulse on GP1 during RTD power-up interval rtd_ms
    RegWrite(CMD_r000_0101_dddd_xddd_GP1_CTRL, 0xc3); // diagnostic GPIO pulse GP1
            // write8 0x05 GP1_CTRL (%SW 0x05 0xc3) 11000 output 011 logic 0
    
    //----------------------------------------
    // timing delay after enable RTD bias current
    wait_ms(rtd_ms); // timing delay function, platform-specific
    
    //----------------------------------------
    // diagnostic GPIO pulse on GP1 during RTD power-up interval rtd_ms
    RegWrite(CMD_r000_0101_dddd_xddd_GP1_CTRL, 0xc4); // diagnostic GPIO pulse GP1
            // write8 0x05 GP1_CTRL (%SW 0x05 0xc4) 11000 output 100 logic 1
    
    //----------------------------------------
    // write8 0x01 CONV_START = 0x01 to set Conversion Mode = Continuous
    RegWrite(CMD_r000_0001_xddd_xxdd_CONV_START, 0x01);
    
    //----------------------------------------
    // purge old data from data0 register
    RegRead(CMD_r011_0000_dddd_dddd_dddd_dddd_dddd_dddd_DATA0, &AINcode[((int)rtd_ainp & 0x0F)]);
    data0 = AINcode[((int)rtd_ainp & 0x0F)];
    
    //----------------------------------------
    // read24 0x80|0x38 STATUS (%SW 0xB8 0 0 0)
    RegRead(CMD_r011_1000_dddd_dddd_dddd_dddd_dxxx_dddd_STATUS, &status);
    
    //----------------------------------------
    // wait until STATUS_enum_t::STATUS_000010_DATA_RDY indicates data is available
    // A bad SPI interface can cause bit slippage, which makes this loop get stuck. Expect *PART_ID? = 0x000F02
    // while ((status &  /* MAX11410_STATUS_enum_t:: */ STATUS_000010_DATA_RDY) == 0) {
    // possible infinite loop; need a timeout or futility countdown to escape
    for (int futility_countdown = loop_limit;
        ((futility_countdown > 0) &&
        ((status &  /* MAX11410_STATUS_enum_t:: */ STATUS_000010_DATA_RDY) == 0));
        futility_countdown--)
    {
        RegRead(CMD_r011_1000_dddd_dddd_dddd_dddd_dxxx_dddd_STATUS, &status);
    }
    
    //----------------------------------------
    // read24 0x80|0x30 DATA0 (%SW 0xB0 0 0 0): AINcode[ainp] = measurement
    RegRead(CMD_r011_0000_dddd_dddd_dddd_dddd_dddd_dddd_DATA0, &AINcode[((int)rtd_ainp & 0x0F)]);
    data0 = AINcode[((int)rtd_ainp & 0x0F)];
    
    //----------------------------------------
    // turn off RTD bias current to avoid self-heating (unless rtd_ms is 0)
    if (rtd_ms != 0)
    {
        // write8 0x0C MUX_CTRL1 = 0xFF to select IDAC1_SEL=NC, IDAC0_SEL=NC
        Configure_MUX_CTRL1((uint8_t)IDAC1_SEL_1111_unconnected, (uint8_t)IDAC0_SEL_1111_unconnected);
    }
    
    //----------------------------------------
    // resistance calculated from raw LSB code and ref1_v reference resistance in ohms
    rtd_ohm = VoltageOfCode(AINcode[((int)rtd_ainp & 0x0F)]);
    TemperatureOfRTD(rtd_ohm); // calculate rtd_degc
    return rtd_ohm;
}

//----------------------------------------
// Return the physical temperature corresponding to measured resistance
// of a PT1000 type Resistive Temperature Device (RTD).
//
// @param[in] rtd_ohm = RTD resistance in ohms, default=1000
// @post rtd_degc: Temperature calculated from RTD Resistance; Thermocouple Cold Junction, in degrees C
//
// @return ideal temperature in degrees C, calculated from RTD resistance in ohms
// @test group RTD_PT1000 // PT1000 type Resistive Temperature Device (RTD)
// @test group RTD_PT1000 tinyTester.blink_time_msec = 20 // quickly speed through the software verification
// @test group RTD_PT1000 TemperatureOfRTD_PT1000(842.94) expect -40.0 within 0.1 // PT-1000 RTD at -40C
// @test group RTD_PT1000 TemperatureOfRTD_PT1000(1000.0) expect 0.0   within 0.1 // PT-1000 RTD at 0C
// @test group RTD_PT1000 TemperatureOfRTD_PT1000(1097.3) expect 25.0  within 0.1 // PT-1000 RTD at 25C
// @test group RTD_PT1000 TemperatureOfRTD_PT1000(1328.1) expect 85.0  within 0.1 // PT-1000 RTD at 85C
// @test group RTD_PT1000 TemperatureOfRTD_PT1000(1479.5) expect 125.0 within 0.1 // PT-1000 RTD at 125C
// @test group RTD_PT1000 tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
//
double MAX11410::TemperatureOfRTD_PT1000(double rtd_ohm)
{
    
    //----------------------------------------
    // Temperature from RTD Resistance maths
    // ITS-90 PT-1000 RTD
    double R0 = 1000.0;
    double a = 3.9083e-3;
    double b = -5.7750e-7;
    // calculate T from R and R0
    double sqrtTerm = sqrt(R0*R0 * a*a - 4*R0*b*(R0 - rtd_ohm));
    double denominator = 2 * R0 * b;
    rtd_degc = ((-R0 * a) + (sqrtTerm)) / denominator;
    return rtd_degc;
}

//----------------------------------------
// Return the physical temperature corresponding to measured resistance
// of a PT100 type Resistive Temperature Device (RTD).
//
// @param[in] rtd_ohm = RTD resistance in ohms, default=100
// @post rtd_degc: Temperature calculated from RTD Resistance; Thermocouple Cold Junction, in degrees C
//
// @return ideal temperature in degrees C, calculated from RTD resistance in ohms
// @test group RTD_PT100 // PT100 type Resistive Temperature Device (RTD)
// @test group RTD_PT100 tinyTester.blink_time_msec = 20 // quickly speed through the software verification
// @test group RTD_PT100 TemperatureOfRTD_PT100(84.294) expect -40.0 within 0.1 // PT-100 RTD at -40C
// @test group RTD_PT100 TemperatureOfRTD_PT100(100.00) expect 0.0   within 0.1 // PT-100 RTD at 0C
// @test group RTD_PT100 TemperatureOfRTD_PT100(109.73) expect 25.0  within 0.1 // PT-100 RTD at 25C
// @test group RTD_PT100 TemperatureOfRTD_PT100(132.81) expect 85.0  within 0.1 // PT-100 RTD at 85C
// @test group RTD_PT100 TemperatureOfRTD_PT100(147.95) expect 125.0 within 0.1 // PT-100 RTD at 125C
// @test group RTD_PT100 tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
//
double MAX11410::TemperatureOfRTD_PT100(double rtd_ohm)
{
    
    //----------------------------------------
    // Temperature from RTD Resistance maths
    // ITS-90 PT-100 RTD
    double R0 = 100.0;
    double a = 3.9083e-3;
    double b = -5.7750e-7;
    // calculate T from R and R0
    double sqrtTerm = sqrt(R0*R0 * a*a - 4*R0*b*(R0 - rtd_ohm));
    double denominator = 2 * R0 * b;
    rtd_degc = ((-R0 * a) + (sqrtTerm)) / denominator;
    return rtd_degc;
}

//----------------------------------------
// Return the physical temperature corresponding to measured resistance
// of a PT100 or PT1000 type Resistive Temperature Device (RTD).
//
// @param[in] rtd_ohm = RTD resistance in ohms, default=100
// @post rtd_degc: Temperature calculated from RTD Resistance; Thermocouple Cold Junction, in degrees C
//
// @return ideal temperature in degrees C, calculated from RTD resistance in ohms
// @test group RTD // Verify function TemperatureOfRTD
// @test group RTD tinyTester.blink_time_msec = 20 // quickly speed through the software verification
// @test group RTD TemperatureOfRTD(84.294) expect -40.0 within 0.1 // PT-100 RTD at -40C
// @test group RTD TemperatureOfRTD(100.00) expect 0.0   within 0.1 // PT-100 RTD at 0C
// @test group RTD TemperatureOfRTD(109.73) expect 25.0  within 0.1 // PT-100 RTD at 25C
// @test group RTD TemperatureOfRTD(132.81) expect 85.0  within 0.1 // PT-100 RTD at 85C
// @test group RTD TemperatureOfRTD(147.95) expect 125.0 within 0.1 // PT-100 RTD at 125C
// @test group RTD TemperatureOfRTD(842.94) expect -40.0 within 0.1 // PT-1000 RTD at -40C
// @test group RTD TemperatureOfRTD(1000.0) expect 0.0   within 0.1 // PT-1000 RTD at 0C
// @test group RTD TemperatureOfRTD(1097.3) expect 25.0  within 0.1 // PT-1000 RTD at 25C
// @test group RTD TemperatureOfRTD(1328.1) expect 85.0  within 0.1 // PT-1000 RTD at 85C
// @test group RTD TemperatureOfRTD(1479.5) expect 125.0 within 0.1 // PT-1000 RTD at 125C
// @test group RTD tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
//
double MAX11410::TemperatureOfRTD(double rtd_ohm)
{
    
    //----------------------------------------
    // return TemperatureOfRTD_PT100 or TemperatureOfRTD_PT1000
    if (rtd_ohm > 500.0)
    {
        return TemperatureOfRTD_PT1000(rtd_ohm);
    }
    else
    {
        return TemperatureOfRTD_PT100(rtd_ohm);
    }
}

//----------------------------------------
// Menu item 'TM' -> tc_v, tc_delta_degc, tc_degc
// Trigger Measurement for Thermocouple
//
// Example code for typical Thermocouple measurement.
// An RTD measures the "cold junction" where TC connects to the board,
// and the TC measures the temperature difference above the cold junction.
//
// @param[in] tc_ainp = channel of Thermocouple high side, default=AINP_SEL_0101_AIN5
// @param[in] tc_ainn = channel of Thermocouple low side, default=AINN_SEL_0110_AIN6
// @param[in] rtd_iout = channel RTD high side force, default=AINP_SEL_0111_AIN7
// @param[in] rtd_ainp = channel RTD high side sense, default=AINP_SEL_1000_AIN8
// @param[in] rtd_ainn = channel RTD low side, default=AINN_SEL_1001_AIN9
// @post AINcode[tc_ainp]: measurement result LSB code
// @post tc_v: raw thermocouple voltage in Volts
// @post tc_delta_degc: temperature in degC above cold junction
// @post tc_degc: temperature in degC
//
// @return 1 on success; 0 on failure
double MAX11410::Measure_Thermocouple(MAX11410_AINP_SEL_enum_t tc_ainp, MAX11410_AINN_SEL_enum_t tc_ainn, MAX11410_AINP_SEL_enum_t rtd_iout, MAX11410_AINP_SEL_enum_t rtd_ainp, MAX11410_AINN_SEL_enum_t rtd_ainn)
{
    
    //----------------------------------------
    // restrict channel selection to valid index range
    if ((uint8_t)tc_ainp >  /* MAX11410_AINP_SEL_enum_t:: */ AINP_SEL_1010_AVDD)
    {
        tc_ainp =  /* MAX11410_AINP_SEL_enum_t:: */ AINP_SEL_1010_AVDD;
    }
    
    //----------------------------------------
    // restrict channel selection to valid index range
    if ((uint8_t)tc_ainn >  /* MAX11410_AINN_SEL_enum_t:: */ AINN_SEL_1010_GND)
    {
        tc_ainn =  /* MAX11410_AINN_SEL_enum_t:: */ AINN_SEL_1010_GND;
    }
    
    //----------------------------------------
    // restrict channel selection to valid index range
    if ((uint8_t)rtd_iout >  /* MAX11410_AINP_SEL_enum_t:: */ AINP_SEL_1010_AVDD)
    {
        rtd_iout =  /* MAX11410_AINP_SEL_enum_t:: */ AINP_SEL_1010_AVDD;
    }
    
    //----------------------------------------
    // restrict channel selection to valid index range
    if ((uint8_t)rtd_ainp >  /* MAX11410_AINP_SEL_enum_t:: */ AINP_SEL_1010_AVDD)
    {
        rtd_ainp =  /* MAX11410_AINP_SEL_enum_t:: */ AINP_SEL_1010_AVDD;
    }
    
    //----------------------------------------
    // restrict channel selection to valid index range
    if ((uint8_t)rtd_ainn >  /* MAX11410_AINN_SEL_enum_t:: */ AINN_SEL_1010_GND)
    { 
        rtd_ainn =  /* MAX11410_AINN_SEL_enum_t:: */ AINN_SEL_1010_GND;
    }
    
    //----------------------------------------
    // write8 0x0B MUX_CTRL0 = 0x0A to select AINP=AIN0 and AINN=GND
    Configure_MUX_CTRL0((uint8_t)tc_ainp, (uint8_t)tc_ainn);
    
    //----------------------------------------
    // write8 0x09 CTRL to select reference REF2P/REF2N; Data Format = Bipolar 2's Complement
    Configure_CTRL(/*extclk*/ 0, /*u_bn*/ 0, /*format*/ 0,
                /*refbufp_en*/ 0, /*refbufn_en*/ 0,
                /*ref_sel*/ (uint8_t)REF_SEL_010_REF2P_REF2N);
    
    //----------------------------------------
    // write8 0x0E PGA
    Configure_PGA((uint8_t) /* MAX11410_SIG_PATH_enum_t:: */ SIG_PATH_00_BUFFERED, 
                (uint8_t) /* MAX11410_GAIN_enum_t:: */ GAIN_000_1);
    
    //----------------------------------------
    // write8 0x08 FILTER = 0x34 to select RATE_0100, LINEF_11_SINC4 60SPS (given CONV_TYPE_01_Continuous)
    Configure_FILTER((uint8_t) /* MAX11410::MAX11410_LINEF_enum_t:: */ LINEF_11_SINC4,
                (uint8_t) /* MAX11410::MAX11410_RATE_enum_t:: */ RATE_0100);
    
    //----------------------------------------
    // write8 0x01 CONV_START = 0x01 to set Conversion Mode = Continuous
    RegWrite(CMD_r000_0001_xddd_xxdd_CONV_START, 0x01);
    
    //----------------------------------------
    // purge old data from data0 register
    RegRead(CMD_r011_0000_dddd_dddd_dddd_dddd_dddd_dddd_DATA0, &AINcode[((int)tc_ainp & 0x0F)]);
    data0 = AINcode[((int)tc_ainp & 0x0F)];
    
    //----------------------------------------
    // read24 0x80|0x38 STATUS (%SW 0xB8 0 0 0)
    RegRead(CMD_r011_1000_dddd_dddd_dddd_dddd_dxxx_dddd_STATUS, &status);
    
    //----------------------------------------
    // wait until STATUS_enum_t::STATUS_000010_DATA_RDY indicates data is available
    // A bad SPI interface can cause bit slippage, which makes this loop get stuck. Expect *PART_ID? = 0x000F02
    // while ((status &  /* MAX11410_STATUS_enum_t:: */ STATUS_000010_DATA_RDY) == 0) {
    // possible infinite loop; need a timeout or futility countdown to escape
    for (int futility_countdown = loop_limit;
        ((futility_countdown > 0) &&
        ((status &  /* MAX11410_STATUS_enum_t:: */ STATUS_000010_DATA_RDY) == 0));
        futility_countdown--)
    {
        RegRead(CMD_r011_1000_dddd_dddd_dddd_dddd_dxxx_dddd_STATUS, &status);
    }
    
    //----------------------------------------
    // read24 0x80|0x30 DATA0 (%SW 0xB0 0 0 0): AINcode[tc_ainp] = measurement
    RegRead(CMD_r011_0000_dddd_dddd_dddd_dddd_dddd_dddd_DATA0, &AINcode[((int)tc_ainp & 0x0F)]);
    data0 = AINcode[((int)tc_ainp & 0x0F)];
    
    //----------------------------------------
    // ideal voltage calculated from raw LSB code and reference voltage
    tc_v = VoltageOfCode(AINcode[((int)tc_ainp & 0x0F)]);
    
    //----------------------------------------
    // ideal voltage calculated from raw LSB code and reference voltage
    tc_delta_degc = TemperatureOfTC_TypeK(tc_v);
    
    //----------------------------------------
    // ideal voltage calculated from raw LSB code and reference voltage
    tc_degc = rtd_degc + tc_delta_degc;
    
    //----------------------------------------
    // ideal voltage calculated from raw LSB code and reference voltage
    return tc_v;
}

//----------------------------------------
// Return the physical temperature corresponding to measured voltage
// of a type K Thermocouple (TC).
//
// @pre {0}.rtd_degc = cold junction temperature, in degrees C
// @param[in] tc_v = Thermocouple voltage in volts, default=0.0254
//
// @return ideal temperature in degrees C, calculated from RTD resistance in ohms
// @test group TC_1 // Verify Thermocouple function TemperatureOfTC_TypeK
// @test group TC_2 // Verify Thermocouple function TemperatureOfTC_TypeK in more detail
// @test group TC_1 tinyTester.blink_time_msec = 20 // quickly speed through the software verification
// @test group TC_1 TemperatureOfTC_TypeK(0.000e-3) expect  0.0    within 0.1 // TC_TypeK at   0C = 0.000mV
// @test group TC_1 TemperatureOfTC_TypeK(0.039e-3) expect  1.0    within 0.1 // TC_TypeK at   1C = 0.039mV
// @test group TC_1 TemperatureOfTC_TypeK(0.079e-3) expect  2.0    within 0.1 // TC_TypeK at   2C = 0.079mV
// @test group TC_1 TemperatureOfTC_TypeK(0.119e-3) expect  3.0    within 0.1 // TC_TypeK at   3C = 0.119mV
// @test group TC_2 TemperatureOfTC_TypeK(0.158e-3) expect  4.0     within 0.1 // TC_TypeK at   4C = 0.158mV
// @test group TC_2 TemperatureOfTC_TypeK(0.198e-3) expect  5.0     within 0.1 // TC_TypeK at   5C = 0.198mV
// @test group TC_2 TemperatureOfTC_TypeK(0.238e-3) expect  6.0     within 0.1 // TC_TypeK at   6C = 0.238mV
// @test group TC_2 TemperatureOfTC_TypeK(0.2775e-3) expect  7.0    within 0.1 // TC_TypeK at   7C = 0.2775mV
// @test group TC_2 TemperatureOfTC_TypeK(0.317e-3) expect  8.0     within 0.1 // TC_TypeK at   8C = 0.317mV
// @test group TC_2 TemperatureOfTC_TypeK(0.357e-3) expect  9.0     within 0.1 // TC_TypeK at   9C = 0.357mV
// @test group TC_1 TemperatureOfTC_TypeK(0.397e-3) expect 10.0    within 0.1 // TC_TypeK at  10C = 0.397mV
// @test group TC_1 TemperatureOfTC_TypeK(0.798e-3) expect 20.0    within 0.1 // TC_TypeK at  20C = 0.798mV
// @test group TC_1 TemperatureOfTC_TypeK(1.081e-3) expect 27.0    within 0.1 // TC_TypeK at  27C = 1.081mV
// @test group TC_1 TemperatureOfTC_TypeK(1.203e-3) expect 30.0    within 0.1 // TC_TypeK at  30C = 1.203mV
// @test group TC_1 TemperatureOfTC_TypeK(1.612e-3) expect 40.0    within 0.1 // TC_TypeK at  40C = 1.612mV
// @test group TC_1 TemperatureOfTC_TypeK(2.023e-3) expect 50.0    within 0.1 // TC_TypeK at  50C = 2.023mV
// @test group TC_1 TemperatureOfTC_TypeK(2.436e-3) expect 60.0    within 0.1 // TC_TypeK at  60C = 2.436mV
// @test group TC_1 TemperatureOfTC_TypeK(2.851e-3) expect 70.0    within 0.1 // TC_TypeK at  70C = 2.851mV
// @test group TC_1 TemperatureOfTC_TypeK(3.267e-3) expect 80.0    within 0.1 // TC_TypeK at  80C = 3.267mV
// @test group TC_1 TemperatureOfTC_TypeK(3.682e-3) expect 90.0    within 0.1 // TC_TypeK at  90C = 3.682mV
// @test group TC_1 TemperatureOfTC_TypeK(4.096e-3) expect 100.0   within 0.1 // TC_TypeK at  100C = 4.096mV
// @test group TC_2 TemperatureOfTC_TypeK(4.509e-3) expect 110.0    within 0.1 // TC_TypeK at  110C = 4.509mV
// @test group TC_2 TemperatureOfTC_TypeK(4.920e-3) expect 120.0    within 0.1 // TC_TypeK at  120C = 4.920mV
// @test group TC_2 TemperatureOfTC_TypeK(5.328e-3) expect 130.0    within 0.1 // TC_TypeK at  130C = 5.328mV
// @test group TC_2 TemperatureOfTC_TypeK(5.735e-3) expect 140.0    within 0.1 // TC_TypeK at  140C = 5.735mV
// @test group TC_2 TemperatureOfTC_TypeK(6.138e-3) expect 150.0    within 0.1 // TC_TypeK at  150C = 6.138mV
// @test group TC_2 TemperatureOfTC_TypeK(6.540e-3) expect 160.0    within 0.1 // TC_TypeK at  160C = 6.540mV
// @test group TC_2 TemperatureOfTC_TypeK(6.941e-3) expect 170.0    within 0.1 // TC_TypeK at  170C = 6.941mV
// @test group TC_2 TemperatureOfTC_TypeK(7.340e-3) expect 180.0    within 0.1 // TC_TypeK at  180C = 7.340mV
// @test group TC_1 TemperatureOfTC_TypeK(7.739e-3) expect 190.0   within 0.1 // TC_TypeK at  190C = 7.739mV
// @test group TC_1 TemperatureOfTC_TypeK(8.138e-3) expect 200.0   within 0.1 // TC_TypeK at  200C = 8.138mV
// @test group TC_1 TemperatureOfTC_TypeK(8.539e-3) expect 210.0   within 0.1 // TC_TypeK at  210C = 8.539mV
// @test group TC_1 TemperatureOfTC_TypeK(8.940e-3) expect 220.0   within 0.1 // TC_TypeK at  220C = 8.940mV
// @test group TC_2 TemperatureOfTC_TypeK(9.343e-3) expect 230.0    within 0.1 // TC_TypeK at  230C = 9.343mV
// @test group TC_2 TemperatureOfTC_TypeK(9.747e-3) expect 240.0    within 0.1 // TC_TypeK at  240C = 9.747mV
// @test group TC_2 TemperatureOfTC_TypeK(10.153e-3) expect 250.0   within 0.1 // TC_TypeK at  250C = 10.153mV
// @test group TC_2 TemperatureOfTC_TypeK(10.561e-3) expect 260.0   within 0.1 // TC_TypeK at  260C = 10.561mV
// @test group TC_2 TemperatureOfTC_TypeK(10.971e-3) expect 270.0   within 0.1 // TC_TypeK at  270C = 10.971mV
// @test group TC_2 TemperatureOfTC_TypeK(11.382e-3) expect 280.0   within 0.1 // TC_TypeK at  280C = 11.382mV
// @test group TC_2 TemperatureOfTC_TypeK(11.795e-3) expect 290.0   within 0.1 // TC_TypeK at  290C = 11.795mV
// @test group TC_1 TemperatureOfTC_TypeK(12.209e-3) expect 300.0  within 0.1 // TC_TypeK at  300C = 12.209mV
// @test group TC_2 TemperatureOfTC_TypeK(14.293e-3) expect 350.0   within 0.1 // TC_TypeK at  350C = 14.293mV
// @test group TC_1 TemperatureOfTC_TypeK(16.397e-3) expect 400.0  within 0.1 // TC_TypeK at  400C = 16.397mV
// @test group TC_1 TemperatureOfTC_TypeK(18.516e-3) expect 450.0  within 0.1 // TC_TypeK at  450C = 18.516mV
// @test group TC_1 TemperatureOfTC_TypeK(20.218e-3) expect 490.0  // TC_TypeK at  490C = 20.218mV
// @test group TC_1 tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
//
double MAX11410::TemperatureOfTC_TypeK(double tc_v)
{
    
    //----------------------------------------
    // Temperature from TC_TypeK voltage maths
    // define standard TC_TypeK coefficients
    // ITS-90 Thermocouple Inverse Polynomial for a Type K thermocouple
    // calculate deltaT from tc_v
    //
    // Voltage range -5891uV < tc_v < 0uV, 
    // Temperature Range -200 deg C to 0 deg C
    static double coefficients_TCtypeK_V_lt_0[] = {
         0.00000,
         2.5173462e-2,
        -1.1662878e-6,
        -1.0833638e-9,
        -8.9773540e-13,
        -3.7342377e-16,
        -8.6632643e-20,
        -1.0450598e-23,
        -5.1920577e-28,
    };
    //
    // Voltage range 0uV < tc_v < 20.644uV, 
    // Temperature Range 0 deg C to 500 deg C
    static double coefficients_TCtypeK_0_lt_V_lt_20u644V[] = {
         0.00000,
         2.508355e-2,
         7.860106e-8,
        -2.503131e-10,
         8.315270e-14,
        -1.228034e-17,
         9.804036e-22,
        -4.413030e-26,
         1.057734e-30,
        -1.052755e-35,
    };
    //
    // Voltage range 20.6440uV < tc_v < 54.886uV, 
    // Temperature Range 500 deg C to 1372 deg C
    static double coefficients_TCtypeK_20u644V_lt_V_lt_54u886V[] = {
        -1.318058e2,
         4.830222e-2,
        -1.646031e-6,
         5.464731e-11,
        -9.650715e-16,
         8.802193e-21,
        -3.110810e-26,
    };
    //
    double deltaT = 0;
    double thermocouple_voltage_uV = tc_v * 1e6;
    if (thermocouple_voltage_uV < 0)
    {
        // Voltage range -5891uV < DMMavg < 0uV, Temperature Range -200 deg C to 0 deg C
        deltaT = temperatureDegC_polynomial(thermocouple_voltage_uV, 9, coefficients_TCtypeK_V_lt_0);
    }
    else if (thermocouple_voltage_uV > 20644)
    {
        // Voltage range 206440uV < DMMavg < 54886uV, Temperature Range 500 deg C to 1372 deg C
        deltaT = temperatureDegC_polynomial(thermocouple_voltage_uV, 7, coefficients_TCtypeK_20u644V_lt_V_lt_54u886V);
    }
    else
    {
        // Voltage range 0uV < DMMavg < 20.644uV, Temperature Range 0 deg C to 500 deg C
        deltaT = temperatureDegC_polynomial(thermocouple_voltage_uV, 10, coefficients_TCtypeK_0_lt_V_lt_20u644V);
    }
    return deltaT; //  + rtd_degc; // cold junction
}

//----------------------------------------
// Calculate temperature in degrees C from input voltage,
// using a given set of polynomial coefficients.
// For example:
//
// t = coefficients[0] + coefficients[1] * DMMavg + coefficients[2] * DmMMavg**2
//
// @param[in] thermocouple_voltage_uV = Thermocouple voltage in microvolts
//
// @return ideal temperature in degrees C, calculated from polynomial coefficients
//
double MAX11410::temperatureDegC_polynomial(double thermocouple_voltage_uV, int num_coefficients, double coefficients[])
{
    
    //----------------------------------------
    // Temperature from polynomial coefficients maths
    double temperatureDegC = 0;
    int index;
    for (index = num_coefficients-1; index >= 0; index--)
    {
        temperatureDegC = (temperatureDegC * thermocouple_voltage_uV) + coefficients[index];
    }
    return temperatureDegC;
}


// End of file
