// /*******************************************************************************
// * Copyright (C) 2020 Maxim Integrated Products, Inc., All Rights Reserved.
// *
// * Permission is hereby granted, free of charge, to any person obtaining a
// * copy of this software and associated documentation files (the "Software"),
// * to deal in the Software without restriction, including without limitation
// * the rights to use, copy, modify, merge, publish, distribute, sublicense,
// * and/or sell copies of the Software, and to permit persons to whom the
// * Software is furnished to do so, subject to the following conditions:
// *
// * The above copyright notice and this permission notice shall be included
// * in all copies or substantial portions of the Software.
// *
// * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
// * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// * OTHER DEALINGS IN THE SOFTWARE.
// *
// * Except as contained in this notice, the name of Maxim Integrated
// * Products, Inc. shall not be used except as stated in the Maxim Integrated
// * Products, Inc. Branding Policy.
// *
// * The mere transfer of this software does not imply any licenses
// * of trade secrets, proprietary technology, copyrights, patents,
// * trademarks, maskwork rights, or any other form of intellectual
// * property whatsoever. Maxim Integrated Products, Inc. retains all
// * ownership rights.
// *******************************************************************************
// */
// *********************************************************************
// @file MAX11410.h
// *********************************************************************
// Header file
// DO NOT EDIT; except areas designated "CUSTOMIZE". Automatically generated file.
// generated by XMLSystemOfDevicesToMBED.py
// System Name = ExampleSystem
// System Description = Device driver example
// Device Name = MAX11410
// Device Description = 1.9ksps, Low-Power, Serial SPI 24-Bit, 10-Channel, Differential/Single-Ended Input, SAR ADC
// Device DeviceBriefDescription = 24-bit 1.9ksps Delta-Sigma ADC
// Device Manufacturer = Maxim Integrated
// Device PartNumber = MAX11410ATI+
// Device RegValue_Width = DataWidth16bit_HL
//
// ADC MaxOutputDataRate = 1.9ksps
// ADC NumChannels = 10
// ADC ResolutionBits = 24
//
// SPI CS = ActiveLow
// SPI FrameStart = CS
// SPI CPOL = 0
// SPI CPHA = 0
// SPI MOSI and MISO Data are both stable on Rising edge of SCLK
// SPI SCLK Idle Low
// SPI SCLKMaxMHz = 8
// SPI SCLKMinMHz = 0
//


// Prevent multiple declaration
#ifndef __MAX11410_H__
#define __MAX11410_H__

// standard include for target platform -- Platform_Include_Boilerplate
#include "mbed.h"
// Platforms:
//   - MAX32625MBED
//      - supports mbed-os-5.11, requires USBDevice library
//      - add https://developer.mbed.org/teams/MaximIntegrated/code/USBDevice/
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - MAX32600MBED
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//      - Windows 10 note:  Don't connect HDK until you are ready to load new firmware into the board.
//   - NUCLEO_F446RE
//      - remove USBDevice library
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - NUCLEO_F401RE
//      - remove USBDevice library
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - MAX32630FTHR
//      - #include "max32630fthr.h"
//      - add http://os.mbed.org/teams/MaximIntegrated/code/max32630fthr/
//      - remove MAX32620FTHR library (if present)
//   - MAX32620FTHR
//      - #include "MAX32620FTHR.h"
//      - remove max32630fthr library (if present)
//      - add https://os.mbed.com/teams/MaximIntegrated/code/MAX32620FTHR/
//      - not tested yet
//   - MAX32625PICO
//      - #include "max32625pico.h"
//      - add https://os.mbed.com/users/switches/code/max32625pico/
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//      - not tested yet
//      - see https://os.mbed.com/users/switches/code/max32625pico/
//      - see https://os.mbed.com/users/switches/code/PICO_board_demo/
//      - see https://os.mbed.com/users/switches/code/PICO_USB_I2C_SPI/
//      - see https://os.mbed.com/users/switches/code/SerialInterface/
//      - Note: To load the MAX32625PICO firmware, hold the button while
//        connecting the USB cable, then copy firmware bin file 
//        to the MAINTENANCE drive.
//      - see https://os.mbed.com/platforms/MAX32625PICO/
//      - see https://os.mbed.com/teams/MaximIntegrated/wiki/MAX32625PICO-Firmware-Updates
//
// end Platform_Include_Boilerplate

// CODE GENERATOR: conditional defines
// CODE GENERATOR: class declaration and docstrings
/**
 * @brief MAX11410 1.9ksps, Low-Power, Serial SPI 24-Bit, 10-Channel, Differential/Single-Ended Input, SAR ADC
 *
 *
 *
 * Datasheet: https://www.maximintegrated.com/MAX11410
 *
 *
 *
 * //---------- CODE GENERATOR: helloCppCodeList
 * @code
 * // CODE GENERATOR: example code includes
 *
 * // example code includes
 * // standard include for target platform -- Platform_Include_Boilerplate
 * #include "mbed.h"
 * // Platforms:
 * //   - MAX32625MBED
 * //      - supports mbed-os-5.11, requires USBDevice library
 * //      - add https://developer.mbed.org/teams/MaximIntegrated/code/USBDevice/
 * //      - remove max32630fthr library (if present)
 * //      - remove MAX32620FTHR library (if present)
 * //   - MAX32600MBED
 * //      - remove max32630fthr library (if present)
 * //      - remove MAX32620FTHR library (if present)
 * //      - Windows 10 note:  Don't connect HDK until you are ready to load new firmware into the board.
 * //   - NUCLEO_F446RE
 * //      - remove USBDevice library
 * //      - remove max32630fthr library (if present)
 * //      - remove MAX32620FTHR library (if present)
 * //   - NUCLEO_F401RE
 * //      - remove USBDevice library
 * //      - remove max32630fthr library (if present)
 * //      - remove MAX32620FTHR library (if present)
 * //   - MAX32630FTHR
 * //      - #include "max32630fthr.h"
 * //      - add http://os.mbed.org/teams/MaximIntegrated/code/max32630fthr/
 * //      - remove MAX32620FTHR library (if present)
 * //   - MAX32620FTHR
 * //      - #include "MAX32620FTHR.h"
 * //      - remove max32630fthr library (if present)
 * //      - add https://os.mbed.com/teams/MaximIntegrated/code/MAX32620FTHR/
 * //      - not tested yet
 * //   - MAX32625PICO
 * //      - #include "max32625pico.h"
 * //      - add https://os.mbed.com/users/switches/code/max32625pico/
 * //      - remove max32630fthr library (if present)
 * //      - remove MAX32620FTHR library (if present)
 * //      - not tested yet
 * //      - see https://os.mbed.com/users/switches/code/max32625pico/
 * //      - see https://os.mbed.com/users/switches/code/PICO_board_demo/
 * //      - see https://os.mbed.com/users/switches/code/PICO_USB_I2C_SPI/
 * //      - see https://os.mbed.com/users/switches/code/SerialInterface/
 * //      - Note: To load the MAX32625PICO firmware, hold the button while
 * //        connecting the USB cable, then copy firmware bin file
 * //        to the MAINTENANCE drive.
 * //      - see https://os.mbed.com/platforms/MAX32625PICO/
 * //      - see https://os.mbed.com/teams/MaximIntegrated/wiki/MAX32625PICO-Firmware-Updates
 * //
 * // end Platform_Include_Boilerplate
 * #include "MAX11410.h"
 *
 * // example code board support
 * //MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);
 * //DigitalOut rLED(LED1);
 * //DigitalOut gLED(LED2);
 * //DigitalOut bLED(LED3);
 * //
 * // Arduino "shield" connector port definitions (MAX32625MBED shown)
 * #if defined(TARGET_MAX32625MBED)
 * #define A0 AIN_0
 * #define A1 AIN_1
 * #define A2 AIN_2
 * #define A3 AIN_3
 * #define D0 P0_0
 * #define D1 P0_1
 * #define D2 P0_2
 * #define D3 P0_3
 * #define D4 P0_4
 * #define D5 P0_5
 * #define D6 P0_6
 * #define D7 P0_7
 * #define D8 P1_4
 * #define D9 P1_5
 * #define D10 P1_3
 * #define D11 P1_1
 * #define D12 P1_2
 * #define D13 P1_0
 * #elif defined(TARGET_MAX32625PICO)
 * #warning "TARGET_MAX32625PICO not previously tested; need to define pins..."
 * #define A0 AIN_1
 * #define A1 AIN_2
 * // #define A2 AIN_3
 * // #define A3 AIN_0
 * #define D0 P0_0
 * #define D1 P0_1
 * #define D2 P0_2
 * #define D3 P0_3
 * #define D4 P1_7
 * #define D5 P1_6
 * #define D6 P4_4
 * #define D7 P4_5
 * #define D8 P4_6
 * #define D9 P4_7
 * #define D10 P0_7
 * #define D11 P0_6
 * #define D12 P0_5
 * #define D13 P0_4
 * #endif
 *
 * // example code declare SPI interface (GPIO controlled CS)
 * #if defined(TARGET_MAX32625MBED)
 * SPI spi(SPI1_MOSI, SPI1_MISO, SPI1_SCK); // mosi, miso, sclk spi1 TARGET_MAX32625MBED: P1_1 P1_2 P1_0 Arduino 10-pin header D11 D12 D13
 * DigitalOut spi_cs(SPI1_SS); // TARGET_MAX32625MBED: P1_3 Arduino 10-pin header D10
 * #elif defined(TARGET_MAX32625PICO)
 * #warning "TARGET_MAX32625PICO not previously tested; need to define pins..."
 * SPI spi(SPI0_MOSI, SPI0_MISO, SPI0_SCK); // mosi, miso, sclk spi1 TARGET_MAX32625PICO: pin P0_5 P0_6 P0_4
 * DigitalOut spi_cs(SPI0_SS); // TARGET_MAX32625PICO: pin P0_7
 * #elif defined(TARGET_MAX32600MBED)
 * SPI spi(SPI2_MOSI, SPI2_MISO, SPI2_SCK); // mosi, miso, sclk spi1 TARGET_MAX32600MBED: Arduino 10-pin header D11 D12 D13
 * DigitalOut spi_cs(SPI2_SS); // Generic: Arduino 10-pin header D10
 * #elif defined(TARGET_NUCLEO_F446RE) || defined(TARGET_NUCLEO_F401RE)
 * // TODO1: avoid resource conflict between P5_0, P5_1, P5_2 SPI and DigitalInOut
 * // void spi_init(spi_t *obj, PinName mosi, PinName miso, PinName sclk, PinName ssel)
 * //
 * // TODO1: NUCLEO_F446RE SPI not working; CS and MOSI data looks OK but no SCLK clock pulses.
 * SPI spi(SPI_MOSI, SPI_MISO, SPI_SCK); // mosi, miso, sclk spi1 TARGET_NUCLEO_F446RE: Arduino 10-pin header D11 D12 D13
 * DigitalOut spi_cs(SPI_CS); // TARGET_NUCLEO_F446RE: PB_6 Arduino 10-pin header D10
 * //
 * #else
 * SPI spi(D11, D12, D13); // mosi, miso, sclk spi1 TARGET_MAX32600MBED: Arduino 10-pin header D11 D12 D13
 * DigitalOut spi_cs(D10); // Generic: Arduino 10-pin header D10
 * #endif
 *
 * // example code declare GPIO interface pins
 * // example code declare device instance
 * MAX11410 g_MAX11410_device(spi, spi_cs, MAX11410::MAX11410_IC);
 *
 * // CODE GENERATOR: example code for ADC: serial port declaration
 * //--------------------------------------------------
 * // Declare the Serial driver
 * // default baud rate settings are 9600 8N1
 * // install device driver from http://developer.mbed.org/media/downloads/drivers/mbedWinSerial_16466.exe
 * // see docs https://docs.mbed.com/docs/mbed-os-handbook/en/5.5/getting_started/what_need/
 * #if defined(TARGET_MAX32630)
 *     #include "USBSerial.h"
 * // Hardware serial port over DAPLink
 * // The default baud rate for the DapLink UART is 9600
 * //Serial DAPLINKserial(P2_1, P2_0);     // tx, rx
 * //    #define HAS_DAPLINK_SERIAL 1
 * // Virtual serial port over USB
 * // The baud rate does not affect the virtual USBSerial UART.
 * USBSerial serial;
 * //--------------------------------------------------
 * #elif defined(TARGET_MAX32625MBED)
 *     #include "USBSerial.h"
 * // Hardware serial port over DAPLink
 * // The default baud rate for the DapLink UART is 9600
 * //Serial DAPLINKserial(P2_1, P2_0);     // tx, rx
 * //    #define HAS_DAPLINK_SERIAL 1
 * // Virtual serial port over USB
 * // The baud rate does not affect the virtual USBSerial UART.
 * USBSerial serial;
 * //--------------------------------------------------
 * #elif defined(TARGET_MAX32600)
 *     #include "USBSerial.h"
 * // Hardware serial port over DAPLink
 * // The default baud rate for the DapLink UART is 9600
 * Serial DAPLINKserial(P1_1, P1_0);     // tx, rx
 *     #define HAS_DAPLINK_SERIAL 1
 * // Virtual serial port over USB
 * // The baud rate does not affect the virtual USBSerial UART.
 * USBSerial serial;
 * //--------------------------------------------------
 * #elif defined(TARGET_NUCLEO_F446RE) || defined(TARGET_NUCLEO_F401RE)
 * Serial serial(SERIAL_TX, SERIAL_RX);     // tx, rx
 * //--------------------------------------------------
 * #else
 * #if defined(SERIAL_TX)
 * #warning "target not previously tested; guess serial pins are SERIAL_TX, SERIAL_RX..."
 * Serial serial(SERIAL_TX, SERIAL_RX);     // tx, rx
 * #elif defined(USBTX)
 * #warning "target not previously tested; guess serial pins are USBTX, USBRX..."
 * Serial serial(USBTX, USBRX);     // tx, rx
 * #elif defined(UART_TX)
 * #warning "target not previously tested; guess serial pins are UART_TX, UART_RX..."
 * Serial serial(UART_TX, UART_RX);     // tx, rx
 * #else
 * #warning "target not previously tested; need to define serial pins..."
 * #endif
 * #endif
 * //
 * #include "CmdLine.h"
 * CmdLine cmdLine(serial, "serial");
 *
 * // example code main function
 * int main()
 * {
 *     // setup: put your setup code here, to run once
 *
 *     // example code: serial port banner message
 *     wait(3); // 3000ms timing delay function, platform-specific
 *     cmdLine.serial().printf("\r\nHello_MAX11410\r\n");
 *
 *     // CODE GENERATOR: example code: member function Init
 *     // Initialize MAX11410 and verify device ID
 *     uint32_t g_SPI_SCLK_Hz = 24000000; // platform limit 24MHz intSPI_SCLK_Platform_Max_MHz * 1000000
 *     if (g_MAX11410_device.Init() == 0)
 *     {  // init failed; try "safe mode" SPI at slower SCLK rate
 *         cmdLine.serial().printf("\r\nMAX11410 Init failed; retry at SPI SCLK frequency 2000000 Hz\r\n");
 *
 *         g_SPI_SCLK_Hz = 2000000;
 *         g_MAX11410_device.spi_frequency(2000000);
 *         g_MAX11410_device.Init();
 *     }
 *     // CODE GENERATOR: get spi properties from device
 *     if (g_SPI_SCLK_Hz > g_MAX11410_device.get_spi_frequency())
 *     {  // Device limits SPI SCLK frequency
 *         g_SPI_SCLK_Hz = g_MAX11410_device.get_spi_frequency();
 *         cmdLine.serial().printf("\r\nMAX11410 limits SPI SCLK frequency to %ld Hz\r\n", g_SPI_SCLK_Hz);
 *
 *         g_MAX11410_device.Init();
 *     }
 *     if (g_MAX11410_device.get_spi_frequency() > g_SPI_SCLK_Hz)
 *     {  // Platform limits SPI SCLK frequency
 *         g_MAX11410_device.spi_frequency(g_SPI_SCLK_Hz);
 *         cmdLine.serial().printf("\r\nPlatform limits MAX11410 SPI SCLK frequency to %ld Hz\r\n", g_SPI_SCLK_Hz);
 *
 *         g_MAX11410_device.Init();
 *     }
 *     // g_SPI_dataMode = g_MAX11410_device.get_spi_dataMode();
 *     while (g_MAX11410_device.Init() == 0)
 *     {
 *         wait(3); // 3000ms timing delay function, platform-specific
 *         cmdLine.serial().printf("\r\nMAX11410 Init failed; retry...\r\n");
 *
 *     }
 *
 *     while (1)
 *     {
 *         // loop: put your main code here, to run repeatedly
 *
 *         // CODE GENERATOR: example code: has no member function REF
 *         // CODE GENERATOR: example code for ADC: repeat-forever convert and print conversion result, one record per line
 *         // CODE GENERATOR: ResolutionBits = 24
 *         // CODE GENERATOR: FScode = 0xffffff
 *         // CODE GENERATOR: NumChannels = 10
 *         // CODE GENERATOR: banner before helloCppCodeList while(1)
 *         cmdLine.serial().printf("v_filter = 0x%2.2x\r\n", g_MAX11410_device.v_filter);
 *
 *         cmdLine.serial().printf("v_pga = 0x%2.2x\r\n", g_MAX11410_device.v_pga);
 *
 *         cmdLine.serial().printf("v_ctrl = 0x%2.2x\r\n", g_MAX11410_device.v_ctrl);
 *
 *         // banner for csv data columns
 *         cmdLine.serial().printf("\"AIN0_LSB\",\"AIN1_LSB\",\"AIN2_LSB\",\"AIN3_LSB\",\"AIN4_LSB\",\"AIN5_LSB\",\"AIN6_LSB\",\"AIN7_LSB\",\"AIN8_LSB\",\"AIN9_LSB\"");
 *
 *         cmdLine.serial().printf("\r\n");
 *
 *         while(1) { // this code repeats forever
 *             // this code repeats forever
 *             // CODE GENERATOR: example code: has no member function ScanStandardExternalClock
 *             // CODE GENERATOR: example code: has no member function ReadAINcode
 *             // CODE GENERATOR: example code: member function Read_All_Voltages
 *             // Measure ADC channels in sequence from AIN0 to channelNumber_0_9.
 *             // @param[in] g_MAX11410_device.channelNumber_0_15: AIN Channel Number
 *             // @param[in] g_MAX11410_device.PowerManagement_0_2: 0=Normal, 1=AutoShutdown, 2=AutoStandby
 *             // @param[in] g_MAX11410_device.chan_id_0_1: ADC_MODE_CONTROL.CHAN_ID
 *             int channelId_0_9 = 9;
 *             //g_MAX11410_device.channelNumber_0_15 = channelId_0_9;
 *             //g_MAX11410_device.PowerManagement_0_2 = 0;
 *             //g_MAX11410_device.chan_id_0_1 = 1;
 *             g_MAX11410_device.Read_All_Voltages();
 *
 *             // wait(3.0);
 *             // CODE GENERATOR: print conversion result
 *             // Use Arduino Serial Plotter to view output: Tools | Serial Plotter
 *             cmdLine.serial().printf("%d", g_MAX11410_device.AINcode[0]);
 *             for (int index = 1; index <= channelId_0_9; index++) {
 *                 cmdLine.serial().printf(",%d", g_MAX11410_device.AINcode[index]);
 *             }
 *             cmdLine.serial().printf("\r\n");
 *
 *         } // this code repeats forever
 *     }
 * }
 * @endcode
 * //---------- CODE GENERATOR: end helloCppCodeList
 */
class MAX11410 {
public:
// CODE GENERATOR: TypedefEnum EnumItem declarations
// CODE GENERATOR: TypedefEnum MAX11410_CMDOP_enum_t
    //----------------------------------------
    /// Command Operation Format (see function DecodeCommand)
    ///
    /// Naming convention is CMDOP_bitstream_OPERATION_NAME
    /// - rxxx_xxxx = read/write bit (1=read, 0=write)
    /// - xaaa_aaaa = 7-bit register address field -- see MAX11410_CMD_enum_t
    /// - xxxx = don't care
    typedef enum MAX11410_CMDOP_enum_t {
        CMDOP_0aaa_aaaa_WriteRegister = 0x00, //!< 0b00000000
        CMDOP_1aaa_aaaa_ReadRegister = 0x80, //!< 0b10000000
    } MAX11410_CMDOP_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_CMD_enum_t
    //----------------------------------------
    /// Register Addresses
    ///
    /// Naming convention is CMD_bitstream_FUNCTION_NAME
    /// - r = read/write bit (1=read, 0=write)
    /// - xaaa_aaaa = 7-bit register address field
    /// - dddd_dddd = 8-bit register data field
    /// - dddd_dddd_dddd_dddd = 16-bit register data field
    /// - dddd_dddd_dddd_dddd_dddd_dddd = 24-bit register data field
    /// - xxxx = don't care
    typedef enum MAX11410_CMD_enum_t {
        CMD_r000_0000_xxxx_xxdd_PD = 0x00, //!< 0b0000000
        CMD_r000_0001_xddd_xxdd_CONV_START = 0x01, //!< 0b0000001
        CMD_r000_0010_xddd_dddd_SEQ_START = 0x02, //!< 0b0000010
        CMD_r000_0011_xxxx_xddd_CAL_START = 0x03, //!< 0b0000011
        CMD_r000_0100_dddd_xddd_GP0_CTRL = 0x04, //!< 0b0000100
        CMD_r000_0101_dddd_xddd_GP1_CTRL = 0x05, //!< 0b0000101
        CMD_r000_0110_xddd_xxdd_GP_CONV = 0x06, //!< 0b0000110
        CMD_r000_0111_xddd_dddd_GP_SEQ_ADDR = 0x07, //!< 0b0000111
        CMD_r000_1000_x0dd_dddd_FILTER = 0x08, //!< 0b0001000
        CMD_r000_1001_dddd_dddd_CTRL = 0x09, //!< 0b0001001
        CMD_r000_1010_dddd_dddd_SOURCE = 0x0a, //!< 0b0001010
        CMD_r000_1011_dddd_dddd_MUX_CTRL0 = 0x0b, //!< 0b0001011
        CMD_r000_1100_dddd_dddd_MUX_CTRL1 = 0x0c, //!< 0b0001100
        CMD_r000_1101_dddd_dddd_MUX_CTRL2 = 0x0d, //!< 0b0001101
        CMD_r000_1110_00ss_0ggg_PGA = 0x0e, //!< 0b0001110
        CMD_r000_1111_dddd_dddd_WAIT_EXT = 0x0f, //!< 0b0001111
        CMD_r001_0000_xxxx_xxxx_WAIT_START = 0x10, //!< 0b0010000
        CMD_r001_0001_xxxx_xxxx_xxxx_xxxx_xxxx_xddd_PART_ID = 0x11, //!< 0b0010001
        CMD_r001_0010_xxxx_xxxx_dddd_xxdd_dddd_dddd_SYSC_SEL = 0x12, //!< 0b0010010
        CMD_r001_0011_dddd_dddd_dddd_dddd_dddd_dddd_SYS_OFF_A = 0x13, //!< 0b0010011
        CMD_r001_0100_dddd_dddd_dddd_dddd_dddd_dddd_SYS_OFF_B = 0x14, //!< 0b0010100
        CMD_r001_0101_dddd_dddd_dddd_dddd_dddd_dddd_SYS_GAIN_A = 0x15, //!< 0b0010101
        CMD_r001_0110_dddd_dddd_dddd_dddd_dddd_dddd_SYS_GAIN_B = 0x16, //!< 0b0010110
        CMD_r001_0111_dddd_dddd_dddd_dddd_dddd_dddd_SELF_OFF = 0x17, //!< 0b0010111
        CMD_r001_1000_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_1 = 0x18, //!< 0b0011000
        CMD_r001_1001_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_2 = 0x19, //!< 0b0011001
        CMD_r001_1010_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_4 = 0x1a, //!< 0b0011010
        CMD_r001_1011_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_8 = 0x1b, //!< 0b0011011
        CMD_r001_1100_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_16 = 0x1c, //!< 0b0011100
        CMD_r001_1101_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_32 = 0x1d, //!< 0b0011101
        CMD_r001_1110_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_64 = 0x1e, //!< 0b0011110
        CMD_r001_1111_dddd_dddd_dddd_dddd_dddd_dddd_SELF_GAIN_128 = 0x1f, //!< 0b0011111
        CMD_r010_0000_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH0 = 0x20, //!< 0b0100000
        CMD_r010_0001_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH1 = 0x21, //!< 0b0100001
        CMD_r010_0010_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH2 = 0x22, //!< 0b0100010
        CMD_r010_0011_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH3 = 0x23, //!< 0b0100011
        CMD_r010_0100_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH4 = 0x24, //!< 0b0100100
        CMD_r010_0101_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH5 = 0x25, //!< 0b0100101
        CMD_r010_0110_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH6 = 0x26, //!< 0b0100110
        CMD_r010_0111_dddd_dddd_dddd_dddd_dddd_dddd_LTHRESH7 = 0x27, //!< 0b0100111
        CMD_r010_1000_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH0 = 0x28, //!< 0b0101000
        CMD_r010_1001_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH1 = 0x29, //!< 0b0101001
        CMD_r010_1010_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH2 = 0x2a, //!< 0b0101010
        CMD_r010_1011_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH3 = 0x2b, //!< 0b0101011
        CMD_r010_1100_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH4 = 0x2c, //!< 0b0101100
        CMD_r010_1101_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH5 = 0x2d, //!< 0b0101101
        CMD_r010_1110_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH6 = 0x2e, //!< 0b0101110
        CMD_r010_1111_dddd_dddd_dddd_dddd_dddd_dddd_UTHRESH7 = 0x2f, //!< 0b0101111
        CMD_r011_0000_dddd_dddd_dddd_dddd_dddd_dddd_DATA0 = 0x30, //!< 0b0110000
        CMD_r011_0001_dddd_dddd_dddd_dddd_dddd_dddd_DATA1 = 0x31, //!< 0b0110001
        CMD_r011_0010_dddd_dddd_dddd_dddd_dddd_dddd_DATA2 = 0x32, //!< 0b0110010
        CMD_r011_0011_dddd_dddd_dddd_dddd_dddd_dddd_DATA3 = 0x33, //!< 0b0110011
        CMD_r011_0100_dddd_dddd_dddd_dddd_dddd_dddd_DATA4 = 0x34, //!< 0b0110100
        CMD_r011_0101_dddd_dddd_dddd_dddd_dddd_dddd_DATA5 = 0x35, //!< 0b0110101
        CMD_r011_0110_dddd_dddd_dddd_dddd_dddd_dddd_DATA6 = 0x36, //!< 0b0110110
        CMD_r011_0111_dddd_dddd_dddd_dddd_dddd_dddd_DATA7 = 0x37, //!< 0b0110111
        CMD_r011_1000_dddd_dddd_dddd_dddd_dxxx_dddd_STATUS = 0x38, //!< 0b0111000
        CMD_r011_1001_dddd_dddd_dddd_dddd_dxxd_dddd_STATUS_IE = 0x39, //!< 0b0111001
        CMD_r011_1010_xaaa_aaaa_dddd_dddd_UC_0 = 0x3a, //!< 0b0111010
        CMD_r011_1011_xaaa_aaaa_dddd_dddd_UC_1 = 0x3b, //!< 0b0111011
        CMD_r011_1100_xaaa_aaaa_dddd_dddd_UC_2 = 0x3c, //!< 0b0111100
        CMD_r011_1101_xaaa_aaaa_dddd_dddd_UC_3 = 0x3d, //!< 0b0111101
        CMD_r011_1110_xaaa_aaaa_dddd_dddd_UC_4 = 0x3e, //!< 0b0111110
        CMD_r011_1111_xaaa_aaaa_dddd_dddd_UC_5 = 0x3f, //!< 0b0111111
        CMD_r100_0000_xaaa_aaaa_dddd_dddd_UC_6 = 0x40, //!< 0b1000000
        CMD_r100_0001_xaaa_aaaa_dddd_dddd_UC_7 = 0x41, //!< 0b1000001
        CMD_r100_0010_xaaa_aaaa_dddd_dddd_UC_8 = 0x42, //!< 0b1000010
        CMD_r100_0011_xaaa_aaaa_dddd_dddd_UC_9 = 0x43, //!< 0b1000011
        CMD_r100_0100_xaaa_aaaa_dddd_dddd_UC_10 = 0x44, //!< 0b1000100
        CMD_r100_0101_xaaa_aaaa_dddd_dddd_UC_11 = 0x45, //!< 0b1000101
        CMD_r100_0110_xaaa_aaaa_dddd_dddd_UC_12 = 0x46, //!< 0b1000110
        CMD_r100_0111_xaaa_aaaa_dddd_dddd_UC_13 = 0x47, //!< 0b1000111
        CMD_r100_1000_xaaa_aaaa_dddd_dddd_UC_14 = 0x48, //!< 0b1001000
        CMD_r100_1001_xaaa_aaaa_dddd_dddd_UC_15 = 0x49, //!< 0b1001001
        CMD_r100_1010_xaaa_aaaa_dddd_dddd_UC_16 = 0x4a, //!< 0b1001010
        CMD_r100_1011_xaaa_aaaa_dddd_dddd_UC_17 = 0x4b, //!< 0b1001011
        CMD_r100_1100_xaaa_aaaa_dddd_dddd_UC_18 = 0x4c, //!< 0b1001100
        CMD_r100_1101_xaaa_aaaa_dddd_dddd_UC_19 = 0x4d, //!< 0b1001101
        CMD_r100_1110_xaaa_aaaa_dddd_dddd_UC_20 = 0x4e, //!< 0b1001110
        CMD_r100_1111_xaaa_aaaa_dddd_dddd_UC_21 = 0x4f, //!< 0b1001111
        CMD_r101_0000_xaaa_aaaa_dddd_dddd_UC_22 = 0x50, //!< 0b1010000
        CMD_r101_0001_xaaa_aaaa_dddd_dddd_UC_23 = 0x51, //!< 0b1010001
        CMD_r101_0010_xaaa_aaaa_dddd_dddd_UC_24 = 0x52, //!< 0b1010010
        CMD_r101_0011_xaaa_aaaa_dddd_dddd_UC_25 = 0x53, //!< 0b1010011
        CMD_r101_0100_xaaa_aaaa_dddd_dddd_UC_26 = 0x54, //!< 0b1010100
        CMD_r101_0101_xaaa_aaaa_dddd_dddd_UC_27 = 0x55, //!< 0b1010101
        CMD_r101_0110_xaaa_aaaa_dddd_dddd_UC_28 = 0x56, //!< 0b1010110
        CMD_r101_0111_xaaa_aaaa_dddd_dddd_UC_29 = 0x57, //!< 0b1010111
        CMD_r101_1000_xaaa_aaaa_dddd_dddd_UC_30 = 0x58, //!< 0b1011000
        CMD_r101_1001_xaaa_aaaa_dddd_dddd_UC_31 = 0x59, //!< 0b1011001
        CMD_r101_1010_xaaa_aaaa_dddd_dddd_UC_32 = 0x5a, //!< 0b1011010
        CMD_r101_1011_xaaa_aaaa_dddd_dddd_UC_33 = 0x5b, //!< 0b1011011
        CMD_r101_1100_xaaa_aaaa_dddd_dddd_UC_34 = 0x5c, //!< 0b1011100
        CMD_r101_1101_xaaa_aaaa_dddd_dddd_UC_35 = 0x5d, //!< 0b1011101
        CMD_r101_1110_xaaa_aaaa_dddd_dddd_UC_36 = 0x5e, //!< 0b1011110
        CMD_r101_1111_xaaa_aaaa_dddd_dddd_UC_37 = 0x5f, //!< 0b1011111
        CMD_r110_0000_xaaa_aaaa_dddd_dddd_UC_38 = 0x60, //!< 0b1100000
        CMD_r110_0001_xaaa_aaaa_dddd_dddd_UC_39 = 0x61, //!< 0b1100001
        CMD_r110_0010_xaaa_aaaa_dddd_dddd_UC_40 = 0x62, //!< 0b1100010
        CMD_r110_0011_xaaa_aaaa_dddd_dddd_UC_41 = 0x63, //!< 0b1100011
        CMD_r110_0100_xaaa_aaaa_dddd_dddd_UC_42 = 0x64, //!< 0b1100100
        CMD_r110_0101_xaaa_aaaa_dddd_dddd_UC_43 = 0x65, //!< 0b1100101
        CMD_r110_0110_xaaa_aaaa_dddd_dddd_UC_44 = 0x66, //!< 0b1100110
        CMD_r110_0111_xaaa_aaaa_dddd_dddd_UC_45 = 0x67, //!< 0b1100111
        CMD_r110_1000_xaaa_aaaa_dddd_dddd_UC_46 = 0x68, //!< 0b1101000
        CMD_r110_1001_xaaa_aaaa_dddd_dddd_UC_47 = 0x69, //!< 0b1101001
        CMD_r110_1010_xaaa_aaaa_dddd_dddd_UC_48 = 0x6a, //!< 0b1101010
        CMD_r110_1011_xaaa_aaaa_dddd_dddd_UC_49 = 0x6b, //!< 0b1101011
        CMD_r110_1100_xaaa_aaaa_dddd_dddd_UC_50 = 0x6c, //!< 0b1101100
        CMD_r110_1101_xaaa_aaaa_dddd_dddd_UC_51 = 0x6d, //!< 0b1101101
        CMD_r110_1110_xaaa_aaaa_dddd_dddd_UC_52 = 0x6e, //!< 0b1101110
        CMD_r110_1111_xxxx_xxxx_xaaa_aaaa_UCADDR = 0x6f, //!< 0b1101111
    } MAX11410_CMD_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_SEQ_ADDR_enum_t
    //----------------------------------------
    /// Microcode Sequencer Addresses.
    /// CMD_r000_0010_xddd_dddd_SEQ_START
    /// CMD_r000_0111_xddd_dddd_GP_SEQ_ADDR
    ///
    /// Naming convention is CMD_bitstream_FUNCTION_NAME
    /// - xaaa_aaaa = 7-bit register address field
    /// - dddd_dddd = 8-bit register data field
    /// - xxxx = don't care
    typedef enum MAX11410_SEQ_ADDR_enum_t {
        SEQ_ADDR_r011_1010_xaaa_aaaa_dddd_dddd_UC_0 = 0x3a, //!< 0b0111010
        SEQ_ADDR_r011_1011_xaaa_aaaa_dddd_dddd_UC_1 = 0x3b, //!< 0b0111011
        SEQ_ADDR_r011_1100_xaaa_aaaa_dddd_dddd_UC_2 = 0x3c, //!< 0b0111100
        SEQ_ADDR_r011_1101_xaaa_aaaa_dddd_dddd_UC_3 = 0x3d, //!< 0b0111101
        SEQ_ADDR_r011_1110_xaaa_aaaa_dddd_dddd_UC_4 = 0x3e, //!< 0b0111110
        SEQ_ADDR_r011_1111_xaaa_aaaa_dddd_dddd_UC_5 = 0x3f, //!< 0b0111111
        SEQ_ADDR_r100_0000_xaaa_aaaa_dddd_dddd_UC_6 = 0x40, //!< 0b1000000
        SEQ_ADDR_r100_0001_xaaa_aaaa_dddd_dddd_UC_7 = 0x41, //!< 0b1000001
        SEQ_ADDR_r100_0010_xaaa_aaaa_dddd_dddd_UC_8 = 0x42, //!< 0b1000010
        SEQ_ADDR_r100_0011_xaaa_aaaa_dddd_dddd_UC_9 = 0x43, //!< 0b1000011
        SEQ_ADDR_r100_0100_xaaa_aaaa_dddd_dddd_UC_10 = 0x44, //!< 0b1000100
        SEQ_ADDR_r100_0101_xaaa_aaaa_dddd_dddd_UC_11 = 0x45, //!< 0b1000101
        SEQ_ADDR_r100_0110_xaaa_aaaa_dddd_dddd_UC_12 = 0x46, //!< 0b1000110
        SEQ_ADDR_r100_0111_xaaa_aaaa_dddd_dddd_UC_13 = 0x47, //!< 0b1000111
        SEQ_ADDR_r100_1000_xaaa_aaaa_dddd_dddd_UC_14 = 0x48, //!< 0b1001000
        SEQ_ADDR_r100_1001_xaaa_aaaa_dddd_dddd_UC_15 = 0x49, //!< 0b1001001
        SEQ_ADDR_r100_1010_xaaa_aaaa_dddd_dddd_UC_16 = 0x4a, //!< 0b1001010
        SEQ_ADDR_r100_1011_xaaa_aaaa_dddd_dddd_UC_17 = 0x4b, //!< 0b1001011
        SEQ_ADDR_r100_1100_xaaa_aaaa_dddd_dddd_UC_18 = 0x4c, //!< 0b1001100
        SEQ_ADDR_r100_1101_xaaa_aaaa_dddd_dddd_UC_19 = 0x4d, //!< 0b1001101
        SEQ_ADDR_r100_1110_xaaa_aaaa_dddd_dddd_UC_20 = 0x4e, //!< 0b1001110
        SEQ_ADDR_r100_1111_xaaa_aaaa_dddd_dddd_UC_21 = 0x4f, //!< 0b1001111
        SEQ_ADDR_r101_0000_xaaa_aaaa_dddd_dddd_UC_22 = 0x50, //!< 0b1010000
        SEQ_ADDR_r101_0001_xaaa_aaaa_dddd_dddd_UC_23 = 0x51, //!< 0b1010001
        SEQ_ADDR_r101_0010_xaaa_aaaa_dddd_dddd_UC_24 = 0x52, //!< 0b1010010
        SEQ_ADDR_r101_0011_xaaa_aaaa_dddd_dddd_UC_25 = 0x53, //!< 0b1010011
        SEQ_ADDR_r101_0100_xaaa_aaaa_dddd_dddd_UC_26 = 0x54, //!< 0b1010100
        SEQ_ADDR_r101_0101_xaaa_aaaa_dddd_dddd_UC_27 = 0x55, //!< 0b1010101
        SEQ_ADDR_r101_0110_xaaa_aaaa_dddd_dddd_UC_28 = 0x56, //!< 0b1010110
        SEQ_ADDR_r101_0111_xaaa_aaaa_dddd_dddd_UC_29 = 0x57, //!< 0b1010111
        SEQ_ADDR_r101_1000_xaaa_aaaa_dddd_dddd_UC_30 = 0x58, //!< 0b1011000
        SEQ_ADDR_r101_1001_xaaa_aaaa_dddd_dddd_UC_31 = 0x59, //!< 0b1011001
        SEQ_ADDR_r101_1010_xaaa_aaaa_dddd_dddd_UC_32 = 0x5a, //!< 0b1011010
        SEQ_ADDR_r101_1011_xaaa_aaaa_dddd_dddd_UC_33 = 0x5b, //!< 0b1011011
        SEQ_ADDR_r101_1100_xaaa_aaaa_dddd_dddd_UC_34 = 0x5c, //!< 0b1011100
        SEQ_ADDR_r101_1101_xaaa_aaaa_dddd_dddd_UC_35 = 0x5d, //!< 0b1011101
        SEQ_ADDR_r101_1110_xaaa_aaaa_dddd_dddd_UC_36 = 0x5e, //!< 0b1011110
        SEQ_ADDR_r101_1111_xaaa_aaaa_dddd_dddd_UC_37 = 0x5f, //!< 0b1011111
        SEQ_ADDR_r110_0000_xaaa_aaaa_dddd_dddd_UC_38 = 0x60, //!< 0b1100000
        SEQ_ADDR_r110_0001_xaaa_aaaa_dddd_dddd_UC_39 = 0x61, //!< 0b1100001
        SEQ_ADDR_r110_0010_xaaa_aaaa_dddd_dddd_UC_40 = 0x62, //!< 0b1100010
        SEQ_ADDR_r110_0011_xaaa_aaaa_dddd_dddd_UC_41 = 0x63, //!< 0b1100011
        SEQ_ADDR_r110_0100_xaaa_aaaa_dddd_dddd_UC_42 = 0x64, //!< 0b1100100
        SEQ_ADDR_r110_0101_xaaa_aaaa_dddd_dddd_UC_43 = 0x65, //!< 0b1100101
        SEQ_ADDR_r110_0110_xaaa_aaaa_dddd_dddd_UC_44 = 0x66, //!< 0b1100110
        SEQ_ADDR_r110_0111_xaaa_aaaa_dddd_dddd_UC_45 = 0x67, //!< 0b1100111
        SEQ_ADDR_r110_1000_xaaa_aaaa_dddd_dddd_UC_46 = 0x68, //!< 0b1101000
        SEQ_ADDR_r110_1001_xaaa_aaaa_dddd_dddd_UC_47 = 0x69, //!< 0b1101001
        SEQ_ADDR_r110_1010_xaaa_aaaa_dddd_dddd_UC_48 = 0x6a, //!< 0b1101010
        SEQ_ADDR_r110_1011_xaaa_aaaa_dddd_dddd_UC_49 = 0x6b, //!< 0b1101011
        SEQ_ADDR_r110_1100_xaaa_aaaa_dddd_dddd_UC_50 = 0x6c, //!< 0b1101100
        SEQ_ADDR_r110_1101_xaaa_aaaa_dddd_dddd_UC_51 = 0x6d, //!< 0b1101101
        SEQ_ADDR_r110_1110_xaaa_aaaa_dddd_dddd_UC_52 = 0x6e, //!< 0b1101110
    } MAX11410_SEQ_ADDR_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_STATUS_enum_t
    //----------------------------------------
    /// Status indicator bits
    /// CMD_r011_1000_dddd_dddd_dddd_dddd_dxxx_dddd_STATUS fields
    ///
    typedef enum MAX11410_STATUS_enum_t {
        STATUS_000001_CONV_RDY = 0x00000001, //!< 0b00000000000000000000000000000001
        STATUS_000002_SEQ_RDY = 0x00000002, //!< 0b00000000000000000000000000000010
        STATUS_000004_CAL_RDY = 0x00000004, //!< 0b00000000000000000000000000000100
        STATUS_000008_WAIT_DONE = 0x00000008, //!< 0b00000000000000000000000000001000
        STATUS_000010_DATA_RDY = 0x00000010, //!< 0b00000000000000000000000000010000
        STATUS_000020_reserved = 0x00000020, //!< 0b00000000000000000000000000100000
        STATUS_000040_reserved = 0x00000040, //!< 0b00000000000000000000000001000000
        STATUS_000080_SYSGOR = 0x00000080, //!< 0b00000000000000000000000010000000
        STATUS_000100_TUR_0 = 0x00000100, //!< 0b00000000000000000000000100000000
        STATUS_000200_TUR_1 = 0x00000200, //!< 0b00000000000000000000001000000000
        STATUS_000400_TUR_2 = 0x00000400, //!< 0b00000000000000000000010000000000
        STATUS_000800_TUR_3 = 0x00000800, //!< 0b00000000000000000000100000000000
        STATUS_001000_TUR_4 = 0x00001000, //!< 0b00000000000000000001000000000000
        STATUS_002000_TUR_5 = 0x00002000, //!< 0b00000000000000000010000000000000
        STATUS_004000_TUR_6 = 0x00004000, //!< 0b00000000000000000100000000000000
        STATUS_008000_TUR_7 = 0x00008000, //!< 0b00000000000000001000000000000000
        STATUS_010000_TOR_0 = 0x00010000, //!< 0b00000000000000010000000000000000
        STATUS_020000_TOR_1 = 0x00020000, //!< 0b00000000000000100000000000000000
        STATUS_040000_TOR_2 = 0x00040000, //!< 0b00000000000001000000000000000000
        STATUS_080000_TOR_3 = 0x00080000, //!< 0b00000000000010000000000000000000
        STATUS_100000_TOR_4 = 0x00100000, //!< 0b00000000000100000000000000000000
        STATUS_200000_TOR_5 = 0x00200000, //!< 0b00000000001000000000000000000000
        STATUS_400000_TOR_6 = 0x00400000, //!< 0b00000000010000000000000000000000
        STATUS_800000_TOR_7 = 0x00800000, //!< 0b00000000100000000000000000000000
    } MAX11410_STATUS_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_PD_enum_t
    //----------------------------------------
    /// Power-down state command
    /// CMD_r000_0000_xxxx_xxdd_PD PD[1:0] field
    ///
    /// - 00: Normal mode
    /// - 01: Standby mode -- Powers down all analog circuity, but not the internal voltage regulator
    /// - 10: Sleep mode -- Powers down all analog circuitry including the internal voltage regulator
    /// - 11: Reset -- all registers reset to POR state (Self Clearing to 01 Standby mode)
    typedef enum MAX11410_PD_enum_t {
        PD_00_Normal = 0x00, //!< 0b00
        PD_01_Standby = 0x01, //!< 0b01
        PD_10_Sleep = 0x02, //!< 0b10
        PD_11_Reset = 0x03, //!< 0b11
    } MAX11410_PD_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_DEST_enum_t
    //----------------------------------------
    /// Conversion / seqeuncer start command
    /// CMD_r000_0001_xddd_xxdd_CONV_START DEST[2:0] field.
    /// CMD_r000_0110_xddd_xxdd_GP_CONV GP_DEST[2:0] field.
    ///
    /// - 000: Store result in DATA0
    /// - 001: Store result in DATA1
    /// - 010: Store result in DATA2
    /// - 011: Store result in DATA3
    /// - 100: Store result in DATA4
    /// - 101: Store result in DATA5
    /// - 110: Store result in DATA6
    /// - 111: Store result in DATA7
    typedef enum MAX11410_DEST_enum_t {
        DEST_000_DATA0 = 0x00, //!< 0b000
        DEST_001_DATA1 = 0x01, //!< 0b001
        DEST_010_DATA2 = 0x02, //!< 0b010
        DEST_011_DATA3 = 0x03, //!< 0b011
        DEST_100_DATA4 = 0x04, //!< 0b100
        DEST_101_DATA5 = 0x05, //!< 0b101
        DEST_110_DATA6 = 0x06, //!< 0b110
        DEST_111_DATA7 = 0x07, //!< 0b111
    } MAX11410_DEST_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_CONV_TYPE_enum_t
    //----------------------------------------
    /// Conversion / seqeuncer start command
    /// CMD_r000_0001_xddd_xxdd_CONV_START CONV_TYPE[1:0] field.
    /// CMD_r000_0110_xddd_xxdd_GP_CONV GP_CONV_TYPE[2:0] field.
    ///
    /// - 00: Single conversion
    /// - 01: Continuous conversions
    /// - 10, 11: 1:4 Duty cycled conversions (modulator low-power mode)
    typedef enum MAX11410_CONV_TYPE_enum_t {
        CONV_TYPE_00_Single = 0x00, //!< 0b00
        CONV_TYPE_01_Continuous = 0x01, //!< 0b01
        CONV_TYPE_10_DutyCycle_1_4 = 0x02, //!< 0b10
        CONV_TYPE_11_DutyCycle_1_4 = 0x03, //!< 0b11
    } MAX11410_CONV_TYPE_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_CAL_TYPE_enum_t
    //----------------------------------------
    /// Calbration command
    /// CMD_r000_0011_xxxx_xddd_CAL_START CAL_TYPE[2:0] field
    ///
    /// - 000: Performs a self-calibration. Resulting offset calibration value is stored in the SELF_OFF register, and the 1x gain calibration value is stored in the SELF_GAIN_1 register.
    /// - 001: Performs a PGA gain calibration at the currently programmed PGA gain. A 'No Op' will result if PGA Gain calibration is executed with the PGA disabled via the SIG_PATH register, or with the GAIN register set to 1x.The resulting gain calibration value is stored in the SELF_GAIN_[2-128] register corresponding to the currently programmed PGA GAIN setting.
    /// - 010: Reserved
    /// - 011: Reserved
    /// - 100: Performs a system offset calibration. The resulting calibration value is stored in the SYS_OFF_A register.
    /// - 101: Performs a system gain calibration. The resulting calibration value is stored in the SYS_GAIN_A register.
    /// - 110: Performs a system offset calibration. The resulting calibration value is stored in the SYS_OFF_B register.
    /// - 111: Performs a system gain calibration. The resulting calibration value is stored in the SYS_GAIN_B register.
    typedef enum MAX11410_CAL_TYPE_enum_t {
        CAL_TYPE_000_SELF_CAL = 0x00, //!< 0b000
        CAL_TYPE_001_PGA_GAIN = 0x01, //!< 0b001
        CAL_TYPE_010_reserved = 0x02, //!< 0b010
        CAL_TYPE_011_reserved = 0x03, //!< 0b011
        CAL_TYPE_100_SYS_OFF_A = 0x04, //!< 0b100
        CAL_TYPE_101_SYS_GAIN_A = 0x05, //!< 0b101
        CAL_TYPE_110_SYS_OFF_B = 0x06, //!< 0b110
        CAL_TYPE_111_SYS_GAIN_B = 0x07, //!< 0b111
    } MAX11410_CAL_TYPE_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_GP0_DIR_enum_t
    //----------------------------------------
    /// GPIO0 pin command
    /// CMD_r000_0100_dddd_xddd_GP0_CTRL GP0_DIR[1:0] field (bits 7:6)
    ///
    /// - 00: Input mode, reference to VDDIO (default)
    /// - 01: Reserved
    /// - 10: Output mode, open-drain output
    /// - 11: Output mode, CMOS output
    typedef enum MAX11410_GP0_DIR_enum_t {
        GP0_DIR_00_Input = 0x00, //!< 0b00
        GP0_DIR_01_reserved = 0x01, //!< 0b01
        GP0_DIR_10_OutputOpenDrain = 0x02, //!< 0b10
        GP0_DIR_11_Output = 0x03, //!< 0b11
    } MAX11410_GP0_DIR_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_GP0_ISEL_enum_t
    //----------------------------------------
    /// GPIO0 pin command
    /// CMD_r000_0100_dddd_xddd_GP0_CTRL GP0_ISEL[1:0] field (bits 5:4)
    ///
    /// - 00: GPIO_0 input disabled (default)
    /// - 01: GPIO_0 input configured as rising-edge-triggered conversion start
    /// - 10: GPIO_0 input configured as rising-edge-triggered sequence start from GP_SEQ_ADDR
    /// - 11: Reserved
    typedef enum MAX11410_GP0_ISEL_enum_t {
        GP0_ISEL_00_disabled = 0x00, //!< 0b00
        GP0_ISEL_01_TRIGGER_CONV_START = 0x01, //!< 0b01
        GP0_ISEL_10_TRIGGER_SEQ_START = 0x02, //!< 0b10
        GP0_ISEL_11_reserved = 0x03, //!< 0b11
    } MAX11410_GP0_ISEL_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_GP0_OSEL_enum_t
    //----------------------------------------
    /// GPIO0 pin command
    /// CMD_r000_0100_dddd_xddd_GP0_CTRL GP0_OSEL[2:0] field (bits 2:0)
    ///
    /// - 000: GPIO_0 output disabled, high Z (default)
    /// - 001: GPIO_0 output is configured as INTRB (active low)
    /// - 010: GPIO_0 output is configured as INTR (active high)
    /// - 011: GPIO_0 output is configured as state Logic 0
    /// - 100: GPIO_0 output is configured as state Logic 1
    /// - 101: GPIO_0 output is configured as automatic low-side switch operation (CMOS output mode overridden)
    /// - 110: GPIO_0 output is configured as modulator active status
    /// - 111: GPIO_0 output is configured as system clock (2.456Mhz Nominal)
    typedef enum MAX11410_GP0_OSEL_enum_t {
        GP0_OSEL_000_disabled = 0x00, //!< 0b000
        GP0_OSEL_001_INTRB = 0x01, //!< 0b001
        GP0_OSEL_010_INTR = 0x02, //!< 0b010
        GP0_OSEL_011_LOGIC_0 = 0x03, //!< 0b011
        GP0_OSEL_100_LOGIC_1 = 0x04, //!< 0b100
        GP0_OSEL_101_AUTO_LOWSIDE_SWITCH = 0x05, //!< 0b101
        GP0_OSEL_110_MODULATOR_ACTIVE_STATUS = 0x06, //!< 0b110
        GP0_OSEL_111_CLOCK_2M456 = 0x07, //!< 0b111
    } MAX11410_GP0_OSEL_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_GP1_DIR_enum_t
    //----------------------------------------
    /// GPIO1 pin command
    /// CMD_r000_0101_dddd_xddd_GP1_CTRL GP1_DIR[1:0] field (bits 7:6)
    ///
    /// - 00: Input mode, reference to VDDIO (default)
    /// - 01: Reserved
    /// - 10: Output mode, open-drain output
    /// - 11: Output mode, CMOS output
    typedef enum MAX11410_GP1_DIR_enum_t {
        GP1_DIR_00_Input = 0x00, //!< 0b00
        GP1_DIR_01_reserved = 0x01, //!< 0b01
        GP1_DIR_10_OutputOpenDrain = 0x02, //!< 0b10
        GP1_DIR_11_Output = 0x03, //!< 0b11
    } MAX11410_GP1_DIR_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_GP1_ISEL_enum_t
    //----------------------------------------
    /// GPIO1 pin command
    /// CMD_r000_0101_dddd_xddd_GP1_CTRL GP1_ISEL[1:0] field (bits 5:4)
    ///
    /// - 00: GPIO_1 input disabled (default)
    /// - 01: GPIO_1 input configured as rising-edge-triggered conversion start
    /// - 10: GPIO_1 input configured as rising-edge-triggered sequence start from GP_SEQ_ADDR
    /// - 11: Reserved
    typedef enum MAX11410_GP1_ISEL_enum_t {
        GP1_ISEL_00_disabled = 0x00, //!< 0b00
        GP1_ISEL_01_TRIGGER_CONV_START = 0x01, //!< 0b01
        GP1_ISEL_10_TRIGGER_SEQ_START = 0x02, //!< 0b10
        GP1_ISEL_11_reserved = 0x03, //!< 0b11
    } MAX11410_GP1_ISEL_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_GP1_OSEL_enum_t
    //----------------------------------------
    /// GPIO1 pin command
    /// CMD_r000_0101_dddd_xddd_GP1_CTRL GP1_OSEL[2:0] field (bits 2:0)
    ///
    /// - 000: GPIO_1 output disabled, high Z (default)
    /// - 001: GPIO_1 output is configured as INTRB (active low)
    /// - 010: GPIO_1 output is configured as INTR (active high)
    /// - 011: GPIO_1 output is configured as state Logic 0
    /// - 100: GPIO_1 output is configured as state Logic 1
    /// - 101: GPIO_1 output is configured as system clock (2.456Mhz Nominal)
    /// - 110: GPIO_1 output is configured as modulator active status
    /// - 111: GPIO_1 output is configured as automatic low-side switch operation (CMOS output mode overridden)
    typedef enum MAX11410_GP1_OSEL_enum_t {
        GP1_OSEL_000_disabled = 0x00, //!< 0b000
        GP1_OSEL_001_INTRB = 0x01, //!< 0b001
        GP1_OSEL_010_INTR = 0x02, //!< 0b010
        GP1_OSEL_011_LOGIC_0 = 0x03, //!< 0b011
        GP1_OSEL_100_LOGIC_1 = 0x04, //!< 0b100
        GP1_OSEL_101_AUTO_LOWSIDE_SWITCH = 0x05, //!< 0b101
        GP1_OSEL_110_MODULATOR_ACTIVE_STATUS = 0x06, //!< 0b110
        GP1_OSEL_111_CLOCK_2M456 = 0x07, //!< 0b111
    } MAX11410_GP1_OSEL_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_LINEF_enum_t
    //----------------------------------------
    /// Filter command
    /// CMD_r000_1000_x0dd_dddd_FILTER LINEF[1:0] field
    ///
    /// - 00: Simultaneous 50/60Hz FIR rejection (default)
    /// - 01: 50Hz FIR rejection
    /// - 10: 60Hz FIR rejection
    /// - 11: SINC4
    typedef enum MAX11410_LINEF_enum_t {
        LINEF_00_50Hz_60Hz_FIR = 0x00, //!< 0b00
        LINEF_01_50Hz_FIR = 0x01, //!< 0b01
        LINEF_10_60Hz_FIR = 0x02, //!< 0b10
        LINEF_11_SINC4 = 0x03, //!< 0b11
    } MAX11410_LINEF_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_RATE_enum_t
    //----------------------------------------
    /// Filter command
    /// CMD_r000_1000_x0dd_dddd_FILTER RATE[3:0] field
    ///
    /// Sets conversion rate based on LINEF value. See Table 9a through Table 9d for details.
    ///
    /// Table 9a. LINEF = 00 Data Rate and Filter Rejection Settings
    ///
    ///  Rate      | LINEF                  | CONV_TYPE                  | Rate
    /// -----------|------------------------|----------------------------|----------
    ///  RATE_0000 | LINEF_00_50Hz_60Hz_FIR | CONV_TYPE_00_Single        |  1.0SPS
    ///  RATE_0001 | LINEF_00_50Hz_60Hz_FIR | CONV_TYPE_00_Single        |  2.0SPS
    ///  RATE_0010 | LINEF_00_50Hz_60Hz_FIR | CONV_TYPE_00_Single        |  4.0SPS
    ///  RATE_0011 | LINEF_00_50Hz_60Hz_FIR | CONV_TYPE_00_Single        |  8.0SPS
    ///  RATE_0100 | LINEF_00_50Hz_60Hz_FIR | CONV_TYPE_00_Single        | 16.0SPS
    ///  RATE_0000 | LINEF_00_50Hz_60Hz_FIR | CONV_TYPE_01_Continuous    |  1.1SPS
    ///  RATE_0001 | LINEF_00_50Hz_60Hz_FIR | CONV_TYPE_01_Continuous    |  2.1SPS
    ///  RATE_0010 | LINEF_00_50Hz_60Hz_FIR | CONV_TYPE_01_Continuous    |  4.2SPS
    ///  RATE_0011 | LINEF_00_50Hz_60Hz_FIR | CONV_TYPE_01_Continuous    |  8.4SPS
    ///  RATE_0100 | LINEF_00_50Hz_60Hz_FIR | CONV_TYPE_01_Continuous    | 16.8SPS
    ///  RATE_0000 | LINEF_00_50Hz_60Hz_FIR | CONV_TYPE_10_DutyCycle_1_4 |  0.3SPS
    ///  RATE_0001 | LINEF_00_50Hz_60Hz_FIR | CONV_TYPE_10_DutyCycle_1_4 |  0.5SPS
    ///  RATE_0010 | LINEF_00_50Hz_60Hz_FIR | CONV_TYPE_10_DutyCycle_1_4 |  1.1SPS
    ///  RATE_0011 | LINEF_00_50Hz_60Hz_FIR | CONV_TYPE_10_DutyCycle_1_4 |  2.1SPS
    ///  RATE_0100 | LINEF_00_50Hz_60Hz_FIR | CONV_TYPE_10_DutyCycle_1_4 |  4.2SPS
    ///
    /// Table 9b. LINEF = 01 Data Rate and Filter Rejection Settings
    ///
    ///  Rate     | LINEF                  | CONV_TYPE                  | Rate
    /// ----------|------------------------|----------------------------|----------
    /// RATE_0000 | LINEF_01_50Hz_FIR      | CONV_TYPE_00_Single        |  1.3SPS
    /// RATE_0001 | LINEF_01_50Hz_FIR      | CONV_TYPE_00_Single        |  2.5SPS
    /// RATE_0010 | LINEF_01_50Hz_FIR      | CONV_TYPE_00_Single        |  5.0SPS
    /// RATE_0011 | LINEF_01_50Hz_FIR      | CONV_TYPE_00_Single        | 10.0SPS
    /// RATE_0100 | LINEF_01_50Hz_FIR      | CONV_TYPE_00_Single        | 20.0SPS
    /// RATE_0101 | LINEF_01_50Hz_FIR      | CONV_TYPE_00_Single        | 35.6SPS
    /// RATE_0000 | LINEF_01_50Hz_FIR      | CONV_TYPE_01_Continuous    |  1.3SPS
    /// RATE_0001 | LINEF_01_50Hz_FIR      | CONV_TYPE_01_Continuous    |  2.7SPS
    /// RATE_0010 | LINEF_01_50Hz_FIR      | CONV_TYPE_01_Continuous    |  5.3SPS
    /// RATE_0011 | LINEF_01_50Hz_FIR      | CONV_TYPE_01_Continuous    | 10.7SPS
    /// RATE_0100 | LINEF_01_50Hz_FIR      | CONV_TYPE_01_Continuous    | 21.3SPS
    /// RATE_0101 | LINEF_01_50Hz_FIR      | CONV_TYPE_01_Continuous    | 40.0SPS
    /// RATE_0000 | LINEF_01_50Hz_FIR      | CONV_TYPE_10_DutyCycle_1_4 |  0.3SPS
    /// RATE_0001 | LINEF_01_50Hz_FIR      | CONV_TYPE_10_DutyCycle_1_4 |  0.7SPS
    /// RATE_0010 | LINEF_01_50Hz_FIR      | CONV_TYPE_10_DutyCycle_1_4 |  1.3SPS
    /// RATE_0011 | LINEF_01_50Hz_FIR      | CONV_TYPE_10_DutyCycle_1_4 |  2.7SPS
    /// RATE_0100 | LINEF_01_50Hz_FIR      | CONV_TYPE_10_DutyCycle_1_4 |  5.3SPS
    /// RATE_0101 | LINEF_01_50Hz_FIR      | CONV_TYPE_10_DutyCycle_1_4 | 10.0SPS
    ///
    /// Table 9c. LINEF = 10 Data Rate and Filter Rejection Settings
    ///
    ///  Rate     | LINEF                  | CONV_TYPE                  | Rate
    /// ----------|------------------------|----------------------------|----------
    /// RATE_0000 | LINEF_10_60Hz_FIR      | CONV_TYPE_00_Single        |  1.3SPS
    /// RATE_0001 | LINEF_10_60Hz_FIR      | CONV_TYPE_00_Single        |  2.5SPS
    /// RATE_0010 | LINEF_10_60Hz_FIR      | CONV_TYPE_00_Single        |  5.0SPS
    /// RATE_0011 | LINEF_10_60Hz_FIR      | CONV_TYPE_00_Single        | 10.0SPS
    /// RATE_0100 | LINEF_10_60Hz_FIR      | CONV_TYPE_00_Single        | 20.0SPS
    /// RATE_0101 | LINEF_10_60Hz_FIR      | CONV_TYPE_00_Single        | 35.6SPS
    /// RATE_0000 | LINEF_10_60Hz_FIR      | CONV_TYPE_01_Continuous    |  1.3SPS
    /// RATE_0001 | LINEF_10_60Hz_FIR      | CONV_TYPE_01_Continuous    |  2.7SPS
    /// RATE_0010 | LINEF_10_60Hz_FIR      | CONV_TYPE_01_Continuous    |  5.3SPS
    /// RATE_0011 | LINEF_10_60Hz_FIR      | CONV_TYPE_01_Continuous    | 10.7SPS
    /// RATE_0100 | LINEF_10_60Hz_FIR      | CONV_TYPE_01_Continuous    | 21.3SPS
    /// RATE_0101 | LINEF_10_60Hz_FIR      | CONV_TYPE_01_Continuous    | 40.0SPS
    /// RATE_0000 | LINEF_10_60Hz_FIR      | CONV_TYPE_10_DutyCycle_1_4 |  0.3SPS
    /// RATE_0001 | LINEF_10_60Hz_FIR      | CONV_TYPE_10_DutyCycle_1_4 |  0.7SPS
    /// RATE_0010 | LINEF_10_60Hz_FIR      | CONV_TYPE_10_DutyCycle_1_4 |  1.3SPS
    /// RATE_0011 | LINEF_10_60Hz_FIR      | CONV_TYPE_10_DutyCycle_1_4 |  2.7SPS
    /// RATE_0100 | LINEF_10_60Hz_FIR      | CONV_TYPE_10_DutyCycle_1_4 |  5.3SPS
    /// RATE_0101 | LINEF_10_60Hz_FIR      | CONV_TYPE_10_DutyCycle_1_4 | 10.0SPS
    ///
    /// Table 9d. LINEF = 11 Data Rate and Filter Rejection Settings
    ///
    ///  Rate     | LINEF                  | CONV_TYPE                  | Rate
    /// ----------|------------------------|----------------------------|----------
    /// RATE_0000 | LINEF_11_SINC4         | CONV_TYPE_00_Single        |     1SPS
    /// RATE_0001 | LINEF_11_SINC4         | CONV_TYPE_00_Single        |     2.5SPS
    /// RATE_0010 | LINEF_11_SINC4         | CONV_TYPE_00_Single        |     5SPS
    /// RATE_0011 | LINEF_11_SINC4         | CONV_TYPE_00_Single        |    10SPS
    /// RATE_0100 | LINEF_11_SINC4         | CONV_TYPE_00_Single        |    15SPS
    /// RATE_0101 | LINEF_11_SINC4         | CONV_TYPE_00_Single        |    30SPS
    /// RATE_0110 | LINEF_11_SINC4         | CONV_TYPE_00_Single        |    60SPS
    /// RATE_0111 | LINEF_11_SINC4         | CONV_TYPE_00_Single        |   120SPS
    /// RATE_1000 | LINEF_11_SINC4         | CONV_TYPE_00_Single        |   240SPS
    /// RATE_1001 | LINEF_11_SINC4         | CONV_TYPE_00_Single        |   480SPS
    /// RATE_0000 | LINEF_11_SINC4         | CONV_TYPE_01_Continuous    |    4SPS
    /// RATE_0001 | LINEF_11_SINC4         | CONV_TYPE_01_Continuous    |   10SPS
    /// RATE_0010 | LINEF_11_SINC4         | CONV_TYPE_01_Continuous    |   20SPS
    /// RATE_0011 | LINEF_11_SINC4         | CONV_TYPE_01_Continuous    |   40SPS
    /// RATE_0100 | LINEF_11_SINC4         | CONV_TYPE_01_Continuous    |   60SPS
    /// RATE_0101 | LINEF_11_SINC4         | CONV_TYPE_01_Continuous    |  120SPS
    /// RATE_0110 | LINEF_11_SINC4         | CONV_TYPE_01_Continuous    |  240SPS
    /// RATE_0111 | LINEF_11_SINC4         | CONV_TYPE_01_Continuous    |  480SPS
    /// RATE_1000 | LINEF_11_SINC4         | CONV_TYPE_01_Continuous    |  960SPS
    /// RATE_1001 | LINEF_11_SINC4         | CONV_TYPE_01_Continuous    | 1920SPS
    /// RATE_0000 | LINEF_11_SINC4         | CONV_TYPE_10_DutyCycle_1_4 |    1SPS
    /// RATE_0001 | LINEF_11_SINC4         | CONV_TYPE_10_DutyCycle_1_4 |    2.5SPS
    /// RATE_0010 | LINEF_11_SINC4         | CONV_TYPE_10_DutyCycle_1_4 |    5SPS
    /// RATE_0011 | LINEF_11_SINC4         | CONV_TYPE_10_DutyCycle_1_4 |   10SPS
    /// RATE_0100 | LINEF_11_SINC4         | CONV_TYPE_10_DutyCycle_1_4 |   15SPS
    /// RATE_0101 | LINEF_11_SINC4         | CONV_TYPE_10_DutyCycle_1_4 |   30SPS
    /// RATE_0110 | LINEF_11_SINC4         | CONV_TYPE_10_DutyCycle_1_4 |   60SPS
    /// RATE_0111 | LINEF_11_SINC4         | CONV_TYPE_10_DutyCycle_1_4 |  120SPS
    /// RATE_1000 | LINEF_11_SINC4         | CONV_TYPE_10_DutyCycle_1_4 |  240SPS
    /// RATE_1001 | LINEF_11_SINC4         | CONV_TYPE_10_DutyCycle_1_4 |  480SPS
    ///
    typedef enum MAX11410_RATE_enum_t {
        RATE_0000 = 0x00, //!< 0b0000
        RATE_0001 = 0x01, //!< 0b0001
        RATE_0010 = 0x02, //!< 0b0010
        RATE_0011 = 0x03, //!< 0b0011
        RATE_0100 = 0x04, //!< 0b0100
        RATE_0101 = 0x05, //!< 0b0101
        RATE_0110 = 0x06, //!< 0b0110
        RATE_0111 = 0x07, //!< 0b0111
        RATE_1000 = 0x08, //!< 0b1000
        RATE_1001 = 0x09, //!< 0b1001
        RATE_1010 = 0x0a, //!< 0b1010
        RATE_1011 = 0x0b, //!< 0b1011
        RATE_1100 = 0x0c, //!< 0b1100
        RATE_1101 = 0x0d, //!< 0b1101
        RATE_1110 = 0x0e, //!< 0b1110
        RATE_1111 = 0x0f, //!< 0b1111
    } MAX11410_RATE_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_REF_SEL_enum_t
    //----------------------------------------
    /// Filter command
    /// CMD_r000_1001_dddd_dddd_CTRL REF_SEL[2:0] field
    ///
    /// - 000: AIN0(REF0P)/AIN1(REF0N)
    /// - 001: REF1P/REF1N (default)
    /// - 010: REF2P/REF2N
    /// - 011: AVDD/AGND
    /// - 100: AIN0(REF0P)/AGND (single-ended mode)
    /// - 101: REF1P/AGND (single-ended mode)
    /// - 110: REF2P/AGND (single-ended mode)
    /// - 111: AVDD/AGND
    typedef enum MAX11410_REF_SEL_enum_t {
        REF_SEL_000_AIN0_AIN1 = 0x00, //!< 0b000
        REF_SEL_001_REF1P_REF1N = 0x01, //!< 0b001
        REF_SEL_010_REF2P_REF2N = 0x02, //!< 0b010
        REF_SEL_011_AVDD_AGND = 0x03, //!< 0b011
        REF_SEL_100_AIN0_AGND = 0x04, //!< 0b100
        REF_SEL_101_REF1P_AGND = 0x05, //!< 0b101
        REF_SEL_110_REF2P_AGND = 0x06, //!< 0b110
        REF_SEL_111_AVDD_AGND = 0x07, //!< 0b111
    } MAX11410_REF_SEL_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_VBIAS_MODE_enum_t
    //----------------------------------------
    /// Source command
    /// CMD_r000_1010_dddd_dddd_SOURCE VBIAS_MODE[1:0] field
    ///
    /// - 00: Active mode (default)
    /// - 01: High impedance; 125kOhm output impedance
    /// - 10: Low impedance; 20kOhm output impedance
    /// - 11: Low impedance; 20kOhm output impedance
    typedef enum MAX11410_VBIAS_MODE_enum_t {
        VBIAS_MODE_00_Active = 0x00, //!< 0b00
        VBIAS_MODE_01_125kOhm = 0x01, //!< 0b01
        VBIAS_MODE_10_20kOhm = 0x02, //!< 0b10
        VBIAS_MODE_11_20kOhm = 0x03, //!< 0b11
    } MAX11410_VBIAS_MODE_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_BRN_MODE_enum_t
    //----------------------------------------
    /// Source command
    /// CMD_r000_1010_dddd_dddd_SOURCE BRN_MODE[1:0] field
    ///
    /// - 00: Powered down, burnout sources disabled (default)
    /// - 01: 0.5uA burnout current sources enabled
    /// - 10: 1uA burnout current sources enabled
    /// - 11: 10uA burnout current sources enabled
    typedef enum MAX11410_BRN_MODE_enum_t {
        BRN_MODE_00_disabled = 0x00, //!< 0b00
        BRN_MODE_01_0u5A = 0x01, //!< 0b01
        BRN_MODE_10_1uA = 0x02, //!< 0b10
        BRN_MODE_11_10uA = 0x03, //!< 0b11
    } MAX11410_BRN_MODE_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_IDAC_MODE_enum_t
    //----------------------------------------
    /// Source command
    /// CMD_r000_1010_dddd_dddd_SOURCE IDAC_MODE[3:0] field
    ///
    /// - 0000: 10uA (default)
    /// - 0001: 50uA
    /// - 0010: 75uA
    /// - 0011: 100uA
    /// - 0100: 125uA
    /// - 0101: 150uA
    /// - 0110: 175uA
    /// - 0111: 200uA
    /// - 1000: 225uA
    /// - 1001: 250uA
    /// - 1010: 300uA
    /// - 1011: 400uA
    /// - 1100: 600uA
    /// - 1101: 800uA
    /// - 1110: 1200uA
    /// - 1111: 1600uA
    typedef enum MAX11410_IDAC_MODE_enum_t {
        IDAC_MODE_0000_10uA = 0x00, //!< 0b0000
        IDAC_MODE_0001_50uA = 0x01, //!< 0b0001
        IDAC_MODE_0010_75uA = 0x02, //!< 0b0010
        IDAC_MODE_0011_100uA = 0x03, //!< 0b0011
        IDAC_MODE_0100_125uA = 0x04, //!< 0b0100
        IDAC_MODE_0101_150uA = 0x05, //!< 0b0101
        IDAC_MODE_0110_175uA = 0x06, //!< 0b0110
        IDAC_MODE_0111_200uA = 0x07, //!< 0b0111
        IDAC_MODE_1000_225uA = 0x08, //!< 0b1000
        IDAC_MODE_1001_250uA = 0x09, //!< 0b1001
        IDAC_MODE_1010_300uA = 0x0a, //!< 0b1010
        IDAC_MODE_1011_400uA = 0x0b, //!< 0b1011
        IDAC_MODE_1100_600uA = 0x0c, //!< 0b1100
        IDAC_MODE_1101_800uA = 0x0d, //!< 0b1101
        IDAC_MODE_1110_1200uA = 0x0e, //!< 0b1110
        IDAC_MODE_1111_1600uA = 0x0f, //!< 0b1111
    } MAX11410_IDAC_MODE_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_AINP_SEL_enum_t
    //----------------------------------------
    /// Input multiplexer channel selection
    /// CMD_r000_1011_dddd_dddd_MUX_CTRL0 field AINP_SEL[3:0]
    ///
    /// - 0000: AINP = AIN0
    /// - 0001: AINP = AIN1
    /// - 0010: AINP = AIN2
    /// - 0011: AINP = AIN3
    /// - 0100: AINP = AIN4
    /// - 0101: AINP = AIN5
    /// - 0110: AINP = AIN6
    /// - 0111: AINP = AIN7
    /// - 1000: AINP = AIN8
    /// - 1001: AINP = AIN9
    /// - 1010: AINP = AVDD
    /// - 1011: AINN = Unconnected
    /// - 1100: AINN = Unconnected
    /// - 1101: AINN = Unconnected
    /// - 1110: AINN = Unconnected
    /// - 1111: AINN = Unconnected (default)
    typedef enum MAX11410_AINP_SEL_enum_t {
        AINP_SEL_0000_AIN0 = 0x00, //!< 0b0000
        AINP_SEL_0001_AIN1 = 0x01, //!< 0b0001
        AINP_SEL_0010_AIN2 = 0x02, //!< 0b0010
        AINP_SEL_0011_AIN3 = 0x03, //!< 0b0011
        AINP_SEL_0100_AIN4 = 0x04, //!< 0b0100
        AINP_SEL_0101_AIN5 = 0x05, //!< 0b0101
        AINP_SEL_0110_AIN6 = 0x06, //!< 0b0110
        AINP_SEL_0111_AIN7 = 0x07, //!< 0b0111
        AINP_SEL_1000_AIN8 = 0x08, //!< 0b1000
        AINP_SEL_1001_AIN9 = 0x09, //!< 0b1001
        AINP_SEL_1010_AVDD = 0x0a, //!< 0b1010
        AINP_SEL_1011_unconnected = 0x0b, //!< 0b1011
        AINP_SEL_1100_unconnected = 0x0c, //!< 0b1100
        AINP_SEL_1101_unconnected = 0x0d, //!< 0b1101
        AINP_SEL_1110_unconnected = 0x0e, //!< 0b1110
        AINP_SEL_1111_unconnected = 0x0f, //!< 0b1111
    } MAX11410_AINP_SEL_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_AINN_SEL_enum_t
    //----------------------------------------
    /// Input multiplexer channel selection
    /// CMD_r000_1011_dddd_dddd_MUX_CTRL0 field AINN_SEL[3:0]
    ///
    /// - 0000: AINN = AIN0
    /// - 0001: AINN = AIN1
    /// - 0010: AINN = AIN2
    /// - 0011: AINN = AIN3
    /// - 0100: AINN = AIN4
    /// - 0101: AINN = AIN5
    /// - 0110: AINN = AIN6
    /// - 0111: AINN = AIN7
    /// - 1000: AINN = AIN8
    /// - 1001: AINN = AIN9
    /// - 1010: AINN = GND
    /// - 1011: AINN = Unconnected
    /// - 1100: AINN = Unconnected
    /// - 1101: AINN = Unconnected
    /// - 1110: AINN = Unconnected
    /// - 1111: AINN = Unconnected (default)
    typedef enum MAX11410_AINN_SEL_enum_t {
        AINN_SEL_0000_AIN0 = 0x00, //!< 0b0000
        AINN_SEL_0001_AIN1 = 0x01, //!< 0b0001
        AINN_SEL_0010_AIN2 = 0x02, //!< 0b0010
        AINN_SEL_0011_AIN3 = 0x03, //!< 0b0011
        AINN_SEL_0100_AIN4 = 0x04, //!< 0b0100
        AINN_SEL_0101_AIN5 = 0x05, //!< 0b0101
        AINN_SEL_0110_AIN6 = 0x06, //!< 0b0110
        AINN_SEL_0111_AIN7 = 0x07, //!< 0b0111
        AINN_SEL_1000_AIN8 = 0x08, //!< 0b1000
        AINN_SEL_1001_AIN9 = 0x09, //!< 0b1001
        AINN_SEL_1010_GND = 0x0a, //!< 0b1010
        AINN_SEL_1011_unconnected = 0x0b, //!< 0b1011
        AINN_SEL_1100_unconnected = 0x0c, //!< 0b1100
        AINN_SEL_1101_unconnected = 0x0d, //!< 0b1101
        AINN_SEL_1110_unconnected = 0x0e, //!< 0b1110
        AINN_SEL_1111_unconnected = 0x0f, //!< 0b1111
    } MAX11410_AINN_SEL_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_IDAC1_SEL_enum_t
    //----------------------------------------
    /// Input multiplexer channel selection
    /// CMD_r000_1100_dddd_dddd_MUX_CTRL1 field IDAC1_SEL[3:0]
    ///
    /// - 0000: AIN0
    /// - 0001: AIN1
    /// - 0010: AIN2
    /// - 0011: AIN3
    /// - 0100: AIN4
    /// - 0101: AIN5
    /// - 0110: AIN6
    /// - 0111: AIN7
    /// - 1000: AIN8
    /// - 1001: AIN9
    /// - 1010: Unconnected; IDAC1 powered down.
    /// - 1011: Unconnected; IDAC1 powered down.
    /// - 1100: Unconnected; IDAC1 powered down.
    /// - 1101: Unconnected; IDAC1 powered down.
    /// - 1110: Unconnected; IDAC1 powered down.
    /// - 1111: Unconnected; IDAC1 powered down.(Default)
    typedef enum MAX11410_IDAC1_SEL_enum_t {
        IDAC1_SEL_0000_AIN0 = 0x00, //!< 0b0000
        IDAC1_SEL_0001_AIN1 = 0x01, //!< 0b0001
        IDAC1_SEL_0010_AIN2 = 0x02, //!< 0b0010
        IDAC1_SEL_0011_AIN3 = 0x03, //!< 0b0011
        IDAC1_SEL_0100_AIN4 = 0x04, //!< 0b0100
        IDAC1_SEL_0101_AIN5 = 0x05, //!< 0b0101
        IDAC1_SEL_0110_AIN6 = 0x06, //!< 0b0110
        IDAC1_SEL_0111_AIN7 = 0x07, //!< 0b0111
        IDAC1_SEL_1000_AIN8 = 0x08, //!< 0b1000
        IDAC1_SEL_1001_AIN9 = 0x09, //!< 0b1001
        IDAC1_SEL_1010_unconnected = 0x0a, //!< 0b1010
        IDAC1_SEL_1011_unconnected = 0x0b, //!< 0b1011
        IDAC1_SEL_1100_unconnected = 0x0c, //!< 0b1100
        IDAC1_SEL_1101_unconnected = 0x0d, //!< 0b1101
        IDAC1_SEL_1110_unconnected = 0x0e, //!< 0b1110
        IDAC1_SEL_1111_unconnected = 0x0f, //!< 0b1111
    } MAX11410_IDAC1_SEL_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_IDAC0_SEL_enum_t
    //----------------------------------------
    /// Input multiplexer channel selection
    /// CMD_r000_1100_dddd_dddd_MUX_CTRL1 field IDAC0_SEL[3:0]
    ///
    /// - 0000: AIN0
    /// - 0001: AIN1
    /// - 0010: AIN2
    /// - 0011: AIN3
    /// - 0100: AIN4
    /// - 0101: AIN5
    /// - 0110: AIN6
    /// - 0111: AIN7
    /// - 1000: AIN8
    /// - 1001: AIN9
    /// - 1010: Unconnected; IDAC0 powered down.
    /// - 1011: Unconnected; IDAC0 powered down.
    /// - 1100: Unconnected; IDAC0 powered down.
    /// - 1101: Unconnected; IDAC0 powered down.
    /// - 1110: Unconnected; IDAC0 powered down.
    /// - 1111: Unconnected; IDAC0 powered down.(Default)
    typedef enum MAX11410_IDAC0_SEL_enum_t {
        IDAC0_SEL_0000_AIN0 = 0x00, //!< 0b0000
        IDAC0_SEL_0001_AIN1 = 0x01, //!< 0b0001
        IDAC0_SEL_0010_AIN2 = 0x02, //!< 0b0010
        IDAC0_SEL_0011_AIN3 = 0x03, //!< 0b0011
        IDAC0_SEL_0100_AIN4 = 0x04, //!< 0b0100
        IDAC0_SEL_0101_AIN5 = 0x05, //!< 0b0101
        IDAC0_SEL_0110_AIN6 = 0x06, //!< 0b0110
        IDAC0_SEL_0111_AIN7 = 0x07, //!< 0b0111
        IDAC0_SEL_1000_AIN8 = 0x08, //!< 0b1000
        IDAC0_SEL_1001_AIN9 = 0x09, //!< 0b1001
        IDAC0_SEL_1010_unconnected = 0x0a, //!< 0b1010
        IDAC0_SEL_1011_unconnected = 0x0b, //!< 0b1011
        IDAC0_SEL_1100_unconnected = 0x0c, //!< 0b1100
        IDAC0_SEL_1101_unconnected = 0x0d, //!< 0b1101
        IDAC0_SEL_1110_unconnected = 0x0e, //!< 0b1110
        IDAC0_SEL_1111_unconnected = 0x0f, //!< 0b1111
    } MAX11410_IDAC0_SEL_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_SIG_PATH_enum_t
    //----------------------------------------
    /// Input multiplexer channel selection
    /// CMD_r000_1110_00ss_0ggg_PGA field SIG_PATH[1:0]
    ///
    /// - 00: Buffered, low-power, unity-gain path (PGA disabled, digital gain) [default]
    /// - 01: Bypass path (signal buffer disabled,PGA disabled, digital gain)
    /// - 10: PGA path (signal buffer disabled, analog gain)
    /// - 11: Reserved
    typedef enum MAX11410_SIG_PATH_enum_t {
        SIG_PATH_00_BUFFERED = 0x00, //!< 0b00
        SIG_PATH_01_BYPASS = 0x01, //!< 0b01
        SIG_PATH_10_PGA = 0x02, //!< 0b10
        SIG_PATH_11_reserved = 0x03, //!< 0b11
    } MAX11410_SIG_PATH_enum_t;

// CODE GENERATOR: TypedefEnum MAX11410_GAIN_enum_t
    //----------------------------------------
    /// Input multiplexer channel selection
    /// CMD_r000_1110_00ss_0ggg_PGA field GAIN[2:0]
    ///
    /// - 000: 1 (default)
    /// - 001: 2
    /// - 010: 4
    /// - 011: 8
    /// - 100: 16
    /// - 101: 32
    /// - 110: 64
    /// - 111: 128
    typedef enum MAX11410_GAIN_enum_t {
        GAIN_000_1 = 0x00, //!< 0b000
        GAIN_001_2 = 0x01, //!< 0b001
        GAIN_010_4 = 0x02, //!< 0b010
        GAIN_011_8 = 0x03, //!< 0b011
        GAIN_100_16 = 0x04, //!< 0b100
        GAIN_101_32 = 0x05, //!< 0b101
        GAIN_110_64 = 0x06, //!< 0b110
        GAIN_111_128 = 0x07, //!< 0b111
    } MAX11410_GAIN_enum_t;

// TODO1: CODE GENERATOR: ic_variant -- IC's supported with this driver
    /**
     * @brief IC's supported with this driver
     * @details MAX11410
     */
    typedef enum
    {
        MAX11410_IC = 0,
        //MAX11410_IC = 1
    } MAX11410_ic_t;

// TODO1: CODE GENERATOR: class constructor declaration
    /**********************************************************//**
    * @brief Constructor for MAX11410 Class.
    *
    * @details Requires an existing SPI object as well as a DigitalOut object.
    * The DigitalOut object is used for a chip enable signal
    *
    * On Entry:
    *     @param[in] spi - pointer to existing SPI object
    *     @param[in] cs_pin - pointer to a DigitalOut pin object
    *     CODE GENERATOR: class constructor docstrings gpio InputPin pins
    *     CODE GENERATOR: class constructor docstrings gpio OutputPin pins
    *     @param[in] ic_variant - which type of MAX11410 is used
    *
    * On Exit:
    *
    * @return None
    **************************************************************/
    MAX11410(SPI &spi, DigitalOut &cs_pin, // SPI interface
            // CODE GENERATOR: class constructor declaration gpio InputPin pins
            // CODE GENERATOR: class constructor declaration gpio OutputPin pins
            MAX11410_ic_t ic_variant);

// CODE GENERATOR: class destructor declaration
    /************************************************************
     * @brief Default destructor for MAX11410 Class.
     *
     * @details Destroys SPI object if owner
     *
     * On Entry:
     *
     * On Exit:
     *
     * @return None
     **************************************************************/
    ~MAX11410();

    // CODE GENERATOR: Declare SPI diagnostic function pointer void onSPIprint()
    /// Function pointer void f(size_t byteCount, uint8_t mosiData[], uint8_t misoData[])
    Callback<void(size_t, uint8_t*, uint8_t*)> onSPIprint; //!< optional @ref onSPIprint SPI diagnostic function

    // CODE GENERATOR: spi_frequency setter declaration
    /// set SPI SCLK frequency
    void spi_frequency(int spi_sclk_Hz);

    // CODE GENERATOR: spi_frequency getter declaration and definition
    /// get SPI SCLK frequency
    int get_spi_frequency() const { return m_SPI_SCLK_Hz; }

    // CODE GENERATOR: spi_dataMode getter declaration and definition
    /// get SPI mode
    int get_spi_dataMode() const { return m_SPI_dataMode; }

//----------------------------------------
// CODE GENERATOR: omit typedef enum MAX11410_device_t, class members instead of global device object
public:

    /// AIN0-AIN1 reference voltage, in Volts
    double ref0_v;

    /// REF1P-REF1N reference voltage, in Volts
    double ref1_v;

    /// REF2P-REF2N reference voltage, in Volts
    double ref2_v;

    /// AVDD-AGND reference voltage, in Volts
    double avdd_v;

    /// shadow of register ctrl CMD_r000_1001_dddd_dddd_CTRL
    uint32_t ctrl;

    /// read-only pga gain 1, 2, 4, 8, 16, 32, 64, or 128 set by Configure_PGA gain index register pga CMD_r000_1110_00ss_0ggg_PGA
    uint8_t pgaGain;

    /// shadow of read-only register status CMD_r011_1000_dddd_dddd_dddd_dddd_dxxx_dddd_STATUS
    uint32_t status;

    /// shadow of read-only register data0 CMD_r011_0000_dddd_dddd_dddd_dddd_dddd_dddd_DATA0
    uint32_t data0;

    /// Each channel's most recent value in LSBs.
    /// Updated by Measure_Voltage function.
    /// Use VoltageOfCode function to convert LSBs to physical voltage.
    /// (Valid index range AINP_SEL_0000_AIN0 to AINP_SEL_1010_AVDD).
    /// AINP_SEL_1010_AVDD is a sentinel position.
    ///
    uint32_t AINcode[11];

    /// When driver polls status of a pin signal or a register status bit,
    /// and there is no device physically connected, the driver must
    /// be able to halt and report failure if too many tries. Each attempt
    /// counts down until loop_limit is reached or exceeded.
    ///
    /// If driver seems to hang or takes too long to decide that device
    /// is not connected, reduce the futility countdown limit value.
    ///
    /// If driver sometimes works but sometimes intermittently fails to
    /// recognize device is attached, increase the futility countdown limit.
    int loop_limit;

    /// read-only constant list of registers to be read by menu item * with no arguments
    MAX11410::MAX11410_CMD_enum_t* readAllStatusList;

    /// read-only constant number of registers to be read by menu item * with no arguments
    uint8_t readAllStatusListLen;

    /// timing delay after enable RTD bias current in Measure_RTD()
    int rtd_ms;

    /// RTD Resistance measurement; Thermocouple Cold Junction, in Ohms
    double rtd_ohm;

    /// Temperature calculated from RTD Resistance; Thermocouple Cold Junction, in degrees C
    double rtd_degc;

    /// filter register configuration in Measure_RTD()
    uint8_t rtd_filter;

    /// ctrl register configuration in Measure_RTD()
    uint8_t rtd_ctrl;

    /// source register configuration in Measure_RTD()
    uint8_t rtd_source;

    /// pga register configuration in Measure_RTD()
    uint8_t rtd_pga;

    /// filter register configuration in Measure_Voltage()
    uint8_t v_filter;

    /// ctrl register configuration in Measure_Voltage()
    uint8_t v_ctrl;

    /// pga register configuration in Measure_Voltage()
    uint8_t v_pga;

    /// Thermocouple voltage measurement, in Volts
    double tc_v;

    /// Temperature calculated from Thermocouple voltage, in degrees C
    double tc_delta_degc;

    /// Temperature calculated from Thermocouple voltage, in degrees C
    double tc_degc;

// CODE GENERATOR: omit global g_MAX11410_device

// CODE GENERATOR: extern function declarations
// CODE GENERATOR: extern function declaration SPIoutputCS
//----------------------------------------
// Assert SPI Chip Select
// SPI chip-select for MAX11410
//
    void SPIoutputCS(int isLogicHigh);

// CODE GENERATOR: extern function declaration SPIwrite16bits
//----------------------------------------
// SPI write 16 bits
// SPI interface to MAX11410 shift 16 bits mosiData into MAX11410 DIN
//
    void SPIwrite16bits(int16_t mosiData16);

// CODE GENERATOR: extern function declaration SPIreadWrite16bits
//----------------------------------------
// SPI read and write 16 bits
// SPI interface to MAX11410 shift 16 bits mosiData16 into MAX11410 DIN
// while simultaneously capturing 16 bits miso data from MAX11410 DOUT
//
    int16_t SPIreadWrite16bits(int16_t mosiData16);

// CODE GENERATOR: extern function declaration SPIreadWrite32bits
//----------------------------------------
// SPI read and write 32 bits
// SPI interface to MAX11410 shift 32 bits mosiData into MAX11410 DIN
// while simultaneously capturing 32 bits miso data from MAX11410 DOUT
//
    int32_t SPIreadWrite32bits(int32_t mosiData32);

// CODE GENERATOR: class member data
private:
// CODE GENERATOR: class member data for SPI interface
    // SPI object
    SPI &m_spi;
    int m_SPI_SCLK_Hz;
    int m_SPI_dataMode;
    int m_SPI_cs_state;

    // Selector pin object
    DigitalOut &m_cs_pin;

// CODE GENERATOR: class member data for gpio InputPin pins
// CODE GENERATOR: class member data for gpio OutputPin pins

    // Identifies which IC variant is being used
    MAX11410_ic_t m_ic_variant;

public:

// CODE GENERATOR: class member function declarations
    //----------------------------------------
    /// Menu item '!'
    /// Initialize device
    ///
    /// @test Init() expect 1
    ///
    /// @test group POR // verify initial register values
    /// @test group PORverbose // verify initial register values
    /// @test group PORverbose tinyTester.print("PART_ID value")
    /// @test group POR RegRead(MAX11410::CMD_r001_0001_xxxx_xxxx_xxxx_xxxx_xxxx_xddd_PART_ID, buffer) expect 1 expect-buffer 0x000F02
    ///
    /// @test group PORverbose tinyTester.print("POR value 0x04 CMD_r000_0100_dddd_xddd_GP0_CTRL")
    /// @test group POR RegRead(MAX11410::CMD_r000_0100_dddd_xddd_GP0_CTRL, buffer) expect 1 expect-buffer 0x00
    ///
    /// @test group PORverbose tinyTester.print("POR value 0x05 CMD_r000_0101_dddd_xddd_GP1_CTRL")
    /// @test group POR RegRead(MAX11410::CMD_r000_0101_dddd_xddd_GP1_CTRL, buffer) expect 1 expect-buffer 0x00
    ///
    /// @test group PORverbose tinyTester.print("POR value 0x07 CMD_r000_0111_xddd_dddd_GP_SEQ_ADDR")
    /// @test group POR RegRead(MAX11410::CMD_r000_0111_xddd_dddd_GP_SEQ_ADDR, buffer) expect 1 expect-buffer 0x00003a
    ///
    /// @test group PORverbose tinyTester.print("POR value 0x08 CMD_r000_1000_x0dd_dddd_FILTER")
    /// @test group POR RegRead(MAX11410::CMD_r000_1000_x0dd_dddd_FILTER, buffer) expect 1 expect-buffer 0x00
    ///
    /// @test group PORverbose tinyTester.print("POR value 0x09 CMD_r000_1001_dddd_dddd_CTRL")
    /// @test group POR RegRead(MAX11410::CMD_r000_1001_dddd_dddd_CTRL, buffer) expect 1 expect-buffer 0x000001
    ///
    /// @test group PORverbose tinyTester.print("POR value 0x0a CMD_r000_1010_dddd_dddd_SOURCE")
    /// @test group POR RegRead(MAX11410::CMD_r000_1010_dddd_dddd_SOURCE, buffer) expect 1 expect-buffer 0x00
    ///
    /// @test group PORverbose tinyTester.print("POR value 0x0b CMD_r000_1011_dddd_dddd_MUX_CTRL0")
    /// @test group POR RegRead(MAX11410::CMD_r000_1011_dddd_dddd_MUX_CTRL0, buffer) expect 1 expect-buffer 0x0000ff
    ///
    /// @test group PORverbose tinyTester.print("POR value 0x0c CMD_r000_1100_dddd_dddd_MUX_CTRL1")
    /// @test group POR RegRead(MAX11410::CMD_r000_1100_dddd_dddd_MUX_CTRL1, buffer) expect 1 expect-buffer 0x0000ff
    ///
    /// @test group PORverbose tinyTester.print("POR value 0x0d CMD_r000_1101_dddd_dddd_MUX_CTRL2")
    /// @test group POR RegRead(MAX11410::CMD_r000_1101_dddd_dddd_MUX_CTRL2, buffer) expect 1 expect-buffer 0x00
    ///
    /// @test group PORverbose tinyTester.print("POR value 0x0e CMD_r000_1110_00ss_0ggg_PGA")
    /// @test group POR RegRead(MAX11410::CMD_r000_1110_00ss_0ggg_PGA, buffer) expect 1 expect-buffer 0x00
    ///
    /// @future test     CMD_r000_1111_dddd_dddd_WAIT_EXT = 0x0f, //!< 0b0001111
    /// @future test     CMD_r001_0000_xxxx_xxxx_WAIT_START = 0x10, //!< 0b0010000
    ///
    /// @test group RES1KA2A3TOGND // measure a 1kohm resistor between (AIN2,AIN3) and AGND to verify ref2_v (disabled by default)
    /// @test group RES1KA2A3TOGNDMORE // measure a 1kohm resistor between (AIN2,AIN3) and AGND to verify ref2_v in more detail
    /// @test group RES1KA2A3TOGNDMORE tinyTester.print("measure a 1kohm resistor between (AIN2,AIN3) and AGND to verify ref2_v")
    /// @test group RES1KA2A3TOGND tinyTester.settle_time_msec = 1000 // default 250
    /// @test group RES1KA2A3TOGND RegWrite(0x0C, 0xF3) expect 1 // *mux_ctrl1=0xf3 drives current source from AIN3
    ///
    /// @test group RES1KA2A3TOGNDMORE RegWrite(0x0A, 0x03) expect 1 // *source=0x03 idac_mode=100uA, 1k resistor 0.1V
    /// @test group RES1KA2A3TOGNDMORE tinyTester.print("idac_mode=100uA, 1k resistor 0.1V")
    /// @test group RES1KA2A3TOGNDMORE tinyTester.Wait_Output_Settling()
    /// @test group RES1KA2A3TOGNDMORE Measure_Voltage(2,10) expect 0.1
    /// @test group RES1KA2A3TOGNDMORE AINcode[2] expect (uint32_t)337731 within 33773 // idac_mode=100uA, 1k resistor 0.1V
    ///
    /// @test group RES1KA2A3TOGNDMORE RegWrite(0x0A, 0x0D) expect 1 // *source=0x0d idac_mode=800uA, 1k resistor 0.8V
    /// @test group RES1KA2A3TOGNDMORE tinyTester.print("idac_mode=800uA, 1k resistor 0.8V")
    /// @test group RES1KA2A3TOGNDMORE tinyTester.Wait_Output_Settling()
    /// @test group RES1KA2A3TOGNDMORE Measure_Voltage(2,10) expect 0.8
    /// @test group RES1KA2A3TOGNDMORE AINcode[2] expect (uint32_t)2724467 within 33773 // idac_mode=800uA, 1k resistor 0.8V
    ///
    /// @test group RES1KA2A3TOGND RegWrite(0x0A, 0x0B) expect 1 // *source=0x0b idac_mode=400uA, 1k resistor 0.4V
    /// @test group RES1KA2A3TOGNDMORE tinyTester.print("idac_mode=400uA, 1k resistor 0.4V")
    /// @test group RES1KA2A3TOGND tinyTester.Wait_Output_Settling()
    /// @test group RES1KA2A3TOGND Measure_Voltage(2,10) expect 0.4
    /// @test group RES1KA2A3TOGNDMORE AINcode[2] expect (uint32_t)1343163 within 33773 // idac_mode=400uA, 1k resistor 0.4V
    ///
    /// @test tinyTester.print("check filter register is writeable")
    /// @future test tinyTester.print("this is a real mess dealing with the custom types")
    /// @test RegWrite(0x08, 0x34) expect 1
    /// @future test tinyTester.print("error: no matching function for call to 'MaximTinyTester::FunctionCall_Expect(const char [18], uint8_t (&)(MAX11410::MAX11410_CMD_enum_t, uint32_t), MAX11410::MAX11410_CMD_enum_t, uint32_t, int)'")
    /// @future test RegWrite(CMD_r000_1000_x0dd_dddd_FILTER, 0x34) expect 1
    /// @future test RegWrite(MAX11410_CMD_enum_t::CMD_r000_1000_x0dd_dddd_FILTER, 0x34) expect 1
    /// @future test RegWrite(MAX11410::MAX11410_CMD_enum_t::CMD_r000_1000_x0dd_dddd_FILTER, 0x34) expect 1
    ///
    /// @test tinyTester.print("check filter register is readable")
    /// @test RegRead(0x08, buffer) expect 1 expect-buffer 0x34
    /// @future test RegRead(MAX11410::MAX11410_CMD_enum_t::CMD_r000_1000_x0dd_dddd_FILTER, &buffer) expect 1 expect-buffer 0x34
    ///
    /// @test tinyTester.settle_time_msec = 250 // default 250
    /// @test tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
    /// @test tinyTester.input_timeout_time_msec = 250 // default 250
    /// @test tinyTester.settle_time_msec = 20 // default 250
    /// @test tinyTester.blink_time_msec = 20 // quickly speed through the software verification
    /// @test tinyTester.input_timeout_time_msec = 100 // default 250
    ///
    /// @test tinyTester.Wait_Output_Settling()
    ///
    /// @future test tinyTester.DigitalIn_Read_Expect_WarnOnly(DigitalIn& digitalInPin, const char* pinName, int expect_result, const char *expect_description)
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Init(void);

    //----------------------------------------
    /// Return the physical voltage corresponding to conversion result,
    /// for unipolar mode.
    /// Does not perform any offset or gain correction.
    ///
    /// @pre CTRL::U_BN = 1 -- Unipolar mode
    /// @pre CTRL::FORMAT = x
    /// @pre g_MAX11410_device.VRef = Voltage of REF input, in Volts
    /// @param[in] value_u24: raw 24-bit MAX11410 code (right justified).
    /// @return physical voltage corresponding to MAX11410 code.
    ///
    /// @test group UNIPOLAR // Verify function VoltageOfCode_Unipolar
    /// @test group UNIPOLAR tinyTester.blink_time_msec = 20 // quickly speed through the software verification
    /// @test group UNIPOLAR Configure_CTRL_REF(2) expect 1 // These tests require REF2 = 2.500V
    /// @test group UNIPOLAR Configure_PGA(0,0) expect 1 // These tests require PGA gain=1
    /// @test group UNIPOLAR VoltageOfCode_Unipolar(0xFFFFFF) expect 2.500 within 0.030 // Full Scale
    /// @test group UNIPOLAR VoltageOfCode_Unipolar(0xFFFFFE) expect 2.500              // Full Scale
    /// @test group UNIPOLAR VoltageOfCode_Unipolar(0xCCCCCC) expect 2.000              // Two Volts
    /// @test group UNIPOLAR VoltageOfCode_Unipolar(0xC00000) expect 1.875              // 75% Scale
    /// @test group UNIPOLAR VoltageOfCode_Unipolar(0x800000) expect 1.250              // Mid Scale
    /// @test group UNIPOLAR VoltageOfCode_Unipolar(0x666666) expect 1.000              // One Volt
    /// @test group UNIPOLAR VoltageOfCode_Unipolar(0x400000) expect 0.625              // 25% Scale
    /// @test group UNIPOLAR VoltageOfCode_Unipolar(0x0A3D70) expect 0.100              // 100mV
    /// @test group UNIPOLAR VoltageOfCode_Unipolar(0x000064) expect 0.000014901162     // 100 LSB
    /// @test group UNIPOLAR VoltageOfCode_Unipolar(0x00000A) expect 0.0000014901162    // Ten LSB
    /// @test group UNIPOLAR VoltageOfCode_Unipolar(0x000003) expect 0.00000044703483   // Three LSB
    /// @test group UNIPOLAR VoltageOfCode_Unipolar(0x000002) expect 0.00000029802326   // Two LSB
    /// @test group UNIPOLAR VoltageOfCode_Unipolar(0x000001) expect 0.00000014901162   // One LSB
    /// @test group UNIPOLAR VoltageOfCode_Unipolar(0x000000) expect 0.0                // Zero Scale
    /// @test group UNIPOLAR tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
    ///
    double VoltageOfCode_Unipolar(uint32_t value_u24);

    //----------------------------------------
    /// Return the physical voltage corresponding to conversion result,
    /// when conversion format is Bipolar mode, offset binary.
    /// Does not perform any offset or gain correction.
    ///
    /// @pre CTRL::U_BN = 0 -- Bipolar mode
    /// @pre CTRL::FORMAT = 1 -- offset binary
    /// @pre g_MAX11410_device.VRef = Voltage of REF input, in Volts
    /// @param[in] value_u24: raw 24-bit MAX11410 code (right justified).
    /// @return physical voltage corresponding to MAX11410 code.
    ///
    /// @test group BIPOB // Verify function VoltageOfCode_Bipolar_OffsetBinary
    /// @test group BIPOB tinyTester.blink_time_msec = 20 // quickly speed through the software verification
    /// @test group BIPOB Configure_CTRL_REF(2) expect 1 // These tests require REF2 = 2.500V
    /// @test group BIPOB Configure_PGA(0,0) expect 1 // These tests require PGA gain=1
    /// @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0xFFFFFF) expect 2.5 within 0.030  // Full Scale
    /// @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0xFFFFFE) expect 2.5               // Full Scale
    /// @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0xC00000) expect 1.25              // Mid Scale
    /// @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0x800003) expect 0.00000894069671  // Three LSB
    /// @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0x800002) expect 0.00000596046447  // Two LSB
    /// @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0x800001) expect 0.0000029802326   // One LSB
    /// @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0x800000) expect 0.0               // Zero Scale
    /// @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0x7FFFFF) expect -0.0000029802326  // Negative One LSB
    /// @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0x7FFFFE) expect -0.0000059604644  // Negative Two LSB
    /// @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0x7FFFFD) expect -0.0000089406967  // Negative Three LSB
    /// @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0x400000) expect -1.25             // Negative Mid Scale
    /// @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0x000001) expect -2.5              // Negative Full Scale
    /// @test group BIPOB VoltageOfCode_Bipolar_OffsetBinary(0x000000) expect -2.5              // Negative Full Scale
    /// @test group BIPOB tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
    ///
    double VoltageOfCode_Bipolar_OffsetBinary(uint32_t value_u24);

    //----------------------------------------
    /// Return the physical voltage corresponding to conversion result,
    /// when conversion format is Bipolar mode, 2's complement.
    /// Does not perform any offset or gain correction.
    ///
    /// @pre CTRL::U_BN = 0 -- Bipolar mode
    /// @pre CTRL::FORMAT = 0 -- 2's complement
    /// @pre g_MAX11410_device.VRef = Voltage of REF input, in Volts
    /// @param[in] value_u24: raw 24-bit MAX11410 code (right justified).
    /// @return physical voltage corresponding to MAX11410 code.
    ///
    /// @test group BIP2C // Verify function VoltageOfCode_Bipolar_2sComplement
    /// @test group BIP2C tinyTester.blink_time_msec = 20 // quickly speed through the software verification
    /// @test group BIP2C Configure_CTRL_REF(2) expect 1 // These tests require REF2 = 2.500V
    /// @test group BIP2C Configure_PGA(0,0) expect 1 // These tests require PGA gain=1
    /// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x7FFFFF) expect 2.500 within 0.030 // Full Scale
    /// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x7FFFFE) expect 2.500              // Full Scale
    /// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x666666) expect 2.000              // Two Volts
    /// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x600000) expect 1.875              // 75% Scale
    /// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x400000) expect 1.250              // Mid Scale
    /// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x333333) expect 1.000              // One Volt
    /// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x200000) expect 0.625              // 25% Scale
    /// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x051eb8) expect 0.100              // 100mV
    /// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x000003) expect 0.00000894069671   // Three LSB
    /// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x000002) expect 0.00000596046447   // Two LSB
    /// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x000001) expect 0.0000029802326    // One LSB
    /// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x000000) expect 0.0                // Zero Scale
    /// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0xFFFFFF) expect -0.0000029802326   // Negative One LSB
    /// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0xFFFFFE) expect -0.0000059604644   // Negative Two LSB
    /// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0xFFFFFD) expect -0.0000089406967   // Negative Three LSB
    /// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0xFAE148) expect -0.100             // Negative 100mV
    /// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0xE00000) expect -0.625             // Negative 25% Scale
    /// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0xCCCCCD) expect -1.000             // Negative One Volt
    /// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0xC00000) expect -1.250             // Negative Mid Scale
    /// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0xA00000) expect -1.875             // Negative 75% Scale
    /// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x99999A) expect -2.000             // Negative Two Volts
    /// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x800001) expect -2.500             // Negative Full Scale
    /// @test group BIP2C VoltageOfCode_Bipolar_2sComplement(0x800000) expect -2.500             // Negative Full Scale
    /// @test group BIP2C tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
    ///
    double VoltageOfCode_Bipolar_2sComplement(uint32_t value_u24);

    //----------------------------------------
    /// Return the physical voltage corresponding to conversion result,
    /// when conversion format is determined by the CTRL register.
    /// Does not perform any offset or gain correction.
    ///
    /// @pre CTRL::U_BN and CTRL::FORMAT = 0 select offset binary, 2's complement, or straight binary
    /// @pre g_MAX11410_device.VRef = Voltage of REF input, in Volts
    /// @param[in] value_u24: raw 24-bit MAX11410 code (right justified).
    /// @return physical voltage corresponding to MAX11410 code.
    double VoltageOfCode(uint32_t value_u24);

// CODE GENERATOR: looks like this is a register access function because 'regAdd'
// CODE GENERATOR: looks like this is a 'write' register access function
    //----------------------------------------
    /// Write a MAX11410 register.
    ///
    /// CMDOP_1aaa_aaaa_ReadRegister bit is cleared 0 indicating a write operation.
    ///
    /// MAX11410 register length can be determined by function RegSize.
    ///
    /// For 8-bit register size:
    ///
    ///     SPI 16-bit transfer
    ///
    ///     SPI MOSI = 0aaa_aaaa_dddd_dddd
    ///
    ///     SPI MISO = xxxx_xxxx_xxxx_xxxx
    ///
    /// For 16-bit register size:
    ///
    ///     SPI 24-bit or 32-bit transfer
    ///
    ///     SPI MOSI = 0aaa_aaaa_dddd_dddd_dddd_dddd
    ///
    ///     SPI MISO = xxxx_xxxx_xxxx_xxxx_xxxx_xxxx
    ///
    /// For 24-bit register size:
    ///
    ///     SPI 32-bit transfer
    ///
    ///     SPI MOSI = 0aaa_aaaa_dddd_dddd_dddd_dddd_dddd_dddd
    ///
    ///     SPI MISO = xxxx_xxxx_xxxx_xxxx_xxxx_xxxx_xxxx_xxxx
    ///
    /// @return 1 on success; 0 on failure
    uint8_t RegWrite(MAX11410_CMD_enum_t commandByte, uint32_t regData);

// CODE GENERATOR: looks like this is a register access function because 'regAdd'
// CODE GENERATOR: looks like this is a 'read' register access function
    //----------------------------------------
    /// Read an 8-bit MAX11410 register
    ///
    /// CMDOP_1aaa_aaaa_ReadRegister bit is set 1 indicating a read operation.
    ///
    /// MAX11410 register length can be determined by function RegSize.
    ///
    /// For 8-bit register size:
    ///
    ///     SPI 16-bit transfer
    ///
    ///     SPI MOSI = 1aaa_aaaa_0000_0000
    ///
    ///     SPI MISO = xxxx_xxxx_dddd_dddd
    ///
    /// For 16-bit register size:
    ///
    ///     SPI 24-bit or 32-bit transfer
    ///
    ///     SPI MOSI = 1aaa_aaaa_0000_0000_0000_0000
    ///
    ///     SPI MISO = xxxx_xxxx_dddd_dddd_dddd_dddd
    ///
    /// For 24-bit register size:
    ///
    ///     SPI 32-bit transfer
    ///
    ///     SPI MOSI = 1aaa_aaaa_0000_0000_0000_0000_0000_0000
    ///
    ///     SPI MISO = xxxx_xxxx_dddd_dddd_dddd_dddd_dddd_dddd
    ///
    ///
    /// @return 1 on success; 0 on failure
    uint8_t RegRead(MAX11410_CMD_enum_t commandByte, uint32_t* ptrRegData);

// CODE GENERATOR: looks like this is a register access function because 'regAdd'
// CODE GENERATOR: looks like this is a 'size' register access function
    //----------------------------------------
    /// Return the size of a MAX11410 register
    ///
    /// @return 8 for 8-bit, 16 for 16-bit, 24 for 24-bit, else 0 for undefined register size
    uint8_t RegSize(MAX11410_CMD_enum_t commandByte);

// CODE GENERATOR: looks like this is a register access function because 'regAdd'
    //----------------------------------------
    /// Decode operation from commandByte
    ///
    /// @return operation such as idle, read register, write register, etc.
    MAX11410::MAX11410_CMDOP_enum_t DecodeCommand(MAX11410_CMD_enum_t commandByte);

// CODE GENERATOR: looks like this is a register access function because 'regAdd'
    //----------------------------------------
    /// Return the address field of a MAX11410 register
    ///
    /// @return register address field as given in datasheet
    uint8_t RegAddrOfCommand(MAX11410_CMD_enum_t commandByte);

// CODE GENERATOR: looks like this is a register access function because 'regAdd'
// CODE GENERATOR: looks like this is a 'read' register access function
    //----------------------------------------
    /// Test whether a command byte is a register read command
    ///
    /// @return true if command byte is a register read command
    uint8_t IsRegReadCommand(MAX11410_CMD_enum_t commandByte);

// CODE GENERATOR: looks like this is a register access function because 'regAdd'
// CODE GENERATOR: looks like this is a 'write' register access function
    //----------------------------------------
    /// Test whether a command byte is a register write command
    ///
    /// @return true if command byte is a register write command
    uint8_t IsRegWriteCommand(MAX11410_CMD_enum_t commandByte);

// CODE GENERATOR: looks like this is a register access function because 'regAdd'
// CODE GENERATOR: looks like this is a 'name' register access function
    //----------------------------------------
    /// Return the name of a MAX11410 register
    ///
    /// @return null-terminated constant C string containing register name or empty string
    const char* RegName(MAX11410_CMD_enum_t commandByte);

    //----------------------------------------
    /// Menu item 'XF'
    ///
    /// FILTER Select Filter and Rate.
    /// Sets conversion rate based on RATE, LINEF, and CONV_TYPE value. See Table 9a through Table 9d for details.
    /// For CONV_TYPE_01_Continuous, linef=LINEF_11_SINC4, rate=RATE_0100 selects output data rate 60SPS.
    ///
    /// @param[in] linef = filter type, default=MAX11410::MAX11410_LINEF_enum_t::LINEF_11_SINC4
    /// @param[in] rate = output data rate selection, default=MAX11410::MAX11410_RATE_enum_t::RATE_0100
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Configure_FILTER(uint8_t linef, uint8_t rate);

    //----------------------------------------
    /// Menu item 'XP'
    ///
    /// PGA Select Gain and Signal Path.
    ///
    /// @param[in] sigpath = signal path, default=MAX11410::MAX11410_SIG_PATH_enum_t::SIG_PATH_00_BUFFERED
    /// @param[in] gain = gain selection, default=MAX11410::MAX11410_GAIN_enum_t::GAIN_000_1
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Configure_PGA(uint8_t sigpath, uint8_t gain);

    //----------------------------------------
    /// Menu item 'XC'
    ///
    /// CTRL Select clock, format, and reference.
    ///
    /// @param[in] extclk = external clock enable, default=0
    /// @param[in] u_bn = unipolar input range enable, default=0
    /// @param[in] format = offset binary format enable, default=0
    /// @param[in] refbufp_en = REFP reference buffer enable, default=0
    /// @param[in] refbufn_en = REFN reference buffer enable, default=0
    /// @param[in] ref_sel = reference selection, default=MAX11410::MAX11410_REF_SEL_enum_t::REF_SEL_001_REF1P_REF1N
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Configure_CTRL(uint8_t extclk, uint8_t u_bn, uint8_t format, uint8_t refbufp_en, uint8_t refbufn_en, uint8_t ref_sel);

    //----------------------------------------
    /// Menu item 'XR'
    ///
    /// CTRL select reference, without changing the other fields.
    ///
    /// @pre ctrl = shadow of CTRL register
    /// @param[in] ref_sel = reference selection, default=MAX11410::MAX11410_REF_SEL_enum_t::REF_SEL_001_REF1P_REF1N
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Configure_CTRL_REF(uint8_t ref_sel);

    //----------------------------------------
    /// Menu item 'XS'
    ///
    /// SOURCE Configure voltage bias source, current source, burnout mode
    ///
    /// @param[in] vbias_mode = bias voltage mode, default=MAX11410::MAX11410_VBIAS_MODE_enum_t::VBIAS_MODE_00_Active
    /// @param[in] brn_mode = burnout source mode, default=MAX11410::MAX11410_BRN_MODE_enum_t::BRN_MODE_00_disabled
    /// @param[in] idac_mode = current source value, default=MAX11410::MAX11410_IDAC_MODE_enum_t::IDAC_MODE_0000_10uA
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Configure_SOURCE(uint8_t vbias_mode, uint8_t brn_mode, uint8_t idac_mode);

    //----------------------------------------
    /// Menu item 'XM'
    ///
    /// MUX_CTRL0 Select pins for analog input AINP and AINN
    ///
    /// @param[in] ainp = channel high side, default=MAX11410::MAX11410_AINP_SEL_enum_t::AINP_SEL_0000_AIN0
    /// @param[in] ainn = channel low side, default=MAX11410::MAX11410_AINN_SEL_enum_t::AINN_SEL_1010_GND
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Configure_MUX_CTRL0(uint8_t ainp, uint8_t ainn);

    //----------------------------------------
    /// Menu item 'XI'
    ///
    /// MUX_CTRL1 Select pins for current source
    ///
    /// @param[in] idac1_sel = channel high side, default=MAX11410::MAX11410_IDAC1_SEL_enum_t::IDAC1_SEL_1111_unconnected
    /// @param[in] idac0_sel = channel low side, default=MAX11410::MAX11410_IDAC0_SEL_enum_t::IDAC0_SEL_1111_unconnected
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Configure_MUX_CTRL1(uint8_t idac1_sel, uint8_t idac0_sel);

    //----------------------------------------
    /// Menu item 'XV'
    ///
    /// MUX_CTRL2 Select pins for voltage bias source
    ///
    /// @param[in] vbias_ain7_ain0_bitmap = bit map of AIN7..AIN0 enables for voltage bias, default=0
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Configure_MUX_CTRL2(uint8_t vbias_ain7_ain0_bitmap);

    //----------------------------------------
    /// Menu item 'X0'
    ///
    /// CAL_START Calibrate Self Offset and Gain.
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Calibrate_Self_Offset_Gain(void);

    //----------------------------------------
    /// Menu item 'X1'
    ///
    /// CAL_START Calibrate Selected PGA.
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Calibrate_PGA_Gain(void);

    //----------------------------------------
    /// CAL_START Calibrate System Offset A.
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Calibrate_System_Offset_A(void);

    //----------------------------------------
    /// CAL_START Calibrate System Gain A.
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Calibrate_System_Gain_A(void);

    //----------------------------------------
    /// CAL_START Calibrate System Offset B.
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Calibrate_System_Offset_B(void);

    //----------------------------------------
    /// CAL_START Calibrate System Gain B.
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Calibrate_System_Gain_B(void);

    //----------------------------------------
    /// Menu item '$' -> AINcode[0], AINcode[1], AINcode[2], AINcode[3], AINcode[4], AINcode[5], AINcode[6], AINcode[7], AINcode[8], AINcode[9], AINcode[10]
    ///
    /// Measure all ADC channels in sequence.
    /// Diagnostic output pulse on GP0 for each channel's measurement.
    /// Diagnostic output pulse on GP1 for entire loop.
    ///
    /// @post AINcode[0..10]: measurement result LSB code
    ///
    /// @return 1 on success; 0 on failure
    uint8_t Read_All_Voltages(void);

    //----------------------------------------
    /// Menu item 'V'
    /// Trigger Measurement for voltage input.
    ///
    /// Example code for typical voltage measurement.
    ///
    /// @pre external connection REF2P-REF2N is a reference voltage
    /// @pre VRef = Voltage of REF input, in Volts
    /// @pre v_filter = filter register configuration, 0x34 for LINEF_11_SINC4 RATE_0100 output data rate 60SPS
    /// @pre v_ctrl = ctrl register configuration, 0x02 for bipolar REF_SEL_010_REF2P_REF2N
    /// @pre v_pga = pga register configuration, 0x00 for SIG_PATH_00_BUFFERED GAIN_000_1
    /// @param[in] ainp = channel high side, default=AINP_SEL_0000_AIN0
    /// @param[in] ainn = channel low side, default=AINN_SEL_1010_GND
    /// @post AINcode[ainp]: measurement result LSB code
    ///
    /// Output data rate (sample rate) is determined by filter register.
    /// filter register configuration in Measure_Voltage CONV_TYPE_01_Continuous
    /// v_filter=0x00 -- LINEF_00_50Hz_60Hz_FIR  RATE_0000 |  1.1SPS
    /// v_filter=0x01 -- LINEF_00_50Hz_60Hz_FIR  RATE_0001 |  2.1SPS
    /// v_filter=0x02 -- LINEF_00_50Hz_60Hz_FIR  RATE_0010 |  4.2SPS
    /// v_filter=0x03 -- LINEF_00_50Hz_60Hz_FIR  RATE_0011 |  8.4SPS
    /// v_filter=0x04 -- LINEF_00_50Hz_60Hz_FIR  RATE_0100 | 16.8SPS
    /// v_filter=0x10 -- LINEF_01_50Hz_FIR       RATE_0000 |  1.3SPS
    /// v_filter=0x11 -- LINEF_01_50Hz_FIR       RATE_0001 |  2.7SPS
    /// v_filter=0x12 -- LINEF_01_50Hz_FIR       RATE_0010 |  5.3SPS
    /// v_filter=0x13 -- LINEF_01_50Hz_FIR       RATE_0011 | 10.7SPS
    /// v_filter=0x14 -- LINEF_01_50Hz_FIR       RATE_0100 | 21.3SPS
    /// v_filter=0x15 -- LINEF_01_50Hz_FIR       RATE_0101 | 40.0SPS
    /// v_filter=0x20 -- LINEF_10_60Hz_FIR       RATE_0000 |   1.3SPS
    /// v_filter=0x21 -- LINEF_10_60Hz_FIR       RATE_0001 |   2.7SPS
    /// v_filter=0x22 -- LINEF_10_60Hz_FIR       RATE_0010 |   5.3SPS
    /// v_filter=0x23 -- LINEF_10_60Hz_FIR       RATE_0011 |  10.7SPS
    /// v_filter=0x24 -- LINEF_10_60Hz_FIR       RATE_0100 |  21.3SPS
    /// v_filter=0x25 -- LINEF_10_60Hz_FIR       RATE_0101 |  40.0SPS
    /// v_filter=0x30 -- LINEF_11_SINC4          RATE_0000 |    4SPS
    /// v_filter=0x31 -- LINEF_11_SINC4          RATE_0001 |   10SPS
    /// v_filter=0x32 -- LINEF_11_SINC4          RATE_0010 |   20SPS
    /// v_filter=0x33 -- LINEF_11_SINC4          RATE_0011 |   40SPS
    /// v_filter=0x34 --*LINEF_11_SINC4          RATE_0100 |   60SPS
    /// v_filter=0x35 -- LINEF_11_SINC4          RATE_0101 |  120SPS
    /// v_filter=0x36 -- LINEF_11_SINC4          RATE_0110 |  240SPS
    /// v_filter=0x37 -- LINEF_11_SINC4          RATE_0111 |  480SPS
    /// v_filter=0x38 -- LINEF_11_SINC4          RATE_1000 |  960SPS
    /// v_filter=0x39 -- LINEF_11_SINC4          RATE_1001 | 1920SPS
    ///
    /// @return ideal voltage calculated from raw LSB code and reference voltage
    double Measure_Voltage(MAX11410_AINP_SEL_enum_t ainp, MAX11410_AINN_SEL_enum_t ainn);

    //----------------------------------------
    /// Menu item 'R' -> rtd_ohm, rtd_degc
    /// Trigger Measurement for Resistive Temperature Device (RTD).
    ///
    /// Example code for typical RTD measurement.
    ///
    /// @pre external connection REF1P-REF1N is a reference resistor
    /// @pre ref1_v = reference resistance in ohms, default=4999
    /// @pre rtd_filter = filter register configuration, 0x34 for LINEF_11_SINC4 RATE_0100 output data rate 60SPS
    /// @pre rtd_ctrl = ctrl register configuration, 0x40 for ref0_v, 0x41 for ref1_v, 0x42 for ref2_v
    /// @pre rtd_souce = souce register configuration, 0x0B for IDAC_MODE_1011_400uA
    /// @pre rtd_pga = pga register configuration, 0x21 for SIG_PATH_10_PGA GAIN_001_2
    /// @param[in] rtd_iout = channel RTD high side force, default=AINP_SEL_0111_AIN7
    /// @param[in] rtd_ainp = channel RTD high side sense, default=AINP_SEL_1000_AIN8
    /// @param[in] rtd_ainn = channel RTD low side, default=AINN_SEL_1001_AIN9
    /// @post AINcode[rtd_ainp]: measurement result LSB code
    /// @post rtd_ohm: measurement result resistance in Ohms
    /// @post rtd_degc: Temperature calculated from RTD Resistance; Thermocouple Cold Junction, in degrees C
    ///
    /// Output data rate (sample rate) is determined by filter register.
    /// filter register configuration in Measure_RTD CONV_TYPE_01_Continuous
    /// rtd_filter=0x00 -- LINEF_00_50Hz_60Hz_FIR  RATE_0000 |  1.1SPS
    /// rtd_filter=0x01 -- LINEF_00_50Hz_60Hz_FIR  RATE_0001 |  2.1SPS
    /// rtd_filter=0x02 -- LINEF_00_50Hz_60Hz_FIR  RATE_0010 |  4.2SPS
    /// rtd_filter=0x03 -- LINEF_00_50Hz_60Hz_FIR  RATE_0011 |  8.4SPS
    /// rtd_filter=0x04 -- LINEF_00_50Hz_60Hz_FIR  RATE_0100 | 16.8SPS
    /// rtd_filter=0x10 -- LINEF_01_50Hz_FIR       RATE_0000 |  1.3SPS
    /// rtd_filter=0x11 -- LINEF_01_50Hz_FIR       RATE_0001 |  2.7SPS
    /// rtd_filter=0x12 -- LINEF_01_50Hz_FIR       RATE_0010 |  5.3SPS
    /// rtd_filter=0x13 -- LINEF_01_50Hz_FIR       RATE_0011 | 10.7SPS
    /// rtd_filter=0x14 -- LINEF_01_50Hz_FIR       RATE_0100 | 21.3SPS
    /// rtd_filter=0x15 -- LINEF_01_50Hz_FIR       RATE_0101 | 40.0SPS
    /// rtd_filter=0x20 -- LINEF_10_60Hz_FIR       RATE_0000 |   1.3SPS
    /// rtd_filter=0x21 -- LINEF_10_60Hz_FIR       RATE_0001 |   2.7SPS
    /// rtd_filter=0x22 -- LINEF_10_60Hz_FIR       RATE_0010 |   5.3SPS
    /// rtd_filter=0x23 -- LINEF_10_60Hz_FIR       RATE_0011 |  10.7SPS
    /// rtd_filter=0x24 -- LINEF_10_60Hz_FIR       RATE_0100 |  21.3SPS
    /// rtd_filter=0x25 -- LINEF_10_60Hz_FIR       RATE_0101 |  40.0SPS
    /// rtd_filter=0x30 -- LINEF_11_SINC4          RATE_0000 |    4SPS
    /// rtd_filter=0x31 -- LINEF_11_SINC4          RATE_0001 |   10SPS
    /// rtd_filter=0x32 -- LINEF_11_SINC4          RATE_0010 |   20SPS
    /// rtd_filter=0x33 -- LINEF_11_SINC4          RATE_0011 |   40SPS
    /// rtd_filter=0x34 --*LINEF_11_SINC4          RATE_0100 |   60SPS
    /// rtd_filter=0x35 -- LINEF_11_SINC4          RATE_0101 |  120SPS
    /// rtd_filter=0x36 -- LINEF_11_SINC4          RATE_0110 |  240SPS
    /// rtd_filter=0x37 -- LINEF_11_SINC4          RATE_0111 |  480SPS
    /// rtd_filter=0x38 -- LINEF_11_SINC4          RATE_1000 |  960SPS
    /// rtd_filter=0x39 -- LINEF_11_SINC4          RATE_1001 | 1920SPS
    ///
    /// @return resistance calculated from raw LSB code and reference resistance
    double Measure_RTD(MAX11410_AINP_SEL_enum_t rtd_iout, MAX11410_AINP_SEL_enum_t rtd_ainp, MAX11410_AINN_SEL_enum_t rtd_ainn);

    //----------------------------------------
    /// Return the physical temperature corresponding to measured resistance
    /// of a PT1000 type Resistive Temperature Device (RTD).
    ///
    /// @param[in] rtd_ohm = RTD resistance in ohms, default=1000
    /// @post rtd_degc: Temperature calculated from RTD Resistance; Thermocouple Cold Junction, in degrees C
    ///
    /// @return ideal temperature in degrees C, calculated from RTD resistance in ohms
    /// @test group RTD_PT1000 // PT1000 type Resistive Temperature Device (RTD)
    /// @test group RTD_PT1000 tinyTester.blink_time_msec = 20 // quickly speed through the software verification
    /// @test group RTD_PT1000 TemperatureOfRTD_PT1000(842.94) expect -40.0 within 0.1 // PT-1000 RTD at -40C
    /// @test group RTD_PT1000 TemperatureOfRTD_PT1000(1000.0) expect 0.0   within 0.1 // PT-1000 RTD at 0C
    /// @test group RTD_PT1000 TemperatureOfRTD_PT1000(1097.3) expect 25.0  within 0.1 // PT-1000 RTD at 25C
    /// @test group RTD_PT1000 TemperatureOfRTD_PT1000(1328.1) expect 85.0  within 0.1 // PT-1000 RTD at 85C
    /// @test group RTD_PT1000 TemperatureOfRTD_PT1000(1479.5) expect 125.0 within 0.1 // PT-1000 RTD at 125C
    /// @test group RTD_PT1000 tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
    ///
    double TemperatureOfRTD_PT1000(double rtd_ohm);

    //----------------------------------------
    /// Return the physical temperature corresponding to measured resistance
    /// of a PT100 type Resistive Temperature Device (RTD).
    ///
    /// @param[in] rtd_ohm = RTD resistance in ohms, default=100
    /// @post rtd_degc: Temperature calculated from RTD Resistance; Thermocouple Cold Junction, in degrees C
    ///
    /// @return ideal temperature in degrees C, calculated from RTD resistance in ohms
    /// @test group RTD_PT100 // PT100 type Resistive Temperature Device (RTD)
    /// @test group RTD_PT100 tinyTester.blink_time_msec = 20 // quickly speed through the software verification
    /// @test group RTD_PT100 TemperatureOfRTD_PT100(84.294) expect -40.0 within 0.1 // PT-100 RTD at -40C
    /// @test group RTD_PT100 TemperatureOfRTD_PT100(100.00) expect 0.0   within 0.1 // PT-100 RTD at 0C
    /// @test group RTD_PT100 TemperatureOfRTD_PT100(109.73) expect 25.0  within 0.1 // PT-100 RTD at 25C
    /// @test group RTD_PT100 TemperatureOfRTD_PT100(132.81) expect 85.0  within 0.1 // PT-100 RTD at 85C
    /// @test group RTD_PT100 TemperatureOfRTD_PT100(147.95) expect 125.0 within 0.1 // PT-100 RTD at 125C
    /// @test group RTD_PT100 tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
    ///
    double TemperatureOfRTD_PT100(double rtd_ohm);

    //----------------------------------------
    /// Return the physical temperature corresponding to measured resistance
    /// of a PT100 or PT1000 type Resistive Temperature Device (RTD).
    ///
    /// @param[in] rtd_ohm = RTD resistance in ohms, default=100
    /// @post rtd_degc: Temperature calculated from RTD Resistance; Thermocouple Cold Junction, in degrees C
    ///
    /// @return ideal temperature in degrees C, calculated from RTD resistance in ohms
    /// @test group RTD // Verify function TemperatureOfRTD
    /// @test group RTD tinyTester.blink_time_msec = 20 // quickly speed through the software verification
    /// @test group RTD TemperatureOfRTD(84.294) expect -40.0 within 0.1 // PT-100 RTD at -40C
    /// @test group RTD TemperatureOfRTD(100.00) expect 0.0   within 0.1 // PT-100 RTD at 0C
    /// @test group RTD TemperatureOfRTD(109.73) expect 25.0  within 0.1 // PT-100 RTD at 25C
    /// @test group RTD TemperatureOfRTD(132.81) expect 85.0  within 0.1 // PT-100 RTD at 85C
    /// @test group RTD TemperatureOfRTD(147.95) expect 125.0 within 0.1 // PT-100 RTD at 125C
    /// @test group RTD TemperatureOfRTD(842.94) expect -40.0 within 0.1 // PT-1000 RTD at -40C
    /// @test group RTD TemperatureOfRTD(1000.0) expect 0.0   within 0.1 // PT-1000 RTD at 0C
    /// @test group RTD TemperatureOfRTD(1097.3) expect 25.0  within 0.1 // PT-1000 RTD at 25C
    /// @test group RTD TemperatureOfRTD(1328.1) expect 85.0  within 0.1 // PT-1000 RTD at 85C
    /// @test group RTD TemperatureOfRTD(1479.5) expect 125.0 within 0.1 // PT-1000 RTD at 125C
    /// @test group RTD tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
    ///
    double TemperatureOfRTD(double rtd_ohm);

    //----------------------------------------
    /// Menu item 'TM' -> tc_v, tc_delta_degc, tc_degc
    /// Trigger Measurement for Thermocouple
    ///
    /// Example code for typical Thermocouple measurement.
    /// An RTD measures the "cold junction" where TC connects to the board,
    /// and the TC measures the temperature difference above the cold junction.
    ///
    /// @param[in] tc_ainp = channel of Thermocouple high side, default=AINP_SEL_0101_AIN5
    /// @param[in] tc_ainn = channel of Thermocouple low side, default=AINN_SEL_0110_AIN6
    /// @param[in] rtd_iout = channel RTD high side force, default=AINP_SEL_0111_AIN7
    /// @param[in] rtd_ainp = channel RTD high side sense, default=AINP_SEL_1000_AIN8
    /// @param[in] rtd_ainn = channel RTD low side, default=AINN_SEL_1001_AIN9
    /// @post AINcode[tc_ainp]: measurement result LSB code
    /// @post tc_v: raw thermocouple voltage in Volts
    /// @post tc_delta_degc: temperature in degC above cold junction
    /// @post tc_degc: temperature in degC
    ///
    /// @return 1 on success; 0 on failure
    double Measure_Thermocouple(MAX11410_AINP_SEL_enum_t tc_ainp, MAX11410_AINN_SEL_enum_t tc_ainn, MAX11410_AINP_SEL_enum_t rtd_iout, MAX11410_AINP_SEL_enum_t rtd_ainp, MAX11410_AINN_SEL_enum_t rtd_ainn);

    //----------------------------------------
    /// Return the physical temperature corresponding to measured voltage
    /// of a type K Thermocouple (TC).
    ///
    /// @pre {0}.rtd_degc = cold junction temperature, in degrees C
    /// @param[in] tc_v = Thermocouple voltage in volts, default=0.0254
    ///
    /// @return ideal temperature in degrees C, calculated from RTD resistance in ohms
    /// @test group TC_1 // Verify Thermocouple function TemperatureOfTC_TypeK
    /// @test group TC_2 // Verify Thermocouple function TemperatureOfTC_TypeK in more detail
    /// @test group TC_1 tinyTester.blink_time_msec = 20 // quickly speed through the software verification
    /// @test group TC_1 TemperatureOfTC_TypeK(0.000e-3) expect  0.0    within 0.1 // TC_TypeK at   0C = 0.000mV
    /// @test group TC_1 TemperatureOfTC_TypeK(0.039e-3) expect  1.0    within 0.1 // TC_TypeK at   1C = 0.039mV
    /// @test group TC_1 TemperatureOfTC_TypeK(0.079e-3) expect  2.0    within 0.1 // TC_TypeK at   2C = 0.079mV
    /// @test group TC_1 TemperatureOfTC_TypeK(0.119e-3) expect  3.0    within 0.1 // TC_TypeK at   3C = 0.119mV
    /// @test group TC_2 TemperatureOfTC_TypeK(0.158e-3) expect  4.0     within 0.1 // TC_TypeK at   4C = 0.158mV
    /// @test group TC_2 TemperatureOfTC_TypeK(0.198e-3) expect  5.0     within 0.1 // TC_TypeK at   5C = 0.198mV
    /// @test group TC_2 TemperatureOfTC_TypeK(0.238e-3) expect  6.0     within 0.1 // TC_TypeK at   6C = 0.238mV
    /// @test group TC_2 TemperatureOfTC_TypeK(0.2775e-3) expect  7.0    within 0.1 // TC_TypeK at   7C = 0.2775mV
    /// @test group TC_2 TemperatureOfTC_TypeK(0.317e-3) expect  8.0     within 0.1 // TC_TypeK at   8C = 0.317mV
    /// @test group TC_2 TemperatureOfTC_TypeK(0.357e-3) expect  9.0     within 0.1 // TC_TypeK at   9C = 0.357mV
    /// @test group TC_1 TemperatureOfTC_TypeK(0.397e-3) expect 10.0    within 0.1 // TC_TypeK at  10C = 0.397mV
    /// @test group TC_1 TemperatureOfTC_TypeK(0.798e-3) expect 20.0    within 0.1 // TC_TypeK at  20C = 0.798mV
    /// @test group TC_1 TemperatureOfTC_TypeK(1.081e-3) expect 27.0    within 0.1 // TC_TypeK at  27C = 1.081mV
    /// @test group TC_1 TemperatureOfTC_TypeK(1.203e-3) expect 30.0    within 0.1 // TC_TypeK at  30C = 1.203mV
    /// @test group TC_1 TemperatureOfTC_TypeK(1.612e-3) expect 40.0    within 0.1 // TC_TypeK at  40C = 1.612mV
    /// @test group TC_1 TemperatureOfTC_TypeK(2.023e-3) expect 50.0    within 0.1 // TC_TypeK at  50C = 2.023mV
    /// @test group TC_1 TemperatureOfTC_TypeK(2.436e-3) expect 60.0    within 0.1 // TC_TypeK at  60C = 2.436mV
    /// @test group TC_1 TemperatureOfTC_TypeK(2.851e-3) expect 70.0    within 0.1 // TC_TypeK at  70C = 2.851mV
    /// @test group TC_1 TemperatureOfTC_TypeK(3.267e-3) expect 80.0    within 0.1 // TC_TypeK at  80C = 3.267mV
    /// @test group TC_1 TemperatureOfTC_TypeK(3.682e-3) expect 90.0    within 0.1 // TC_TypeK at  90C = 3.682mV
    /// @test group TC_1 TemperatureOfTC_TypeK(4.096e-3) expect 100.0   within 0.1 // TC_TypeK at  100C = 4.096mV
    /// @test group TC_2 TemperatureOfTC_TypeK(4.509e-3) expect 110.0    within 0.1 // TC_TypeK at  110C = 4.509mV
    /// @test group TC_2 TemperatureOfTC_TypeK(4.920e-3) expect 120.0    within 0.1 // TC_TypeK at  120C = 4.920mV
    /// @test group TC_2 TemperatureOfTC_TypeK(5.328e-3) expect 130.0    within 0.1 // TC_TypeK at  130C = 5.328mV
    /// @test group TC_2 TemperatureOfTC_TypeK(5.735e-3) expect 140.0    within 0.1 // TC_TypeK at  140C = 5.735mV
    /// @test group TC_2 TemperatureOfTC_TypeK(6.138e-3) expect 150.0    within 0.1 // TC_TypeK at  150C = 6.138mV
    /// @test group TC_2 TemperatureOfTC_TypeK(6.540e-3) expect 160.0    within 0.1 // TC_TypeK at  160C = 6.540mV
    /// @test group TC_2 TemperatureOfTC_TypeK(6.941e-3) expect 170.0    within 0.1 // TC_TypeK at  170C = 6.941mV
    /// @test group TC_2 TemperatureOfTC_TypeK(7.340e-3) expect 180.0    within 0.1 // TC_TypeK at  180C = 7.340mV
    /// @test group TC_1 TemperatureOfTC_TypeK(7.739e-3) expect 190.0   within 0.1 // TC_TypeK at  190C = 7.739mV
    /// @test group TC_1 TemperatureOfTC_TypeK(8.138e-3) expect 200.0   within 0.1 // TC_TypeK at  200C = 8.138mV
    /// @test group TC_1 TemperatureOfTC_TypeK(8.539e-3) expect 210.0   within 0.1 // TC_TypeK at  210C = 8.539mV
    /// @test group TC_1 TemperatureOfTC_TypeK(8.940e-3) expect 220.0   within 0.1 // TC_TypeK at  220C = 8.940mV
    /// @test group TC_2 TemperatureOfTC_TypeK(9.343e-3) expect 230.0    within 0.1 // TC_TypeK at  230C = 9.343mV
    /// @test group TC_2 TemperatureOfTC_TypeK(9.747e-3) expect 240.0    within 0.1 // TC_TypeK at  240C = 9.747mV
    /// @test group TC_2 TemperatureOfTC_TypeK(10.153e-3) expect 250.0   within 0.1 // TC_TypeK at  250C = 10.153mV
    /// @test group TC_2 TemperatureOfTC_TypeK(10.561e-3) expect 260.0   within 0.1 // TC_TypeK at  260C = 10.561mV
    /// @test group TC_2 TemperatureOfTC_TypeK(10.971e-3) expect 270.0   within 0.1 // TC_TypeK at  270C = 10.971mV
    /// @test group TC_2 TemperatureOfTC_TypeK(11.382e-3) expect 280.0   within 0.1 // TC_TypeK at  280C = 11.382mV
    /// @test group TC_2 TemperatureOfTC_TypeK(11.795e-3) expect 290.0   within 0.1 // TC_TypeK at  290C = 11.795mV
    /// @test group TC_1 TemperatureOfTC_TypeK(12.209e-3) expect 300.0  within 0.1 // TC_TypeK at  300C = 12.209mV
    /// @test group TC_2 TemperatureOfTC_TypeK(14.293e-3) expect 350.0   within 0.1 // TC_TypeK at  350C = 14.293mV
    /// @test group TC_1 TemperatureOfTC_TypeK(16.397e-3) expect 400.0  within 0.1 // TC_TypeK at  400C = 16.397mV
    /// @test group TC_1 TemperatureOfTC_TypeK(18.516e-3) expect 450.0  within 0.1 // TC_TypeK at  450C = 18.516mV
    /// @test group TC_1 TemperatureOfTC_TypeK(20.218e-3) expect 490.0  // TC_TypeK at  490C = 20.218mV
    /// @test group TC_1 tinyTester.blink_time_msec = 75 // default 75 resume hardware self test
    ///
    double TemperatureOfTC_TypeK(double tc_v);

    //----------------------------------------
    /// Calculate temperature in degrees C from input voltage,
    /// using a given set of polynomial coefficients.
    /// For example:
    ///
    /// t = coefficients[0] + coefficients[1] * DMMavg + coefficients[2] * DmMMavg**2
    ///
    /// @param[in] thermocouple_voltage_uV = Thermocouple voltage in microvolts
    ///
    /// @return ideal temperature in degrees C, calculated from polynomial coefficients
    ///
    double temperatureDegC_polynomial(double thermocouple_voltage_uV, int num_coefficients, double coefficients[]);

}; // end of class MAX11410

#endif // __MAX11410_H__

// End of file
