// /*******************************************************************************
// * Copyright (C) 2019 Maxim Integrated Products, Inc., All Rights Reserved.
// *
// * Permission is hereby granted, free of charge, to any person obtaining a
// * copy of this software and associated documentation files (the "Software"),
// * to deal in the Software without restriction, including without limitation
// * the rights to use, copy, modify, merge, publish, distribute, sublicense,
// * and/or sell copies of the Software, and to permit persons to whom the
// * Software is furnished to do so, subject to the following conditions:
// *
// * The above copyright notice and this permission notice shall be included
// * in all copies or substantial portions of the Software.
// *
// * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
// * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
// * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
// * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
// * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
// * OTHER DEALINGS IN THE SOFTWARE.
// *
// * Except as contained in this notice, the name of Maxim Integrated
// * Products, Inc. shall not be used except as stated in the Maxim Integrated
// * Products, Inc. Branding Policy.
// *
// * The mere transfer of this software does not imply any licenses
// * of trade secrets, proprietary technology, copyrights, patents,
// * trademarks, maskwork rights, or any other form of intellectual
// * property whatsoever. Maxim Integrated Products, Inc. retains all
// * ownership rights.
// *******************************************************************************
// */
// example code includes
// standard include for target platform -- Platform_Include_Boilerplate
#include "mbed.h"
// Platforms:
//   - MAX32625MBED
//      - supports mbed-os-5.11, requires USBDevice library
//      - add https://developer.mbed.org/teams/MaximIntegrated/code/USBDevice/
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - MAX32600MBED
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//      - Windows 10 note:  Don't connect HDK until you are ready to load new firmware into the board.
//   - NUCLEO_F446RE
//      - remove USBDevice library
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - NUCLEO_F401RE
//      - remove USBDevice library
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//   - MAX32630FTHR
//      - #include "max32630fthr.h"
//      - add http://os.mbed.org/teams/MaximIntegrated/code/max32630fthr/
//      - remove MAX32620FTHR library (if present)
//   - MAX32620FTHR
//      - #include "MAX32620FTHR.h"
//      - remove max32630fthr library (if present)
//      - add https://os.mbed.com/teams/MaximIntegrated/code/MAX32620FTHR/
//      - not tested yet
//   - MAX32625PICO
//      - remove max32630fthr library (if present)
//      - remove MAX32620FTHR library (if present)
//      - not tested yet
//
// end Platform_Include_Boilerplate
#include "MAX11131.h"

// example code board support
//MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);
//DigitalOut rLED(LED1);
//DigitalOut gLED(LED2);
//DigitalOut bLED(LED3);
//
// Arduino "shield" connector port definitions (MAX32625MBED shown)
#if defined(TARGET_MAX32625MBED)
#define A0 AIN_0
#define A1 AIN_1
#define A2 AIN_2
#define A3 AIN_3
#define D0 P0_0
#define D1 P0_1
#define D2 P0_2
#define D3 P0_3
#define D4 P0_4
#define D5 P0_5
#define D6 P0_6
#define D7 P0_7
#define D8 P1_4
#define D9 P1_5
#define D10 P1_3
#define D11 P1_1
#define D12 P1_2
#define D13 P1_0
#endif

// example code declare SPI interface
#if defined(TARGET_MAX32625MBED)
SPI spi(SPI1_MOSI, SPI1_MISO, SPI1_SCK); // mosi, miso, sclk spi1 TARGET_MAX32625MBED: P1_1 P1_2 P1_0 Arduino 10-pin header D11 D12 D13
DigitalOut spi_cs(SPI1_SS); // TARGET_MAX32625MBED: P1_3 Arduino 10-pin header D10
#elif defined(TARGET_MAX32600MBED)
SPI spi(SPI2_MOSI, SPI2_MISO, SPI2_SCK); // mosi, miso, sclk spi1 TARGET_MAX32600MBED: Arduino 10-pin header D11 D12 D13
DigitalOut spi_cs(SPI2_SS); // Generic: Arduino 10-pin header D10
#else
SPI spi(D11, D12, D13); // mosi, miso, sclk spi1 TARGET_MAX32600MBED: Arduino 10-pin header D11 D12 D13
DigitalOut spi_cs(D10); // Generic: Arduino 10-pin header D10
#endif

// example code declare GPIO interface pins
DigitalOut CNVST_pin(D9); // Digital Trigger Input to MAX11131 device
// AnalogOut REF_plus_pin(Px_x_PortName_To_Be_Determined); // Reference Input to MAX11131 device
// AnalogOut REF_minus_slash_AIN15_pin(Px_x_PortName_To_Be_Determined); // Reference Input to MAX11131 device
DigitalIn EOC_pin(D2); // Digital Event Output from MAX11131 device
// example code declare device instance
MAX11131 g_MAX11131_device(spi, spi_cs, CNVST_pin, EOC_pin, MAX11131::MAX11131_IC);

//--------------------------------------------------
// Declare the Serial driver
// default baud rate settings are 9600 8N1
// install device driver from http://developer.mbed.org/media/downloads/drivers/mbedWinSerial_16466.exe
// see docs https://docs.mbed.com/docs/mbed-os-handbook/en/5.5/getting_started/what_need/
#if defined(TARGET_MAX32630)
    #include "USBSerial.h"
// Hardware serial port over DAPLink
// The default baud rate for the DapLink UART is 9600
//Serial DAPLINKserial(P2_1, P2_0);     // tx, rx
//    #define HAS_DAPLINK_SERIAL 1
// Virtual serial port over USB
// The baud rate does not affect the virtual USBSerial UART.
USBSerial serial;
//--------------------------------------------------
#elif defined(TARGET_MAX32625MBED)
    #include "USBSerial.h"
// Hardware serial port over DAPLink
// The default baud rate for the DapLink UART is 9600
//Serial DAPLINKserial(P2_1, P2_0);     // tx, rx
//    #define HAS_DAPLINK_SERIAL 1
// Virtual serial port over USB
// The baud rate does not affect the virtual USBSerial UART.
USBSerial serial;
//--------------------------------------------------
#elif defined(TARGET_MAX32600)
    #include "USBSerial.h"
// Hardware serial port over DAPLink
// The default baud rate for the DapLink UART is 9600
Serial DAPLINKserial(P1_1, P1_0);     // tx, rx
    #define HAS_DAPLINK_SERIAL 1
// Virtual serial port over USB
// The baud rate does not affect the virtual USBSerial UART.
USBSerial serial;
//--------------------------------------------------
#elif defined(TARGET_NUCLEO_F446RE) || defined(TARGET_NUCLEO_F401RE)
Serial serial(SERIAL_TX, SERIAL_RX);     // tx, rx
//--------------------------------------------------
#else
#if defined(SERIAL_TX)
#warning "target not previously tested; guess serial pins are SERIAL_TX, SERIAL_RX..."
Serial serial(SERIAL_TX, SERIAL_RX);     // tx, rx
#elif defined(USBTX)
#warning "target not previously tested; guess serial pins are USBTX, USBRX..."
Serial serial(USBTX, USBRX);     // tx, rx
#elif defined(UART_TX)
#warning "target not previously tested; guess serial pins are UART_TX, UART_RX..."
Serial serial(UART_TX, UART_RX);     // tx, rx
#else
#warning "target not previously tested; need to define serial pins..."
#endif
#endif
//
#include "CmdLine.h"
CmdLine cmdLine(serial, "serial");

// example code main function
int main()
{
    while (1)
    {
        g_MAX11131_device.Init();

        while(1) { // this code repeats forever
            // this code repeats forever
            // Measure ADC channels in sequence from AIN0 to channelNumber_0_15.
            // @param[in] g_MAX11131_device.channelNumber_0_15: AIN Channel Number
            // @param[in] g_MAX11131_device.PowerManagement_0_2: 0=Normal, 1=AutoShutdown, 2=AutoStandby
            // @param[in] g_MAX11131_device.chan_id_0_1: ADC_MODE_CONTROL.CHAN_ID
            int channelId_0_15 = 15;
            g_MAX11131_device.channelNumber_0_15 = channelId_0_15;
            g_MAX11131_device.PowerManagement_0_2 = 0;
            g_MAX11131_device.chan_id_0_1 = 1;
            g_MAX11131_device.NumWords = g_MAX11131_device.ScanStandardExternalClock();

            // Read raw ADC codes from device into AINcode[] and RAW_misoData16[]
            // @pre one of the MAX11311_Scan functions was called, setting g_MAX11131_device.NumWords
            g_MAX11131_device.ReadAINcode();
            // @post RAW_misoData16[index] contains the raw SPI Master-In,Slave-Out data
            // @post AINcode[NUM_CHANNELS] contains the latest readings in LSBs

            // wait(3.0);
            // Use Arduino Serial Plotter to view output: Tools | Serial Plotter
            cmdLine.serial().printf("%d", g_MAX11131_device.AINcode[0]);
            for (int index = 1; index <= channelId_0_15; index++) {
                cmdLine.serial().printf(",%d", g_MAX11131_device.AINcode[index]);
            }
            cmdLine.serial().printf("\r\n");

        } // this code repeats forever
    }
}
