/*******************************************************************************
 * Copyright (C) 2018 Maxim Integrated Products, Inc., All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of Maxim Integrated
 * Products, Inc. shall not be used except as stated in the Maxim Integrated
 * Products, Inc. Branding Policy.
 *
 * The mere transfer of this software does not imply any licenses
 * of trade secrets, proprietary technology, copyrights, patents,
 * trademarks, maskwork rights, or any other form of intellectual
 * property whatsoever. Maxim Integrated Products, Inc. retains all
 * ownership rights.
 *******************************************************************************
 */
#ifndef SH_Max8614x_BareMetal_H_
#define SH_Max8614x_BareMetal_H_

#include <stdint.h>
#include <stdio.h>

#define COMM_SUCCESS        0
#define COMM_GENERAL_ERROR  -1
#define COMM_INVALID_PARAM  -254
#define COMM_NOT_RECOGNIZED -255

enum enAlgoMode{
	kAlgoModeHeartRate = 0,
	kAlgoModeSPO2
};

/**
 * @brief	Get the value of register at addr
 *
 * @param[in]	addr - adress of the register
 * @param[out]	val - value at the register

 */
void SH_Max8614x_get_reg(uint8_t addr, uint32_t *val);

/**
* @brief	Write a value to the register at address addr
*
* @param[in]	addr - adress of the register to write
* @param[in]	val - value of the register to write
*/
void SH_Max8614x_set_reg(uint8_t addr, uint32_t val);

/**
* @brief	Initialize Max86140 with default configuration
*
* @param[in] paramAlgoMode - the mode of the algorithm to initialize
*
* @return 0 on SUCCESS
*/
int SH_Max8614x_default_init(enum enAlgoMode paramAlgoMode);

/**
* @brief	Check the data stored in the Sensor Hub. Reads and prints
* 			the data if available
*
*/
int SH_Max8614x_data_report_execute(void);

/**
* @brief	Stops the active sensors and algorithms
*
*/
void SH_Max8614x_stop(void);


extern uint16_t HrmResult;
extern uint16_t SPO2Result;
extern uint8_t  HrmConfidence;
extern uint8_t  SPo2Confidence;

/* define to see debug messages*/
#define DEBUG_INFO



#endif


