/*
 * cmdInterface.cpp
 *
 *  Created on: Jan 30, 2019
 *      Author: Yagmur.Gok
 */

#include <mbed.h>
#include "cmdInterface.h"
#include "SH_Max8614x_BareMetal.h"
#include "bootldrAPI.h"
#include "SHComm.h"
#include "demoDefinitions.h"

static uint8_t hostOperatingMode = HOSTMODEAPPLICATION;


static int get_host_operating_mode(const char* arg){

	int status = 0x00;
	SERIALOUT("\r\n%s host_operating_mode=%s\r\n", "get_host_mode", (hostOperatingMode ==HOSTMODEAPPLICATION)? "APPMODE":"BOOTLOADERMODE" );
    return status;
}

static int set_host_operating_mode(const char* arg){

    int status = -1;
	uint32_t val;
	if(  sscanf(arg, "%*s %x", &val) == 1 ){
		hostOperatingMode = ( val > 0 )? HOSTMODEBOOTLOADER:HOSTMODEAPPLICATION;

		status = 0x00;
	}
	SERIALOUT("\r\n%s err=%d\r\n", "set_host_opmode", status);
    return status;

}



static int get_hub_operating_mode(const char* arg){

	uint8_t hubMode;
	int status = sh_get_sensorhub_operating_mode(&hubMode);
	if( status == 0x00)
		SERIALOUT("\r\n hub_operating_mode=%s\r\n", (hubMode == 0x00)? "APPMODE":"BOOTLOADERMODE" );
	else
		SERIALOUT("\r\n%s err=%d\r\n", "get_sensorhub_opmode", status);

    return status;
}

uint8_t get_internal_operating_mode(void){

	return hostOperatingMode;
}


cmd_interface_t setHostModeCMD = {"set_host_opmode"     , set_host_operating_mode , "sets mode of host to app or bootloader"};
cmd_interface_t getHostModeCMD = {"get_host_opmode"     , get_host_operating_mode , "gets mode of host app or bootloader"};
cmd_interface_t getHubModeCMD =  {"get_sensorhub_opmode", get_hub_operating_mode , "gets mode of host app or bootloader"};


static bool starts_with(const char* str1, const char* str2)
{
	while (*str1 && *str2) {
		if (*str1 != *str2)
			return false;
		str1++;
		str2++;
	}

	if (*str2)
		return false;

	return true;
}

//MYG DEBUG:

int parse_execute_command( const char *cmd_str)
{

	int found = 0;
    int tableIdx;
    if( starts_with(&cmd_str[0], setHostModeCMD.cmdStr)) {
    	int status = setHostModeCMD.execute(cmd_str);
        if( status != 0x00){
        	SERIALOUT("\r\n%s err=%d\r\n", "set_host_mode", COMM_INVALID_PARAM);
        	hostOperatingMode = 0;
        }
        found = 1;
    }

    if( starts_with(&cmd_str[0], getHostModeCMD.cmdStr)) {
    	int  status = getHostModeCMD.execute(cmd_str);
    	found = 1;
    }

    if( starts_with(&cmd_str[0], getHubModeCMD.cmdStr)) {
    	int  status = getHubModeCMD.execute(cmd_str);
    	found = 1;
    }

    if( hostOperatingMode == HOSTMODEAPPLICATION) {

		tableIdx = NUMCMDS8614X;
		do{
			tableIdx -= 1;
			if (starts_with(&cmd_str[0], CMDTABLE8614x[tableIdx].cmdStr)){

				CMDTABLE8614x[tableIdx].execute(cmd_str);
				/*MYG DEBUG8*/// SERIALPRINT("___SELECTED COMMAND IDX IS: %d \r\n", tableIdx);
				SERIALOUT(" \r\n"); // Here is needed due to a bug on mbed serial!
				found = 1;
			}

		}while(tableIdx && found == 0 );

    }

    if( hostOperatingMode == HOSTMODEBOOTLOADER) {


    	tableIdx = NUMCMDSBOOTLDRAPI;
		do{
			tableIdx -= 1;
			if (starts_with(&cmd_str[0], CMDTABLEBOOTLDR[tableIdx].cmdStr)){

				CMDTABLEBOOTLDR[tableIdx].execute(cmd_str);
				/*MYG DEBUG8*/// SERIALPRINT("___SELECTED COMMAND IDX IS: %d \r\n", tableIdx);
				SERIALOUT(" \r\n"); // Here is needed due to a bug on mbed serial!
				found = 1;
			}

		}while(tableIdx && found == 0 );
    }

    return found;
}


void cmdIntf_build_command(char ch)
{
	static char cmd_str[1024];
    static int cmd_idx = 0;
    int status;

	if (ch == 0x00) {
		return;
	}

	if ((ch == '\n') || (ch == '\r')) {
		if (cmd_idx < 1024)
		cmd_str[cmd_idx++] = '\0';
		status = parse_execute_command(cmd_str);

		//Clear cmd_str
		while (cmd_idx > 0)
			cmd_str[--cmd_idx] = '\0';

	} else if ((ch == 0x08 || ch == 0x7F) && cmd_idx > 0) {
		//Backspace character
		if (cmd_idx > 0)
			cmd_str[--cmd_idx] = '\0';
	} else {

		if (cmd_idx < 1024)
			cmd_str[cmd_idx++] = ch;
	}

}



