/*
 * demoUI.h
 *
 *  Created on: Nov 29, 2018
 *      Author: Yagmur.Gok
 */

#ifndef SOURCE_DEMOUI_DEMOUI_H_
#define SOURCE_DEMOUI_DEMOUI_H_

#include <events/mbed_events.h>
#include <mbed.h>

#include "screen/LS013B7DH03.h"

enum{
	DISPLAY_WHRM             = 0,
	DISPLAY_REINIT           = 1,
};

#define USE_DEMO_DISPDEV
#if defined(USE_DEMO_DISPDEV)


	void demoUI_init();
	void demoUI_display_algo_estimations(int integer , int confidence);
	void demoUI_display_set_algoMode(int algo);
	int demoUI_display_get_mode(void);
	void demoUI_display(int algoResult);
	void demoUI_display_bootldr_screen(void);


#else
	void start_demo_display(void);
	void display_algo_estimations( uint8_t mode , int integer, int fraction);
	void setup_mode_button(void);

#endif


extern volatile uint8_t algoMode;

#endif /* SOURCE_DEMOUI_DEMOUI_H_ */

