#include "mbed.h"
#include "max32630hsp.h"
#include "USBSerial.h"

MAX32630HSP icarus(MAX32630HSP::VIO_3V3);

// Hardware serial port over DAPLink
Serial daplink(USBTX, USBRX);

// Virtual serial port over USB
USBSerial microUSB; 

DigitalOut rLED(LED1);
DigitalOut gLED(LED2);
DigitalOut bLED(LED3);

// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)
int main()
{
    int c;

    daplink.printf("daplink serial port\r\n");
    microUSB.printf("micro USB serial port\r\n");
    rLED = LED_ON;
    gLED = LED_ON;
    bLED = LED_OFF;

    rLED = LED_OFF;

    while(1) {
        c = microUSB.getc();
        microUSB.putc(c);
        daplink.putc(c);
        bLED = c & 1;
    }
}

