/*******************************************************************************
 * Copyright (C) 2018-2019 Maxim Integrated Products, Inc., All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of Maxim Integrated
 * Products, Inc. shall not be used except as stated in the Maxim Integrated
 * Products, Inc. Branding Policy.
 *
 * The mere transfer of this software does not imply any licenses
 * of trade secrets, proprietary technology, copyrights, patents,
 * trademarks, maskwork rights, or any other form of intellectual
 * property whatsoever. Maxim Integrated Products, Inc. retains all
 * ownership rights.
 *******************************************************************************
 */
#include "mbed.h"
#include "max32630fthr.h"
#include "DS4424.h"

#include "USBSerial.h"

MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);

DigitalOut rLED(LED1);
DigitalOut gLED(LED2);
DigitalOut bLED(LED3);

I2C i2cBus(P3_4, P3_5);

DS4424 ds4424_dac(i2cBus, DS4424::DS4424_I2C_SLAVE_ADRS0, DS4424::DS4424_IC);

/** main() runs in its own thread in the OS */
/** (note the calls to Thread::wait below for delays) */
/**
 * @brief Sample main program for Maxim Integrated DS4424, DS4422
 * @version 1.0000.301
 *
 * @details Sample main program for DS4424, DS4422
 * The prints are sent to the terminal window (9600, 8n1).
 * The program sets the output DAC registers to various values.
 * These registers are then read back and printed out.
 * The program then blinks the blue-green LED.
 * To run the program, drag and drop the .bin file into the 
 * DAPLINK folder. After it finishes flashing, cycle the power or 
 * reset the Pegasus (MAX32630FTHR) after flashing by pressing the button on
 * the Pegasus next to the battery connector or the button
 * on the MAXREFDES100HDK.
 */
int main()
{
    int32_t in_pAmps[4] = {-193675000, -1525000, 6100000, -16012500};
    uint8_t in_raw[4];
    int32_t value[4] = {0, 0, 0, 0};
    int ret, i;
    int32_t out_pAmps[4] = {0, 0, 0, 0};
    uint32_t rfs_board[4] = {40000, 80000, 100000, 160000};
    
    DigitalOut rLED(LED1, LED_OFF);
    DigitalOut gLED(LED2, LED_OFF);
    DigitalOut bLED(LED3, LED_OFF);
    
    bLED = LED_ON;
    gLED = LED_ON;

    i2cBus.frequency(400000);
    printf("\r\n");
    
    /* write to each channel using picoAmps */
    for (i = 0; i < 4; i++) {
        ret = ds4424_dac.convert_picoAmps_to_hw_raw(&in_raw[i], in_pAmps[i], rfs_board[i]);
        printf("Set picoAmps Out %d picoAmps, hw raw = %d, rfs = %d Ohms\r\n", in_pAmps[i], in_raw[i], rfs_board[i]);
    }
    printf("\r\n");
    ret = ds4424_dac.write_hw_raw(in_raw[0], DS4424::REG_OUT0);
    ret = ds4424_dac.write_hw_raw(in_raw[1], DS4424::REG_OUT1);
    ret = ds4424_dac.write_hw_raw(in_raw[2], DS4424::REG_OUT2);
    ret = ds4424_dac.write_hw_raw(in_raw[3], DS4424::REG_OUT3);

    /* write to each channel using two's complement */
    /*
    ret = ds4424_dac.write_raw(-127, DS4424::REG_OUT0); 
    ret = ds4424_dac.write_raw(-2, DS4424::REG_OUT1); 
    ret = ds4424_dac.write_raw(10, DS4424::REG_OUT2); 
    ret = ds4424_dac.write_raw(-42, DS4424::REG_OUT3);
    */
    ret = ds4424_dac.read_hw_raw(in_raw[0], DS4424::REG_OUT0); 
    ret = ds4424_dac.read_hw_raw(in_raw[1], DS4424::REG_OUT1); 
    ret = ds4424_dac.read_hw_raw(in_raw[2], DS4424::REG_OUT2); 
    ret = ds4424_dac.read_hw_raw(in_raw[3], DS4424::REG_OUT3); 
    for (i = 0; i < 4; i++) {
        printf("Read hw raw Out %d = %d\r\n", i, in_raw[i]);
    }
    printf("\r\n");

    ret = ds4424_dac.read_raw(value[0], DS4424::REG_OUT0); 
    ret = ds4424_dac.read_raw(value[1], DS4424::REG_OUT1); 
    ret = ds4424_dac.read_raw(value[2], DS4424::REG_OUT2); 
    ret = ds4424_dac.read_raw(value[3], DS4424::REG_OUT3); 
    for (i = 0; i < 4; i++) {
        printf("Read raw two's complement Out %d = %d\r\n", i, value[i]);
    }
    printf("\r\n");

    /* Convert two's complement values to picoAmps */
    for (i = 0; i < 4; i++) {
        ret = ds4424_dac.convert_raw_to_picoAmps(&out_pAmps[i], value[i], rfs_board[i]); 
        printf("Read Out %d = %d picoAmps, rfs = %d Ohms\r\n", i, out_pAmps[i], rfs_board[i]);
    }
    printf("\r\n");
   
    while (true) {  // Blink the blue-green LED 
        bLED = !bLED;
        gLED = !gLED;
        wait(1.0);
    }
}
