/*******************************************************************************
 * Copyright (C) 2016 Maxim Integrated Products, Inc., All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of Maxim Integrated
 * Products, Inc. shall not be used except as stated in the Maxim Integrated
 * Products, Inc. Branding Policy.
 *
 * The mere transfer of this software does not imply any licenses
 * of trade secrets, proprietary technology, copyrights, patents,
 * trademarks, maskwork rights, or any other form of intellectual
 * property whatsoever. Maxim Integrated Products, Inc. retains all
 * ownership rights.
 *******************************************************************************
 */
#include "mbed.h"
#include "max32630fthr.h"
#include "DS4424.h"

#include "USBSerial.h"

MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);

DigitalOut rLED(LED1);
DigitalOut gLED(LED2);
DigitalOut bLED(LED3);
    
    
// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)
int main()
{
    int32_t value[4]={0,0,0,0};
    int ret, i;

    DigitalOut rLED(LED1, LED_OFF);
    DigitalOut gLED(LED2, LED_OFF);
    DigitalOut bLED(LED3, LED_OFF);

    
    bLED = LED_ON;
    gLED = LED_ON;

//    I2C i2cBus(P5_7, P6_0);
    I2C i2cBus(P3_4, P3_5);
    //i2cBus.frequency(400000);
    DS4424 ds4424_dac(i2cBus, DS4424::DS4424_I2C_SLAVE_ADRS0);

    ret = ds4424_dac.readRaw(value[0], DS4424::REG_OUT0); 
    ret = ds4424_dac.readRaw(value[1], DS4424::REG_OUT1); 
    ret = ds4424_dac.readRaw(value[2], DS4424::REG_OUT2); 
    ret = ds4424_dac.readRaw(value[3], DS4424::REG_OUT3); 
    for (i = 0; i < 4; i++) {
        printf("Out%d = %d\r\n", i, value[i]);
    }
    ret = ds4424_dac.writeRaw(127, DS4424::REG_OUT0); 
    ret = ds4424_dac.writeRaw(2, DS4424::REG_OUT1); 
    ret = ds4424_dac.writeRaw(-127, DS4424::REG_OUT2); 
    ret = ds4424_dac.writeRaw(-2, DS4424::REG_OUT3); 

    ret = ds4424_dac.readRaw(value[0], DS4424::REG_OUT0); 
    ret = ds4424_dac.readRaw(value[1], DS4424::REG_OUT1); 
    ret = ds4424_dac.readRaw(value[2], DS4424::REG_OUT2); 
    ret = ds4424_dac.readRaw(value[3], DS4424::REG_OUT3); 
    for (i = 0; i < 4; i++) {
        printf("Out%d = %d\r\n", i, value[i]);
    }
    
    //ret = ds4424_dac.printRawRegs(); 
    //ret = ds4424_dac.printRegs(); 
   
    while (true) {
        bLED = !bLED;
        gLED = !gLED;
        wait(1.0);
    }

}

