/**********************************************************************
* 
* Demo Ard2Pmod Library
*
* Configures mux for desired pmod type and then displays current time
* and date in endless loop after asking the user for input to configure 
* the RTC.
*
* Requires TeraTerm, or your favorite terminal emulator, configured at
* 8N1 9600bps
*
***********************************************************************
* Copyright (C) 2015 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
**********************************************************************/


#include "ard2pmod.h"

#define ESC 0x1B

void get_user_input(char* message, uint8_t min, uint8_t max, uint32_t* member);
void get_user_input(char* message, uint8_t min, uint8_t max, bool* member);

Serial term(USBTX, USBRX);

int main(void)
{
    /* 
    available PMOD types
       PMOD_TYPE_I2C_A,
       PMOD_TYPE_I2C_B,
       PMOD_TYPE_I2C_AB,
       PMOD_TYPE_1_GPIO,
       PMOD_TYPE_2_SPI,
       PMOD_TYPE_3_UART,
       PMOD_TYPE_4_UART,
       PMOD_TYPE_5_HBRIDGE,
       PMOD_TYPE_6_HBRIDGE
    */
    
    Ard2Pmod rtc(Ard2Pmod::PMOD_TYPE_1_GPIO);

    //default destructor call example
    //rtc.~Ard2Pmod();
    
    //can be used to wiggle lines for PMOD_TYPE_1_GPIO
    //BusOut pmod_A(D10, D11, D12, D13);
    //BusOut pmod_B(D4, D5, D6, D7);
    
    //DS3231 rtc variables
    //default for control and status registers, 
    //use bit masks in ds3231.h for desired operation
    ds3231_cntl_stat_t rtc_control_status = {0,0}; 
    ds3231_time_t rtc_time;
    ds3231_calendar_t rtc_calendar;
    
    time_t epoch_time;
    
    rtc.set_cntl_stat_reg(rtc_control_status);
    
    uint32_t user_input;
    
    get_user_input("\nDo you want to set the RTC time and calendar (1 for yes, 0 for no): ", 0,
                    1, &user_input);
    
    if(user_input)
    {
        //get day from user
        get_user_input("\nPlease enter day of week, 1 for Sunday (1-7): ", 1,
                        7, &rtc_calendar.day);
    
        //get day of month from user
        get_user_input("\nPlease enter day of month (1-31): ", 1, 31, 
                        &rtc_calendar.date);
    
        //get month from user
        get_user_input("\nPlease enter the month, 1 for January (1-12): ", 1, 
                        12, &rtc_calendar.month);
                        
        //get year from user
        get_user_input("\nPlease enter the year (0-99): ",0, 99, 
                        &rtc_calendar.year);
          
        //Get time mode
        get_user_input("\nWhat time mode? 1 for 12hr 0 for 24hr: ", 0, 1, 
                       &rtc_time.mode);  
        
        if(rtc_time.mode)
        {
            //Get AM/PM status
            get_user_input("\nIs it AM or PM? 0 for AM 1 for PM: ", 0, 1, 
                           &rtc_time.am_pm);  
            //Get hour from user
            get_user_input("\nPlease enter the hour (1-12): ", 1, 12, 
                           &rtc_time.hours);
        }
        else
        {
            //Get hour from user
            get_user_input("\nPlease enter the hour (0-23): ", 0, 23, 
                           &rtc_time.hours);
        }
         
        //Get minutes from user
        get_user_input("\nPlease enter the minute (0-59): ", 0, 59, 
                       &rtc_time.minutes);
        
        //Get seconds from user
        get_user_input("\nPlease enter the second (0-59): ", 0, 59, 
                       &rtc_time.seconds);
                       
        //Set the time
        rtc.set_time(rtc_time);
        
        //Set the calendar
        rtc.set_calendar(rtc_calendar);
    }
    
    char buffer[32];
    
    for(;;)
    {
        term.printf("%c[2J", ESC); //clear screen
        term.printf("%c[H", ESC); //move cursor to Home
        
        //new epoch time fx
        epoch_time = rtc.get_epoch();
        
        term.printf("\nTime as seconds since January 1, 1970 = %d\n", epoch_time);
        
        term.printf("\nTime as a basic string = %s", ctime(&epoch_time));
 
        strftime(buffer, 32, "%I:%M %p\n", localtime(&epoch_time));
        term.printf("\nTime as a custom formatted string = %s", buffer);
        
        wait(1.0);
    }//loop 
}


/**********************************************************************
* Function: get_user_input() 
* Parameters: message - user prompt
*             min - minimum value of input
*             max - maximum value of input
*             member - pointer to struct member              
* Returns: none
*
* Description: get time/date input from user
*
**********************************************************************/
void get_user_input(char* message, uint8_t min, uint8_t max, uint32_t* member)
{
    uint32_t temp;

    do
    {
        printf("\n%s", message);
        
        //for some reason mbed doesn't like a pointer to a member in scanf
        //term.scanf("%d", member); works with gcc on RPi
        scanf("%d", &temp);
        
        *member = temp;
       
        if((*(member)< min) || (*(member) > max))
        {
            printf("\nERROR-RTI");
        }
    }
    while((*(member) < min) || (*(member) > max));
}


void get_user_input(char* message, uint8_t min, uint8_t max, bool* member)
{
    uint32_t temp;

    do
    {
        printf("\n%s", message);
        scanf("%d", &temp);
        
        if(temp == 1)
        {
            *member = true;
        }
        else if(temp == 0)
        {
            *member = false;
        }
        else
        {
            printf("\nERROR-RTI");
        }
    }
    while((temp != 1) && (temp != 0));
}

    