/******************************************************************//**
* @file ard2pmod.h
*
* @author Justin Jordan
*
* @version 1.0
*
* Started: 11NOV14
*
* Updated: 
*
* @brief Header file for ard2pmod class
*
***********************************************************************
*
* @copyright 
* Copyright (C) 2015 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
**********************************************************************/


#ifndef ARD2PMOD_H
#define ARD2PMOD_H


#include "mbed.h"
#include "max14661.h"
#include "ds3231.h"


#define ARD2PMOD_SDA D14
#define ARD2PMOD_SCL D15
	
	
/******************************************************************//**
* Ard2Pmod Class
* Used for establishing PMOD type, MAX14661 16:2 mux, 
* and DS3231 RTC interface
*
* Please See MAXREFDES72# pcb schematic for constraints.
*
* PMOD_TYPE_I2C_A -
* Switches SWA9, SWA12 and SWB10, SWB11 closed.  All other switches 
* open
*
* PMOD_TYPE_I2C_B -
* Switches SWA9, SWA7 and SWB10, SWB8 closed.  All other switches 
* open
* 
* PMOD_TYPE_I2C_AB - 
* Switches SWA7, SWA9, SWA12 and SWB8, SWB10, SWB11 closed.  All other
* switches open
*
* PMOD_TYPE_1_GPIO - 
* Switches all open, mux not used
*
* PMOD_TYPE_2_SPI - 
* Switches all open, mux not used
*
* PMOD_TYPE_3_UART - 
* Switches SWA12, SWA1, SWB11, SWB2 closed.  All other switches open.
*
* PMOD_TYPE_4_UART - 
* Switches SWA13, SWA2, SWB12, SWB1 closed.  All other switches open.
*
* PMOD_TYPE_5_HBRIDGE - 
* Switches all open, mux not used
*
* PMOD_TYPE_6_HBRIDGE - 
* Switches all open, mux not used
**********************************************************************/
class Ard2Pmod : public Max14661, public Ds3231
{
    public:
        
        /**
		* pmod_type_t - enumerated PMOD types
		*/
		typedef enum
		{
			PMOD_TYPE_I2C_A,
			PMOD_TYPE_I2C_B,
			PMOD_TYPE_I2C_AB,
			PMOD_TYPE_1_GPIO,
			PMOD_TYPE_2_SPI,
			PMOD_TYPE_3_UART,
			PMOD_TYPE_4_UART,
			PMOD_TYPE_5_HBRIDGE,
			PMOD_TYPE_6_HBRIDGE
		}pmod_type_t;


    	/**************************************************************//**
	    * Default constructor for Ard2Pmod Class, all mux switches open
	    * Use with Max14661 member functions for custom mux settings
	    *
	    * On Entry:
	    *
	    * On Exit:
	    *    @return none
	    *
	    * Example:
		* @code
		* #include "ard2pmod.h"
		*
		* int main(void)
		* {  
		*     Ard2Pmod ard2pmod;
		*     
		*     //main app.
		*     for(;;)
		*     {
		*     }
		* }
		* @endcode
		******************************************************************/
		Ard2Pmod(); 
		
		
	    /**************************************************************//**
	    * Constructor for Ard2Pmod Class
	    *
	    * On Entry:
	    *     @param[in] pmod_type - desired PMOD interface
	    *
	    * On Exit:
	    *    @return none
	    *
	    * Example:
		* @code
		* #include "ard2pmod.h"
		*
		* int main(void)
		* {  
		*     Ard2Pmod ard2pmod(PMOD_TYPE_1_GPIO);
		*     
		*     //main app.
		*     for(;;)
		*     {
		*     }
		* }
		* @endcode
		******************************************************************/
		Ard2Pmod(pmod_type_t pmod_type); 

};


#endif /* ARD2PMOD_H*/