/******************************************************************//**
* @file ard2pmod.cpp
*
* @author Justin Jordan
*
* @version 1.0
*
* Started: 11NOV14
*
* Updated: 
*
* @brief Source file for ard2pmod class
*
***********************************************************************
*
* @copyright 
* Copyright (C) 2015 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
**********************************************************************/


#include "ard2pmod.h"


/**************************************************************//**
* Default constructor for Ard2Pmod Class, all mux switches open
* Use with Max14661 member functions for custom mux settings
*
* On Entry:
*
* On Exit:
*    @return none
*
* Example:
* @code
* #include "ard2pmod.h"
*
* int main(void)
* {  
*     Ard2Pmod ard2pmod;
*     
*     //main app.
*     for(;;)
*     {
*     }
* }
* @endcode
******************************************************************/
Ard2Pmod::Ard2Pmod() : 
Max14661(ARD2PMOD_SDA, ARD2PMOD_SCL, MAX14661_I2C_ADRS0), 
Ds3231(ARD2PMOD_SDA, ARD2PMOD_SCL)
{
    wrt_cmd_registers(DISABLE_BANK, DISABLE_BANK);
}


/**************************************************************//**
* Constructor for Ard2Pmod Class
*
* On Entry:
*     @param[in] pmod_type - desired PMOD interface
*
* On Exit:
*    @return none
*
* Example:
* @code
* #include "ard2pmod.h"
*
* int main(void)
* {  
*     Ard2Pmod ard2pmod(PMOD_TYPE_1_GPIO);
*     
*     //main app.
*     for(;;)
*     {
*     }
* }
* @endcode
******************************************************************/
Ard2Pmod::Ard2Pmod(pmod_type_t pmod_type) : 
Max14661(ARD2PMOD_SDA, ARD2PMOD_SCL, MAX14661_I2C_ADRS0), 
Ds3231(ARD2PMOD_SDA, ARD2PMOD_SCL)
{
    switch(pmod_type)
    {
        case PMOD_TYPE_I2C_A:
            set_switches((SW12 | SW09), (SW11 | SW10));
            break;
            
        case PMOD_TYPE_I2C_B:
            set_switches((SW09 | SW07), (SW10 | SW08));
            break;
            
        case PMOD_TYPE_I2C_AB:
            set_switches((SW12 | SW09 | SW07), (SW11 | SW10 | SW08));
            break;
            
        case PMOD_TYPE_1_GPIO:
            wrt_cmd_registers(DISABLE_BANK, DISABLE_BANK);
            break;
            
        case PMOD_TYPE_2_SPI:
            wrt_cmd_registers(DISABLE_BANK, DISABLE_BANK);
            break;
            
        case PMOD_TYPE_3_UART:
            set_switches((SW12 | SW01), (SW11 | SW02));
            break;
            
        case PMOD_TYPE_4_UART:
            set_switches((SW13 | SW02), (SW12 | SW01));
            break;
            
        case PMOD_TYPE_5_HBRIDGE:
            wrt_cmd_registers(DISABLE_BANK, DISABLE_BANK);
            break;
            
        case PMOD_TYPE_6_HBRIDGE:
            wrt_cmd_registers(DISABLE_BANK, DISABLE_BANK);
            break;
            
        default:
            wrt_cmd_registers(DISABLE_BANK, DISABLE_BANK);
    }
    
}


