/***********************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
**********************************************************************/
#include "maxrefdes99.h"


int main(void)
{
    Max7219 display(D11, D12, D13, D10);
    
    //struct for holding MAX7219 configuration data
    max7219_configuration_t display_config;
        
    //configuration data
    display_config.decode_mode = 0; //no BCD decode
    display_config.intensity  = Max7219::MAX7219_INTENSITY_F;   //max intensity
    display_config.scan_limit = Max7219::MAX7219_SCAN_8;        //scan all digits
    
    //set number of MAX7219 devices being used
    display.set_num_devices(4);
    
    //config display 
    display.init_display(display_config);
    
    //ensure all data registers are 0
    display.display_all_off();
    
    display.enable_display();
    
    uint32_t user_input = 0,user_font = 0;
    uint32_t shift_right;
    char user_char;
    char *p_str;
    
    while(user_input != 9)
    {
        user_input = print_menu();
 
        switch(user_input) 
        {
            case 1:
                    printf("\n 0: For 5x7 font");
                    printf("\n 1: For 16x16 Aerial bold font");
                    printf("\n 2: For 16x16 Manual font");
                    user_font = get_user_input("\nPlease select font: ", 2);
                    if((user_font == 1) || (user_font == 2))
                        printf("\nNote:Position option works only for 5x7 font\n");
                    break;
            case 2:
                    user_input = get_user_input("\nPlease enter a value from 0 to 15: ", 15);  
                    printf("\nUpdating display configuration...\n");
                    display_config.intensity = user_input;
                    display.init_display(display_config);
                    //make sure is good for next loop
                    user_input = 0;
                    break;
             case 3:
                    if(user_font == 0)
                        user_input = get_user_input("\nPlease enter which position, 1 to 32: ", 32);
                    user_char = get_user_char("\nPlease enter an ASCII character from  '0' (zero) to 'z' (0x7A): ");
                    if(user_font == 0) 
                        print_char(&display, user_input, user_char);
                    else if(user_font >= 1)
                        print_char_16x16(&display, 0, user_char, user_font);
                    //make sure is good for next loop
                    user_input = 0;
                    break;
            case 4: 
                    if(user_font == 0)
                        user_input = get_user_input("\nPlease enter which position  1 to 32: ", 32);
                    p_str = get_user_string("\nPlease enter a string less than 24 characters: ");
                    if(user_font == 0)
                        print_string(&display, user_input, p_str);
                    else if(user_font >=1)
                        print_string_16x16(&display, p_str, user_font);
                    //make sure is good for next loop
                    user_input = 0;
                    break;
            case 5:
                    if(user_font == 0)
                        user_input = get_user_input("\nPlease enter number of shifts, 1 to 32: ", 32);
                    else if(user_font >= 1)
                        user_input = get_user_input("\nPlease enter number of shifts, 1 to 96: ", 96);
                    shift_right = get_user_input("\nWhich direction? 0 for left, 1 for right: ", 1);
                    if(shift_right)
                    {
                        printf("\nShifting Display Right %d positions\n", user_input);
                        if(user_font == 0)
                            shift_display_right(&display, user_input, 100);
                        else if(user_font >= 1)
                            shift_display_right_16x16(&display, user_input, 100);
                    }
                    else
                    {
                        printf("\nShifting Display Left %d positions\n", user_input);
                        if(user_font == 0)
                            shift_display_left(&display, user_input, 100);
                        else if(user_font >= 1)
                            shift_display_left_16x16(&display, user_input, 100);
                    }
                    break;
             case 6:
                    all_off(&display);
                    break;
             case 7:
                    printf("\nRunning Demo\n");
                    if(user_font==0)
                        demo(&display, display_config, false);
                    else if(user_font >= 1)
                        demo_16x16(&display, display_config, user_font, false);
                    break;
            case 8:
                    //blocking case, endless loop
                    shift_right = get_user_input("\nWhich direction? 0 for left, 1 for right: ", 1);
                    if(user_font == 0)
                        endless_scroll_display(&display, shift_right);
                    else if(user_font >= 1)
                        endless_scroll_display_16x16(&display, shift_right);
                    break;
            case 9:
                    printf("\nEnding Program\n");
                    break;
            default:
                    printf("\nInvalid entry, please try again\n");
                    break;
        }
    }
    return 0;
}

