/******************************************************************//**
* @file maxrefdes99.cpp
* Copyright (C) 2016 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
**********************************************************************/


#include "maxrefdes99.h"


//5x7 character bit map
static const uint8_t font_5x7[95][6] = {
    {0x00, 0x00, 0x00, 0x00, 0x00, 0x00}, //SPACE
    {0x00, 0x00, 0x00, 0xf2, 0x00, 0x00}, //!
    {0x00, 0x00, 0xe0, 0x00, 0xe0, 0x00}, //"
    {0x00, 0x28, 0xfe, 0x28, 0xfe, 0x28}, //#
    {0x00, 0x24, 0x54, 0xfe, 0x54, 0x48}, //$
    {0x00, 0xc4, 0xc8, 0x10, 0x26, 0x46}, //%
    {0x00, 0x6c, 0x92, 0xaa, 0x44, 0x0a}, //&
    {0x00, 0x00, 0xa0, 0xc0, 0x00, 0x00}, //'
    {0x00, 0x00, 0x38, 0x44, 0x82, 0x00}, //(
    {0x00, 0x00, 0x82, 0x44, 0x38, 0x00}, //)
    {0x00, 0x28, 0x10, 0x7c, 0x10, 0x28}, //*
    {0x00, 0x10, 0x10, 0x7c, 0x10, 0x10}, //+
    {0x00, 0x00, 0x0a, 0x0c, 0x00, 0x00}, //,
    {0x00, 0x10, 0x10, 0x10, 0x10, 0x10}, //-
    {0x00, 0x00, 0x06, 0x06, 0x00, 0x00}, //.
    {0x00, 0x04, 0x08, 0x10, 0x20, 0x40}, ///
    {0x00, 0x7c, 0x8a, 0x92, 0xa2, 0x7c}, //0
    {0x00, 0x00, 0x42, 0xfe, 0x02, 0x00}, //1
    {0x00, 0x42, 0x86, 0x8a, 0x92, 0x62}, //2
    {0x00, 0x84, 0x82, 0xa2, 0xd2, 0x8c}, //3
    {0x00, 0x18, 0x28, 0x48, 0xfe, 0x08}, //4
    {0x00, 0xe4, 0xa2, 0xa2, 0xa2, 0x9c}, //5
    {0x00, 0x3c, 0x52, 0x92, 0x92, 0x0c}, //6
    {0x00, 0x80, 0x8e, 0x90, 0xa0, 0xc0}, //7
    {0x00, 0x6c, 0x92, 0x92, 0x92, 0x6c}, //8
    {0x00, 0x60, 0x92, 0x92, 0x94, 0x78}, //9
    {0x00, 0x6c, 0x6c, 0x00, 0x00, 0x00}, //:
    {0x00, 0x6a, 0x6c, 0x00, 0x00, 0x00}, //;
    {0x00, 0x10, 0x28, 0x44, 0x82, 0x00}, //<
    {0x00, 0x28, 0x28, 0x28, 0x28, 0x28}, //=
    {0x00, 0x00, 0x82, 0x44, 0x28, 0x10}, //>
    {0x00, 0x40, 0x80, 0x8a, 0x90, 0x60}, //?
    {0x00, 0x0c, 0x92, 0x9e, 0x82, 0x7c}, //@
    {0x00, 0x7e, 0x88, 0x88, 0x88, 0x7e}, //A
    {0x00, 0xfe, 0x92, 0x92, 0x92, 0x6c}, //B
    {0x00, 0x7c, 0x82, 0x82, 0x82, 0x44}, //C
    {0x00, 0xfe, 0x82, 0x82, 0x44, 0x38}, //D
    {0x00, 0xfe, 0x92, 0x92, 0x92, 0x82}, //E
    {0x00, 0xfe, 0x90, 0x90, 0x90, 0x80}, //F
    {0x00, 0x7c, 0x82, 0x92, 0x92, 0x5e}, //G
    {0x00, 0xfe, 0x10, 0x10, 0x10, 0xfe}, //H
    {0x00, 0x00, 0x82, 0xfe, 0x82, 0x00}, //I
    {0x00, 0x04, 0x02, 0x82, 0xfc, 0x80}, //J
    {0x00, 0xfe, 0x10, 0x28, 0x44, 0x82}, //K
    {0x00, 0xfe, 0x02, 0x02, 0x02, 0x02}, //L
    {0x00, 0xfe, 0x40, 0x30, 0x40, 0xfe}, //M
    {0x00, 0xfe, 0x20, 0x10, 0x08, 0xfe}, //N
    {0x00, 0x7c, 0x82, 0x82, 0x82, 0x7c}, //O
    {0x00, 0xfe, 0x90, 0x90, 0x90, 0x60}, //P
    {0x00, 0x7c, 0x82, 0x8a, 0x84, 0x7a}, //Q
    {0x00, 0xfe, 0x90, 0x98, 0x94, 0x62}, //R
    {0x00, 0x62, 0x92, 0x92, 0x92, 0x8c}, //S
    {0x00, 0x80, 0x80, 0xfe, 0x80, 0x80}, //T
    {0x00, 0xfc, 0x02, 0x02, 0x02, 0xfc}, //U
    {0x00, 0xf8, 0x04, 0x02, 0x04, 0xf8}, //V
    {0x00, 0xfc, 0x02, 0x0c, 0x02, 0xfc}, //W
    {0x00, 0xc6, 0x28, 0x10, 0x28, 0xc6}, //X
    {0x00, 0xe0, 0x10, 0x0e, 0x10, 0xe0}, //Y
    {0x00, 0x86, 0x8a, 0x92, 0xa2, 0xc2}, //Z
    {0x00, 0x00, 0xfe, 0x82, 0x82, 0x00}, //[
    {0x00, 0x40, 0x20, 0x10, 0x08, 0x04}, //backslash
    {0x00, 0x00, 0x82, 0x82, 0xfe, 0x00}, //]
    {0x00, 0x20, 0x40, 0x80, 0x40, 0x20}, //^
    {0x00, 0x02, 0x02, 0x02, 0x02, 0x02}, //_
    {0x00, 0x00, 0x80, 0x40, 0x20, 0x00}, //`
    {0x00, 0x04, 0x2a, 0x2a, 0x2a, 0x1e}, //a
    {0x00, 0xfe, 0x0a, 0x12, 0x12, 0x0c}, //b
    {0x00, 0x1c, 0x22, 0x22, 0x22, 0x04}, //c
    {0x00, 0x1c, 0x22, 0x22, 0x12, 0xfe}, //d
    {0x00, 0x1c, 0x2a, 0x2a, 0x2a, 0x18}, //e
    {0x00, 0x10, 0x7e, 0x90, 0x80, 0x40}, //f
    {0x00, 0x30, 0x4a, 0x4a, 0x4a, 0x7c}, //g
    {0x00, 0xfe, 0x10, 0x20, 0x20, 0x1e}, //h
    {0x00, 0x00, 0x22, 0xbe, 0x02, 0x00}, //i
    {0x00, 0x04, 0x02, 0x22, 0xbc, 0x00}, //j
    {0x00, 0xfe, 0x08, 0x14, 0x22, 0x00}, //k
    {0x00, 0x00, 0x82, 0xfe, 0x02, 0x00}, //l
    {0x00, 0x1e, 0x20, 0x1a, 0x22, 0x1e}, //m
    {0x00, 0x3e, 0x10, 0x20, 0x20, 0x1e}, //n
    {0x00, 0x1c, 0x22, 0x22, 0x22, 0x1c}, //o
    {0x00, 0x3e, 0x28, 0x28, 0x28, 0x10}, //p
    {0x00, 0x10, 0x28, 0x28, 0x18, 0x3e}, //q
    {0x00, 0x3e, 0x10, 0x20, 0x20, 0x10}, //r
    {0x00, 0x12, 0x2a, 0x2a, 0x2a, 0x04}, //s
    {0x00, 0x20, 0xfc, 0x22, 0x02, 0x04}, //t
    {0x00, 0x3c, 0x02, 0x02, 0x04, 0x3e}, //u
    {0x00, 0x38, 0x04, 0x02, 0x04, 0x38}, //v
    {0x00, 0x3c, 0x02, 0x0c, 0x02, 0x3c}, //w
    {0x00, 0x22, 0x14, 0x08, 0x14, 0x22}, //x
    {0x00, 0x30, 0x0a, 0x0a, 0x0a, 0x3c}, //y
    {0x00, 0x22, 0x26, 0x2a, 0x32, 0x22}, //z
    {0x00, 0x00, 0x10, 0x6c, 0x82, 0x00}, //{
    {0x00, 0x00, 0x00, 0xfe, 0x00, 0x00}, //|
    {0x00, 0x00, 0x82, 0x6c, 0x10, 0x00}, //}
    {0x00, 0x30, 0x40, 0x30, 0x08, 0x30}  //~
};


/*******************************************************************************
* 16*16 character bit map for Aerial bold fonts
* These font data taken from the rinkydinkelectronic.com 
* All fonts are considered Public Domain. This means that 
* you are free to use them as you see fit in any project, 
* commercial or not.
* Important note: Commercial projects will still need a 
* commercial license for any libraries used
*********************************************************************************/

static const uint8_t Aerial_bold_font_16x16[95][32] = {

    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, // SPACE

    {0x0,0x0,0x0,0x0,0x0,0x0,0x3F,0x3F,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0xEC,0xEC,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, // !

    {0x0,0x0,0x0,0x0,0x0,0x3C,0x3C,0x0,
    0x0,0x3C,0x3C,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, //"

    {0x0,0x0,0x6,0x6,0x6,0xF,0x3F,0x36,
    0xF,0x3F,0x36,0x6,0x0,0x0,0x0,0x0,
    0x0,0x0,0x60,0x6C,0xFC,0xF0,0x6C,0xFC,
    0xF0,0x60,0x60,0x60,0x0,0x0,0x0,0x0},// #

    {0x0,0x0,0x0,0x0,0xE,0x1F,0x33,0x7F,
    0x31,0x18,0x8,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x30,0x38,0x8C,0xFE,
    0xCC,0xF8,0x70,0x0,0x0,0x0,0x0,0x0}, //$

    {0x0,0x1E,0x3F,0x21,0x21,0x3F,0x1E,0x0,
    0x3,0x7,0x1C,0x38,0x20,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x4,0xC,0x38,0xF0,
    0xC0,0x0,0x78,0xFC,0x84,0x84,0xFC,0x78},//%

    {0x0,0x0,0x0,0x0,0x1C,0x3F,0x33,0x33,
    0x33,0x3E,0x1C,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x70,0xF8,0x8C,0xC,0xCC,
    0xEC,0x78,0x38,0xF8,0x5C,0x8,0x0,0x0},//&

    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3C,
    0x3C,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},//'

    {0x0,0x0,0x0,0x0,0x0,0xF,0x3F,0x70,
    0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0xE0,0xF8,0x1C,
    0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0},//(

    {0x0,0x0,0x0,0x0,0x0,0x40,0x70,0x3F,
    0xF,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x4,0x1C,0xF8,
    0xE0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, //}  

    {0x0,0x0,0x3,0x3,0x1,0x1,0xF,0xF,
    0xF,0x1,0x1,0x3,0x3,0x0,0x0,0x0,
    0x0,0x0,0x0,0x10,0x30,0xF8,0xE0,0xC0,
    0xE0,0xF8,0x30,0x10,0x0,0x0,0x0,0x0},//*

    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x7,0x7,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0xC0,0xC0,0xC0,
    0xF8,0xF8,0xC0,0xC0,0xC0,0x0,0x0,0x0},//+

    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x32,0x3C,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, //,

    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0xC0,0xC0,
    0xC0,0xC0,0xC0,0x0,0x0,0x0,0x0,0x0},// -
 
    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x18,0x18,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, // .

    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0xF,0x3F,0x30,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0xC,0xFC,
    0xF0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, // /

    {0x0,0x0,0x0,0x0,0xF,0x1F,0x38,0x30,
    0x30,0x38,0x1F,0xF,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0xF0,0xF8,0x1C,0xC,
    0xC,0x1C,0xF8,0xF0,0x0,0x0,0x0,0x0}, // 0

    {0x0,0x0,0x0,0x0,0x6,0xC,0x18,0x3F,
    0x3F,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFC,
    0xFC,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, // 1

    {0x0,0x0,0x0,0x0,0xC,0x1C,0x38,0x30,
    0x30,0x31,0x1F,0xE,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0xC,0x1C,0x3C,0x6C,
    0xEC,0xCC,0x8C,0xC,0x0,0x0,0x0,0x0},// 2

    {0x0,0x0,0x0,0x0,0x8,0x18,0x38,0x33,
    0x33,0x33,0x3F,0x1C,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x30,0x38,0x1C,0xC,
    0xC,0x9C,0xF8,0xF0,0x0,0x0,0x0,0x0}, // 3

    {0x0,0x0,0x0,0x0,0x0,0x0,0x3,0x7,
    0x1C,0x3F,0x3F,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x70,0xF0,0xB0,0x30,
    0x30,0xFC,0xFC,0x30,0x0,0x0,0x0,0x0},//4

    {0x0,0x0,0x0,0x0,0x7,0x3F,0x3B,0x33,
    0x33,0x33,0x31,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0xB0,0xB8,0x1C,0xC,
    0xC,0x9C,0xF8,0xF0,0x0,0x0,0x0,0x0}, //5

    {0x0,0x0,0x0,0x0,0x7,0x1F,0x39,0x33,
    0x33,0x33,0x39,0x18,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0xE0,0xF8,0x9C,0xC,
    0xC,0x8C,0xF8,0xF0,0x0,0x0,0x0,0x0}, //6

    {0x0,0x0,0x0,0x0,0x30,0x30,0x30,0x31,
    0x37,0x3E,0x38,0x30,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x3C,0xFC,
    0xE0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, // 7

    {0x0,0x0,0x0,0x0,0xE,0x1F,0x31,0x31,
    0x31,0x31,0x1F,0xE,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x70,0xF8,0x8C,0x8C,
    0x8C,0x8C,0xF8,0x70,0x0,0x0,0x0,0x0}, //8 

    {0x0,0x0,0x0,0x0,0xF,0x1F,0x31,0x30,
    0x30,0x39,0x1F,0x7,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x18,0x9C,0xCC,0xCC,
    0xCC,0x9C,0xF8,0xE0,0x0,0x0,0x0,0x0}, //9

    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x18,
    0x18,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30,
    0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0},  // :

    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x18,
    0x18,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x32,
    0x3C,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, // ;

    {0x0,0x0,0x0,0x0,0x1,0x1,0x3,0x3,
    0x6,0x6,0xC,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x80,0xC0,0xC0,0x60,0x60,
    0x30,0x30,0x18,0x0,0x0,0x0,0x0,0x0}, // <

    {0x0,0x0,0x0,0xC,0xC,0xC,0xC,0xC,
    0xC,0xC,0xC,0xC,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0xC0,0xC0,0xC0,0xC0,0xC0,
    0xC0,0xC0,0xC0,0xC0,0x0,0x0,0x0,0x0}, // =

    {0x0,0x0,0x0,0x0,0xC,0x6,0x6,0x3,
    0x3,0x1,0x1,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x18,0x30,0x30,0x60,
    0x60,0xC0,0xC0,0x80,0x0,0x0,0x0,0x0}, // >

    {0x0,0x0,0x0,0x0,0xC,0x1C,0x38,0x30,
    0x31,0x33,0x1F,0xE,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xEC,
    0xEC,0x80,0x0,0x0,0x0,0x0,0x0,0x0}, // ?

    {0x0,0x0,0x7,0x18,0x27,0x6F,0x58,0x58,
    0x4F,0x5F,0x38,0x30,0x1F,0x0,0x0,0x0,
    0x0,0x0,0xC0,0x20,0x90,0xC8,0xC8,0x88,
    0xC8,0xC8,0x48,0x90,0x20,0x0,0x0,0x0}, //@

    {0x0,0x0,0x0,0x0,0x1,0xF,0x3E,0x30,
    0x3E,0xF,0x1,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x4,0x3C,0xF8,0xE0,0x60,0x60,
    0x60,0xE0,0xF8,0x3C,0x4,0x0,0x0,0x0}, // A

    {0x0,0x0,0x0,0x3F,0x3F,0x31,0x31,0x31,
    0x31,0x31,0x3F,0x1E,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0xFC,0xFC,0x8C,0x8C,0x8C,
    0x8C,0x8C,0x8C,0xF8,0x70,0x0,0x0,0x0}, // B

    {0x0,0x0,0x0,0x7,0x1F,0x1C,0x30,0x30,
    0x30,0x30,0x38,0x1C,0x8,0x0,0x0,0x0,
    0x0,0x0,0x0,0xE0,0xF8,0x38,0xC,0xC,
    0xC,0xC,0x1C,0x38,0x10,0x0,0x0,0x0}, // C

    {0x0,0x0,0x0,0x3F,0x3F,0x30,0x30,0x30,
    0x30,0x30,0x18,0x1F,0x7,0x0,0x0,0x0,
    0x0,0x0,0x0,0xFC,0xFC,0xC,0xC,0xC,
    0xC,0xC,0x18,0xF8,0xE0,0x0,0x0,0x0}, // D 

    {0x0,0x0,0x0,0x0,0x3F,0x3F,0x31,0x31,
    0x31,0x31,0x31,0x31,0x31,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0xFC,0xFC,0x8C,0x8C,
    0x8C,0x8C,0x8C,0x8C,0x8C,0x0,0x0,0x0}, // E

    {0x0,0x0,0x0,0x0,0x3F,0x3F,0x31,0x31,
    0x31,0x31,0x31,0x30,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0xFC,0xFC,0x80,0x80,
    0x80,0x80,0x80,0x0,0x0,0x0,0x0,0x0}, // F

    {0x0,0x0,0x7,0x1F,0x1C,0x30,0x30,0x30,
    0x30,0x30,0x38,0x1C,0x8,0x0,0x0,0x0,
    0x0,0x0,0xE0,0xF8,0x38,0xC,0xC,0xC,
    0xCC,0xCC,0xDC,0xF8,0xF8,0x0,0x0,0x0}, //G

    {0x0,0x0,0x0,0x3F,0x3F,0x1,0x1,0x1,
    0x1,0x1,0x1,0x3F,0x3F,0x0,0x0,0x0,
    0x0,0x0,0x0,0xFC,0xFC,0x80,0x80,0x80,
    0x80,0x80,0x80,0xFC,0xFC,0x0,0x0,0x0}, //H

    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3F,
    0x3F,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFC,
    0xFC,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, // I

    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x3F,0x3F,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x30,0x38,0x1C,0xC,
    0xC,0x1C,0xF8,0xF0,0x0,0x0,0x0,0x0}, // J

    {0x0,0x0,0x0,0x3F,0x3F,0x0,0x1,0x3,
    0x7,0xD,0x18,0x30,0x20,0x0,0x0,0x0,
    0x0,0x0,0x0,0xFC,0xFC,0xC0,0x80,0x0,
    0x80,0xE0,0x70,0x3C,0xC,0x0,0x0,0x0}, //K
 
    {0x0,0x0,0x0,0x0,0x3F,0x3F,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0xFC,0xFC,0xC,0xC,
    0xC,0xC,0xC,0xC,0x0,0x0,0x0,0x0},    // L

    {0x0,0x0,0x3F,0x3F,0x3C,0xF,0x1,0x0,
    0x1,0xF,0x3C,0x3F,0x3F,0x0,0x0,0x0,
    0x0,0x0,0xFC,0xFC,0x0,0xC0,0xF8,0x3C,
    0xF8,0xC0,0x0,0xFC,0xFC,0x0,0x0,0x0},  // M

    {0x0,0x0,0x0,0x3F,0x3F,0x1C,0xE,0x3,
    0x1,0x0,0x0,0x3F,0x3F,0x0,0x0,0x0,
    0x0,0x0,0x0,0xFC,0xFC,0x0,0x0,0x80,
    0xC0,0x70,0x38,0xFC,0xFC,0x0,0x0,0x0},  // N

    {0x0,0x0,0x7,0x1F,0x18,0x30,0x30,0x30,
    0x30,0x30,0x18,0x1F,0x7,0x0,0x0,0x0,
    0x0,0x0,0xE0,0xF8,0x18,0xC,0xC,0xC,
    0xC,0xC,0x18,0xF8,0xE0,0x0,0x0,0x0},  // O 

    {0x0,0x0,0x0,0x0,0x3F,0x3F,0x31,0x31,
    0x31,0x31,0x3B,0x1F,0xE,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0xFC,0xFC,0x80,0x80,
    0x80,0x80,0x80,0x0,0x0,0x0,0x0,0x0}, // P

    {0x0,0x0,0x7,0x1F,0x18,0x30,0x30,0x30,
    0x30,0x30,0x18,0x1F,0x7,0x0,0x0,0x0,
    0x0,0x0,0xE0,0xF8,0x18,0xC,0xC,0x2C,
    0x3C,0x18,0x3C,0xFE,0xE2,0x0,0x0,0x0},// Q

    {0x0,0x0,0x0,0x3F,0x3F,0x31,0x31,0x31,
    0x31,0x31,0x3B,0x1F,0xE,0x0,0x0,0x0,
    0x0,0x0,0x0,0xFC,0xFC,0x80,0x80,0x80,
    0xC0,0xE0,0x78,0x3C,0xC,0x4,0x0,0x0}, // R

    {0x0,0x0,0x0,0x0,0xE,0x1F,0x3B,0x33,
    0x31,0x31,0x39,0x1C,0xC,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x30,0x38,0x1C,0x8C,
    0x8C,0x8C,0xDC,0xF8,0x70,0x0,0x0,0x0}, //S

    {0x0,0x0,0x0,0x30,0x30,0x30,0x30,0x3F,
    0x3F,0x30,0x30,0x30,0x30,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFC,
    0xFC,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, //T 

    {0x0,0x0,0x0,0x3F,0x3F,0x0,0x0,0x0,
    0x0,0x0,0x0,0x3F,0x3F,0x0,0x0,0x0,
    0x0,0x0,0x0,0xF0,0xF8,0x1C,0xC,0xC,
    0xC,0xC,0x1C,0xF8,0xF0,0x0,0x0,0x0}, //U

    {0x0,0x0,0x20,0x3C,0x1F,0x3,0x0,0x0,
    0x0,0x3,0x1F,0x3C,0x20,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x80,0xE0,0xFC,0x1C,
    0xFC,0xE0,0x80,0x0,0x0,0x0,0x0,0x0},//V 

    {0x0,0x0,0x38,0x3F,0x7,0x0,0x7,0x3F,
    0x38,0x3F,0x7,0x0,0x7,0x3F,0x38,0x0,
    0x0,0x0,0x0,0xC0,0xFC,0x3C,0xFC,0xC0,
    0x0,0xC0,0xFC,0x3C,0xFC,0xC0,0x0,0x0}, // W

    {0x0,0x0,0x0,0x30,0x38,0x1E,0x7,0x3,
    0x7,0x1E,0x38,0x30,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0xC,0x1C,0x78,0xE0,0xC0,
    0xE0,0x78,0x1C,0xC,0x0,0x0,0x0,0x0}, // X

    {0x0,0x0,0x0,0x30,0x38,0x1E,0x7,0x1,
    0x1,0x7,0x1E,0x38,0x30,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFC,
    0xFC,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, // Y 

    {0x0,0x0,0x0,0x0,0x0,0x30,0x30,0x30,
    0x33,0x37,0x3E,0x38,0x30,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0xC,0x1C,0x7C,0xEC,
    0xCC,0xC,0xC,0xC,0xC,0x0,0x0,0x0}, // Z

    {0x0,0x0,0x0,0x0,0x0,0x0,0x7F,0x7F,
    0x60,0x60,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0xFE,0xFE,
    0x6,0x6,0x0,0x0,0x0,0x0,0x0,0x0},  // [

    {0x0,0x0,0x0,0x0,0x0,0x0,0x30,0x3F,
    0xF,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0xF0,0xFC,0xC,0x0,0x0,0x0,0x0,0x0}, // backslash

    {0x0,0x0,0x0,0x0,0x0,0x0,0x60,0x60,
    0x7F,0x7F,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x6,0x6,
    0xFE,0xFE,0x0,0x0,0x0,0x0,0x0,0x0}, // ]

    {0x0,0x0,0x0,0x0,0x1,0xF,0x3E,0x70,
    0x70,0x3E,0xF,0x1,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, // ^

    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x6,0x6,0x6,0x6,0x6,0x6,0x6,0x6,
    0x6,0x6,0x6,0x6,0x6,0x6,0x6,0x6}, // _

    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,
    0x30,0x10,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, // `

    {0x0,0x0,0x0,0x0,0x6,0xE,0xC,0xD,
    0xD,0xF,0x7,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x70,0xF8,0xD8,0x98,
    0x98,0xF0,0xF8,0x8,0x0,0x0,0x0,0x0}, // a

    {0x0,0x0,0x0,0x0,0x7F,0x7F,0x6,0xC,
    0xC,0xE,0x7,0x3,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0xF8,0xF8,0x30,0x18,
    0x18,0x38,0xF0,0xE0,0x0,0x0,0x0,0x0}, // b

    {0x0,0x0,0x0,0x0,0x3,0x7,0xE,0xC,
    0xC,0xE,0x6,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0xE0,0xF0,0x38,0x18,
    0x18,0x38,0x30,0x0,0x0,0x0,0x0,0x0}, //c

    {0x0,0x0,0x0,0x0,0x3,0x7,0xE,0xC,
    0xC,0x6,0x7F,0x7F,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0xE0,0xF0,0x38,0x18,
    0x18,0x30,0xF8,0xF8,0x0,0x0,0x0,0x0}, // d

    {0x0,0x0,0x0,0x0,0x3,0x7,0xD,0xD,
    0xD,0x7,0x3,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0xE0,0xF0,0xB8,0x98,
    0x98,0xB0,0xA0,0x0,0x0,0x0,0x0,0x0},  // e

    {0x0,0x0,0x0,0x0,0xC,0x3F,0x7F,0x6C,
    0x6C,0x60,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0xF8,0xF8,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},   // f

    {0x0,0x0,0x0,0x7,0xF,0x1C,0x18,0x18,
    0xC,0x1F,0x1F,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0xCC,0xEE,0x76,0x36,0x36,
    0x66,0xFE,0xFC,0x0,0x0,0x0,0x0,0x0}, // g

    {0x0,0x0,0x0,0x0,0x7F,0x7F,0x6,0xC,
    0xC,0xC,0xF,0x7,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0xF8,0xF8,0x0,0x0,
    0x0,0x0,0xF8,0xF8,0x0,0x0,0x0,0x0}, //h

    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x37,
    0x37,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xF8,
    0xF8,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, // i

    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x37,
    0x37,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x3,0x3,0xFF,
    0xFE,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, // j

    {0x0,0x0,0x0,0x0,0x7F,0x7F,0x1,0x3,
    0x7,0xC,0x8,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0xF8,0xF8,0xC0,0x80,
    0xE0,0xF8,0x18,0x0,0x0,0x0,0x0,0x0}, // k

    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x7F,
    0x7F,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xF8,
    0xF8,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, // l

    {0x0,0x0,0xF,0xF,0x6,0xC,0xC,0xF,
    0x7,0x6,0xC,0xC,0xF,0x7,0x0,0x0,
    0x0,0x0,0xF8,0xF8,0x0,0x0,0x0,0xF8,
    0xF8,0x0,0x0,0x0,0xF8,0xF8,0x0,0x0},// m

    0x0,0x0,0x0,0x0,0xF,0xF,0x6,0xC,
    0xC,0xC,0xF,0x7,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0xF8,0xF8,0x0,0x0,
    0x0,0x0,0xF8,0xF8,0x0,0x0,0x0,0x0, // n

    {0x0,0x0,0x0,0x0,0x3,0x7,0xE,0xC,
    0xC,0xE,0x7,0x3,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0xE0,0xF0,0x38,0x18,
    0x18,0x38,0xF0,0xE0,0x0,0x0,0x0,0x0}, // o

    {0x0,0x0,0x0,0x0,0xF,0xF,0x6,0xC,
    0xC,0xE,0x7,0x3,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0xFF,0xFF,0x30,0x18,
    0x18,0x38,0xF0,0xE0,0x0,0x0,0x0,0x0}, // p

    {0x0,0x0,0x0,0x0,0x3,0x7,0xE,0xC,
    0xC,0x6,0xF,0xF,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0xE0,0xF0,0x38,0x18,
    0x18,0x30,0xFF,0xFF,0x0,0x0,0x0,0x0}, //q

    {0x0,0x0,0x0,0x0,0x0,0x0,0xF,0xF,
    0x6,0xC,0xC,0xC,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0xF8,0xF8,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, //r

    {0x0,0x0,0x0,0x0,0x7,0xF,0xD,0xD,
    0xC,0xE,0x6,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x30,0xB8,0x98,0x98,
    0xD8,0xF8,0x70,0x0,0x0,0x0,0x0,0x0}, // s

    {0x0,0x0,0x0,0x0,0x0,0xC,0x3F,0x7F,
    0xC,0xC,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0xF0,0xF8,
    0x18,0x18,0x0,0x0,0x0,0x0,0x0,0x0}, // t

    {0x0,0x0,0x0,0x0,0xF,0xF,0x0,0x0,
    0x0,0x0,0xF,0xF,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0xF0,0xF8,0x18,0x18,
    0x18,0x30,0xF8,0xF8,0x0,0x0,0x0,0x0}, // u

    {0x0,0x0,0x0,0x0,0x0,0xE,0xF,0x1,
    0x0,0x1,0xF,0xE,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0xC0,0xF8,
    0x38,0xF8,0xC0,0x0,0x0,0x0,0x0,0x0}, // v

    {0x0,0x0,0xC,0xF,0x3,0x0,0x1,0xF,
    0xE,0xF,0x1,0x0,0x3,0xF,0xC,0x0,
    0x0,0x0,0x0,0xC0,0xF8,0x38,0xF8,0xC0,
    0x0,0xC0,0xF8,0x38,0xF8,0xC0,0x0,0x0}, // w

    {0x0,0x0,0x0,0x0,0x0,0xC,0xE,0x7,
    0x1,0x7,0xE,0xC,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x18,0x38,0xF0,
    0xC0,0xF0,0x38,0x18,0x0,0x0,0x0,0x0}, // x

    {0x0,0x0,0x0,0x0,0xC,0xF,0x3,0x0,
    0x0,0x0,0x3,0xF,0xC,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x3,0xE3,0xFF,
    0x3E,0xF8,0xE0,0x0,0x0,0x0,0x0,0x0}, // y

    {0x0,0x0,0x0,0x0,0x0,0x0,0xC,0xC,
    0xC,0xD,0xF,0xF,0xC,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x18,0x78,
    0xF8,0xD8,0x98,0x18,0x18,0x0,0x0,0x0}, //z

    {0x0,0x0,0x0,0x0,0x3,0x3,0x7F,0xFC,
    0xC0,0xC0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0xFC,0xFE,
    0x6,0x6,0x0,0x0,0x0,0x0,0x0,0x0}, // {

    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,
    0xFF,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,
    0xFF,0x0,0x0,0x0,0x0,0x0,0x0,0x0},  // |

    {0x0,0x0,0x0,0x0,0x0,0x0,0xC0,0xC0,
    0xFC,0x7F,0x3,0x3,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x6,0x6,
    0xFE,0xFC,0x0,0x0,0x0,0x0,0x0,0x0}, // }

    {0x0,0x0,0x0,0x0,0x18,0x30,0x30,0x30,
    0x38,0x18,0x18,0x18,0x30,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, // ~
};

// Manually created 16*16 character bit map 
static const uint8_t Manual_font_16x16[95][32] = {
    
    // Note: Number 0-9, char A-Z and char a-z  bit map data created manually, other 
    // font bit map data taken from Aerial_bold font
    
    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, // SPACE

    {0x0,0x0,0x0,0x0,0x0,0x0,0x3F,0x3F,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0xEC,0xEC,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, // !

    {0x0,0x0,0x0,0x0,0x0,0x3C,0x3C,0x0,
    0x0,0x3C,0x3C,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, //"

    {0x0,0x0,0x6,0x6,0x6,0xF,0x3F,0x36,
    0xF,0x3F,0x36,0x6,0x0,0x0,0x0,0x0,
    0x0,0x0,0x60,0x6C,0xFC,0xF0,0x6C,0xFC,
    0xF0,0x60,0x60,0x60,0x0,0x0,0x0,0x0},// #

    {0x0,0x0,0x0,0x0,0xE,0x1F,0x33,0x7F,
    0x31,0x18,0x8,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x30,0x38,0x8C,0xFE,
    0xCC,0xF8,0x70,0x0,0x0,0x0,0x0,0x0}, //$

    {0x0,0x1E,0x3F,0x21,0x21,0x3F,0x1E,0x0,
    0x3,0x7,0x1C,0x38,0x20,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x4,0xC,0x38,0xF0,
    0xC0,0x0,0x78,0xFC,0x84,0x84,0xFC,0x78},//%

    {0x0,0x0,0x0,0x0,0x1C,0x3F,0x33,0x33,
    0x33,0x3E,0x1C,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x70,0xF8,0x8C,0xC,0xCC,
    0xEC,0x78,0x38,0xF8,0x5C,0x8,0x0,0x0},//&

    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3C,
    0x3C,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0},//'

    {0x0,0x0,0x0,0x0,0x0,0xF,0x3F,0x70,
    0x40,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0xE0,0xF8,0x1C,
    0x4,0x0,0x0,0x0,0x0,0x0,0x0,0x0},//(

    {0x0,0x0,0x0,0x0,0x0,0x40,0x70,0x3F,
    0xF,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x4,0x1C,0xF8,
    0xE0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, //}  

    {0x0,0x0,0x3,0x3,0x1,0x1,0xF,0xF,
    0xF,0x1,0x1,0x3,0x3,0x0,0x0,0x0,
    0x0,0x0,0x0,0x10,0x30,0xF8,0xE0,0xC0,
    0xE0,0xF8,0x30,0x10,0x0,0x0,0x0,0x0},//*

    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x7,0x7,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0xC0,0xC0,0xC0,
    0xF8,0xF8,0xC0,0xC0,0xC0,0x0,0x0,0x0},//+

    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x32,0x3C,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, //,

    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0xC0,0xC0,
    0xC0,0xC0,0xC0,0x0,0x0,0x0,0x0,0x0},// -
 
    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0x18,0x18,
    0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, // .

    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
    0xF,0x3F,0x30,0x0,0x0,0x0,0x0,0x0,
    0x0,0x0,0x0,0x0,0x0,0x0,0xC,0xFC,
    0xF0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, // /
    
    {0x00,0x00,0x3F,0x7F,0x7F,0x60,0x60,0x60, 
    0x61,0x63,0x66,0x7F,0x7F,0x3F,0x00,0x00, 
    0x00,0x00,0xFE,0xFF,0xFF,0x33,0x63,0xC3,
    0x83,0x03,0x03,0xFF,0xFF,0x0FE,0x00,0x00}, // 0
    
    {0x00,0x00,0x00,0x00,0x08,0x18,0x3F,0x7F, 
    0xFF,0xFF,0x00,0x00,0x00,0x00,0x00,0x00,  
    0x00,0x00,0x00,0x00,0x00,0x03,0xFF,0xFF,
    0xFF,0xFF,0x03,0x00,0x00,0x00,0x00,0x00 }, //  1
    
    {0x00,0x00,0x30,0x70,0x60,0x60,0x60,0x60, 
    0x61,0x63,0x66,0x7C,0x38,0x30,0x00,0x00,  
    0x00,0x00,0x06,0x0E,0x1E,0x36,0x66,0xC6,
    0x86,0x06,0x06,0x06,0x06,0x06,0x00,0x00 }, // 2  

    {0x00,0x00,0x30,0x70,0x60,0x60,0x60,0x60, 
    0x61,0x63,0x66,0x7E,0x7C,0x38,0x00,0x00,  
    0x00,0x00,0x0C,0x0E,0x06,0x06,0x06,0x06,
    0x86,0xC6,0x66,0x7E,0x3E,0x1C,0x00,0x00 }, // 3
 
    {0x00,0x00,0x00,0x01,0x03,0x06,0xC,0x18, 
    0x30,0x7F,0xFF,0xFF,0x00,0x00,0x00,0x00,  
    0x00,0x00,0xE0,0xE0,0x60,0x60,0x60,0x60,
    0x60,0xFE,0xFE,0xFE,0x60,0x60,0x00,0x00 }, // 4    
    
    {0x00,0x00,0x7F,0x7F,0x7F,0x61,0x61,0x61, 
     0x61,0x61,0x61,0x61,0x61,0x60,0x00,0x00,  
     0x00,0x00,0x04,0x86,0x86,0x86,0x86,0x86,
     0x86,0x86,0x86,0xFE,0xFE,0xFC,0x00,0x00 }, // 5
   
    {0x00,0x00,0x3F,0x7F,0x7F,0x61,0x61,0x61, 
     0x61,0x61,0x61,0x61,0x61,0x20,0x00,0x00,  
     0x00,0x00,0xFC,0xFE,0xFE,0x86,0x86,0x86,
     0x86,0x86,0x86,0xFE,0xFE,0xFC,0x00,0x00 }, // 6
   
    {0x00,0x00,0x00,0x30,0x30,0x30,0x30,0x30, 
     0x30,0x30,0x31,0x3F,0x3E,0x00,0x00,0x00,  
     0x00,0x00,0x00,0x00,0x06,0x0C,0x18,0x30,
     0x60,0xC0,0x80,0x00,0x00,0x00,0x00,0x00 }, // 7
 
    {0x00,0x00,0x3F,0x7F,0x7F,0x60,0x60,0x60, 
     0x60,0x60,0x60,0x7F,0x7F,0x3F,0x00,0x00, 
     0x00,0x00,0x3E,0xFF,0xFF,0xC3,0xC3,0xC3,
     0xC3,0xC3,0xC3,0xFF,0xFF,0x03E,0x00,0x00}, // 8

    {0x00,0x00,0x3F,0x7F,0x7F,0x60,0x60,0x60, 
     0x60,0x60,0x60,0x7F,0x7F,0x3F,0x00,0x00, 
     0x00,0x00,0x86,0xC7,0xC3,0xC3,0xC3,0xC3,
     0xC3,0xC3,0xC3,0xFF,0xFF,0x0FE,0x00,0x00}, // 9 
      
    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x18,
     0x18,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x30,
     0x30,0x0,0x0,0x0,0x0,0x0,0x0,0x0},  // :

    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x18,
     0x18,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x32,
     0x3C,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, // ;

    {0x0,0x0,0x0,0x0,0x1,0x1,0x3,0x3,
     0x6,0x6,0xC,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0x0,0x80,0xC0,0xC0,0x60,0x60,
     0x30,0x30,0x18,0x0,0x0,0x0,0x0,0x0}, // <

    {0x0,0x0,0x0,0xC,0xC,0xC,0xC,0xC,
     0xC,0xC,0xC,0xC,0x0,0x0,0x0,0x0,
     0x0,0x0,0x0,0xC0,0xC0,0xC0,0xC0,0xC0,
     0xC0,0xC0,0xC0,0xC0,0x0,0x0,0x0,0x0}, // =

    {0x0,0x0,0x0,0x0,0xC,0x6,0x6,0x3,
     0x3,0x1,0x1,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0x0,0x0,0x18,0x30,0x30,0x60,
     0x60,0xC0,0xC0,0x80,0x0,0x0,0x0,0x0}, // >

    {0x0,0x0,0x0,0x0,0xC,0x1C,0x38,0x30,
     0x31,0x33,0x1F,0xE,0x0,0x0,0x0,0x0,
     0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xEC,
     0xEC,0x80,0x0,0x0,0x0,0x0,0x0,0x0}, // ?

    {0x0,0x0,0x7,0x18,0x27,0x6F,0x58,0x58,
     0x4F,0x5F,0x38,0x30,0x1F,0x0,0x0,0x0,
     0x0,0x0,0xC0,0x20,0x90,0xC8,0xC8,0x88,
     0xC8,0xC8,0x48,0x90,0x20,0x0,0x0,0x0}, //@
                                                   
    {0x00,0x00,0x3F,0x7F,0x7F,0x60,0x60,0x60, 
     0x60,0x60,0x60,0x7F,0x7F,0x3F,0x00,0x00, 
     0x00,0x00,0xFF,0xFF,0xFF,0x60,0x60,0x60,  
     0x60,0x60,0x60,0xFF,0xFF,0xFF,0x00,0x00 }, // A 
  
    {0x00,0x00,0x7F,0x7F,0x7F,0x60,0x60,0x60, 
     0x60,0x60,0x60,0x7F,0x07F,0x3E,0x00,0x00, 
     0x00,0x00,0xFF,0xFF,0xFF,0xC3,0xC3,0xC3,
     0xC3,0xC3,0xC3,0xFF,0xFF,0x3E,0x00,0x00}, // B    
 
    {0x00,0x00,0x3F,0x7F,0x7F,0x60,0x60,0x60, 
     0x60,0x60,0x60,0x70,0x30,0x00,0x00,0x00, 
     0x00,0x00,0xFE,0xFF,0xFF,0x03,0x03,0x03,
     0x03,0x03,0x03,0x07,0x06,0x00,0x00,0x00}, // C

    {0x00,0x00,0x7F,0x7F,0x7F,0x60,0x60,0x60, 
     0x60,0x60,0x60,0x70,0x3F,0x1F,0x00,0x00, 
     0x00,0x00,0xFF,0xFF,0xFF,0x03,0x03,0x03,
     0x03,0x03,0x03,0x07,0xFE,0x0FC,0x00,0x00}, // D

    {0x00,0x00,0x07F,0x7F,0x7F,0x60,0x60,0x60, 
     0x60,0x60,0x60,0x60,0x60,0x060,0x00,0x00, 
     0x00,0x00,0xFF,0xFF,0xFF,0xC3,0xC3,0xC3,
     0xC3,0xC3,0xC3,0xC3,0x03,0x03,0x00,0x00}, // E
       
    {0x00,0x00,0x7F,0x7F,0x7F,0x60,0x60,0x60,  
     0x60,0x60,0x60,0x60,0x60,0x060,0x00,0x00, 
     0x00,0x00,0xFF,0xFF,0xFF,0xC0,0xC0,0xC0,
     0xC0,0xC0,0xC0,0xC0,0x00,0x00,0x00,0x00}, // F 

    {0x00,0x00,0x3F,0x7F,0x7F,0x60,0x60,0x60,  
     0x60,0x60,0x60,0x78,0x38,0x18,0x00,0x00, 
     0x00,0x00,0xFE,0xFF,0xFF,0x03,0x03,0x03,
     0x03,0x23,0x33,0x3F,0x3F,0x3F,0x00,0x00}, // G
   
    {0x00,0x00,0x7F,0x7F,0x7F,0x00,0x00,0x00,  
     0x00,0x00,0x00,0x7F,0x7F,0x7F,0x00,0x00, 
     0x00,0x00,0xFF,0xFF,0xFF,0xC0,0xC0,0xC0,
     0xC0,0xC0,0xC0,0xFF,0xFF,0xFF,0x00,0x00 }, // H

    {0x00,0x00,0x00,0x00,0x60,0x60,0x7F,0x7F, 
     0x7F,0x7F,0x60,0x60,0x00,0x00,0x00,0x00,  
     0x00,0x00,0x00,0x00,0x03,0x03,0xFF,0xFF,
     0xFF,0xFF,0x03,0x03,0x00,0x00,0x00,0x00 }, // I

    {0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00, 
     0x00,0x00,0x00,0x7F,0x7F,0x7F,0x00,0x00, 
     0x00,0x00,0x00,0x01E,0x1F,0x1F,0x03,0x03,
     0x03,0x03,0x03,0xFF,0xFF,0xFE,0x00,0x00 }, // J

    {0x00,0x00,0x7F,0x7F,0x7F,0x03,0x03,0x06,  
     0x0C,0x18,0x30,0x60,0x60,0x00,0x00,0x00,  
     0x00,0x00,0xFE,0xFE,0xFE,0xC0,0xC0,0x60,
     0x30,0x18,0x0C,0x06,0x06,0x00,0x00,0x00 }, // K

    {0x00,0x00,0x7F,0x7F,0x7F,0x00,0x00,0x00, 
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,  
     0x00,0x00,0xFF,0xFF,0xFF,0x03,0x03,0x03,
     0x03,0x03,0x03,0x03,0x03,0x00,0x00,0x00 }, // L

    {0x00,0x00,0x7F,0x7F,0x7F,0x1C,0x0E,0x07, 
     0x07,0x0E,0x1C,0x7F,0x7F,0x7F,0x00,0x00, 
     0x00,0x00,0xFC,0xFC,0xFC,0x00,0x00,0x80,
     0x80,0x00,0x00,0xFC,0xFC,0xFC,0x00,0x00 }, // M
   
    {0x00,0x00,0x7F,0x7F,0x7F,0x38,0x1C,0x07, 
     0x03,0x00,0x00,0x7F,0x7F,0x7F,0x00,0x00, 
     0x00,0x00,0xFC,0xFC,0xFC,0x00,0x00,0x00,
     0x80,0xE0,0x70,0xFC,0xFC,0xFC,0x00,0x00 }, // N

    {0x00,0x00,0x3F,0x7F,0x7F,0x60,0x60,0x60, 
     0x60,0x60,0x60,0x7F,0x7F,0x3F,0x00,0x00, 
     0x00,0x00,0xFE,0xFF,0xFF,0x03,0x03,0x03,
     0x03,0x03,0x03,0xFF,0xFF,0x0FE,0x00,0x00}, // O
   
    {0x00,0x00,0x07F,0x7F,0x7F,0x60,0x60,0x60, 
     0x60,0x60,0x60,0x7F,0x7F,0x03F,0x00,0x00,  
     0x00,0x00,0xFF,0xFF,0xFF,0xC0,0xC0,0xC0,
     0xC0,0xC0,0xC0,0xC0,0xC0,0x80,0x00,0x00}, // P
  
    {0x00,0x00,0x3F,0x7F,0x60,0x60,0x60,0x60, 
     0x60,0x60,0x60,0x60,0x7F,0x3F,0x00,0x00, 
     0x00,0x00,0xF8,0xFC,0x0C,0x0C,0x0C,0x0C,
     0x0C,0x0C,0x3C,0x3C,0xFE,0xFF,0x03,0x00}, // Q

    {0x00,0x00,0x07F,0x7F,0x7F,0x61,0x61,0x61, 
     0x61,0x61,0x61,0x7F,0x7F,0x03F,0x00,0x00, 
     0x00,0x00,0xFF,0xFF,0xFF,0xC0,0xE0,0xF0,
     0xB8,0x9C,0x8E,0x87,0x83,0x03,0x00,0x00}, // R
 
    {0x00,0x00,0x1E,0x3F,0x73,0x61,0x61,0x61, 
     0x61,0x61,0x61,0x70,0x30,0x00,0x00,0x00, 
     0x00,0x00,0x0C,0x0C,0x86,0x86,0x86,0x86,
     0x86,0x86,0xC6,0xFC,0x78,0x00,0x00,0x00}, // S  
    
    {0x00,0x00,0x10,0x30,0x30,0x30,0x30,0x3F, 
     0x3F,0x30,0x30,0x30,0x30,0x10,0x00,0x00, 
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF,
     0xFF,0x00,0x00,0x00,0x00,0x00,0x00,0x00 }, // T
  
    {0x00,0x00,0x7F,0x7F,0x7F,0x00,0x00,0x00, 
     0x00,0x00,0x00,0x7F,0x7F,0x7F,0x00,0x00,  
     0x00,0x00,0xFC,0xFE,0xFE,0x06,0x06,0x06,
     0x06,0x06,0x06,0xFE,0xFE,0xFC,0x00,0x00 }, // U
  
    {0x60,0x70,0x1C,0x0F,0x03,0x00,0x00,  
     0x00,0x00,0x00,0x00,0x03,0x0F,0x1C,0x70,0x60,  
     0x00,0x00,0x00,0x00,0xC0,0xF0,0x3C,0x06,
     0x06,0x3C,0xF0,0xC0,0x00,0x00,0x00,0x00 }, // V  
  
    {0x00,0x00,0x7F,0x7F,0x7F,0x00,0x00,0x00, 
     0x00,0x00,0x00,0x7F,0x7F,0x7F,0x00,0x00,  
     0x00,0x00,0xFC,0xFE,0xFE,0x1C,0x38,0x70,
     0x70,0x38,0x1C,0xFE,0xFE,0xFC,0x00,0x00 }, // W
   
    {0x00,0x00,0x60,0x70,0x78,0x0E,0x07,0x03, 
     0x03,0x07,0x0E,0x78,0x70,0x60,0x00,0x00,  
     0x00,0x00,0x06,0x0E,0x1E,0x70,0xE0,0xC0,
     0xC0,0xE0,0x70,0x1E,0x0E,0x06,0x00,0x00 }, // X
    
    {0x00,0x00,0x20,0x30,0x18,0x0C,0x06,0x03, 
     0x03,0x06,0x0C,0x18,0x30,0x20,0x00,0x00,  
     0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFC,
     0xFC,0x00,0x00,0x00,0x00,0x00,0x00,0x00 }, // Y 

    {0x00,0x00,0x70,0x70,0x60,0x60,0x60,0x61, 
     0x63,0x67,0x6E,0x78,0x70,0x60,0x00,0x00,  
     0x00,0x00,0x06,0x0E,0x3E,0x76,0xE6,0xC6,
     0x86,0x06,0x06,0x06,0x0E,0x0E,0x00,0x00 }, // Z 
    
    {0x0,0x0,0x0,0x0,0x0,0x0,0x7F,0x7F,
     0x60,0x60,0x0,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0x0,0x0,0x0,0x0,0xFE,0xFE,
     0x6,0x6,0x0,0x0,0x0,0x0,0x0,0x0},  // [

    {0x0,0x0,0x0,0x0,0x0,0x0,0x30,0x3F,
     0xF,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
     0xF0,0xFC,0xC,0x0,0x0,0x0,0x0,0x0}, // backslash

    {0x0,0x0,0x0,0x0,0x0,0x0,0x60,0x60,
     0x7F,0x7F,0x0,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0x0,0x0,0x0,0x0,0x6,0x6,
     0xFE,0xFE,0x0,0x0,0x0,0x0,0x0,0x0}, // ]

    {0x0,0x0,0x0,0x0,0x1,0xF,0x3E,0x70,
     0x70,0x3E,0xF,0x1,0x0,0x0,0x0,0x0,
     0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, // ^

    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
     0x6,0x6,0x6,0x6,0x6,0x6,0x6,0x6,
     0x6,0x6,0x6,0x6,0x6,0x6,0x6,0x6}, // _

    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x20,
     0x30,0x10,0x0,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, // `

    {0x0,0x0,0x0,0x04,0x09,0x19,0x19,0x19,
     0x0F,0x07,0x0,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0x0,0xE0,0xB0,0x30,0x30,0x20,
     0xF0,0xF0,0x10,0x0,0x0,0x0,0x0,0x0}, // a

    {0x0,0x0,0xFF,0xFF,0xFC,0x8,0x18,0x18,
     0x1C,0xF,0x3,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0xF0,0xF0,0x60,0x30,0x30,0x30,
     0x60,0xE0,0x80,0x0,0x0,0x0,0x0,0x0}, // b

    {0x0,0x0,0x07,0x0F,0x0C,0x18,0x18,0x18,
     0xC,0x4,0x0,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0xC0,0xE0,0x60,0x30,0x30,0x30,
     0x60,0x40,0x0,0x0,0x0,0x0,0x0,0x0}, // c

    {0x0,0x0,0x03,0x07,0x0C,0x18,0x18,0x18,
     0xFF,0xFF,0x0,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0xC0,0xE0,0x60,0x30,0x30,0x30,
     0xF8,0xF8,0x0,0x0,0x0,0x0,0x0,0x0}, // d

    {0x0,0x0,0x03,0x0F,0x0D,0x19,0x19,0x19,
     0x19,0x0F,0x06,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0xC0,0xE0,0x30,0x30,0x10,0x30,
     0x30,0x60,0x40,0x0,0x0,0x0,0x0,0x0}, // e

    {0x0,0x0,0x0,0x0,0x00,0x03,0x03,0x3F,
     0x7F,0x43,0x03,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0x0,0x0,0x0,0x0,0x00,0xFE,
     0xFE,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, // f

    {0x0,0x0,0x01,0x07,0x0E,0x08,0x08,0x0C,
     0x0F,0x1F,0x00,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0x84,0xE2,0x62,0x23,0x23,0x63,
     0xFE,0xFC,0x0,0x0,0x0,0x0,0x0,0x0}, // g

    {0x0,0x0,0x00,0x3F,0x3F,0x03,0x02,0x03,
     0x03,0x01,0x0,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0x0,0xFC,0xFC,0x0,0x0,0x0,
     0xFC,0xFC,0x0,0x0,0x0,0x0,0x0,0x0}, // h

    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x06F,
     0x6F,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xF0,
     0xF0,0x00,0x0,0x0,0x0,0x0,0x0,0x0}, // i

    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xDF,
     0xDF,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0x0,0x0,0x0,0x08,0x0C,0xFC,
     0xF8,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, // j

    {0x0,0x0,0xFF,0xFF,0x03,0x03,0x07,0x0C,
     0x18,0x30,0x0,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0xF0,0xF0,0x80,0x0,0x80,0xE0,
     0x30,0x10,0x0,0x0,0x0,0x0,0x0,0x0}, // k

    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x3F,
     0x3F,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFC,
     0xFC,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, // l

    {0x0,0x0,0x08,0x1F,0x1F,0x18,0x18,0x18,
     0x1F,0x1F,0x18,0x18,0x18,0x1F,0x0F,0x0,
     0x0,0x0,0x0,0xF0,0xF0,0x0,0x0,0x0,
     0xF0,0xF0,0x0,0x0,0x0,0xF0,0xF0,0x0}, // m

    {0x0,0x0,0x1F,0x0F,0x0C,0x18,0x18,0x1C,
     0x0F,0x07,0x0,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0xF0,0xF0,0x0,0x0,0x0,0x0,
     0xF0,0xF0,0x0,0x0,0x0,0x0,0x0,0x0}, // n

    {0x0,0x0,0x03,0x07,0x0C,0x18,0x18,0x18,
     0x0C,0x07,0x03,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0x80,0xC0,0x60,0x30,0x30,0x30,
     0x60,0xC0,0x80,0x0,0x0,0x0,0x0,0x0}, // o

    {0x0,0x0,0x0,0x1F,0x1F,0x0C,0x08,0x08,
     0x0C,0x07,0x03,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0x0,0xFE,0xFE,0x30,0x10,0x10,
     0x30,0xE0,0xC0,0x0,0x0,0x0,0x0,0x0}, // p

    {0x0,0x0,0x01,0x07,0x0C,0x08,0x08,0x0C,
     0x1F,0x1F,0x0,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0x80,0xE0,0x30,0x10,0x10,0x30,
     0xFE,0xFE,0x0,0x0,0x0,0x0,0x0,0x0}, // q

    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x1F,
     0x1F,0x0C,0x08,0x0C,0x0,0x0,0x0,0x0,
     0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xF0,
     0xF0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, // r

    {0x0,0x0,0x0,0x07,0x0F,0x19,0x19,0x0D,
     0x04,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0x0,0x60,0x30,0x18,0x98,0xB0,
     0xE0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, // s

    {0x0,0x0,0x0,0x0,0x0,0x0,0x03,0x3F,
     0x3F,0x03,0x0,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xF8,
     0xFC,0x0C,0x08,0x0,0x0,0x0,0x0,0x0}, // t

    {0x0,0x0,0x1F,0x1F,0x0,0x0,0x0,0x0,
     0x1F,0x1F,0x0,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0xC0,0xE0,0x70,0x30,0x30,0x60,
     0xF0,0xF0,0x0,0x0,0x0,0x0,0x0,0x0}, // u

    {0x0,0x0,0x0C,0x0F,0x01,0x0,0x0,0x01,
     0x0F,0x0C,0x0,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0x0,0x80,0xE0,0x30,0x30,0xE0,
     0x80,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, // v

    {0x0,0x0,0x18,0x1F,0x0,0x0,0x07,0x0E,
    0x07,0x0,0x0,0x1F,0x18,0x0,0x0,0x0,
    0x0,0x0,0x0,0xC0,0x60,0x60,0xC0,0x0,
    0xC0,0x60,0x60,0xC0,0x0,0x0,0x0,0x0}, // w

    {0x0,0x0,0x0,0x0,0x08,0x0C,0x06,0x03,
     0x03,0x06,0x0C,0x08,0x0,0x0,0x0,0x0,
     0x0,0x0,0x0,0x0,0x10,0x30,0x60,0xC0,
     0xC0,0x60,0x30,0x10,0x0,0x0,0x0,0x0}, // x

    {0x0,0x0,0x08,0x0C,0x06,0x03,0x01,0x01,
     0x03,0x06,0x0C,0x08,0x0,0x0,0x0,0x0,
     0x0,0x0,0x0C,0x18,0x30,0x60,0xC0,0x80,
     0x00,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, // y

    {0x0,0x0,0x08,0x08,0x08,0x09,0x0B,0x0E,
     0x0C,0x08,0x0,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0x30,0x070,0xD0,0x90,0x10,0x10,
     0x10,0x10,0x0,0x0,0x0,0x0,0x0,0x0}, // z

    {0x0,0x0,0x0,0x0,0x3,0x3,0x7F,0xFC,
     0xC0,0xC0,0x0,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0x0,0x0,0x0,0x0,0xFC,0xFE,
     0x6,0x6,0x0,0x0,0x0,0x0,0x0,0x0}, // {

    {0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,
     0xFF,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0x0,0x0,0x0,0x0,0x0,0xFF,
     0xFF,0x0,0x0,0x0,0x0,0x0,0x0,0x0},  // |

    {0x0,0x0,0x0,0x0,0x0,0x0,0xC0,0xC0,
     0xFC,0x7F,0x3,0x3,0x0,0x0,0x0,0x0,
     0x0,0x0,0x0,0x0,0x0,0x0,0x6,0x6,
     0xFE,0xFC,0x0,0x0,0x0,0x0,0x0,0x0}, // }

    {0x0,0x0,0x0,0x0,0x18,0x30,0x30,0x30,
     0x38,0x18,0x18,0x18,0x30,0x0,0x0,0x0,
     0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0,
     0x0,0x0,0x0,0x0,0x0,0x0,0x0,0x0}, // ~
    };



static uint8_t display_buff[1024];
static uint8_t display_buff_16x16[32];
static uint16_t buff_end =0;
static uint8_t disp_buff1[512];
static uint8_t disp_buff2[512];
static uint8_t temp_buff1[512];
static uint8_t temp_buff2[512];
static uint8_t temp_buff[256];

static const uint8_t DISPLAY_BUFF_START = 0;
static const uint8_t DISPLAY_BUFF_END = 31;
static const uint32_t MAX_STRING_LENGTH = 32;
static char str[MAX_STRING_LENGTH];


//*********************************************************************
void print_char(Max7219 *p_display, uint8_t position99, char c)
{
    uint8_t idx;
    uint8_t char_buff[6];
    uint8_t device;
    uint8_t wrap_device;
    uint8_t wrap_idx;
    uint8_t buff_start = position99;
    
    memcpy(char_buff, &(font_5x7[c - 0x20][0]), 6);

    if(position99 < 33)
    {
        //get device and device_position
        if(position99 > 8)
        {
            if(position99%8)
            {
                device = ((position99/8) + 1);
                position99 = position99%8;
            }
            else
            {
                device = position99/8;
                position99 = 8;
            }
        }
        else
        {
            device = 1;
        }
        //check for dispaly wrap around 
        //(moving to next 8x8 grid cause character doesn't fit on current one)
        if(position99 > 3)
        {
            wrap_idx = (9 - position99);
            if(device < 4)
            {
                wrap_device = (device + 1);
            }
            else
            {
                wrap_device = 1;
            }
        }
        else
        {
            wrap_idx = 6; //make bigger than idx, not used
            wrap_device = 0; //not used
        }
        //print character to position
        for(idx = 0; idx < 6; idx++)
        {
            //check for wrap
            if((idx >= wrap_idx)  && (device != 4))
            {
                p_display->write_digit(wrap_device, ((idx - wrap_idx) + 1), char_buff[idx]);
            }
            else
            {
                p_display->write_digit(device, (position99 + idx), char_buff[idx]);
            }
            buff_end = ((buff_start - 1) + idx);
            display_buff[buff_end] = char_buff[idx];
        }
    }
    else
    {
        for(idx = 0; idx < 6; idx++)
        {
            buff_end = ((buff_start - 1) + idx);
            display_buff[buff_end] = char_buff[idx];
        }
    }
}

//*********************************************************************
void print_string(Max7219 *p_display, uint8_t position, const char *s)
{
    uint8_t idx = 0;
    
    while(s[idx] != '\0')
    {
        print_char(p_display, (position + (idx*6)), s[idx]);
        idx++;
    } 
}

//*********************************************************************
void shift_display_right(Max7219 *p_display, uint8_t count, uint8_t ms_delay)
{
    uint16_t idx, idy;
    uint8_t position99;
    
    for(idx = 0; idx < count; idx++)
    {
        for(idy = 0; idy < (buff_end + 1); idy++)
        {
            if(idy == buff_end)
            {
                temp_buff[0] = display_buff[idy];
            }
            else
            {
                temp_buff[idy + 1] = display_buff[idy];
            }
        }
        for(idy = 0; idy < (buff_end + 1); idy++)
        {
            //save shifted display in buffer
            display_buff[idy] = temp_buff[idy];
            if(idy <= DISPLAY_BUFF_END)
            {
                position99 = ((idy - DISPLAY_BUFF_START) + 1);
                if(position99 > 24)
                {
                    if(position99 % 8)
                    {
                        position99 = position99  % 8;
                    }
                    else
                    {
                         position99 = 8;
                    }
                    p_display->write_digit(4, position99, display_buff[idy]);
                }
                else if(position99 > 16)
                {
                    if(position99 % 8)
                    {
                        position99 = position99  % 8;
                    }
                    else
                    {
                         position99 = 8;
                    }
                    p_display->write_digit(3, position99, display_buff[idy]);
                }
                else if(position99 > 8)
                {
                    if(position99 % 8)
                    {
                        position99 = position99  % 8;
                    }
                    else
                    {
                        position99 = 8;
                    }
                    p_display->write_digit(2, position99, display_buff[idy]);
                }
                else
                {
                    p_display->write_digit(1, position99, display_buff[idy]);
                }
            }
        }
        wait_ms(ms_delay);
    }
}

//*********************************************************************
void shift_display_left(Max7219 *p_display, uint8_t count, uint8_t ms_delay)
{
    uint16_t idx, idy;
    uint8_t position99;
    
    for(idx = 0; idx < count; idx++)
    {
        for(idy = 0; idy < (buff_end + 1); idy++)
        {
            if(idy == 0)
            {
                temp_buff[buff_end] = display_buff[idy];
            }
            else
            {
                temp_buff[idy - 1] = display_buff[idy];
            }
        }
        for(idy = 0; idy < (buff_end + 1); idy++)
        {
            //save shifted display in buffer
            display_buff[idy] = temp_buff[idy];
            if(idy <= DISPLAY_BUFF_END)
            {
                position99 = ((idy - DISPLAY_BUFF_START) + 1);
                if(position99 > 24)
                {
                    if(position99 % 8)
                    {
                        position99 = position99  % 8;
                    }
                    else
                    {
                         position99 = 8;
                    }
                    p_display->write_digit(4, position99, display_buff[idy]);
                }
                else if(position99 > 16)
                {
                    if(position99 % 8)
                    {
                        position99 = position99  % 8;
                    }
                    else
                    {
                         position99 = 8;
                    }
                    p_display->write_digit(3, position99, display_buff[idy]);
                }
                else if(position99 > 8)
                {
                    if(position99 % 8)
                    {
                        position99 = position99  % 8;
                    }
                    else
                    {
                        position99 = 8;
                    }
                    p_display->write_digit(2, position99, display_buff[idy]);
                }
                else
                {
                    p_display->write_digit(1, position99, display_buff[idy]);
                }
            }
        }
        wait_ms(ms_delay);
    }
}


//*********************************************************************
void quad_all_on(Max7219 *p_display, uint8_t quad)
{
    if(quad > 1)
    {
        for(uint8_t idx = 0; idx < 8; idx++)
        {
            display_buff[((quad - 1)*8) + DISPLAY_BUFF_START + idx] = 0xFF;
        }
    }
    else
    {
        for(uint8_t idx = 0; idx < 8; idx++)
        {
            display_buff[idx + DISPLAY_BUFF_START] = 0xFF;
        }
    }
    if(buff_end < (quad * 8))
    {
        buff_end = (quad * 8);
    }
    p_display->device_all_on(quad);
}

//*********************************************************************
void quad_all_off(Max7219 *p_display, uint8_t quad)
{
    if(quad > 1)
    {
        for(uint8_t idx = 0; idx < 8; idx++)
        {
            display_buff[((quad - 1)*8) + DISPLAY_BUFF_START + idx] = 0;
        }
    }
    else
    {
        for(uint8_t idx = 0; idx < 8; idx++)
        {
            display_buff[idx + DISPLAY_BUFF_START] = 0;
        }
    }

    //is buff_end in the quad?
    if((((quad - 1) * 8) < buff_end) && ((quad * 8) > buff_end))
    {
        buff_end = ((quad - 1) * 8);
    }
    //leave it alone otherwise
    p_display->device_all_off(quad);
}

//*********************************************************************
void all_on(Max7219 *p_display)
{
    for(uint16_t idx = 0; idx < 32; idx++)
    {
        display_buff[idx] = 0xFF;
    }
    if(buff_end < 32)
    {
        buff_end = 32;
    }
    p_display->display_all_on();
}

//*********************************************************************
void all_off(Max7219 *p_display)
{
    for(uint16_t idx = 0; idx < 32; idx++)
    {
        display_buff[idx] = 0;
    }
    if(buff_end < 32)
    {
        buff_end = 0;
    }
    p_display->display_all_off();
}

//*********************************************************************
void demo(Max7219 *display, max7219_configuration_t display_config, bool endless_loop)
{
    uint8_t position = 1;
    uint8_t idx = 0;
    do
    {
        all_off(display);
        if(position > 25)
        {
            position = 1;
        }
        printf("\nPosition = %d\n", position);
        for(idx = 0x20; idx < 0x7F; idx++)
        {
            print_char(display, position, (char) idx);
            wait(0.25);
        }
        position = (position + 8);
        all_on(display);
        for(idx = 0; idx < 16; idx++)
        {
            display_config.intensity = 15 - idx;
            display->init_display(display_config);
            wait_ms(50);
        } 
        for(idx = 0; idx < 16; idx++)
        {
            display_config.intensity = idx;
            display->init_display(display_config);
            wait_ms(100);
        } 
        wait_ms(100);
        all_off(display);
        wait_ms(100);
        
        quad_all_on(display, 1);
        wait_ms(500);
        shift_display_right(display, 32, 100);
        shift_display_left(display, 32, 100);
        all_off(display);
        wait_ms(100);
        
        print_string(display, 1, "Maxim");
        wait_ms(100);
        shift_display_right(display, 32, 100);
        shift_display_left(display, 32, 100);
        wait_ms(100);
    }
    while(endless_loop);
}

//*********************************************************************
void endless_scroll_display(Max7219 *display, uint32_t scroll_right)
{
    if(scroll_right)
    {
        printf("\nScrolling Right\n");
        while(1)
        {
            shift_display_right(display, 1, 100);
        }
    }
    else
    {
        printf("\nScrolling Left\n");
        while(1)
        {
            shift_display_left(display, 1, 100);
        }
    }
}

/********************************************************************/
void get_16x16_character(char c, uint8_t *char_buff, uint8_t font_type)
{
    uint8_t idx;
    
    switch(font_type)
    {
        case 1: // Use 16x16 Aerial bold font
                for(idx = 0; idx < 32; idx++) 
                {
                    //Get byte of char from map & store in buffer
                    char_buff[idx] = Aerial_bold_font_16x16[c - 0x20][idx];
                }
                break; 
        case 2: // Use For 16x16 manual font 
                for(idx = 0; idx < 32; idx++) 
                {
                    //Get byte of char from map & store in buffer
                    char_buff[idx] = Manual_font_16x16[c - 0x20][idx];
                }
                break;
        default : //Use 16x16 Aerial bold font
                for(idx = 0; idx < 32; idx++) 
                {
                    //Get byte of char from map & store in buffer
                    char_buff[idx] = Aerial_bold_font_16x16[c - 0x20][idx];
                }
                break; 
    } //end of switch       
}

void print_char_16x16(Max7219 *p_display, uint16_t position, char c, uint8_t font_type)
{
   
    uint8_t idx,device;
    uint8_t char_buff[32]; 
    uint16_t buff_start = position;
    
    get_16x16_character(c, char_buff,font_type);
    //Write bit map data to display device and store it in buffer 
    for(device = 1; device < 5; device++)
    {
        for(idx = 0; idx < 8; idx++)
        {
            p_display->write_digit(device, (idx+1), char_buff[idx + ( device - 1) * 8]); 
            //Get index for display buffer, keeps image of display for shifting
            buff_end = (device - 1) * 8 + idx + buff_start;
            //Wrap buffer back around 
            if(buff_end > 1023)
            {
                buff_end -= 1023;
            }
            display_buff[buff_end] = char_buff[idx + ( device - 1) * 8];
         } 
    }
    buff_end +=1;
    //Arrange single character data in buffers as upper and lower row   
    for(idx = 0;idx < 16; idx++)
    {
        disp_buff1[idx] = display_buff[idx];
        disp_buff2[idx] = display_buff[idx+16];
    }
}

void print_string_16x16(Max7219 *p_display, char *s,uint8_t font_type)
{
    uint16_t idx1=0,idy1=0;
    
    while(s[idx1] != '\0')
    {
        print_char_16x16(p_display, (idx1 * 32), s[idx1], font_type);
        idx1++;
        wait_ms(200);
    } 
    //Arrange character data in upper and lower row data 
    for (idy1=0; idy1 < (buff_end/32); idy1++)
    {
        for(idx1 = 0; idx1 < 16; idx1++)
        {
            disp_buff1[idx1 + (16 * idy1)] = display_buff[idx1 + (32 * idy1)];
            disp_buff2[idx1 + (16 * idy1)] = display_buff[idx1 + 16 + (32 * idy1)];
        }
    }
    // Clear buffer for next iteration
    for(idx1 = 0; idx1 < 1024; idx1++)
    display_buff[idx1] = 0;
}

//*********************************************************************
void shift_display_right_16x16(Max7219 *p_display, uint8_t count, uint8_t delay)
{
    uint16_t idx1, idy1;
    uint8_t position,device;
                     
    for(idx1 = 0; idx1 < count; idx1++)
    {
        // Right shift data in display buffer 1 & 2  
        for(idy1 = 0; idy1 < buff_end/2; idy1++)
        {
            if(idy1 == ((buff_end/2)-1))
            {
                temp_buff1[0] = disp_buff1[(buff_end/2) - 1];
                temp_buff2[0] = disp_buff2[(buff_end/2) - 1];
            }
            else 
            {
                temp_buff1[idy1 + 1] = disp_buff1[idy1];
                temp_buff2[idy1 + 1] = disp_buff2[idy1];
            }
        }
        // Save shifted data in the display buffer 1 & 2
        for(idy1 = 0; idy1 < buff_end/2; idy1++) 
        { 
            disp_buff1[idy1] = temp_buff1[idy1]; 
            disp_buff2[idy1] = temp_buff2[idy1]; 
        }
        for(idy1 = 0; idy1 < 16; idy1++) 
        {
            display_buff_16x16[idy1] = disp_buff1[idy1];
            display_buff_16x16[idy1 + 16] = disp_buff2[idy1];
        }
        position = 0; 
        for(device = 1; device < 5; device++)
        {
            for(idy1 = 0; idy1 < 8; idy1++)
            {
                p_display->write_digit(device, (idy1 + 1), display_buff_16x16[idy1 + position]); 
            }
            position+= 8; 
        } 
        wait_ms(delay);  
    }
}

//*********************************************************************
void shift_display_left_16x16(Max7219 *p_display, uint8_t count, uint8_t delay)
{
    uint16_t idx1,idy1;
    uint8_t position,device;
    
    for(idx1 = 0; idx1 < count; idx1++)
    {
        // Left shift data in display buffer 1 & 2  
        for(idy1 = 0; idy1 < buff_end/2; idy1++)
        {
            if(idy1 == 0)
            {
                temp_buff1[(buff_end/2) - 1] = disp_buff1[idy1];
                temp_buff2[(buff_end/2) - 1] = disp_buff2[idy1];
            }
            else 
            {
                temp_buff1[idy1 - 1] = disp_buff1[idy1];
                temp_buff2[idy1 - 1] = disp_buff2[idy1];
            }
        }
        // Save shifted data in the display buffer 1 & 2 
        for(idy1 = 0; idy1 < buff_end/2; idy1++) 
        { 
            disp_buff1[idy1] = temp_buff1[idy1]; 
            disp_buff2[idy1] = temp_buff2[idy1]; 
        }
        for(idy1 = 0; idy1 < 16; idy1++) 
        {
            display_buff_16x16[idy1] = disp_buff1[idy1];
            display_buff_16x16[idy1 + 16] = disp_buff2[idy1];  
        }
        position = 0; 
        for(device = 1; device < 5; device++)
        {
            for(idy1 = 0; idy1 < 8; idy1++)
            {
                p_display->write_digit(device, (idy1+1), display_buff_16x16[idy1 + position]); 
            }
            position+= 8; 
        }
    wait_ms(delay);
    }
}

//*********************************************************************
void demo_16x16(Max7219 *display, max7219_configuration_t display_config, uint8_t font_type, bool endless_loop)
{
    uint8_t index = 0;
    
    do
    {
        all_off(display);
        for(index = 0x20; index < 0x7F; index++)
        {
            print_char_16x16(display, 0, (char) index, font_type);
            wait(0.25);
        }
        all_on(display);
        for(index = 0; index < 16; index++)
        {
            display_config.intensity = 15 - index;
            display->init_display(display_config);
            wait_ms(50);
        } 
        for(index = 0; index < 16; index++)
        {
            display_config.intensity = index;
            display->init_display(display_config);
            wait_ms(100);
        } 
        wait_ms(100);
        all_off(display);
        wait_ms(100);
        
        all_on(display);
        wait_ms(500);
        // Display character then shift right and left
        print_char_16x16(display, 0, 'A', font_type);
        wait_ms(500);
        shift_display_right_16x16(display, 32, 100);
        shift_display_left_16x16(display, 32, 100);
        all_off(display);
        wait_ms(100);
        // Display string then shift right and left
        print_string_16x16(display, "Maxim", font_type);
        wait_ms(500);
        shift_display_right_16x16(display, 32, 100);
        shift_display_left_16x16(display, 32, 100);
        wait_ms(100);
    }
    while(endless_loop);
}

//*********************************************************************
void endless_scroll_display_16x16(Max7219 *display, uint32_t scroll_right)
{
    if(scroll_right)
    {
        printf("\nScrolling Right\n");
        while(1)
        {
            shift_display_right_16x16(display, 1, 100);
        }
    }
    else
    {
        printf("\nScrolling Left\n");
        while(1)
        {
            shift_display_left_16x16(display, 1, 100);
        }
    }
}

//*********************************************************************
uint32_t print_menu(void)
{
    uint32_t user_input;
    
    printf("\nPlease select an option below:\n");
    printf("%t1. Select font\n");
    printf("%t2. Set Brightness\n");
    printf("%t3. Print a character to given position\n");
    printf("%t4. Print a string to position\n");
    printf("%t5. Shift display given number of position and direction\n"); 
    printf("%t6. Clear display\n");
    printf("%t7. Run the Demo Routine\n");
    printf("%t8. Scroll Display In Endless Loop, left or right\n");
    printf("%t9. Quit\n\n");
    
    user_input = get_user_input(NULL, 9);
    
    return(user_input);
}

//*********************************************************************
uint32_t get_user_input(char *msg, uint32_t max_val)
{
    uint32_t user_input;
    
    do
    {
        printf(msg);
        
        //get user input
        fgets(str, MAX_STRING_LENGTH, stdin);
               
        //Remove trailing newline and CR, if there.
        if((strlen(str) > 0 ) && (str[strlen(str) - 1] == 0x0A) && (str[strlen(str) - 2] == 0x0D))
        {
            str[strlen(str) - 1] = '\0';
            str[strlen(str) - 1] = '\0';
        }
        user_input = strtoul(str, NULL, 0);
        printf("\nYou entered = %d\n", user_input);
        
        if(user_input > max_val)
        {
            printf("\nOut of range\n");
        }
    }
    while(user_input > max_val);
    
    return(user_input);
}

//*********************************************************************
char get_user_char(char *msg)
{
    
    do
    {
        printf(msg);
        
        //get user input
        fflush(stdin);
        fgets(str, 4, stdin);
        fflush(stdin);
        //Remove trailing newline and CR, if there.
        if((strlen(str) > 0 ) && (str[strlen(str) - 1] == 0x0A) && (str[strlen(str) - 2] == 0x0D))
        {
            str[strlen(str) - 1] = '\0';
            str[strlen(str) - 1] = '\0';
        }
        
        printf("\nYou entered = %c\n", str[0]);
        
        if((str[0] < 0x20) || (str[0] > 0x7E))
        {
            printf("\nOut of range\n");
        }
    }
    while((str[0] < 0x20) || (str[0] > 0x7E));
    
    return(str[0]);
}


//*********************************************************************
char * get_user_string(char *msg)
{
    printf(msg);
    //get user input
    fgets(str, MAX_STRING_LENGTH, stdin);
    //Remove trailing newline and CR, if there.
    if((strlen(str) > 0 ) && (str[strlen(str) - 1] == 0x0A) && (str[strlen(str) - 2] == 0x0D))
    {
        str[strlen(str) - 1] = '\0';
        str[strlen(str) - 1] = '\0';
    }
    
    return(str);
}


void clear_buffer(void)
{
    buff_end = 0;
    
    for(uint16_t idx = 0; idx < 256; idx++)
    {
        display_buff[idx] = 0;
    }
}
