/***********************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
**********************************************************************/


#include "mbed.h"
#include "ds3231.h"
#include "maxrefdes99.h"
#include <string>


void set_rtc(Ds3231 & rtc);


int main(void)
{
    //rtc object
    Ds3231 rtc(D14, D15); 
    
    set_rtc(rtc);
    
    Max7219 display(D11, D12, D13, D10);
    
    //struct for holding MAX7219 configuration data
    max7219_configuration_t display_config;
    
    //configuration data
    display_config.decode_mode = 0; //no BCD decode
    display_config.intensity = 0x0F; //max intensity
    display_config.scan_limit = 0x07; //scan all digits
    
    //set number of MAX7219 devices being used
    display.set_num_devices(4);
    
    //config display 
    display.init_display(display_config);
    
    //ensure all data registers are 0
    display.display_all_off();
    
    display.enable_display();
    
    time_t epoch_time;
    string str;
    char time_buff[32];
    
    for(;;)
    {   
        //get epoch time from rtc
        epoch_time = rtc.get_epoch();
        
        //format time
        strftime(time_buff, 32, "%a %b %d %Y %I:%M %p", localtime(&epoch_time));
        
        //assign to str
        str.assign(time_buff);
        
        //find '\n' and remove it
        if(str.find('\n') != std::string::npos)
        {
            str.erase(str.find('\n'));
        }
        
        //append spaces to the end
        str.append("     ");
        
        //print to display
        print_string(&display, 33, str.c_str());
        
        //shift the display the appropriate number of positions
        //1 char is 6 columns wide
        shift_display_left(&display, (str.length()*6), 150);
        
        //clear the display
        all_off(&display);
        
        //clears all data in buffer 
        clear_buffer();
        
        wait(0.5);
    }
}


//*********************************************************************
void set_rtc(Ds3231 & rtc)
{
    //default, use bit masks in ds3231.h for desired operation
    ds3231_cntl_stat_t rtc_control_status = {0,0}; 
    ds3231_time_t rtc_time;
    ds3231_calendar_t rtc_calendar;
    
    rtc.set_cntl_stat_reg(rtc_control_status);
    
    //get day from user
    rtc_calendar.day = get_user_input("\nPlease enter day of week, 1 for Sunday (1-7): ", 7);
 
    //get day of month from user
    rtc_calendar.date = get_user_input("\nPlease enter day of month (1-31): ", 31);
 
    //get month from user
    rtc_calendar.month = get_user_input("\nPlease enter the month, 1 for January (1-12): ", 12);
 
    //get year from user
    rtc_calendar.year = get_user_input("\nPlease enter the year (0-99): ", 99);
      
    //Get time mode
    rtc_time.mode = get_user_input("\nWhat time mode? 1 for 12hr 0 for 24hr: ", 1);  
    
    if(rtc_time.mode)
    {
        //Get AM/PM status
        rtc_time.am_pm = get_user_input("\nIs it AM or PM? 0 for AM 1 for PM: ", 1);  
        //Get hour from user
        rtc_time.hours = get_user_input("\nPlease enter the hour (1-12): ", 12);
    }
    else
    {
        //Get hour from user
        rtc_time.hours = get_user_input("\nPlease enter the hour (0-23): ", 23);
    }
     
    //Get minutes from user
    rtc_time.minutes = get_user_input("\nPlease enter the minute (0-59): ", 59);
    
    
    //Get seconds from user
    rtc_time.seconds = get_user_input("\nPlease enter the second (0-59): ", 59);
    
    rtc.set_time(rtc_time);
    rtc.set_calendar(rtc_calendar);
}
    
   
