/**********************************************************************
* Copyright (C) 2015 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
**********************************************************************/


#include "mbed.h"
#include "max14871_shield.h"

template <typename T>
static inline void REPORT (T set, T get)
{
    const char *resp = (set == get) ? "Pass" : "Fail";
    printf("%08d: %s\n", __LINE__, resp);
}

float float_status = 0.0f;
Max14871_Shield::max14871_current_regulation_mode_t reg_mode_status = Max14871_Shield::TCOFF_SLOW_EXTERNAL_REF;
Max14871_Shield::max14871_operating_mode_t op_mode_status = Max14871_Shield::FORWARD;

int main(void)
{

    uint8_t idx = 0;
    const uint8_t DELAY = 50;
    const float VREF = 2.0f;
    const float PWM_PERIOD = 0.000025f; //40KHz
    float pwm_duty_cycle = 0.0f;

    puts("Starting Test");
    Max14871_Shield shld(D14, D15, true);

    Max14871_Shield::max14871_motor_driver_t MD_ARRAY[] = {Max14871_Shield::MD1, Max14871_Shield::MD2,
            Max14871_Shield::MD3, Max14871_Shield::MD4
                                                          };

    //configure motor drivers
    for(idx = 0; idx < 4; idx++) {
        shld.set_pwm_duty_cycle(MD_ARRAY[idx], pwm_duty_cycle);
        float_status = shld.get_pwm_duty_cycle(MD_ARRAY[idx]);
        REPORT(pwm_duty_cycle, float_status);

        shld.set_pwm_period(MD_ARRAY[idx], PWM_PERIOD);
        // no get pwm_period method
        float_status = shld.get_pwm_period(MD_ARRAY[idx]);
        REPORT(PWM_PERIOD, float_status);

        shld.set_current_regulation_mode(MD_ARRAY[idx], Max14871_Shield::RIPPLE_25_EXTERNAL_REF, VREF);
        reg_mode_status = shld.get_current_regulation_mode(MD_ARRAY[idx]);
        REPORT(Max14871_Shield::RIPPLE_25_EXTERNAL_REF, reg_mode_status);

        shld.set_operating_mode(MD_ARRAY[idx], Max14871_Shield::BRAKE);
        op_mode_status = shld.get_operating_mode(MD_ARRAY[idx]);
        REPORT(Max14871_Shield::BRAKE, op_mode_status);
    }

    for(idx = 0; idx < 4; idx++) {
        shld.set_operating_mode(MD_ARRAY[idx], Max14871_Shield::FORWARD);
        op_mode_status = shld.get_operating_mode(MD_ARRAY[idx]);
        REPORT(Max14871_Shield::FORWARD, op_mode_status);

        //Ramp up
        printf("Ramping up Forward, MD = %d\n", MD_ARRAY[idx]);
        for(pwm_duty_cycle = 0.0f; pwm_duty_cycle < 1.0f; pwm_duty_cycle += 0.1f) {
            printf("Duty Cycle = %0.2f\n", pwm_duty_cycle);
            shld.set_pwm_duty_cycle(MD_ARRAY[idx], pwm_duty_cycle);
            float_status = shld.get_pwm_duty_cycle(MD_ARRAY[idx]);
            REPORT(pwm_duty_cycle, float_status);
            wait_ms(DELAY);
        }

        //100% duty cycle
        printf("Duty Cycle = %0.2f\n", pwm_duty_cycle);
        shld.set_pwm_duty_cycle(MD_ARRAY[idx], pwm_duty_cycle);
        float_status = shld.get_pwm_duty_cycle(MD_ARRAY[idx]);
        REPORT(pwm_duty_cycle, float_status);
        wait_ms(DELAY);

        //Ramp down
        printf("Ramping down Forward, MD = %d\n", MD_ARRAY[idx]);
        for(pwm_duty_cycle = 1.0f; pwm_duty_cycle > 0.0f; pwm_duty_cycle -= 0.1f) {
            printf("Duty Cycle = %0.2f\n", pwm_duty_cycle);
            shld.set_pwm_duty_cycle(MD_ARRAY[idx], pwm_duty_cycle);
            float_status = shld.get_pwm_duty_cycle(MD_ARRAY[idx]);
            REPORT(pwm_duty_cycle, float_status);
            wait_ms(DELAY);
        }

        //0% duty cycle
        printf("Duty Cycle = %0.2f\n", pwm_duty_cycle);
        shld.set_pwm_duty_cycle(MD_ARRAY[idx], pwm_duty_cycle);
        float_status = shld.get_pwm_duty_cycle(MD_ARRAY[idx]);
        REPORT(pwm_duty_cycle, float_status);
        wait_ms(DELAY);

        shld.set_operating_mode(MD_ARRAY[idx], Max14871_Shield::REVERSE);
        op_mode_status = shld.get_operating_mode(MD_ARRAY[idx]);
        REPORT(Max14871_Shield::REVERSE, op_mode_status);

        //Ramp up
        printf("Ramping up Reverse, MD = %d\n", MD_ARRAY[idx]);
        for(pwm_duty_cycle = 0.0f; pwm_duty_cycle < 1.0f; pwm_duty_cycle += 0.1f) {
            printf("Duty Cycle = %0.2f\n", pwm_duty_cycle);
            shld.set_pwm_duty_cycle(MD_ARRAY[idx], pwm_duty_cycle);
            float_status = shld.get_pwm_duty_cycle(MD_ARRAY[idx]);
            REPORT(pwm_duty_cycle, float_status);
            wait_ms(DELAY);
        }

        //100% duty cycle
        printf("Duty Cycle = %0.2f\n", pwm_duty_cycle);
        shld.set_pwm_duty_cycle(MD_ARRAY[idx], pwm_duty_cycle);
        float_status = shld.get_pwm_duty_cycle(MD_ARRAY[idx]);
        REPORT(pwm_duty_cycle, float_status);
        wait_ms(DELAY);

        //Ramp down
        printf("Ramping down Reverse, MD = %d\n", MD_ARRAY[idx]);
        for(pwm_duty_cycle = 1.0f; pwm_duty_cycle > 0.0f; pwm_duty_cycle -= 0.1f) {
            printf("Duty Cycle = %0.2f\n", pwm_duty_cycle);
            shld.set_pwm_duty_cycle(MD_ARRAY[idx], pwm_duty_cycle);
            float_status = shld.get_pwm_duty_cycle(MD_ARRAY[idx]);
            REPORT(pwm_duty_cycle, float_status);
            wait_ms(DELAY);
        }

        //0% duty cycle
        printf("Duty Cycle = %0.2f\n", pwm_duty_cycle);
        shld.set_pwm_duty_cycle(MD_ARRAY[idx], pwm_duty_cycle);
        float_status = shld.get_pwm_duty_cycle(MD_ARRAY[idx]);
        REPORT(pwm_duty_cycle, float_status);
        wait_ms(DELAY);

        shld.set_operating_mode(MD_ARRAY[idx], Max14871_Shield::COAST);
        op_mode_status = shld.get_operating_mode(MD_ARRAY[idx]);
        REPORT(Max14871_Shield::COAST, op_mode_status);
    }

    return 0;
}
