/*******************************************************************************
* Copyright (C) Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************/

#include <string>
#include "DisplayIdWindow.hpp"
#include "InitWindow.hpp"
#include "MakeFunction.hpp"
#include "Text.hpp"
#include "WifiConnectWindow.hpp"
#include "WindowManager.hpp"

extern std::string webId;

DisplayIdWindow::DisplayIdWindow(Mode mode) {
  backButton.setParent(this);
  backButton.setText("Back");
  backButton.setClickedHandler(
      makeFunction(this, &DisplayIdWindow::backButtonClicked));
  switch (mode) {
  case PreConnectMode:
    continueButton.setParent(this);
    continueButton.setText("Continue");
    continueButton.setClickedHandler(
        makeFunction(this, &DisplayIdWindow::continueButtonClicked));
    continueButton.setFocused();
    break;

  case PopupMode:
    backButton.setFocused();
    break;
  }
}

void DisplayIdWindow::doRender(Bitmap & bitmap, int xOffset,
                               int yOffset) const {
  Text description;
  description.setText("Web ID: " + webId);
  description.setWordWrap(true);
  description.resize(width(), height());
  description.render(bitmap, xOffset + x(), yOffset + y());
  Window::doRender(bitmap, xOffset, yOffset);
}

void DisplayIdWindow::resized() {
  backButton.resize(backButton.preferredWidth(),
                    backButton.preferredHeight());
  backButton.move(0, height() - backButton.height());
  continueButton.resize(continueButton.preferredWidth(),
                        continueButton.preferredHeight());
  continueButton.move(width() - continueButton.width(),
                      height() - continueButton.height());
}

bool DisplayIdWindow::doProcessKey(Key key) {
  bool handled;
  switch (key) {
  case LeftKey:
    backButton.setFocused();
    handled = true;
    break;

  case RightKey:
    continueButton.setFocused();
    handled = true;
    break;

  default:
    handled = false;
    break;
  }
  return handled;
}

void DisplayIdWindow::backButtonClicked(Button *) {
  if (windowManager()) {
    windowManager()->pop();
    if (continueButton.parent()) {
      std::auto_ptr<Window> window(new InitWindow(InitWindow::MenuMode));
      windowManager()->push(window);
    }
  }
}

void DisplayIdWindow::continueButtonClicked(Button *) {
  if (windowManager()) {
    windowManager()->pop();
    std::auto_ptr<Window> window(new WifiConnectWindow);
    windowManager()->push(window);
  }
}
