/*******************************************************************************
* Copyright (C) Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************/

#include "Display.hpp"

/// @{
/// Width and height of the display in pixels.
static const int width = 128;
static const int height = 64;
/// @}

Display::Display(PinName mosi, PinName miso, PinName sclk, PinName ssel,
                 PinName a0)
    : canvas_(width, height), spi(mosi, miso, sclk), cs(ssel, 1), a0(a0, 0) {
  spi.format(8, 3); // CPOL = 1, CPHA = 1
}

void Display::initialize() {
  sendCommand(0xA0);
  sendCommand(0xAE);
  sendCommand(0xC0);
  sendCommand(0xA2);
  sendCommand(0x2F);
  sendCommand(0x26);
  sendCommand(0x81);
  sendCommand(0x11);
  sendCommand(0xAF);
}

void Display::update() {
  const int rowsPerPage = 8;
  const int pages = height / rowsPerPage;
  sendCommand(0xAE);
  sendCommand(0x40);
  for (int page = 0; page < pages; ++page) {
    sendCommand(0xB0 + page);
    sendCommand(0x10);
    sendCommand(0x00);
    for (int column = 0; column < width; ++column) {
      uint8_t segment = 0;
      for (int pixel = 0; pixel < rowsPerPage; ++pixel) {
        segment <<= 1;
        if (canvas_.pixelEnabled(column,
                                 ((pages - 1 - page) * rowsPerPage) + pixel)) {
          segment |= 1;
        }
      }
      sendData(segment);
    }
  }
  sendCommand(0xAF);
}

void Display::sendCommand(uint8_t command) {
  cs = 0;
  a0 = 0;
  spi.write(command);
  cs = 1;
}

void Display::sendData(uint8_t data) {
  cs = 0;
  a0 = 1;
  spi.write(data);
  cs = 1;
}
