/*******************************************************************************
* Copyright (C) Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************/

#ifndef WINDOWMANAGER_HPP
#define WINDOWMANAGER_HPP

#include <memory>
#include <vector>
#include "Keys.hpp"
#include "Window.hpp"

class Bitmap;

/// Stack based window manager.
class WindowManager {
public:
  /// @param canvas Canvas to use for rendering.
  WindowManager(Bitmap & canvas) : canvas(canvas) {}

  ~WindowManager();

  /// @brief Push a window onto the top of the stack.
  /// @details The operation will be queued until the next update.
  /// @param window
  /// Heap allocated object that WindowManager will take ownership of.
  void push(std::auto_ptr<Window> & window);

  /// @brief Pop a window from the top of the stack.
  /// @details
  /// The operation will be queued until the next update. The popped window
  /// will be deleted.
  void pop();

  /// @brief Updates all windows and redraws the top window if invalid.
  /// @returns True if the canvas has been updated.
  bool update();

  /// Forwards a key-press input event to the top window for processing.
  void processKey(Key key);

private:
  void processAction(Window * window);

  Bitmap & canvas;
  std::vector<Window *> windowStack;
  std::vector<Window *> actionQueue;

  // Uncopyable
  WindowManager(const WindowManager &);
  const WindowManager & operator=(const WindowManager &);
};

#endif
