/*******************************************************************************
* Copyright (C) Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************/

#include <MaximInterfaceDevices/DS28C36_DS2476.hpp>
#include "ErrorWindow.hpp"
#include "Factory.hpp"
#include "HardwareTestWindow.hpp"
#include "SensorNode.hpp"
#include "WindowManager.hpp"

extern MaximInterfaceDevices::DS2476 coproc;
extern SensorNode sensorNode;

HardwareTestWindow::HardwareTestWindow() {
  setState(LeftClickKeyTest);
  prompt.setParent(this);
  prompt.setWordWrap(true);
}

void HardwareTestWindow::resized() { prompt.resize(width(), height()); }

void HardwareTestWindow::updated() {
  switch (state) {
  case CoprocessorTest:
    if (provisionCoprocessor(coproc)) {
      setState(AuthenticatorTest);
    } else {
      if (windowManager()) {
        std::auto_ptr<Window> window(
            new ErrorWindow("Failed to provision DS2476"));
        windowManager()->push(window);
      }
    }
    break;

  case AuthenticatorTest: {
    if (!provisionAuthenticator(sensorNode.ds28c36)) {
      if (windowManager()) {
        std::auto_ptr<Window> window(
            new ErrorWindow("Failed to provision DS28C36"));
        windowManager()->push(window);
      }
      break;
    }

    const SensorNode::State state = sensorNode.detect();
    if (!(state == SensorNode::ValidLaserDisabled ||
          state == SensorNode::ValidLaserEnabled)) {
      if (windowManager()) {
        std::auto_ptr<Window> window(
            new ErrorWindow("Failed to authenticate DS28C36"));
        windowManager()->push(window);
      }
      break;
    }

    setState(LaserDisabledTest);
    break;
  }

  case LaserEnabledTest:
    if (!sensorNode.setLaserEnabled(true)) {
      if (windowManager()) {
        std::auto_ptr<Window> window(
            new ErrorWindow("Failed to set laser enabled"));
        windowManager()->push(window);
      }
    }
    break;

  case TempSensorTest: {
    const MaximInterfaceCore::Result<double> ambientTemp =
        sensorNode.readTemp(SensorNode::AmbientTemp);
    if (ambientTemp && ambientTemp.value() >= 0.0 &&
        ambientTemp.value() <= 50.0) {
      setState(ResetKeyTest);
    } else {
      if (windowManager()) {
        std::auto_ptr<Window> window(
            new ErrorWindow("Failed to read valid ambient temperature"));
        windowManager()->push(window);
      }
    }
    break;
  }

  default:
    break;
  }
}

bool HardwareTestWindow::doProcessKey(Key key) {
  switch (state) {
  case LeftClickKeyTest:
    if (key == LeftClickKey) {
      setState(RightClickKeyTest);
    }
    break;

  case RightClickKeyTest:
    if (key == RightClickKey) {
      setState(UpKeyTest);
    }
    break;

  case UpKeyTest:
    if (key == UpKey) {
      setState(DownKeyTest);
    }
    break;

  case DownKeyTest:
    if (key == DownKey) {
      setState(LeftKeyTest);
    }
    break;

  case LeftKeyTest:
    if (key == LeftKey) {
      setState(RightKeyTest);
    }
    break;

  case RightKeyTest:
    if (key == RightKey) {
      setState(CoprocessorTest);
    }
    break;

  case LaserDisabledTest:
    setState(LaserEnabledTest);
    break;

  case LaserEnabledTest:
    setState(TempSensorTest);
    break;

  default:
    break;
  }
  return true;
}

void HardwareTestWindow::setState(State state) {
  this->state = state;
  switch (state) {
  case LeftClickKeyTest:
    prompt.setText("Press \"Left Click\" key.");
    break;

  case RightClickKeyTest:
    prompt.setText("Press \"Right Click\" key.");
    break;

  case UpKeyTest:
    prompt.setText("Press \"Up\" key.");
    break;

  case DownKeyTest:
    prompt.setText("Press \"Down\" key.");
    break;

  case LeftKeyTest:
    prompt.setText("Press \"Left\" key.");
    break;

  case RightKeyTest:
    prompt.setText("Press \"Right\" key.");
    break;

  case CoprocessorTest:
    prompt.setText("Testing DS2476...");
    break;

  case AuthenticatorTest:
    prompt.setText("Testing DS28C36...");
    break;

  case LaserDisabledTest:
    prompt.setText("Ensure that green LED under laser is OFF. Press red button "
                   "and ensure that laser is OFF. Press any key to continue.");
    break;

  case LaserEnabledTest:
    prompt.setText("Ensure that green LED under laser is ON. Press red button "
                   "and ensure that laser is ON. Press any key to continue.");
    break;

  case TempSensorTest:
    prompt.setText("Testing temperature sensor...");
    break;

  case ResetKeyTest:
    prompt.setText("Press \"Reset\" key to complete test.");
    break;

  default:
    break;
  }
}
