/*******************************************************************************
* Copyright (C) Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************/

#ifndef DISPLAYIDWINDOW_HPP
#define DISPLAYIDWINDOW_HPP

#include "Button.hpp"
#include "Window.hpp"

/// @brief
/// Displays the Web ID of the device before connecting to Wi-Fi or later as a
/// pop-up window.
class DisplayIdWindow : public Window {
public:
  /// Mode of the window which controls appearance and behavior.
  enum Mode {
    /// Displays a continue button which takes user to WifiConnectWindow.
    PreConnectMode,

    /// Displays a return button that clears the pop-up.
    PopupMode
  };

  explicit DisplayIdWindow(Mode mode);

protected:
  virtual void resized();
  virtual void doRender(Bitmap & bitmap, int xOffset, int yOffset) const;
  virtual bool doProcessKey(Key key);

private:
  Button backButton;
  Button continueButton;

  void backButtonClicked(Button *);
  void continueButtonClicked(Button *);
};

#endif
