/*******************************************************************************
* Copyright (C) Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************/

#ifndef DISPLAY_HPP
#define DISPLAY_HPP

#include <stdint.h>
#include <mbed-os/drivers/DigitalOut.h>
#include <mbed-os/drivers/SPI.h>
#include "Bitmap.hpp"

/// Interface to the SPI LCD module.
class Display {
public:
  Display(PinName mosi, PinName miso, PinName sclk, PinName ssel, PinName a0);

  /// Initializes the display to a known configuration before other operations.
  void initialize();

  Bitmap & canvas() { return canvas_; }

  const Bitmap & canvas() const { return canvas_; }

  /// @brief Updates the display with the specified bitmap.
  /// @param canvas
  /// Bitmap to display which should typically match the width and height dimensions.
  void update();

private:
  Bitmap canvas_;
  mbed::SPI spi;
  mbed::DigitalOut cs;
  mbed::DigitalOut a0;

  void sendCommand(uint8_t command);
  void sendData(uint8_t data);
};

#endif
