/*******************************************************************************
* Copyright (C) Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************/

#ifndef BUTTON_HPP
#define BUTTON_HPP

#include <MaximInterfaceCore/Function.hpp>
#include "Graphic.hpp"
#include "Rectangle.hpp"
#include "Text.hpp"

/// Clickable button control with text label.
class Button : public Graphic {
public:
  typedef MaximInterfaceCore::Function<void(Button *)> EventHandler;

  Button();

  /// @name Text
  /// @brief Text label of the button.
  /// @{

  const std::string & text() const { return label.text(); }
  void setText(const std::string & text) { label.setText(text); }

  /// @}

  /// @name Word wrap
  /// @brief Enable or disable word wrapping on the label.
  /// @{

  bool wordWrap() const { return label.wordWrap(); }
  void setWordWrap(bool wordWrap) { label.setWordWrap(wordWrap); }

  /// @}

  /// @name Preferred width
  /// @note Depends on text and wordWrap properties. Call update to refresh.
  /// @{

  int preferredWidth() const;
  int preferredHeight() const;

  /// @}

  /// Set the event handler that is called when the button is clicked.
  void setClickedHandler(const EventHandler & clickedHandler) {
    this->clickedHandler = clickedHandler;
  }

protected:
  virtual void focusChanged(bool focused);
  virtual void resized();
  virtual bool doProcessKey(Key key);

private:
  Rectangle border;
  Text label;
  EventHandler clickedHandler;
};

#endif
