/*******************************************************************************
* Copyright (C) Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************/

#include <string>
#include <MaximInterfaceDevices/DS28C36_DS2476.hpp>
#include <MaximInterfaceMbed/I2CMaster.hpp>
#include <MaximInterfaceMbed/Sleep.hpp>
#include <mbed-os/drivers/DigitalIn.h>
#include <mbed-os/drivers/I2C.h>
#include "CC3100.hpp"
#include "Display.hpp"
#include "InitWindow.hpp"
#include "Keys.hpp"
#include "SensorNode.hpp"
#include "WindowManager.hpp"

static mbed::DigitalIn upButton(MBED_CONF_APP_UP_BUTTON_PIN);
static mbed::DigitalIn downButton(MBED_CONF_APP_DOWN_BUTTON_PIN);
static mbed::DigitalIn leftButton(MBED_CONF_APP_LEFT_BUTTON_PIN);
static mbed::DigitalIn rightButton(MBED_CONF_APP_RIGHT_BUTTON_PIN);
static mbed::DigitalIn leftClickButton(MBED_CONF_APP_LEFT_CLICK_BUTTON_PIN);
static mbed::DigitalIn rightClickButton(MBED_CONF_APP_RIGHT_CLICK_BUTTON_PIN);

static Display display(MBED_CONF_APP_DISPLAY_MOSI_PIN,
                       MBED_CONF_APP_DISPLAY_MISO_PIN,
                       MBED_CONF_APP_DISPLAY_SCLK_PIN,
                       MBED_CONF_APP_DISPLAY_SSEL_PIN,
                       MBED_CONF_APP_DISPLAY_A0_PIN);
static WindowManager windowManager(display.canvas());

static mbed::I2C mbedI2C(MBED_CONF_APP_SDA_PIN, MBED_CONF_APP_SCL_PIN);
static MaximInterfaceMbed::I2CMaster i2c(mbedI2C);
static MaximInterfaceMbed::Sleep sleep;
MaximInterfaceDevices::DS2476 coproc(sleep, i2c);
SensorNode sensorNode(sleep, i2c, coproc);

std::string webId;

static bool buttonPressed(mbed::DigitalIn & button);

int main() {
  mbedI2C.frequency(100000);
  display.initialize();
  // Set initial window.
  {
    std::auto_ptr<Window> window(new InitWindow(InitWindow::InitMode));
    windowManager.push(window);
  }
  while (true) {
    // Update window manager and redraw screen if necessary.
    if (windowManager.update()) {
      display.update();
    }
    // Update CC3100 Wi-Fi interface.
    CC3100::instance().update();
    // Check if any buttons are pressed.
    if (buttonPressed(leftClickButton)) {
      windowManager.processKey(LeftClickKey);
    } else if (buttonPressed(rightClickButton)) {
      windowManager.processKey(RightClickKey);
    } else if (buttonPressed(upButton)) {
      windowManager.processKey(UpKey);
    } else if (buttonPressed(downButton)) {
      windowManager.processKey(DownKey);
    } else if (buttonPressed(leftButton)) {
      windowManager.processKey(LeftKey);
    } else if (buttonPressed(rightButton)) {
      windowManager.processKey(RightKey);
    }
  }
}

/// @brief Checks if button is pressed and waits for release.
/// @param button Active low button to check.
/// @returns True if pressed.
static bool buttonPressed(mbed::DigitalIn & button) {
  const int buttonPressed = 0; // Active low
  if (button == buttonPressed) {
    while (button == buttonPressed)
      ;
    return true;
  }
  // else
  return false;
}
