/*******************************************************************************
* Copyright (C) Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************/

#ifndef INITWINDOW_HPP
#define INITWINDOW_HPP

#include "Button.hpp"
#include "Window.hpp"

/// Displays a welcome screen and optionally initializes the DS2476 and CC3100.
class InitWindow : public Window {
public:
  /// Mode of the window which controls appearance and behavior.
  enum Mode {
    /// Initializes the DS2476 and CC311 before displaying the menu.
    InitMode,

    /// Only displays the menu.
    MenuMode
  };

  explicit InitWindow(Mode mode);

protected:
  virtual void resized();
  virtual void updated();
  virtual void doRender(Bitmap & bitmap, int xOffset, int yOffset) const;
  virtual bool doProcessKey(Key key);

private:
  enum State {
    NotStarted, // Display the welcome screen before starting initialization.
    Running,    // Initialization performed here.
    Completed   // Display prompt to continue.
  };

  State state;
  Button startButton;
  Button hardwareTestButton;

  void startButtonClicked(Button *);
  void hardwareTestButtonClicked(Button *);
};

#endif
