/*******************************************************************************
* Copyright (C) Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************/

#ifndef TEXT_HPP
#define TEXT_HPP

#include <list>
#include <string>
#include "Graphic.hpp"

/// Text graphical primitive.
class Text : public Graphic {
public:
  Text();

  /// @name Text
  /// @brief Text string to display.
  /// @details
  /// Only printable ASCII characters and the line feed ('\n') will be displayed.
  /// @{

  const std::string & text() const { return text_; }
  void setText(const std::string & text);

  /// @}

  /// @name Word wrap
  /// @brief
  /// Lines will be wrapped when they are too long to be displayed with the
  /// current width.
  /// @{

  bool wordWrap() const { return wordWrap_; }
  void setWordWrap(bool wordWrap);

  /// @}

  /// @name Character spacing
  /// @brief Spacing in pixels between characters.
  /// @{

  int charSpacing() const { return charSpacing_; }
  void setCharSpacing(int charSpacing);

  /// @}

  /// @{
  /// Spacing in pixels between lines.
  int lineSpacing() const { return lineSpacing_; }
  void setLineSpacing(int lineSpacing);
  /// @}

  /// @brief Preferred width and height calculated after word wrapping.
  /// @{

  int preferredWidth() const;
  int preferredHeight() const;

  /// @}

protected:
  virtual void resized();
  virtual void doRender(Bitmap & bitmap, int xOffset, int yOffset) const;

private:
  void calculateLayout() const;

  std::string text_;
  bool wordWrap_;
  int charSpacing_;
  int lineSpacing_;

  mutable std::list<std::string> textLines_;
  mutable int preferredWidth_;
  mutable int preferredHeight_;
};

#endif
