/**********************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
**********************************************************************/


#include "maxrefdes131_demo.h"


//*********************************************************************
void print_rom_id(Serial & comms, RomId & romId)
{
    //print the rom number
    for(uint8_t idx = 0; idx < RomId::byteLen; idx++)
    {
        comms.printf("0x%2x ", romId[idx]);
    }
    comms.printf("\n");
}


//*********************************************************************
uint8_t init_sensor_state(OneWireMaster & owm, Serial & comms)
{
    OneWireMaster::CmdResult ow_result = owm.OWReset();
    SearchState search_state;
    MultidropRomIterator selector(owm);
    
    DS2413 * p_ow_switch;
    
    uint8_t num_sensors = 0;
    uint8_t num_sensors_old = 0;
    
    if(ow_result == OneWireMaster::Success)
    {
        /*this loop will run at least twice. Each time a branch is closed
          OWFirst is called in order to make sure all sensors are found.
          When num_sensors == num_sensors_old, all sensors should have been found
        */
        do
        {
            num_sensors_old = num_sensors;
            num_sensors = 0;
            
            ow_result = OWFirst(owm, search_state);
        
            while(ow_result == OneWireMaster::Success)
            {
                if(search_state.romId.familyCode() == OWGridEye::DS2413_FAMILY_CODE)
                {
                    num_sensors++;
                    
                    p_ow_switch = new DS2413(selector);
                    
                    p_ow_switch->setRomId(search_state.romId);
                    
                    p_ow_switch->pioAccessWriteChAB(0);
                    
                    delete p_ow_switch;
                }
                
                ow_result = OWNext(owm, search_state); 
            }
        }
        while(num_sensors > num_sensors_old);
        
        //Disconnect all branches and GridEYE sensors for proper enumeration
        if(num_sensors > 0)
        {
            //set all sensors to default state
            uint8_t write_val = 0xFD;
            uint8_t send_block[] = {0x5A, write_val, ~write_val};
            
            ow_result = OWSkipRom(owm);
            if(ow_result == OneWireMaster::Success)
            {
                ow_result = owm.OWWriteBlock(send_block, 3);
            }
            
            if(ow_result != OneWireMaster::Success)
            {
                comms.printf("MBED: Failed to init sensors\n");
            }
        }
    }
    
    return num_sensors;  
}


//*********************************************************************
uint8_t enumerate_sensors(Serial & comms, OneWireMaster & owm, RandomAccessRomIterator & selector, OWGridEye * array[])
{
    OWGridEye * p_sensor;
    OWGridEye::CmdResult sensor_result;
    
    RomId temp_rom;
    
    uint8_t num_sensors = 0;
    uint8_t num_sensors_old = 0;
    
    uint8_t array_idx = 0;
    
    uint8_t idx;
    
    bool sensor_exists = false;
    
    OneWireMaster::CmdResult ow_result = owm.OWReset();
    SearchState search_state;

    if(ow_result == OneWireMaster::Success)
    {
        do
        {
            num_sensors_old = num_sensors;
            num_sensors = 0;
            
            ow_result = OWFirst(owm, search_state);
            
            while(ow_result == OneWireMaster::Success)
            {
                num_sensors++;
                
                if(search_state.romId.familyCode() == OWGridEye::DS2413_FAMILY_CODE)
                {
                    //check if sensor already exists 
                    sensor_exists = false;
                    for(idx = 0; idx < array_idx; idx++)
                    {
                        p_sensor = array[idx];
                        
                        if(p_sensor->getOWSwitchRomId() == search_state.romId)
                        {
                            sensor_exists = true;
                        }
                    }
                    
                    //if sensor doesn't already exist add to array
                    if(!sensor_exists)
                    {
                        p_sensor = new OWGridEye(selector);
                        
                        p_sensor->setOWSwitchRomId(search_state.romId);
                        
                        sensor_result = p_sensor->connectGridEye();
                        if(sensor_result == OWGridEye::Success)
                        {
                            search_state.findFamily(OWGridEye::DS28E17_FAMILY_CODE);
                            ow_result = OWNext(owm, search_state);
                            if(ow_result == OneWireMaster::Success)
                            {
                                p_sensor->setI2CBridgeRomId(search_state.romId);
                                
                                array[array_idx++] = p_sensor;
                                
                                comms.printf("MBED: DS2413 romId = ");
                                temp_rom =  p_sensor->getOWSwitchRomId();
                                print_rom_id(comms,temp_rom); 
                                comms.printf("MBED: DS28E17 romId = ");
                                temp_rom = p_sensor->getI2CBridgeRomId();
                                print_rom_id(comms, temp_rom); 
                                
                                sensor_result = p_sensor->disconnectGridEye();    
                                if(sensor_result == OWGridEye::OpFailure)
                                {
                                    comms.printf("MBED: Failed to disconnect sensor\n");
                                    mbed_die();
                                }   
                                
                                sensor_result = p_sensor->connectOWbus();    
                                if(sensor_result == OWGridEye::OpFailure)
                                {
                                    comms.printf("MBED: Failed to connect ow branch %d\n", array_idx);
                                    mbed_die();
                                }
                            }
                            else
                            {
                                comms.printf("MBED: Failed to find DS28E17\n", array_idx);
                            }
                        }
                        else
                        {
                            comms.printf("MBED: Failed to connect GridEye\n", array_idx);
                        }
                    }
                }
                
                ow_result = OWNext(owm, search_state);
            }
        }
        while(num_sensors > num_sensors_old);
    }
    
    
    return array_idx;
}


//*********************************************************************
void send_data(Serial & comms, float * data_buffer, float therm_temp)
{
    comms.printf("DATA: ");
    wait_us(1000);
    for(uint8_t idx = 0; idx < 64; idx++)
    {
        comms.printf("%.3f ", data_buffer[idx]);
        wait_us(1000);
        
        if(((idx+1) % 8) == 0)
        {
            comms.printf("\nDATA: ");
            wait_us(1000);
        }
    }                                
    comms.printf("%.3f \n", therm_temp);
    wait_us(1000);
}
