/*******************************************************************************
 * Copyright (C) 2017 Maxim Integrated Products, Inc., All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
 * OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the name of Maxim Integrated
 * Products, Inc. shall not be used except as stated in the Maxim Integrated
 * Products, Inc. Branding Policy.
 *
 * The mere transfer of this software does not imply any licenses
 * of trade secrets, proprietary technology, copyrights, patents,
 * trademarks, maskwork rights, or any other form of intellectual
 * property whatsoever. Maxim Integrated Products, Inc. retains all
 * ownership rights.
 *******************************************************************************
 */
 

#include "mbed.h"
#include "max32630fthr.h"
#include "MAX30205.h"

MAX32630FTHR pegasus(MAX32630FTHR::VIO_3V3);

bool temp_sensor_config(MAX30205 &temp_sensor);

int main()
{
    
    Serial pc(USBTX, USBRX);        // Use USB debug probe for serial link
    pc.baud(115200);                // Baud rate = 115200
        
    DigitalOut rLed(LED1, LED_OFF);     // Debug LEDs
    
    I2C i2cBus(I2C1_SDA, I2C1_SCL);     // I2C bus, P3_4 = SDA, P3_5 = SCL   
    
    MAX30205 temp_sensor(i2cBus, 0x48);         // New MAX30205 on i2cBus
    int rc = temp_sensor_config(temp_sensor);   // Configure sensor, return 0 on success
    
    Timer temp_sensor_sampleTimer;      // Create temp. sensor sample timer 
    temp_sensor_sampleTimer.start();    // Start the timer
    
    MAX30205::Configuration_u temp_cfg;
    temp_cfg.all = 0;  
    uint16_t rawTemperatureRead, temp_conversion_flag;
    float temperature;
    
    while(1) {
        
        if( rc == 0 ) {
        
            // Start a new temperature conversion 
            if ( ( temp_sensor_sampleTimer.read() > 1.0f ) && !temp_conversion_flag && ( rc == 0 ) ) {
                
                temp_cfg.bits.one_shot = 1;
                rc = temp_sensor.writeConfiguration(temp_cfg);     // Send one-shot cmd to begin conversion  
                temp_conversion_flag = 1;                           // Raise flag indicating a conversion has begun
                
            } 
            
            // Read the completed temperature conversion 
            if ( ( temp_sensor_sampleTimer.read() > 1.05f ) && temp_conversion_flag && ( rc == 0 ) ){
                
                temp_conversion_flag = 0;                                   // Lower flag when conversion has completed
                rc = temp_sensor.readTemperature(rawTemperatureRead);      // Read the temperature data
                temperature = temp_sensor.toCelsius(rawTemperatureRead);   // Convert temp data to Celsius
                temp_sensor_sampleTimer.reset();                            // Reset timer 
                
                pc.printf("Temperature is %2.3f deg. C \r\n", temperature);
                  
            }
        
        }else{
            
            pc.printf("Something went wrong, check the I2C bus and power connections... \r\n");

            while(1){
                rLed = !rLed;
                wait(0.5);   
            }
            
        }
    }
}


bool temp_sensor_config(MAX30205 &temp_sensor){
     
    int rc = 0;
    
    MAX30205::Configuration_u temp_cfg;
    temp_cfg.all = 0;
    temp_cfg.bits.shutdown = 1;     // Shutdown mode
    temp_cfg.bits.comp_int = 1;     // Interrupt mode
    temp_cfg.bits.os_polarity = 0;  // Active low OS
    temp_cfg.bits.fault_queue = 1;  // Two faults for OS condition
    temp_cfg.bits.data_format = 0;  // Normal data format
    temp_cfg.bits.timeout = 0;      // I2C timeout reset enabled
    temp_cfg.bits.one_shot = 0;     // Start with one-shot = 0
        
    rc = temp_sensor.writeConfiguration(temp_cfg);  // Write config to MAX30205    
    
    return rc;
} 
