/**********************************************************************
* 
* Demo MAX14661 Library
*
***********************************************************************
* Copyright (C) 2015 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
**********************************************************************/


#include "mbed.h"
#include "max14661.h"


Max14661 mux(D14, D15, Max14661::MAX14661_I2C_ADRS0);


int main(void)
{
    uint16_t bankA = 0;
    uint16_t bankB = mux.SW03;
    uint8_t data[4];
    
    printf("\r\nMAX14661 Library Demo\r\n");
    
    mux.set_switches(bankA, bankB);
    
    mux.rd_dir_registers(data);
    for(uint8_t idx = 0; idx < 4; idx++)
    {
        printf("\r\nDirect Register %d = %d", idx, data[idx]);
    }
    printf("\r\n");
    
    mux.wrt_cmd_registers(mux.DISABLE_BANK, mux.DISABLE_BANK);
    
    mux.rd_dir_registers(data);
    for(uint8_t idx = 0; idx < 4; idx++)
    {
        printf("\r\nDirect Register %d = %d", idx, data[idx]);
    }
    printf("\r\n");
    
    return 0;
}
