/*******************************************************************************
* Copyright (C) 2015 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*
* LEDRemote version 1.0 is a program that listens for ACII characters from a 
* websocket.  If the correct ASCII characters are sent, the onboard LED on 
* a Freescale Freedom board (K64F) will light an LED.  For example, if "R1" or 
* "R2" is received the RED LED gets exercised.  "B1" and "B0" exercises the blue 
* LED, and "G1" and "G0" exercises the green LED.
*
*/

#include "mbed.h"
#include "EthernetInterface.h"
#include "Websocket.h"

DigitalOut ledr(PTB22);
DigitalOut ledg(PTE26);
DigitalOut ledb(PTB21);
//DigitalIn sw(PTA4);

int main() {
    int res;
    char buf[100]={0};
    char comparebuf[2]={0};
    char msg[100];
    ledg = 1;
    ledr = 1;
    ledb = 1;
    bool startup = true;
    int startupmode = 0;
    int startupledcount = 0;

    //bool pb = 1;
    
    //BW_MPU_CESR_VLD(0);// k64f workaround mentioned here (to turn off MPU): https://community.freescale.com/thread/324825
    //wait(1);
    //clock_manager_set_gate(kClockModuleENET,0,true); // turn on clock
    
    printf("\r\n---- Maxim's WebSocket example with the k64f board ----\r\n");
    EthernetInterface eth;
    eth.init();
    eth.connect();
    //wait(1.0);
    printf("IP Address is %s\r\n", eth.getIPAddress());
    wait(1.0);
    
    // Change YOURLOGIN for your mbed login so you can communicate to the board
    // using the mbed websocket at:
    // http://sockets.mbed.org/YOURLOGIN
    //Websocket ws("ws://sockets.mbed.org/ws/brianh/ro"); // over port 80 (html)
    //Websocket ws("ws://sockets.mbed.org:443/ws/brianh/rw"); // secure TLS
    
    //Websocket ws("ws://192.168.1.12:8080/"); // home -- notice forward slash is necessary
    Websocket ws("ws://10.17.245.247:8080/"); // Dallas -- Mbed needs the slash at the end or the websocket won't connect properly without a path
    //Websocket ws("ws://10.33.245.13:8080/"); // California -- Mbed needs the slash at the end or the websocket won't connect properly without a path
    //Websocket ws("ws://dal-lt-BHindman.maxim-ic.internal:8080/"); // laptop
    //wait(1.0);
    
    ws.connect();
    wait(1.0);
     
    //ws.send("st");
    //while (pb)
    while(1) 
    {
        if (ws.is_connected())
        {        
            if (startup) 
            {
               startupledcount++; // count number of loops while websocket is connected
               if (startupledcount > 20)
               {
                  startupledcount = 0;
                  startupmode++;
                  if (startupmode == 1) ws.send("st"); // request server to send state of red led
                  if (startupmode == 2) ws.send("su"); // request server to send state of green led
                  if (startupmode == 3) ws.send("sv"); // request server to send state of blue led
                  if (startupmode == 3) startup = false;
               }     

            }
            //printf("is_connected() is true \r\n");
            // read from websocket the led that should be turned on.  
            if(!ws.read(buf)) 
            {
                //printf("%c",buf[0]);
                // is it red?
                if(buf[0] == 'r') 
                {
                    if(buf[1] == '0') 
                    {
                        ledr = 0;
                        if ((comparebuf[0] != buf[0]) || (comparebuf[1] != buf[1])) printf("Turned red LED on\n\r");
                    } 
                    else 
                    {
                        ledr = 1;
                        if ((comparebuf[0] != buf[0]) || (comparebuf[1] != buf[1])) printf("Turned red LED off\n\r");
                    }
                }
                // is it green?
                if(buf[0] == 'g') 
                {
                    //printf("g! \r\n");
                    if(buf[1] == '0') 
                    {
                        ledg = 0;
                        if ((comparebuf[0] != buf[0]) || (comparebuf[1] != buf[1])) printf("Turned green LED on\n\r");
                    } 
                    else 
                    {
                        ledg = 1;
                        if ((comparebuf[0] != buf[0]) || (comparebuf[1] != buf[1])) printf("Turned green LED off\n\r");
                    }
                }
                // is it blue?
                if(buf[0] == 'b') 
                {
                    if(buf[1] == '0') 
                    {
                        ledb = 0;
                        if ((comparebuf[0] != buf[0]) || (comparebuf[1] != buf[1])) printf("Turned blue LED on\n\r");
                    } 
                    else 
                    {
                        ledb = 1;
                        if ((comparebuf[0] != buf[0]) || (comparebuf[1] != buf[1])) printf("Turned blue LED off\n\r");
                    }
                }
                comparebuf[0] = buf[0];
                comparebuf[1] = buf[1];
                
            }
            //pb = sw; 
        }
        else
        {           
            printf("trying to make websocket connection\n\r");
            ws.close();
            ws.connect();
            //wait(1.0);
        }
    }// end while
    //ws.close();
    //eth.disconnect();
    //ledg = 1;
    //ledr = 1;
    //ledb = 1;
    //while(1) 
    //{
    //}
}
