/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************/

#ifndef MAX44009_HPP
#define MAX44009_HPP

#include <stdint.h>

namespace mbed { class I2C; }

/// Interface to the MAX44009 optical light sensor.
class MAX44009 {
public:
  enum Result { Success, Hardware_Failure };

  /// @param I2C_interface A configured I2C interface to use for communication.
  /// @param I2C_address Device bus address in mbed format.
  MAX44009(mbed::I2C & I2C_interface, uint8_t I2C_address);

  /// Read the current lux from the MAX44009.
  /// @returns Success or Hardware_Failure.
  Result read_current_lux(double & lux) const;

private:
  /// MAX44009 Register addresses.
  enum Register { Lux_High_Byte_Reg = 0x03, Lux_Low_Byte_Reg = 0x04 };

  mbed::I2C & m_I2C_interface;
  uint8_t m_I2C_address;
};

#endif
