/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

#ifndef _COMMON_HPP
#define _COMMON_HPP

#include <string>
#include <stdint.h>
#include <stddef.h>

/// Contains a set of sensor measurements.
struct SensorData
{
  static const int8_t tempAlarmLevel = 26;
  static const uint8_t filterLifeAlarmLevel = 20;
  
  int8_t temp;
  uint8_t filterLife;
  
  bool tempAlarm() const { return (temp >= tempAlarmLevel); }
  bool filterLifeAlarm() const { return (filterLife <= filterLifeAlarmLevel); }
};

/// Characters per byte for hex data.
extern const size_t charsPerByte;

/// Creates a new hex string from a byte array.
std::string byteArrayToHexString(const uint8_t * byteArray, size_t byteArraySize);

/// Appends a hex string created from a byte array to an existing string.
void byteArrayToHexString(const uint8_t * byteArray, size_t byteArraySize, std::string & hexString);

#endif