/*******************************************************************************
* Copyright (C) 2016 Maxim Integrated Products, Inc., All Rights Reserved.
*
* Permission is hereby granted, free of charge, to any person obtaining a
* copy of this software and associated documentation files (the "Software"),
* to deal in the Software without restriction, including without limitation
* the rights to use, copy, modify, merge, publish, distribute, sublicense,
* and/or sell copies of the Software, and to permit persons to whom the
* Software is furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included
* in all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
* OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
* IN NO EVENT SHALL MAXIM INTEGRATED BE LIABLE FOR ANY CLAIM, DAMAGES
* OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
* ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
* OTHER DEALINGS IN THE SOFTWARE.
*
* Except as contained in this notice, the name of Maxim Integrated
* Products, Inc. shall not be used except as stated in the Maxim Integrated
* Products, Inc. Branding Policy.
*
* The mere transfer of this software does not imply any licenses
* of trade secrets, proprietary technology, copyrights, patents,
* trademarks, maskwork rights, or any other form of intellectual
* property whatsoever. Maxim Integrated Products, Inc. retains all
* ownership rights.
*******************************************************************************
*/

#include "MAX44009.hpp"
#include "I2C.h"

static const int I2C_OK = 0;

MAX44009::MAX44009(mbed::I2C & I2C_interface, uint8_t I2C_address)
  : m_I2C_interface(I2C_interface), m_I2C_address(I2C_address)
{
  
}

MAX44009::Result MAX44009::read_current_lux(double & lux) const
{
  uint8_t I2C_data, mantissa, exponent;
  
  I2C_data = Lux_High_Byte_Reg;
  if (m_I2C_interface.write(m_I2C_address, reinterpret_cast<char *>(&I2C_data), 1, true) != I2C_OK)
  {
    m_I2C_interface.stop();
    return Hardware_Failure;
  }
  if (m_I2C_interface.read(m_I2C_address, reinterpret_cast<char *>(&I2C_data), 1, true) != I2C_OK)
  {
    m_I2C_interface.stop();
    return Hardware_Failure;
  }
  mantissa = (I2C_data << 4);
  exponent = (I2C_data >> 4);
  
  I2C_data = Lux_Low_Byte_Reg;
  if (m_I2C_interface.write(m_I2C_address, reinterpret_cast<char *>(&I2C_data), 1, true) != I2C_OK)
  {
    m_I2C_interface.stop();
    return Hardware_Failure;
  }
  if (m_I2C_interface.read(m_I2C_address, reinterpret_cast<char *>(&I2C_data), 1, false) != I2C_OK)
  {
    m_I2C_interface.stop();
    return Hardware_Failure;
  }
  mantissa |= (I2C_data & 0x0F);
  
  unsigned long calc_result = 1;
  if (exponent > 0)
  {
    calc_result <<= exponent;
  }
  calc_result *= mantissa;
  lux = calc_result * 0.045;
  
  return Success;
}