/*
 / _____)             _              | |
( (____  _____ ____ _| |_ _____  ____| |__
 \____ \| ___ |    (_   _) ___ |/ ___)  _ \
 _____) ) ____| | | || |_| ____( (___| | | |
(______/|_____)_|_|_| \__)_____)\____)_| |_|
    (C)2015 Semtech

Description: End device commissioning parameters

License: Revised BSD License, see LICENSE.TXT file include in the project

Maintainer: Miguel Luis and Gregory Cristian
*/
#ifndef __LORA_COMMISSIONING_H__
#define __LORA_COMMISSIONING_H__


/*!
 * When set to 1 the application uses the Over-the-Air activation procedure
 * When set to 0 the application uses the Personalization activation procedure
 */
#define OVER_THE_AIR_ACTIVATION                     0
/************************************************************************/
/****************  Configuration for ABP Activation *********************/
/************************************************************************/
/*!
 * Indicates if the end-device is to be connected to a private or public network
 */
#define LORAWAN_PUBLIC_NETWORK                      true

/*!
 * Application IEEE EUI (big endian)
 */
#define LORAWAN_APPLICATION_EUI                     { 0x70, 0xB3, 0xD5, 0x7E, 0xD0, 0x00, 0xA7, 0x97 }

/*!
 * AES encryption/decryption cipher network session key
 */
#define LORAWAN_NWKSKEY                             { 0x84, 0xA9, 0x6F, 0xE7, 0x2D, 0x4D, 0x31, 0xFC, 0x01, 0x50, 0xD4, 0x4B, 0x7A, 0xB1, 0xFC, 0x01 }
/*!
 * AES encryption/decryption cipher application session key
 */
#define LORAWAN_APPSKEY                           { 0xCC, 0xAB, 0xE8, 0x66, 0x38, 0xCF, 0x39, 0x76, 0x39, 0x9A, 0xF8, 0x6D, 0x58, 0x76, 0x87, 0x01 }

/*!
 * Device address on the network (big endian)
 */
#define LORAWAN_DEVICE_ADDRESS                      ( uint32_t )0x26011759
/************************************************************************/
/*************** End Configuration for APB Activation  ******************/
/************************************************************************/


/*!
 * IEEE Organizationally Unique Identifier ( OUI ) (big endian)
 * \remark This is unique to a company or organization
 */
#define IEEE_OUI                                    0x11, 0x22, 0x33

/*!
 * Mote device IEEE EUI (big endian)
 */
#define LORAWAN_DEVICE_EUI                          { 0x00, 0x9A, 0xD1, 0x8B, 0x92, 0x7C, 0xF1, 0x6F }

/*!
 * AES encryption/decryption cipher application key
 */
#define LORAWAN_APPLICATION_KEY                     { 0x2B, 0x7E, 0x15, 0x16, 0x28, 0xAE, 0xD2, 0xA6, 0xAB, 0xF7, 0x15, 0x88, 0x09, 0xCF, 0x4F, 0x3C }

/*!
 * Current network ID
 */
#define LORAWAN_NETWORK_ID                          ( uint32_t )0

#endif // __LORA_COMMISSIONING_H__


/************************************************************************/
/******************* ABP Configuration For Devices STM32 ****************/
/************************************************************************/



/* stm32lorawan_3
#define LORAWAN_APPLICATION_EUI    { 0x70, 0xB3, 0xD5, 0x7E, 0xD0, 0x00, 0xA7, 0x97 }
#define LORAWAN_NWKSKEY            { 0xC2, 0x2E, 0x85, 0x89, 0xC8, 0xF4, 0x87, 0xEE, 0x7D, 0x14, 0x42, 0xDA, 0x5F, 0xAF, 0x8B, 0x18 }
#define LORAWAN_APPSKEY            { 0xEB, 0x7B, 0xBD, 0xA9, 0xB6, 0x94, 0x28, 0x8F, 0x10, 0x1F, 0xD4, 0x8F, 0x2F, 0xBB, 0xDD, 0x61 }
#define LORAWAN_DEVICE_ADDRESS     ( uint32_t )0x2601135C
 In main.cpp : AppData[0] = 0x03;
*/

/* stm32lorawan_13
#define LORAWAN_APPLICATION_EUI    { 0x70, 0xB3, 0xD5, 0x7E, 0xD0, 0x00, 0xA7, 0x97 }
#define LORAWAN_NWKSKEY            { 0x5D, 0xF1, 0x0D, 0xF1, 0x61, 0x43, 0x19, 0xA2, 0x59, 0xA8, 0x5F, 0xDC, 0xAE, 0xBA, 0x8E, 0xA5 }
#define LORAWAN_APPSKEY            { 0x6B, 0x59, 0x42, 0x77, 0x8F, 0xCE, 0xC6, 0x7D, 0x44, 0x6A, 0x47, 0xF1, 0x10, 0x6F, 0x78, 0x1B }
#define LORAWAN_DEVICE_ADDRESS     ( uint32_t )0x260112D6
 In main.cpp : AppData[0] = 0x13;
*/

/* stm32lorawan_14
#define LORAWAN_APPLICATION_EUI    { 0x70, 0xB3, 0xD5, 0x7E, 0xD0, 0x00, 0xA7, 0x97 }
#define LORAWAN_NWKSKEY            { 0x84, 0xA9, 0x6F, 0xE7, 0x2D, 0x4D, 0x31, 0xFC, 0x01, 0x50, 0xD4, 0x4B, 0x7A, 0xB1, 0xFC, 0x01 }
#define LORAWAN_APPSKEY            { 0xCC, 0xAB, 0xE8, 0x66, 0x38, 0xCF, 0x39, 0x76, 0x39, 0x9A, 0xF8, 0x6D, 0x58, 0x76, 0x87, 0x01 }
#define LORAWAN_DEVICE_ADDRESS     ( uint32_t )0x26011759
 In main.cpp : AppData[0] = 0x14;
*/

/* stm32lorawan_4
#define LORAWAN_APPLICATION_EUI    { 0x70, 0xB3, 0xD5, 0x7E, 0xD0, 0x00, 0xA7, 0x97 }
#define LORAWAN_NWKSKEY            { 0x57, 0x58, 0x8C, 0xB0, 0x06, 0x05, 0x94, 0x31, 0x71, 0xD5, 0x54, 0xC2, 0x4B, 0x13, 0x8D, 0x4A }
#define LORAWAN_APPSKEY            { 0x81, 0xD2, 0xFE, 0x5D, 0x38, 0xC7, 0x85, 0x43, 0xEE, 0x7E, 0x89, 0xA8, 0x64, 0xC7, 0x8C, 0xB9 }
#define LORAWAN_DEVICE_ADDRESS     ( uint32_t )0x260112C2
 In main.cpp : AppData[0] = 0x04;
*/

/* stm32lorawan_10
#define LORAWAN_APPLICATION_EUI    { 0x70, 0xB3, 0xD5, 0x7E, 0xD0, 0x00, 0xA7, 0x97 }
#define LORAWAN_NWKSKEY            { 0x20, 0x69, 0x01, 0x5E, 0xDA, 0x86, 0x7F, 0xB3, 0x6D, 0xAF, 0x6F, 0x82, 0xFA, 0x7D, 0xD6, 0x3D }
#define LORAWAN_APPSKEY            { 0xB4, 0x1D, 0x3F, 0x53, 0x8A, 0x51, 0x2B, 0x82, 0x2A, 0x3E, 0x39, 0x82, 0x7E, 0xD2, 0x20, 0x0D }
#define LORAWAN_DEVICE_ADDRESS     ( uint32_t )0x26011C9A
 In main.cpp : AppData[0] = 0x10;
 */

/* stm32lorawan_1
#define LORAWAN_APPLICATION_EUI    { 0x70, 0xB3, 0xD5, 0x7E, 0xD0, 0x00, 0xA7, 0x97 }
#define LORAWAN_NWKSKEY            { 0xE3, 0xD9, 0x0A, 0xFB, 0xC3, 0x6A, 0xD4, 0x79, 0x55, 0x2E, 0xFE, 0xA2, 0xCD, 0xA9, 0x37, 0xB9 }
#define LORAWAN_APPSKEY            { 0xF0, 0xBC, 0x25, 0xE9, 0xE5, 0x54, 0xB9, 0x64, 0x6F, 0x20, 0x8E, 0x1A, 0x8E, 0x3C, 0x7B, 0x24 }
#define LORAWAN_DEVICE_ADDRESS     ( uint32_t )0x26011AD3
 In main.cpp : AppData[0] = 0x01;
*/

/* stm32lorawan_11
#define LORAWAN_APPLICATION_EUI    { 0x70, 0xB3, 0xD5, 0x7E, 0xD0, 0x00, 0xA7, 0x97 }
#define LORAWAN_NWKSKEY            { 0x64, 0x3F, 0x24, 0x5D, 0xBF, 0xEC, 0x8E, 0x4D, 0x7D, 0xA0, 0x1F, 0xF2, 0xE3, 0x34, 0x06, 0xE3 }
#define LORAWAN_APPSKEY            { 0x15, 0xA9, 0x8F, 0xB4, 0x72, 0x05, 0x26, 0x45, 0xE7, 0x27, 0x89, 0x3B, 0x74, 0x22, 0x29, 0x9B }
#define LORAWAN_DEVICE_ADDRESS     ( uint32_t )0x26011A70
 In main.cpp : AppData[0] = 0x11;
*/

