
 #include "mbed.h"
 #include "MFRC522.h"


 #define SPI_MOSI    D4
 #define SPI_MISO    D5
 #define SPI_SCLK    D6//SCK
 #define SPI_CS      D3//SDA
// KL25Z Pin for MFRC522 reset
 #define MF_RESET    D2//Rst pini

 MFRC522    RfChip   (SPI_MOSI, SPI_MISO, SPI_SCLK, SPI_CS, MF_RESET);

 int main(void) {


   // Init. RC522 Chip
   RfChip.PCD_Init();

   while (true) {


     // Look for new cards
     if ( ! RfChip.PICC_IsNewCardPresent())
     {
       wait_ms(500);
       continue;
     }


     // Select one of the cards
     if ( ! RfChip.PICC_ReadCardSerial())
     {
       wait_ms(500);
       continue;
     }

     // Print Card UID
     printf("Card UID: ");
     for (uint8_t i = 0; i < RfChip.uid.size; i++)
     {
       printf(" %X ", RfChip.uid.uidByte[i]);//Hex kodunu verir
     }
     printf("\n\r");

     // Print Card type
     uint8_t piccType = RfChip.PICC_GetType(RfChip.uid.sak);
     printf("PICC Type: %s \n\r", RfChip.PICC_GetTypeName(piccType));
   }
 }
